
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-docking-layout",class extends Smart.ContentElement{static get properties(){return{autoLoadState:{value:!1,type:"boolean"},autoSaveState:{value:!1,type:"boolean"},draggable:{value:!0,type:"boolean"},floatable:{value:!0,type:"boolean"},hideSplitterBars:{value:!1,type:"boolean"},layout:{value:[],type:"array",reflectToAttribute:!1},liveResize:{value:!1,type:"boolean"},messages:{value:{en:{invalidNode:'{{elementType}}: "{{method}}" method accepts an instance of Smart.TabsWindow',invalidNodeRemove:'{{elementType}}: "{{method}}" method accepts an instance of Smart.TabsWindow that is a child of the DockingLayout.',invalidNodeType:'{{elementType}}: The method "{{method}}" requires a "smart-tabs-window" element to be passed as an argument.',invalidTargetNode:'{{elementType}}: The method "{{method}}" requires an index of an item that is not hidden/closed. Only visible items that are part of the Layout are valid.',invalidIndex:'{{elementType}}: "{{method}}" method accepts an index of type number.',noId:"smartDockingLayout requires an id in order to save/load a state."}},type:"object",extend:!0},resizeStep:{value:5,type:"number"},snapMode:{value:"advanced",allowedValues:["simple","advanced"],type:"string"}}}static get listeners(){return{"autoHideWindow.close":"_autoHideWindowCloseHandler","autoHideWindow.resizeEnd":"_autoHideWindowResizeEndHandler","container.dock":"_dockEventHandler",move:"_moveHandler","document.down":"_documentDownHandler","document.move":"_documentMoveHandler","document.up":"_documentUpHandler","document.selectstart":"_documentSelectStartHandler","document.dragstart":"_documentDragStartHandler","container.tabStripResize":"_containerTabStripResizeHandler","horizontalHiddenItemsContainer.resize":"_resizeHandler","itemsContainer.close":"_itemsContainerCloseHandler","itemsContainer.autoHide":"_itemsContainerAutoHideHandler","itemsContainer.resizeEnd":"_itemsContainerResizeHandler",keydown:"_keyDownHandler",keyup:"_keyUpHandler",mouseleave:"_mouseLeaveHandler"}}static get styleUrls(){return["smart.dockinglayout.css"]}template(){return'<div id="container" role="presentation">\n                    <smart-splitter id="horizontalHiddenItemsContainer" class="smart-horizontal-hidden-items-container" orientation="horizontal">\n                        <smart-splitter-item class="smart-docking-layout-item-holder">\n                            <smart-splitter id="verticalHiddenItemsContainer" class="smart-vertical-hidden-items-container">\n                                <smart-splitter-item class="smart-docking-layout-item-holder">\n                                    <smart-splitter id="itemsContainer" class="smart-items-container">\n                                        <content></content>\n                                        <smart-splitter-item id="placeholderItem" class="smart-placeholder" pinned>\n                                            <smart-tabs-window tab-position="hidden" opened header-buttons=\'[]\'>\n                                                <smart-tab-item></smart-tab-item>\n                                            </smart-tabs-window>\n                                        </smart-splitter-item>\n                                    </smart-splitter>\n                                </smart-splitter-item>\n                            </smart-splitter>\n                        </smart-splitter-item>\n                    </smart-splitter>\n                    <smart-tabs-window id="tabsWindowFeedback" class="smart-tabs-window-feedback smart-hidden"></smart-tabs-window>\n                    <smart-tabs-window id="autoHideWindow" class="smart-docking-layout-auto-hide-window" pinned header-buttons=\'["close", "dock"]\'\n                        right-to-left="[[rightToLeft]]" tab-position="hidden">\n                            <smart-tab-item></smart-tab-item>\n                    </smart-tabs-window>\n                </div>'}propertyChangedHandler(e,t,i){const a=this;switch(e){case"autoSaveState":a._handleAutoSave();break;case"layout":a._handleLayout();break;case"liveResize":case"resizeStep":{const t=a.getElementsByTagName("smart-splitter");for(let a=0;a<t.length;a++)t[a][e]=i;"liveResize"===e&&(a.$.autoHideWindow[e]=i);break}case"snapMode":a._handleSnapping(),a._snapFeedback=void 0;break;case"hideSplitterBars":a._setSplitterBarVisibility();break;case"rightToLeft":case"theme":a._items&&a._items.forEach((t=>t[e]=i));break;default:super.propertyChangedHandler(e,t,i)}}ready(){super.ready()}render(){const e=this;if(e.setAttribute("role","group"),e.autoLoadState){const t=e.loadState();t&&(e.layout=t)}e.$.itemsContainer.liveResize=e.liveResize,e.$.itemsContainer.resizeStep=e.resizeStep,e._handleLayout(),e.$tabsWindowFeedback.removeClass("smart-hidden"),e._setFocusable(),e.checkLicense(),super.render()}static get requires(){return{"Smart.TabsWindow":"smart.window.js","Smart.Splitter":"smart.splitter.js"}}appendChild(e){const t=this;if(!t.isCompleted){const e=Array.prototype.slice.call(arguments,2);return HTMLElement.prototype.appendChild.apply(t,e.concat(Array.prototype.slice.call(arguments)))}e?e instanceof Smart.TabsWindow?t.insertBefore(e,null):t.error(t.localize("invalidNodeType",{elementType:t.nodeName.toLowerCase(),method:"appendChild"})):t.error(t.localize("invalidNode",{elementType:t.nodeName.toLowerCase(),method:"appendChild"}))}autoHideBottom(e){this._autoHide(e,"bottom")}autoHideLeft(e){this._autoHide(e,"left")}autoHideRight(e){this._autoHide(e,"right")}autoHideTop(e){this._autoHide(e,"top")}clearState(){const e=this;e.id?window.localStorage.removeItem("smartDockingLayout"+e.id):e.warn(e.localize("noId"))}dock(e){this._dock(e)}undock(e){const t=this;if("number"==typeof e?e=t._items[e]:"string"==typeof e&&(e=t._getItemById(e)),!e)return;if(!(t.shadowRoot||t).contains(e)&&t._getClosestDockingLayout(e)!==t)return;const i=e.getRootNode()&&e.getRootNode().host?e.getRootNode().host:void 0,a=e.closest("smart-splitter-item")||(i?i.closest("smart-splitter-item"):void 0);if(!a)return;const o=a.getBoundingClientRect();let s;if(e instanceof Smart.TabsWindow){e.autoHide?(t.$.autoHideWindow.close(),e._autoHideWindow&&(e.style.width=e._autoHideWindow.offsetWidth+"px",e.style.height=e._autoHideWindow.offsetHeight+"px"),"left"===e.tabPosition||"right"===e.tabPosition?e.style.height=t.offsetHeight+"px":e.style.width=t.offsetWidth+"px"):(e.style.width=e.offsetWidth+"px",e.style.height=e.offsetHeight+"px"),e.windowParent="body",e.opened=!0,e.autoHide&&(e.tabPosition="top"),e.autoHide=e.allowToggle=e.pinned=!1,e.style.maxWidth=e.style.maxHeight="",s=e;const i=a.closest("smart-splitter");i.removeChild(a),t._removeUnneccessaryItems(i)}else{if(!(e instanceof Smart.TabItem))return;{const o=e.closest("smart-tabs-window")||(i?i.closest("smart-tabs-window"):void 0);let n;1===o.items.length?(n=o,a.closest("smart-splitter").removeChild(a)):(n=t._createTabsWindowFromObject({label:e.label}),o.removeChild(e),n.appendChild(e)),"body"!==n.windowParent&&(n.windowParent="body"),n.parentElement!==t.getShadowRootOrBody()&&(t.getShadowRootOrBody().appendChild(n),t._ownTabWindow(n)),n.allowToggle=n.autoHide=n.pinned=!1,n.label=e.label,n.opened=!0,n._parentInfo={closestItem:o,position:e.index},s=n,e=o}}e._originalTabPosition?s.tabPosition=e._originalTabPosition:e.autoHide&&(s.tabPosition="top"),s.tabTextOrientation=e._originalTextOrientation||"horizontal",s===e&&(delete s._originalTabPosition,delete s._originalTextOrientation),t._setFloatingItemsHeaderButtons(s),s.style.left=o.left+"px",s.style.top=o.top+"px",s.resizeMode="both";const n=t._items.indexOf(e);if(s.layout=t,n>-1&&(t._items.splice(n,1),s.position&&(s.style.top=s.position.top,s.style.left=s.position.left,delete s.position)),0!==t._items.filter((e=>e.opened)).length||t.$.placeholderItem.parentElement||t.$.itemsContainer.appendChild(t.$.placeholderItem),t._validateWindowPosition(s),t._setAutoHidePaddings(),t._noStateChangeFiring||(t._handleAutoSave(),t.$.fireEvent("stateChange",{type:"float",item:s})),document.activeElement!==s){const e=document.scrollingElement||document.documentElement,t=e.scrollLeft,i=e.scrollTop;s.focus(),s.bringToFront(),window.scrollTo(t,i)}return s}insertBefore(e,t,i){const a=this;if(!a.isCompleted){const e=Array.prototype.slice.call(arguments,2);return HTMLElement.prototype.insertBefore.apply(a,e.concat(Array.prototype.slice.call(arguments)))}let o,s=e;if(s instanceof Smart.TabsWindow?((e=document.createElement("smart-splitter-item")).size=s.size||"",e.max=s.max||"",e.min=s.min||"",e.locked=s.locked||!1,e.collapsible=s.collapsible||!1,e.collapsed=s.collapsed||!1,e.appendChild(s)):s instanceof Smart.SplitterItem?s=s.querySelector("smart-tabs-window"):a.error(a.localize("invalidNodeType",{elementType:a.nodeName.toLowerCase(),method:"insertBefore"})),s.opened=s.pinned=!0,s.style.width=s.style.height="",s.style.top=s.style.left="",s.style.paddingTop=s.style.paddingBottom="",s.style.paddingLeft=s.style.paddingRight="",e.style.top=e.style.left="",a._items.indexOf(s)>-1&&a._items.splice(a._items.indexOf(s),1),t){if(o=t.closest("smart-splitter"),o===a.$.verticalHiddenItemsContainer||o===a.$.horizontalHiddenItemsContainer?(o=a.$.itemsContainer,t=0===a._items.length?null:"top"===t.tabPosition||"left"===t.tabPosition?a._items[0]:a._items[a._items.length-1]):i&&(o=a.$.itemsContainer),!(t instanceof Smart.TabsWindow))return void a.error(a.localize("invalidNodeType",{elementType:a.nodeName.toLowerCase(),method:"insertBefore"}));o.autoFitMode="proportional",o.insertBefore(e,o._items.filter((e=>e.contains(t)))[0]),a._items.splice(a._items.indexOf(t),0,s)}else o=a.$.itemsContainer,a._dockingAutoHideTabItem&&(o.autoFitMode="end"),a._items.push(s),a.$.itemsContainer.insertBefore(e);if(o.autoFitMode="proportional",s.autoHide)a._autoHide(s,s.autoHidePosition);else{s.autoHide=s.allowToggle=!1,s._originalTabPosition&&(s.tabPosition=s._originalTabPosition,delete s._originalTabPosition),s._originalTextOrientation&&(s.tabTextOrientation=s._originalTextOrientation,delete s._originalTextOrientation),a._setDockedItemsHeaderButtons(s);const e=document.scrollingElement||document.documentElement,t=e.scrollLeft,i=e.scrollTop;s.focus(),window.scrollTo(t,i)}a._items.filter((e=>e.opened)).length>0&&a.$.placeholderItem.parentElement&&a.$.itemsContainer.removeChild(a.$.placeholderItem),s.layout=a,s.minimized=!1,s.maximized=!1,s.locked=!1,s.resizeMode="none",a._handleAutoHiddenSplitterBars(),a._setSplitterBarVisibility(),a._handleAutoSave(),a.$.fireEvent("stateChange",{type:"dock",item:s})}insertBeforeItem(e,t){this._insert(e,t,"top","insertBeforeItem")}insertAfterItem(e,t){this._insert(e,t,"bottom","insertAfterItem")}insertIntoLeft(e,t){this._insert(e,t,"inside-left","insertIntoLeft")}insertIntoRight(e,t){this._insert(e,t,"inside-right","insertIntoRight")}insertIntoTop(e,t){this._insert(e,t,"inside-top","insertIntoTop")}insertIntoBottom(e,t){this._insert(e,t,"inside-bottom","insertIntoBottom")}insertLayoutTop(e){this._insert(0,e,"layout-top","insertLayoutTop")}insertLayoutBottom(e){this._insert(0,e,"layout-bottom","insertLayoutBottom")}insertLayoutLeft(e){this._insert(0,e,"layout-left","insertLayoutLeft")}insertLayoutRight(e){this._insert(0,e,"layout-right","insertLayoutRight")}insertOutsideTargetGroupTop(e,t){this._insert(e,t,"outside-top","insertOutsideTargetGroupTop")}insertOutsideTargetGroupBottom(e,t){this._insert(e,t,"outside-bottom","insertOutsideTargetGroupBottom")}insertOutsideTargetGroupLeft(e,t){this._insert(e,t,"outside-left","insertOutsideTargetGroupLeft")}insertFloatingWindow(e,t,i){if(!e)return;let a="tabsWindow_"+Math.floor(65536*(1+Math.random())).toString(16).substring(1);e.id?a=e.id:e.id=a,this._insert(0,e);const o=this.undock(a);o&&(void 0!==t&&(o.style.left="number"==typeof t?t+"px":t),void 0!==i&&(o.style.top="number"==typeof i?i+"px":i))}insertOutsideTargetGroupRight(e,t){this._insert(e,t,"outside-right","insertOutsideTargetGroupRight")}getAutoHideItems(e){const t=this;function i(e){let t=[];if(!e._items)return t;for(let i=0;i<e._items.length;i++)e._items[i].$.hasClass("smart-docking-layout-item-holder")||t.push(e._items[i].getElementsByTagName("smart-tabs-window")[0]);return t}return e?i("horizontal"===e?t.$.horizontalHiddenItemsContainer:t.$.verticalHiddenItemsContainer):i(t.$.horizontalHiddenItemsContainer).concat(i(t.$.verticalHiddenItemsContainer))}getIndex(e){const t=this;if(t.isReady&&t._items.length)return t._items.indexOf(e)}get autoHideItems(){return this.isReady?this.getAutoHideItems():[]}get items(){const e=this;return e.isReady?e._items.filter((e=>e.opened)).concat(e.getAutoHideItems()):[]}get closedItems(){return this.isReady?this._items.filter((e=>!e.opened)):[]}get undockedItems(){const e=this;if(!e.isReady)return[];const t=document.getElementsByTagName("smart-tabs-window");let i=[];for(let a=0;a<t.length;a++)t[a].closest("smart-docking-layout")||e._getClosestDockingLayout(t[a])||t[a].layout!==e||(t[a].undocked=!0,i.push(t[a]));return i}getItemGroupElement(e){const t=this;if(t.isReady&&e&&e instanceof Smart.TabsWindow&&(t.shadowRoot||t).contains(e))return e.closest("smart-splitter")}getState(e){const t=this,i=t.getAutoHideItems(),a=t.undockedItems,o=[];for(let a=0;a<i.length;a++)o.push(t._createTabsWindowStructure(i[a],e));for(let i=0;i<a.length;i++)o.push(t._createTabsWindowStructure(a[i],e));return[{type:"LayoutGroup",items:o.concat(t._createLayoutStructure(t.$.itemsContainer,e)),orientation:t.$.itemsContainer.orientation}]}getClosestSplitterBars(e){const t=this;if(!t._items||!t._items.length)return;if("string"==typeof e?e=t._getItemById(e):"number"==typeof e&&(e=t._items[parseInt(e)]),!(e instanceof Smart.TabsWindow&&t._items.find((t=>t===e))))return;let i=e.closest("smart-splitter");for(;i&&!i.bars.length;)i=i.closest("smart-splitter");return i?i.bars:void 0}getJSONStructure(){return this.getState(!0)}loadState(e){const t=this;if(!e){if(!t.id)return void t.warn(t.localize("noId"));e=JSON.parse(window.localStorage.getItem("smartDockingLayout"+t.id))}if(e)return t._loadState(e),e}removeAt(e){const t=this;"number"==typeof e?e=t._items[e]:"string"==typeof e&&(e=t._getItemById(e)),e instanceof Smart.TabsWindow?e.closest("smart-docking-layout")===t||t._getClosestDockingLayout(e)===t?t.removeChild(e):t.error(t.localize("invalidNodeRemove",{elementType:t.nodeName.toLowerCase(),method:"remove"})):t.error(t.localize("invalidIndex",{elementType:t.nodeName.toLowerCase(),method:"remove"}))}removeAll(){this._removeAll()}removeChild(e){const t=this;if(!e)return void t.error(t.localize("invalidNode",{elementType:t.nodeName.toLowerCase(),method:"removeChild"}));if(!(e instanceof Smart.TabsWindow))return void t.error(t.localize("invalidNodeType",{elementType:t.nodeName.toLowerCase(),method:"removeChild"}));if(!t.isCompleted){const e=Array.prototype.slice.call(arguments,2);return HTMLElement.prototype.removeChild.apply(t,e.concat(Array.prototype.slice.call(arguments)))}const i=e.closest("smart-splitter-item");if(!i)return;const a=i.closest("smart-splitter");a&&(i.closest("smart-splitter").removeChild(i),t._items.splice(t._items.indexOf(e),1),t._removeUnneccessaryItems(a),0!==t._items.filter((e=>e.opened)).length||t.$.placeholderItem.parentElement||t.$.itemsContainer.appendChild(t.$.placeholderItem),e.layout=t,t._handleAutoSave(),t.$.fireEvent("stateChange",{type:"remove",item:e}))}saveState(){const e=this;e.id?window.localStorage.setItem("smartDockingLayout"+e.id,JSON.stringify(e.getJSONStructure())):e.warn(e.localize("noId"))}update(e,t){const i=this;if("number"==typeof e?e=i._items[parseInt(e)]:"string"==typeof e&&(e=i._getItemById(e)),!(e&&e instanceof Smart.TabsWindow))return void i.error(i.localize("invalidNodeType",{elementType:i.nodeName.toLowerCase(),method:"update"}));if(!(i.shadowRoot||i).contains(e)&&i._getClosestDockingLayout(e)!==i)return;if(!t||"object"!=typeof t)return;if(t.items)for(let i=0;i<t.items.length;i++){const a=t.items[i].index;"number"!=typeof a||isNaN(a)||(e.items&&!e.items[a]?e.insert(a,t.items[i]):e.update(t.items[i].index,t.items[i].label,t.items[i].content))}t.id&&(e.id=t.id),t.label&&(e.label=t.label),e.tabCloseButtons=t.tabCloseButtons||!1,t.headerButtons&&Array.isArray(t.headerButtons)&&(e.headerButtons=0===t.headerButtons.length?["close","autoHide"]:t.headerButtons);const a=e.closest("smart-splitter-item");a&&(e.autoHide?i._autoHide(e):(a.size=void 0!==t.size?t.size:a.size,a.min=void 0!==t.min?t.min:a.min,a.max=void 0!==t.max?t.max:a.max,a.locked=void 0!==t.locked?t.locked:a.locked,a.collapsible=void 0!==t.collapsible?t.collapsible:a.collapsible,a.collapsed=void 0!==t.collapsed?t.collapsed:a.collapsed))}_autoHide(e,t){const i=this;if("number"==typeof e?e=i._items[e]:"string"==typeof e&&(e=i._getItemById(e)),!e)return;if(e instanceof Smart.TabItem){const a=e.closest("smart-tabs-window")||(e.getRootNode()&&e.getRootNode().host?e.getRootNode().host.closest("smart-tabs-window"):void 0);if(a&&a.items.length<2)e=a;else{const o=e;if(a){if(a.autoHide&&a.tabPosition===t)return;a.removeChild(e)}(e=i._createTabsWindowFromObject({label:e.label})).appendChild(o)}}if(!(e instanceof Smart.TabsWindow))return void i.error(i.localize("invalidNodeType",{elementType:i.nodeName.toLowerCase(),method:"appendChild"}));let a,o=e.closest("smart-splitter-item");const s=e.closest("smart-splitter")||(e.isInShadowDOM?e.getRootNode().host:void 0)||i.$.itemsContainer,n=i._getAutoHidePositionDetails(t,e,o),d=n.autoHideSplitter;t=n.position,e.offsetHeight&&(a="left"===t||"right"===t?e.offsetWidth:e.offsetHeight),o||(o=document.createElement("smart-splitter-item"),o.appendChild(e)),o.min=30;const l="auto-hide-"+t;if(e.autoHide&&o.$.hasClass(l))return;const r=i._items.indexOf(e);i._items.splice(r,r>-1?1:0),0!==i._items.filter((e=>e.opened)).length||i.$.placeholderItem.parentElement||("left"===t?i.$.itemsContainer.insert(1,i.$.placeholderItem):i.$.itemsContainer.appendChild(i.$.placeholderItem)),i._handleAutoHideWindow({position:t,tabsWindow:e,splitterItem:o,autoHideName:l,splitterContainer:s,autoHideSplitter:d}),d.bars.map((e=>e.hide())),(!i.shadowRoot||i.shadowRoot&&i.isCompleted)&&i._setAutoHidePaddings();const m=e.items;if(m)for(let e=0;e<m.length;e++)m[e]._autoHideWindowSize||(m[e]._autoHideWindowSize=a);i.$.autoHideWindow.opened&&i.$.autoHideWindow._tabsWindow&&i.$.autoHideWindow._tabsWindow._setAutoHideWindowSize(i.$.autoHideWindow._tabsWindow.selectedIndex),i.isCompleted&&(i._handleAutoSave(),i.$.fireEvent("stateChange",{type:"autoHide",item:e}),i.shadowRoot&&setTimeout((function(){"top"===t||"bottom"===t?(i.$.horizontalHiddenItemsContainer.items.filter((e=>e.className.indexOf("auto-hide-")>-1)).forEach((e=>{const t=e.querySelector("smart-tabs-window");e.style.height="",t.refreshTabs()})),i.$.horizontalHiddenItemsContainer.refresh()):(i.$.verticalHiddenItemsContainer.items.filter((e=>e.className.indexOf("auto-hide-")>-1)).forEach((e=>{const t=e.querySelector("smart-tabs-window");e.style.width="",t.refreshTabs()})),i.$.verticalHiddenItemsContainer.refresh()),i._setAutoHidePaddings()}),150))}_moveHandler(e){this.hasAttribute("dragged")&&"touchmove"===e.originalEvent.type&&e.originalEvent.preventDefault()}_getAutoHidePositionDetails(e,t,i){const a=this,o=t.closest("smart-splitter")||a.$.itemsContainer,s=o?o._items.indexOf(i):0;let n;switch(e){case"top":case"bottom":n=a.$.horizontalHiddenItemsContainer;break;case"left":case"right":n=a.$.verticalHiddenItemsContainer;break;default:if("vertical"===o.orientation){n=a.$.verticalHiddenItemsContainer;const t=n.items.filter((e=>e.className.indexOf("auto-hide-")>-1));e=1===t.length&&1===a._items.length?t[0].$.hasClass("auto-hide-right")?"right":"left":s>=o.items.length/2?"right":"left"}else{n=a.$.horizontalHiddenItemsContainer;const t=n.items.filter((e=>e.className.indexOf("auto-hide-")>-1));e=1===t.length&&1===a._items.length?t[0].$.hasClass("auto-hide-bottom")?"bottom":"top":s>=o.items.length/2?"bottom":"top"}}return{autoHideSplitter:n,position:e}}_handleAutoHideWindow(e){const t=this,i=e.autoHideName,a=e.splitterItem,o=e.splitterContainer,s=e.position,n=e.autoHideSplitter;let d=e.tabsWindow,l=(t.shadowRoot||t).querySelector("."+i),r="offset"+("left"===s||"right"===s?"Width":"Height");if(d.locked=!1,l){const e=[].slice.call(d.isCompleted?d.items:d.children),i=l.querySelector("smart-tabs-window"),s=i.items.length;for(let t=0;t<e.length;t++)i.insert(s,{node:e[t]}),e[t]._autoHideWindowSize=d[r];a.parentElement&&o.removeChild(a),t._removeUnneccessaryItems(o),d=i}else{o&&o.contains(a)&&o.removeChild(a),!t._initializingItems&&d.autoHide||(d._originalTabPosition=d.tabPosition,d._originalTextOrientation=d.tabTextOrientation,d._originalLocked=d.locked),d.autoHideWindow=t.$.autoHideWindow,d.autoHide=d.allowToggle=!0,d.selectedIndex=null,d.$.tabsElement&&d.$.tabsElement.selectedIndex!==d.selectedIndex&&(d.$.tabsElement.selectedIndex=d.selectedIndex),d.tabTextOrientation="right"===s||"left"===s?"vertical":"horizontal",d.tabPosition=s,d.style.top=d.style.left="",d.style.width=d.style.height="",d.opened=!0,d.resizeMode="none";for(let e=0;e<a.classList.length;e++)a.classList[e].indexOf("auto-hide-")>-1&&a.$.removeClass(a.classList[e]);if(a.$.addClass(i),a.style.paddingLeft=a.style.paddingRight=a.style.paddingTop=a.style.paddingBottom="",a.min&&(a.min=""),t._removeUnneccessaryItems(o),"top"===s||"left"===s?n.insert(0,a):n.appendChild(a),n.autoFitMode="proportional",!Smart.Utilities.Core.Browser.Safari||"left"!==s&&"right"!==s){if(Smart.Utilities.Core.Browser.Firefox&&("top"===s||"bottom"===s)){const e=(d.shadowRoot||d).querySelector(".smart-tab-strip");e&&(d.size=e.offsetHeight)}d.size="auto"}else{const e=d.querySelector(".smart-tab-strip");d.size=e.offsetWidth}d.min&&(d.min=""),d.min=30,d.locked=!0,n.autoFitMode="end"}}_autoHideWindowCloseHandler(){const e=this.$.autoHideWindow._tabsWindow,t=document.scrollingElement||document.documentElement,i=t.scrollLeft,a=t.scrollTop;if(e._moveContent(e._autoHideWindow.items[0],e._autoHideWindow._tab),!this.$.autoHideWindow.opened)return e.selectedIndex=null,void(document.activeElement!==e.$.tabsElement&&(e.$.tabsElement.focus(),window.scrollTo(i,a)));e.allowToggle&&null!==e.$.tabsElement.selectedIndex&&(e.select(e.$.tabsElement.selectedIndex),document.activeElement!==e.$.tabsElement&&(e.$.tabsElement.focus(),window.scrollTo(i,a)))}_autoHideWindowResizeEndHandler(e){const t=e.target,i="left"===t.resizeMode||"right"===t.resizeMode?"width":"height";t._tab&&(t._tab._autoHideWindowSize=e.detail[i])}_cancelDragOperation(e){const t=this;t.removeAttribute("dragged"),t._dragDetails.windowFeedback.removeAttribute("tabs-window-dragged"),t._dragDetails.windowFeedback.removeAttribute("ontop"),t._returnItemToOrigin(t._dragDetails.windowFeedback),t._noStateChangeFiring=!0,e||t._endDrag()}_createTabsWindowFromObject(e,t){const i=this,a=document.createElement("smart-tabs-window");let o,s=["close","autoHide"];if(a.layout=i,e.id&&(a.id=e.id),e.disabled&&(a.disabled=e.disabled),e.label&&(a.label=e.label),e.headerPosition&&(a.headerPosition=e.headerPosition),e.tabCloseButtons&&(a.tabCloseButtons=e.tabCloseButtons),e.dropPosition&&(a.dropPosition=e.dropPosition),e.resizeMode&&(a.resizeMode=e.resizeMode),a.animation=i.animation,a.rightToLeft=i.rightToLeft,a.theme=i.theme,a.draggable=void 0===e.draggable||e.draggable,a.floatable=void 0===e.floatable||e.floatable,a.tabCloseButtons=e.tabCloseButtons?e.tabCloseButtons:a.tabCloseButtons,e.autoHide?(a.autoHideWindow=i.$.autoHideWindow,a.autoHide=a.allowToggle=e.autoHide,a.autoHidePosition=e.autoHidePosition):e.undocked&&(s=["close","maximize","minimize"],a.undocked=e.undocked,a.position={top:e.top?(e.top+"").indexOf("%")>-1?e.top:parseFloat(e.top)+"px":void 0,left:e.left?(e.left+"").indexOf("%")>-1?e.left:parseFloat(e.left)+"px":void 0,width:e.width,height:e.height}),a.tabPosition=e.tabPosition||a.tabPosition,a.opened=a.pinned=!0,e.headerButtons&&(s=e.headerButtons),(!e.headerButtons||Array.isArray(e.headerButtons)&&0===e.headerButtons.length)&&(s=["close","autoHide"]),a.headerButtons=s,a.size=e.size||"",a.max=e.max||"",a.min=e.min?e.min:30,a.locked=e.locked||!1,a.collapsible=e.collapsible||!1,a.collapsed=e.collapsed||!1,e.items&&Array.isArray(e.items))for(let i=0;i<e.items.length;i++){if(t&&e.items[i].instance)o=e.items[i].instance,o.index=null,o.id=e.items[i].id||"";else{o=document.createElement("smart-tab-item"),o.label=e.items[i].label?e.items[i].label:"",o.id=e.items[i].id||"";const t=e.items[i].content;if(/^[#.]{1}\w(\w|-)+$/gm.test(t)){const e=document.querySelectorAll(t);for(let t=0;t<e.length;t++){const i=e[t];o.appendChild(i instanceof HTMLTemplateElement?document.importNode(i.content,!0):i)}}else o.content=e.items[i].content?e.items[i].content:"";o.selected=!!e.items[i].selected&&e.items[i].selected,a._isItemSelected=!0}o.draggable=void 0===e.items[i].draggable||e.items[i].draggable,o.floatable=void 0===e.items[i].floatable||e.items[i].floatable,e.items[i].id&&(o.id=e.items[i].id),a.appendChild(o)}return a}_createItemsFromArray(e,t){const i=this;let a=e;const o=a.length;i._removeAll(!0),i._initializingItems=!0;const s=i.undockedItems;for(let e=0;e<s.length;e++)s[e].layout=null,s[e].parentElement.removeChild(s[e]);let n;1===o&&a[0].type&&"layoutgroup"===a[0].type.toLowerCase()&&(i.$.itemsContainer.orientation=a[0].orientation||i.$.itemsContainer.orientation,i.$.itemsContainer.liveResize=a[0].liveResize||i.$.itemsContainer.liveResize,i.$.itemsContainer.resizeMode=a[0].resizeMode||i.$.itemsContainer.resizeMode,a=a[0].items),i.$.itemsContainer.autoFitMode="end";for(let e=0;e<a.length;e++)n=i._createLayoutItem(a[e],t),n&&(i.$.placeholderItem.parentElement&&i.$.itemsContainer.removeChild(i.$.placeholderItem),i.$.itemsContainer.appendChild(n));0===i._items.filter((e=>e.opened)).length?i.$.placeholderItem.parentElement||i.$.itemsContainer.appendChild(i.$.placeholderItem):i.$.placeholderItem.parentElement&&i.$.itemsContainer.removeChild(i.$.placeholderItem),i.$.itemsContainer.autoFitMode="proportional",delete i._initializingItems}_createLayoutItem(e,t){if(!e)return;const i=this,a=document.createElement("smart-splitter-item");let o;if(e.type&&"layoutgroup"===e.type.toLowerCase()){let a;o=document.createElement("smart-splitter"),o._isInShadowDOM=i.isInShadowDOM,o.autoFitMode="proportional",e.id&&(o.id=e.id),e.orientation&&(o.orientation=e.orientation),e.resizeMode&&(o.resizeMode=e.resizeMode),o.liveResize=i.liveResize,o.resizeStep=i.resizeStep;for(let s=0;s<e.items.length;s++)a=i._createLayoutItem(e.items[s],t),a&&o.appendChild(a);if(!o.querySelector("smart-splitter-item"))return}else{if(o=i._createTabsWindowFromObject(e.type&&"layoutgroup"===e.type.toLowerCase()?e.items[0]:e,t),o.autoHide)return i._autoHide(o,o.autoHidePosition),void delete o.autoHidePosition;if(o.undocked)return i.undock(o),i.getShadowRootOrBody().appendChild(o),i._ownTabWindow(o),o.opened=!0,o.pinned=!1,o.layout=i,o.position&&(o.style.left=o.position.left,o.style.top=o.position.top,o.style.width=o.position.width,o.style.height=o.position.height,delete o.position),void(o.size&&(o.style.left=o.position.left,o.style.top=o.position.top));i._items.push(o)}return a.size=e.size||"",a.max=e.max||"",a.min=e.min||30,a.locked=e.locked||!1,a.collapsible=e.collapsible||!1,a.collapsed=e.collapsed||!1,a.appendChild(o),a}_createLayoutStructure(e,t){const i=this,a=[];let o,s,n=e._items;const d=n[0].$.content.children[0];function l(e){let t=e.firstElementChild;for(;t;){if(t instanceof Smart.Splitter)return t;if(t instanceof Smart.TabsWindow)return t;t=t.nextElementSibling}}1===n.length&&d instanceof Smart.Splitter&&(n=d._items,e===i.$.itemsContainer&&(i.$.itemsContainer.orientation=d.orientation));for(let d=0;d<n.length;d++)if(n[d]!==i.$.placeholderItem){if(s=l(n[d].$.content),s instanceof Smart.TabsWindow)o=i._createTabsWindowStructure(s,t);else if(s instanceof Smart.Splitter){for(;1===s._items.length&&s._items[0].$.content.children[0]instanceof Smart.Splitter;)s=s._items[0].$.content.children[0];o=1===s._items.length?i._createTabsWindowStructure(s._items[0].$.content.children[0],t):{type:"LayoutGroup",items:i._createLayoutStructure(s,t),orientation:s.orientation},s.id&&(o.id=s.id),"adjacent"!==s.resizeMode&&(o.resizeMode=s.resizeMode),5!==s.resizeStep&&(o.resizeStep=s.resizeStep),s.liveResize&&(o.resizeStep=s.liveResize)}o.size=n[d][e._measurements.size],n[d].locked&&(o.locked=!0),n[d].min&&(o.min=n[d].min),n[d].max&&(o.max=n[d].max),a.push(o)}return a}_createTabsWindowStructure(e,t){function i(e){const i={type:"LayoutPanelItem"};return i.label=e.label||"",e.selected&&(i.selected=e.selected),e.disabled&&(i.disabled=e.disabled),i.draggable=void 0===e.draggable||e.draggable,i.floatable=void 0===e.floatable||e.floatable,t||(i.instance=e),e.id&&(i.id=e.id),i}const a={type:"LayoutPanel"};if(e.id&&(a.id=e.id),e.disabled&&(a.disabled=e.disabled),e.label&&(a.label=e.label),e.autoHide?(a.autoHide=e.autoHide,a.autoHidePosition=e.tabPosition):"top"!==e.tabPosition&&(a.tabPosition=e.tabPosition),e.closest("smart-docking-layout")||this._getClosestDockingLayout(e)||(a.undocked=!0,a.top=e.style.top,a.left=e.style.left,a.width=e.style.width,a.height=e.style.height),e.dropPosition&&"all"!==e.dropPosition[0]&&(a.dropPosition=e.dropPosition),a.draggable=void 0===e.draggable||e.draggable,a.floatable=void 0===e.floatable||e.floatable,void 0!==e.floatable&&(a.floatable=e.floatable),"none"!==e.resizeMode&&(a.resizeMode=e.resizeMode),e.items){a.items=[];for(let t=0;t<e.items.length;t++)a.items.push(i(e.items[t]))}return a}_containerTabStripResizeHandler(e){const t=this,i=e.target.closest("smart-splitter");i!==t.$.horizontalHiddenItemsContainer&&i!==t.$.verticalHiddenItemsContainer||(i._resizeEventHandler(),t._setAutoHidePaddings())}_getItemById(e){const t=this,i=e;if(e=document.getElementById(i))return e;if(t.shadowRoot&&!(e=t.shadowRoot.querySelector("#"+i))){let a=t.items;for(let t=0;t<a.length;t++){const o=a[t];if(o.shadowRoot&&(e=o.shadowRoot.querySelector("#"+i)))return e}a=document.querySelectorAll("smart-tabs-window");for(let o=0;o<a.length;o++){const s=a[o];if(s.layout===t&&s.shadowRoot&&(e=s.shadowRoot.querySelector("#"+i)))return e}}}_dock(e,t){const i=this;if("number"==typeof e?e=i._items[e]:"string"==typeof e&&(e=i._getItemById(e)),!e)return;let a;const o=e.id;if(e instanceof Smart.TabItem){const t=i._handleTabItemDocking(e);e=t.tabsWindow,a=t.newTabsWindow}else"object"!=typeof e||e instanceof HTMLElement||(e=i._createTabsWindowFromObject(e));if(!(e instanceof Smart.TabsWindow&&e.autoHide))return void((i._items.indexOf(e)<0||!e.opened&&!e.parentElement)&&(e.autoHide=!1,0===e.items.length&&"simple"===i.snapMode&&e.parentElement.removeChild(e),o&&(e.id=o),t?i._insert(-1,e,t?"layout-"+t:void 0):i.appendChild(e)));if(!(i.shadowRoot||i).contains(e))return;const s=e.closest("smart-splitter-item"),n=e.closest("smart-splitter"),d=!s.nextElementSibling;t||(t="horizontal"===n.orientation?d?"bottom":"top":d?"right":"left"),0===e.items.length&&s.closest("smart-splitter").removeChild(s),a&&(e=a),e.autoHide&&(i.$.verticalHiddenItemsContainer.contains(e)?i.$.verticalHiddenItemsContainer.removeChild(e.closest("smart-splitter-item")):i.$.horizontalHiddenItemsContainer.contains(e)&&i.$.horizontalHiddenItemsContainer.removeChild(e.closest("smart-splitter-item")),e.tabPosition=e._originalTabPosition||"top",delete e._originalTabPosition),i._setDockedItemsHeaderButtons(e),e.autoHide=e.allowToggle=e.maximized=e.minimized=e.collapsed=e.locked=!1,e.tabTextOrientation="horizontal",e.headerButtons=i.$.autoHideWindow.headerButtons,i.$.autoHideWindow.close(),o&&(e.id=o),i._insert(-1,e,"layout-"+t),i._setAutoHidePaddings(),delete i._dockingAutoHideTabItem}_handleTabItemDocking(e){const t=this,i=(e.isInShadowDOM?e.getRootNode().host:e).closest("smart-tabs-window");let a;if(i){const o=t.$.autoHideWindow;if(!i.autoHide)return{tabsWindow:i,newTabsWindow:i};t._dockingAutoHideTabItem=!0,a=1===i.items.length?i:document.createElement("smart-tabs-window"),delete e._autoHideWindowSize,a.size="left"===o.resizeMode||"right"===o.resizeMode?o.offsetWidth:o.offsetHeight,i.removeChild(e),0!==i.items.length||a.id||(t.shadowRoot||t).contains(i)||i.parentElement.removeChild(i),a.tabCloseButtons=i.tabCloseButtons,a.dropPosition=i.dropPosition,a.draggable=e.draggable,a.floatable=e.floatable}return a||(a=document.createElement("smart-tabs-window")),a.animation=t.animation,a.rightToLeft=t.rightToLeft,a.theme=t.theme,a.min=30,a.opened=a.pinned=a.autoHide=!0,a.style.maxWidth=a.style.maxHeight="",a._originalTabPosition=i._originalTabPosition||void 0,a._originalTextOrientation=i._originalTextOrientation||void 0,a!==i&&(delete i._originalTabPosition,delete i._originalTextOrientation),a.label=e.label,a.appendChild(e),{tabsWindow:e=i,newTabsWindow:a}}_dockEventHandler(e){const t=this;let i=e.target;i._tabsWindow&&(i=i._tabsWindow),i.autoHide?t._dock(i.items[i.selectedIndex]):t._autoHide(i,t._items.indexOf(i)<(t._items.length-1)/2)}_documentDownHandler(e){const t=this;let i=e.originalEvent.target;if(i.shadowRoot)for(i=e.originalEvent.composedPath()[0];i;){if(i.closest(".smart-window")){i=i.closest(".smart-window");break}i=i.getRootNode().host}else i=i.closest(".smart-window");if(t.$.autoHideWindow._tabsWindow&&(!i||i!==t.$.autoHideWindow&&i!==t.$.autoHideWindow._tabsWindow)&&(t.$.autoHideWindow._tabsWindow.selectedIndex=null),t._dragDetails)return void t._cancelDragOperation();if(!(i instanceof Smart.TabsWindow)||!t.draggable||t.disabled)return;if(t._dragDetails||i.maximized||i.minimized||!Smart.Utilities.Core.isMobile&&1!==e.which||i._dragDetails&&"resize"===i._dragDetails.type&&i._dragDetails.started)return;const a=e.originalEvent.target.shadowRoot?e.originalEvent.composedPath()[0]:e.originalEvent.target;if(i=a.closest(".smart-header-section")||a.closest(".smart-tab-label-container"),t._dragDetails={},i&&i.classList.contains("smart-header-section")&&("simple"===t.snapMode||a.closest(".smart-buttons-container"))&&(i=void 0),t._dragDetails.windowFeedback=t.$.tabsWindowFeedback,i){const a=i.getRootNode()&&i.getRootNode().host?i.getRootNode().host:i;if(t._dragDetails.selectedTabsWindow=i.closest("smart-tabs-window")||(a?a.closest("smart-tabs-window"):void 0),t._dragDetails.selectedTabsWindow===t.$.autoHideWindow){if(t._dragDetails.selectedItem=t.$.autoHideWindow._tabsWindow.closest("smart-splitter-item"),!t.$.autoHideWindow._tabsWindow.draggable)return void(t._dragDetails=void 0)}else t._dragDetails.selectedItem=t._dragDetails.selectedTabsWindow.closest("smart-splitter-item");if(!t._dragDetails.selectedTabsWindow||!t._dragDetails.selectedTabsWindow.draggable||t._dragDetails.selectedTabsWindow.layout!==t)return void(t._dragDetails=void 0);if(t._dragDetails.offset={x:0,y:0},t._dragDetails.selectedTabLabel=i,t._dragDetails.x=e.pageX,t._dragDetails.y=e.pageY,t._dragDetails.selectedTabLabel.$.hasClass("smart-header-section")){if(!t._dragDetails.selectedItem&&t._dragDetails.selectedTabsWindow.pinned)return void(t._dragDetails=void 0);t._dragDetails.windowFeedback=t._dragDetails.selectedTabsWindow;const a=i.getBoundingClientRect();t._dragDetails.offset.x=e.clientX-a.left,t._dragDetails.offset.y=e.clientY-a.top}else{if(!t._dragDetails.selectedTabLabel.tab||void 0!==t._dragDetails.selectedTabLabel.tab.draggable&&!t._dragDetails.selectedTabLabel.tab.draggable)return void(t._dragDetails=void 0);1===t._dragDetails.selectedTabsWindow.items.length&&(t._dragDetails.windowFeedback=t._dragDetails.selectedTabsWindow,t._dragDetails.windowFeedback.floatable=t._dragDetails.selectedTabsWindow.items[0].floatable)}}t._items.map((e=>e.removeAttribute("ontop"))),t._dragDetails.windowFeedback!==t.$.autoHideWindow&&t._dragDetails.windowFeedback.setAttribute("ontop","")}_getClosestDockingLayout(e){const t=this,i=(t.shadowRoot||t.isInShadowDOM?t.getRootNode().host:t).nodeName.toLowerCase(),a=this._getClosestElement(i,e);return a?t:a}_getClosestElement(e,t){if(!t||!this.isInShadowDOM)return;if(!t.getRootNode())return;let i=t.getRootNode().host;for(;i;){if(!i.closest)return;if(i.closest(e))return i.closest(e);i=i.getRootNode()?i.getRootNode().host:void 0}}_documentMoveHandler(e){const t=this,i=Smart.Utilities.Core.isMobile?document.elementFromPoint(e.pageX-window.pageXOffset,e.pageY-window.pageYOffset):t.isInShadowDOM||e.originalEvent.target.shadowRoot?e.originalEvent.composedPath()[0]:e.originalEvent.target;if(t.disabled||!t._dragDetails||t._dragDetails&&!t._dragDetails.selectedTabsWindow||!i)return;if(Math.abs(e.pageX-t._dragDetails.x)<=5&&Math.abs(e.pageY-t._dragDetails.y)<=5)return;const a=document.scrollingElement||document.documentElement,o=a.scrollLeft,s=a.scrollTop,n=t._dragDetails.selectedTabsWindow;if(t._dragDetails.isInsideTheLayout=i.closest&&i.closest("smart-docking-layout")===t,t._dragDetails.isInsideTheLayout||!t.shadowRoot&&!t.isInShadowDOM||(t._dragDetails.isInsideTheLayout=t._getClosestDockingLayout(i)),t._dragDetails.started=!0,t._dragDetails.windowFeedback===t.$.autoHideWindow){const e=t._dragDetails.selectedTabsWindow.getBoundingClientRect();let i;1===t.$.autoHideWindow._tabsWindow.items.length?i=t.$.autoHideWindow._tabsWindow:(i=document.createElement("smart-tabs-window"),i.draggable=!0,i.min=30,i.layout=t),i.style.width=e.width+"px",i.style.height=e.height+"px",i.style.left=e.left+"px",i.style.top=e.top+"px",i.setAttribute("ontop",""),t._dragDetails.windowFeedback=i,t.$.autoHideWindow.$.addClass("no-transition"),t.$.autoHideWindow.close(),t.$.autoHideWindow.$.removeClass("no-transition")}if(t._setDragDetailsOnMove(i),t.$.autoHideWindow.close(),t._dragDetails.windowFeedback.classList.contains("smart-tabs-window-feedback")){if(t._dragDetails._parentInfo||(t._dragDetails._parentInfo={closestItem:n,position:t._originalTabIndex||t._dragDetails.selectedTabLabel.tab.index},t._originalTabIndex=void 0),t.getShadowRootOrBody().contains(t._dragDetails.windowFeedback)||t.getShadowRootOrBody().appendChild(t._dragDetails.windowFeedback),t._dragDetails.selectedItem){const e=t._dragDetails.selectedItem.closest("smart-splitter");!t._dragDetails.windowFeedback.size&&e&&(t._dragDetails.windowFeedback.size=t._dragDetails.selectedTabsWindow[e._measurements.size])}}else t._handleWindowOnDrag();t._dragDetails.selectedTabLabel.classList.contains("smart-header-section")||t._dragDetails.windowFeedback.setAttribute("tabs-window-dragged",""),(t._dragDetails.windowFeedback.hasAttribute("tabs-window-dragged")||t._dragDetails.selectedTabsWindow===t.$.autoHideWindow||t._dragDetails._parentInfo&&"string"==typeof t._dragDetails._parentInfo.position)&&(t._dragDetails.windowFeedback.style.left=e.pageX-t._dragDetails.offset.x+"px",t._dragDetails.windowFeedback.style.top=e.pageY-t._dragDetails.offset.y+"px",t._setWindowFeedbackSize()),t._dragDetails.windowFeedback.opened=!0,document.activeElement!==t&&(t.focus(),window.scrollTo(o,s));let d=t._dragDetails.hoveredTabsWindow?i.closest(".smart-tabs-header-section"):void 0;d||!t.shadowRoot&&!t.isInShadowDOM||(d=t._getClosestElement(".smart-tabs-header-section",i)),t._dragDetails.hoveredTabArea=d||(t._dragDetails.hoveredTabsWindow&&i.closest(".smart-tabs-content-section")?t._dragDetails.hoveredTabsWindow.$.tabsElement.$.tabContentSection:t._dragDetails.hoveredTabsWindow),t.shadowRoot&&t._dragDetails.selectedTabsWindow===t._dragDetails.windowFeedback&&requestAnimationFrame((()=>{t._dragDetails&&t._dragDetails.windowFeedback.refreshTabHeader()})),t._setSnappingMarkers(e,d)}_setDragDetailsOnMove(e){const t=this;let i;if(!t.hasAttribute("dragged")){t._originalBodyOverflow={overflowX:document.body.style.overflowX,overflowY:document.body.style.overflowY,overflow:document.body.style.overflow};const e=(document.scrollingElement||document.documentElement).scrollHeight>document.documentElement.clientHeight,a=(document.scrollingElement||document.documentElement).scrollWidth>document.documentElement.clientWidth;let o=t._dragDetails.selectedTabsWindow;if(document.body.style.overflow=document.body.style.overflowX=document.body.style.overflowY="",e&&!a?document.body.style.overflowX="hidden":a&&!e?document.body.style.overflowY="hidden":a||e||(document.body.style.overflow="hidden"),t._dragDetails.windowFeedback.$.hasClass("smart-tabs-window-feedback")||o===t.$.autoHideWindow){const e=t._dragDetails.selectedTabLabel.tab||t.$.autoHideWindow._tab;let i=t.$.tabsWindowFeedback;o===t.$.autoHideWindow&&(o=t.$.autoHideWindow._tabsWindow,i=t._dragDetails.windowFeedback,i.label=e.label,i.draggable=e.draggable,i.floatable=e.floatable),Smart.Utilities.Core.isMobile&&navigator.platform&&/iPad|iPhone|iPod/.test(navigator.platform)&&(t._dragDetails.selectedTabLabel._lazyRemove=!0),e.parentElement&&(o.removeChild(e),t._dragDetails.selectedItem&&!t._dragDetails.selectedItem.style.width&&t._dragDetails.selectedItem.closest("smart-splitter").refresh()),t._originalTabIndex=e.index,i.appendChild(e);const a=t._dragDetails.selectedTabsWindow;if(a===t.$.autoHideWindow)a._tabsWindow.items.length>1&&(i.tabPosition=a.tabPosition,i.tabTextOrientation=a._originalTextOrientation||a.tabTextOrientation);else{const e=a.autoHide;i.tabPosition=a._originalTabPosition||(e?"top":a.tabPosition),i.tabTextOrientation=a._originalTextOrientation||(e?"horizontal":a.tabTextOrientation)}if(e._autoHideWindowSize)i.size=e._autoHideWindowSize;else if(o.autoHide){const e="offset"+("top"===o.tabPosition||"bottom"===o.tabPosition?"Height":"Width");i.size=(o._autoHideWindow||o)[e]}}i=t._dragDetails.selectedTabsWindow.closest("smart-docking-layout"),!i&&t.shadowRoot&&(i=t._getClosestDockingLayout(t._dragDetails.selectedTabsWindow)),i||t._dragDetails.windowFeedback._originalPinnedState||(t._dragDetails.windowFeedback._originalPinnedState=t._dragDetails.windowFeedback.pinned),t._dragDetails.windowFeedback.pinned=!1,t.setAttribute("dragged","")}t._dragDetails.hoveredItem=e.closest("smart-splitter-item"),t._dragDetails.hoveredItem||!t.shadowRoot&&!t.isInShadowDOM||(t._dragDetails.hoveredItem=t._getClosestElement("smart-splitter-item",e)),t._dragDetails.hoveredItem?(i=t._dragDetails.hoveredItem.closest("smart-docking-layout"),!i&&t.shadowRoot&&(i=t._getClosestDockingLayout(t._dragDetails.hoveredItem)),i&&i===t?t._dragDetails.hoveredTabsWindow=t._dragDetails.hoveredItem.querySelector("smart-tabs-window"):t._dragDetails.hoveredItem=t._dragDetails.hoveredTabsWindow=void 0):t._dragDetails.hoveredTabsWindow=e.closest("smart-tabs-window")||(e.getRootNode()&&e.getRootNode().host?e.getRootNode().host.closest("smart-tabs-window"):void 0),t._dragDetails.hoveredTabsWindow&&(i=t._dragDetails.hoveredTabsWindow.closest("smart-docking-layout"),!i&&t.shadowRoot&&(i=t._getClosestDockingLayout(t._dragDetails.hoveredTabsWindow)),i&&i!==t?t._dragDetails.hoveredTabsWindow=void 0:t._dragDetails.hoveredTabsWindow.bringToFront())}_documentDragStartHandler(e){const t=this;(t.contains(e.target)||t.contains(e.composedPath()[0])||"simple"===t.snapMode&&t._dragDetails&&t._dragDetails.selectedTabLabel)&&e.preventDefault()}_documentSelectStartHandler(e){this._dragDetails&&this._dragDetails.started&&e.preventDefault()}_documentUpHandler(e){const t=this,i=e.originalEvent||e,a=i.target.getRootNode().host?i.composedPath()[0]:i.target;if(!t._dragDetails||t._dragDetails&&!t._dragDetails.started||t.disabled)return void delete t._dragDetails;t._noStateChangeFiring=!0,t.removeAttribute("dragged"),t._dragDetails.windowFeedback.removeAttribute("tabs-window-dragged"),t._dragDetails.windowFeedback.removeAttribute("ontop");let o=a.closest&&a.closest("smart-docking-layout");o||!t.shadowRoot&&!t.isInShadowDOM||(o=t._getClosestDockingLayout(a)),e.ctrlKey&&(t._snapFeedback._position=o=void 0);const s=t._snapFeedback?t._snapFeedback._position:void 0;if(!o&&!s||o&&!t._dragDetails.hoveredTabArea&&!s)t._dropWindowOutsideLayout(e,s,o);else if(t._dragDetails.hoveredTabsWindow&&s){if(t._dragDetails.hoveredTabArea&&t._dragDetails.hoveredTabArea.classList.contains("smart-tabs-header-section")){let e,i,o,s=t._dragDetails.hoveredTabsWindow.itemLabels.length,n=a.closest(".smart-tab-label-container");if(n&&!n.$.hasClass("smart-add-new-tab")&&n.tab||(n=t._dragDetails.hoveredTabsWindow.itemLabels[s-1],e=!0),i=t._dragDetails.selectedTabLabel.$.hasClass("smart-tab-label-container")&&t._dragDetails.windowFeedback.$.hasClass("smart-tabs-window-feedback")?[t._dragDetails.selectedTabLabel.tab]:[].slice.call(t._dragDetails.windowFeedback.items),t._dragDetails.hoveredTabsWindow.autoHide){const e=t._dragDetails.hoveredTabsWindow.tabPosition;o=t._dragDetails.windowFeedback["offset"+("top"===e||"bottom"===e?"Height":"Width")]}for(let a=0;a<i.length;a++)i[a]._autoHideWindowSize=o||t._dragDetails.windowFeedback.size,t._dragDetails.windowFeedback.removeChild(i[a]),t._dragDetails.hoveredTabsWindow.insert(e?s:n.tab.index,{node:i[a]}),s=t._dragDetails.hoveredTabsWindow.items.length;t._dragDetails.targetWindow=t._dragDetails.hoveredTabsWindow}else t._dragDetails.targetWindow=t._handleItemNesting(),t._eventAlreadyFired=!0;t.$.autoHideWindow.close(),t._noStateChangeFiring=!1}if(t.shadowRoot||t.isInShadowDOM){const e=t._dragDetails.targetWindow;setTimeout((()=>e.refreshTabHeader()),100)}t._endDrag()}_dropWindowOutsideLayout(e,t,i){const a=this;let o;if(a.floatable&&(void 0===a._dragDetails.windowFeedback.floatable||a._dragDetails.windowFeedback.floatable)){if(a._dragDetails.windowFeedback.classList.contains("smart-tabs-window-feedback")){const t=a._dragDetails.windowFeedback.items[0];if(t&&void 0!==t.floatable&&!t.floatable)return void a._cancelDragOperation(!0);const i=a._dragDetails.selectedTabLabel.tab;let s=document.createElement("smart-tabs-window");s.opened=!0,s.animation=a.animation,s.rightToLeft=a.rightToLeft,s.theme=a.theme,s.label=i.label,a._dragDetails.windowFeedback.removeChild(i),a._dragDetails.selectedTabLabel.tab.$.removeClass("smart-visibility-hidden"),s.appendChild(a._dragDetails.selectedTabLabel.tab),s.style.left=e.pageX+"px",s.style.top=e.pageY+"px",s.style.maxWidth=s.style.maxHeight="",s.resizeMode=a._dragDetails.selectedTabsWindow.resizeMode,s.tabCloseButtons=a._dragDetails.selectedTabsWindow.tabCloseButtons,s.tabTextOrientation=a._dragDetails.windowFeedback.tabTextOrientation,s.tabPosition=a._dragDetails.windowFeedback.tabPosition,s.min=30,s.style.width=a._dragDetails.windowFeedback.style.width,s.style.height=a._dragDetails.windowFeedback.style.height,s.draggable=void 0===i.draggable||i.draggable,s.floatable=void 0===i.floatable||i.floatable,a.getShadowRootOrBody().appendChild(s),s.pinned=s.autoHide=s.allowToggle=!1,a._noStateChangeFiring=!1,o=s}else a._dragDetails._parentInfo&&a._dragDetails._parentInfo.closestItem?(a._dragDetails.windowFeedback.parentElement!==a.getShadowRootOrBody()&&(a._dragDetails.windowFeedback.windowParent="body",a.getShadowRootOrBody().appendChild(a._dragDetails.windowFeedback)),a._dragDetails.windowFeedback.style.maxWidth=a._dragDetails.windowFeedback.style.maxHeight="",a._dragDetails.windowFeedback.pinned=a._dragDetails.windowFeedback.allowToggle=a._dragDetails.windowFeedback.autoHide=!1,a._dragDetails.selectedTabLabel.$.hasClass("smart-tab-label-container")&&(a._dragDetails.windowFeedback.label=a._dragDetails.selectedTabLabel.tab.label)):t||a._dragDetails.selectedItem instanceof Smart.SplitterItem||!a._dragDetails.selectedTabLabel.$.hasClass("smart-tab-label-container")||a._returnItemToOrigin(a._dragDetails.windowFeedback),o=a._dragDetails.windowFeedback,o.locked=!1,a._dragDetails.selectedItem&&(a._noStateChangeFiring=!1);a.$.autoHideWindow.close(),i||(a._dragDetails.windowFeedback.pinned=!1),a._validateWindowPosition(o),a._dragDetails._parentInfo&&(o._parentInfo={closestItem:a._dragDetails._parentInfo.closestItem,position:a._dragDetails._parentInfo.position}),o.layout=a,a._dragDetails.targetWindow=o,o.resizeMode="both",a._setFloatingItemsHeaderButtons(o),a._ownTabWindow(o)}else a._cancelDragOperation(!0)}_endDrag(){const e=this,t=e._dragDetails,i=e._dragDetails.windowFeedback;if(e.$.tabsWindowFeedback.close(),t.isInsideTheLayout&&0===i.$.tabsElement._tabs.length&&!i.$.hasClass("smart-tabs-window-feedback")&&i.remove(),(e.shadowRoot||e).contains(e._dragDetails.windowFeedback)||void 0===e._dragDetails.windowFeedback._originalPinnedState||(e._dragDetails.windowFeedback.pinned=e._dragDetails.windowFeedback._originalPinnedState,delete e._dragDetails.windowFeedback._originalPinnedState),e._originalBodyOverflow&&(document.body.style.overflow=e._originalBodyOverflow.overflow,document.body.style.overflowX=e._originalBodyOverflow.overflowX,document.body.style.overflowY=e._originalBodyOverflow.overflowY,delete e._originalBodyOverflow),e._dragDetails.targetWindow?(e._dragDetails.targetWindow.focus(),e._dragDetails.selectedTabsWindow&&e._dragDetails.selectedTabsWindow.removeAttribute("active")):e._dragDetails.windowFeedback.bringToFront(),e._dragDetails.started=!1,e._dragDetails.hoveredItem=e._dragDetails.hoveredTabsWindow=e._dragDetails.isInsideTheLayout=void 0,i.removeAttribute("dragged"),e._handleSnapping(),e._dragDetails.selectedTabsWindow&&delete e._dragDetails.selectedTabsWindow._ownerLayout,0===i.items.length&&((e.shadowRoot||e).contains(i)&&(i.opened=!1),i.$.hasClass("smart-tabs-window-feedback")&&e.$.container.appendChild(i)),!e._eventAlreadyFired&&!e._noStateChangeFiring){e._handleAutoSave();let t={item:e._dragDetails.targetWindow};t.type=e._items.indexOf(e._dragDetails.targetWindow)>-1?"dock":"float",e.$.fireEvent("stateChange",t)}e._noStateChangeFiring=e._eventAlreadyFired=void 0,e._dragDetails._parentInfo&&e._dragDetails._parentInfo.closestItem&&e._removeUnneccessaryItems(e._dragDetails._parentInfo.closestItem.closest("smart-splitter"));let a=e._getClosestDockingLayout(i);if(i.closest("smart-docking-layout")||a)return i.style.top=i.style.left="",void delete e._dragDetails;i.top&&(i.style.top=i.top),i.left&&(i.style.left=i.left),e._dragDetails.selectedTabLabel&&e._dragDetails.selectedTabLabel._lazyRemove&&(e._dragDetails.selectedTabLabel&&e._dragDetails.selectedTabLabel.remove(),delete e._dragDetails.selectedTabLabel._lazyRemove),i._cancelDragging(),delete e._dragDetails}_getTabItemContent(e){const t=e.isCompleted?e.$.content:e,i=document.createDocumentFragment();for(;t.firstChild;)i.appendChild(t.firstChild);return i}_getHeaderLabelDimensions(e){const t=this;function i(e){if(!t._dragDetails)return clearInterval(t._scrollInterval),void(t._scrollInterval=void 0);o.scrollLeft+=e,a._updateScrollButtonVisibility(),a._positionTabSelectionBar(a._tabLabelContainers[a.selectedIndex],!0)}if(!t._dragDetails||!t._dragDetails.hoveredTabsWindow)return;const a=t._dragDetails.hoveredTabsWindow.$.tabsElement,o=a.$.tabStrip,s=o.getBoundingClientRect(),n="left"===a.tabPosition||"right"===a.tabPosition,d=t.rightToLeft&&Smart.Utilities.Core.Browser.Chrome?o.scrollLeft-(o.scrollWidth-o.offsetWidth):o.scrollLeft;let l=0,r=0;"horizontal"===a.tabTextOrientation?l=a.$.scrollButtonNear.offsetWidth:r=a.$.scrollButtonNear.offsetHeight,"top"!==a.tabPosition&&"bottom"!==a.tabPosition||(t._scrollInterval&&clearInterval(t._scrollInterval),t._scrollInterval=setInterval((function(){e&&(d||t.rightToLeft)&&e.clientX<=s.left+Math.max(l,20)?i(-1):e&&d!==(t.rightToLeft?0:o.scrollWidth)&&e.clientX>=s.left+s.width-Math.max(l,20)?i(1):(clearInterval(t._scrollInterval),t._scrollInterval=void 0)}),1));let m,c,g=0,p=0;if(t._dragDetails.hoveredTabArea)m=t._dragDetails.hoveredTabArea.offsetWidth,c=t._dragDetails.hoveredTabArea.offsetHeight,g=t._dragDetails.hoveredTabArea.offsetLeft,p=t._dragDetails.hoveredTabArea.offsetTop;else if(o.children.length>0){const e=a.$.tabStrip.children[a.$.tabStrip.children.length-1];g=e.offsetLeft+(t.rightToLeft?-1:1)*(n?0:e.offsetWidth),p=e.offsetTop+(n?e.offsetHeight:0),m=e.offsetWidth,c=e.offsetHeight}t._dragDetails.hoveredTabArea=a.$.tabsHeaderSection;const h=t._dragDetails.hoveredTabArea.getBoundingClientRect(),_=s.left-h.left+h.left+g-d-l,b=s.top-h.top+h.top+p-o.scrollTop-r,f=Math.min(g-d-l,0),u=Math.min(p-o.scrollTop-r,0);return{width:Math.min(s.width,Math.max(0,m+f),Math.max(0,s.left+s.width-_)),height:Math.min(s.height,Math.max(0,c+u),Math.max(0,s.top+s.height-b)),top:b+window.pageYOffset-u,left:_+window.pageXOffset-f}}_handleAutoSave(){this.autoSaveState&&this.saveState()}_handleAutoHiddenSplitterBars(){const e=this.$.itemsContainer.querySelectorAll(".auto-hide-left,.auto-hide-right, .auto-hide-top, .auto-hide-bottom");for(let t=0;t<e.length;t++)e[t].previousElementSibling instanceof Smart.SplitterBar?e[t].previousElementSibling.hide():e[t].nextElementSibling instanceof Smart.SplitterBar&&e[t].nextElementSibling.hide()}_handleItemPositionInserting(e,t,i){const a=this;e.autoHide||i.indexOf("layout")>-1?a._handleLayoutItemInserting(t,e,i):i.indexOf("outside-")>-1?a._handleOutsideItemInserting(t,e,i):(i.indexOf("inside-")>-1?a._handleInsideItemInserting(t,e,i):a._handleNormalItemInserting(t,e,i),a._handleAutoSave(),a.$.fireEvent("stateChange",{type:"dock",item:e}),a._setSplitterBarVisibility())}_handleInsideItemInserting(e,t,i){const a=this,o=document.createElement("smart-splitter-item"),s=document.createElement("smart-splitter-item");let n,d=e.closest("smart-splitter-item"),l=e.closest("smart-splitter"),r=a._items.indexOf(e);n=l&&1===l._items.length?l:document.createElement("smart-splitter"),n._isInShadowDOM=a.isInShadowDOM,n.autoFitMode="proportional",n.liveResize=a.liveResize,n.resizeStep=a.resizeStep,t.windowParent=null,o.appendChild(t),e.windowParent=null,i=i.replace("inside-",""),n.orientation="top"===i||"bottom"===i?"horizontal":"vertical";const m=d["horizontal"===n.orientation?"offsetHeight":"offsetWidth"]/2;if(n.parentElement?n.insertBefore(o,"top"===i||"left"===i?d:null):(s.appendChild(e),e.min&&(s.min=e.min),"top"===i||"left"===i?(n.appendChild(o),n.appendChild(s)):(n.appendChild(s),n.appendChild(o)),d.appendChild(n)),t.size){const e="string"==typeof t.size&&t.size.indexOf("%")>-1;o.size=e?t.size:Math.min(m,parseFloat(t.size))}o.max=t.max||"",o.min=t.min?t.min:30,o.locked=t.locked||!1,o.collapsible=t.collapsible||!1,o.collapsed=t.collapsed||!1,"bottom"!==i&&"right"!==i||(r=Math.min(r+1,a._items.length)),t.pinned=!0,t.autoHide=t.allowToggle=t.maximized=t.minimized=t.collapsed=!1,t._originalTabPosition?(t.tabPosition=t._originalTabPosition,delete t._originalTabPosition):t.tabPosition="top",t._originalTextOrientation?(t.tabTextOrientation=t._originalTextOrientation,delete t._originalTextOrientation):t.tabTextOrientation="horizontal",a._items.splice(r,0,t),a._handleAutoHiddenSplitterBars()}_handleLayoutItemInserting(e,t,i){const a=this,o=document.createElement("smart-splitter-item"),s="bottom"===i||"top"===i?"offsetHeight":"offsetWidth";if(t.size||(t.size=t[s]),i=i.replace("layout-",""),o.size=t.size||"",o.max=t.max||"",o.min=t.min||"",o.locked=t.locked||!1,o.collapsible=t.collapsible||!1,o.collapsed=t.collapsed||!1,o.size&&!a._dockingAutoHideTabItem&&(o.size=Math.min(a[s]/2,parseFloat(t.size))),("horizontal"!==a.$.itemsContainer.orientation||"right"!==i&&"left"!==i)&&("vertical"!==a.$.itemsContainer.orientation||"top"!==i&&"bottom"!==i)){const e=i.indexOf("left")>-1||i.indexOf("top")>-1?a._items.filter((e=>e.opened))[0]:void 0;return t.windowParent=null,o.appendChild(t),a.insertBefore(o,e,a.$.itemsContainer),!0}{let e,s=a.$.itemsContainer.orientation;const n=a.$.itemsContainer,d=[].slice.call(n._items),l=function(e,t){n.appendChild(e),n.insertBefore(t,"right"===i||"bottom"===i?null:e)};t.windowParent=null,o.appendChild(t),d.map((e=>e.size=e[n._measurements.size])),"right"===i||"bottom"===i?a._items.push(t):a._items.splice(0,0,t),n.removeAll(),n.orientation="top"===i||"bottom"===i?"horizontal":"vertical";const r=n[n._measurements.size]-o.size;if(d.length>1){const t=document.createElement("smart-splitter");t._isInShadowDOM=a.isInShadowDOM,t.autoFitMode="end",t.orientation=s,t.liveResize=a.liveResize,t.resizeStep=a.resizeStep,e=document.createElement("smart-splitter-item"),e.min=30,e.appendChild(t),e.size=r,l(e,o);for(let e=0;e<d.length;e++)t.appendChild(d[e]);t.autoFitMode="proportional"}else d[0].size=r,a._dockingAutoHideTabItem&&(n.autoFitMode="end"),l(d[0],o),n.autoFitMode="proportional";a._handleAutoHiddenSplitterBars(),a._handleAutoSave(),a.$.fireEvent("stateChange",{type:"dock",item:t}),a._setSplitterBarVisibility()}}_handleNormalItemInserting(e,t,i){let a=e.closest("smart-splitter-item");const o=this,s=e.closest("smart-splitter"),n=document.createElement("smart-splitter-item"),d="right"===i||"bottom"===i?s._items.indexOf(a)+1:s._items.indexOf(a);let l=o._items.indexOf(e);t.windowParent=null,n.appendChild(t),n.size=t.size||"",n.min=t.min||"",s.insert(d,n),"bottom"!==i&&"right"!==i||(l=Math.min(l+1,o._items.length)),t.pinned=!0,t.locked=!1,t.autoHide=t.allowToggle=t.maximized=t.minimized=t.collapsed=!1,t._originalTabPosition?(t.tabPosition=t._originalTabPosition,delete o._originalTabPosition):t.tabPosition="top",t._originalTextOrientation?(t.tabTextOrientation=t._originalTextOrientation,delete t._originalTextOrientation):t.tabTextOrientation="horizontal",o._items.splice(l,0,t),o._handleAutoHiddenSplitterBars()}_handleOutsideItemInserting(e,t,i){const a=this,o=document.createElement("smart-splitter-item");let s=e.closest("smart-splitter");if(s||(s=a.$.itemsContainer),o.size=t.size||"",o.max=t.max||"",o.min=t.min||"",o.locked=t.locked||!1,o.collapsible=t.collapsible||!1,o.collapsed=t.collapsed||!1,s===a.$.itemsContainer)return t.windowParent=null,o.appendChild(t),a.insertBefore(o,i.indexOf("left")>-1||i.indexOf("top")>-1?a._items[0]:void 0,a.$.itemsContainer),!0;{let n=s.closest("smart-splitter-item");const d=document.createElement("smart-splitter"),l=document.createElement("smart-splitter-item");if(d._isInShadowDOM=a.isInShadowDOM,i=i.replace("outside-",""),d.autoFitMode="proportional",d.liveResize=a.liveResize,d.resizeStep=a.resizeStep,t.windowParent=null,o.appendChild(t),l.min=30,l.appendChild(s),d.orientation="top"===i||"bottom"===i?"horizontal":"vertical",n.appendChild(d),"right"===i||"bottom"===i?(d.appendChild(l),d.appendChild(o),a._items.splice(a._items.indexOf(e)+1,0,t)):(d.appendChild(o),d.appendChild(l),a._items.splice(a._items.indexOf(e),0,t)),o.size){const e=o.size;o.size="",o.size=e}else o.size=d[d._measurements.size]/2;a._handleAutoHiddenSplitterBars(),a._handleAutoSave(),a.$.fireEvent("stateChange",{type:"dock",item:t}),a._setSplitterBarVisibility()}}refresh(){this._handleLayout()}_handleLayout(){const e=this;if(e._items=[],"string"==typeof e.layout&&(e.layout=JSON.parse(e.layout)),null!==e.layout&&Array.isArray(e.layout))return void e._createItemsFromArray(e.layout);const t=Array.from(e.$.itemsContainer.children);e.$.itemsContainer.innerHTML="";for(let i=0;i<t.length;i++){"Smart-TABS-WINDOW"!==t[i].tagName&&t[i].parentElement.removeChild(t[i]),t[i].layout=e;const a=document.createElement("smart-splitter-item");a.appendChild(t[i]),e.$.itemsContainer.appendChild(a),e._items.push(t[i])}}_handleSnapping(e,t){const i=this;"simple"===i.snapMode?i._handleSimpleSnapping(e,t):i._handleAdvancedSnapping(t)}_handleAdvancedSnapping(e){const t=this;if(!t._dragDetails)return;if(t._snapFeedback&&!t._dragDetails.hoveredTabsWindow&&(t._snapFeedback._position=void 0,t._snapFeedback.areaHighlighter&&t._snapFeedback.areaHighlighter.remove(),t._snapFeedback.headerHighlighter&&t._snapFeedback.headerHighlighter.remove(),!t._dragDetails.hoveredItem)){if(t._snapFeedback.innerSnapElement&&t._snapFeedback.innerSnapElement.remove(),t._snapFeedback.outherSnapElement&&!t._dragDetails.isInsideTheLayout){const e=[].slice.call(t.$.container.children);for(let i=0;i<e.length;i++)e[i].className.indexOf("smart-docking-layout-snap")>-1&&t._snapFeedback.outherSnapElement.appendChild(e[i])}return}if(t._snapFeedback||(t._snapFeedback={innerSnapElement:document.createElement("div"),outherSnapElement:document.createElement("div"),areaHighlighter:document.createElement("div"),headerHighlighter:document.createElement("div")},t._snapFeedback.innerSnapElement.classList.add("smart-docking-layout-snap"),t._snapFeedback.areaHighlighter.classList.add("smart-docking-layout-snap-highlighter"),t._snapFeedback.headerHighlighter.classList.add("smart-docking-layout-snap-highlighter-header"),t._snapFeedback.innerSnapElement.innerHTML='\n                            <div>\n                                <div class="top">\n                                    <div><div></div></div>\n                                </div>\n                            </div>\n                            <div>\n                                <div class="left">\n                                    <div><div></div></div>\n                                </div>\n                                <div class="center">\n                                    <div><div></div></div>\n                                </div>\n                                <div class="right">\n                                    <div><div></div></div>\n                                </div>\n                            </div>\n                            <div>\n                                <div class="bottom">\n                                    <div><div></div></div>\n                                </div>\n                            </div>',t._snapFeedback.outherSnapElement.innerHTML='\n                            <div class="smart-docking-layout-snap layout-top">\n                                <div><div></div></div>\n                            </div>\n                            <div class="smart-docking-layout-snap layout-left">\n                                <div><div></div></div>\n                            </div>\n                            <div class="smart-docking-layout-snap layout-right">\n                                <div><div></div></div>\n                            </div>\n                            <div class="smart-docking-layout-snap layout-bottom">\n                                <div><div></div></div>\n                            </div>'),t._snapFeedback.areaHighlighter.parentElement&&(t._snapFeedback.areaHighlighter.removeAttribute("position"),t._snapFeedback.areaHighlighter.classList.remove("smart-hidden")),t._snapFeedback.areaHighlighter.style.width="",t._snapFeedback.areaHighlighter.style.height="",t._snapFeedback._position=!t._dragDetails.hoveredItem||t._dragDetails.hoveredItem instanceof Smart.SplitterItem?"":t._dragDetails.hoveredItem.className,t._dragDetails.hoveredItem&&t._dragDetails.hoveredItem.className.indexOf("layout-")>-1){t._snapFeedback._position=t._snapFeedback._position.replace("smart-docking-layout-snap ",""),t._snapFeedback.areaHighlighter.setAttribute("position",t._snapFeedback._position);const e=t._dragDetails.selectedTabsWindow;return void(e.dropPosition.indexOf("all")>-1||e.dropPosition.indexOf(t._snapFeedback._position)>-1?(t._dragDetails.hoveredItem.setAttribute("show",""),t.$.container.appendChild(t._snapFeedback.areaHighlighter),t._dragDetails.hoveredTabsWindow=!0,["layout-left","layout-right"].indexOf(t._snapFeedback._position)>-1?t._snapFeedback.areaHighlighter.style.width=t._dragDetails.windowFeedback.style.width||t._dragDetails.windowFeedback.offsetWidth+"px":["layout-top","layout-bottom"].indexOf(t._snapFeedback._position)>-1&&(t._snapFeedback.areaHighlighter.style.height=t._dragDetails.windowFeedback.style.height||t._dragDetails.windowFeedback.offsetHeight+"px")):(t._dragDetails.hoveredItem.removeAttribute("show"),t._snapFeedback._position=void 0))}let i=t._dragDetails.hoveredTabsWindow?t._dragDetails.hoveredTabsWindow.dropPosition:["all"];if(0===i.length&&(i=["all"]),t._dragDetails.hoveredTabsWindow instanceof Smart.TabsWindow&&t._dragDetails.hoveredTabArea&&t._dragDetails.hoveredTabArea.closest(".smart-tabs-header-section")&&(i.indexOf("all")>-1||i.indexOf("header")>-1)){t._dragDetails.hoveredTabArea=t._dragDetails.hoveredTabArea.classList.contains("smart-tab-label-container")?t._dragDetails.hoveredTabArea:void 0;const i=t._getHeaderLabelDimensions(e),a=t._snapFeedback.headerHighlighter;a.style.width=i.width+"px",a.style.height=i.height+"px",a.style.top=i.top+"px",a.style.left=i.left+"px",a.classList.remove("smart-hidden"),t.getShadowRootOrBody().contains(a)||t.getShadowRootOrBody().appendChild(a),t._snapFeedback._position="header"}else t._scrollInterval&&(clearInterval(t._scrollInterval),t._scrollInterval=void 0),t._snapFeedback.headerHighlighter.style.width=t._snapFeedback.headerHighlighter.style.height=0;const a=t._snapFeedback.innerSnapElement.closest("smart-splitter-item");if(t._dragDetails.hoveredItem instanceof Smart.SplitterItem){if(a&&t._dragDetails.hoveredItem!==a&&a.removeChild(t._snapFeedback.innerSnapElement),t._dragDetails.hoveredItem.className.indexOf("auto-hide")<0){const e=t._snapFeedback.innerSnapElement.querySelectorAll(".top, .bottom, .left, .right, .center");for(let t=0;t<e.length;t++)i.indexOf(e[t].className)>-1||0===i.indexOf("all")?e[t].setAttribute("show",""):e[t].removeAttribute("show");t._snapFeedback.innerSnapElement.classList.remove("smart-hidden"),t._dragDetails.hoveredItem.contains(t._snapFeedback.innerSnapElement)||t._dragDetails.hoveredItem.appendChild(t._snapFeedback.innerSnapElement)}const e=[].slice.call(t._snapFeedback.outherSnapElement.children),o=t._dragDetails.selectedTabsWindow;let s;for(let i=0;i<e.length;i++)s=e[i].className.replace("smart-docking-layout-snap ",""),e[i].classList.remove("smart-hidden"),o.dropPosition.indexOf("all")>-1||o.dropPosition.indexOf(s)>-1?e[i].setAttribute("show",""):e[i].removeAttribute("show"),t.$.container.appendChild(e[i])}if(!t._snapFeedback._position||i.indexOf("all")<0&&i.indexOf(t._snapFeedback._position)<0)t._snapFeedback._position=t._dragDetails.hoveredTabArea=void 0;else if("center"===t._snapFeedback._position&&t._items.filter((e=>e.opened)).length>0&&(t._dragDetails.hoveredTabArea=t._dragDetails.hoveredTabsWindow.$.tabsElement.$.tabsHeaderSection),["left","right"].indexOf(t._snapFeedback._position)>-1?t._snapFeedback.areaHighlighter.style.width=t._dragDetails.windowFeedback.style.width||t._dragDetails.windowFeedback.offsetWidth+"px":["top","bottom"].indexOf(t._snapFeedback._position)>-1&&(t._snapFeedback.areaHighlighter.style.height=t._dragDetails.windowFeedback.style.height||t._dragDetails.windowFeedback.offsetHeight+"px"),t._snapFeedback.areaHighlighter.setAttribute("position",t._snapFeedback._position),"header"===t._snapFeedback._position)t._dragDetails.hoveredTabsWindow.$.tabsElement.$.tabContentSection.appendChild(t._snapFeedback.areaHighlighter);else{const e=t._dragDetails.hoveredTabsWindow.closest("smart-splitter").orientation;("left"!==t._snapFeedback._position&&"right"!==t._snapFeedback._position||"horizontal"!==e)&&("top"!==t._snapFeedback._position&&"bottom"!==t._snapFeedback._position||"vertical"!==e)||(t._snapFeedback._position="inside-"+t._snapFeedback._position),t._dragDetails.hoveredItem.closest("smart-splitter-item").appendChild(t._snapFeedback.areaHighlighter)}}_handleSimpleSnapping(e,t){const i=this;if(!e)return i._dragDetails&&(i._dragDetails.hoveredTabsWindow=i._dragDetails.hoveredTabArea=void 0),void(i._snapFeedback instanceof HTMLElement&&(i._snapFeedback._position=void 0,i.getShadowRootOrBody().contains(i._snapFeedback)&&i._snapFeedback.classList.add("smart-visibility-hidden")));i._snapFeedback||(i._snapFeedback=document.createElement("div"),i._snapFeedback.addEventListener("transitionend",(function(){i._snapFeedback.classList.contains("smart-visibility-hidden")&&i.getShadowRootOrBody().contains(i._snapFeedback)&&i._snapFeedback.remove()})));for(let e=0;e<i._snapFeedback.classList.length;e++)i._snapFeedback.classList[e].indexOf("smart-docking-snap-")>-1&&i._snapFeedback.classList.remove(i._snapFeedback.classList[e]);i._snapFeedback._position=e,e=e.replace("inside-",""),i._snapFeedback.classList.add("smart-docking-snap-"+e+"-feedback"),i._snapFeedback.classList.remove("smart-visibility-hidden");let a,o,s,n,d,l=0===e.indexOf("layout")?i._dragDetails.selectedTabsWindow.dropPosition:i._dragDetails.hoveredTabsWindow.dropPosition;0===l.length&&(l=["all"]),l.indexOf("all")>-1||l.indexOf(e)>-1?i._snapFeedback.removeAttribute("disabled"):(i._snapFeedback.setAttribute("disabled",""),i._snapFeedback._position=void 0);const r=i.getBoundingClientRect(),m=getComputedStyle(i._dragDetails.hoveredTabsWindow.$.contentSection),c=parseFloat(m.getPropertyValue("padding-left")||0),g=parseFloat(m.getPropertyValue("padding-right")||0),p=parseFloat(m.getPropertyValue("padding-top")||0),h=parseFloat(m.getPropertyValue("padding-bottom")||0),_=i.$.verticalHiddenItemsContainer.getElementsByClassName("auto-hide-left")[0],b=i.$.horizontalHiddenItemsContainer.getElementsByClassName("auto-hide-top")[0];switch(i._snapFeedback.style.display="",e){case"header":{const e=i._getHeaderLabelDimensions(t);a=e.width,o=e.height,s=e.top,n=e.left,a&&o||(i._snapFeedback.style.display="none");break}case"left":case"right":d=i._dragDetails.hoveredTabArea.getBoundingClientRect(),o=i._dragDetails.hoveredTabArea.offsetHeight,a=i._dragDetails.hoveredTabArea.offsetWidth/2,s=d.top+window.pageYOffset,n=d.left+("right"===e?i._dragDetails.hoveredTabArea.offsetWidth/2:0)+window.pageXOffset;break;case"top":case"bottom":d=i._dragDetails.hoveredTabArea.getBoundingClientRect(),o=i._dragDetails.hoveredTabArea.offsetHeight/2,a=i._dragDetails.hoveredTabArea.offsetWidth,s=d.top+window.pageYOffset+("bottom"===e?i._dragDetails.hoveredTabArea.offsetHeight/2:0),n=d.left+window.pageXOffset;break;case"layout-left":case"layout-right":i.getShadowRootOrBody().contains(i._snapFeedback)&&void 0===i._snapFeedback.maxWidth&&(i._snapFeedback.maxWidth=parseFloat(getComputedStyle(i._snapFeedback).getPropertyValue("max-width"))||0),a=.07*i.$.itemsContainer.offsetWidth-(c+g),i._snapFeedback.maxWidth&&(a=Math.min(i._snapFeedback.maxWidth,a)),o=i.$.itemsContainer.offsetHeight-(p+h),s=r.top+window.pageYOffset+p+(b?b.offsetHeight:0),n=r.left+window.pageXOffset+("layout-left"===e?c:0)+(_?_.offsetWidth:0)+("layout-right"===e?i.$.itemsContainer.offsetWidth-a-g:0);break;case"layout-top":case"layout-bottom":i.getShadowRootOrBody().contains(i._snapFeedback)&&void 0===i._snapFeedback.maxHeight&&(i._snapFeedback.maxHeight=parseFloat(getComputedStyle(i._snapFeedback).getPropertyValue("max-height"))||0),o=.07*i.$.itemsContainer.offsetHeight-(p+h),i._snapFeedback.maxHeight&&(o=Math.min(i._snapFeedback.maxHeight,o)),a=i.$.itemsContainer.offsetWidth-(c+g),s=r.top+window.pageYOffset+(b?b.offsetHeight:0)+("layout-bottom"===e?i.$.itemsContainer.offsetHeight-o+p:p),n=r.left+window.pageXOffset+c+(_?_.offsetWidth:0)}i._snapFeedback.style.height=o+"px",i._snapFeedback.style.width=a+"px",i._snapFeedback.style.left=n+"px",i._snapFeedback.style.top=s+"px",i._snapFeedback._position||(i._dragDetails.hoveredTabArea=void 0),i._snapFeedback&&!i.getShadowRootOrBody().contains(i._snapFeedback)&&i.getShadowRootOrBody().appendChild(i._snapFeedback)}_handleItemNesting(){const e=this;let t=e._dragDetails.windowFeedback;if(t.classList.contains("smart-tabs-window-feedback")){let i=document.createElement("smart-tabs-window");const a=e._dragDetails.selectedTabLabel.tab;i.min=30,i.opened=i.pinned=!0,i.headerPosition=e._dragDetails.selectedTabsWindow.headerPosition,i.tabCloseButtons=e._dragDetails.selectedTabsWindow.tabCloseButtons,e._dragDetails.selectedTabsWindow.autoHide?(i.tabTextOrientation=e._dragDetails.selectedTabsWindow._originalTextOrientation||"horizontal",i.tabPosition=e._dragDetails.selectedTabsWindow._originalTabPosition||"top"):(i.tabPosition=e._dragDetails.selectedTabsWindow.tabPosition,i.tabTextOrientation=e._dragDetails.selectedTabsWindow.tabTextOrientation),i.animation=e.animation,i.rightToLeft=e.rightToLeft,i.theme=e.theme,e._snapFeedback._position.indexOf("top")>-1||e._snapFeedback._position.indexOf("bottom")>-1?i.size=parseFloat(t.style.height)||t.offsetHeight:i.size=parseFloat(t.style.width)||t.offsetWidth,i.label=a.label,i.id="",e._dragDetails.windowFeedback.removeChild(a),i.appendChild(a),i.style.left=i.style.top="",i.draggable=void 0===a.draggable||a.draggable,i.floatable=void 0===a.floatable||a.floatable,t=i}else{const i=t.context;t.context=t,t.windowParent=null,t.context=i,t.animation=e.animation,t.rightToLeft=e.rightToLeft,t.theme=e.theme,e._snapFeedback._position.indexOf("top")>-1||e._snapFeedback._position.indexOf("bottom")>-1?t.size=parseFloat(t.style.height)||t.offsetHeight:t.size=parseFloat(t.style.width)||t.offsetWidth,t.style.top=t.style.left=t.style.width=t.style.height="",t.pinned=!0,t.locked=t._originalLocked,t._originalTabPosition||(e._dragDetails.selectedTabsWindow.classList.contains("smart-docking-layout-auto-hide-window")?t._originalTabPosition="top":t._originalTabPosition=t.tabPosition)}return e._insert(e._items.indexOf(e._dragDetails.hoveredTabsWindow),t,e._snapFeedback._position),e._disownTabWindow(t),t}_handleWindowOnDrag(){const e=this;if(e._dragDetails.windowFeedback.hasAttribute("dragged"))return;let t=e._dragDetails.selectedItem,i=e._dragDetails.selectedTabsWindow,a=i.closest("smart-splitter");if(e._setWindowFeedbackSize(),i!==e.$.autoHideWindow||e._dragDetails._parentInfo){if(a&&a!==e.$.itemsContainer&&1===a._items.length)for(;1===a._items.length&&a!==e.$.itemsContainer;)a=a.parentElement.closest("smart-splitter"),t=t.parentElement.closest("smart-splitter-item");if(!e._dragDetails._parentInfo)if(e._dragDetails._parentInfo={},i.closest("smart-docking-layout")===e||e._getClosestDockingLayout(i)===e){if(i.autoHide)e._dragDetails._parentInfo.closestItem=e.$.itemsContainer,e._dragDetails._parentInfo.position=i.tabPosition,i._originalTabPosition&&(i.tabPosition=i._originalTabPosition),i._originalTextOrientation&&(i.tabTextOrientation=i._originalTextOrientation);else if(a){const i=a._items.indexOf(t);1===a._items.length?(e._dragDetails._parentInfo.position="horizontal"===a.orientation?"top":"left",e._dragDetails._parentInfo.closestItem=void 0):(0===i?(e._dragDetails._parentInfo.position="horizontal"===a.orientation?"top":"left",e._dragDetails._parentInfo.closestItem=a._items[i+1].getElementsByTagName("smart-tabs-window")[0]):(e._dragDetails._parentInfo.position="horizontal"===a.orientation?"bottom":"right",e._dragDetails._parentInfo.closestItem=a._items[i-1].getElementsByTagName("smart-tabs-window")[0]),e._dragDetails._parentInfo.closestItemSize=e._dragDetails._parentInfo.closestItem[a._measurements.size],a!==e._dragDetails._parentInfo.closestItem.closest("smart-splitter")?a===e.$.itemsContainer?e._dragDetails._parentInfo.position="layout-"+e._dragDetails._parentInfo.position:e._dragDetails._parentInfo.position="outside-"+e._dragDetails._parentInfo.position:2===a._items.length&&(e._dragDetails._parentInfo.position="inside-"+e._dragDetails._parentInfo.position))}}else e._dragDetails._parentInfo.position={top:i.offsetTop,left:i.offsetLeft}}else e._dragDetails._parentInfo={},i._tabsWindow.items.length>1?(e._dragDetails._parentInfo.closestItem=i._tabsWindow,e._dragDetails._parentInfo.position=e.$.autoHideWindow._tab.index):(e._dragDetails._parentInfo.closestItem=e.$.itemsContainer,e._dragDetails._parentInfo.position=i._tabsWindow.tabPosition,e._dragDetails.windowFeedback.headerButtons=e.$.autoHideWindow._tabsWindow.headerButtons,e._noStateChangeFiring=!0,e.undock(e._dragDetails.windowFeedback)),e._originalTabIndex=void 0;if(a)e._dragDetails.windowFeedback.size=e._dragDetails.windowFeedback[a._measurements.size];else if(i===e.$.autoHideWindow){const t=e.$.autoHideWindow._tabsWindow.tabPosition;e._dragDetails.windowFeedback.size=e.$.autoHideWindow["offset"+("top"===t||"bottom"===t?"Height":"Width")]}e._dragDetails.windowFeedback.setAttribute("dragged",""),e._dragDetails.windowFeedback.parentElement!==e.getShadowRootOrBody()&&(e._dragDetails.windowFeedback.windowParent="body",e.getShadowRootOrBody().appendChild(e._dragDetails.windowFeedback),e._ownTabWindow(e._dragDetails.windowFeedback)),("advanced"!==e.snapMode&&"none"===e._dragDetails.windowFeedback.tabPosition||e._dragDetails.windowFeedback.autoHide)&&(e._dragDetails.windowFeedback.tabPosition=e._dragDetails.windowFeedback._originalTabPosition||"top"),e._dragDetails.windowFeedback.autoHide=!1,e._dragDetails.windowFeedback.allowToggle=!1;const o=e._items.indexOf(e._dragDetails.windowFeedback);if(o>-1&&e._items.splice(o,1),t&&t.parentElement){if(0!==e._items.filter((e=>e.opened)).length||e.$.placeholderItem.parentElement||(e.$.itemsContainer._items[0].className.indexOf("auto-hide")>-1?e.$.itemsContainer.insert(1,e.$.placeholderItem):e.$.itemsContainer.insert(0,e.$.placeholderItem)),a){if(a.removeChild(t),a===e.$.itemsContainer){const e=a.querySelectorAll("smart-splitter");for(let t=0;t<e.length;t++)"vertical"===e[t].orientation&&e[t].refresh()}e._dragDetails.initialSplitterOrientation="horizontal"===a.orientation,e._removeUnneccessaryItems(a)}else i===e.$.autoHideWindow&&0===e.$.autoHideWindow._tabsWindow.items.length&&e.$.autoHideWindow._tabsWindow.closest("smart-splitter").removeChild(t);e._setAutoHidePaddings()}}_setWindowFeedbackSize(){const e=this,t=e._dragDetails.selectedTabsWindow;if(!e._dragDetails._isWindowFeedbackSizeSet){let i,a;t.autoHide&&t._autoHideWindow?"top"===t.tabPosition||"bottom"===t.tabPosition?(i=t.offsetWidth+"px",a=t._autoHideWindow.offsetHeight+"px"):(i=t._autoHideWindow.offsetWidth+"px",a=t.offsetHeight+"px"):(i=t.style.width||t.offsetWidth+"px",a=t.style.height||t.offsetHeight+"px"),e._dragDetails.windowFeedback.style.width=i,e._dragDetails.windowFeedback.style.height=a,e._dragDetails._isWindowFeedbackSizeSet=!0}}_insert(e,t,i){const a=this;let o;if("string"==typeof e?(o=a._getItemById(t),o&&(e=a._items.indexOf(o))):e instanceof Smart.TabsWindow&&a.contains(e)&&(e=a._items.indexOf(e)),"number"!=typeof e)return void a.error(a.localize("invalidIndex",{elementType:a.nodeName.toLowerCase(),method:arguments[3]||"insert"}));if("object"!=typeof t||t instanceof HTMLElement){if("string"==typeof t)t=a._getItemById(t);else if(t instanceof Smart.TabItem){let e=t.closest("smart-tabs-window");if(!e&&a.shadowRoot&&t.getRootNode()&&t.getRootNode().host&&(e=t.getRootNode().host.closest("smart-tabs-window")),e&&e.autoHide)return void a._dock(e,i);t=a._createTabsWindowFromObject({label:t.label,items:[{label:t.label,content:t.content}]})}}else t=a._createTabsWindowFromObject(t);if(!(t&&t instanceof Smart.TabsWindow))return void a.error(a.localize("invalidNode",{elementType:a.nodeName.toLowerCase(),method:arguments[3]||"insert"}));if((a.shadowRoot||a).contains(t)&&t.autoHide)return void a._dock(t,i);if(i&&i.indexOf("layout")>-1){const t=a._items.filter((e=>e.opened));e=t>0?i.indexOf("left")>-1||i.indexOf("top")>-1?0:t[t.length-1]:0}o=a._items[e],a._items[e]&&!a._items[e].opened&&(o=a._items.filter((e=>e.opened))[0]),0===a._items.length&&(a.$.itemsContainer.orientation=i.indexOf("left")>-1||i.indexOf("right")>-1?"vertical":"horizontal"),t.style.top=t.style.left="",t.style.width=t.style.height="",t.opened=!0,t.pinned=!0;const s=t.closest("smart-splitter-item");if(o){if(delete t._parentInfo,t.autoHide&&(a.$.verticalHiddenItemsContainer.contains(t)?a.$.verticalHiddenItemsContainer.removeChild(t.closest("smart-splitter-item")):a.$.horizontalHiddenItemsContainer.contains(t)&&a.$.horizontalHiddenItemsContainer.removeChild(t.closest("smart-splitter-item"))),i?a._handleItemPositionInserting(t,o,i):a.insertBefore(t,o||null),s){const e=s.closest("smart-splitter");e&&e.removeChild(s)}if(t.autoHide)a._autoHide(t,i);else{const e=document.scrollingElement||document.documentElement,i=e.scrollLeft,a=e.scrollTop;t.focus(),window.scrollTo(i,a)}a._items.filter((e=>e.opened)).length>0&&a.$.placeholderItem.parentElement&&a.$.itemsContainer.removeChild(a.$.placeholderItem),t.layout=a,t.resizeMode="none",t.minimized=!1,t.maximized=!1,a._setDockedItemsHeaderButtons(t)}else if(a.insertBefore(t,o||null),s){let e=s.closest("smart-splitter");!e&&a.shadowRoot&&s.getRootNode()&&s.getRootNode().host&&(e=s.getRootNode().host.closest("smart-splitter")),e&&e.removeChild(s)}}_itemsContainerCloseHandler(e){const t=this;if(e.target instanceof Smart.Tabs){const i=e.target;return void(0===i._tabs.length&&t.removeChild(i.closest("smart-tabs-window")))}if(!(e.target instanceof Smart.TabsWindow))return;const i=e.target.closest("smart-splitter-item"),a=i.closest("smart-splitter");a&&(a.removeChild(i),t._removeUnneccessaryItems(a)),e.target.close(),e.target.remove(),0!==t._items.filter((e=>e.opened)).length||t.$.placeholderItem.parentElement||t.$.itemsContainer.appendChild(t.$.placeholderItem)}_itemsContainerAutoHideHandler(e){const t=this,i=e.detail.button,a=i.closest("smart-tabs-window")||i.getRootNode().host;if(!a)return;const o=a.closest("smart-splitter-item");if(!o)return;const s=a.closest("smart-splitter");if(!s)return;const n=s.items,d="horizontal"===s.orientation,l=n.indexOf(o)>=n.length/2;d?l?t.autoHideBottom(a):t.autoHideTop(a):l?t.autoHideRight(a):t.autoHideLeft(a)}_itemsContainerMenuHandler(e){const t=this,i=t.$.menu,a=t.getBoundingClientRect(),o=e.detail.button.getBoundingClientRect();i.open(o.left-a.left,o.top-a.top),t._menuOpenButton=e.detail.button}_itemsContainerResizeHandler(){const e=event.target._items?event.target._items[event.detail.firstItem.index]:void 0;this._handleAutoSave(),this.$.fireEvent("stateChange",{type:"resize",item:e})}_keyDownHandler(e){const t=this;if(!t.disabled&&t.hasAttribute("dragged")&&t._snapFeedback)if(e.preventDefault(),"Control"===e.key)if("advanced"===t.snapMode){for(let e in t._snapFeedback)if(t._snapFeedback[e]instanceof HTMLElement){if("outherSnapElement"===e){const e=t.$.container.children;for(let t=0;t<e.length;t++)e[t].className.indexOf("smart-docking-layout-snap")>-1&&e[t].classList.add("smart-hidden");continue}t._snapFeedback[e].classList.add("smart-hidden")}}else t._snapFeedback.classList.add("smart-hidden");else"Escape"===e.key&&t._cancelDragOperation()}_keyUpHandler(e){const t=this;if(!t.disabled&&"Control"===e.key&&t.hasAttribute("dragged")&&t._snapFeedback)if(e.preventDefault(),"advanced"===t.snapMode){for(let e in t._snapFeedback)if(t._snapFeedback[e]instanceof HTMLElement){if("outherSnapElement"===e){const e=t.$.container.children;for(let t=0;t<e.length;t++)e[t].className.indexOf("smart-docking-layout-snap")>-1&&e[t].classList.remove("smart-hidden");continue}t._snapFeedback[e].classList.remove("smart-hidden")}t._handleSnapping()}else t._snapFeedback.classList.remove("smart-hidden")}_loadState(e){this._createItemsFromArray(e,!0)}_removeAll(e){const t=this;function i(e){const t=e._items;if(t)for(let i=0;i<t.length;i++)t[i].$.hasClass("smart-docking-layout-item-holder")||e.removeChild(t[i])}t.$.itemsContainer.removeAll(),i(t.$.horizontalHiddenItemsContainer),i(t.$.verticalHiddenItemsContainer),t._items=[],e||t.$.itemsContainer.appendChild(t.$.placeholderItem)}_removeUnneccessaryItems(e){if(!e)return;const t=this;let i;for(;e._items&&0===e._items.length&&e!==t.$.itemsContainer;)(i=e.closest("smart-splitter-item")).removeChild(e),(e=i.closest("smart-splitter")).removeChild(i)}_returnItemToOrigin(e){const t=this;if(!e||!t._dragDetails)return;let i=t._dragDetails._parentInfo;if(i)if("number"==typeof i.position){const t=[].slice.call(e.items);for(let a=0;a<t.length;a++)e.removeChild(t[a]),i.closestItem.insert(i.position,{node:t[a]})}else"object"==typeof i.position?(e.style.top=i.position.top+"px",e.style.left=i.position.left+"px"):i.closestItem?i.closestItem===t.$.itemsContainer?t._autoHide(e,i.position):t._insert(t._items.indexOf(i.closestItem),e,i.position):t.appendChild(e)}_setAutoHidePaddings(){const e=this,t=e.$.verticalHiddenItemsContainer.getElementsByClassName("auto-hide-left")[0],i=e.$.verticalHiddenItemsContainer.getElementsByClassName("auto-hide-right")[0],a=e.$.horizontalHiddenItemsContainer.getElementsByClassName("auto-hide-top")[0],o=e.$.horizontalHiddenItemsContainer.getElementsByClassName("auto-hide-bottom")[0];a&&(a.style.paddingLeft=t?t.offsetWidth+"px":"",a.style.paddingRight=i?i.offsetWidth+"px":""),o&&(o.style.paddingLeft=t?t.offsetWidth+"px":"",o.style.paddingRight=i?i.offsetWidth+"px":"")}_setDockedItemsHeaderButtons(e){let t=e.headerButtons,i=["close","maximize","minimize"],a=t.filter((e=>i.indexOf(e)<0));a=0===a.length?["close","autoHide"]:t,e.headerButtons=a}_setFloatingItemsHeaderButtons(e){const t=this._dragDetails,i=["close","autoHide"];t&&t.selectedTabsWindow&&t.selectedTabsWindow.classList.contains("smart-docking-layout-auto-hide-window")?e._originalTabPosition="top":e._originalTabPosition=e.tabPosition;let a=e.headerButtons.filter((e=>i.indexOf(e)<0));a=0===a.length?["close","maximize","minimize"]:e.headerButtons,e.headerButtons=a}_setFocusable(){const e=this;if(e.disabled||e.unfocusable)e.removeAttribute("tabindex");else{let t=e.tabIndex>0?e.tabIndex:0;e.setAttribute("tabindex",t)}}_setSnappingMarkers(e,t){const i=this;let a=Smart.Utilities.Core.isMobile?document.elementFromPoint(e.pageX-window.pageXOffset,e.pageY-window.pageYOffset):e.originalEvent.target,o=a.closest&&a.closest("smart-docking-layout");if((a.shadowRoot||i.isInShadowDOM)&&(a=e.originalEvent.composedPath()[0]),o||(o=i._getClosestDockingLayout(a)),"advanced"===i.snapMode){if(e.ctrlKey)return;return i._dragDetails.hoveredItem=a.closest(".smart-docking-layout-snap")?a:i._dragDetails.hoveredItem&&i._dragDetails.hoveredItem.getElementsByTagName("smart-splitter").length>0?void 0:i._dragDetails.hoveredItem,i._dragDetails.hoveredTabArea=t?a.closest(".smart-tab-label-container")||t:i._dragDetails.hoveredTabArea,void i._handleSnapping("",e)}if(!o||o!==i)return void i._handleSnapping();if(!i._dragDetails.hoveredTabsWindow||i._dragDetails.windowFeedback!==i.$.tabsWindowFeedback&&i._dragDetails.hoveredTabsWindow===i._dragDetails.selectedTabsWindow)return i._dragDetails.hoveredItem=a.closest(".smart-docking-layout-snap")?a:i._dragDetails.hoveredItem&&i._dragDetails.hoveredItem.getElementsByTagName("smart-splitter").length>0?void 0:i._dragDetails.hoveredItem,void i._handleSnapping();let s={};if(i._dragDetails.hoveredItem){const e=i._dragDetails.hoveredItem.getBoundingClientRect(),t=i.$.itemsContainer.getBoundingClientRect();s.left=i._dragDetails.hoveredItem?e.left-t.left:0,s.top=i._dragDetails.hoveredItem?e.top-t.top:0}else s.left=s.top=0;const n=i.getBoundingClientRect(),d=i.$.itemsContainer.getBoundingClientRect(),l=Math.max(0,e.pageX-window.pageXOffset-n.left-(d.left-n.left)),r=Math.max(0,e.pageY-window.pageYOffset-n.top-(d.top-n.top));if(i._dragDetails.hoveredTabArea===t)i._dragDetails.hoveredTabArea=a.closest(".smart-tab-label-container"),i._handleSnapping("header",e);else if(i._dragDetails.hoveredItem&&!i._dragDetails.hoveredTabsWindow.autoHide)if(l<.05*i.$.itemsContainer.offsetWidth&&l<.15*i._dragDetails.hoveredItem.offsetWidth)i._handleSnapping("layout-left");else if(l>.95*i.$.itemsContainer.offsetWidth&&l>.85*i._dragDetails.hoveredItem.offsetWidth+i._dragDetails.hoveredItem.offsetLeft)i._handleSnapping("layout-right");else if(r<.05*i.$.itemsContainer.offsetHeight)i._handleSnapping("layout-top");else if(r>.95*i.$.itemsContainer.offsetHeight)i._handleSnapping("layout-bottom");else if(a.closest(".smart-tabs-content-section")){const e=i._dragDetails.hoveredItem.closest("smart-splitter").orientation;l<s.left+.3*i._dragDetails.hoveredTabArea.offsetWidth?i._handleSnapping("horizontal"===e?"inside-left":"left"):l>s.left+.7*i._dragDetails.hoveredTabArea.offsetWidth?i._handleSnapping("horizontal"===e?"inside-right":"right"):r<s.top+i._dragDetails.hoveredTabArea.offsetTop+.5*i._dragDetails.hoveredTabArea.offsetHeight+i._dragDetails.hoveredTabsWindow.$.headerSection.offsetHeight?i._handleSnapping("vertical"===e?"inside-top":"top"):i._handleSnapping("vertical"===e?"inside-bottom":"bottom")}else i._handleSnapping();else i._handleSnapping()}_setSplitterBarVisibility(){const e=this,t=e.$.itemsContainer.getElementsByTagName("smart-splitter-bar");for(let i=0;i<t.length;i++)e.hideSplitterBars?t[i].hide():t[i].show()}_validateWindowPosition(e){e.$.addClass("no-transition","");const t=document.scrollingElement||document.documentElement;t.scrollTop>0?e.style.top=(parseFloat(e.style.top)||e.offsetTop)+"px":e.style.top=Math.max(0,Math.min(parseFloat(e.style.top)||e.offsetTop,document.documentElement.clientHeight-e.offsetHeight))+"px",t.scrollLeft>0?e.style.left=(parseFloat(e.style.left)||e.offsetLeft)+"px":e.style.left=Math.max(0,Math.min(parseFloat(e.style.left)||e.offsetLeft,document.documentElement.clientWidth-e.offsetWidth))+"px",requestAnimationFrame((()=>e.$.removeClass("no-transition")))}_ownTabWindow(e){const t=this,i=e.id;let a=t.getAttribute("aria-owns");a?(a=a.split(" "),-1===a.indexOf(i)&&(a.push(i),t.setAttribute("aria-owns",a.join(" ")))):t.setAttribute("aria-owns",i)}_disownTabWindow(e){const t=this,i=e.id;let a=t.getAttribute("aria-owns");if(!a)return;a=a.split(" ");const o=a.indexOf(i);-1!==o&&(a.splice(o,1).join(" "),a.length>0?t.setAttribute("aria-owns",a):t.removeAttribute("aria-owns"))}_resizeHandler(){const e=this;e.$.autoHideWindow.opened&&e.$.autoHideWindow._tabsWindow&&e.$.autoHideWindow._tabsWindow._setAutoHideWindowSize(e.$.autoHideWindow._tabsWindow.selectedIndex)}});