
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-editor",class extends Smart.ContentElement{static get properties(){return{autoLoad:{value:!1,type:"boolean"},autoSave:{value:!1,type:"boolean"},autoSaveInterval:{value:1e3,type:"number"},autoExpand:{value:!1,type:"boolean"},charCountFormatFunction:{value:null,type:"function?"},contentFiltering:{value:{attributes:{value:[],type:"array"},attributeFilterMode:{allowedValues:["blackList","whiteList"],value:"blackList",type:"string"},tags:{value:[],type:"array"},tagFilterMode:{allowedValues:["blackList","whiteList"],value:"blackList",type:"string"},styleAttributes:{value:[],type:"array"},styleAttributeFilterMode:{allowedValues:["blackList","whiteList"],value:"blackList",type:"string"}},type:"object"},contextMenu:{allowedValues:["default","browser","none"],value:"default",type:"string"},contextMenuDataSource:{value:null,type:"any",reflectToAttribute:!1},dataExport:{value:{style:{value:null,type:"object"},fileName:{value:"smartEditor",type:"string?"},pageOrientation:{value:"portrait",type:"string"}},type:"object"},disableEditing:{value:!1,type:"boolean"},disableSearchBar:{value:!1,type:"boolean"},editMode:{allowedValues:["html","markdown"],value:"html",type:"string"},enableHtmlEncode:{value:!1,type:"boolean"},enableTabKey:{value:!1,type:"boolean"},findAndReplaceTimeout:{value:50,type:"number"},hideToolbar:{value:!1,type:"boolean"},hideInlineToolbar:{value:!1,type:"boolean"},imageFormat:{allowedValues:["blob","base64"],value:"base64",type:"string"},imageName:{value:"userfile[]",type:"string"},innerHTML:{type:"string",validator:"_sanitize",reflectToAttribute:!1},inlineToolbarOffset:{value:[0,-5],type:"array"},iframeSettings:{value:{attributes:{value:null,type:"object?"},enabled:{value:!1,type:"boolean"},resources:{value:null,type:"object?"}},type:"object"},maxCharCount:{value:null,type:"number?"},messages:{extend:!0,value:{en:{invalidValue:"{{elementType}}: Invalid {{property}} value. {{property}} should be of type {{typeOne}} or {{typeTwo}}.",incorrectArgument:"{{elementType}}: Incorrect argument {{argumentName}} in method {{methodName}}.",permissionsRequired:"{{elementType}}: Permissions are required for the following action {{actionName}}.",timeout:"{{elementType}}: The import request has timed out.",importError:"{{elementType}}: The import request errored with the following status: {{status}}.",exportError:"{{elementType}}: The Export request errored with the following status: {{status}}.",ok:"Ok",cancel:"Cancel",alignLeft:"Align Left",alignCenter:"Align Center",alignRight:"Align Right",alignJustify:"Align Justify",segoeUi:"Segoe UI",arial:"Arial",georgia:"Georgia",impact:"Impact",tahoma:"Tahoma",timesNewRoman:"Times New Roman",verdana:"Verdana",p:"Paragraph",pre:"Code",code:"Code",blockquote:"Quotation",h1:"Heading 1",h2:"Heading 2",h3:"Heading 3",h4:"Heading 4",h5:"Heading 5",h6:"Heading 6",bold:"Bold",italic:"Italic",underline:"Underline",strikethrough:"Strikethrough",orderedlist:"Ordered List",unorderedlist:"Unordered List",subscript:"Subscript",superscript:"Superscript",alignment:"Alignments",fontname:"Font Name",fontsize:"Font Size",formats:"Formats",backgroundcolor:"Background Color",fontcolor:"Font Color",redo:"Redo",undo:"Undo",indent:"Indent",outdent:"Outdent",createlink:"Hyperlink",hyperlink:"Hyperlink",editlink:"Hyperlink",removelink:"Remove link",openlink:"Open link",image:"Image",video:"Video",table:"Table",lowercase:"Lower Case",uppercase:"Upper Case",print:" Print",cut:" Cut",copy:" Copy",paste:" Paste",clearformat:"Clear Format",fullscreen:"Full Screen",restore:"Restore Screen",sourcecode:"Source Code",preview:"Preview",splitmode:"Split Editor",address:"Web Address",text:"Display Text",addressPlaceholder:"http://example.com",textPlaceholder:"Enter Text",targetPlaceholder:"Select Target",titlePlaceholder:"Enter a Title",urlPlaceholder:"http://example.com/image.png",srcPlaceholder:"https://www.youtube.com/embed/video_link",thumbnail:"Or provide a URL as a video thumbnail",thumbnailPlaceholder:"https://www.link-to-thumbnail.jpg",videoUrl:"Video URL",videoUrlPlaceholder:"https://www.youtube.com/video_link",captionPlaceholder:"Caption",altPlaceholder:"Alternative Text",widthPlaceholder:"auto",heightPlaceholder:"auto",target:"Open Link in",linkBlankDescr:"New Window",linkSelfDescr:"Same Window",linkParentDescr:"Parent Frame",linkTopDescr:"Full Body of the Window",linkCustomDescr:"Custom Frame Name",title:"Title",url:"Or provide the URL to an image",src:"Or provide the URL to an embed video",width:"Width",height:"Height",alt:"Alternative Text",caption:"Caption",display:"Display",displayPlaceholder:"Display",displayBlock:"Block",displayInline:"Inline",draggable:"Enable Dragging",resizable:"Enable Resizing",browse:"Browse",connectionError:"{{elementType}}: File Upload requires connection to the server.",wrongItemIndex:"{{elementType}}: There is no file with such an index in the list of uploaded files.",tooLongFileName:"{{elementType}}: File name is too long.",totalFiles:"Total files: ",cancelFile:"Cancel File",dashedborders:"Dashed Borders",altrows:"Alternate Rows",insertRowBefore:"Insert Row Before",insertRowAfter:"Insert Row After",deleteRow:"Delete Row",insertColumnLeft:"Insert Column Left",insertColumnRight:"Insert Column Right",deleteColumn:"Delete Column",alignTop:"Align Top",alignMiddle:"Align Middle",alignBottom:"Align Bottom",delete:"Delete",tablerows:"Table Rows",tablecolumns:"Table Columns",tablevalign:"Table Cell Vertical Align",tablestyle:"Table Style",tableheader:"Table Header",buttonLabel:"Custom Table",pasteLabel:"Choose the paste format action:",cols:"Columns",rows:"Rows",alphabet:"abcdefghijklmnopqrstuvwxyz",header:"Header",column:"Column",plainText:"Plain Text",keepFormat:"Keep Format",cleanFormat:"Clean Format",roleDescription:"Text Editor",iframeTitle:"Editor Content is Encloused in it's own DOM inside an iFrame",toolbarButtonAriaLabel:"Toolbar Toggle Button",primaryToolbarAriaLabel:"Primary Toolbar",secondaryToolbarAriaLabel:"Secondary Toolbar",inputAriaLabel:"Enter Text",homeTab:"Home",viewTab:"View",insertTab:"Insert",layoutTab:"Layout",undoGroup:"Undo",clipboardGroup:"Clipboard",fontGroup:"Font",paragraphGroup:"Paragraph",editingGroup:"Editing",tableGroup:"Tables",imageGroup:"Images",videoGroup:"Videos",linkGroup:"Links",viewsGroup:"Views",deleteGroup:"Delete",findandreplace:"Find and Replace",requiredMessage:"The content of the Editor cannot be empty",tableProperties:"Table Properties",imageProperties:"Image Properties",videoProperties:"Video Properties",linkProperties:"Link Properties",selectAll:"Select All",deleteTable:"Delete Table",deleteImage:"Delete Image",deleteVideo:"Delete Video",createLink:"Create Link",deleteLink:"Delete Link",copyImage:"Copy",cutImage:"Cut",copyVideo:"Copy",cutVideo:"Cut",find:"Find",findPlaceholder:"",replace:"Replace",replaceWith:"Replace With",replaceAll:"Replace All",replacePlaceholder:"",results:"Results",resultsPlaceholder:"No match",matchCase:"Match Case",searchPlaceholder:"Search..."}}},name:{value:null,type:"string?"},pasteFormat:{allowedValues:["prompt","plainText","keepFormat","cleanFormat"],value:"keepFormat",type:"string"},postData:{value:null,type:"object"},placeholder:{value:"",type:"string"},removeStylesOnClearFormat:{value:!1,type:"boolean"},required:{value:!1,type:"boolean"},sanitized:{value:!1,type:"boolean"},showCharCount:{value:!1,type:"boolean"},splitModeRefreshTimeout:{value:100,type:"number"},toolbarItems:{value:["bold","italic","underline","|","formats","alignment","orderedList","unorderedList","|","hyperlink","image","video","|","sourceCode","undo","redo"],reflectToAttribute:!1,type:"array"},toolbarMode:{allowedValues:["menu","singleLineRibbon"],value:"menu",type:"string"},toolbarRibbonConfig:{value:[{name:"homeTab",groups:[{name:"undoGroup",items:["undo","redo"]},{name:"clipboardGroup",items:["cut","copy","paste"]},{name:"fontGroup",items:["fontName","fontSize","backgroundColor","fontColor","clearFormat","formats","bold","italic","underline","strikethrough","superscript","subscript"]},{name:"paragraphGroup",items:["orderedList","unorderedList","indent","outdent","alignment"]},{name:"editingGroup",items:["findAndReplace"]}]},{name:"insertTab",groups:[{name:"tableGroup",items:["table"]},{name:"imageGroup",items:["image"]},{name:"videoGroup",items:["video"]},{name:"linkGroup",items:["createLink","removeLink"]}]},{name:"viewTab",groups:[{name:"viewsGroup",items:["fullScreen","sourceCode","splitMode"]}]},{name:"layoutTab",hidden:!0,groups:[{name:"deleteGroup",items:["delete"]},{name:"tableGroup",items:["table","tableHeader","tableRows","tableColumns","tableVAlign","tableStyle",""]},{name:"imageGroup",items:["image","caption"]},{name:"videoGroup",items:["video","caption"]}]}],type:"array"},toolbarViewMode:{allowedValues:["toggle","multiRow","scroll"],value:"toggle",type:"string"},toolbarSticky:{value:!1,type:"boolean"},spellCheck:{value:!0,type:"boolean"},value:{value:"",type:"string",validator:"_sanitize",reflectToAttribute:!1},validateFile:{value:null,type:"function?",reflectToAttribute:!1},uploadUrl:{value:"",type:"string",reflectToAttribute:!1},removeUrl:{value:"",type:"string",reflectToAttribute:!1},onImageRemove:{value:null,type:"function?"},autoUpload:{value:!0,type:"boolean"},windowCustomizationFunction:{value:null,reflectToAttribute:!1,type:"function?"}}}static get listeners(){return{"document.down":"_documentDownHandler","document.move":"_documentMoveHandler","document.up":"_documentUpHandler","document.dragstart":"_dragStartHandler","document.selectstart":"_selectStartHandler","document.selectionchange":"_selectionChangeHandler","container.dragend":"_dragEndHandler","container.drop":"_dropHandler","container.change":"_changeHandler","container.beforeinput":"_beforeInputHandler","container.input":"_afterInputHandler","contentContainer.contextmenu":"_contextMenuHandler","contentContainer.keydown":"_editableElementKeyDownHandler","contentContainer.keyup":"_updateOnInputChange","contentContainer.paste":"_updateOnInputChange","input.focus":"_editableElementFocusHandler","input.blur":"_editableElementBlurHandler","input.change":"_inputChangeEvent","editableElement.focus":"_editableElementFocusHandler","editableElement.blur":"_editableElementBlurHandler","editableElement.wheel":"_editableElementWheelHandler","editableElement.move":"_editableElementMoveHandler",touchmove:"_touchmoveHandler",resize:"_resizeHandler"}}static get requires(){return{"Smart.Button":"smart.button.js","Smart.Window":"smart.window.js","Smart.Tooltip":"smart.tooltip.js"}}static get styleUrls(){return["smart.editor.css"]}template(){return'<div id="container" role="presentation">\n                    <div id="toolbar" class="smart-editor-toolbar" role="presentation">\n                        <div id="toolbarItemsPrimary" class="smart-editor-toolbar-items-primary" role="toolbar"></div>\n                        <div id="toolbarToggleButton" class="smart-editor-toolbar-toggle-button" role="button"></div>\n                        <div id="toolbarItemsSecondary" class="smart-editor-toolbar-items-secondary" role="toolbar"></div>\n                    </div>\n                    <div id="contentContainer" class="smart-editor-content-container" role="presentation">\n                        <div class="smart-editor-editable" contenteditable="true" id="editableElement" aria-placeholder="[[placeholder]]"\n                        inner-h-t-m-l="[[innerHTML]]" spellcheck="[[spellCheck]]" role="textbox" aria-multiline="true"><content></content></div>\n                        <textarea name="[[name]]" id="input" class="smart-hidden" placeholder="[[placeholder]]" aria-placeholder="[[placeholder]]"\n                        spellcheck="[[spellCheck]]" autocapitalize="none" autocomplete="off"></textarea>\n                    </div>\n                </div>'}propertyChangedHandler(e,t,o){const a=this;switch(e){case"contentFiltering":case"contentFiltering_attributes":case"contentFiltering_attributeFilterMode":case"contentFiltering_tags":case"contentFiltering_tagFilterMode":case"contentFiltering_styleAttributes":case"contentFiltering_styleAttributeFilterMode":a._handleContentFiltering();break;case"disabled":case"disableEditing":a.$.input.readonly=o,a.$.editableElement.setAttribute("contenteditable",!o),"disabled"===e&&a._setFocusable();break;case"disableSearchBar":a._closeSearchToolbar();break;case"enableHtmlEncode":{const e=a.$.input;e.classList.contains("smart-hidden")||(e.value=a._getInputValue());break}case"hideToolbar":o&&a._updateToolbarItems(void 0,a.$.toolbar);break;case"innerHTML":case"value":a._handleInputContent(e,o),a.$.fireEvent("change",{oldValue:a._value||t,value:a._value=a._getCurrentValue()});break;case"editMode":a._handleEditMode(o);break;case"hideInlineToolbar":{const e=a.$.inlineToolbar;e&&e.visible&&e.classList.contains("smart-editor-inline-toolbar")&&e.close();break}case"toolbarViewMode":a._toggleToolbar("toggle"===o);break;case"toolbarMode":case"toolbarRibbonConfig":a._handleToolbarMode();break;case"locale":delete a._toolbarItemsObj,delete a._inlineToolbarItemsObj,a._refreshToolbarItems(a._getToolbarItems()),a._closeToolbar(),a._closeWindow();break;case"iframeSettings":a._handleInputElement();break;case"maxCharCount":a._handleMaxCharCount(),a._setCharCount();break;case"name":o&&"markdown"!==a.editMode&&(a.$.input.value=a._getInputValue(a.$.editableElement.innerHTML.trim()));break;case"placeholder":a._handlePlaceholder();break;case"pasteFormat":a._closeWindow();break;case"readonly":a.$.input.readonly=o,a.$.editableElement.setAttribute("contenteditable","markdown"!==a.editMode&&!o),a._closePopups(),a._setResizeFrame(),a._closeWindow();break;case"showCharCount":a._setCharCount();break;case"rightToLeft":case"animation":case"theme":a._updateIframeBody();break;case"toolbarItems":a._handleToolbarItems();break;default:super.propertyChangedHandler(e,t,o)}}_handleToolbarItems(){const e=this,t=e.$.toolbarItemsPrimary,o=e.$.toolbarItemsSecondary;if(t.innerHTML=o.innerHTML="",delete e._toolbarItemsObj,delete e._inlineToolbarItemsObj,e._refreshToolbarItems(e._getToolbarItems()),"toggle"===e.toolbarViewMode){const a=e.$.toolbarToggleButton;t.scrollHeight!==t.offsetHeight||o.children.length?a.classList.remove("smart-visibility-hidden"):a.classList.add("smart-visibility-hidden")}}render(){const e=this,t=()=>0===e.offsetWidth||0===e.offsetHeight,o=()=>{e._isMobile=Smart.Utilities.Core.isMobile,e._isFireFox=Smart.Utilities.Core.Browser.Firefox,e._isSafari=Smart.Utilities.Core.Browser.Safari,e._isMacOS=(window.navigator.platform||"").indexOf("Mac")>-1,e._handleMaxCharCount(),e._handleInputContent(),e._setToolbarVisibility(),e._handleToolbarMode(),e._handleInputElement(),e._handleEditMode(),e._predefPropertyGetter(),e._setCharCount(),e._setFocusable(),e._setAriaSettings(),e.autoExpand&&e.expandToolbar(),e.isInitialized=!0,e.checkLicense()};if(t())return requestAnimationFrame((()=>{e.isInitialized||t()?e._createInterval=setInterval((()=>{e.isInitialized||t()||(o(),clearInterval(e._createInterval))}),100):o()})),void super.render();o(),super.render()}detached(){const e=this;super.detached(),delete e._dragDetails,delete e._resizeFrameObj,delete e._toolbarItemClick,e._endInlineToolbarClick(),e._closeWindow(),e._closeToolbarItemDropDown(e.$.inputPopup),e._closeToolbarItemDropDown(e.$.colorInputPopup),e._closeContextMenu(),e._closeToolbar(),e._handleTableSelection()}focus(){const e=this,t="markdown"===e.editMode?e.$.input:e.$.editableElement;t&&t.focus()}blur(){const e=this,t="markdown"===e.editMode?e.$.input:e.$.editableElement;t&&t.blur()}clearState(){const e=this;e.id?window.localStorage.removeItem("smartEditor"+e.id):e.warn(e.localize("noId"))}collapseToolbar(){this._toggleToolbar(!0)}disableToolbarItem(e){this._setToolbarItemAttr(e,"disabled",!0)}enableToolbarItem(e){this._setToolbarItemAttr(e,"disabled",!1)}expandToolbar(){this._toggleToolbar()}executeCommand(e,t){const o=this,a=o._getCurrentValue();o.$.editableElement.focus();const n=o.$.editableElement.getRootNode().execCommand(e,!1,t),i=o._getCurrentValue();return o.$.fireEvent("change",{value:i,oldValue:a}),n}exportData(e,t){this._handleDataExport(e,t)}importData(e,t){"string"==typeof e&&(e={url:e}),t||(t={}),this._ajax(e,t)}fullScreenMode(e){const t=this;t.$.fireEvent("actionStart",{name:"fullScreenMode"}).defaultPrevented||(t._handleFullScreenMode(t._toggleItem("fullscreen",e)),t.$.fireEvent("actionEnd",{name:"fullScreenMode"}))}getCharCount(){const e=this;if("html"===e.editMode){const t=e.$.editableElement,o=t.textContent.length,a=t.innerText.length;return a&&o?a:0}return e.$.input.value.length}getSelectionRange(){return this._selectionRange}clearContent(){const e=this;e._setResizeFrame(),e.$.editableElement.innerHTML=e.$.input.value=""}getHTML(){const e=this;if("markdown"===e.editMode){const t=e.$.input;return window.marked?window.marked(t.value):t.value}return e.$.editableElement.innerHTML}getText(){const e=this;return"markdown"===e.editMode?e.$.input.value:e.$.editableElement.textContent}loadState(e){const t=this;t.id?(e||(e=window.localStorage.getItem("smartEditor"+t.id)),"string"==typeof e&&(t.set("value",e),t.$.editableElement.innerHTML=t.$.input.value=e)):t.warn(t.localize("noId"))}showMessage(e,t){const o=this;if(!e||!o.isRendered)return;if(!Smart.Toast)return void o.error(o.localize("missingReference",{elementType:o.nodeName.toLowerCase(),methodName:"showMessage",files:"smart.toast.js"}));o._setToast();const a=o.$.toast;if(a){let n;if("object"==typeof t)for(let e in t)"iconType"===e?n=t[e]:a[e]=t[e];if(!o.$.container.contains(a)){const e=o.$toast;o._toastVisibilityHandler||(o._toastVisibilityHandler=e=>{const t=e.type;"close"===e.type&&e.detail.instance===o._requiredMessage&&delete o._requiredMessage,e.stopPropagation(),o.$.fireEvent("message"+t.slice(0,1).toUpperCase()+t.slice(1),e.detail)},e.listen("open",o._toastVisibilityHandler),e.listen("close",o._toastVisibilityHandler)),o.$.container.appendChild(a)}return a.open(e+"",n)}}hideMessage(e){const t=this.$.toast;t&&(void 0===e?t.closeAll():t.closeItem(e))}hideLastMessage(){const e=this.$.toast;e&&e.closeLast()}selectAll(){this._selectAll()}selectRange(e,t){const o=this,a=o.$.editableElement.getRootNode();if(!a)return;e=parseInt(e),t=parseInt(t),e=Math.min(e,t),t=Math.max(e,t);const n=o.$.input,i=o.$.editableElement,r="markdown"===o.editMode||o.$.editableElement.classList.contains("smart-hidden")?n:i,l=o.$.iframe,[s,d]=l?[l.contentWindow,l.contentDocument]:[window,document],c=s.getSelection();let m=a.activeElement;if((!m||m!==n&&m!==i||m.classList.contains("smart-hidden"))&&(r.focus(),m=r),c.removeAllRanges(),delete o._selectionRange,!isNaN(e)&&!isNaN(t)&&e!==t){if(m===n)n.setSelectionRange(e,t),o._selectionRange={selectionStart:e,selectionEnd:t};else{const a=o._getNodes(i,e,t).nodes;for(let e=0,t=a.length;e<t;e+=1){const{node:t,index:n,startIndex:i}=a[e],r=d.createRange();t.nodeType===Node.TEXT_NODE?(r.setStart(t,Math.max(0,i)),r.setEnd(t,Math.min(n,t.nodeValue.length))):r.selectNodeContents(t),c.addRange(r),o._selectionRange=r}}o._updateToolbarItems()}}saveState(){const e=this;e.id?window.localStorage.setItem("smartEditor"+e.id,e.$.editableElement.innerHTML):e.warn(e.localize("noId"))}splitMode(e){const t=this;t.$.fireEvent("actionStart",{name:"splitMode"}).defaultPrevented||(t._handleSplitMode(t._toggleItem("splitmode",e)),t.$.fireEvent("actionEnd",{name:"splitMode"}))}previewMode(e){const t=this;t.$.contentContainer.hasAttribute("split-mode")||t.$.fireEvent("actionStart",{name:"sourcecode"}).defaultPrevented||(t._handleSourceCodeMode(t._toggleItem("sourcecode",e)),t.$.fireEvent("actionEnd",{name:"sourcecode"}))}print(){this._handlePrint()}updateToolbarItem(e,t){const o=this,a=o.toolbarItems;let n;if("string"==typeof e?n=a.find((t=>t.name===e)):"number"==typeof e&&(n=a[e]),n){o._closePopups(),o._closeWindow(),delete o._toolbarItemsObj[n.name],delete o._inlineToolbarItemsObj[n.name];for(let e in t)n[e]=t[e];return o._refreshToolbarItems(o._getToolbarItems()),!0}}_toggleItem(e,t){const o=this._toolbarItemsObj;if(!o)return;const a=o[e],n=this.$.toolbar.querySelector(`.smart-editor-toolbar-item[item-name="${e}"]`);return a&&n?((t=a.value=void 0===t?!a.value:!!t)?(n.setAttribute("checked",""),n.setAttribute("aria-pressed",!0)):(n.removeAttribute("checked"),n.setAttribute("aria-pressed",!1)),n):void 0}_ajax(e,t={}){const o=this;let a="GET",n=e.url,i=null,r=!0;if(e.type&&(a=e.type),e.data)if("GET"===a){n+="?";for(let t in e.data)Object.prototype.hasOwnProperty.call(e.data,t)&&(n+=encodeURI(t+"="+e.data[t]+"&"));"&"===n.charAt(n.length-1)&&(n=n.slice(0,n.length-1))}else"POST"===a&&(i=JSON.stringify(e.data));t&&!1===t.async&&(r=!1),void 0!==window.fetch&&r?o._ajaxFetch(e,t,a,n,i):o._ajaxXMLHttpRequest(e,t,a,n,i,r)}_ajaxFetch(e,t,o,a,n){const i=this,r={method:o};let l,s,d;t&&t.contentType&&(r.headers=new Headers({"Content-Type":t.contentType})),null!==n&&(r.body=n),e.timeout&&(s=setTimeout((function(){d=!0}),e.timeout)),t.beforeSend&&!1===t.beforeSend(r,t)||fetch(a,r).then((function(e){if(d)throw l=408,i.error(i.localize("timeout",{elementType:i.nodeName.toLowerCase()}));if(s&&clearTimeout(s),l=e.status,!e.ok)throw i.error(i.localize("importError",{elementType:i.nodeName.toLowerCase(),status:e.statusText}));return e.text()})).then((e=>i._ajaxComplete(t,e,l))).catch((function(e){t&&t.loadError&&t.loadError(l,e)}))}_ajaxXMLHttpRequest(e,t,o,a,n,i){const r=new XMLHttpRequest,l=this;r.open(o,a,i),r.ontimeout=function(){t&&t.loadError&&t.loadError(408,"timeout")},r.onload=function(){if(4===r.readyState){const o=r.status;let a=r.response;o>=200&&o<=299?("json"===e.dataType&&(a=JSON.parse(a)),l._ajaxComplete(t,a,o)):t&&t.loadError&&t.loadError(o,a)}},r.onerror=function(){t&&t.loadError&&t.loadError(r.status,r.response)},t&&t.contentType&&r.setRequestHeader("Content-Type",t.contentType),i&&e.timeout&&(r.timeout=e.timeout),t.beforeSend&&!1===t.beforeSend(r,t)||r.send(n)}_ajaxComplete(e,t){if(e){if(e.beforeLoadComplete){const o=e.beforeLoadComplete(t);o&&(t=o)}this._handleInputContent("value",t)}}_afterInputHandler(e){const t=this,o=t._beforeInputObj,a=t.$.editableElement,n=!a.innerHTML;let i,r;if(o&&o.type&&(i=o.type,r=o.rangeDetails),delete t._beforeInputObj,n&&(t._setResizeFrame(),t._closeToolbar()),"insertParagraph"===i||n){let e=t._getSelectionRange().startContainer;if(e.nodeType===Node.TEXT_NODE&&(e=e.parentElement),e&&e.classList&&(e.closest(".smart-editor-image-caption")||e.closest(".smart-editor-editable table")))return;const o=t.$.iframe,[i,r]=o?[o.contentWindow,o.contentDocument]:[window,document];("div"===i.getSelection().anchorNode.nodeName.toLowerCase()||e===a&&n)&&r.execCommand("insertHTML",!1,"<p><br></p>")}else if(i&&r&&i.indexOf("delete")>-1){const e=t._resizeFrameObj;e&&e.target&&!a.contains(e.target)&&t._setResizeFrame()}a.textContent.length&&a.innerText.length?a.removeAttribute("show-placeholder"):a.setAttribute("show-placeholder",""),t.name&&e.target===t.$.editableElement&&"markdown"!==t.editMode&&(t.$.input.value=t._getInputValue(t.$.editableElement.innerHTML.trim())),t._setCharCount()}_beforeInputHandler(e){const t=this,o=t.$.iframe,a=t.$.contentContainer,n=t.$.editableElement,i=(o?o.contentWindow:window).getSelection().getRangeAt(0),r=e.inputType,l=i.startContainer;let s;if(r&&(s=r.indexOf("delete")>-1,t._beforeInputObj={type:r,rangeDetails:{startOffset:i.startOffset,endOffset:i.endOffset,startContainer:i.startContainer,endContainer:i.endContainer}}),s&&n.contains(l))if(l===i.endContainer&&i.startOffset===i.endOffset){const e=t._resizeFrameObj;let o=l;if(e&&e.target&&e.target.contains(l))return;if(o.nodeType!==Node.TEXT_NODE&&o.innerHTML.length){if(o===n)return}else{let e=o.parentElement,t=o.previousElementSibling;for(;!t&&e;)t=e.previousElementSibling,e=e.parentElement;n!==t&&n.contains(t)&&!t.innerHTML.length&&t.nodeName}}else i.deleteContents(),e.preventDefault();if(!a.classList.contains("char-count-maxed")||s){if("insertParagraph"===r){const o=t._getSelectionRange().startContainer;if(o.nodeType===Node.TEXT_NODE&&o.parentElement===n){if(-1!==t.$.editableElement.innerHTML.indexOf("<")){const o=document.createElement("p");o.innerHTML="&#8203;";const a=document.createElement("span");a.id="INSERTION_MARKER",a.innerHTML="&nbsp;";let i=t._getSelectionRange(),r=i.endContainer;r.parentElement.insertBefore(o,i.endContainer.nextSibling),r.parentElement.insertBefore(a,o.nextSibling),t.selectRange(i);const l=n.getRootNode().querySelector("#INSERTION_MARKER");return t._setSelectionRange(l.previousElementSibling),i=t._getSelectionRange(),i.collapse(),l.remove(),e.preventDefault&&e.preventDefault(),!1}n.getRootNode().execCommand("formatBlock",!1,"p")}}}else e.preventDefault()}_changeHandler(e){const t=this,o=e.target,a=e.detail,n=o.closest(".smart-editor-toolbar-item");if(e.stopPropagation(),t._toolbarItemsObj||t._inlineToolbarItemsObj)return n&&o===t.$.inputPopup||o===t.$.colorInputPopup?(t._ignoreSelectionChange=!0,t._updateToolbarItem(n,a),void delete t._ignoreSelectionChange):void 0}_contextMenuHandler(e){const t=this,o=t.contextMenu;"browser"!==o?(e.preventDefault(),"none"!==o?t._openContextMenu(e):t._closeContextMenu()):t._closeContextMenu()}_closeContextMenu(){const e=this.$.inlineToolbar,t=this.$.fireEvent("dropDownToolbarClosing",{target:e}).defaultPrevented;e&&e.visible&&e.classList.contains("smart-editor-context-menu")&&!t&&e.close()}_openContextMenu(e){const t=this,o=e.target;let a=t.$.inlineToolbar;if(a||(a=t._createToolbar()),t.$.fireEvent("contextMenuOpening",{target:a}).defaultPrevented)return;t._setupToolbar(o,"context"),a.parentElement||t.getShadowRootOrBody().appendChild(a),a.clear(),t._setContextMenuContent(o);const n=t.getBoundingClientRect();a.style.left=Math.min(e.pageX+1,n.right+window.pageXOffset-a.offsetWidth)+"px",a.style.top=Math.min(e.pageY+1,n.bottom+window.pageYOffset-a.offsetHeight)+"px",a.open()}_setContextMenuContent(e){const t=this;if(!e)return;let o=t._contextList,a=t._getContextMenuTargetType(e),n=t._getContextMenuDataSource(e,a);o||(t._contextList=o=document.createElement("div"),o.classList.add("smart-editor-context-menu-item-container"));const i=document.createDocumentFragment(),r=n.length;let l=o.children;for(;l.length>r;)l[0].remove();l=Array.from(l);for(let o=0;o<r;o++){const r=n[o];let s,d,c=l[o];if("object"==typeof r?(s=r.label,d=r.value):s=d=r+"",c||(c=document.createElement("div"),c.classList.add("smart-editor-context-menu-item"),c.setAttribute("role","option")),c.removeAttribute("disabled"),"deleteLink"!==r||"image"!==a||e.closest(".smart-editor-editable a")){if("cut"===r||"copy"===r){const e=t._getSelectionRange();(void 0!==e.selectionStart?e.selectionStart:e.startOffset)===(void 0!==e.selectionEnd?e.selectionEnd:e.endOffset)&&c.setAttribute("disabled","")}}else c.setAttribute("disabled","");c.parentElement||i.appendChild(c),c.innerHTML=t.localize(s)||s,c.setAttribute("value",d)}o.appendChild(i),t.$.inlineToolbar.appendChild(o)}_getContextMenuTargetType(e){let t;return t=e.closest(".smart-editor-editable table")?"table":e.closest(".smart-editor-editable img")?"image":e.closest(".smart-editor-video-container")?"video":e.closest(".smart-editor-editable a")?"link":"text",t}_getContextMenuDataSource(e,t){if(!t)return[];const o=this.contextMenuDataSource;let a;switch(t){case"table":a=["tableProperties","insertRowAfter","insertRowBefore","insertColumnLeft","insertColumnRight","deleteRow","deleteColumn","deleteTable","selectAll"];break;case"image":a=["imageProperties","copyImage","cutImage","createLink","deleteLink","deleteImage","caption"];break;case"video":a=["videoProperties","copyVideo","cutVideo","deleteVideo","caption"];break;case"link":a=["linkProperties","deleteLink","selectAll"];break;default:a=["copy","cut","paste","selectAll"]}return o&&(a="function"==typeof o?o(e,t,a):Array.isArray(o)?o:[]),a}_updateToolbarItem(e,t){const o=this,a=o.editMode,n=e.getAttribute("item-name"),i=o.$.toolbarItemsPrimary,r=o.$.toolbarItemsSecondary,l=o.$.inlineToolbar,s="markdown"===a?o.$.input:o.$.editableElement,d=(e,a,n)=>{a&&(a.label=t["alignment"===a.name?"value":"label"],a.value=t.value,e&&o._setItemValue(e,a),n&&o._updateToolbarTarget(a))};if(l&&l.contains(e)?(d(e,o._inlineToolbarItemsObj[n],!0),o._toolbarItemsObj&&o._toolbarItemsObj[n]&&d(o.$.toolbar.querySelector(`.smart-editor-toolbar-item[item-name=${n}]`),o._toolbarItemsObj[n])):(i.contains(e)||r.contains(e))&&o._toolbarItemsObj&&(d(e,o._toolbarItemsObj[n],!0),l&&l.visible&&o._inlineToolbarItemsObj&&d(l.querySelector(`.smart-editor-toolbar-item[item-name=${n}]`),o._inlineToolbarItemsObj[n])),s.getRootNode().activeElement!==s){const e=o._selectionRange,t=s.scrollTop;e&&("markdown"===a?o._setSelectionRange(s,e.selectionStart,e.selectionEnd):o._setSelectionRange(e.startContainer,e.startOffset,e.endOffset)),s.focus({preventScroll:!0}),o._isSafari&&t&&(s.scrollTop=t)}}_updateToolbarTarget(e){const t=this,o=t._resizeFrameObj;if(!e)return;const a=t.$.inlineToolbar;let n;o&&o.target?n=o.target:a&&a.visible&&(n=a.selector,n=n.closest?n.closest(".smart-editor-editable img")||n.closest(".smart-editor-editable table"):void 0);const i=n?n.nodeName.toLowerCase():"";if(n&&"img"===i)return"alignment"===e.name&&(n.closest(".smart-editor-image-container")||n).setAttribute("alignment",e.value),t._setResizeFrame(n),void(a&&a.visible&&a.reposition());if(n&&"table"===i)return void t._handleTableToolbarAction(e,n);const r=t._getSelectionRange();if(r&&(r.startContainer||void 0!==r.selectionStart)){const o=e.name;if(t.$.fireEvent("actionStart",{name:o}).defaultPrevented)return;switch(o){case"backgroundcolor":t._handleBackgroundColor(e);break;case"fontcolor":t._handleFontColor(e);break;case"alignment":t._handleTextAlignment(e);break;case"fontsize":t._handleFontSize(e);break;case"fontname":t._handleFontName(e);break;case"formats":t._handleFormats(e);break;case"paste":t._handlePaste(e);break;default:{const t=r.startContainer.closest?r.startContainer:r.startContainer.parentElement;return void(t&&t.closest&&t.setAttribute(e.name,e.value))}}o&&t.$.fireEvent("actionEnd",{name:o})}}_setSelectionRange(e,t,o){const a=this,n=a.$.iframe,i=a.editMode;let r;if(a.disabled)return;if("markdown"===i||a.$.editableElement.classList.contains("smart-hidden")){r=a.$.input,a._selectionRange={selectionStart:void 0!==t?t:r.selectionStart,selectionEnd:void 0!==o?o:r.selectionEnd};const e=a._selectionRange;return void(a._selectionChangeFired||r.setSelectionRange(e.selectionStart,e.selectionEnd))}const l=(n?n.contentWindow:window).getSelection();let s;if(r=a.$.editableElement,e){if(s=document.createRange(),"number"==typeof t&&"number"==typeof o)try{s.setStart(e,parseInt(t)),s.setEnd(e,parseInt(o))}catch(t){s.selectNodeContents(e)}else"img"===e.nodeName.toLowerCase()||e.classList.contains("smart-editor-video-container")?(s.setStartBefore(e),s.setEndAfter(e),s.selectNode(e)):s.selectNodeContents(e);l.removeAllRanges(),l.addRange(s)}else l.rangeCount&&(s=l.getRangeAt(0));try{s&&s.startContainer&&r.contains(s.startContainer)&&(a._selectionRange=s)}catch(e){}a._selectionRange||(s=document.createRange(),s.selectNodeContents(r),s.collapse(!0),a._selectionRange=s)}_getSelectionRange(){const e=this,t=e.editMode;let o=e._selectionRange;return o&&("markdown"===t&&void 0===o.selectionStart||"html"===t&&void 0===o.startContainer)&&(delete e._selectionRange,o=void 0),o||e._setSelectionRange(),e._selectionRange}_setCharCount(){const e=this,t=e.$.contentContainer;if(!e.showCharCount)return void t.removeAttribute("char-count");const o=e.maxCharCount;let a,n;if("html"===e.editMode){const t=e.$.editableElement,o=t.textContent.length,a=t.innerText.length;n=a&&o?a:0}else n=e.$.input.value.length;if(a=e.charCountFormatFunction?e.charCountFormatFunction(n,o)+"":o?`${n} / ${o}`:n+"",t.setAttribute("char-count",a),null===o)return void t.classList.remove("char-count-low","char-count-medium");const i=parseFloat((n/o).toFixed(2));t.classList[i>=.7&&i<=.9?"add":"remove"]("char-count-warning"),t.classList[i>=.9?"add":"remove"]("char-count-error"),t.classList[n>=o?"add":"remove"]("char-count-maxed")}_documentDownHandler(e){const t=this,o=t.$.iframe,a=t.$.inlineToolbar,n=t.$.window,i=e.originalEvent||e,r=t.shadowRoot||t.isInShadowDOM?i.composedPath()[0]:i.target;if(a&&a.contains(r)){const e=r.closest(".smart-editor-toolbar-item");return t._handleToolbarItemDown(e,r),void i.preventDefault()}if(t.$.container.contains(r)||o&&o.contentDocument.body.contains(r))return void t._handleDownInside(i,r);const l=r.closest(".smart-input-drop-down-menu");let s;if(l&&(s=l.ownerElement),n&&n.opened&&!n.contains(s||r)&&n.close(),t._handleTableSelection(),s&&(t.$.toolbarItemsPrimary.contains(s)||t.$.toolbarItemsSecondary.contains(s)||a&&a.contains(s)))return t._toolbarItemClick={},void i.preventDefault();t._setResizeFrame(),t._closePopups()}_handleDownInside(e,t){const o=this,a=e.originalEvent||e,n=t.closest(".smart-editor-toolbar-item"),i=o.$.inlineToolbar,r=t.classList.contains("smart-editor-video-container")?t:null,l=o.$.window;let s=o._editorVideoItemClick;if(s&&(r&&s.dragElement&&s.dragElement.remove(),delete o._editorVideoItemClick,s=void 0),t===o.$.toolbarToggleButton)o._toolbarItemClick={},e.preventDefault();else{if(n)return o._handleToolbarItemDown(n,t),void e.preventDefault();if(t.closest(".smart-editor-toolbar-tab"))e.preventDefault();else if(r)s||(s=o._editorVideoItemClick={target:t,originalSelectionRange:o._selectionRange}),e.preventDefault(),!1!==r.getAttribute("draggable")&&r.querySelector("video")?(s.dragElement=o._createWhiteSpaceChar(t,r),o._setSelectionRange(t)):s.dragElement&&(s.dragElement.remove(),delete s.dragElement);else if(t.closest(".smart-editor-search-bar"))o._searchBarDown={target:t},t.closest(".smart-search-input")||e.preventDefault();else{const e={x:a.pageX+window.pageXOffset,y:a.pageY+window.pageYOffset};l&&l.opened&&l.close();const n=o._getInlineToolbarTarget(t,e);if(n){const t=o.$.contentContainer;t.contains(t.getRootNode().activeElement)||o._focusEditableElement(),o._handleInlineToolbarItemDown(n,e)}else!i||i.contains(t)&&i.classList.contains("smart-editor-drop-down-toolbar")||(o._closeToolbar(),o._handleTableSelection())}}o._closeToolbarItemDropDown(o.$.inputPopup),o._closeToolbarItemDropDown(o.$.colorInputPopup)}_handleToolbarItemDown(e,t){const o=this,a=o.$.inlineToolbar,n=o.$.window;if(!e)return;const i=e.getAttribute("item-type"),r=e.getAttribute("item-name");switch(!n||!n.opened||n._target&&n._target.item.name===r||n.close(),o._toolbarItemClick={toolbarItem:e},o._resizeFrameObj&&o._resizeFrameObj.target?o._toolbarItemClick.target=o._resizeFrameObj.target:o._setResizeFrame(),o._setSelectionRange(),i){case"button":["hyperlink","createlink","image","video"].includes(r)?o._toolbarItemClick.callback=o._toggleWindow:"table"===r&&(o._toolbarItemClick.callback=a&&a.contains(e)?o._toggleWindow:o._toggleDropDownToolbar);break;case"toggle":e.toggleAttribute("checked"),e.hasAttribute("checked")?e.setAttribute("aria-pressed",!0):e.setAttribute("aria-pressed",!1),o._closeToolbarItemDropDown(o.$.inputPopup),o._closeToolbarItemDropDown(o.$.colorInputPopup);break;case"drop-down":o._toolbarItemClick.callback=o._toggleItemDropDown;break;case"color-input":t.closest(".smart-editor-item-drop-down-button")&&(o._toolbarItemClick.callback=o._toggleItemDropDown)}}_handleInlineToolbarItemDown(e,t){const o=this,a=e.closest(".smart-editor-editable table"),n=o.$.editableElement;if(o._inlineToolbarClickObj&&o._inlineToolbarClickObj.target&&(o._inlineToolbarClickObj.target.removeAttribute("drag-id"),o._inlineToolbarClickObj.dragElement&&o._inlineToolbarClickObj.dragElement.removeAttribute("drag-id")),o._inlineToolbarClickObj={},e)if("img"===e.nodeName.toLowerCase())e.setAttribute("drag-id",Math.random().toString(36).substr(2,5));else if(e.classList.contains("smart-editor-video-container")){const t=e.querySelector("video, iframe");t&&(t.setAttribute("drag-id",Math.random().toString(36).substr(2,5)),o._inlineToolbarClickObj.dragElement=t)}if(a&&n.hasAttribute("table-cell-resize")){const i=n.getAttribute("table-cell-resize");o._inlineToolbarClickObj.resizeDetails={x:t.x,y:t.y,position:i,target:"vertical"===i?e.closest("tr"):e,table:a},e=void 0}o._handleTableSelection(e),o._inlineToolbarClickObj.target=e,o._inlineToolbarClickObj.dragTarget=e}_getInlineToolbarTarget(e,t){const o=this;let a,n=e.closest(".smart-editor-editable img")||e.closest(".smart-editor-editable a")||e.closest(".smart-editor-video-container");return n||(a=e.closest(".smart-editor-editable table"),a&&(n=e.closest(".smart-editor-editable td")||e.closest(".smart-editor-editable th"))),e.closest(".smart-editor-resize-frame")&&o._resizeFrameObj?(o._resizeFrameObj.resizeDetails={x:t.x,y:t.y,position:e.getAttribute("position")},n=o._resizeFrameObj.target):n&&(n&&"img"===n.nodeName.toLowerCase()||a||n.classList.contains("smart-editor-video-container"))||o._setResizeFrame(),n}_documentMoveHandler(e){const t=this,o=t._resizeFrameObj,a=t._inlineToolbarClickObj,n=e.originalEvent||e;o&&o.resizeDetails?t._handleFrameResize(n):a&&a.resizeDetails&&t._handleTableCellResize(n)}_touchmoveHandler(e){const t=this,o=t._resizeFrameObj;t._isMobile&&o&&o.target&&(o.resizeDetails?(e.preventDefault(),e.stopPropagation()):(t._closeToolbar(),t._setResizeFrame()))}_dragStartHandler(e){const t=this,o=t._resizeFrameObj,a=t._inlineToolbarClickObj;if(o&&o.resizeDetails||a&&a.resizeDetails)return e.preventDefault(),void delete t._dragDetails;if(!t.$.contentContainer.contains(e.target))return;if(!a||!a.target)return void e.preventDefault();const n=t._inlineToolbarClickObj.target;if(n&&(["img","table"].indexOf(n.nodeName.toLowerCase())>-1||n.classList.contains("smart-editor-video-container"))){if("false"===n.getAttribute("draggable"))return void e.preventDefault();const o=e.target,a=o.parentElement,i=o.closest(".smart-editor-image-container");t._closeToolbar(),t._setResizeFrame(),t._dragDetails={target:o,scrollTop:t.$.editableElement.scrollTop,container:i,anchor:a&&"a"===a.nodeName.toLowerCase()?a:void 0,caption:i?i.querySelector(".smart-editor-image-caption"):void 0}}}_dropHandler(){const e=this;e._isFireFox&&e._dragEndHandler()}_dragEndHandler(){const e=this,t=e.$.inlineToolbar,o=e._dragDetails;if(o){const a=o.target,n=o.container,i=e.$.editableElement,r=i.querySelector(`[drag-id="${a.getAttribute("drag-id")}"]`);if(r){const a=o.anchor;if(r.removeAttribute("drag-id"),n&&!n.contains(r)&&r.parentElement){const e=o.caption;let t=r.parentElement;if(t.classList.contains("smart-editor-video-container")){const e=t;t=t.parentElement,e.remove(),t.appendChild(r)}n.remove(),n.innerHTML="",t.insertBefore(n,r),n.appendChild(r),e&&n.appendChild(e)}a&&r.parentElement!==a&&(a.innerHTML="",r.parentElement.insertBefore(a,r),a.appendChild(r)),void 0!==o.scrollTop&&(i.scrollTop=o.scrollTop),requestAnimationFrame((()=>e._setResizeFrame(r)));const l=e._resizeFrameObj;if(e._editorVideoItemClick){const t=i.querySelectorAll('.smart-editor-video-white-space, div[pseudo="-webkit-media-controls"]');for(let e=0,o=t.length;e<o;e+=1)t[e].remove();delete e._editorVideoItemClick}(!t||t&&!t.visible)&&l&&l.target&&e._openInlineToolbar(l.target)}return void delete e._dragDetails}e._setSelectionRange();const a=e._getSelectionRange();a&&a.startOffset!==a.endOffset&&(e._handleInlineToolbar(a.startContainer),e._focusEditableElement())}_documentUpHandler(e){const t=this,o=t._resizeFrameObj,a=t.$.inlineToolbar,n=e.originalEvent||e,i=t.shadowRoot||t.isInShadowDOM?n.composedPath()[0]:n.target;if(o&&(o.resizeDetails&&o.target&&(o.target.removeAttribute("dragged"),t.$.fireEvent("resizeEnd",{target:o.target})),delete o.resizeDetails),t._dragDetails)return t._endInlineToolbarClick(),void delete t._toolbarItemClick;const r=t.$.iframe;if(t.$.container.contains(i)||a&&a.contains(i)||r&&r.contentDocument.body.contains(i)){const e=i.closest(".smart-editor-toolbar-item");e?t._handleToolbarUp(e):t._handleContentUp(n,i)}t._endInlineToolbarClick(),delete t._searchBarDown,delete t._dragDetails,delete t._toolbarItemClick}_handleToolbarUp(e){const t=this,o=t._toolbarItemClick,a=e.getAttribute("item-type");if(o&&o.toolbarItem===e){const e=o.toolbarItem;"custom"!==a&&(t._handleToolbarItemClick(event,e),t._focusEditableElement())}}_handleContentUp(e,t){const o=this,a=o._inlineToolbarClickObj,n=o.$.toolbarToggleButton,i=o._editorVideoItemClick,r=void 0!==e.button&&2===e.button;if(r||t!==n&&!n.contains(t))if(t.classList.contains("smart-editor-toolbar-tab"))o.$.toolbar.hasAttribute("expanded")?t.hasAttribute("checked")||o._selectToolbarTab(t):(o._selectToolbarTab(t),o._toggleSecondaryToolbar(t.hasAttribute("checked")));else if(i&&t.classList.contains("smart-editor-video-container")&&t===i.target)o._setResizeFrame(t),o._focusEditableElement();else if(a){const e=a.target;e&&(e===t||e.contains(t))&&(r?o._setResizeFrame(e):o._handleInlineToolbar(e),o._focusEditableElement())}else if(!r&&(o.$.editableElement.contains(t)||"markdown"===o.editMode&&t===o.$.input)){const e=o.$.iframe,t=e?e.contentWindow:window;requestAnimationFrame((()=>{e&&o._setSelectionRange();const a=o._getSelectionRange();if(a instanceof t.Range){let e=a.startContainer;a.startOffset!==a.endOffset&&(o._handleInlineToolbar(e),o._focusEditableElement())}}))}else!r&&t.closest(".smart-editor-search-bar")&&o._handleSearchButtonClick(t.closest(".smart-search-button"));else o._toggleToolbar(o.$.toolbar.hasAttribute("expanded"))}_toggleSecondaryToolbar(e){const t=this,o=t.$.toolbar,a=t.$.toolbarItemsPrimary,n=t.$.toolbarItemsSecondary,i=()=>{o.hasAttribute("expanded")?(n.classList.remove("smart-drop-down"),o.contains(n)||o.appendChild(n),n.style.top=""):(n.classList.add("smart-drop-down"),o.contains(n)&&o.parentElement.insertBefore(n,o.nextElementSibling),n.style.top=a.offsetTop+a.offsetHeight+"px")};if(!e&&(n.classList.add("smart-visibility-hidden"),t.hasAnimation))return n.addEventListener("transitionend",i,{once:!0}),void n.addEventListener("transitioncancel",i,{once:!0});i(),e&&(t._setToolbarGroupHeight(),n.classList.remove("smart-visibility-hidden"))}_setToolbarGroupHeight(){const e=this.$.toolbarItemsSecondary,t=e.children;if(e.style.height="","menu"===this.toolbarMode)return;let o;for(let e=0,a=t.length;e<a;e+=1){const a=t[e].offsetHeight;(void 0===o||o<a)&&(o=a)}void 0!==o&&(e.style.height=o+"px")}_endInlineToolbarClick(){const e=this,t=e._inlineToolbarClickObj;if(t){const o=t.resizeDetails;if(!e._dragDetails&&t.target&&(t.target.removeAttribute("drag-id"),t.dragElement&&t.dragElement.removeAttribute("drag-id")),o&&o.target){if("horizontal"===o.position){const e=o.cells,t=o.table.offsetWidth;e&&e.forEach((e=>{e.style.width&&(e.style.width=100*parseFloat((e.offsetWidth/t).toFixed(2))+"%")}))}e.$.editableElement.removeAttribute("table-cell-resize"),o.target.removeAttribute("resizing"),o.isInlineToolbarOpened&&e._handleInlineToolbar(o.target)}delete e._inlineToolbarClickObj}}_updateToolbarItems(e,t){const o=this;if(o._dragDetails||o.readonly||o.disabled)return;if("markdown"===o.editMode)return void o._updateToolbarItemsMarkdown(e);const a=o._getSelectionRange(),n=o.$.inlineToolbar;let i,r;if(!a)return;if(t||(t=o.$.toolbar),n&&t!==n&&!o.hideInlineToolbar&&n.visible&&(o._updateToolbarItems(e,n),i=!0),t!==o.$.toolbar||o.hideToolbar?i||o.hideInlineToolbar||(r=o._inlineToolbarItemsObj):r=o._toolbarItemsObj,!r)return;const l=o.$.editableElement;let s,d=a.startOffset>a.endOffset?a.endContainer:a.startContainer;if(d&&(d.closest||(d=d.parentElement),d&&d.closest)){e||(e=["alignment","bold","italic","strikethrough","underline","fontsize","fontname","formats","fontcolor","backgroundcolor","orderedlist","unorderedlist","subscript","superscript"]);for(let a=0,n=e.length;a<n;a+=1){const n=e[a],i=r[n];if(i){let e;if("alignment"===n)e=d.style.textAlign;else if("bold"===n)e=!!o._getNodeFromList(d,["b","strong","h1","h2","h3","h4","h5","h6"]);else if("italic"===n)e=!!o._getNodeFromList(d,["i"]);else if("underline"===n)e=!!o._getNodeFromList(d,["u"]);else if("strikethrough"===n)e=!!o._getNodeFromList(d,["strike"]);else if("fontsize"===n){const t=d.closest(".smart-editor-editable font");t&&(e=t.style.fontSize),e||(s||(s=window.getComputedStyle(d)),e=s.fontSize),e=parseInt(e),isNaN(e)&&(e="")}else if("fontname"===n){const t=d.closest(".smart-editor-editable font");t&&t.hasAttribute("face")?e=t.getAttribute("face"):(s||(s=window.getComputedStyle(d)),e=s.fontFamily.split(",")[0])}else if("formats"===n&&d!==l){const t=i.dataSource;if(e="",t){const a=t.map((e=>e.value));e=o._getNodeFromList(d,a)||""}}else if("fontcolor"===n){const t=d.closest(".smart-editor-editable font");t?e=t.color:(s||(s=window.getComputedStyle(d)),e=s.color)}else"backgroundcolor"===n?(e=o._getNodeBackgroundColor(d),e||(s||(s=window.getComputedStyle(d)),e=s.backgroundColor)):"orderedlist"===n||"unorderedlist"===n?e=!!d.closest(`.smart-editor-editable ${"orderedlist"===n?"ol":"ul"} li`):"subscript"===n?e=!!d.closest(".smart-editor-editable sub"):"superscript"===n&&(e=!!d.closest(".smart-editor-editable sup"));if(!e&&i.dataSource){const t=i.dataSource[0];t&&(e=t.value||t)}null!==e&&(i.value=e,o._setItemValue(t.querySelector(`.smart-editor-toolbar-item[item-name=${n}]`),i))}}}}_updateToolbarItemsMarkdown(e){const t=this,o=t._getSelectionRange();if(!o||void 0===o.selectionStart)return;const a=o.selectionStart;e||(e=["bold","italic","strikethrough","underline","formats","orderedlist","unorderedlist","subscript","superscript"]);for(let o=0,n=e.length;o<n;o+=1){const n=e[o],i=t._toolbarItemsObj[n];if(i){let e;if("bold"===n)e=!!t._getMarkdownItem(a,"**"),e||(e=!!t._getMarkdownItem(a,"__"));else if("italic"===n)e=!!t._getMarkdownItem(a,"*"),e||(e=!!t._getMarkdownItem(a,"_"));else if("strikethrough"===n)e=!!t._getMarkdownItem(a,"~~");else if("underline"===n)e=!!t._getMarkdownItem(a,"<ins>","</ins>");else if("formats"===n){const o=i.dataSource;if(e="",o){const n=o.map((e=>e.value));e:for(let o=0,i=n.length;o<i;o+=1)if(e=t._getMarkdownFormat(a,n[o]),e&&void 0!==e.formatName){e=e.formatName;break e}}}else"orderedlist"===n||"unorderedlist"===n?e=!!t._getMarkdownFormat(a,n):"subscript"===n?e=!!t._getMarkdownItem(a,"<sub>","</sub>"):"superscript"===n&&(e=!!t._getMarkdownItem(a,"<sup>","</sup>"));if(!e&&i.dataSource){const t=i.dataSource[0];t&&(e=t.value||t)}null!==e&&(i.value=e,t._setItemValue(t.$.toolbar.querySelector(`.smart-editor-toolbar-item[item-name=${n}]`),i))}}}_getMarkdownItem(e,t,o=t){const a=this.$.input.value,n=a.lastIndexOf(t,Math.max(0,e-1)),i=a.indexOf(o,n>-1?n+t.length:e);if(!(n<0||n>e||i<0||i<e||a.slice(n,e).indexOf("\n")>-1||a.slice(e,i).indexOf("\n")>-1))return" "!==a[n+1]&&a[n-1]!==t&&a[n+1]!==t&&" "!==a[i-1]&&a[i-1]!==t&&a[i+1]!==t?{startIndex:n,endIndex:i+o.length}:void 0}_getMarkdownFormat(e,t){const o=this.$.input.value,a=o.lastIndexOf("\n",Math.max(0,e-1))+1,n=o.slice(a,e);let i;switch(t){case"h1":i="# ";break;case"h2":i="## ";break;case"h3":i="### ";break;case"h4":i="#### ";break;case"h5":i="##### ";break;case"h6":i="###### ";break;case"code":case"pre":i="```";break;case"blockquote":i="> ";break;case"orderedlist":{const e=/^\s*([0-9]+\.{1}\s+)/gs.exec(n);return e?{formatName:t,occuranceIndex:a+e.input.indexOf(e[1])}:void 0}case"unorderedlist":{const e=/^\s*([-+*]{1}\s+)/gs.exec(n);return e?{formatName:t,occuranceIndex:a+e.input.indexOf(e[1])}:void 0}default:i=t+""}const r=n.indexOf(i);if(r>=0&&r<=3&&n.slice(r,i.length)===i)return{formatName:t,occuranceIndex:a+r,markdown:i}}_getNodeFromList(e,t){const o=this.$.editableElement;if(e&&t)for(;e&&e!==o;){const o=e.nodeName.toLocaleLowerCase();if(t.indexOf(o)>-1)return o;e=e.parentElement}}_getNodeBackgroundColor(e){const t=this.$.editableElement;for(;e&&e!==t;){const t=e.style.backgroundColor;if(t)return t;e=e.parentElement}}_editableElementBlurHandler(e){const t=this,o=t.$.editableElement,a=t.$.contentContainer;if(!t._toolbarItemClick&&!a.contains(a.getRootNode().activeElement)){const n=t._value,i=()=>{a.removeAttribute("required"),t._requiredMessage&&(t.hideMessage(t._requiredMessage),delete t._requiredMessage)},r=t._getCurrentValue();if(t.required){const e=t.$.editableElement;"markdown"===t.editMode&&!t.$.input.value||"markdown"!==t.editMode&&!e.textContent&&!e.querySelectorAll("img, table").length?(a.hasAttribute("required")||a.setAttribute("required",""),t._requiredMessage||(t._requiredMessage=t.showMessage(t.localize("requiredMessage"),{autoClose:!1,iconType:"error"}))):i()}else i();n!==r&&(t.$.fireEvent("change",{oldValue:n,value:r}),t.name&&e.target===o&&"markdown"!==t.editMode&&(t.$.input.value=t._getInputValue(o.innerHTML.trim()))),t.removeAttribute("focus"),t.removeAttribute("aria-activedescendant")}}_editableElementFocusHandler(e){const t=this,o=t.editMode,a="markdown"===o?t.$.input:t.$.editableElement;let n=t._autoSaveObj;t.setAttribute("focus",""),e.target.id&&t.setAttribute("aria-activedescendant",e.target.id),t._value=t._getCurrentValue(),t.autoSave?(n||(n=t._autoSaveObj={}),clearInterval(n.interval),n.interval=setInterval((()=>{a.getRootNode().activeElement!==a&&clearInterval(n.interval),window.localStorage.setItem("smartEditor"+t.id,"markdown"===o?a.value:a.innerHTML)}),t.autoSaveInterval)):n&&(clearInterval(n.interval),delete t._autoSaveObj)}_inputChangeEvent(e){e.stopPropagation()}_updateOnInputChange(e){const t=this,o=t.$.editableElement,a=e.target,n=t.$.input,i=a.classList.contains("smart-search-input"),r=()=>{const e=l===n?n.value:t.$.editableElement.innerHTML;void 0!==s&&e!==s&&t.$.fireEvent("changing",{value:e,oldValue:t._changingValue})};if("paste"===e.type&&o.contains(a)){const o=e.clipboardData;if(o&&o.types.length){const a=o.types.indexOf("text/html")>-1?"text/html":"text/plain",[n,i]=["\x3c!--StartFragment--\x3e","\x3c!--EndFragment--\x3e"];let r=o.getData(a);e.preventDefault();let l=(e.clipboardData||e.originalEvent.clipboardData).items,s=null;for(let e=0;e<l.length;e++)0===l[e].type.indexOf("image")&&(s=l[e].getAsFile());if(null!==s){let e=new FileReader;return e.onload=function(e){t.$.editableElement.getRootNode().execCommand("insertHTML",!1,`<img src="${e.target.result}"/>`)},void e.readAsDataURL(s)}r.indexOf(n)>-1&&r.indexOf(i)>-1&&(r=r.slice(r.indexOf(n),r.indexOf(i))),t._handlePasteAction(r,{advanced:!0,value:t.pasteFormat},a)}}const l=o.getRootNode().activeElement,s=t._changingValue;if(!t.$.contentContainer.hasAttribute("split-mode")){if(clearTimeout(t._refreshTimeout),delete t._refreshTimeout,i){const o=t.findAndReplaceTimeout,a=e.key;if(clearTimeout(t._findAndReplaceTimeout),!a||"enter"===a.toLowerCase())return;return void(o?t._findAndReplaceTimeout=setTimeout((()=>t._applySearching(e.target.value)),o):t._applySearching(e.target.value))}const o=t._resizeFrameObj?t._resizeFrameObj.target:void 0;return o&&!o.parentElement&&(t._setResizeFrame(),t._closeToolbar()),void r()}r(),clearTimeout(t._refreshTimeout);let d=t.$.input.value;t._refreshTimeout=setTimeout((()=>{clearTimeout(t._refreshTimeout),"markdown"===t.editMode?t.$.editableElement.innerHTML=window.marked?window.marked(d):d:l===n?t.$.editableElement.innerHTML=t._getInputValue(d,!0):t.$.input.value=t._getInputValue(t.$.editableElement.innerHTML.trim())}),t.splitModeRefreshTimeout)}_editableElementWheelHandler(){const e=this.$.inlineToolbar;this._setResizeFrame(),e&&e.visible&&e.close()}_editableElementKeyDownHandler(e){const t=this,o=t.$.editableElement,a=t.$.input,n=e.target.getRootNode().activeElement,i=e.key.toLowerCase(),r=t._isMacOS&&e.metaKey||e.ctrlKey;if(!t.disabled&&!t.readonly){switch(i){case"a":if(!r){t._changingValue=n===o?o.innerHTML:a.value;break}if(n.classList.contains("smart-editor-image-caption"))return e.preventDefault(),t._setSelectionRange(n),void t._handleInlineToolbar(t._getSelectionRange().startContainer);if(t._tableCell)return e.preventDefault(),t._setSelectionRange(t._tableCell),void t._handleInlineToolbar(t._getSelectionRange().startContainer);break;case"backspace":case"delete":{const i=t._resizeFrameObj?t._resizeFrameObj.target:void 0;i&&("img"===i.nodeName.toLowerCase()||i.classList.contains("smart-editor-video-container"))&&(e.preventDefault(),t._deleteResizeFrameTarget(i)),t._changingValue=n===o?o.innerHTML:a.value;break}case"enter":if(!t.disableSearchBar){const o=t._searchToolbar;o&&!o.classList.contains("smart-visibility-hidden")&&(e.preventDefault(),t._highlightSearchResult(!e.shiftKey))}break;case"escape":n===o?t._closeToolbar():n.classList.contains("smart-search-input")&&t._closeSearchToolbar();break;case"tab":t.enableTabKey&&(e.preventDefault(),t._handleTabInsert());break;default:t._handleToolbarShortcuts(e,n)}t._closeToolbar()}}_handleToolbarShortcuts(e,t){const o=this,a=o.$.editableElement,n=o.$.input,i=e.key,r=o._isMacOS&&e.metaKey||e.ctrlKey;if(!r)return void(o._changingValue=t===a?a.innerHTML:n.value);const l=o._resizeFrameObj;let s;switch(l&&l.target&&(s=l.target),i.toLocaleLowerCase()){case"b":e.preventDefault(),o._handleTextDecorations("bold");break;case"c":r&&s&&o._handleImageCopy(s);break;case"x":r&&s&&o._handleImageCut(s);break;case"k":e.preventDefault(),o._openWindow({name:"hyperlink"});break;case"i":e.shiftKey?(e.preventDefault(),o._openWindow({name:"image"},s)):(e.preventDefault(),o._handleTextDecorations("italic"));break;case"e":e.shiftKey?(e.preventDefault(),o._openWindow({name:"table"},s)):(e.preventDefault(),o._updateToolbarTarget({name:"alignment",value:"center"}));break;case"u":e.shiftKey?(e.preventDefault(),o._handleTextCase("uppercase")):(e.preventDefault(),o._handleTextDecorations("underline"));break;case"s":e.shiftKey&&(e.preventDefault(),o._handleTextDecorations("strikethrough"));break;case"l":e.shiftKey?(e.preventDefault(),o._handleTextCase("lowercase")):(e.preventDefault(),o._updateToolbarTarget({name:"alignment",value:"left"}));break;case"+":e.shiftKey&&(e.preventDefault(),o._handleSubSuperScript("superscript"));break;case"=":e.shiftKey?(e.preventDefault(),o._handleSubSuperScript("superscript")):(e.preventDefault(),o._handleSubSuperScript("subscript"));break;case"]":e.preventDefault(),o._handleIndentation("indent");break;case"[":e.preventDefault(),o._handleIndentation("outdent");break;case"h":if(e.shiftKey){const t=o._toolbarItemsObj.sourcecode;t&&(t.value=void 0===t.value||!t.value),e.preventDefault(),o._handleSourceCodeMode()}break;case"f":if(e.shiftKey){const t=o._toolbarItemsObj.fullscreen;t&&(t.value=void 0===t.value||!t.value),e.preventDefault(),o._handleFullScreenMode()}else!r||o.disableSearchBar||"html"!==o.editMode||a.classList.contains("smart-hidden")||(e.preventDefault(),o._openSearchBar());break;case"j":e.preventDefault(),o._updateToolbarTarget({name:"alignment",value:"justify"});break;case"r":e.shiftKey?(e.preventDefault(),o._handleClearFormat()):(e.preventDefault(),o._updateToolbarTarget({name:"alignment",value:"right"}));break;case"o":e.shiftKey?(e.preventDefault(),o._handleList("orderedlist")):e.altKey&&(e.preventDefault(),o._handleList("unorderedlist"))}}_editableElementMoveHandler(e){const t=this,o=t.$.editableElement,a=e.originalEvent||e,n=a.clientX,i=a.clientY,r=t.shadowRoot||t.isInShadowDOM?a.composedPath()[0]:a.target;if(e.stopPropagation(),!r||!r.closest||t._isMobile||"false"===o.getAttribute("contenteditable"))return void o.removeAttribute("table-cell-resize");const l=t._inlineToolbarClickObj;if(l&&l.resizeDetails||t._dragDetails)return;const s=r.tagName.toLowerCase();if(!r.closest(".smart-editor-editable table")||"td"!==s&&"th"!==s)return void o.removeAttribute("table-cell-resize");const d=r.getBoundingClientRect();i<d.bottom+5&&i>d.bottom-5?o.setAttribute("table-cell-resize","vertical"):n<d.right+5&&n>d.right-5&&r.nextElementSibling?o.setAttribute("table-cell-resize","horizontal"):o.removeAttribute("table-cell-resize")}_focusEditableElement(){const e=this,t=e.$.iframe,o=e.editMode;let a=e.$.editableElement;if(("markdown"===o||a.classList.contains("smart-hidden"))&&(a=e.$.input),t&&t.focus({preventScroll:!0}),a.getRootNode().activeElement!==a){const n=e._getSelectionRange(),i=a.scrollTop,r=t?t.contentWindow:window;if(a.focus({preventScroll:!0}),e._isSafari&&i&&(a.scrollTop=i),"markdown"===o||a.classList.contains("smart-hidden"))return void(void 0!==n.selectionStart&&e._setSelectionRange(n.selectionStart,n.selectionEnd));if(n instanceof r.Range){const e=(t?t.contentWindow:window).getSelection();e.removeAllRanges(),e.addRange(n)}}}_getTextFromCarret(){const e=this._getSelectionRange(),t=e.startContainer,o=t.textContent;let a,n;if(!e.toString()&&o.length>0&&o.indexOf(" ")>-1){const t=o.slice(0,e.startOffset).lastIndexOf(" ")+1;let i=o.slice(e.endOffset).indexOf(" ");i<0&&(i=o.length-1),a=t>-1?t:e.startOffset,n=Math.max(e.endOffset,e.endOffset+i)}else a=0,n=t.length;return{selectionStartIndex:a,selectionEndIndex:n}}_handleSearchButtonClick(e){const t=this;if(!e)return;const o=e.classList;o.contains("smart-search-button")&&(o.contains("prev")?t._highlightSearchResult():o.contains("next")?t._highlightSearchResult(!0):o.contains("close")&&t._closeSearchToolbar())}_highlightSearchResult(e){const t=this,o=t.$.contentContainer,a=t.$.editableElement.querySelectorAll(".find-and-replace-match"),n=o.querySelector(".smart-search-input-container"),i=a.length;for(let o=0,r=i;o<r;o+=1){const r=a[o];if(r.classList.contains("selected")){const l=e?Math.min(i-1,o+1):Math.max(0,o-1),s=a[l];return s&&(s.classList.add("selected"),n.setAttribute("selected",l+1),t._scrollToMarker(s)),void(s!==r&&r.classList.remove("selected"))}}}_handleToolbarItemClick(e,t){const o=this;if(!t)return;const a=o.$.inlineToolbar,n=o._toolbarItemClick,i=t.getAttribute("item-type"),r=t.getAttribute("item-name");let l,s;if(e&&(l=e.originalEvent||e,s=o.shadowRoot||o.isInShadowDOM?l.composedPath()[0]:l.target),"custom"!==i&&l&&(o.hasRippleAnimation&&"delimiter"!==i&&Smart.Utilities.Animation.Ripple.animate(s,l.pageX,l.pageY),n&&n.callback))return n.callback.call(o,t,n.target),void o.$.fireEvent("toobarItemClick",{value:r,originalEvent:l});o.$.fireEvent("actionStart",{name:r}).defaultPrevented||(o._handleToolbarItemAction(t),o._closeToolbarItemDropDown(o.$.inputPopup),o._closeToolbarItemDropDown(o.$.colorInputPopup),a&&a.close(),l&&o.$.fireEvent("toobarItemClick",{value:r,originalEvent:l}),r&&o.$.fireEvent("actionEnd",{name:r}))}_handleToolbarItemAction(e){const t=this,o=t._toolbarItemClick;if(!e)return;const a=e.getAttribute("item-type"),n=e.getAttribute("item-name");if("custom"!==a)switch(n){case"bold":case"italic":case"underline":case"strikethrough":t._handleTextDecorations(n);break;case"clearformat":t._handleClearFormat();break;case"redo":case"undo":t._handleUndoRedo(n);break;case"lowercase":case"uppercase":t._handleTextCase(n);break;case"backgroundcolor":t._handleBackgroundColor(e.getAttribute("item-value"));break;case"fontcolor":t._handleFontColor(e.getAttribute("item-value"));break;case"findandreplace":case"editlink":t._openWindow(e);break;case"openlink":{const o=t.$.inlineToolbar;if(o&&o.contains(e)){const e=o.selector;let t;e.nodeName!==Node.TEXT_NODE&&(t=e.closest(".smart-editor-editable a")),t&&window.open(t.href,t.target)}break}case"caption":{if(!o)break;const e=o.target;if(e&&"img"===e.nodeName.toLowerCase()){const o=e.closest(".smart-editor-image-container");let a;o&&o.querySelector(".smart-editor-image-caption")||(a=t.localize("captionPlaceholder")),t._handleImgCaption(e,{caption:a,focusCaption:!0})}else if(e.classList.contains("smart-editor-video-container")){const o=e.querySelectorAll(".smart-editor-video-container > video, .smart-editor-video-container > iframe");let a;e.querySelector(".smart-editor-image-caption")||(a=t.localize("captionPlaceholder")),t._handleVideoCaption(o[0]||o[1],{caption:a,focusCaption:!0})}break}case"cut":case"copy":case"paste":t._handleClipboardAction(n);break;case"delete":t._resizeFrameObj&&t._resizeFrameObj.target?t._deleteResizeFrameTarget(o.target):t._handleTextDelete();break;case"removelink":o&&t._handleLinkRemove(o.target);break;case"tableheader":case"tablerows":case"tablecolumns":case"tablevalign":case"tablestyle":t._handleTableToolbarAction(e);break;case"sourcecode":t._handleSourceCodeMode(e);break;case"splitmode":t._handleSplitMode(e);break;case"fullscreen":t._handleFullScreenMode(e);break;case"orderedlist":case"unorderedlist":t._handleList(n);break;case"indent":case"outdent":t._handleIndentation(n);break;case"subscript":case"superscript":t._handleSubSuperScript(n);break;case"print":t._handlePrint();break;default:t._inlineToolbarItemsObj?t._updateEditorViaWindow(t._inlineToolbarItemsObj[n]):t._toolbarItemsObj&&t._updateEditorViaWindow(t._toolbarItemsObj[n])}}_handleCommonToolbarAction(e,t){const o=this;if("html"===o.editMode){const a=o._getSelectionRange(),n=o.$.iframe,[i,r]=n?[n.contentDocument,n.contentWindow]:[document,window];let l,s=a.startContainer;if(!s)return;const d=e=>"string"==typeof e?("removeFormat"===e&&o.removeStylesOnClearFormat&&o._removeNodeStyles(a.commonAncestorContainer),i.execCommand(e)):"object"==typeof e?i.execCommand(e.name,!1,e.value):void 0;if(a.startOffset===a.endOffset&&s.nodeType===Node.TEXT_NODE){const{selectionStartIndex:e,selectionEndIndex:t}=o._getTextFromCarret();l=a.startOffset-e,o._setSelectionRange(s,e,t)}d(e)&&void 0!==l&&o._setSelectionRange(r.getSelection().focusNode,l,l),t&&o._updateToolbarItems(t)}}_handleClearFormat(){this._handleCommonToolbarAction("removeFormat")}_handleFontName(e){this._handleCommonToolbarAction(e)}_handleFontSize(e){const t=this;if("markdown"===t.editMode)return;const o=t._getSelectionRange();let a,n=o.startContainer;if(n){if(o.startOffset===o.endOffset){if(n.nodeType!==Node.TEXT_NODE){const a=document.createElement("font");return o.insertNode(a),t._setSelectionRange(a),void(a.style.fontSize=e.value+"px")}{const{selectionStartIndex:e,selectionEndIndex:i}=t._getTextFromCarret();a=o.startOffset-e,t._setSelectionRange(n,e,i)}}if((t.$.editableElement.getRootNode()||document).execCommand("fontSize",!1,3)){const n=t.$.iframe,i=n?n.contentWindow:window;if(o.commonAncestorContainer.closest){const t=o.commonAncestorContainer.querySelectorAll("font[size]");for(let o=0,a=t.length;o<a;o+=1){const a=t[o];a.removeAttribute("size"),a.style.fontSize=e.value+"px"}}else{const t=i.getSelection().focusNode;if(!t)return;const o=t.closest?t.closest(".smart-editor-editable font"):t.parentElement;"font"===o.nodeName.toLowerCase()&&(o.removeAttribute("size"),o.style.fontSize=e.value+"px")}void 0!==a&&t._setSelectionRange(i.getSelection().focusNode,a,a)}}}_handleFormats(e){const t=this;if("markdown"!==t.editMode)t._getSelectionRange().startContainer&&t.$.editableElement.getRootNode().execCommand("formatBlock",!1,e.value);else{let o;switch(e.value){case"h1":o="#";break;case"h2":o="##";break;case"h3":o="###";break;case"h4":o="####";break;case"h5":o="#####";break;case"h6":o="######";break;case"code":case"pre":o="```\n\n```";break;case"blockquote":o=">";break;case"p":o="";break;default:o=e.value}const a=e.dataSource,n=t.$.input.selectionStart;if(a){const e=a.map((e=>e.value));for(let o=0,a=e.length;o<a;o+=1){const a=t._getMarkdownFormat(n,e[o]);if(a&&void 0!==a.formatName){t._removeMarkDown(a.markdown,a.occuranceIndex,!0);break}}}0===o.indexOf("#")||0===o.indexOf(">")?(o+=" ",t._insertMarkDown(o,t.$.input.selectionStart+o.length,!0)):t._insertMarkDown(o,t.$.input.selectionStart+o.length/2)}}_handleSubSuperScript(e){const t=this;"markdown"!==t.editMode?t._handleCommonToolbarAction(e,["subscript","superscript"]):t._handleMarkdownItem(e)}_handleMarkdownItem(e){const t=this,o=t.$.input,a=t._getSelectionRange(),n=a.selectionStart,i=a.selectionEnd;let r,l,s,d=o.value;switch(e){case"bold":l="**",s="**";break;case"italic":l="*",s="*";break;case"underline":l="<ins>",s="</ins>";break;case"strikethrough":l="~~",s="~~";break;case"subscript":l="<sub>",s="</sub>";break;case"superscript":l="<sup>",s="</sup>"}if(void 0!==n&&n!==i){const e=l.length,a=s.length;if(r=d.slice(n,i),d.slice(n-e,n)===l&&d.slice(i,i+a)===s)return o.value=d.slice(0,n-e)+r+d.slice(i+a),t._refreshMarkdownPreview(),void t._setSelectionRange(o,n-e,i-e)}l&&s&&t._insertMarkDown(l+s,o.selectionStart+l.length)}_handleTextDecorations(e){const t=this;if("markdown"===t.editMode)return void t._handleMarkdownItem(e);const o=t._getSelectionRange();let a,n=o.startContainer;if(n){if(o.startOffset===o.endOffset&&n.nodeType===Node.TEXT_NODE){const{selectionStartIndex:e,selectionEndIndex:i}=t._getTextFromCarret();a=o.startOffset-e,t._setSelectionRange(n,e,i)}if((t.$.editableElement.getRootNode()||document).execCommand(e))if(void 0!==a){const e=t.$.iframe,o=e?e.contentWindow:window,n=o.getSelection().focusNode;n.textContent=n.textContent.trim(),t._setSelectionRange(o.getSelection().focusNode,a,a)}else t._setSelectionRange();t._updateToolbarItems([e])}}_handlePasteAction(e,t,o){if(!e)return;const a=this;if(t&&!t.name&&"prompt"===a.pasteFormat){const n={name:"paste",text:e,textType:o};return t&&(n.value=t.value,n.advanced=t.advanced),void a._openWindow(n)}a._handleTextPaste(e,t,o)}_handleTextPaste(e,t,o){const a=this,n=a.$.input;if(a.$.contentContainer.classList.contains("char-count-maxed"))return;if("markdown"===a.editMode)return a._insertMarkDown(e),void a._setCharCount();e=e.replace(/<!--StartFragment-->|<!--EndFragment-->/gi,"");let i,r,l=a.pasteFormat;if(t&&t.advanced&&(l=t.value),!o||"plainText"===l){const t=document.createElement("div");t.innerHTML=e,e=t.innerText}const s=e.toLocaleLowerCase();if(i=document.createElement("span"),i.innerHTML=e,s.indexOf("<video")>-1||s.indexOf("<iframe")>-1||s.indexOf("smart-editor-image-caption")>-1){const e=i.querySelectorAll("video, iframe"),t=i.querySelector(".smart-editor-image-caption"),o=e.length>0;let a=document.createDocumentFragment();for(let t=0,o=e.length;t<o;t+=1)a.appendChild(e[t]);if(t&&(t.removeAttribute("style"),a.appendChild(t)),o||t){const e=document.createElement("span");i.classList.add("smart-editor-image-container"),o&&i.classList.add("smart-editor-video-container"),i.setAttribute("contenteditable",!1),a.childElementCount&&(i.innerHTML="",i.appendChild(a)),e.appendChild(i),i=e}}if("cleanFormat"===l&&a._removeNodeStyles(i),o&&"text/plain"!==o||(i=document.createTextNode(i.innerHTML),r=Node.TEXT_NODE),n.getRootNode().activeElement===n){const e=n.value;return n.value=e.slice(0,n.selectionStart)+(r===Node.TEXT_NODE?i.textContent:i.innerHTML)+e.slice(n.selectionEnd),void a._setCharCount()}const d=a._getSelectionRange(),c=a.$.iframe,[m,u]=c?[c.contentWindow,c.contentDocument]:[window,document];if(!(d instanceof m.Range))return u.execCommand("paste"),void a._handleContentFiltering();if(d.deleteContents(),i.childNodes.length)for(;i.lastChild;)d.insertNode(i.lastChild);else d.insertNode(i);d.collapse(),a._handleContentFiltering()}_removeNodeStyles(e){if(e&&e.nodeType!==Node.TEXT_NODE){const t=e.querySelectorAll("style, [style]");for(let e=0,o=t.length;e<o;e+=1){const o=t[e];"style"===o.nodeName.toLowerCase()?o.remove():t[e].removeAttribute("style")}e.removeAttribute("style")}}_handlePaste(e){const t=this,o=navigator.clipboard,a=o.read?"read":"readText",n=()=>{o[a]&&o[a]().then((o=>{if(Array.isArray(o)&&o.length){const a=o[0],n=a.types.indexOf("text/html")>-1?"text/html":"text/plain";a.getType(n).then((o=>{o.text().then((o=>t._handlePasteAction(o,e,n)))}))}else"string"==typeof o&&t._handlePasteAction(o,e)}))};if(navigator.permissions&&navigator.permissions.query&&!t._isFireFox)try{navigator.permissions.query({name:"clipboard-read"}).then((e=>{("granted"===e.state||"prompt"===e.state&&o[a])&&n()}))}catch(e){t.error(t.localize("permissionsRequired",{elementType:t.nodeName.toLowerCase(),actionName:"paste"}))}else if(o[a])return void n();t.$.editableElement.getRootNode().execCommand("paste")}_handlePasteViaWindow(e){const t=this,o=t._getItemOptionsViaWindow(e);if(!e||"paste"!==e.name)return;let a=t.pasteFormat;for(let e in o)if(o[e]){a=e;break}e.value=a,t._handleTextPaste(e.text,e,e.textType)}_handleClipboardAction(e){const t=this,o=t.editMode,a=t.$.input;if("paste"===e)return void t._handlePaste();const n=t._getSelectionRange();if(("copy"===e||"cut"===e)&&(document.execCommand("copy"),"cut"===e))if("markdown"===o){const e=a.value,o=a.selectionStart;a.value=e.slice(0,o)+e.slice(a.selectionEnd),t._setSelectionRange(a,o,o),t._refreshMarkdownPreview()}else n.deleteContents()}_handleLinkRemove(e){const t=this;let o;if(e&&"img"===e.nodeName.toLowerCase())o=e.closest(".smart-editor-editable a"),o&&(o.parentElement.insertBefore(e,o),o.remove());else{const e=t.$.iframe;let o,a;e?(o=e.contentDocument,a=e.contentWindow):(o=document,a=window);const n=a.getSelection(),i=t._getSelectionRange();n.removeAllRanges(),n.addRange(i);const r=n.anchorNode?n.anchorNode.parentElement:void 0;if(!r||"a"!==r.nodeName.toLowerCase())return;i.selectNode(n.anchorNode),o.execCommand("unlink",!1,!1)}}_handleBackgroundColor(e){const t=this;if("markdown"===t.editMode)return;const o=t.$.iframe,a="string"==typeof e?e:e.value,[n,i]=o?[o.contentDocument,o.contentWindow]:[document,window],r=t.$.inlineToolbar,l=t._getSelectionRange(),s=r&&r.visible?r.selector:l.commonAncestorContainer;let d;if(s&&["th","td"].indexOf(s.nodeName.toLowerCase())>-1){if(l.startOffset===l.endOffset)return void(s.style.backgroundColor=a);d=s.style.backgroundColor}const c=l.startOffset,m=l.endOffset,u=l.startContainer;let b;if(u&&u.nodeType===Node.TEXT_NODE&&l.startOffset===l.endOffset){const{selectionStartIndex:e,selectionEndIndex:o}=t._getTextFromCarret();b=l.startOffset-e,t._setSelectionRange(u,e,o)}else u.closest&&c!==m&&t._setSelectionRange(u,c,m);const p=n.execCommand("hiliteColor",!1,a&&"transparent"!==a?a:"transparent");s&&d?s.style.backgroundColor=d:p&&void 0!==b&&t._setSelectionRange(i.getSelection().focusNode,b,b)}_handleFontColor(e){const t=this;if("markdown"===t.editMode)return;const o=t._getSelectionRange(),a="string"==typeof e?e:e.value,n=o.startContainer,i=t.$.iframe,r=a?"foreColor":"removeFormat",[l,s]=i?[i.contentDocument,i.contentWindow]:[document,window];let d;if(n&&n.nodeType===Node.TEXT_NODE&&o.startOffset===o.endOffset){const e=n.parentElement;if("font"===e.nodeName.toLocaleLowerCase())return void(e.color=a);const{selectionStartIndex:i,selectionEndIndex:r}=t._getTextFromCarret();d=o.startOffset-i,t._setSelectionRange(n,i,r)}l.execCommand(r,!1,a)&&void 0!==d&&t._setSelectionRange(s.getSelection().focusNode,d,d)}_handlePrint(){const e=this,t=e.dataExport.fileName;e.dataExport.fileName=null;const o=window.open("","","width=800,height=500"),a=o.document.open(),n='<!DOCTYPE html><html><head><meta charset="utf-8" /><title>'+t+"</title></head><body>"+e._handleDataExport("html")+"</body></html>";try{a.write(n),a.close(),setTimeout((function(){o.print(),o.close()}),100)}catch(e){}e.dataExport.fileName=t}_handleDataExport(e,t){const o=this;if(!Smart.Utilities.DataExporter)return void o.error(o.localize("missingReference",{elementType:o.nodeName.toLowerCase(),methodName:"exportData",files:"smart.export.js"}));try{new JSZip}catch(e){return void o.error(o.localize("missingReference",{elementType:o.nodeName.toLowerCase(),methodName:"exportData",files:"jszip.min.js"}))}if("pdf"===e&&!window.pdfMake)return void o.error(o.localize("missingReference",{elementType:o.nodeName.toLowerCase(),methodName:"exportData",files:"pdfMake.min.js"}));if("pdf"===e)return void o._exportToPDF(o.dataExport.fileName,e);let a;if("markdown"===o.editMode){const t=o.$.input;a="md"!==e&&window.marked?window.marked(t.value):t.value}else a=o.$.editableElement["pdf"===e?"textContent":"innerHTML"];const n=new Smart.Utilities.DataExporter({exportHeader:!1,pageOrientation:o.dataExport.pageOrientation,style:o.dataExport.style}),i=[{value:a}];return o._setExportStyles(n,e),n.exportData(i,e,o.dataExport.fileName,t)}_exportToPDF(e,t){const o=this,a=o.$.editableElement,n=window.getComputedStyle(o),i=o.dataExport.style,r={pageOrientation:o.pageOrientation||"portrait",info:{title:"smartEditor",creator:"Smart",producer:"Smart"}};if(i&&(r.styles=i),r.defaultStyle={fontSize:parseFloat(n.fontSize)},"markdown"===o.editMode){const e=o.$.input,n=document.createElement("div");let i;"md"!==t?a.classList.contains("smart-hidden")?(n.innerHTML=window.marked?window.marked(e.value):e.value,i=o._processHTMLAsPDFObject(n,[])):i=o._processHTMLAsPDFObject(a,[]):(n.innerHTML=e.value,i=o._processHTMLAsPDFObject(n,[])),r.content=i}else r.content=o._processHTMLAsPDFObject(o.$.editableElement,[]);try{pdfMake.createPdf(r).download(e)}catch(e){console.error(o.localize("exportError",{elementType:o.nodeName.toLowerCase(),status:e.toString()}))}}_processHTMLAsPDFObject(e,t,o){const a=this,n={},i=["left","center","right"],r=e.childNodes,l=["td","th"].indexOf(e.nodeName.toLowerCase())>-1;for(let o=0,s=r.length;o<s;o+=1){const s=r[o],d=s.nodeName.toLowerCase(),c=s.nodeType===Node.TEXT_NODE;let m;if("table"===d){const e=s.querySelectorAll("thead tr"),t=s.querySelectorAll("thead tr:last-of-type td, thead tr:last-of-type th"),o=s.querySelectorAll("tbody tr:last-of-type td, tbody tr:last-of-type th"),n=t.length?t:o,i=s.querySelectorAll("body tr");let r=e.length;if(!r)for(let e=0,t=i.length;e<t&&Array.from(i[e].children).every((e=>"th"===e.nodeName.toLowerCase()));e+=1)r++;m={table:{headerRows:r,widths:(()=>{const e=Math.round(100/n.length)+"%";let t=[];for(let o=0,a=n.length;o<a;o+=1)t.push(e);return t})(),body:(()=>{let e=[];for(let t=0,o=i.length;t<o;t+=1){const o=i[t],r=o.children;let l=[];for(let e=0,t=o.childElementCount;e<t;e+=1){const t=a._processHTMLAsPDFObject(r[e],[],!0);if(o.childElementCount<n.length){let e;for(e=Array.isArray(t)&&1===t.length?t[0]:{text:t},e.colSpan=Math.round(n.length/o.childElementCount),l.push(e);l.length<n.length;)l.push({text:""})}else l.push(1===t.length?t[0]:t)}e.push(l)}return e})()}}}else if("ul"===d)m={ul:a._processHTMLAsPDFObject(s,[])};else if("ol"===d)m={ol:a._processHTMLAsPDFObject(s,[])};else if("img"===d){const e=document.createElement("canvas"),t=e.getContext("2d");let o;e.width=s.naturalWidth||s.width,e.height=s.naturalHeight||s.height,t.drawImage(s,0,0);try{o=e.toDataURL("image/png")}catch(e){console.error(a.localize("exportError",{elementType:a.nodeName.toLowerCase(),status:e.toString()}));continue}if(o.indexOf("image/png")<0){console.error(a.localize("exportError",{elementType:a.nodeName.toLowerCase(),status:"Invalid image"}));continue}m={image:o,width:s.width,height:s.height}}else"a"===d?(m={},s.childElementCount?s.querySelector("img")&&(m=a._processHTMLAsPDFObject(s,[],!0)[0]||{}):m.text=s.textContent,m.link=s.href):s.childElementCount?t=t.concat(a._processHTMLAsPDFObject(s,[],!0)):m={text:s.textContent.trim()?s.textContent:"\n"};if(m){const o=window.getComputedStyle(c?e:s);if(!c||l){const e=o.backgroundColor,t=parseFloat(o.fontSize);isNaN(t)||(m.fontSize=t),m.alignment=n.alignment=i.indexOf(o.textAlign)>-1?o.textAlign:i[0],"rgba(0, 0, 0, 0)"!==e&&"transparent"!==e&&(m.fillColor=n.fillColor=a._RGBAtoHex(e)),parseInt(o.fontWeight)>500&&(m.bold=!0),"italic"===o.fontStyle&&(m.italics=!0)}m.inlineElement=c||o.display.indexOf("inline")>-1,m.color=n.color=a._RGBAtoHex(o.color),t.push(m)}}return 1===t.length?t:o||l?(n[t.every((e=>e.inlineElement&&!e.image))?"text":"stack"]=t,[n]):t}_RGBAtoHex(e){const t=/rgb[a]?\(\s*(\d+),\s*(\d+),\s*(\d+),?\s*(\d*.\d+|\d+)?\)/gi.exec(e.replace(/\s/g,""));if(null===t)return e;const o=parseFloat(t[1]).toString(16).toUpperCase(),a=parseFloat(t[2]).toString(16).toUpperCase(),n=parseFloat(t[3]).toString(16).toUpperCase();return"#"+"0".repeat(2-o.length)+o+"0".repeat(2-a.length)+a+"0".repeat(2-n.length)+n}_setExportStyles(e,t){const o=this;if(e.style)return;const a=window.getComputedStyle(o),n=a.getPropertyValue("--smart-border-width")||"1px",i=a.getPropertyValue("--smart-border")||"black",r=a.getPropertyValue("--smart-editor-table-column-width")||"initial",l=a.getPropertyValue("--smart-editor-table-cell-min-height")||"20px",s=a.getPropertyValue("--smart-editor-table-cell-min-width")||l,d=a.getPropertyValue("--smart-surface")||"#333",c=a.getPropertyValue("--smart-alternation-index0-background")||d;e.style={border:"initial",width:"100%",height:o.$.editableElement.scrollHeight+"px",removeDefault:!0,custom:`\n            ${"html"===t&&o.rightToLeft?"body { direction: rtl; }":""}\n\n          .column table {\n            width: 100%;\n            border-collapse: collapse;\n            empty-cells: show;\n            border-spacing: 0;\n            table-layout: fixed;\n          }\n          \n          .column td, .column th {\n            border: ${n} solid ${i};\n            width: ${r};\n            min-height: ${l};\n            min-width: ${s};\n            padding: 2px 5px;\n            vertical-align: middle;\n          }\n          \n          .column table img {\n            max-width: 100%;\n          }\n          \n          .column table table {\n            width: 100%;\n          }\n          \n          .column table th {\n            background: ${d};\n          }\n\n          .column th:empty::before,\n          .column td:empty::before {\n            content: 'A';\n            visibility: hidden;\n          }\n          \n          .column table[dashed-borders] th, .column table[dashed-borders] td {\n            border-style: dashed;\n          }\n          \n          .column table[alternation] tr:nth-child(2n) {\n            background-color: ${c};\n          }\n          \n          .column .smart-editor-image-container {\n            display: inline-block;\n          }\n          \n          .column .smart-editor-image-container[display="block"] {\n            display: block;\n          }\n          \n          .column .smart-editor-image-container[display="block"][alignment="left"] img {\n            margin-left: 0;\n          }\n          \n          .column .smart-editor-image-container[display="block"][alignment="left"] .smart-editor-image-caption {\n            text-align: left;\n          }\n          \n          .column .smart-editor-image-container[display="block"][alignment="right"] img {\n            margin-right: 0;\n          }\n          \n          .column .smart-editor-image-container[display="block"][alignment="right"] .smart-editor-image-caption {\n            text-align: right;\n          }\n          \n          .column .smart-editor-image-container:not([display="block"])[alignment="left"] {\n            float: left;\n          }\n          \n          .column .smart-editor-image-container:not([display="block"])[alignment="right"] {\n            float: right;\n          }\n          \n          .column .smart-editor-image-container .smart-editor-image-caption {\n            display: block;\n            text-align: center;\n            outline: none;\n          }`}}_handleSourceCodeMode(e){const t=this,o=t.editMode,a=t._toolbarItemsObj.sourcecode;let n;if(t.$.contentContainer.hasAttribute("split-mode"))return;e?n=e.hasAttribute("checked"):(n=a?a.value:!t.classList.contains("preview-mode"),e=t.$.toolbar.querySelector('.smart-editor-toolbar-item[item-name="sourcecode"]')),t._closePopups(),t._closeWindow(),t._closeSearchToolbar(),t._setResizeFrame(),t._handleTableSelection();const i=t.$.editableElement,r=t.$.input;"markdown"===o?n&&i.classList.contains("smart-hidden")?(i.innerHTML=window.marked?window.marked(r.value):r.value,i.classList.remove("smart-hidden"),r.classList.add("smart-hidden"),i.focus({preventScroll:!0})):!n&&r.classList.contains("smart-hidden")&&(i.classList.add("smart-hidden"),r.classList.remove("smart-hidden"),r.focus({preventScroll:!0})):n&&r.classList.contains("smart-hidden")?(r.value=t._getInputValue(i.innerHTML),i.classList.add("smart-hidden"),r.classList.remove("smart-hidden"),r.focus({preventScroll:!0})):!n&&i.classList.contains("smart-hidden")&&(i.innerHTML=t._getInputValue(r.value,!0),r.classList.add("smart-hidden"),i.classList.remove("smart-hidden"),i.focus({preventScroll:!0}),t._handleContentFiltering()),n?t.classList.add("preview-mode"):t.classList.remove("preview-mode"),a&&(a.value=n),e&&a&&(n?(e.setAttribute("checked",""),e.setAttribute("aria-pressed",!0)):(e.removeAttribute("checked"),e.setAttribute("aria-pressed",!1)),t._setTextSelection(),t._setToolbarItemAttr("sourcecode","disabled",a.disabled))}_setTextSelection(){const e=this,t=e.$.input,o=e.$.editableElement,a=e._selectionRange;if(!a)return;const n=a.commonAncestorContainer;if(n){if(t.classList.contains("smart-hidden"))return;const i=e._getParentCharDetails(a.startContainer,n),r=e._getParentCharDetails(a.endContainer,n),l=e._getSiblingsCharOffset(i.parentElement,r.parentElement),{charOffset:s}=e._getParentCharDetails(n,o),d=a.startOffset+i.charOffset+s,c=a.endOffset+r.charOffset+l+s;e._setSelectionRange(t,d,c)}else if(!o.classList.contains("smart-hidden")){const n=a.selectionStart,i=a.selectionEnd,r=t.value;if(void 0===n||void 0===i||n===i&&(r.length===n||0===n))return;if(0===n&&i===o.innerHTML.length)return void e._setSelectionRange(o);const l=e._getNodeByChartOffset(o.firstChild,n,i);if(!l)return;const{node:s,charOffset:d}=l;e._setSelectionRange(s,n-d,i-d)}}_getNodeByChartOffset(e,t,o){const a=this;let n=0;for(;e;){const i=e.outerHTML||e.textContent,r=i.length;if(n<=t&&n+r>=o){e.tagName&&(n+=e.outerHTML.slice(0,i.indexOf(e.innerHTML)).length);const r=a._getNodeByChartOffset(e.firstChild,t-n,o-n);return r?{node:r.node,charOffset:r.charOffset+n}:{node:e,charOffset:n}}e=e.nextSibling,n+=r}}_getParentCharDetails(e,t){let o=0;if(e===t)return{charOffset:o,parentElement:e.parentElement};let a=e,n=e.innerHTML||e.textContent,i=e.parentElement;for(;i&&i!==t&&t.contains(i);){const e=i.outerHTML;o+=e.indexOf(n),n=e,a=i,i=i.parentElement}return o+=(t.innerHTML||t.textContent).indexOf(n),{charOffset:o,parentElement:a}}_getPreSiblingOffset(e,t){let o=0,a=e.textContent,n=e.previousSibling;for(;n&&t.contains(n);){const e=n.outerHTML||n.textContent;a=e+a,o+=e.length,n=n.previousSibling}return o}_getSiblingsCharOffset(e,t){let o=0,a=e.nextSibling;if(e===t)return o;for(;a&&a!==t;)o+=(a.outerHTML||a.textContent).length,a=a.nextSibling;return o}_handleFullScreenMode(e){const t=this,o=t._toolbarItemsObj.fullscreen;let a;e?a=e.hasAttribute("checked"):(a=o?o.value:!t.classList.contains("full-screen-mode"),e=t.$.toolbar.querySelector('.smart-editor-toolbar-item[item-name="fullscreen"]')),t._closePopups(),t._setResizeFrame(),t._handleTableSelection(),a?(t.classList.add("full-screen-mode"),t._lastToolbarExpandedState=t.$.toolbar.hasAttribute("expanded")):(t.classList.remove("full-screen-mode"),t._lastToolbarExpandedState&&t._toggleToolbar()),o&&(o.value=a),e&&o&&(a?(e.setAttribute("cheched",""),e.setAttribute("aria-pressed",!0)):(e.removeAttribute("checked"),e.setAttribute("aria-pressed",!1)),o.disabled?(e.setAttribute("disabled",""),e.setAttribute("aria-disabled",!0)):(e.removeAttribute("disabled"),e.removeAttribute("aria-disabled")))}_handleSplitMode(e){const t=this,o=t.$.editableElement,a=t.$.input,n=t.$.contentContainer,i=t._toolbarItemsObj,r=i.splitmode,l=i.sourcecode,s=e?e.hasAttribute("checked"):!n.hasAttribute("split-mode"),d=t.editMode;t._closePopups(),s?("markdown"===d?o.innerHTML=window.marked?window.marked(a.value):a.value:a.value=o.innerHTML.trim(),n.setAttribute("split-mode",""),a.classList.remove("smart-hidden"),o.classList.remove("smart-hidden"),l&&t._setToolbarItemAttr("sourcecode","disabled",!0)):(n.removeAttribute("split-mode",""),"markdown"===d?o.classList.add("smart-hidden"):a.classList.add("smart-hidden"),l&&t._setToolbarItemAttr("sourcecode","disabled",!1)),r&&(r.value=s),e||(e=t.$.toolbar.querySelector('.smart-editor-toolbar-item[item-name="splitmode"]')),e&&(s?(e.setAttribute("checked",""),e.setAttribute("aria-pressed",!0)):(e.removeAttribute("checked"),e.setAttribute("aria-pressed",!1))),t._resizeFrameObj&&t._setResizeFrame(t._resizeFrameObj.target),t.classList.contains("preview-mode")&&t._handleSourceCodeMode()}_handleUndoRedo(e){this.$.editableElement.getRootNode().execCommand(e)}_handleTextCase(e){const t=this;if("markdown"===t.editMode)return;const o=t._getSelectionRange(),a=o.startContainer;if(!a)return;const n=a.textContent;let i,r,l,s,d=o.startOffset;a.nodeType===Node.TEXT_NODE&&o.startOffset===o.endOffset?(({selectionStartIndex:l,selectionEndIndex:s}=t._getTextFromCarret()),r=n.slice(l,s)):([l,s]=[d,o.endOffset],r=n.slice(d,o.endOffset),i=o.endOffset),r="lowercase"===e?r.toLowerCase():r.toUpperCase(),a.textContent=n.slice(0,l)+r+n.slice(s),t._setSelectionRange(a,d,i||d)}_handleList(e){const t=this;if(!e)return;if("markdown"===t.editMode){const o="orderedlist"===e?"1. ":"- ",a=t.$.input.selectionStart,n=t._getMarkdownFormat(a,"orderedlist"),i=t._getMarkdownFormat(a,"unorderedlist");if(n&&(t._removeMarkDown(o,n.occuranceIndex,"orderedlist"!==e),"orderedlist"===e))return;if(i&&(t._removeMarkDown(o,i.occuranceIndex,"unorderedlist"!==e),"unorderedlist"===e))return;return void t._insertMarkDown(o,t.$.input.selectionStart+o.length,!0)}let o,a,n=t._getSelectionRange();if(n.startContainer===n.endContainer&&(o=n.startOffset,a=n.endOffset),t.$.editableElement.getRootNode().execCommand("insert"+e,!1)){const e=t.$.iframe;n=(e?e.contentWindow:window).getSelection(),void 0!==a&&void 0!==a&&t._setSelectionRange(n.focusNode,o,a),t._updateToolbarItems(["orderedlist","unorderedlist"])}}_handleIndentation(e){"markdown"!==this.editMode&&this.$.editableElement.getRootNode().execCommand(e,!1)}_handleTextDelete(){this.$.editableElement.getRootNode().execCommand("delete")}_handleTabInsert(){this.$.editableElement.getRootNode().execCommand("insertHTML",!1,"&#009")}_handleTableToolbarAction(e,t){const o=this,a=o._toolbarItemClick;if(!t&&a&&(t=a.target),!t||"table"!==t.nodeName.toLowerCase()||!e)return;const n=e.getAttribute?e.getAttribute("item-name"):e.name,i=o.$.inlineToolbar;let r=e;if(r.closest){const e=o.$.inlineToolbar;r=(e&&e.contains(r)?o._inlineToolbarItemsObj:o._toolbarItemsObj)[n]}if(!a&&o.$.fireEvent("actionStart",{name:n}).defaultPrevented)return;switch(n){case"backgroundcolor":o._handleBackgroundColor(r);break;case"fontcolor":o._handleFontColor(r);break;case"fontsize":o._handleFontSize(r);break;case"tableheader":o._handleTableHeader(t);break;case"tablerows":o._handleTableRows(t,r);break;case"tablecolumns":o._handleTableColumns(t,r);break;case"tablevalign":o._handleTableVAlignment(t,r);break;case"alignment":o._handleTextAlignment(r);break;case"tablestyle":o._handleTableStyle(t,r);break;default:o._handleToolbarItemAction(e)}!a&&n&&o.$.fireEvent("actionEnd",{name:n}),i&&i.visible&&(o.$.editableElement.contains(i.selector)?i.reposition():o._closeToolbar());const l=o._getSelectionRange().startContainer;let s;if(l.nodeType===Node.TEXT_NODE){const e=l.parentElement;s=e.closest("th")||e.closest("td")}else s=["th","td"].indexOf(l.nodeName.toLowerCase())>-1;o._setResizeFrame(s&&t.contains(l)?t:void 0)}_handleTableHeader(e,t){let o,a,n=e.querySelector("th"),i=e.querySelector("tbody tr"),r=e.querySelector("thead");if(i&&(a=Array.from(i.children)),t||!r&&!n){if(void 0===t||!0===t){let t=e.querySelectorAll("tbody tr:first-of-type td").length;r||(r=document.createElement("thead")),o=r.querySelector("tr"),o||(o=document.createElement("tr"));const n=Array.from(o.children);for(;n.length>t;)n.pop().remove();for(let e=n.length;e<t;e+=1){const t=document.createElement("th");a[e]&&(t.style.width=a[e].style.width,a[e].style.width=""),o.appendChild(t)}r.appendChild(o),e.insertBefore(r,e.querySelector("tbody")||e.querySelector("tr"))}}else r&&r.remove(),n&&(o=n.closest("tr"),o&&o.remove(),Array.from(o.children).forEach(((e,t)=>a[t].style.width=e.style.width)))}_handleTableRows(e,t){if(!e)return;const o=this,a=o.$.inlineToolbar.selector,n=a.nodeName.toLocaleLowerCase();let i;if(!(a&&["th","td"].indexOf(n)>-1))return;if(i=a.closest("tr"),!i)return;const r=t.value,l=i.closest("thead");switch(r){case"insertRowAfter":case"insertRowBefore":{const t=document.createElement("tr"),o=i.parentElement;if(!o)break;const a=e.querySelector("tr").childElementCount,l="th"===n?"th":"td";for(let e=0;e<a;e+=1)t.appendChild(document.createElement(l));o.insertBefore(t,r.indexOf("Before")>-1?i:i.nextElementSibling);break}case"deleteRow":o._closeToolbar(),i.remove(),l&&!l.children.length&&l.remove()}const s=e.querySelectorAll("tr").length;s?(e.setAttribute("aria-rowcount",s),o._resizeFrameObj&&o._setResizeFrame(o._resizeFrameObj.target)):e.remove()}_handleTableColumns(e,t){if(!e)return;const o=this,a=o.$.inlineToolbar.selector;if(!(a&&["th","td"].indexOf(a.nodeName.toLowerCase())>-1))return;const n=t.value,i=Array.from(e.querySelectorAll("tr"));if(!i.length)return o._closeToolbar(),void e.remove();const r=Array.from(a.parentElement.children).indexOf(a);switch(n){case"insertColumnLeft":case"insertColumnRight":{const e=n.indexOf("Left")>-1;for(let t=0,o=i.length;t<o;t+=1){const o=i[t],a=o.children[r];if(a){const t="th"===a.tagName.toLowerCase()?"th":"td";o.insertBefore(document.createElement(t),e?a:a.nextElementSibling)}}break}case"deleteColumn":o._closeToolbar();for(let e=0,t=i.length;e<t;e+=1){const t=i[e].children[r];t&&t.remove()}}const l=i[0].children.length;l?(e.setAttribute("aria-colcount",l),o._resizeFrameObj&&o._setResizeFrame(o._resizeFrameObj.target)):e.remove()}_handleTextAlignment(e){if("markdown"===this.editMode)return;const t="justify"===e.value?"full":e.value;this.$.editableElement.getRootNode().execCommand("justify"+t.charAt(0).toUpperCase()+t.slice(1),!1,null)}_handleTableVAlignment(e,t){const o=this.$.inlineToolbar;if(!o)return;const a=o.selector;a&&["th","td"].indexOf(a.nodeName.toLowerCase())>-1&&(a.style.verticalAlign=t.value)}_handleTableStyle(e,t){const o=this.$.inlineToolbar.selector;if(o&&["th","td"].indexOf(o.nodeName.toLowerCase())>-1)switch(t.value){case"altrows":e.toggleAttribute("alternation");break;case"dashedborders":e.toggleAttribute("dashed-borders")}}_handleInlineToolbar(e){const t=this,o=e.nodeName.toLowerCase();"a"===o?(t._openInlineToolbar(e),t._refreshToolbarTabs()):"img"===o||["td","th"].indexOf(o)>-1?(t._setResizeFrame(e),t._openInlineToolbar(e),t._refreshToolbarTabs()):e.nodeType===Node.TEXT_NODE&&e.textContent.trim().length&&t._openInlineToolbar(e)}_handleTableCellResize(e){const t=this,o=t._inlineToolbarClickObj,a=o?o.resizeDetails:void 0;if(!a)return;const n=a.target,i=a.position,r=t.$.inlineToolbar;switch(a.started||t.$.fireEvent("resizeStart",{target:n}),n.setAttribute("resizing",""),a.started=!0,r&&r.visible&&(a.isInlineToolbarOpened=!0,t._closeToolbar()),i){case"horizontal":{const o=e.pageX+window.pageXOffset;if(t._setTableResizeDetails(a),!a.shrinkingCell)break;t._handleHorizontalTableCellResize(a,o);break}case"vertical":{const o=a.table;o.style.height&&(o.querySelectorAll("tr").forEach((e=>e.style.height=e.offsetHeight+"px")),o.style.height=""),t._resizeFrameObj&&t._resizeFrameObj.target&&t._setResizeFrame();const i=e.pageY+window.pageYOffset,r=a.y-i;let l=n.offsetHeight;l-=r,n.style.height=Math.max(1,l)+"px",l===n.offsetHeight&&(a.y=i+Math.abs(Math.min(0,l)));break}}}_setTableResizeDetails(e){const t=e.table,o=e.target;let a,n=e.expandingCell,i=e.shrinkingCell,r=e.isLastCell,l=e.areAllCellsResized;if(!n){const i=t.querySelector("tr"),r=Array.from(o.parentElement.children).indexOf(o);a=e.cells=Array.from(i.children),n=e.expandingCell=a[r]}e.shrinkingCell||(i=e.shrinkingCell=n.nextElementSibling,l=e.areAllCellsResized=!a.some((e=>e!==n&&e!==i&&!e.style.width)),r=e.isLastCell=l&&null===i.nextElementSibling,l&&!e.lastCell&&(e.lastCell=a[a.length-1]),r&&(i.style.width=""))}_handleHorizontalTableCellResize(e,t){const o=30,a=e.isLastCell;let n=e.expandingCell,i=e.shrinkingCell,r=n.offsetWidth,l=i.offsetWidth,s=e.x-t;const d=e.x-r+o,c=e.x+i.offsetWidth-o;if(a){const a=r+l-o;n.style.width=Math.min(Math.max(o,r-s),a)+"px",n.offsetWidth!==r&&(e.x=Math.min(c,Math.max(d,t)))}else{let a;s>0&&([n,i]=[i,n],[r,l]=[l,r],s*=-1),i.style.width=Math.max(o,l+s)+"px",a=i.offsetWidth-l,n.style.width=Math.max(o,n.offsetWidth-a)+"px",0!==a&&(e.x=Math.min(c,Math.max(d,t))),e.lastCell&&(e.lastCell.style.width="")}}_handleFrameResize(e){const t=this,o=t._resizeFrameObj;if(!o)return;t._closeToolbar();const a=o.resizableElement||o.target,n=o.resizeDetails,i=n.position,r=e.pageX+window.pageXOffset,l=e.pageY+window.pageYOffset,s=n.x-r,d=n.y-l;let c,m;c=a.offsetWidth,m=a.offsetHeight,n.started||(o.target.setAttribute("dragged",""),t.$.fireEvent("resizeStart",{target:a})),n.started=!0;const u=c,b=m,p=t.rightToLeft?-1:1;switch(i){case"top-left":a.style.width=Math.max(0,u+p*s)+"px",a.style.height=Math.max(0,b+d)+"px",c=a.offsetWidth,m=a.offsetHeight,u!==c&&(n.x-=p*(c-u)),b!==m&&(n.y-=m-b);break;case"bottom-left":a.style.width=Math.max(0,u+p*s)+"px",a.style.height=Math.max(0,b-d)+"px",c=a.offsetWidth,m=a.offsetHeight,u!==c&&(n.x-=p*(c-u)),b!==m&&(n.y+=m-b);break;case"bottom-right":a.style.width=Math.max(0,u-p*s)+"px",a.style.height=Math.max(0,b-d)+"px",c=a.offsetWidth,m=a.offsetHeight,u!==c&&(n.x+=p*(c-u)),b!==m&&(n.y+=m-b);break;case"top-right":a.style.width=Math.max(0,u+p*-s)+"px",a.style.height=Math.max(0,b+d)+"px",c=a.offsetWidth,m=a.offsetHeight,b!==m&&(n.y-=m-b),u!==c&&(n.x+=p*(c-u));break;case"top-center":a.style.height=Math.max(0,b+d)+"px",m=a.offsetHeight,b!==m&&(n.y-=m-b);break;case"bottom-center":a.style.height=Math.max(0,b-d)+"px",m=a.offsetHeight,b!==m&&(n.y+=m-b);break;case"left-center":a.style.width=Math.max(0,u+p*s)+"px",c=a.offsetWidth,u!==c&&(n.x-=p*(c-u));break;case"right-center":a.style.width=Math.max(0,u-p*s)+"px",c=a.offsetWidth,u!==c&&(n.x+=p*(c-u))}t._positionResizeHandles()}_deleteResizeFrameTarget(e){const t=this,o=t._getSelectionRange();if(e)if("img"===e.nodeName.toLowerCase()){const o=e.closest(".smart-editor-editable .smart-editor-image-container"),l=(o||e).parentElement,s=l&&"a"===l.nodeName.toLowerCase()?l:void 0;if(t._setResizeFrame(),(s||o||e).remove(),URL.revokeObjectURL(e.src),t.removeUrl){let o=new FormData,l=new XMLHttpRequest;const s=(e,t)=>{let o=e.split(","),a=o[0].match(/:(.*?);/)[1],n=atob(o[1]),i=n.length,r=new Uint8Array(i);for(;i--;)r[i]=n.charCodeAt(i);return new File([r],t,{type:a})};a=e.src,n=e.name,i=e=>{o.append(t.imageName,e),l.open("POST",t.removeUrl),l.send(o)},(r=new Image).crossOrigin="Anonymous",r.onload=function(){var e=document.createElement("canvas"),t=e.getContext("2d");e.height=this.naturalHeight,e.width=this.naturalWidth,t.drawImage(this,0,0);var o=e.toDataURL("image/jpeg");i(s(o,n))},r.src=a}t.onImageRemove&&t.onImageRemove(e.src)}else if(e.classList.contains("smart-editor-video-container")){const o=e.querySelector(".smart-editor-video-container video, .smart-editor-video-container > iframe");t._setResizeFrame(),e.remove(),o&&URL.revokeObjectURL(o.src)}else if("table"===e.nodeName.toLowerCase()){const o=e.closest(".smart-editor-editable table");o&&(t._setResizeFrame(),o.remove())}var a,n,i,r;t._setCharCount(),t._setSelectionRange(o.startContainer,o.startOffset,o.endOffset),t._focusEditableElement()}_setResizeFrame(e,t){const o=this,a=o.$.editableElement;let n,i=e?e.nodeName.toLowerCase():"",r=o._resizeFrameObj;if("td"!==i&&"th"!==i||(e=e.closest(".smart-editor-editable table")),i=e?e.nodeName.toLowerCase():"",e&&e.parentElement&&("img"===i||"table"===i||e.classList.contains("smart-editor-video-container"))&&"false"!==a.getAttribute("contenteditable"))if(r?n=r.element:(r=o._resizeFrameObj={},n=r.element=document.createElement("span"),n.classList.add("smart-editor-resize-frame"),n.innerHTML='<span position="top-left"></span><span position="top-right"></span>\n                                     <span position="bottom-left"></span><span position="bottom-right"></span>\n                                     <span position="top-center"></span><span position="bottom-center"></span>\n                                     <span position="left-center"></span><span position="right-center"></span>'),r.target&&r.target.removeAttribute("show-resize-frame"),r.target=e,e.classList.contains("smart-editor-video-container")?r.resizableElement=e.querySelector("video, iframe"):delete r.resizableElement,o._refreshToolbarTabs(),"false"!==e.getAttribute("resizable")){if(e.setAttribute("show-resize-frame",""),o._positionResizeHandles(),n.parentElement||o.$.contentContainer.appendChild(n),!t&&"img"===i){const e=o.$.iframe;(e?e.contentWindow:window).getSelection().collapse(null),o._updateToolbarItems()}}else e.removeAttribute("show-resize-frame");else{if(r){if(r.element.remove(),r.target){const e=a.querySelectorAll("[show-resize-frame]");for(let t=0,o=e.length;t<o;t+=1)e[t].removeAttribute("show-resize-frame")}delete r.target}o._refreshToolbarTabs()}}_setToast(){const e=this;let t=e.$.toast;return t||(e.$.toast=t=document.createElement("smart-toast"),t.appendTo=e.$.container,t.showCloseButton=!0,t.itemClass="smart-editor-message",e.$toast=Smart.Utilities.Extend(t)),t.rightToLeft=e.rightToLeft,t.theme=e.theme,t.animation=e.animation,t}_positionResizeHandles(){const e=this,t=e._resizeFrameObj;if(!e._resizeFrameObj)return;const o=t.element,a=e.rightToLeft,n=a?"right":"left",i=(t.resizableElement||t.target).getBoundingClientRect(),r=o.children,l=r[0],s=r[1],d=r[2],c=r[3],m=r[4],u=r[5],b=r[6],p=r[7],h=e.$.editableElement,g=e.$.contentContainer.getBoundingClientRect(),f=i.top-g.top+h.offsetTop,_=i.width,v=i.height;let w;a?(w=g.right-i.right+(h.offsetLeft+h.offsetWidth-g.width),l.style.left=d.style.left=b.style.left=""):(w=i.left-g.left+h.offsetLeft,l.style.right=d.style.right=b.style.right=""),l.style.top=s.style.top=m.style.top=f+"px",l.style[n]=d.style[n]=b.style[n]=w+"px",d.style.top=c.style.top=u.style.top=f+v+"px",s.style[n]=c.style[n]=p.style[n]=_+w+"px",m.style[n]=u.style[n]=w+_/2+"px",b.style.top=p.style.top=f+v/2+"px"}_openInlineToolbar(e){const t=this,o=t.$.editableElement;let a=t.$.inlineToolbar;if(t._closeToolbarItemDropDown(t.$.inputPopup),t._closeToolbarItemDropDown(t.$.colorInputPopup),"false"===o.getAttribute("contenteditable")||t.hideInlineToolbar)return void(a&&a.visible&&a.close());if(a||(a=t._createToolbar()),t.$.fireEvent("inlineToolbarOpening",{target:a}).defaultPrevented)return;t._setupToolbar(e,"inline"),a.parentElement||t.getShadowRootOrBody().appendChild(a);const n=t._getInlineToolbarContent(e);a.clear(),n instanceof DocumentFragment&&(a.appendChild(n),a.open(),t._setAriaOwns(a)),t._updateToolbarItems(void 0,a)}_closeToolbar(){const e=this,t=e.$.inlineToolbar;if(t){const o=t.classList,a=o.contains("smart-editor-context-menu")?"contextMenu":o.contains("smart-editor-inline-toolbar")?"inlineToolbar":"dropDownToolbar";if(e.$.fireEvent(a+"Closing",{target:t}).defaultPrevented)return;t.close()}}_closePopups(){const e=this;e._closeToolbar(),e._closeToolbarItemDropDown(e.$.inputPopup),e._closeToolbarItemDropDown(e.$.colorInputPopup)}_createToolbar(){const e=this;let t=e.$.inlineToolbar;return t||(t=document.createElement("smart-tooltip"),e.$.inlineToolbar=t,e.$inlineToolbar=Smart.Utilities.Extend(t),t)}_setupToolbar(e,t){const o=this,a=o.$.iframe,n=o.$.inlineToolbar,i=o.$inlineToolbar;if(!n.visible){const e=e=>o._tooltipVisibilityHandler.call(o,e),t=e=>o._tooltipVisibilityHandler.call(o,e),a=e=>o._tooltipChangeHandler.call(o,e),n=e=>o._tooltipClickHandler.call(o,e),r=e=>o._tooltipTransitionEndHandler.call(o,e);i.unlisten("open"),i.unlisten("close"),i.unlisten("change"),i.unlisten("click"),i.unlisten("transitionend"),i.listen("open",e),i.listen("close",t),i.listen("change",a),i.listen("click",n),i.listen("transitionend",r)}if(n.locale=o.locale,n.rightToLeft=o.rightToLeft,n.theme=o.theme,n.animation=o.animation,n.openMode="manual","inline"===t)n.position="auto",n.iframeRect=a?a.getBoundingClientRect():null,n.arrow=!0,n.align="center",n.offset=o.inlineToolbarOffset,n.classList.add("smart-editor-toolbar","smart-editor-inline-toolbar"),n.classList.remove("smart-editor-drop-down-toolbar","smart-editor-context-menu"),n.setAttribute("role","tooltip"),n.setAttribute("aria-label","Inline Toolbar");else{if("context"!==t)return n.position="auto",n.iframeRect=null,n.arrow=!1,n.align=o.rightToLeft?"right":"left",n.offset=[0,-5],n.selector=e,n.classList.add("smart-editor-toolbar","smart-editor-drop-down-toolbar"),n.classList.remove("smart-editor-inline-toolbar","smart-editor-context-menu"),n.setAttribute("role","tooltip"),void n.setAttribute("aria-label","Drop Down Toolbar");n.position="absolute",n.arrow=!1,n.classList.add("smart-editor-context-menu"),n.classList.remove("smart-editor-toolbar","smart-editor-drop-down-toolbar","smart-editor-inline-toolbar"),n.setAttribute("role","listbox"),n.setAttribute("aria-label","Context Menu")}if(n.selector&&!n.selector.closest&&delete n.selector.getBoundingClientRect,e.closest)n.selector=e;else{const t=e.parentElement,a=o._getSelectionRange();t.getBoundingClientRect=()=>a.getBoundingClientRect(),n.selector=t}}_getInlineToolbarContent(e){const t=this,o=t.$.inlineToolbar;if(o.innerHTML&&o.selector.nodeName===e.nodeName)return;let a;const n=t._toolbarItemsObj,i=e.nodeName.toLowerCase(),r=(e=[])=>{let t;for(let o=0,a=e.length;o<a;o+=1){const a=n[e[o]];if(a){t=a;break}}return t};let l;switch(i){case"a":l=r(["hyperlink","createlink"]);break;case"#text":l=r(["cut","copy","paste"]);break;case"img":l=r(["image"]);break;case"td":case"th":l=r(["table"]);break;default:return}return a=l&&Array.isArray(l.inlineToolbarItems)?l.inlineToolbarItems:t._getDefaultInlineToolbarItems(e,i),a.length?t._getToolbarItems(o,a):void 0}_getDefaultInlineToolbarItems(e,t){let o;switch(t){case"a":o=["openlink","editlink","removelink"];break;case"#text":o=["cut","copy","paste"];break;case"img":o=["image","alignment","createlink","delete","caption"],e.closest(".smart-editor-editable a")&&o.splice(o.indexOf("createlink")+1,0,"openlink","removelink");break;case"td":case"th":o=["table","tableheader","tablerows","tablecolumns","backgroundcolor","delete","alignment","tablevalign","tablestyle"];break;default:return[]}return o}_getNodes(e,t=0,o,a=0){const n=this,i=e.childNodes;let r=[];for(let e=0,l=i.length;e<l;e+=1){const l=i[e];if(l.childElementCount){const e=n._getNodes(l,t,o,a);if(a=e.index,e.nodes.length&&(r=r.concat(e.nodes)),a>=o)break}else if(l.nodeType===Node.TEXT_NODE){const e=l.nodeValue;if(!e.trim())continue;const n=e.length;if(a+n>t&&r.push({node:l,index:o-a,startIndex:Math.max(0,t-a)}),(a+=n)>o)break}else if((a+=(l.textContent||l.innerText||l.innerHTML).length)>t&&r.push({node:l,index:a}),a>o)break}return{nodes:r,index:a}}_tooltipChangeHandler(e){const t=this,o=e.target,a=t.$.inlineToolbar;a&&a.classList.contains("smart-editor-drop-down-toolbar")&&a.visible&&a.contains(o)?o.classList.contains("smart-table-picker")&&(t._handleTableInsert({cells:e.detail.value}),a.close()):t._changeHandler(e)}_tooltipClickHandler(e){const t=this,o=e.target,a=t.$.inlineToolbar;if(a&&a.classList.contains("smart-editor-drop-down-toolbar")&&a.contains(e.target)&&o.closest(".smart-table-picker-button")){const e=t._getSelectionRange();let o;return e.startContainer&&["th","td"].indexOf(e.startContainer.nodeName.toLowerCase())>-1&&(o=e.startContainer.closest(".smart-editor-editable table")),void t._openWindow(a.selector,o)}if(a&&a.classList.contains("smart-editor-context-menu")){const a=o.closest(".smart-editor-context-menu-item");if(a)return void t._handleContextMenuItemClick(e,a)}}_tooltipVisibilityHandler(e){const t=this,o=t.$.inlineToolbar,a=e.type;if(e.target!==o)return;const n=t.$.inlineToolbar,i=t.$inlineToolbar;let r;r=o.classList.contains("smart-editor-toolbar")?(o.classList.contains("smart-editor-drop-down-toolbar")?"inline":"dropDown")+"Toolbar":"contextMenu",e.stopPropagation(),"close"===e.type?(n.selector&&!n.selector.closest&&delete n.selector.getBoundingClientRect,n.hasAnimation||(i.unlisten(e.type),i.unlisten("change"),i.unlisten("click"),n.remove(),t._focusEditableElement()),t._setAriaOwns(o)):"open"===e.type&&t._setAriaOwns(o),t.$.fireEvent(r+a.slice(0,1).toUpperCase()+a.slice(1),Object.assign({target:e.target},e.detail))}_tooltipTransitionEndHandler(e){const t=this;if(!(e.target instanceof Smart.Tooltip))return;const o=t.$.inlineToolbar,a=t.$inlineToolbar;o.visible||(a.unlisten("transitionend"),o.style.top=o.style.left=0,o.remove(),t._setAriaOwns(o))}_toggleItemDropDown(e){const t=this,o=e.getAttribute("item-type");let a;if("drop-down"===o?(t.$.inputPopup||(t.$.inputPopup=document.createElement("smart-input")),a=t.$.inputPopup):"color-input"===o&&(t.$.colorInputPopup||(t.$.colorInputPopup=document.createElement("smart-color-input")),a=t.$.colorInputPopup),a.noRipple=!0,t.$.inputPopup&&a===t.$.colorInputPopup&&t.$.inputPopup.parentElement?t._closeToolbarItemDropDown(t.$.inputPopup):t.$.colorInputPopup&&a===t.$.inputPopup&&t.$.colorInputPopup.parentElement&&t._closeToolbarItemDropDown(t.$.colorInputPopup),a)if(a.locale=t.locale,a.rightToLeft=t.rightToLeft,a.theme=t.theme,a.animation=t.animation,e.contains(a)&&a.opened)t._closeToolbarItemDropDown(a);else{const o=t.$.inlineToolbar;o&&!o.contains(e)&&t._closeToolbar(),a.remove(),t._openToolbarItemDropDown(e,a)}}_toggleDropDownToolbar(e){const t=this;if(!e)return;if("table"!==e.getAttribute("item-name"))return;const o=t.$.inlineToolbar;if(o&&o.visible&&o.classList.contains("smart-editor-drop-down-toolbar")){if(o.contains(e)){const o=t._getSelectionRange();let a;return o.startContainer&&["th","td"].indexOf(o.startContainer.nodeName.toLowerCase())>-1&&(a=o.startContainer.closest(".smart-editor-editable table")),void t._openWindow(e,a)}o.classList.contains("smart-editor-drop-down-toolbar")&&o.close()}else t._closeToolbarItemDropDown(t.$.inputPopup),t._closeToolbarItemDropDown(t.$.colorInputPopup),t._openDropDownToolbar(e)}_openDropDownToolbar(e){const t=this;let o=t.$.inlineToolbar;o||(o=t._createToolbar()),t.$.fireEvent("dropDownToolbarOpening",{target:o}).defaultPrevented||(t._setupToolbar(e,"dropDown"),o.parentElement||t.getShadowRootOrBody().appendChild(o),t._setDropDownToolbarContent(e),o.open(),t._setAriaControls(e,o))}_setDropDownToolbarContent(e){const t=this,o=t.$.inlineToolbar,a=e.getAttribute("item-name");let n=t._dropDownToolbarObj;n||(n=t._dropDownToolbarObj={});let i=n[a];i||(i=document.createElement("smart-table-picker"),n[a]=i),i.rightToLeft=t.rightToLeft,i.locale=t.locale,i.messages=t.messages,i.value=[],o.contains(i)||(o.clear(),o.appendChild(i))}_openSearchBar(){const e=this,t=e.$.editableElement,o=e.$.contentContainer;let a=e._searchToolbar;if(e.disableSearchBar||t.classList.contains("smart-hidden"))return void(a&&a.remove());a||(a=e._searchToolbar=document.createElement("div"),a.classList.add("smart-editor-search-bar"),a.innerHTML='<span class="smart-search-input-container">\n                                    <input class="smart-search-input"></input>\n                                </span>\n                                <smart-button class="smart-search-button prev"></smart-button>\n                                <smart-button class="smart-search-button next"></smart-button>\n                                <smart-button class="smart-search-button close"></smart-button>'),a.ontransitionend=null;const n=e.animation,i=e.theme,r=e.rightToLeft,l=a.children;let s;for(let t=0,o=l.length;t<o;t+=1){const o=l[t];if(o.classList.contains("smart-search-input-container")){const t=o.firstElementChild;t.placeholder=e.localize("searchPlaceholder"),s=t}o.animation=n,o.theme=i,o.rightToLeft=r}if(o.contains(a)||o.appendChild(a),a.classList.remove("smart-visibility-hidden"),s){const t=e.$.iframe,o=(t?t.contentWindow:window).getSelection().toString();s.value=o,s.focus({preventScroll:!0}),o&&e._applySearching(o)}delete e._lastSearchQuery}_closeSearchToolbar(){const e=this,t=e._searchToolbar;if(t&&!t.classList.contains("smart-visibility-hidden")){t.classList.add("smart-visibility-hidden"),t.ontransitionend=()=>{t.remove(),t.ontransitionend=null};const o=Array.from(e.$.editableElement.querySelectorAll(".find-and-replace-match"));for(let e=0,t=o.length;e<t;e+=1){const t=o[e];t.outerHTML=t.textContent}e._focusEditableElement()}}_toggleWindow(e,t){const o=this;if(!e)return;const a=e.getAttribute("item-name"),n=o.$.window;if(!n)return void o._openWindow(e,t);const i=n._target?n._target.item:void 0;!i||i.name!==a||i.name===a&&!n.opened?o._openWindow(e,t):n.close()}_openWindow(e,t){const o=this;if(!e||!o._toolbarItemsObj||o._window&&o._window.opened)return;let a;t&&t.classList.contains("smart-editor-video-container")&&(t=t.querySelector(".smart-editor-video-container > video, .smart-editor-video-container > iframe"));const n=o.$.editableElement;if(e.closest){if(!e.classList.contains("smart-editor-toolbar-item"))return;a=(e.closest(".smart-editor-inline-toolbar")?o._inlineToolbarItemsObj:o._toolbarItemsObj)[e.getAttribute("item-name")]}else"object"==typeof e&&"string"==typeof e.name&&(a=e);if(!a||"findandreplace"===a.name&&n.classList.contains("smart-hidden"))return;const i=o._createWindow(a);o.$.fireEvent("dialogOpening",{target:i,item:a}).defaultPrevented||(o._closeToolbarItemDropDown(o.$.inputPopup),o._closeToolbarItemDropDown(o.$.colorInputPopup),i._target={item:a,itemTarget:t,originalTarget:e},o._closeToolbar(),i.parentElement||o.getShadowRootOrBody().appendChild(i),i.isCompleted?o._setupWindow():i.whenReady((()=>o._setupWindow())))}_closeWindow(){const e=this,t=e.$.window;t&&t.opened&&(e.$.fireEvent("dialogClosing",{target:t,item:t._target.item}).defaultPrevented||t.close())}_setupWindow(){const e=this,t=e.$.window,o=t._target,a=o.item;function n(){e._positionWindow(),t.opened?(t.bringToFront(),t._handleActiveState(),t._onOpenCallback&&t._onOpenCallback()):t.open()}if(t.locale=e.locale,t.rightToLeft=e.rightToLeft,t.theme=e.theme,t.animation=e.animation,e.windowCustomizationFunction?e.windowCustomizationFunction(t,a):(e._setPopupWindowTemplate("header",a),e._setPopupWindowTemplate("footer",a),e._setPopupWindowTemplate("content",a)),!t.opened){const o=e.$window,a=t=>e._windowOpenHandler.call(e,t),n=t=>e._windowCloseHandler.call(e,t),i=t=>e._windowClickHandler.call(e,t),r=t=>e._windowChangeHandler.call(e,t),l=t=>e._windowKeyDownHandler.call(e,t),s=t=>e._windowKeyUpHandler.call(e,t),d=t=>e._windowTransitionendHandler.call(e,t),c=t=>e._fileUploadCompletedHandler.call(e,t),m=t=>e._fileUploadErrorHandler.call(e,t);o.unlisten("transitionend"),o.unlisten("open"),o.unlisten("close"),o.unlisten("click"),o.unlisten("change"),o.unlisten("keydown"),o.unlisten("keyup"),o.unlisten("uploadCompleted"),o.unlisten("uploadError"),t._onOpenCallback=()=>{((t.shadowRoot||t).querySelector(".smart-editor-window-editor:not(.smart-hidden) .smart-input.smart-element")||t).focus({preventScroll:!0})},t.hasAnimation&&o.listen("transitionend",d),o.listen("open",a),o.listen("close",n),o.listen("click",i),o.listen("change",r),o.listen("keydown",l),o.listen("keyup",s),o.listen("uploadCompleted",c),o.listen("uploadError",m)}t.shadowRoot?e._onShadowDomLoaded(t,"smart.window.css",n):n(),e._setAriaOwns(t),e._setAriaControls(o.originalTarget,t)}_setPopupWindowTemplate(e,t){const o=this,a=o.$.window;if(!a)return;if("content"===e)return void o._setWindowContent(t);a[e+"Template"]||(a[e+"Template"]=o._createWindowTemplate(e));const n=a._target.item;if("header"===e)a.label=o.localize(n.name)||"";else if("footer"===e){const e=(a.shadowRoot||a).querySelectorAll(".smart-editor-window-button"),n="findandreplace"===t.name;for(let t=0;t<e.length;t++){const a=e[t];a.innerHTML='<span class="smart-icon"></span>',a.theme=o.theme,a.rightToLeft=o.rightToLeft,a.animation=o.animation,a.classList.contains("ok")?n?(a.classList.add("replace"),a.innerHTML+=o.localize("replace"),a.setAttribute("aria-label","replace")):(a.classList.remove("replace"),a.innerHTML+=o.localize("ok"),a.setAttribute("aria-label","ok")):a.classList.contains("cancel")?(a.innerHTML+=o.localize("cancel"),a.setAttribute("aria-label","cancel")):n?(a.classList.contains("replace-all")&&(a.innerHTML+=o.localize("replaceAll"),a.setAttribute("aria-label","replaceAll")),a.classList.remove("smart-hidden")):a.classList.add("smart-hidden");const i=a.querySelector(".smart-ripple");i&&i.parentElement.removeChild(i)}}}_setWindowContent(e){const t=this,o=t.$.window,a=o._target.originalTarget,n=[].slice.call(o.getElementsByClassName("smart-editor-window-editor"));if((!o.innerHTML||n.length)&&a){switch(e.name){case"createlink":case"editlink":case"hyperlink":case"image":case"video":case"table":case"paste":case"findandreplace":t._createWindowEditors(e)}a.id&&o.setAttribute("aria-controls",a.id)}}_createWindowEditors(e){const t=this,o=t.$.window,a=e.name;let n,i=t._windowEditors,r=o.querySelector(".smart-editor-window-content-wrapper");r||(r=document.createElement("div"),r.classList.add("smart-editor-window-content-wrapper"),o.appendChild(r)),t._windowEditors||(i=t._windowEditors={}),i&&(n=i[a]),n||(n=document.createElement("div"),n.classList.add(`smart-editor-window-${a}`),n.innerHTML=t._getWindowEditorTemplate(a),i[a]=n),r.contains(n)||(r.innerHTML="",r.appendChild(n));const l=n.querySelectorAll(".smart-editor-window-editor[type]");for(let e=0;e<l.length;e++)t._setPopupWindowEditor(l[e])}_getWindowEditorTemplate(e){switch(e){case"createlink":case"editlink":case"hyperlink":return'\n                <div class="smart-editor-window-editor" type="address">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="text">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="title">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="target">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>';case"image":return'\n                <div class="smart-editor-window-editor" type="file">\n                    <smart-file-upload item-editor></smart-file-upload>\n                </div>\n                <div class="smart-editor-window-editor" type="url">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="width">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="height">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="alt">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="title">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="caption">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="display">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="alignment">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="draggable">\n                    <smart-check-box item-editor></smart-check-box>\n                </div>\n                <div class="smart-editor-window-editor" type="resizable">\n                    <smart-check-box item-editor></smart-check-box>\n                </div>';case"table":return'\n                    <div class="smart-editor-window-editor" type="cols">\n                        <label></label>\n                        <smart-number-input item-editor></smart-number-input>\n                    </div>\n                    <div class="smart-editor-window-editor" type="rows">\n                        <label></label>\n                        <smart-number-input item-editor></smart-number-input>\n                    </div>\n                    <div class="smart-editor-window-editor" type="width">\n                        <label></label>\n                        <smart-input item-editor></smart-input>\n                    </div>\n                    <div class="smart-editor-window-editor" type="height">\n                        <label></label>\n                        <smart-input item-editor></smart-input>\n                    </div>\n                    <div class="smart-editor-window-editor" type="tableheader">\n                        <smart-check-box item-editor></smart-check-box>\n                    </div>\n                    <div class="smart-editor-window-editor" type="altrows">\n                        <smart-check-box item-editor></smart-check-box>\n                    </div>\n                    <div class="smart-editor-window-editor" type="dashedborders">\n                        <smart-check-box item-editor></smart-check-box>\n                    </div>\n                    <div class="smart-editor-window-editor" type="resizable">\n                        <smart-check-box item-editor></smart-check-box>\n                    </div>';case"paste":return'\n                    <div class="smart-editor-window-editor" type="keepFormat">\n                        <label></label>\n                        <smart-radio-button checked group-name="editorPasteViaWindow" item-editor></smart-radio-button>\n                    </div>\n                    <div class="smart-editor-window-editor" type="cleanFormat">\n                        <smart-radio-button group-name="editorPasteViaWindow" item-editor></smart-radio-button>\n                    </div>\n                    <div class="smart-editor-window-editor" type="plainText">\n                        <smart-radio-button group-name="editorPasteViaWindow" item-editor></smart-radio-button>\n                    </div>';case"findandreplace":return'\n                <div class="smart-editor-window-editor" type="find">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="replaceWith">\n                    <label></label>\n                    <smart-input item-editor></smart-input>\n                </div>\n                <div class="smart-editor-window-editor" type="results">\n                    <label></label>\n                    <smart-list-box virtualized item-editor></smart-list-box>\n                </div>\n                <div class="smart-editor-window-editor" type="matchCase">\n                    <smart-check-box item-editor></smart-check-box>\n                </div>';case"video":return'\n                        <div class="smart-editor-window-editor" type="file">\n                            <smart-file-upload item-editor></smart-file-upload>\n                        </div>\n                        <div class="smart-editor-window-editor" type="src">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="width">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="height">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="thumbnail">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="videoUrl">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="alt">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="title">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="caption">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="display">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="alignment">\n                            <label></label>\n                            <smart-input item-editor></smart-input>\n                        </div>\n                        <div class="smart-editor-window-editor" type="draggable">\n                            <smart-check-box item-editor></smart-check-box>\n                        </div>\n                        <div class="smart-editor-window-editor" type="resizable">\n                            <smart-check-box item-editor></smart-check-box>\n                        </div>';default:return""}}_setPopupWindowEditor(e){const t=this,o=e.getAttribute("type"),a=e.querySelector("label"),n=t.$.window._target,i=n.item,r="markdown"===t.editMode,l=i.editor;let s,d=e.querySelector("[item-editor]");if(a&&("paste"===i.name?(a.id=t.id+"pasteLabel",a.innerHTML=t.localize("pasteLabel")||""):(a.id=t.id+o+"Label",a.innerHTML=t.localize(o)||"")),!d)return;const c=t._toolbarItemClick;let m;switch(m=c?c.target:n.itemTarget,i.name){case"hyperlink":case"createlink":case"editlink":{const a=t._getSelectionRange();let n=a.startContainer;n&&"a"!==n.nodeName.toLowerCase()&&(n=n.parentElement),n&&"a"===n.nodeName.toLowerCase()?"address"===o?s=n.getAttribute("href"):"text"===o?s=n.textContent:"title"===o?s=n.title:"target"===o&&(s=n.target):s="text"===o?r?t.$.input.value.slice(a.selectionStart,a.selectionEnd):a.toString():l&&void 0!==l[o]?l[o]+"":"","target"===o&&r||m&&"img"===m.nodeName.toLowerCase()&&["title","text"].indexOf(o)>-1?e.classList.add("smart-hidden"):e.classList.remove("smart-hidden");break}case"video":case"image":{const a=t._toolbarItemClick,d=a?a.target:n.itemTarget;if(d&&["img","video","iframe"].indexOf(d.nodeName.toLowerCase())>-1){const e=d.closest(".smart-editor-image-container");switch(o){case"file":d.file instanceof File&&(s=d.file);break;case"url":case"src":s=d.file instanceof File?"":d.getAttribute("src")||"";break;case"alt":s=d.alt;break;case"title":s=d.title;break;case"width":if(s=d.style.width||(e?e.style.width:""),!s){const e=d.getAttribute("width");e&&(s=e)}break;case"height":if(s=d.style.height||(e?e.style.height:""),!s){const e=d.getAttribute("height");e&&(s=e)}break;case"caption":if(e){const t=e.querySelector(".smart-editor-image-caption");t&&(s=t.textContent)}void 0===s&&(s="");break;case"alignment":s=(e||d).getAttribute("alignment")||"";break;case"display":s=(e||d).getAttribute("display")||"";break;case"draggable":case"resizable":{const t=("video"===i.name?e:d).getAttribute(o);s=null==t||"true"===t;break}}}else s=l?("draggable"===o||"resizable"===o)&&void 0===l[o]||(void 0!==l[o]?l[o]+"":""):"width"===o?480:"height"===o?270:"draggable"===o||"resizable"===o||"";r&&["file","url","videoUrl","alt","title","thumbnail"].indexOf(o)<0||!r&&"video"===i.name&&["alt","thumbnail","videoUrl"].indexOf(o)>-1?e.classList.add("smart-hidden"):e.classList.remove("smart-hidden");break}case"table":{const t=n.itemTarget&&"table"===n.itemTarget.nodeName.toLowerCase()?n.itemTarget:void 0;switch(o){case"width":case"height":s=t?t.style[o]:l&&void 0!==l[o]?l[o]:"";break;case"cols":s=t?t.querySelector("tbody > tr").children.length+"":l&&void 0!==l[o]?l[o]:"1";break;case"rows":s=t?t.querySelectorAll("tbody > tr").length+"":l&&void 0!==l[o]?l[o]:"1";break;case"tableheader":s=!!r||(t?null!==t.querySelector("thead"):!(!l||void 0===l[o])&&l[o]);break;case"altrows":s=t?t.hasAttribute("alternation"):!(!l||void 0===l[o])&&l[o];break;case"dashedborders":s=t?t.hasAttribute("dashed-borders"):!(!l||void 0===l[o])&&l[o];break;case"resizable":s=t?!("false"===t.getAttribute("resizable")):!l||void 0===l[o]||l[o]}r&&["cols","rows","tableheader"].indexOf(o)<0?e.classList.add("smart-hidden"):e.classList.remove("smart-hidden");break}case"paste":s=o===t.pasteFormat;break;case"findandreplace":s=l&&void 0!==l[o]?l[o]:""}t._setupEditorElement(d,o,s),t._setEditorCommonProperties(d)}_setupEditorElement(e,t,o){const a=this,n=a.$.window._target.item,i=n.editor,r="markdown"===a.editMode;if((e instanceof Smart.CheckBox||e instanceof Smart.RadioButton)&&(e.innerHTML=a.localize(t)||"",e.checked=!!o),e instanceof Smart.NumberInput)e.min=1,e.value=parseInt(o);else{if(e instanceof Smart.FileUpload)return"file"===t&&e.isCompleted&&(e.cancelAll(),o&&e.addFile(o)),e.uploadUrl="",e.removeUrl="",e.autoUpload=!1,a.postData?e.postData=a.postData:a.getAttribute("post-data")&&(e.postData=JSON.parse(a.getAttribute("post-data"))),a.uploadUrl&&(e.uploadUrl=a.uploadUrl,a._fileUpload=e,a._fileUpload.name=a.imageName,e.autoUpload=a.autoUpload),a.removeUrl&&(e.removeUrl=a.removeUrl),a.validateFile&&(e.validateFile=a.validateFile),i&&(i.uploadUrl&&(e.uploadUrl=i.uploadUrl,e.autoUpload=!0),i.removeUrl&&(e.removeUrl=i.removeUrl)),e.dropZone=e.parentElement,e.accept=n.allowedTypes||(r||"video"!==n.name?"image/*":"video/mp4,video/x-m4v,video/*"),void(e.hideFooter=!0);if(e instanceof Smart.ListBox)e.selectionMode="one",e.itemHeight=35;else{if("string"==typeof e.placeholder&&(e.placeholder=a.localize(t+"Placeholder")||""),e.dropDownClassList&&(e.dropDownClassList=["smart-editor-input"]),void 0!==e.dataSource){if("target"===t||"alignment"===t||"display"===t){e.dataSource.length||(e.dataSource=a._getDefaultDataSource(t)),"alignment"!==t||o||(o="center");const n=o?e.dataSource.find((e=>"object"==typeof e&&e.value===o)):void 0;n&&"object"==typeof n&&(o=n.label||o),e.readonly=!n&&!o||n&&""!==n.value}else e.dataSource=[];"string"==typeof e.dropDownButtonPosition&&(e.dropDownButtonPosition=e.dataSource.length?a.rightToLeft?"left":"right":"none")}e.value=void 0===o?"":o+""}}}_setEditorCommonProperties(e){const t=this;if(e){const o=e.messages,a=t.messages,n=t.locale;for(let e in o.en){const t=a[n][e];void 0!==t&&(o[n]||(o[n]={}),o[n][e]=t)}e.locale=t.locale,e.rightToLeft=t.rightToLeft,e.animation=t.animation,e.theme=t.theme}}_createWindow(){const e=this,t=e.$.window;if(t)return t;const o=document.createElement("smart-window");return o.classList.add("smart-editor-window"),o.id=e.id+"Window",o.setAttribute("smart-id","window"),e.$.window=o,e.$window=Smart.Utilities.Extend(o),o.rightToLeft=e.rightToLeft,o.theme=e.theme,o.animation=e.animation,o.disableSnap=!0,o.headerButtons=["close"],o}_createWindowTemplate(e){const t=this,o=t.animation,a=t.theme,n=t.rightToLeft;let i;return"footer"===e&&(i=document.createElement("template"),i.innerHTML=`<smart-button class="smart-editor-window-button primary replace replace-all smart-hidden"\n                    animation="${o}" theme="${a}" ${n?"right-to-left":""}>\n                </smart-button>\n                <smart-button class="smart-editor-window-button ok primary"\n                    animation="${o}" theme="${a}" ${n?"right-to-left":""}>\n                </smart-button>\n                <smart-button class="smart-editor-window-button cancel"\n                    animation="${o}" theme="${a}" ${n?"right-to-left":""}>\n                </smart-button>`),i}_positionWindow(){const e=this,t=e.getShadowRootOrBody(),o=e.$.window;if(!o||!t.contains(o))return;const a=e.getBoundingClientRect();o.opened||(o.style.left=o.style.top=""),o.style.left=Math.max(a.left+window.pageXOffset,a.left+window.pageXOffset+a.width/2-o.offsetWidth/2)+"px",o.style.top=Math.max(a.top+window.pageYOffset,a.top+window.pageYOffset+a.height/2-o.offsetHeight/2)+"px"}_windowChangeHandler(e){const t=this,o=e.detail,a=t.$.window._target.item;let n=(e.originalEvent||e).target;const i=n.closest(".smart-editor-window-editor");if(!n.hasAttribute("item-editor")||!a||!i)return;const r=i.getAttribute("type");if(a.name.indexOf("link")>0&&"target"===r&&n instanceof Smart.Input)n.readonly=!!o.value.length;else if(t._windowEditors&&a.name.indexOf("findandreplace")>-1)if("results"===r&&n instanceof Smart.ListBox)t._handleMarkerSelection(e.target);else if("matchCase"===r&&n instanceof Smart.CheckBox){const e=i.parentElement.querySelector('.smart-editor-window-editor[type="find"] [item-editor]');e&&t._findMatches(e.value)}}_windowClickHandler(e){const t=this;let o=(e.originalEvent||e).target;o.shadowRoot&&(o=(e.originalEvent||e).composedPath()[0]);const a=t.$.window,n=a._target,i=o.closest(".smart-editor-window-button");if(a&&i&&n){if("findandreplace"===n.item.name){const e=i.classList,o=i.classList.contains("replace-all");if(o||e.contains("ok"))return void t._replaceMatches(a._target.item,o)}else if(i.classList.contains("ok")&&!1===t._updateEditorViaWindow(n.item))return;a.close(),delete a._target}}_windowCloseHandler(e){const t=this,o=e.target;if(!o.classList.contains("smart-editor-window"))return;const a=t.$window;if(a){t.$.fireEvent("dialogClose",{target:e.target,item:e.target._target.item}),a.unlisten("close"),a.unlisten("click"),a.unlisten("change"),a.unlisten("keydown"),a.unlisten("uploadCompleted"),a.unlisten("uploadError"),t.hasAttribute("aria-owns")&&t.removeAttribute("aria-owns"),t.hasAnimation||(o.remove(),t._setAriaOwns(o));const n=o._target,i=n.itemTarget;if("findandreplace"===n.item.name&&t._findMatches(""),t._focusEditableElement(),i&&["img","th","td","table"].indexOf(i.nodeName.toLowerCase())>-1)return void t._setResizeFrame(i)}}_windowKeyDownHandler(e){const t=this,o=t.$.window;if("Enter"!==e.key||!o._target)return;const a=o._target.item,n=o.getRootNode().activeElement;if(a&&n.closest(".smart-editor-window-editor")){if(!1===t._updateEditorViaWindow(a))return;e.stopPropagation(),e.preventDefault(),o.close(),delete o._target}}_windowKeyUpHandler(e){const t=this,o=e.target;if(o.closest('.smart-editor-window-editor[type="find"]')){const e=o.closest("[item-editor]");if(e){const o=t.findAndReplaceTimeout;if(clearTimeout(t._findAndReplaceTimeout),"html"!==t.editMode)return;o?t._findAndReplaceTimeout=setTimeout((()=>t._findMatches(e.value)),o):t._findMatches(e.value)}}}_windowOpenHandler(e){const t=this,o=e.target;if(!o.classList.contains("smart-editor-window"))return;const a=t.$window;if(a){const n=o._target.item;if(t._setAriaOwns(o),t.$.fireEvent("dialogOpen",{target:e.target,item:n}),a.unlisten("open"),"findandreplace"===n.name){const e=o.querySelector('.smart-editor-window-editor[type="find"] [item-editor]');t._findMatches(e?e.value:"")}}}_windowTransitionendHandler(e){const t=this,o=e.target;o.classList.contains("smart-editor-window")&&(o.opened||"visibility"!==e.propertyName||(t.$window.unlisten("transitionend"),t.$.window.remove(),t._setAriaOwns(o)))}_updateEditorViaWindow(e){const t=this;if(!e||!t._windowEditors)return;const o=t.$.iframe,a=t.$.editableElement;let n,i;t.$.contentContainer.contains(a.getRootNode().activeElement)||t._focusEditableElement(),o?(n=o.contentWindow,i=n.getSelection()):(n=window,i=window.getSelection());const r=t._windowEditors[e.name],l=t._getSelectionRange();let s;if(r&&!t.$.fireEvent("actionStart",{name:e.name}).defaultPrevented){switch(l instanceof n.Range&&(i.removeAllRanges(),i.addRange(l)),e.name){case"editlink":case"createlink":case"hyperlink":s=t._handleLinksInsert(e);break;case"image":s=t._handleImageInsert(e);break;case"table":t._handleTableInsert(t._getItemOptionsViaWindow(e));break;case"paste":t._handlePasteViaWindow(e);break;case"video":s=t._handleVideoInsert(e)}return t.$.fireEvent("actionEnd",{name:e.name}),s?(s(),!1):void 0}}_focusFirstInputCallback(e,t){const o=this._windowEditors[e];if(o)return()=>{const e=o.querySelector(`.smart-editor-window-editor[type="${t}"] .smart-input[item-editor]`);e&&e.focus({preventScroll:!0})}}_fileUploadCompletedHandler(e){const t=this.$.window;let o;t&&t.opened&&t._target&&(o=t._target.item),e.stopPropagation(),this.$.fireEvent("imageUploadSuccess",Object.assign({target:e.target,toolbarItem:o},e.detail));const a=e.detail.fileURL,n=e.detail.serverResponse,i=t.querySelector('[type="url"] [item-editor]');a?(i.value=a,i._details=e.detail):n&&(Array.isArray(n)?e.detail.serverResponse[0].file_url?i.value=e.detail.serverResponse[0].file_url:e.detail.serverResponse[0].fileURL&&(i.value=e.detail.serverResponse[0].fileURL):e.detail.serverResponse.file_url?i.value=e.detail.serverResponse.file_url:e.detail.serverResponse.fileURL&&(i.value=e.detail.serverResponse.fileURL))}_fileUploadErrorHandler(e){const t=this.$.window;let o;t&&t.opened&&t._target&&(o=t._target.item),e.stopPropagation(),this.$.fireEvent("imageUploadFailed",Object.assign({target:e.target,toolbarItem:o},e.detail))}_replaceMatches(e,t){const o=this,a=o.$.editableElement;if(!e||!o._windowEditors||"html"!==o.editMode||a.classList.contains("smart-hidden"))return;const n=o._getItemOptionsViaWindow(e),i=o._windowEditors[e.name],r=i.querySelector('.smart-editor-window-editor[type="results"] smart-list-box[item-editor]'),l=i.querySelector('.smart-editor-window-editor[type="results"] label'),s=r.selectedIndexes;if(!n||!s||!s.length)return;const d=n.replaceWith,c=Array.from(a.querySelectorAll(".find-and-replace-match"));for(let e=0,o=c.length;e<o;e+=1){const o=c[e];(t||s.indexOf(e)>-1)&&(o.outerHTML=d)}t?r.dataSource=[]:s.forEach((e=>r.removeAt(e))),o._setFindAndReplaceLabel(l,r)}_findMatches(e){const t=this,o=t.$.editableElement,a=t._windowEditors,n=a?a.findandreplace:void 0,i=n.querySelector('.smart-editor-window-editor[type="results"] smart-list-box[item-editor]'),r=n.querySelector('.smart-editor-window-editor[type="results"] label'),l=n.querySelector('.smart-editor-window-editor[type="matchCase"] smart-check-box[item-editor]'),s=t.$.window.querySelectorAll(".smart-editor-window-button.replace");i&&"smart-list-box"===i.nodeName.toLowerCase()&&(i.dataSource=[]),t._findAndReplaceTimeout&&(clearTimeout(t._findAndReplaceTimeout),delete t._findAndReplaceTimeout);const d=Array.from(o.querySelectorAll(".find-and-replace-match"));for(let e=0,t=d.length;e<t;e+=1){const t=d[e];t.outerHTML=t.textContent}if("html"===t.editMode)if(e){i.dataSource=t._getFindMarkers(o,new RegExp(e,"gm"+(l.checked?"":"i")),[]),i.select("0"),t._setFindAndReplaceLabel(r,i);for(let e=0,t=s.length;e<t;e+=1)s[e].disabled=!1}else{t._setFindAndReplaceLabel(r);for(let e=0,t=s.length;e<t;e+=1)s[e].disabled=!0}}_clearSearchToolbar(){const e=this,t=e._searchToolbar;t&&!t.classList.contains("smart-visibility-hidden")&&(t.value="",delete e._lastSearchQuery)}_applySearching(e){const t=this,o=t.$.editableElement;if(t._lastSearchQuery===e||o.classList.contains("smart-hidden"))return;const a=t.$.contentContainer.querySelector(".smart-search-input-container");let n;t._findAndReplaceTimeout&&(clearTimeout(t._findAndReplaceTimeout),delete t._findAndReplaceTimeout);const i=Array.from(o.querySelectorAll(".find-and-replace-match"));for(let e=0,t=i.length;e<t;e+=1){const t=i[e];t.outerHTML=t.textContent}if("html"===t.editMode){if(e){n=t._getFindMarkers(o,new RegExp(e,"gmi"),[]).length;const a=o.querySelector(".find-and-replace-match");a&&(a.classList.add("selected"),t._scrollToMarker(a))}a&&(a.setAttribute("matches",n||0),a.setAttribute("selected",n?1:0)),t._lastSearchQuery=e}}_scrollToMarker(e){const t=this,o=t._searchToolbar,a=o&&!t._searchToolbar.classList.contains("smart-visibility-hidden")?o.offsetHeight:0,n=t.$.editableElement,i=n.getBoundingClientRect(),r=e.getBoundingClientRect(),l=n.scrollLeft,s=n.scrollTop,d=i.height,c=i.width,m=r.height,u=r.width,b=r.top-i.top+s,p=r.left-i.left+l;s+a>b||l>p?n.scrollTo(p-c,b-a-10):(s+d<b+m||l+c<p+u)&&n.scrollTo(p+u-c,b+m-d)}_setFindAndReplaceLabel(e,t){if(!e)return;const o=t?t.items.length:0;if(!t||!o)return e.removeAttribute("matches"),void e.removeAttribute("selected");if(e){const a=t.selectedIndexes[0];e.setAttribute("matches",o),e.setAttribute("selected",a?a+1:1)}}_getFindMarkers(e,t,o){const a=this,n=Array.from(e.childNodes);for(let e=0,i=n.length;e<i;e+=1){const i=n[e];if(i.childElementCount)a._getFindMarkers(i,t,o);else if(i.textContent){const e=document.createDocumentFragment(),a=i.textContent;let n,r=0;if(a.matchAll)n=Array.from(a.matchAll(t));else{let e;for(n=[];e=t.exec(a);)n.push(e)}if(n.forEach((t=>{const a=t.input,n=t.index,i=t[0],l=a.substring(r,n),s=o.length,d=document.createElement("span");l.length&&e.appendChild(document.createTextNode(l)),d.classList.add("find-and-replace-match"),d.setAttribute("match-id",s),d.textContent=i,e.appendChild(d);const c=a.substring(Math.max(0,n-10),n),m=a.substr(n+i.length,10);o.push({label:`${n>0?"...":""}${c}<b>${i}</b>${m}${n<a.length-1?"...":""}`,value:s}),r=n+i.length})),!e.childElementCount)continue;const l=i.textContent.substr(r);l&&e.appendChild(document.createTextNode(l)),i.nodeType===Node.TEXT_NODE?(i.parentElement.insertBefore(e,i),i.remove()):(i.innerHTML="",i.appendChild(e))}}return o}_handleMarkerSelection(e){const t=this,o=e.selectedValues[0],a=t.$.editableElement.querySelectorAll(`.find-and-replace-match.selected, .find-and-replace-match[match-id="${o}"]`);let n;for(let e=0,t=a.length;e<t;e+=1){const t=a[e];t.getAttribute("match-id")===o?(t.classList.add("selected"),n=t):t.classList.remove("selected")}n&&t._scrollToMarker(n);const i=t._windowEditors,r=i?i.findandreplace:void 0,l=r?r.querySelector('.smart-editor-window-editor[type="results"] label'):void 0;if(l){const t=e.selectedIndexes;l.setAttribute("selected",t.length?t[0]+1:0)}}_handleImageInsert(e){const t=this,o=t._getItemOptionsViaWindow(e),a=t.$.window;if(!a)return;let n,i,r,l,s,d=a._target.itemTarget;if(o.file.length?(l=o.file[0],n=URL.createObjectURL(l)):o.url&&(n=o.url+""),!n&&o)return t._focusFirstInputCallback(e.name,"url");if("markdown"===t.editMode)return i=o.title?` "${o.title}"`:"",void t._insertMarkDown(`![${o.alt}](${n}${i})`);const c=t.$.iframe,m=t.$.editableElement,u=c?c.contentDocument:document;if(!d||"img"!==d.nodeName.toLowerCase()){const e=t.id+"newImage"+Math.random().toString(36).substr(2,5);s=u.execCommand("insertHTML",!1,`<img id="${e}"></img>`),d=m.querySelector("#"+e)}if(d&&"img"===d.nodeName.toLowerCase()){const e="inline"===o.display.toLowerCase()?"inline":"block",a=o.width+"",i=o.height+"";if(t._handleImgCaption(d,o),s&&(d.id=""),URL.revokeObjectURL(d.src),d.src=n,l&&(d.file=l,"base64"===t.imageFormat)){const e=new FileReader;e.readAsDataURL(l),e.onload=()=>d.src=e.result}if(t.uploadUrl&&t._fileUpload&&(d.name=n.replace(t.uploadUrl+"/",""),!t.autoUpload)){const e=e=>{t.$.fireEvent("imageUploadSuccess",e.detail);const o=e.detail.fileURL,a=e.detail.serverResponse;o?d.src=o:a&&(Array.isArray(a)?e.detail.serverResponse[0].file_url?d.src=e.detail.serverResponse[0].file_url:e.detail.serverResponse[0].fileURL&&(d.src=e.detail.serverResponse[0].fileURL):e.detail.serverResponse.file_url?d.src=e.detail.serverResponse.file_url:e.detail.serverResponse.fileURL&&(d.src=e.detail.serverResponse.fileURL))};t._fileUpload.onuploadcompleted=e,t._fileUpload.onuploaderror=e=>{console.error(e.detail)},t._fileUpload.uploadAll()}if(d.removeAttribute("width"),d.removeAttribute("height"),d.style.width=a&&"auto"!==a?parseFloat(a)+(a.indexOf("%")>-1?"%":"px"):"",d.style.height=i&&"auto"!==i?parseFloat(i)+(i.indexOf("%")>-1?"%":"px"):"",o.alt&&(d.alt=o.alt),o.title&&(d.title=o.title),o.alignment){const e=o.alignment.toLowerCase();r=e.indexOf("left")>-1?"left":e.indexOf("right")>-1?"right":"center"}d.setAttribute("resizable",o.resizable),d.setAttribute("draggable",o.draggable);const c=d.closest(".smart-editor-image-container");c?(c.setAttribute("alignment",r),c.setAttribute("display",e),d.removeAttribute("alignment"),d.removeAttribute("display")):(d.setAttribute("alignment",r),d.setAttribute("display",e))}}_handleVideoInsert(e){const t=this,o=t._getItemOptionsViaWindow(e),a=t.$.window;if(!a)return;let n,i,r,l,s=a._target.itemTarget;if(o.file.length?(r=o.file[0],n=URL.createObjectURL(r),s&&"video"!==s.nodeName.toLowerCase()&&(s.remove(),s=void 0)):(o.src||o.videoUrl)&&(n=(o.src||o.videoUrl)+"",s&&"iframe"!==s.nodeName.toLowerCase()&&(s.remove(),s=void 0)),s&&s.file&&(r=s.file),!n&&!r&&o)return t._focusFirstInputCallback(e.name,"src");if("markdown"===t.editMode)return i=o.title?` "${o.title}"`:"",void t._insertMarkDown(`[![${o.alt}](${n||o.thumbnail||""})](${o.videoUrl} ${i})`);const d=t.$.iframe,c=t.$.editableElement,m=d?d.contentDocument:document;if(!r||s&&"video"===s.nodeName.toLowerCase()){if(!(r||s&&"iframe"===s.nodeName.toLowerCase())){const e=t.id+"newVideo"+Math.random().toString(36).substr(2,5);l=m.execCommand("insertHTML",!1,`<iframe id="${e}" frameborder="0" allowfullscreen></iframe>`),s=c.querySelector("#"+e)}}else{const e=t.id+"newVideo"+Math.random().toString(36).substr(2,5);l=m.execCommand("insertHTML",!1,`<video id="${e}"></video>`),s=c.querySelector("#"+e)}if(s){if(l&&s.removeAttribute("id"),URL.revokeObjectURL(s.src),s.controls=!0,s.frameborder=0,s.allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture",t._handleVideoCaption(s,o),void 0!==o.width){const e=o.width+"";s.style.width=e?e+(e.indexOf("%")<0?"px":""):""}if(void 0!==o.height){const e=o.height+"";s.style.height=e?e+(e.indexOf("%")<0?"px":""):""}if(r){if(s.file===r)return;if(s.file=r,"base64"===t.imageFormat){const e=new FileReader;e.readAsDataURL(r),e.onload=()=>s.src=e.result}}else s.src!==n&&(s.src=n)}}_insertMarkDown(e,t,o){const a=this;if("markdown"!==a.editMode)return;const n=a.$.input,i=a._getSelectionRange(),r=i.selectionStart,l=i.selectionEnd;let s,d=n.value;if(void 0!==r&&r!==l&&(s=d.slice(r,l)),o){let t=d.lastIndexOf("\n",r-1)+1;for(;" "===d[t+1];)t++;n.value=d.slice(0,t)+e+d.slice(t)}else n.value=d.slice(0,n.selectionStart)+e+d.slice(n.selectionEnd);void 0!==r&&(void 0===t&&(t=r+e.length),s?o?a._setSelectionRange(n,r+e.length,l+e.length):(d=n.value,n.value=d.slice(0,t)+s+d.slice(t),a._setSelectionRange(n,t,t+s.length)):a._setSelectionRange(n,t,t)),a._refreshMarkdownPreview()}_removeMarkDown(e,t,o){const a=this,n=a.$.input,i=n.value,r=a._getSelectionRange(),l=r.selectionStart,s=r.selectionEnd,d=e.length;n.value=i.slice(0,t)+i.slice(t+d),a._setSelectionRange(n,l-d,s-d),o||a._refreshMarkdownPreview()}_handleLinksInsert(e){const t=this,o=t.$.window,a=t.editMode,n=t._getItemOptionsViaWindow(e);if(!n.address)return t._focusFirstInputCallback(e.name,"address");if("markdown"===a){let e;return e=n.title?`[${n.text}](${n.address}, "${n.title}")`:`[${n.text}](${n.address})`,void t._insertMarkDown(e)}const i=t.$.iframe,[r,l]=i?[i.contentDocument,i.contentWindow]:[document,window],s=l.getSelection();let d,c,m=s.anchorNode?s.anchorNode.parentElement:void 0,u=o&&o._target?o._target.itemTarget:void 0;u&&"img"===u.nodeName.toLowerCase()?(d=o._target.itemTarget,m=d.parentElement,m&&"a"===m.nodeName.toLowerCase()||(m=document.createElement("a"),d.parentElement.insertBefore(m,d),m.appendChild(d))):m=s.anchorNode?s.anchorNode.parentElement:void 0,n.address&&"a"!==m.nodeName.toLowerCase()&&(c=r.execCommand("createLink",!1,n.address),m=s.anchorNode.parentElement),"a"===m.nodeName.toLowerCase()&&(n.address?c||m.setAttribute("href",n.address):m.setAttribute("href",""),n.text?m.textContent=n.text:m.innerHTML||(m.textContent=n.address||""),m.title=n.title||"",m.target=n.target||"",d||s.selectAllChildren(m))}_refreshMarkdownPreview(){const e=this,t=e.$.input;if(e.$.contentContainer.hasAttribute("split-mode")){let o=t.value;e.$.editableElement.innerHTML=window.marked?window.marked(o):o}}_handleImgCaption(e,t){const o=this;if(!t)return;let a,n=e.closest(".smart-editor-image-container");const i=e.nodeName.toLowerCase(),r="video"===i||"iframe"===i&&e.src.indexOf("/embed")>-1;if(t.caption||r){if(n||(n=document.createElement("span"),n.classList.add("smart-editor-image-container"),n.setAttribute("draggable",!1),n.setAttribute("contenteditable",!1),e.hasAttribute("alignment")&&n.setAttribute("alignment",e.getAttribute("alignment")),e.hasAttribute("display")&&n.setAttribute("display",e.getAttribute("display")),e.parentElement.insertBefore(n,e),n.appendChild(e)),n.classList[r?"add":"remove"]("smart-editor-video-container"),a=n.querySelector(".smart-editor-image-caption"),a||(a=document.createElement("span"),a.setAttribute("contenteditable",!0),a.classList.add("smart-editor-image-caption"),n.appendChild(a)),a.textContent=t.caption,t.focusCaption)return delete o._toolbarItemClick,o._setSelectionRange(a),o._setResizeFrame(),void o.$.editableElement.scrollTo(a.offsetLeft,a.offsetTop)}else!t.caption&&n&&(n.hasAttribute("alignment")&&e.setAttribute("alignment",n.getAttribute("alignment")),n.hasAttribute("display")&&e.setAttribute("display",n.getAttribute("display")),n.parentElement.insertBefore(e,n),n.remove());o._resizeFrameObj&&o._resizeFrameObj.target&&o._setResizeFrame(o._resizeFrameObj.target,!0)}_handleVideoCaption(e,t){const o=this,a=e?e.nodeName.toLowerCase():void 0;if(!t||"video"!==a&&"iframe"!==a)return;let n=e.closest(".smart-editor-video-container");if(n||(n=document.createElement("span"),n.classList.add("smart-editor-image-container","smart-editor-video-container"),n.setAttribute("contenteditable",!1),e.parentElement.insertBefore(n,e),n.appendChild(e)),n.setAttribute("resizable",t.resizable),!1===t.draggable?n.setAttribute("draggable",!1):n.removeAttribute("draggable"),t.title&&(e.title=t.title),t.alignment){let e=t.alignment.toLowerCase();e=e.indexOf("left")>-1?"left":e.indexOf("right")>-1?"right":"center",n.setAttribute("alignment",e)}if(t.display){const e="inline"===t.display.toLowerCase()?"inline":"block";n.setAttribute("display",e)}if(t.caption){let e=n.querySelector(".smart-editor-image-caption");if(e||(e=document.createElement("span"),e.setAttribute("contenteditable",!0),e.classList.add("smart-editor-image-caption"),n.appendChild(e)),e.textContent=t.caption,t.focusCaption)return delete o._toolbarItemClick,o._setSelectionRange(e),o._setResizeFrame(),void o.$.editableElement.scrollTo(e.offsetLeft,e.offsetTop)}else if(!t.caption){let e=n.querySelector(".smart-editor-image-caption");e&&e.remove()}o._resizeFrameObj&&o._resizeFrameObj.target&&o._setResizeFrame(o._resizeFrameObj.target,!0)}_handleTableInsert(e){const t=this,o=t.editMode;if(!e)return;if("markdown"===o)return void t._insertTableMarkdown(e);const a=t._getSelectionRange();let n,i,r,l;if(e.cells){const t=e.cells;[r,l]=[t[1],t[0]]}else{let t=a.startContainer;[r,l]=[parseInt(e.cols),parseInt(e.rows)],t.nodeType===Node.TEXT_NODE&&(t=t.parentElement),n=t&&t.closest&&t.closest(".smart-editor-editable table")}if(!n){const e=t.$.editableElement,o=t.$.iframe,r=(o?o.contentWindow:window).getSelection();r.removeAllRanges(),r.addRange(a);const l=t.id+"newTable"+Math.random().toString(36).substr(2,5);i=(o?o.contentDocument:document).execCommand("insertHTML",!1,`<table id="${l}"><tbody></tbody></table>`),n=e.querySelector("#"+l)}if(n&&"table"===n.nodeName.toLowerCase()){let o,a=n.querySelector("tbody");for(a?o=Array.from(a.children):(n.innerHTML="<tbody></tbody>",a=n.firstElementChild,o=[]);o.length>l;)o.pop().remove();for(let e=o.length,t=l;e<t;e+=1)o.push(document.createElement("tr"));for(let e=0,t=o.length;e<t;e+=1){const t=o[e],n=Array.from(t.children);for(;n.length>r;)n.pop().remove();for(let e=0,o=r;e<o;e+=1){let o=n[e];o||(o=t.appendChild(document.createElement("td")))}t.parentElement||a.appendChild(t)}void 0===e.tableheader?e.tableheader=!!n.querySelector("th"):void 0===e.altrows?e.altrows=n.hasAttribute("alternation"):void 0===e.dashedborders?e.dashedborders=n.hasAttribute("dashed-borders"):void 0===e.resizable&&(e.resizable="false"!==n.getAttribute("resizable")),t._handleTableHeader(n,e.tableheader),e.altrows?n.setAttribute("alternation",""):n.removeAttribute("alternation"),e.dashedborders?n.setAttribute("dashed-borders",""):n.removeAttribute("dashed-borders");const s=e.width,d=e.height;n.style.width=s?s+(s.indexOf("%")<0?"px":""):"",n.style.height=d?d+(d.indexOf("%")<0?"px":""):"",i&&n.removeAttribute("id"),n.setAttribute("aria-rowcount",l),n.setAttribute("aria-colcount",r),n.setAttribute("resizable",e.resizable)}t._setResizeFrame(n)}_insertTableMarkdown(e){const t=this,o=e.cells,[a,n]=o?[o[1],o[0]]:[parseInt(e.cols),parseInt(e.rows)],i=t.localize("alphabet"),r=t.localize("header"),l=t.localize("column");let s="";if(!1!==e.tableheader){let e="",t=Math.max(3,r.length)+3;for(;t>0;)e+="-",t--;for(let e=1;e<=a;e+=1)s+=`| ${r} ${e} `;s+="|\n";for(let t=0;t<a;t++)s+=`|${e} `;s+="|\n"}for(let e=0;e<n;e++){const t=i[Math.max(0,e-1)%i.length].toUpperCase();for(let e=1;e<=a;e+=1)s+=`| ${l} ${t} ${e} `;s+="|\n"}t._insertMarkDown(s)}_handleTableSelection(e){const t=this,o=t.$.editableElement;if(t._tableCell&&t._tableCell.removeAttribute("selected"),"false"!==o.getAttribute("contenteditable"))return e&&["th","td"].indexOf(e.nodeName.toLowerCase())>-1?(t._tableCell=e,void e.setAttribute("selected","")):void delete t._tableCell}_getItemOptionsViaWindow(e){const t=this._windowEditors[e.name];if(!t)return;const o=t.children;let a={};for(let e=0,t=o.length;e<t;e+=1){const t=o[e].getAttribute("type"),n=o[e].querySelector("[item-editor]");let i;if(t){if(n instanceof Smart.Input)if(void 0===n.$.input.dataValue&&n.dataSource&&n.dataSource.length){const e=n.dataSource[0];i="string"==typeof e?e:e.value||e.label}else i=n.$.input.dataValue||n.value;else n instanceof Smart.CheckBox||n instanceof Smart.RadioButton?i=n.checked:n instanceof Smart.FileUpload?i=n.value:n instanceof Smart.ListBox&&(i=n.selectedIndexes);a[t]=i}}return a}_closeToolbarItemDropDown(e){const t=this,o=()=>{e.opened||e.remove()};e&&(e.opened?(e.hasAnimation&&(e.removeEventListener("transitionend",o),e.addEventListener("transitionend",o,{once:!0})),e.close(),t._setAriaOwns(e)):o())}_openToolbarItemDropDown(e,t){const o=this,a=e.getBoundingClientRect();o._setupDropDown(e,t),t.style.width=a.width+"px",t.style.height=a.height+"px",e.contains(t)||e.appendChild(t),t.open(),o._setAriaOwns(t),o._setAriaControls(e,t)}_setupDropDown(e,t){const o=this,a=o.$.inlineToolbar,n=a&&a.contains(e)?o._inlineToolbarItemsObj:o._toolbarItemsObj,i=n?n[e.getAttribute("item-name")]:void 0;let r;if(i&&(r=i.dataSource),r||(r=[]),t instanceof Smart.ColorInput?t.dropDownClassList=["smart-editor-color-input"]:(t.dropDownClassList=["smart-editor-input"],t.dropDownHeight=310),t.classList.add("smart-editor-item-drop-down"),t.readonly=!0,t.dataSource=r,t.dropDownOpenMode="manual",t.dropDownButtonPosition=o.rightToLeft?"left":"right",void 0!==i.value){const e=i.name;t.value=e.indexOf("table")>-1||e.indexOf("paste")>-1?"":i.value+""}else t.value=""}_toggleToolbar(e){const t=this,o=t.$.toolbar,a=t.$.contentContainer,n=t.toolbarViewMode,i="toggle"===n,r=t.$.toolbarToggleButton,l=t.$.toolbarItemsPrimary,s=t.hasAnimation;o.style.transition=s&&i?"none":"",o.style.height="";const d=o.offsetHeight,c=a.offsetHeight;if(e&&"toggle"===n){if(r.removeAttribute("checked"),r.setAttribute("aria-pressed",!1),!o.hasAttribute("expanded"))return void(o.style.transition="");o.removeAttribute("expanded")}else{if(r.setAttribute("checked",""),r.setAttribute("aria-pressed",!0),o.hasAttribute("expanded"))return o.style.transition="",void(t.$.toolbarItemsSecondary.innerHTML&&t._refreshToolbarItems());"scroll"!==n?o.setAttribute("expanded",""):o.removeAttribute("expanded")}if(t._refreshToolbarItems(),"menu"!==t.toolbarMode)return void(o.hasAttribute("expanded")?(l.querySelector(".smart-editor-toolbar-tab[checked]")||t._selectToolbarTab(l.firstElementChild),t._toggleSecondaryToolbar(!0)):(t._selectToolbarTab(null),t._toggleSecondaryToolbar()));if(!i)return;const m=o.offsetHeight,u=t.$.inlineToolbar;u&&u.visible&&u.reposition(),t._resizeFrameObj&&t._setResizeFrame(t._resizeFrameObj.target),o.style.height=d+"px",a.style.height=c+"px",s?requestAnimationFrame((()=>{o.style.transition="",o.style.height=m+"px",a.style.height=c+d-m+"px",requestAnimationFrame((()=>o.style.height=a.style.height=""))})):(o.style.transition="",o.style.height=m+"px",a.style.height=c+d-m+"px",requestAnimationFrame((()=>o.style.height=a.style.height="")))}_predefPropertyGetter(e="value"){const t=this;Object.defineProperty(t,e,{get:function(){return t.context===t?t.properties[e].value:t._getCurrentValue()},set(o){t._properties[e].value=t._getCurrentValue(),t.updateProperty(t,t._properties[e],o)}})}_getCurrentValue(){const e=this;if("markdown"===e.editMode)return e.$.input.value;let t=e.$.editableElement.innerHTML;return e.enableHtmlEncode&&(t=t.replaceAll("<","&lt;").replaceAll(">","&gt;")),t}_getInputValue(e,t){const o=this.$.input;return void 0===e&&(e=o.value),e=!t&&this.enableHtmlEncode?e.replaceAll("<","&lt;").replaceAll(">","&gt;"):e.replaceAll("&lt;","<").replaceAll("&gt;",">")}_handleEditMode(e){const t=this,o=t.$.input,a=t.$.editableElement,n=t.editMode,i=t._toolbarItemsObj.sourcecode,r=!!i&&i.value;t._closePopups(),"html"===e?r?o.value=a.innerHTML:a.innerHTML=o.value:"markdown"===e&&(r?a.innerHTML=window.marked?window.marked(o.value):o.value:o.value=a.textContent,t._closeSearchToolbar()),t.$.contentContainer.hasAttribute("split-mode")||("markdown"===n?r?(o.classList.add("smart-hidden"),a.classList.remove("smart-hidden")):(o.classList.remove("smart-hidden"),a.classList.add("smart-hidden")):r?(o.classList.remove("smart-hidden"),a.classList.add("smart-hidden")):(o.classList.add("smart-hidden"),a.classList.remove("smart-hidden"))),t.readonly||t.disableEditing||t.$.editableElement.setAttribute("contenteditable","markdown"!==n)}_handleInputContent(e,t){const o=this,a=o.$.editableElement,n=o.$.input,i=o.editMode;if(!o.isRendered&&o.autoLoad){const e=window.localStorage.getItem("smartEditor"+o.id);e&&o.set("value",e)}const r=o.value;void 0===t&&r&&(t=r),void 0!==t?"html"===i?o.$.editableElement.innerHTML=t:o.$.input.value=t:t||"markdown"!==i||(o.$.input.value=o.$.editableElement.textContent),o.$.contentContainer.hasAttribute("split-mode")?"markdown"===i?a.innerHTML=window.marked?window.marked(n.value):n.value:n.value=a.innerHTML.trim():o.classList.contains("preview-mode")&&("markdown"===i?a.innerHTML=window.marked?window.marked(n.value):n.value:n.value=a.innerHTML),a.textContent.length&&a.innerText.length?(a.removeAttribute("show-placeholder"),o._handleContentFiltering()):a.setAttribute("show-placeholder",""),o._clearSearchToolbar()}_sanitize(e,t){return this.sanitized?t.replaceAll(/(<[\/]?script[>]?)|([on].*=['"`]?.*['"`]?)|(SRC=['"`]?javascript:['"`]?)/gim,""):t}_handleContentFiltering(){const e=this,t=e.contentFiltering;if("html"===!e.editMode)return;const o=t.tags.map((e=>e.trim())),a=t.attributes.map((e=>e.trim())),n=t.styleAttributes.map((e=>e.trim()));if(!o.length&&!a.length&&!n.length)return;const i=t.tagFilterMode,r=t.attributeFilterMode,l=t.styleAttributeFilterMode;let s=e.$.editableElement.innerHTML;if(o.length){const e=new RegExp(/<\s*\/?\s*([a-z0-9]+).*?>/,"gmi");let t,a=[];for(;null!==(t=e.exec(s));){const e=t[1],n=o.indexOf(e)>-1;(n&&"blackList"===i||!n&&"whiteList"===i)&&a.push(t[0])}a.forEach((e=>s=s.replace(e,"")))}e.$.editableElement.innerHTML=s;const d=e.$.editableElement.querySelectorAll("*");for(let e=0,t=d.length;e<t;e+=1){const t=d[e];if(a.length){const e=Array.from(t.attributes);for(let o=0,n=e.length;o<n;o+=1){const n=e[o].name,i=a.indexOf(n)>-1;(i&&"blackList"===r||!i&&"whiteList"===r)&&t.removeAttribute(n)}}if(n.length){const e=t.getAttribute("style");if(!e)continue;const o=e.split(";");let a=[];for(let e=0,t=o.length;e<t;e+=1){const t=o[e],i=t.indexOf(":"),r=n.indexOf(t.slice(0,i>0?i:void 0))>-1;(r&&"whiteList"===l||!r&&"blackList"===l)&&a.push(t)}o.length&&(a.length?t.setAttribute("style",a.join(";")):t.removeAttribute("style"))}}e._setCharCount()}_handleContextMenuItemClick(e,t){if(!t||!t.classList.contains("smart-editor-context-menu-item"))return;const o=this,a=o.$.inlineToolbar,n=t.getAttribute("value");if(!a)return;const i=a.selector;switch(n){case"imageProperties":o._openWindow({name:"image"},i.closest(".smart-editor-editable img"));break;case"linkProperties":o._openWindow({name:"hyperlink"});break;case"tableProperties":o._openWindow({name:"table"},i.closest(".smart-editor-editable table"));break;case"videoProperties":{const e=i.closest(".smart-editor-video-container");if(e){const t=e.querySelectorAll(".smart-editor-video-container > video, .smart-editor-video-container > iframe");o._openWindow({name:"video"},t[0]||t[1])}break}case"insertRowAfter":case"insertRowBefore":case"deleteRow":o._handleTableRows(i.closest(".smart-editor-editable table"),{value:n});break;case"insertColumnLeft":case"insertColumnRight":case"deleteColumn":o._handleTableColumns(i.closest(".smart-editor-editable table"),{value:n});break;case"deleteImage":case"deleteTable":{const e=o._resizeFrameObj?o._resizeFrameObj.target:void 0;e&&o._deleteResizeFrameTarget(e);break}case"deleteVideo":{const e=i.closest(".smart-editor-video-container");if(e){const t=o._resizeFrameObj?o._resizeFrameObj.target:void 0;if(t===e){o._deleteResizeFrameTarget(t);break}e.remove()}break}case"createLink":o._openWindow({name:"hyperlink"},i.closest(".smart-editor-editable img"));break;case"deleteLink":o._handleLinkRemove(i);break;case"copyImage":o._handleImageCopy(i.closest(".smart-editor-editable img"));break;case"cutImage":o._handleImageCut(i.closest(".smart-editor-editable img"));break;case"copyVideo":o._handleImageCopy(i.closest(".smart-editor-video-container"));break;case"cutVideo":o._handleImageCut(i.closest(".smart-editor-video-container"));break;case"copy":case"cut":case"paste":o._handleClipboardAction(n);break;case"caption":{const e=i.closest(".smart-editor-editable img");let t;if(e&&"img"===e.nodeName.toLowerCase()){const a=e.closest(".smart-editor-image-container");a&&a.querySelector(".smart-editor-image-caption")||(t=o.localize("captionPlaceholder")),o._handleImgCaption(e,{caption:t,focusCaption:!0})}else if(i.classList.contains("smart-editor-video-container")){const e=i.querySelectorAll(".smart-editor-video-container > video, .smart-editor-video-container > iframe");i.querySelector(".smart-editor-image-caption")||(t=o.localize("captionPlaceholder")),o._handleVideoCaption(e[0]||e[1],{caption:t,focusCaption:!0})}break}case"selectAll":o._selectAll()}o.$.fireEvent("contextMenuItemClick",{originalEvent:e,value:n}),o._closeContextMenu()}_handleImageCopy(e){const t=this;if(!e||"img"!==e.nodeName.toLowerCase()&&!e.classList.contains("smart-editor-video-container"))return;const o=t._createWhiteSpaceChar(e,e.classList.contains("smart-editor-video-container")?e:void 0);t._setSelectionRange(e),t.$.editableElement.getRootNode().execCommand("copy"),o&&o.remove()}_handleImageCut(e){const t=this;if(!e||"img"!==e.nodeName.toLowerCase()&&!e.classList.contains("smart-editor-video-container"))return;const o=t._createWhiteSpaceChar(e,e.classList.contains("smart-editor-video-container")?e:void 0);t._setSelectionRange(e),t.$.editableElement.getRootNode().execCommand("cut"),t._setResizeFrame(),o&&o.remove()}_createWhiteSpaceChar(e,t){if(!t)return;const o=document.createElement("span");return o.innerHTML="&nbsp;",o.classList.add("smart-editor-video-white-space"),e.appendChild(o),o}_handleInputElement(){const e=this,t=e.iframeSettings,o=e.$.contentContainer,a=e.$.container,n=e.$.editableElement,i=e.$.input,r=e.readonly,l=e.disableEditing;if(n.contentEditable=!r&&!l,i.readonly=r||l,e._handlePlaceholder(),e._closePopups(),t.enabled?e._handleIframeSettings():a.contains(o)||(a.appendChild(o),n.setAttribute("contenteditable",!0),e.$.iframe&&(e.$.iframe.remove(),e._removeIframeEventListeners(),delete e.$.iframe)),"markdown"===e.editMode){const t=e.$.editableElement;e.$.input.classList.remove("smart-hidden"),t.classList.add("smart-hidden")}}_handleToolbarMode(){const e=this,t=e.$.toolbar,o=e.$.toolbarItemsSecondary,a=e.toolbarMode;e.$.toolbarItemsPrimary.innerHTML=o.innerHTML="","menu"===a?(o.classList.remove("smart-drop-down"),o.style.top=o.style.height="",t.contains(o)||t.appendChild(o),e._refreshToolbarItems(e._getToolbarItems())):(e._setToolbarTabs(),e._setToolbarItemGroups(),e._toolbarItemsObj||(e._toolbarItemsObj={}),e._refreshToolbarItems()),e._setToolbarGroupHeight()}_setToolbarTabs(){const e=this,t=e.toolbarRibbonConfig,o=e.$.toolbarToggleButton,a=e.$.toolbarItemsPrimary,n=a.querySelectorAll(".smart-editor-toolbar-tab"),i=document.createDocumentFragment();let r;for(let o=0,a=t.length;o<a;o+=1){const a=t[o];let l=n[o];l||(l=document.createElement("div")),l.classList.add("smart-editor-toolbar-tab"),l.setAttribute("tab-name",a.name),l.textContent=e.localize(a.name),!r&&l.hasAttribute("checked")&&(r=l),r!==l&&l.removeAttribute("checked"),l.classList[a.hidden?"add":"remove"]("smart-hidden"),i.appendChild(l)}o.hasAttribute("checked")&&!r&&i.children[0].setAttribute("checked",""),a.appendChild(i)}_setToolbarItemGroups(){const e=this,t=e.toolbarRibbonConfig,o=Array.from(e.$.toolbarItemsPrimary.querySelectorAll(".smart-editor-toolbar-tab")).find((e=>e.hasAttribute("checked")));if(!t||!o)return;const a=o.getAttribute("tab-name"),n=t.find((e=>e.name===a)),i=n?n.groups:null,r=e.$.toolbarItemsSecondary,l="singleLineRibbon"===e.toolbarMode;if(r.innerHTML="",!Array.isArray(i))return;const s=r.querySelectorAll(".smart-editor-toolbar-tab-group"),d=document.createDocumentFragment();for(let t=0,o=i.length;t<o;t+=1){const o=i[t],a=o.name;let n=s[t];if(n||(n=document.createElement("div")),l)n.innerHTML="",n.appendChild(e._getToolbarItems(e.$.toolbar,o.items));else{n.innerHTML='<div class="smart-editor-tab-group-container"></div><div class="smart-editor-tab-group-label"></div>';const t=n.firstElementChild;n.lastElementChild.innerHTML=e.localize(a),t.appendChild(e._getToolbarItems(e.$.toolbar,o.items))}n.classList.add("smart-editor-toolbar-tab-group"),n.setAttribute("group-name",a),d.appendChild(n)}r.appendChild(d),r.classList.remove("smart-visibility-hidden"),e._refreshToolbarTabs()}_refreshToolbarTabs(){const e=this,t=e._resizeFrameObj,o=Array.from(e.$.toolbarItemsPrimary.children).find((e=>"layouttab"===(e.getAttribute("tab-name")||"").toLowerCase()));if(!o)return;if(!t||!t.target||"singleLineRibbon"!==e.toolbarMode)return o.classList.add("smart-hidden"),void(o.hasAttribute("checked")&&e._selectToolbarTab(e.$.toolbarItemsPrimary.firstElementChild));const a=e.$.toolbarItemsSecondary.children,n=t.target,i=n.nodeName.toLowerCase();let r,l,s;for(let e=0,t=a.length;e<t;e+=1){const t=a[e],o=t.getAttribute("group-name");"tableGroup"===o?(l=t,l.classList.add("smart-hidden")):"imageGroup"===o?(r=t,r.classList.add("smart-hidden")):"videoGroup"===o&&(s=t,s.classList.add("smart-hidden"))}"table"===i?(o.classList.remove("smart-hidden"),l&&l.classList.remove("smart-hidden")):"img"===i?(o.classList.remove("smart-hidden"),r&&r.classList.remove("smart-hidden")):n.classList.contains("smart-editor-video-container")?(o.classList.remove("smart-hidden"),s&&s.classList.remove("smart-hidden")):o.classList.add("smart-hidden")}_handlePlaceholder(){const e=this.$.editableElement,t=this.placeholder;t?e.setAttribute("placeholder",t):e.removeAttribute("placeholder")}_handleIframeSettings(){const e=this;e.iframeSettings.enabled&&(()=>{let t=e.$.iframe;t||(t=e.$.iframe=document.createElement("iframe")),t.onload=()=>{e._handleIframeBody(),e._handleIframeAttributes(),e._handleIframeResources()},t.parentElement||e.$.container.appendChild(t),!t.contentWindow.marked&&window.marked&&(t.contentWindow.marked=window.marked)})()}_removeIframeEventListeners(){const e=this,t=e.$.iframe.contentDocument,o=e.$iframe;o&&(o.unlisten("down"),o.unlisten("move"),o.unlisten("up")),t.removeEventListener("dragstart",e._iframeDragStartHandler),t.removeEventListener("dragend",e._iframeDragEndHandler),t.removeEventListener("selectionchange",e._iframeSelectionChangeHandler)}_handleIframeBody(){const e=this,t=e.$.iframe.contentDocument,o=t.body;if(!o)return;let a=e.$iframe;o.classList.add("smart-editor","smart-element","smart-editor-iframe-body"),o.appendChild(e.$.contentContainer),e._updateIframeBody(),a||(a=e.$iframe=Smart.Utilities.Extend(o)),e._iframeDownHandler=t=>e._documentDownHandler.call(e,t),e._iframeMoveHandler=t=>e._documentMoveHandler.call(e,t),e._iframeUpHandler=t=>e._documentUpHandler.call(e,t),e._iframeDragStartHandler=t=>e._dragStartHandler.call(e,t),e._iframeDragEndHandler=t=>e._dragEndHandler.call(e,t),e._iframeSelectionChangeHandler=t=>e._selectionChangeHandler.call(e,t),e._removeIframeEventListeners(),a.listen("down",e._iframeDownHandler),a.listen("move",e._iframeMoveHandler),a.listen("up",e._iframeUpHandler),t.addEventListener("dragstart",e._iframeDragStartHandler),t.addEventListener("dragend",e._iframeDragEndHandler),t.addEventListener("selectionchange",e._iframeSelectionChangeHandler)}_updateIframeBody(){const e=this,t=e.$.iframe;if(!t)return;const o=t.contentDocument.body;o&&(e.rightToLeft?o.setAttribute("right-to-left",""):o.removeAttribute("right-to-left"),e.theme?o.setAttribute("theme",e.theme):o.removeAttribute("theme"),o.setAttribute("animation",e.animation))}_handleIframeAttributes(){const e=this,t=e.$.iframe,o=e.iframeSettings.attributes;if(!t)return;if(t.hasAttribute("title")||t.setAttribute("title",e.localize("iframeTitle")),!o||"object"!=typeof o)return;const a=e.$.editableElement;for(let e in o){const n=o[e];"readonly"===e?a.setAttribute("contenteditable",!n):t[e]=n}}_handleIframeResources(){const e=this.iframeSettings.resources,t=this.$.iframe;if(!t||"object"!=typeof e)return;const o=document.styleSheets,a=t.contentDocument,n=a.head,i=a.body;for(let e in o){const a=o[e],n=a.ownerNode;"text/css"===a.type&&n&&["link","style"].indexOf(n.nodeName.toLocaleLowerCase())>-1&&t.contentDocument.head.appendChild(a.ownerNode.cloneNode())}for(let t in e){const o=t,a=e[t];let r;if((o+"").indexOf("style")>-1||"link"===o?(r=document.createElement("link"),r.rel="stylesheet",r.type="text/css","string"==typeof a&&(r.href=a)):"script"===o&&(r=document.createElement("script"),r.type="text/javascript","string"==typeof a&&(r.src=a)),"object"==typeof a&&"[object Object]"===a.toString())for(let e in a)r[e]=a[e];"module"===r.type?i.appendChild(r):n.appendChild(r)}}_handleMaxCharCount(){const e=this,t=e.$.input;null!==e.maxCharCount?t.maxLength=e.maxCharCount:t.removeAttribute("maxlength")}_getToolbarItems(e,t){const o=this;e||(e=o.$.toolbar),t||(t=o.toolbarItems);const a=e===o.$.toolbar?"toolbar":"inlineToolbar",n=e.querySelectorAll(".smart-editor-toolbar-item"),i=document.createDocumentFragment();for(let e=0,r=t.length;e<r;e+=1){const r=o._getToolbarItemDetails(a,t[e]),l=r.name,s=r.type;let d=n[e];if(d?"custom"===d.getAttribute("item-type")&&(d.innerHTML=""):(d=document.createElement("div"),d.classList.add("smart-editor-toolbar-item")),"color-input"===s)d.innerHTML||(d.innerHTML=`<div class="smart-editor-item-action-button" item-name="${l}"></div>\n                                               <div class="smart-editor-item-drop-down-button"></div>`);else if("custom"===s){const e=r.template;d.innerHTML="",e&&e.closest&&!d.contains(e)?d.appendChild(e):"string"!=typeof e||d.innerHTML?"function"==typeof e&&e(d,r):d.innerHTML=e||""}else"toggle"===s&&(r.value?(d.setAttribute("checked",""),d.setAttribute("aria-pressed",!0)):(d.removeAttribute("checked"),d.setAttribute("aria-pressed",!1)),d.innerHTML&&(d.innerHTML=""));r.disabled||"paste"===l&&o._isFireFox?(d.setAttribute("disabled",""),d.setAttribute("aria-disabled",!0)):(d.removeAttribute("disabled"),d.removeAttribute("aria-disabled")),d.setAttribute("role","delimiter"===s?"separator":"button"),"color-input"===s||"drop-down"===s?d.setAttribute("aria-haspopup",!0):d.removeAttribute("aria-haspopup"),o._setItemValue(d,r),r.title?d.setAttribute("title",r.title):d.removeAttribute("title"),d.setAttribute("item-name",l),d.setAttribute("item-type",s),d.style.width=r.width||"",i.appendChild(d)}return i}_setItemValue(e,t){const o=this;let a=t.value;e&&t&&("button"===t.type?a?(e.setAttribute("checked",""),e.setAttribute("aria-pressed",!0)):(e.removeAttribute("checked"),e.setAttribute("aria-pressed",!1)):(a||"color-input"!==t.type?["fontname","formats"].indexOf(t.name)>-1&&(a=o.localize(t.value)||t.label||t.value):a="transparent",a?(e.setAttribute("item-value",a),e.style.setProperty("--item-value",a)):(e.removeAttribute("item-value"),e.style.removeProperty("--item-value"))))}_refreshToolbarItems(e){const t=this,o=t.$.toolbar,a=t.$.toolbarToggleButton,n=t.$.toolbarItemsPrimary,i=t.$.toolbarItemsSecondary;if("menu"===t.toolbarMode){if(n.scrollTop=n.scrollLeft=0,e)n.appendChild(e);else{const e=Array.from(i.children),t=document.createDocumentFragment(),o=e.length;for(let a=0;a<o;a+=1)t.appendChild(e[a]);o>0&&n.appendChild(t)}if("toggle"===t.toolbarViewMode){const e=n.offsetHeight;if(o.hasAttribute("expanded")){let t=[];e:for(;n.scrollHeight>e;){const e=n.lastElementChild;if(!e)break e;t.push(e),e.remove()}t.reverse();for(let e=0,o=t.length;e<o;e+=1)i.appendChild(t[e])}else n.scrollHeight===e&&a.classList.add("smart-visibility-hidden")}}else a.classList.remove("smart-visibility-hidden")}_resizeHandler(e){const t=this,o=t.$.inlineToolbar;if(e.target===t){if("toggle"===t.toolbarViewMode){const e=t.$.toolbarItemsPrimary,o=t.$.toolbarItemsSecondary;t.$.toolbar.hasAttribute("expanded")&&t._refreshToolbarItems();const a=t.$.toolbarToggleButton;e.scrollHeight!==e.offsetHeight||o.children.length?a.classList.remove("smart-visibility-hidden"):a.classList.add("smart-visibility-hidden")}if("menu"===t.toolbarMode||t.$.toolbarItemsSecondary.classList.contains("smart-visibility-hidden")||t._setToolbarGroupHeight(),o&&o.visible){const e=o.selector;e.classList.contains("smart-editor-toolbar-item")&&e.offsetTop>=t.$.toolbar.offsetHeight?o.close():o.reposition()}t._positionWindow(),t._resizeFrameObj&&t._setResizeFrame(t._resizeFrameObj.target)}}_setToolbarItemAttr(e,t,o){const a=this,n=a.$.toolbar,i=a.$.inlineToolbar,r=[a._toolbarItemsObj,a._inlineToolbarItemsObj];for(let a=0,l=r.length;a<l;a+=1){const l=r[a],s=l?l[e]:void 0;if(s){const a=l==l?n:i;if(s[t]=o,!a||!a.parentElement)continue;const r=a.querySelector(`.smart-editor-toolbar-item[item-name="${e}"]`);if(!r)continue;null==o||!1===o?(r.removeAttribute(t),"disabled"===t&&r.removeAttribute("aria-disabled")):(r.setAttribute(t,o),"disabled"===t&&r.setAttribute("aria-disabled",!0))}}}_setToolbarVisibility(){const e=this,t=e.$.toolbar,o=e.$.toolbarToggleButton;"toggle"!==e.toolbarViewMode||o.hasAttribute("checked")?t.setAttribute("expanded",""):t.removeAttribute("expanded")}_getToolbarItemDetails(e,t){const o=this;let a,n=o[`_${e}ItemsObj`];if(a="string"==typeof t?t:"object"==typeof t&&t.name?t.name+"":"",a=a.trim().toLowerCase(),n){if(void 0!==n[a])return n[a]}else n=o[`_${e}ItemsObj`]={};const i=n[a]={};return i.title=t.title||o.localize(a),i.name=a,i.toolbarName=e,i.advanced=!!t.advanced,i.inlineToolbarItems=t.inlineToolbarItems,o._setItemType(t,i,a),o._setItemData(t,i,a),o._setItemTemplate(t,i,a),o._setItemSpecifics(t,i,a),i}_setItemType(e,t,o){let a;if(t){switch(o){case"sourcecode":case"splitmode":case"fullscreen":a="toggle";break;case"alignment":case"fontname":case"fontsize":case"formats":case"tablerows":case"tablecolumns":case"tablevalign":case"tablestyle":a="drop-down";break;case"backgroundcolor":case"fontcolor":a="color-input";break;case"bold":case"italic":case"underline":case"strikethrough":case"delete":case"redo":case"undo":case"indent":case"outdent":case"openlink":case"editlink":case"createlink":case"removelink":case"hyperlink":case"cut":case"copy":case"image":case"video":case"lowercase":case"uppercase":case"print":case"caption":case"clearformat":case"table":case"tableheader":case"orderedlist":case"unorderedlist":case"subscript":case"superscript":case"findandreplace":a="button";break;case"paste":a=t.advanced?"drop-down":"button";break;default:a="string"==typeof e?"delimiter":"custom"}t.type=a}}_setItemData(e,t,o){const a=this;let n,i;if(!t||!e)return;const r=t.type;let l=e.width;if("drop-down"===r||"color-input"===r){if("object"==typeof e&&(n=e.dataSource,void 0!==e.value&&(i=e.value+"")),n&&Array.isArray(n)||(n=a._getDefaultDataSource(o,t)),void 0===i&&("fontsize"===t.name&&(i=parseInt(window.getComputedStyle(a.$.editableElement).fontSize)),isNaN(i)&&n.length)){const e=n[0];i=e["alignment"===o?"value":"label"]||e}o.indexOf("table")>-1&&(i="")}void 0!==l&&("number"==typeof l?l+="px":(l+="",l.includes("%")||(l=parseFloat(e.width),l=isNaN(l)?"":l+"px"))),t.dataSource=n,t.value=i,t.disabled=!!e.disabled,t.width=l}_setItemSpecifics(e,t,o){if(!t||"object"!=typeof e)return;let a=e.editor,n=t.editor;if(n||(n=t.editor={}),!a)return;let i=[],r=[];switch(o){case"createlink":case"removelink":case"hyperlink":i=["address","text","target"];break;case"image":i=["allowedTypes","uploadUrl","removeUrl","path","display"],r=["draggable","resizable"];break;case"table":i=["cols","rows","tableheader"],r=["altrows","dashedborders","resizable"]}for(let e in a){let t=a[e];void 0!==t&&(i.indexOf(e)>-1?"display"===e?t="block"===t?"block":"inline":t+="":r.indexOf(e)>-1?t=!!t:"width"!==e&&"height"!==e||"string"==typeof t||(t+="px"),n[e]=t)}}_getDefaultDataSource(e,t){const o=this;let a=[];switch(e){case"alignment":a=[{label:o.localize("alignLeft"),value:"left",icon:"editor-icon"},{label:o.localize("alignCenter"),value:"center",icon:"editor-icon"},{label:o.localize("alignRight"),value:"right",icon:"editor-icon"}],t&&"toolbar"===t.toolbarName&&a.push({label:o.localize("alignJustify"),value:"justify",icon:"editor-icon"});break;case"display":a=[{label:o.localize("displayInline"),value:"inline"},{label:o.localize("displayBlock"),value:"block"}];break;case"fontname":["segoeUi","arial","georgia","impact","tahoma","timesNewRoman","verdana"].forEach((e=>{a.push({label:o.localize(e),value:e})}));break;case"fontsize":["8","10","12","14","18","24","36"].forEach((e=>{a.push({label:e,value:e})}));break;case"formats":["p","pre","blockquote","h1","h2","h3","h4"].forEach((e=>{a.push({label:o.localize(e),value:e})}));break;case"backgroundcolor":case"fontcolor":["#000000","#FFFFFF","#D50000","#E67C73","#F4511E","#F6BF26","#33B679","#0B8043","#039BE5","#3F51B5","#7986CB","#8E24AA","#616161",""].forEach((e=>{a.push({label:e,value:e})}));break;case"paste":a=[{label:o.localize("plainText"),value:"plainText"},{label:o.localize("keepFormat"),value:"keepFormat"},{label:o.localize("cleanFormat"),value:"cleanFormat"}];break;case"target":a=[{label:o.localize("linkBlankDescr"),value:"_blank"},{label:o.localize("linkSelfDescr"),value:"_self"},{label:o.localize("linkParentDescr"),value:"_parent"},{label:o.localize("linkTopDescr"),value:"_top"},{label:o.localize("linkCustomDescr"),value:""}];break;case"tablerows":a=[{label:o.localize("insertRowBefore"),value:"insertRowBefore",icon:"editor-icon"},{label:o.localize("insertRowAfter"),value:"insertRowAfter",icon:"editor-icon"},{label:o.localize("deleteRow"),value:"deleteRow",icon:"editor-icon"}];break;case"tablecolumns":a=[{label:o.localize("insertColumnLeft"),value:"insertColumnLeft",icon:"editor-icon"},{label:o.localize("insertColumnRight"),value:"insertColumnRight",icon:"editor-icon"},{label:o.localize("deleteColumn"),value:"deleteColumn",icon:"editor-icon"}];break;case"tablevalign":a=[{label:o.localize("alignTop"),value:"top"},{label:o.localize("alignMiddle"),value:"middle"},{label:o.localize("alignBottom"),value:"bottom"}];break;case"tablestyle":a=[{label:o.localize("dashedborders"),value:"dashedborders"},{label:o.localize("altrows"),value:"altrows"}]}return a}_setItemTemplate(e,t){let o=e.template;t&&(o?(o&&o.closest?o="content"in o?document.importNode(o.content,!0):o:"function"==typeof o?o=o.bind(this):"string"==typeof o&&(o=document.getElementById(o)||o),t.template=o):delete t.template)}_setAriaSettings(){const e=this,t=e.$.input,o=e.$.editableElement;e.setAttribute("role","application"),e.setAttribute("aria-roledescription",e.localize("roleDescription")),e.$.toolbarToggleButton.setAttribute("aria-label",e.localize("toolbarButtonAriaLabel")),e.$.toolbarItemsPrimary.setAttribute("aria-label",e.localize("primaryToolbarAriaLabel")),e.$.toolbarItemsSecondary.setAttribute("aria-label",e.localize("secondaryToolbarAriaLabel")),t.setAttribute("aria-label",e.localize("inputAreaLabel")),t.id=e.id+"TextArea",o.id=e.id+"EditableElement",o.setAttribute("aria-label",e.localize("inputAriaLabel"))}_setAriaControls(e,t){const o=this;e&&e.nodeName&&(t.id||(t.id=o.id+"Popup"+Math.floor(65536*(1+Math.random())).toString(16).substring(1)),e.setAttribute("aria-controls",t.id))}_setAriaOwns(e){const t=this;if(!e)return;const o=e.id;let a=(t.getAttribute("aria-owns")||"").split(" ").filter((e=>e.length));const n=a.indexOf(o);if(n>-1){if(e.parentElement&&(e.opened||e.visible))return;a.splice(n,1)}else a.push(o);a.length?t.setAttribute("aria-owns",a.join(" ")):t.removeAttribute("aria-owns")}_setFocusable(){const e=this,t=e.$.editableElement;if(e.disabled||e.unfocusable)return void(t&&t.removeAttribute("tabindex"));const o=e.tabIndex>0?e.tabIndex:0;t&&(t.tabIndex=o)}_selectAll(){const e=this,t=e.$.input,o=e.$.editableElement;t.classList.contains("smart-hidden")||t.select(),o.classList.contains("smart-hidden")||e._setSelectionRange(o)}_selectStartHandler(e){const t=this._resizeFrameObj,o=this._inlineToolbarClickObj;(t&&t.resizeDetails||o&&o.resizeDetails)&&e.preventDefault()}_selectionChangeHandler(e){const t=this;if(t.disabled||!e.target.getSelection)return;const o=e.target.getSelection().focusNode;if(t.$.contentContainer.contains(o)){if(t._ignoreSelectionChange||o.classList&&o.classList.contains("smart-search-input"))return;t._selectionChangeFired=!0,t._setSelectionRange(),t._updateToolbarItems(),delete t._selectionChangeFired}}_selectToolbarTab(e){const t=this,o=t.$.toolbar,a=t.$.toolbarItemsPrimary,n=e&&!e.hasAttribute("checked"),i=a.querySelectorAll(".smart-editor-toolbar-tab");for(let t=0,o=i.length;t<o;t+=1){const o=i[t];e===o&&n?o.setAttribute("checked",""):o.removeAttribute("checked")}let r=t._tabSelectionBar;r||(t._tabSelectionBar=r=document.createElement("div"),r.classList.add("smart-editor-toolbar-tab-selection-bar")),r.classList.add("smart-visibility-hidden"),e&&e.hasAttribute("checked")?(o.setAttribute("toolbar-tab-selected",""),r.style.left=e.offsetLeft+"px",r.style.width=e.offsetWidth+"px",a.contains(r)||a.appendChild(r),t._setToolbarItemGroups(),requestAnimationFrame((()=>r.classList.remove("smart-visibility-hidden")))):o.removeAttribute("toolbar-tab-selected")}}),Smart("smart-table-picker",class extends Smart.BaseElement{static get properties(){return{columns:{value:10,type:"number"},messages:{extend:!0,value:{en:{buttonLabel:"Insert Table"}}},rows:{value:3,type:"number"},value:{value:[],type:"array"}}}static get listeners(){return{"tableGrid.mouseover":"_cellOver","tableGrid.mouseleave":"_cellLeave","tableGrid.click":"_cellOver"}}template(){return'<div id="container" role="presentation">\n                    <div id="tableGrid" class="smart-table-picker-grid" role="presentation"></div>\n                    <div class="smart-table-picker-separator" role="separator"></div>\n                    <smart-button id="tableButton" class="smart-table-picker-button" right-to-left="[[rightToLeft]]"></smart-button>\n                </div>'}propertyChangedHandler(e,t,o){const a=this;switch(e){case"value":a._selectCell(o,t,!0);break;case"rows":case"columns":a._createTableGrid();break;case"messages":a._setTableButton();break;default:super.propertyChangedHandler(e,t,o)}}render(){const e=this;e._isMobile=Smart.Utilities.Core.isMobile,e._createTableGrid(),e._setTableButton(),e._setAria(),super.render()}_setAria(){this.setAttribute("role","grid")}_createTableGrid(){const e=this,t=e.$.tableGrid,o=e.columns,a=e.rows,n=t.children,i=document.createDocumentFragment();let r=n.length;for(;r>a;){const e=n[0];if(!e)break;e.remove(),r--}for(let e=r,t=a;e<t;e+=1){const e=document.createElement("div");e.setAttribute("role","row"),i.appendChild(e)}i.children.length&&t.appendChild(i);for(let e=0,t=a;e<t;e+=1){const t=n[e],a=t.children;let i=a.length;for(;i>o&&a[0];)a[0].remove(),i--;for(let e=i,a=o;e<a;e+=1){const e=document.createElement("span");e.setAttribute("role","gridcell"),e.classList.add("smart-table-picker-cell"),t.appendChild(e)}}e._selectCell(e.value)}_cellOver(e){const t=this,o=e.target;let a=[];if(!t.$.tableGrid.contains(o))return void t._selectCell(t.value);const n=o.closest(".smart-table-picker-cell");if(n){const o=n.parentElement,i=Array.from(o.children);a[0]=Math.max(0,Array.from(t.$.tableGrid.children).indexOf(o)+1),a[1]=Math.max(0,i.indexOf(n)+1),t._selectCell(a,t.value,"click"===e.type)}}_cellLeave(){this._selectCell(this.value)}_selectCell(e,t,o){const a=this,n=a.$.tableGrid,i=Array.from(n.children),r=i.length;let l=0,s=0;e&&(l=e[0]||0,s=e[1]||0);for(let e=0,t=r;e<t;e+=1){const t=i[e].children;if(l<e+1)for(let e=0,o=t.length;e<o;e+=1)t[e].removeAttribute("selected");else for(let e=0,o=t.length;e<o;e+=1)s>=e+1?t[e].setAttribute("selected",""):t[e].removeAttribute("selected")}n.setAttribute("value",l+"x"+s),o&&(void 0===t&&(t=a.value),a.set("value",[l,s]),t[0]===l&&t[1]===s||a.$.fireEvent("change",{value:e,oldValue:t}))}_setTableButton(){this.$.tableButton.innerHTML=this.localize("buttonLabel")}});