
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-gantt-chart",class extends Smart.ScrollViewer{static get properties(){return{adjustToNonworkingTime:{value:!1,type:"boolean"},autoSchedule:{value:!1,type:"boolean"},autoScheduleStrictMode:{value:!1,type:"boolean"},autoScrollStep:{value:5,type:"number"},columnMenu:{value:!1,type:"boolean"},columnMinWidth:{value:"50px",type:"any"},columnResize:{value:!1,type:"boolean"},columnResizeFeedback:{value:!1,type:"boolean"},currentTimeIndicator:{value:!1,type:"boolean"},currentTimeIndicatorInterval:{value:1,validator:"_currentTimeIndicatorIntervalValidator",type:"number"},dataExport:{value:{exportFiltered:{value:!1,type:"boolean"},itemType:{value:"task",type:"string"},fileName:{value:"smartGanttChart",type:"string?"}},type:"object"},dataSource:{value:[],type:"any",reflectToAttribute:!1},dateEnd:{value:"",type:"any",validator:"_dateValidator"},dateStart:{value:"",type:"any",validator:"_dateValidator"},dateMarkers:{value:[],reflectToAttribute:!1,type:"array"},dayFormat:{value:"short",allowedValues:["2-digit","numeric","long","short","narrow"],type:"string"},disableAutoScroll:{value:!1,type:"boolean"},disableTaskDrag:{value:!1,type:"boolean"},disableTaskProgressChange:{value:!1,type:"boolean"},disableTaskResize:{value:!1,type:"boolean"},disableSelection:{value:!1,type:"boolean"},disableSegmentDrag:{value:!1,type:"boolean"},disableSegmentResize:{value:!1,type:"boolean"},disableWindowEditor:{value:!1,type:"boolean"},durationUnit:{value:"milisecond",allowedValues:["day","week","hour","minute","second","milisecond"],type:"string"},filterRow:{value:!1,type:"boolean"},firstDayOfWeek:{value:-1,type:"number"},groupByResources:{value:!1,type:"boolean"},headerTemplate:{value:null,type:"any"},hourFormat:{value:"default",allowedValues:["default","2-digit","numeric"],type:"string"},hideDateMarkers:{value:!1,type:"boolean"},hideTimelineHeaderDetails:{value:!1,type:"boolean"},hideTimelineSecondHeaderDetails:{value:!0,type:"boolean"},hideTimelineHeader:{value:!1,type:"boolean"},hideResourcePanel:{value:!1,type:"boolean"},showSelectionColumn:{value:!1,type:"boolean"},infiniteTimeline:{value:!1,type:"boolean"},infiniteTimelineStep:{value:5,type:"number"},inverted:{value:!1,type:"boolean"},keyboardNavigation:{value:!1,type:"boolean"},messages:{extend:!0,value:{en:{duplicateIds:"{{elementType}}: DataSource contains duplicate ids. Tasks should have unique ids. The following ids are duplicating: {{duplicates}}.",invalidNonworkingRange:"{{elementType}}: Invalid {{property}} value. {{property}} should not contain all possible days/hours because it will result in an endless timeline. The value has been validated by removing the last item from the new value range.",invalidValue:"{{elementType}}: Invalid {{property}} value. {{property}} should be of type {{typeOne}} or {{typeTwo}}.",incorrectArgument:"{{elementType}}: Incorrect argument {{argumentName}} in method {{methodName}}.",outOfBounds:"{{elementType}}: Out of bounds argument {{argumentName}} in method {{methodName}}.",missingReference:"{{elementType}}: Missing reference to {{file}} in method {{methodName}}.",alreadyExists:"{{elementType}}: The item already exists when calling the {{methodName}} method.",notExisting:"{{elementType}}: The item does not exists when calling the {{methodName}} method.",notAProject:"{{elementType}}: The {{argumentName}} argument in {{methodName}} method does not reference an item of type 'project'.",noId:"smartGanttChart requires an id in order to save/load/clear a state.",ok:"Ok",add:"Add",remove:"Remove",cancel:"Cancel",delete:"Delete",confirm:"{{componentName}} will be deleted permanently, <b>are you sure? </b>",taskColumnLabel:"Task Name",resourceColumnLabel:"Resource Name",deleteLink:"Delete link",unassigned:"Unassigned",generalTab:"General",dependencyTab:"Dependency",segmentsTab:"Segments",segment:"Segment",dependencyValidation:"*The Task cannot be connected to itself.",segmentsCountValidation:"*Segmented Tasks must have at least 2 segments. ",segmentConflictError:'*The Segment "{{label}}" is in conflict, because it starts on/before and ends on/after the {{dateConflict}} of Segment "{{conflictLabel}}." ',segmentStartError:'*The Segment "{{label}}" cannot start before it ends and cannot end before it starts.',segmentEndError:'*The Segment "{{label}}" cannot start when it ends.',segmentRangeError:'*The Segment "{{label}}" is out of Task date range. The first segment must start when the task starts and the last segment must end when the task ends.',label:"Label",duration:"Duration",dateStart:"Date Start",dateEnd:"Date End",id:"Id",name:"Name",type:"Type",lag:"Lag",startToStart:"Start-To-Start",endToStart:"End-To-Start",endToEnd:"End-To-End",startToEnd:"Start-To-End",overdue:"Overdue",weeks:"week(s)",days:"day(s)",hours:"hour(s)",minutes:"minute(s)",seconds:"second(s)",miliseconds:"milisecond(s)",task:"Task",resource:"Resource",assignments:"Assignments",startTask:"Task Start",endTask:"Task End",deadline:"Deadline"}},type:"object"},monthFormat:{value:"short",allowedValues:["2-digit","numeric","long","short","narrow"],type:"string"},monthScale:{value:"week",allowedValues:["day","week"],type:"string"},max:{value:new Date(2100,0,1),type:"any",validator:"_dateValidator"},min:{value:new Date(1900,0,1),type:"any",validator:"_dateValidator"},nonworkingDays:{value:[],type:"array",validator:"_nonworkingDayValidator"},nonworkingHours:{value:[],type:"array",validator:"_nonworkingTimeValidator"},popupWindowCustomizationFunction:{value:null,reflectToAttribute:!1,type:"function?"},popupWindowTabs:{value:["general","dependency","segments"],reflectToAttribute:!1,type:"array"},progressLabelFormatFunction:{value:null,reflectToAttribute:!1,type:"function?"},resizeHandlesVisibility:{allowedValues:["auto","hidden","visible"],value:"auto",type:"string"},resourceColumns:{value:[{label:"resourceColumnLabel",value:"label"}],type:"array",reflectToAttribute:!1},resourceFiltering:{value:!1,type:"boolean"},resourceGroupFormatFunction:{value:null,reflectToAttribute:!1,type:"function?"},resourcePanelHeaderTemplate:{value:null,type:"any"},resourcePanelMin:{value:100,type:"any"},resourcePanelSize:{value:"",type:"any"},resourcePanelRefreshRate:{value:0,reflectToAttribute:!1,type:"number"},resourceTimelineFormatFunction:{value:null,reflectToAttribute:!1,type:"function?"},resourceTimelineMode:{allowedValues:["diagram","histogram","custom"],value:"diagram",type:"string"},resourceTimelineView:{allowedValues:["hours","tasks","custom"],value:"hours",type:"string"},selectedTaskIds:{value:[],type:"array"},selectedResourceIds:{value:[],type:"array"},shadeUntilCurrentTime:{value:!1,type:"boolean"},showBaseline:{value:!1,type:"boolean"},showProgressLabel:{value:!1,type:"boolean"},snapToNearest:{value:!1,type:"boolean"},sortFunction:{value:null,type:"function?",reflectToAttribute:!1},sortMode:{value:"none",allowedValues:["none","one","many"],type:"string"},taskColumns:{value:[{label:"taskColumnLabel",value:"label"}],type:"array",reflectToAttribute:!1},taskFiltering:{value:!1,type:"boolean"},taskPanelMin:{value:200,type:"any"},taskPanelSize:{value:"",type:"any"},timelineHeaderFormatFunction:{value:null,reflectToAttribute:!1,type:"function?"},timelineMin:{value:200,type:"any"},treeMin:{value:100,type:"any"},treeSize:{value:"20%",type:"any"},tooltip:{value:{enabled:{value:!1,type:"boolean"},arrow:{value:!1,type:"boolean"},delay:{value:50,type:"number"},offset:{value:[0,5],type:"array"}},type:"object"},verticalScrollBarVisibility:{type:"string",value:"auto",allowedValues:["auto","disabled","hidden","visible"]},view:{value:"year",allowedValues:["day","week","month","quarter","year"],type:"any"},yearFormat:{value:"numeric",allowedValues:["2-digit","numeric"],type:"string"},weekFormat:{value:"long",allowedValues:["long","numeric"],type:"string"}}}template(){return'<div id="container" role="presentation">\n                    <smart-splitter id="mainSplitter" auto-fit-mode="end" keep-proportions-on-resize right-to-left="[[rightToLeft]]" animation="[[animation]]" orientation="horizontal">\n                        <smart-splitter-item id="taskSplitterItem" class="smart-task-splitter-item">\n                            <div id="taskSplitterItemHeader" class="smart-task-panel-header"></div>\n                            <smart-splitter id="taskSplitter" class="smart-task-splitter" auto-fit-mode="end">\n                                 <smart-splitter-item id="tableSplitterItem">\n                                    <smart-table right-to-left="[[rightToLeft]]" wait id="taskTable" class="smart-task-table" virtualization animation="none" deferred-scroll-delay="0" ></smart-table>\n                                </smart-splitter-item>\n                                <smart-splitter-item id="timelineSplitterItem" class="smart-timeline-splitter-item">\n                                        <div id="timeline" class="smart-timeline">\n                                            <div id="timelineHeader" class="smart-timeline-header" role="rowgroup">\n                                                <div id="timelineHeaderContent" class="smart-timeline-header-content">\n                                                    <div class="smart-timeline-view-details" id="timelineViewDetails" role="row"></div>\n                                                    <div class="smart-timeline-view-details smart-hidden" id="timelineViewSubDetails" role="row"></div>\n                                                    <div class="smart-timeline-view-cells" id="timelineViewCells" role="row"></div>\n                                                </div>\n                                            </div>\n                                            <div id="taskTimelineContainer" class="smart-timeline-content-container">\n                                                <div id="timelineContent" class="smart-timeline-content">\n                                                    <div id="taskTimelineCellsContainer" class="smart-timeline-cells-container" aria-hidden="true"></div>\n                                                    <div id="taskIndicatorsContainer" class="smart-timeline-indicators-container" role="group"></div>\n                                                    <div id="timelineConnectionsContainer" class="smart-timeline-connections-container" role="group"></div>\n                                                    <div id="timelineBaselinesContainer" class="smart-timeline-baselines-container" role="group"></div>\n                                                    <div id="timelineTasksContainer" class="smart-timeline-tasks-container" role="group"></div>\n                                                    <div id="timelineMarkers" class="smart-timeline-markers-container" role="group"></div>\n                                                    <div id="timelineDeadlines" class="smart-timeline-deadlines-container" role="group"></div>\n                                                </div>\n                                            </div>\n                                        </div>\n                                        <smart-scroll-bar id="verticalScrollBar" class="smart-timeline-scroll-bar" orientation="vertical"\n                                                right-to-left="[[rightToLeft]]" aria-controls="[[id]]">\n                                        </smart-scroll-bar>\n                                </smart-splitter-item>\n                            </smart-splitter>\n                        </smart-splitter-item>\n                    </smart-splitter>\n                    <smart-scroll-bar wait id="horizontalScrollBar" class="smart-timeline-scroll-bar"></smart-scroll-bar>\n                </div>'}static get listeners(){return{down:"_downHandler","document.move":"_documentMoveHandler","document.up":"_documentUpHandler","document.dragstart":"_dragStartHandler","container.wheel":"_mouseWheelHandler","horizontalScrollBar.change":"_horizontalScrollbarHandler","verticalScrollBar.change":"_verticalScrollbarHandler","resourceVerticalScrollBar.change":"_verticalScrollbarHandler","mainSplitter.resizeEnd":"_resizeEventHandler","mainSplitter.resize":"_resizeEventHandler",move:"_moveHandler","mainSplitter.change":"_tableChangeHandler","mainSplitter.filter":"_tableSortFilterHandler","mainSplitter.sort":"_tableSortFilterHandler","mainSplitter.columnResize":"_tableColumnResizeHandler","taskTable.group":"_taskTableGroupEventHandler","taskTable.collapse":"_taskTableExpandHandler","taskTable.expand":"_taskTableExpandHandler","taskTable.keydown":"_taskTableKeyDownHandler"}}static get styleUrls(){return["smart.ganttchart.css"]}attached(){const e=this;if(super.attached(),e._scrollView||(e._scrollView=new Smart.Utilities.Scroll(e.$.taskSplitterItem,e.$.horizontalScrollBar,e.$.verticalScrollBar)),!e._resourceScrollView&&e.$.mainSplitter.contains(e.$.resourceSplitter)&&(e._resourceScrollView=new Smart.Utilities.Scroll(e.$.resourceSplitterItem,e.$.horizontalScrollBar,e.$.resourceVerticalScrollBar)),e.scrollLeft){const t=e._getScrollLeft(e.scrollLeft);e.$.timelineHeader.scrollLeft=e.$.taskTimelineContainer.scrollLeft=t,e.$.mainSplitter.contains(e.$.resourceTimelineHeader)&&(e.$.resourceTimelineHeader.scrollLeft=e.$.resourceTimelineContent.scrollLeft=t)}if(e.scrollTop){const t=e.scrollTop;e.$.taskTimelineContainer.scrollTop=t,e.$.timelineContent.scrollTop=t,e.$.mainSplitter.contains(e.$.resourceTimelineHeader)&&(e.$.resourceTimelineContent.scrollTop=t)}const t=["taskPopupWindow","connectionPopupWindow","confirmPopupWindow"];for(let i=0;i<t.length;i++){const n=t[i];if(e.$[n]&&e.$[n].opened){const t=e["$"+n];e._handleModal(!0),t.listen("close",e._popupWindowCloseHandler.bind(e)),t.listen("closing",e._popupWindowClosingHandler.bind(e)),t.listen("open",e._popupWindowOpenHandler.bind(e)),t.listen("click",e._popupWindowClickHandler.bind(e)),t.listen("change",e._popupWindowChangeHandler.bind(e)),t.listen("transitionend",e._popupWindowTransitionendHandler.bind(e)),e.getShadowRootOrBody().appendChild(e.$[n])}}e._handleTooltipEvents(!0),e._currentTimeIndicatorInterval||!e.currentTimeIndicator&&!e.shadeUntilCurrentTime||e._setCurrentTimeIndicators()}detached(){const e=this;super.detached(),e._scrollView&&(e._scrollView.unlisten(),delete e._scrollView),e._resourceScrollView&&(e._resourceScrollView.unlisten(),delete e._resourceScrollView);const t=["taskPopupWindow","connectionPopupWindow","confirmPopupWindow"];e._handleModal();for(let i=0;i<t.length;i++){const n=t[i],a=e["$"+n];e.$[n]&&e.$[n].remove(),a&&(a.unlisten("open"),a.unlisten("close"),a.unlisten("closing"),a.unlisten("click"),a.unlisten("change"),a.unlisten("transitionend"))}e._handleTooltipEvents(),clearInterval(e._currentTimeIndicatorInterval),delete e._currentTimeIndicatorInterval}propertyChangedHandler(e,t,i){const n=this;switch(e){case"adjustToNonworkingTime":for(let e=0;e<n._tasks.length;e++){const t=n._tasks[e],i=t.$.project;n._validateTaskDates(t,i),n._validateTaskSegments(t),n._synchronizeProjectDates(t,i),n._refreshTableColumnsData(t,["dateEnd","duration"])}n._refreshTimeline();break;case"animation":break;case"autoSchedule":i?n._autoSchedule():n._autoScheduleRestore();break;case"autoScheduleStrictMode":i&&(n._autoSchedule(),n._refreshTimeline());break;case"columnMinWidth":case"columnResizeFeedback":case"columnResize":{const t=n.$.taskTable,a=n.$.resourceTable;t[e]=i,a&&(a[e]=i);break}case"currentTimeIndicator":case"shadeUntilCurrentTime":n._setCurrentTimeIndicators();break;case"dataSource":n.scrollLeft=n.scrollTop=0,n._createTasks(),n._refreshTableDataSource(),n._createTimeline(),n._createResourceTimeline(),n._setAriaControls();break;case"dateMarkers":n._createDateMarkers();break;case"hideDateMarkers":n._recycleDateMarkers();break;case"disableSelection":{const e=n.$.taskTable,t=n.$.resourceTable;e&&(e.selection=!n.disableSelection),t&&(t.selection=!n.disableSelection);break}case"durationUnit":for(let e=0;e<n._tasks.length;e++){const t=n._tasks[e],i=t.$.project;n._validateTaskDuration(t),n._validateTaskDates(t,i),n._validateTaskSegments(t),n._synchronizeProjectDates(t,i)}n._createTimelineCells(),n._insertTimelineTasks(),n.taskColumns.some((e=>(e.value+"").toLowerCase().indexOf("duration")>-1))&&n._refreshTableDataSource();break;case"filterRow":n.$.taskTable[e]=i;break;case"groupByResources":n._setTable(n.$.taskTable),n._createTimelineContent(),n._recycleTimelineTasks(),n._refresh();break;case"infiniteTimeline":i?n._scrollView.hScrollBar.value===n._scrollView.hScrollBar.max&&n._handleInfiniteTimeline():n.set("dateEnd","");break;case"keyboardNavigation":n.$.taskTable[e]=i,n.$.resourceTable&&(n.$.resourceTable[e]=i);break;case"popupWindowTabs":case"popupWindowCustomizationFunction":{const e=n.$.taskPopupWindow;e&&(e.opened&&(e.close(),delete e._target),e.clear());break}case"taskFiltering":n.$.taskTable.filtering=i,n._refresh();break;case"resourceFiltering":{const e=n.$.resourceTable;e&&(e.filtering=i,n._refresh());break}case"tooltip_enabled":{const e=n.$.tooltip;e&&(i||e.remove(),n._handleTooltipEvents(i));break}case"tooltip_arrow":case"tooltip_delay":case"tooltip_offset":{const t=n.$.tooltip;t&&(t[e.replace("tooltip_","")]=i);break}case"headerTemplate":n._handleHeaderTemplate();break;case"inverted":if(n._handleInverted(),n.scrollLeft){const e=n._getScrollLeft(n.scrollLeft);n.$.timelineHeader.scrollLeft=n.$.taskTimelineContainer.scrollLeft=e,n.$.mainSplitter.contains(n.$.resourceTimelineHeader)&&(n.$.resourceTimelineHeader.scrollLeft=n.$.resourceTimelineContent.scrollLeft=e)}break;case"rightToLeft":Array.from(n.querySelectorAll("smart-splitter, smart-table, smart-scroll-bar")).forEach((t=>t[e]=i)),n.closeWindow(),n._handleInverted(),n._refreshTimeline();break;case"firstDayOfWeek":case"dateStart":case"dateEnd":n._refreshTimeline();break;case"messages":case"locale":case"dayFormat":case"hourFormat":case"timelineHeaderFormatFunction":case"monthFormat":case"yearFormat":n._refreshHeaderDate(!0),n._refreshColumnsHeaders(),n._recycleResourceHeaderCells();break;case"hideResourcePanel":n._createResourceTimeline(),n._refreshTimeline();break;case"nonworkingDays":case"nonworkingHours":n._refreshAfterWorkingTimeChange();break;case"selectedTaskIds":n.$.taskTable.selected=n._getSelection("task",i);break;case"selectedResourceIds":n.$.resourceTable&&(n.$.resourceTable.selected=n._getSelection("resource",i));break;case"resourceColumns":n._setTable(n.$.resourceTable),n._highlightAssignedItem("task",n._getSelection("task",n.selectedTaskIds));break;case"resourcePanelHeaderTemplate":n._handleHeaderTemplate("resource");break;case"resourceTimelineView":case"resourceTimelineMode":case"resourceTimelineFormatFunction":n.$.mainSplitter.contains(n.$.resourceSplitter)&&n._resources.forEach((e=>n._refreshResourceTimelineContent(e)));break;case"showProgressLabel":case"progressLabelFormatFunction":n._tasks.forEach((e=>n._setTaskBarProgress(e)));break;case"sortFunction":n.$.taskTable.sort=i,n.$.resourceTable&&(n.$.resourceTable.sort=i);break;case"showSelectionColumn":n.$.taskTable.hideSelectionColumn=!i,n.$.resourceTable&&(n.$.resourceTable.hideSelectionColumn=!i);break;case"columnMenu":case"hideSelectionColumn":case"sortMode":n.$.taskTable[e]=i,n.$.resourceTable&&(n.$.resourceTable[e]=i);break;case"taskColumns":n._setTable(n.$.taskTable);break;case"timelineMin":n.$.timelineSplitterItem.min=i,n.$.taskSplitter.refresh(),n.$.mainSplitter.contains(n.$.resourceSplitter)&&n._synchronizeSplitters(n.$.taskSplitter,n.$.resourceSplitter);break;case"treeMin":case"treeSize":{const t=e.toLowerCase().indexOf("size")>-1?"size":"min";n.$.tableSplitterItem[t]=i,n.$.taskSplitter.refresh(),n.$.mainSplitter.contains(n.$.resourceSplitter)&&n._synchronizeSplitters(n.$.taskSplitter,n.$.resourceSplitter);break}case"taskPanelMin":case"taskPanelSize":case"resourcePanelSize":case"resourcePanelMin":{const t=e.indexOf("Min")>-1?"min":"size",a=e.indexOf("resource")>-1?"resource":"task";n.$.mainSplitter.contains(n.$.resourceSplitter)&&(n.$[`${a}SplitterItem`][t]=i,n.$.taskSplitterItem._setSize("size",n.taskPanelSize),n.refresh());break}case"unfocusable":n._setFocusable();break;case"view":n._refreshTimeline(t);break;default:super.propertyChangedHandler(e,t,i)}}_predefPropertyGetter(e){const t=this;Object.defineProperty(t,e,{get:function(){switch(e){case"dataSource":{if(t.context===t)return t.properties[e].value;const i=function(e){if(!e.length)return e;for(let n=0;n<e.length;n++){const a=e[n];let s=t._getProjectTasks(a);s&&Array.isArray(s)&&(s=i(s.filter((e=>e.$&&e.$.project===a)))),e[n]=t._cloneObject(a),s&&s.length?e[n].tasks=s:delete e[n].tasks}return e},n=t.properties[e].value;return n instanceof Smart.DataAdapter?n:i(n.slice(0))}case"dateStart":case"dateEnd":{const i=t._timelineCells;if(i.length){const n=t._getCellDateRange({_date:i["dateStart"===e?0:i.length-1].date});return new Date(n[e])}return t.properties[e].value}default:return t.properties[e].value}},set(i){t.updateProperty(t,t._properties[e],i)}})}ready(){this._customScrollView=!0,super.ready()}render(){const e=this,t=window.getComputedStyle(e),i=Smart.Utilities.Core;e._isMobile=i.isMobile,e._isFirefox=i.Firefox,e._taskBarMinWidth=parseFloat(t.getPropertyValue("--smart-gantt-chart-timeline-task-min-width"))||0,e._taskDefaultHeight=parseFloat(t.getPropertyValue("--smart-gantt-chart-task-default-height"))||30,e._timelineCellSize=parseFloat(t.getPropertyValue("--smart-gantt-chart-timeline-cell-size"))||0,e._timelineCellMinSize=parseFloat(t.getPropertyValue("--smart-gantt-chart-timeline-cell-min-size"))||0,e._taskConnectionWidth=parseFloat(t.getPropertyValue("--smart-gantt-chart-timeline-task-connection-width"))||1,e._baselineProportion=parseFloat(t.getPropertyValue("--smart-gantt-chart-baseline-proportion"))||0,e._predefPropertyGetter("dataSource"),e._predefPropertyGetter("dateStart"),e._predefPropertyGetter("dateEnd"),e.$.tableSplitterItem.size=e.treeSize,e.$.tableSplitterItem.min=e.treeMin,e.$.timelineSplitterItem.min=e.timelineMin,e._setScrollBars(),e._handleHeaderTemplate(),e._handleInverted(!0),e._createTasks(),e._setTable(),e._createTimeline(),e._createResourceTimeline(),e._setAriaControls(),e._setFocusable(),e.checkLicense(),(e.shadowRoot||e._isFirefox)&&requestAnimationFrame((()=>e.refresh())),super.render()}refresh(e){const t=this;if(e)return t._refreshTimeline(),t._setTable(t.$.taskTable),void t._createResourceTimeline();t.isRendered&&t._resizeEventHandler()}addFilter(e,t){const i=this;if(!i.taskFiltering&&!i.resourceFiltering||!(t instanceof Smart.Utilities.FilterGroup))return;Array.isArray(e)||(e="object"==typeof e?[e]:[]);const n=i.taskColumns,a=i.resourceColumns,s=i.$.taskTable,r=i.$.resourceTable;for(let i=0;i<e.length;i++){const o=e[i],l=o.type,[d,c]="resource"===l||a.includes(o)?[r,a]:[s,n],m=c.find((e=>o.value&&e.value===o.value));m&&d.addFilter(m.value,t)}}clearSelection(){this._unselectAll("task"),this._unselectAll("resource")}static get requires(){return{"Smart.Splitter":"smart.splitter.js","Smart.Tree":"smart.tree.js","Smart.Window":"smart.window.js"}}ensureVisible(e,t="task"){const i=this,n=i._getValidItemAndIndex(e,t);(e=n?n.item:void 0)&&(i._ensureVisible(e,t),i._scrollTo(e.dateStart,!0))}removeAllConnections(){const e=this;e.isCompleted&&(e.$.timelineConnectionsContainer.innerHTML="",e._connections=[],e._tasks.map((e=>e.connections=[])))}removeConnection(){const e=this,t=Array.from(arguments).filter((e=>void 0!==e));if(!e.isCompleted)return;let i;if(1===t.length){if("string"==typeof t[0]){const e=document.getElementById(t[0]);e&&(i=e.getAttribute("connection-id"))}i||(i=(t[0]+"").split("-"),i=e._getValidConnectionId(i[0],i[1],i[2],"removeConnection"))}else 3===t.length&&(i=e._getValidConnectionId(t[0],t[1],t[2],"removeConnection"));i&&(e._removeConnection(i),e.$.fireEvent("itemRemove",{type:"connection",id:`${i[0]}-${i[1]}-${i[2]}`,item:{source:i[0],target:i[1],type:i[2]}}))}removeTaskConnection(e,t){const i=this;if(!i.isCompleted)return;if((e+="").indexOf("-")>-1&&!t){const i=e.split("-");t=i[1],e=i[0]}const n=i._getValidItemAndIndex(e),a=i._getValidItemAndIndex(t);e=n?n.index:void 0,t=a?a.index:void 0,isNaN(e)?i.error(i.localize("incorrectArgument",{elementType:i.nodeName.toLowerCase(),methodName:"removeTaskConnection",argumentName:"taskEndIndex"})):i._removeConnection(""+e+(isNaN(t)?"":t))}beginUpdate(){this._isUpdating={started:!0,type:{}},this.$.fireEvent("beginUpdate")}endUpdate(){const e=this;function t(){e._refreshTableDataSource(),e._createTimelineContent(),e._recycleTimelineTasks(),e._setAriaControls();const t=e._resources;for(let i=0;i<t.length;i++)e._refreshTableColumnsData(t[i],void 0,"resource")}function i(){if(e.hideResourcePanel)return;e._refreshTableDataSource("resource"),e._recycleResourceHeaderCells(),e._createResourceTimelineContent(),e._refresh();const t=e._tasks;for(let i=0;i<t.length;i++)e._refreshTableColumnsData(t[i])}if(!e._isUpdating)return;const n=1===Object.keys(e._isUpdating.type).length?Object.keys(e._isUpdating.type)[0]:void 0;let a,s;switch(e._selected&&({task:a,resource:s}=e._selected),delete e._isUpdating,n){case"task":t();break;case"resource":i();break;default:t(),i()}a&&(e._refreshSelectedItems("task",a),e.$.taskTable.selected=e._getSelection("task",e.selectedTaskIds)),s&&(e._refreshSelectedItems("resource",s),e.$.resourceTable.selected=e._getSelection("resource",e.selectedResourceIds)),e.$.fireEvent("endUpdate")}clearFilters(e){this._resetFromAction(e,"clearFilters")}clearSort(e){const t=this;"task"!==e&&"resource"!==e?(t._resetFromAction("task","clearSort"),t._resetFromAction("resource","clearSort")):t._resetFromAction(e,"clearSort")}clearTasks(){this._clearTasks()}_clearTasks(){const e=this;e._selected&&delete e._selected.task,e.set("selectedTaskIds",[]),e._tasks=[],e._timelineCells=[],e._timelineVCells=[],e._timelineHeaderCells=[],e.$.timelineContent.style.width="",e.$.container.style.removeProperty("--smart-gantt-chart-task-timeline-content-height"),e.$.timelineViewDetails.innerHTML="",e.$.timelineViewCells.innerHTML="",e.$.taskTimelineCellsContainer.innerHTML="",e.$.timelineConnectionsContainer.innerHTML="",e.$.timelineTasksContainer.innerHTML="",e.$.taskIndicatorsContainer.innerHTML="",e.$.timelineContent.style.height="",delete e._hoveredItem,e.$.taskTable.dataSource=[],e._closeTooltip(),e.closeWindow(),e._refresh()}clearResources(){const e=this;e._unselectAll("resource"),e._resources=[],e.$.resourceTable&&(e.$.resourceTable.dataSource=[]),e.$.resourceTimelineCellsContainer.innerHTML="",e._tasks.forEach((t=>{t.resources=[],e._refreshTableColumnsData(t,["resources"])})),e._refreshTimeline(),e._createResourceTimeline()}createConnection(){const e=this,t=e._tasks;let i,n=Array.from(arguments).filter((e=>void 0!==e));if(!e.isCompleted||0===t.length)return;if(i=1===n.length?(n[0]+"").split("-"):n,!e._getValidConnectionId(i[0],i[1],i[2],"createConnection"))return;const a=parseInt(i[3]);e._connectTask([i[0],i[1],i[2],isNaN(a)?0:a]),e._recycleConnections(),e.$.fireEvent("itemInsert",{type:"connection",item:{source:i[0],target:i[1],type:i[2],lag:a}})}collapse(e){this._handleCollapseExpandMethods(e,"collapse")}expand(e){this._handleCollapseExpandMethods(e,"expand")}exportData(e,t){const i=this;if(!Smart.Utilities.DataExporter)return void i.error(i.localize("missingReference",{elementType:i.nodeName.toLowerCase(),methodName:"exportData",file:"smart.export.js"}));try{new JSZip}catch(e){return void i.error(i.localize("missingReference",{elementType:i.nodeName.toLowerCase(),methodName:"exportData",file:"jszip.min.js"}))}if("pdf"===e&!window.pdfMake)return void i.error(i.localize("missingReference",{elementType:i.nodeName.toLowerCase(),methodName:"exportData",file:"pdfMake.min.js"}));const n="task"===i.dataExport.itemType?i.$.taskTable:i.$.resourceTable;return n?n.exportData(e,i.dataExport.fileName,i.dataExport.exportFiltered,t):void 0}print(){const e=this,t=e.dataExport.fileName;e.dataExport.fileName=null;const i=e.exportData("html"),n=window.open("","","width=800,height=500"),a=n.document.open(),s='<!DOCTYPE html><html><head><meta charset="utf-8" /><title>'+t+"</title></head><body>"+i+"</body></html>";try{a.write(s),a.close(),setTimeout((function(){n.print(),n.close()}),100)}catch(e){}e.dataExport.fileName=t}getConnectionDetails(e){const t=this;if("string"!=typeof e)return;const i=t._getConnectionObjById(e);if(!i)return;const n=i.startTask,a=i.endTask,s={startTask:t._cloneObject(i.startTask),endTask:t._cloneObject(i.endTask),startTaskId:"string"==typeof n.id||"number"==typeof n.id?n.id:n.$.id,endTaskId:"string"==typeof a.id||"number"==typeof a.id?a.id:a.$.id,type:i.type};return void 0!==i.lag&&(s.lag=i.lag),s}getConnections(){const e=this;return e._connections.map((t=>{const i=t.startTask,n=t.endTask;return{id:t.startIndex+"-"+t.endIndex+"-"+t.type,startTask:e._cloneObject(i),endTask:e._cloneObject(n),startIndex:t.startIndex,startTaskId:"string"==typeof i.id||"number"==typeof i.id?i.id:i.$.id,endTaskId:"string"==typeof n.id||"number"==typeof n.id?n.id:n.$.id,endIndex:t.endIndex,type:t.type,lag:t.lag}}))}getState(){const e=this,t=e._getTasksJSON(!0)||[];return{tasks:JSON.parse(JSON.stringify(t)),selectedTaskIds:e.selectedTaskIds.slice(0),resources:JSON.parse(JSON.stringify(e._resources.slice(0))),scrollLeft:e.scrollLeft,scrollTop:e.scrollTop}}get tasks(){return this.isReady?this.getTasks():[]}get resources(){return this.isReady?this.getResources():[]}getTask(e){const t=this,i=t._getValidItemAndIndex(e);if(i.item)return t._cloneObject(i.item)}getTasks(){const e=this,t=e._tasks;return e.isReady&&t&&t.length?t.map((t=>e._cloneObject(t))):[]}getResource(e){const t=this,i=t._getValidItemAndIndex(e,"resource");if(i.item)return t._cloneObject(i.item)}getResources(){const e=this,t=e._resources;return e.isReady&&t&&t.length?t.map((t=>e._cloneObject(t))):[]}getItemPath(e){if(!e||void 0===e.type)return;const t="string"==typeof e.type?"task":"resource",i=this._getValidItemAndIndex(e,t);return i.item?i.item.$.id:void 0}getTaskIndex(e){const t=this;return"string"==typeof e?t._getTaskIndexById(e):t._getItemIndex(e,"task")}getTaskProject(e){const t=this;if((e=t._tasks[t._getItemIndex(e,"task")])&&e.$&&e.$.project)return t._cloneObject(e.$.project)}getTaskConnections(e){const t=this._getValidItemAndIndex(e,"task");return t&&t.item?this._getTaskConnections(t.item).taskConnections.map((e=>({target:e.endIndex,type:e.type,lag:e.lag}))):[]}getResourceIndex(e){return this._getItemIndex(e,"resource")}getResourceTasks(e){const t=this._getValidItemAndIndex(e,"resource");if(e=t?t.item:void 0)return this._getTasksAssigned(e)}getSelectedIds(){const e=this,t=e.selectedTaskIds,i=e.selectedResourceIds;return e.disableSelection||!t.length&&!i.length?null:{task:t.slice(),resources:i.slice()}}getSelectedTasks(){return this._getSelectedItems("task")}getSelectedResources(){return this._getSelectedItems("resource")}getWorkingHours(){const e=this.nonworkingHours;let t=[];for(let i=0,n=23;i<n;i+=1)e.indexOf(i)<0&&t.push(i);return t}isWorkingDay(e){return e=new Date(e),!isNaN(e.getTime())&&this.nonworkingDays.indexOf(e.getDay())<0}clearState(){const e=this;e.id?window.localStorage.removeItem("smartGanttChart"+e.id):e.warn(e.localize("noId"))}loadState(e){const t=this;if(!e){if(!t.id)return;e=JSON.parse(window.localStorage.getItem("smartGanttChart"+t.id))}if(!e)return;let i=JSON.stringify(e.tasks),n=JSON.stringify(e.selectedTaskIds),a=JSON.stringify(e.resources);if(i&&(i=JSON.parse(i)),n&&(n=JSON.parse(n)),a&&(a=JSON.parse(a)),t._noChangeEvent=!0,Array.isArray(i)&&(t._createTasks(i),t.set("dataSource",i)),Array.isArray(a)){let e=a;for(let i=0;i<e.length;i++){const e=a[i];let n=t._resources.find((t=>t.id&&t.id.toString()===e.id.toString()))||{};t._setResource(n,e),Object.values(n).length&&!t._resources.includes(n)&&t._resources.push(n)}t._refreshItemIds("resource")}"number"==typeof e.scrollLeft&&(t.scrollLeft=e.scrollLeft),"number"==typeof e.scrollTop&&(t.scrollTop=e.scrollTop),t._setTable(t.$.taskTable),t._createTimeline(),t._createResourceTimeline(),Array.isArray(n)&&(t.$.taskTable.selected=t._getSelection("task",n)),delete t._noChangeEvent}saveState(){const e=this;e.id?window.localStorage.setItem("smartGanttChart"+e.id,JSON.stringify(e.getState())):e.warn(e.localize("noId"))}insertTask(e,t,i){const n=this;if("object"!=typeof e)return void n.error(n.localize("incorrectArgument",{elementType:n.nodeName.toLowerCase(),methodName:"insertTask",argumentName:"newTask"}));const a=n._tasks;if(a.indexOf(e)>-1)return void n.error(n.localize("alreadyExists",{elementType:n.nodeName.toLowerCase(),methodName:"insertTask"}));const s=n._createTasks([e],!0);if(!a)return;let r,o,l;const d=n._getSelection("task",n.selectedTaskIds);if("string"==typeof i&&i.indexOf(!1)){const e=i.split(".");i=parseInt(e.slice(-1)),null==t&&(t=e.slice(0,-1).join("."))}if("string"==typeof t?(r=a.find((e=>e.id&&e.id.toString()===t)),r||(r=n._getItemByTableId("task",t))):"number"==typeof t&&(r=a[t]),r){if("project"!==r.type)return void n.error(n.localize("notAProject",{elementType:n.nodeName.toLowerCase(),argumentName:"project",methodName:"insertTask"}));s[0].$.project=r}return n._synchronizeProjectVisibility(s[0].$.project,s[0]),n._insertTasks(s,r,i),n._refreshItemIds(),n._refreshConnectionIds(),n._isUpdating?(n._isUpdating.type.task=!0,void(n._isUpdating.type.resource=!0)):(n._selected&&n._selected.task&&n._setSelection("task",l=n._selected.task.map((e=>e.$.id))),n._refreshTableDataSource(),n._refreshTimeline(),l&&d.toString()!==l.toString()&&(n.$.taskTable.selected=l.slice(0)),n._refreshTaskResources(o),n._ensureVisible(o),n.$.fireEvent("itemInsert",{type:"task",item:n._cloneObject(s[0])}),s[0].id||s[0].$.id+"")}openWindow(e){const t=this;if(t.disableWindowEditor)return;if("string"==typeof e){if(e.indexOf(".")>-1){const i=t._getVCellById("task",e),n=i?i.task:void 0;return void(n&&t._openPopupWindow(n))}if(e.indexOf("-")>-1){let e=(arguments[0]+"").split("-");if(e=t._getValidConnectionId(e[0],e[1],e[2],"openEditor"),e)return void t._openPopupWindow(e)}}const i=t._getValidItemAndIndex(e);i&&t._openPopupWindow(i.item)}closeWindow(){const e=this,t=["confirm","task","connection"];for(let i=0;i<t.length;i++){const n=e.$[t[i]+"PopupWindow"];n&&(n.close(),delete n._target)}}updateTask(e,t){const i=this,n=i._getValidItemAndIndex(e),a=n?n.item:void 0;"object"==typeof a?"object"==typeof t?i._updateTask(a,t):i.error(i.localize("incorrectArgument",{elementType:i.nodeName.toLowerCase(),methodName:"updateTask",argumentName:"taskDetails"})):i.error(i.localize("notExisting",{elementType:i.nodeName.toLowerCase(),methodName:"updateTask",argumentName:"newTask"}))}removeTask(e){const t=this,i=t._tasks,n=t._getValidItemAndIndex(e),a=n?n.item:void 0;i&&i.length&&("object"==typeof a?t._removeTask(a):t.error(t.localize("notExisting",{elementType:t.nodeName.toLowerCase(),methodName:"removeTask",argumentName:"index"})))}setWorkTime(e){this._setWorkTime(e,(function(e,t){for(let i=0,n=e.length;i<n;i+=1){const n=parseInt(e[i]),a=t.indexOf(n);a>-1&&t.splice(a,1)}return t}))}selectTask(e){this._handleItemSelection(e,"task")}selectResource(e){const t=this;t.$.mainSplitter.contains(t.$.resourceTable)&&t._handleItemSelection(e,"resource")}sort(e){const t=this;if("none"===t.sortMode)return;Array.isArray(e)||(e="object"==typeof e?[e]:[]);const i=t.taskColumns,n=t.resourceColumns,a=t.$.taskTable,s=t.$.resourceTable;for(let t=0;t<e.length;t++){const r=e[t],o="desc"===r.sortOrder?"desc":"asc",[l,d]="resource"===r.type||n.includes(r)?[s,n]:[a,i],c=d.find((e=>r.value&&e.value===r.value));c&&l.sortBy(c.value,o)}}unselectTask(e){this._handleItemSelection(e,"task",!0)}unselectResource(e){const t=this;t.$.mainSplitter.contains(t.$.resourceTable)&&t._handleItemSelection(e,"resource",!0)}unsetWorkTime(e){this._setWorkTime(e,(function(e,t){for(let i=0,n=e.length;i<n;i+=1){const n=parseInt(e[i]);t.indexOf(n)<0&&t.push(n)}return t}),!0)}hideTooltip(){this._closeTooltip()}showTooltip(e,t){this._openTooltip(e,void 0,t)}_getSelectedItems(e="task"){const t=this,i=t[`_${e}s`],n=t._getSelection(e,"task"===e?t.selectedTaskIds:t.selectedResourceIds);if(!n.length)return[];let a=[];for(let e=0,s=i.length;e<s;e+=1){const s=i[e];n.indexOf(s.$.id)>-1&&a.push(t._cloneObject(s))}return a}_getTasksAssigned(e){const t=this,i=t._tasks||[];let n=[];for(let a=0;a<i.length;a++){const s=i[a];!s.disableResources&&s.resources.find((t=>t===e.id))&&n.push(t._cloneObject(s))}return n}_getItemIndex(e,t){t||(t="task");const i=this[`_${t}s`];if(e instanceof HTMLElement&&e.classList.contains("smart-timeline-task"))return i.indexOf(e._cellObj[`_${t}`]);const n="resource"===t?["id","label","value","progress"]:["id","label","type","class","dateStart","dateEnd","resources","connections"];if("object"==typeof e)for(let t=0;t<i.length;t++)if(n.every((n=>Array.isArray(e[n])?JSON.stringify(e[n])===JSON.stringify(i[t][n]):n.indexOf("date")>-1?new Date(e[n]).getTime()===new Date(i[t][n]).getTime():e[n]===i[t][n])))return i.indexOf(i[t]);return-1}_handleItemSelection(e,t="task",i){const n=this,a=n._getValidItemAndIndex(e,t);if(a.item){const s=a.item,r=n._getSelection(t,"task"===t?n.selectedTaskIds:n.selectedResourceIds);if(e=s.$.id,i){const i=r.indexOf(e);i>-1&&(r.splice(i,1),n.$[`${t}Table`].selected=r)}else r.indexOf(e)<0&&(r.push(e),n.$[`${t}Table`].selected=r);return"string"==typeof s.id||"number"==typeof s.id?s.id:s.$.id}}_refreshAfterWorkingTimeChange(){const e=this;if(e.adjustToNonworkingTime)for(let t=0;t<e._tasks.length;t++){const i=e._tasks[t],n=i.$.project;e._validateTaskDates(i,n),e._synchronizeProjectDates(i,n),e._refreshTableColumnsData(i,["dateEnd","duration"])}e._refreshTimeline()}_refreshItemIds(e="task"){const t=this[`_${e}s`];if(!t)return;let i={},n=0;for(let e=0,a=t.length;e<a;e+=1){const a=t[e],s=a.$.project;if(void 0!==s){const e=s.$.id;i[e]||(i[e]=0),a.$.id=e+"."+i[e],i[e]++}else a.$.id=n+"",n++}}_refreshConnectionIds(){const e=this._tasks,t=this._connections;if(t&&t.length)for(let i=0,n=t.length;i<n;i+=1){const a=t[i],s=e.indexOf(a.startTask),r=e.indexOf(a.endTask);(s<0||r<0)&&(t.splice(i,1),n--),a.startIndex=s,a.endIndex=r}}_refreshSelectedItems(e="task",t){const i=this,n=i[`_${e}s`];if(n&&(!t&&i._selected&&i._selected[e]&&(t=i._selected[e]),t)){for(let e=0,i=t.length;e<i;e+=1){const a=t[e];(n.indexOf(a)<0||a.hidden)&&(t.splice(e,1),e-=1,i--)}i._setSelection(e,t.map((e=>e.$.id)))}}_resetFromAction(e="task",t="clearSort"){const i=this;function n(){i.$.taskTable[t](),i._createTimelineContent(),i._recycleTimelineTasks()}function a(){const e=i.$.resourceTable;e&&(e[t](),i._createResourceTimelineVCells(),i._recycleResourceContent())}"resource"===e?a():"task"===e?n():(n(),a())}_setWorkTime(e,t,i){const n=this;if("object"!=typeof e)return;let a,s=e.days,r=e.hours;null!=s&&(Array.isArray(s)||(s=[s]),s=n._nonworkingDayValidator(void 0,s),a=t(s,i?n.nonworkingDays:[0,1,2,3,4,5,6]),n.set("nonworkingDays",7===a.length?[]:a),n._refreshAfterWorkingTimeChange()),null!=r&&(Array.isArray(r)||(r=[r]),r=n._nonworkingTimeValidator(void 0,r),a=t(r,i?n.nonworkingHours:[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23]),n.set("nonworkingHours",24===a.length?[]:a),n._refreshAfterWorkingTimeChange())}_getValidConnectionId(e,t,i,n){const a=this,s=a._tasks,r=0===n.indexOf("_");let o;if("string"==typeof e&&(o=a._getTaskIndexById(e),o>=0&&(e=o)),"string"==typeof t&&(o=a._getTaskIndexById(t),o>=0&&(t=o)),e=parseInt(e),t=parseInt(t),i=parseInt(i),isNaN(e)||isNaN(t)||e===t)r||a.error(a.localize("incorrectArgument",{elementType:a.nodeName.toLowerCase(),methodName:n,argumentName:"taskIndex"}));else if(e>=s.length||e<0||t>=s.length||t<0)r||a.error(a.localize("outOfBounds",{elementType:a.nodeName.toLowerCase(),methodName:n,argumentName:"taskIndex"}));else{if(!(isNaN(i)||i<0||i>3))return r?[e,t,i]:e+"-"+t+"-"+i;r||a.error(a.localize("incorrectArgument",{elementType:a.nodeName.toLowerCase(),methodName:n,argumentName:"connectionType"}))}}_autoSchedule(e){const t=this,i=t._tasks;if(t.autoSchedule){e?Array.isArray(e)||(e=[e]):e=i;for(let i=0;i<e.length;i++){const n=e[i];"project"===n.type&&n.synchronized||(n.minDateStart=n.minDateEnd=void 0,t._autoScheduleTasks(n))}t._isUpdateRequired&&(t._createTimelineCells(),t._recycleTimelineTasks(!0),delete t._isUpdateRequired)}}_getTaskConnections(e){const t=this._tasks,i=this._connections;let n=[],a=[];if(t&&t.length&&i&&i.length){const s=t.indexOf(e);for(let e=0;e<i.length;e+=1){const t=i[e];t.startIndex===s?n.push(t):t.endIndex===s&&a.push(t)}}return{taskConnections:n,connectedTasks:a}}_autoScheduleTasks(e){const t=this,i=t._tasks,n=t._getTaskConnections(e),a=n.taskConnections,s=n.connectedTasks;let r,o,l;for(let n=0;n<a.length;n++)t._isAutoScheduled(e,i[a[n].endIndex],!0);for(let n=0;n<s.length;n++){const a=s[n],d=i[a.startIndex],c=a.type,m=a.lag,u=e.$.project;d&&"project"===d.type&&d.synchronized||(0===c||1===c?(l=new Date((0===c?d.dateStart:d.dateEnd).getTime()+m),e.minDateStart=new Date(e.minDateStart?Math.max(e.minDateStart.getTime(),l.getTime()):l),o=e.minDateStart.getTime()-e.dateStart.getTime(),r=new Date(e.dateEnd.getTime()+(t.autoScheduleStrictMode?o:Math.max(0,o))),r.getTime()!==e.dateEnd.getTime()&&(e.dateEnd=r,t._isUpdateRequired=!0),t.autoScheduleStrictMode&&e.minDateStart.getTime()!==e.dateStart.getTime()&&(e.dateStart=e.minDateStart,t._isUpdateRequired=!0)):(l=new Date((2===c?d.dateEnd:d.dateStart).getTime()+m),e.minDateEnd=new Date(e.minDateEnd?Math.min(e.minDateEnd.getTime(),l.getTime()):l),o=e.minDateEnd.getTime()-e.dateEnd.getTime(),r=new Date(e.dateStart.getTime()+(t.autoScheduleStrictMode?o:Math.max(0,o))),r.getTime()!==e.dateStart.getTime()&&(e.dateStart=r,t._isUpdateRequired=!0),t.autoScheduleStrictMode&&e.minDateEnd.getTime()!==e.dateEnd.getTime()&&(e.dateEnd=e.minDateEnd,t._isUpdateRequired=!0)),t._validateTaskDates(e,u),t._synchronizeProjectDates(e,u))}for(let e=0;e<a.length;e++){const n=i[a[e].endIndex];!n||"project"===n.type&&n.synchronized||(n.minDateStart=n.minDateEnd=void 0,t._autoScheduleTasks(n))}}_autoScheduleRestore(e,t){const i=this._tasks;e||(e=i),Array.isArray(e)||(e=[e]);for(let n=0;n<e.length;n++){const a=e[n];i.indexOf(e[n])>-1&&(t?0===t||1===t?a.minDateStart=void 0:a.minDateEnd=void 0:a.minDateStart=a.minDateEnd=void 0)}}_autoScroll(e){const t=this,i=t.hasAttribute("dragged"),n=t.hasAttribute("resized");function a(a,s){if(!t._dragDetails)return clearInterval(t._scrollInterval),t._scrollInterval=void 0,void delete t._autoScrolling;t._autoScrolling=!0,s?i||(t.scrollTop-=t.autoScrollStep*a,t._dragDetails.coordinates.y+=t.autoScrollStep*a):(t.scrollLeft-=(t.rightToLeft?-1:1)*t.autoScrollStep*a,t._dragDetails.coordinates.x+=t.autoScrollStep*a),i?t._handleTaskBarDrag(e):n&&t._handleTaskBarResize(e)}if(t.disableAutoScroll||!e||!i&&!n&&!t.hasAttribute("connecting-task"))return;const s=t.$.timeline.getBoundingClientRect();t._scrollInterval&&clearInterval(t._scrollInterval),t._scrollInterval=setInterval((function(){(t.scrollLeft||t.rightToLeft)&&e.clientX<=s.left+20?a(1):t.scrollLeft!==(t.rightToLeft?0:t.scrollWidth)&&e.clientX>=s.left+s.width-20?a(-1):t.scrollTop&&e.clientY<=s.top+20?a(1,!0):t.scrollTop!==t.scrollHeight&&e.clientY>=s.top+s.height-20?a(-1,!0):(clearInterval(t._scrollInterval),t._scrollInterval=void 0,delete t._autoScrolling)}),1)}_checkTaskBarResizability(e){const t=this;let i=e.originalEvent.target;t.shadowRoot&&i===t&&(i=e.originalEvent.composedPath()[0]);const n=t.$.timeline;if(!i.closest)return void n.removeAttribute("task-bar-hovered");let a,s=i.closest(".smart-timeline-row")||i.closest(".smart-timeline-task");if(t.disabled||t.disableTaskResize||!s||!n.contains(s))return void n.removeAttribute("task-bar-hovered");const r=s._cellObj.task,o=t._getTaskDOMIndex(r);if(s.classList.contains("smart-timeline-row")?a=t.$.timelineTasksContainer.children[o]:s.classList.contains("smart-timeline-task")&&(a=s,s=t.$.taskTimelineCellsContainer.children[o]),!a||a.classList.contains("milestone")||r.synchronized||r.disableResize)return;const l=i.closest(".smart-task-segment"),d=r.segments?r.segments.length:1;if(i.classList&&i.classList.contains("smart-task-connection-point")||l&&(d>1&&t.disableSegmentResize||l._segmentObj&&l._segmentObj.disableResize))return void n.removeAttribute("task-bar-hovered");const c=e.pageX-window.pageXOffset,m="visible"===t.resizeHandlesVisibility||t._isMobile?20:5,u=(l||a).getBoundingClientRect(),h=s.getBoundingClientRect(),g=Math.min(m,c-h.left),f=Math.min(m,h.left+h.width-c);Math.round(u.left)+g>=c&&Math.round(u.left)-g<=c?n.setAttribute("task-bar-hovered","left"):Math.round(u.left+u.width)+f>=c&&Math.round(u.left+u.width)-f<=c?n.setAttribute("task-bar-hovered","right"):n.removeAttribute("task-bar-hovered")}_onShadowDomLoaded(e,t,i){requestAnimationFrame((function n(){const a=(e.shadowRoot||e.getRootNode()).querySelectorAll("link");for(let e=0;e<a.length;e++)if(-1!==a[e].href.indexOf(t))return void i();requestAnimationFrame(n)}))}_getConnectionObjById(e){const t=this._connections;if(!e||!t||!t.length)return;const i=e.split("-"),n=parseInt(i[0]),a=parseInt(i[1]),s=parseInt(i[2]);for(let e=0,i=t.length;e<i;e+=1){const i=t[e];if(i.startIndex===n&&i.endIndex===a&&i.type===s)return i}}_positionWindow(){const e=this,t=e.getShadowRootOrBody(),i=[e.$.taskPopupWindow,e.$.connectionPopupWindow,e.$.confirmPopupWindow];for(let n=0;n<i.length;n++){const a=i[n];if(!a||!t.contains(a))continue;const s=e.getBoundingClientRect();a.opened||(a.style.left=a.style.top=""),e._isMobile?(a.setAttribute("mobile",""),a.style.left=s.left+window.pageXOffset+"px",a.style.top=s.top+window.pageYOffset+"px",a.style.width=s.width+"px",a.style.height=s.height+"px"):(a.style.left=Math.max(s.left+window.pageXOffset,s.left+window.pageXOffset+s.width/2-a.offsetWidth/2)+"px",a.style.top=Math.max(s.top+window.pageYOffset,s.top+window.pageYOffset+s.height/2-a.offsetHeight/2)+"px")}}_openPopupWindow(e,t){const i=this;function n(){function t(){i._positionWindow(),s.opened?(s.bringToFront(),s._onOpenCallback?s._onOpenCallback():s._handleActiveState()):s.open()}if(i.popupWindowCustomizationFunction?i.popupWindowCustomizationFunction(s,a,"connection"===a?e.startIndex+"-"+e.endIndex+"-"+e.type:i._cloneObject(e)):s._onOpenCallback=()=>{const e=(s.shadowRoot||s).querySelectorAll(".smart-gantt-chart-popup-window-editor .smart-input, .smart-popup-window-button");(e[0]||e[1]||s).focus({preventScroll:!0}),s._handleActiveState()},i._setPopupWindowTemplate("header",a,e),i._setPopupWindowTemplate("footer",a,e),i._setPopupWindowTemplate("content",a,e),!i._popupWindow[a+"PopupWindow"]){const e=i["$"+a+"PopupWindow"];e.unlisten("transitionend"),e.unlisten("open"),e.unlisten("close"),e.unlisten("closing"),e.unlisten("click"),e.unlisten("change"),e.listen("transitionend",i._popupWindowTransitionendHandler.bind(i)),e.listen("open",i._popupWindowOpenHandler.bind(i)),e.listen("close",i._popupWindowCloseHandler.bind(i)),e.listen("closing",i._popupWindowClosingHandler.bind(i)),e.listen("click",i._popupWindowClickHandler.bind(i)),e.listen("change",i._popupWindowChangeHandler.bind(i))}s.shadowRoot?(s.importStyle(Smart.Utilities.Core.getScriptLocation()+Smart.StyleBaseUrl.replace("/scoped/","/smart.textbox.css")),i._onShadowDomLoaded(s,"smart.window.css",t)):t();const n=(i.getAttribute("aria-owns")||"")+" "+s.id;i.setAttribute("aria-owns",n.trim()),i._popupWindow[a+"PopupWindow"]=s}if(e&&e.classList)if(e.classList.contains("smart-task-connection"))e=i._getConnectionObjById(e.getAttribute("connection-id"));else if("TR"===e.nodeType){const t=e?"task":"resource",n=i._getVCellById(t,e.getAttribute("row-id"));e=n?n[t]:void 0}else e=e._cellObj.task;if(!e||e.isGroup)return;const a=t?"confirm":"string"==typeof e.type?"task":"connection",s=i._createPopupWindow(a);!t&&i.$.fireEvent("opening",{target:s,type:a}).defaultPrevented||(i._closeTooltip(),s._target=e,i._popupWindow||(i._popupWindow={}),s.parentElement||i.getShadowRootOrBody().appendChild(s),s.isCompleted?n():s.whenReady((()=>n())))}_createPopupWindow(e){const t=this,i=e+"PopupWindow";if(t.$[i])return t.$[i];const n=document.createElement("smart-window");return n.classList.add("smart-"+e+"-popup-window"),n.classList.add("smart-gantt-chart-popup-window"),n.setAttribute("smart-id",i),t.$[i]=n,t["$"+i]=Smart.Utilities.Extend(n),n.rightToLeft=t.rightToLeft,n.theme=t.theme,n.animation=t.animation,n.disableSnap=!0,n.headerButtons=["close"],n}_popupWindowOpenHandler(e){const t=this,i=t["$"+e.target.getAttribute("smart-id")];if(i){const n=e.target.classList.contains("smart-confirm-popup-window")?"confirm":e.target.classList.contains("smart-connection-popup-window")?"connection":"task";t._handleModal(!0),t.$.fireEvent(e.type,Object.assign({type:n,target:e.target},e.detail)),i.unlisten("open")}}_popupWindowClosingHandler(e){const t=this["$"+e.target.getAttribute("smart-id")];if(!t)return;const i=e.target.classList.contains("smart-confirm-popup-window")?"confirm":e.target.classList.contains("smart-connection-popup-window")?"connection":"task";this.$.fireEvent(e.type,{target:e.target,type:i}).defaultPrevented?e.preventDefault():t.unlisten(e.type)}_popupWindowCloseHandler(e){const t=this,i=e.target.getAttribute("smart-id"),n=t["$"+i];if(n){const a=e.target.classList.contains("smart-confirm-popup-window")?"confirm":e.target.classList.contains("smart-connection-popup-window")?"connection":"task";if(t._handleModal(),t.$.fireEvent(e.type,Object.assign({type:a,target:e.target},e.detail)),n.unlisten("close"),n.unlisten("click"),t.hasAttribute("aria-owns")){const e=t.getAttribute("aria-owns").replace(t._popupWindow[i].id,"").trim();e?t.setAttribute("aria-owns",e):t.removeAttribute("aria-owns")}delete t._popupWindow[i];const s=Object.keys(t._popupWindow);1===s.length&&t._popupWindow.confirmPopupWindow&&(delete t._popupWindow.confirmPopupWindow._target,t._popupWindow.confirmPopupWindow.close()),s.length?requestAnimationFrame((()=>{const e=t._popupWindow[s[s.length-1]];e&&e.focus()})):t.keyboardNavigation&&t.$.taskTable.focus({preventScroll:!0})}}_popupWindowTransitionendHandler(e){const t=this,i=e.target;i instanceof Smart.Window&&!i.opened&&"visibility"===e.propertyName&&(t["$"+i.getAttribute("smart-id")].unlisten("transitionend"),i.parentElement&&i.parentElement.removeChild(i))}_handleModal(e){const t=this;let i=(t.shadowRoot||t).querySelector(".smart-popup-window-modal");e?(i||(i=document.createElement("div"),i.classList.add("smart-popup-window-modal")),i.parentElement||(t.$.container.appendChild(i),t.setAttribute("modal",""))):i&&i.parentElement&&Object.keys(t._popupWindow).length<2&&(i.parentElement.removeChild(i),t.removeAttribute("modal"))}_findTaskEditor(e,t){if(!e||!t)return;const i=t.children;for(let t=0,n=i.length;t<n;t+=1){const n=i[t];if(n.getAttribute("value")===e)return n}}_createTaskEditor(e,t,i){const n=this,a=e.value,s=t[e.value];let r,o,l=i.find((e=>e._label===a));if(l)r=l.querySelector(".smart-gantt-chart-label-container"),o=l.lastElementChild;else{const t="editorLabel"+Math.floor(65536*(1+Math.random())).toString(16).substring(1);if(r=document.createElement("div"),r.classList.add("smart-gantt-chart-label-container"),r.innerHTML=`<label id="${t}"></label>`,"deadline"===a){const e=document.createElement("span");e.classList.add("smart-popup-window-editor-toggle"),r.appendChild(e)}if(l=document.createElement("div"),l.classList.add("smart-gantt-chart-popup-window-editor"),l.setAttribute("value",a||""),l._label=a,e.customEditor)return l.appendChild(e.customEditor(a,s)),l;if("number"==typeof s||"string"==typeof s)o=document.createElement("input"),o.classList.add("smart-input");else if(s instanceof Date||"deadline"===a)Smart.DateTimePicker?(o=document.createElement("smart-date-time-picker"),o.locale=n.locale,o.dropDownAppendTo="body",o.calendarButton=!0,o.dropDownDisplayMode="auto",o.enableMouseWheelAction=!0,o.formatString="yyyy-MMM-dd HH:mm:ss"):(o=document.createElement("input"),o.type="datetime-local");else if(Array.isArray(s))if(Smart.DropDownList)o=document.createElement("smart-drop-down-list"),o.virtualized=!0,o.dropDownAppendTo="body",o.selectionMode="zeroOrMany";else{o=document.createElement("input"),o.classList.add("smart-input");const e=document.createElement("datalist");e.id="resourceList",o.setAttribute("list",e.id),l.appendChild(e)}o&&o.setAttribute("aria-labelledby",t)}if(!l.parentElement)return r&&l.appendChild(r),o&&l.appendChild(o),l;n._setPopupWindowEditors(e,t,l)}_setAriaControls(){this.setAttribute("role","treegrid")}_setPopupWindowEditors(e,t,i){const n=this,a=i.querySelector("label"),s=i.querySelector(".smart-popup-window-editor-toggle"),r=i.lastElementChild,o=e.value+"",l=o.split(/(?=[A-Z])/).join(" "),d=t[o];if(e.customEditor)e.setCustomEditorValue&&e.setCustomEditorValue(i,l,d);else{if(a.innerHTML=n.localize(e.value)||l.charAt(0).toUpperCase()+l.slice(1),s)if("deadline"===o){const e=null==d?"add":"remove";r.classList[e]("smart-hidden"),s.textContent=n.localize(e)}else s.remove();if("number"==typeof d)r.value=parseFloat(d);else if("string"==typeof d)r.value=d;else if(d instanceof Date)r.value=new Date(d);else if(Array.isArray(d)){const e=n._resources;if(r.placeholder=n.localize("unassigned"),Smart.DropDownList&&r instanceof Smart.DropDownList)r.dataSource=e.map((e=>({label:e.label,value:e.id}))),r.selectedValues=t.disableResources?[]:t.resources.map((e=>e.toString()));else{let n=i.querySelector("datalist"),a=document.createDocumentFragment();n.innerHTML="";for(let t=0;t<e.length;t++){const i=e[t],n=document.createElement("option");n.value=i.id,n.innerHTML=i.label,a.appendChild(n)}r.value=t.resources.toString(),n.appendChild(a)}}"project"===t.type&&t.synchronized&&["duration","date"].indexOf(l.toLowerCase())>-1||"resources"===l&&t.disableResources?r.disabled=!0:r.disabled=!!e.disableEdit,r.rightToLeft=n.rightToLeft,r.animation=n.animation,r.theme=n.theme}}_setupPopupWindowTabs(e,t){const i=this,n=i.popupWindowTabs,a="milestone"===t.type,s=[{label:i.localize("generalTab"),value:"general"},{label:i.localize("dependencyTab"),value:"dependency"},{label:i.localize("segmentsTab"),value:"segments"}];let r=e.querySelector(".smart-gantt-chart-popup-window-tabs");r||(r=document.createElement("smart-tabs"),r.classList.add("smart-gantt-chart-popup-window-tabs"),e.clear(),e.appendChild(r)),r.animation=i.animation,r.rightToLeft=i.rightToLeft,r.theme=i.theme;const o=r.getTabs().slice(0);for(let e=0,t=s.length;e<t;e+=1){const t=s[e],i=t.value;let l=o[e];n.indexOf(i)<0?l&&r.removeChild(l):(l||(l=document.createElement("smart-tab-item"),r.appendChild(l)),l.label=t.label,l.setAttribute("value",i||""),l.disabled=a&&"segments"===i)}return r}_setPopupWindowContent(e,t){const i=this,n=i.$[e+"PopupWindow"],a=[].slice.call(n.querySelectorAll(".smart-gantt-chart-popup-window-editor"));if(n.content&&(!n.content.innerHTML||a.length))if("task"===e&&t){const e=i.taskColumns;let s=[];const r=i._setupPopupWindowTabs(n,t);0!==r.selectedIndex&&(r.selectedIndex=0);const o=r.getTabs()[0];if("general"!==o.getAttribute("value"))return void i._handleTabsContent(o,n);"string"==typeof o.content?o.content="":o.content.innerHTML="";for(let n=0;n<e.length;n++){const r=e[n],l=r.value;if(void 0===t[l]&&"deadline"!==l||"overdue"===l)continue;let d=i._findTaskEditor(l,o);d||(d=i._createTaskEditor(r,t,a),d&&o.appendChild(d)),d&&(i._setPopupWindowEditors(r,t,d),s.push(d))}for(let e=0,t=a.length;e<t;e+=1){const t=a[e];s.indexOf(t)<0&&t.remove()}t.id&&n.setAttribute("aria-controls",t.id)}else if("confirm"===e){if(n.innerHTML='<div class="smart-gantt-chart-popup-window-editor">'+i.localize("confirm",{componentName:"The task"})+"</div >",i._popupWindow){const e=Object.keys(i._popupWindow);e.length&&n.setAttribute("aria-controls",i._popupWindow[e[e.length-1]].id)}}else{const e=t.startTask,a=t.endTask;n.innerHTML='<div class="smart-gantt-chart-popup-window-editor">'+i.localize("deleteLink")+"<b> "+e.label+" - "+a.label+"?</b></div>"}}_setPopupWindowTemplate(e,t,i){const n=this,a=n.$[t+"PopupWindow"];if("content"!==e){if(a[e+"Template"]||(a[e+"Template"]=n._createPopupWindowTemplate(e,t)),"header"===e&&i&&"string"==typeof i.type){const e=(a.shadowRoot||a).querySelector(".smart-popup-window-label");e&&(e.innerHTML=i.label)}else if("footer"===e){const e=(a.shadowRoot||a).querySelectorAll(".smart-popup-window-button");for(let i=0;i<e.length;i++){const a=e[i];a.innerHTML="task"===t?'<span class="smart-icon"></span>':"",a.theme=n.theme,a.rightToLeft=n.rightToLeft,a.animation=n.animation,a.disabled=!1,a.classList.contains("ok")?(a.innerHTML+=n.localize("ok"),a.setAttribute("aria-label","ok")):a.classList.contains("cancel")?(a.innerHTML+=n.localize("cancel"),a.setAttribute("aria-label","cancel")):a.classList.contains("delete")&&(a.innerHTML+=n.localize("delete"),a.setAttribute("aria-label","delete"));const s=a.querySelector(".smart-ripple");s&&s.parentElement.removeChild(s)}}}else n._setPopupWindowContent(t,i)}_createPopupWindowTemplate(e,t){const i=this,n=document.createElement("template");if("footer"===e)switch(t){case"task":n.innerHTML=`<smart-button class="smart-popup-window-button ok primary"\n                            animation="${i.animation}" theme="${i.theme}" ${i.rightToLeft?"right-to-left":""}>\n                        </smart-button>\n                        <smart-button class="smart-popup-window-button cancel"\n                            animation="${i.animation}" theme="${i.theme}" ${i.rightToLeft?"right-to-left":""}>\n                        </smart-button>\n                        <smart-button class="smart-popup-window-button delete secondary"\n                            animation="${i.animation}" theme="${i.theme}" ${i.rightToLeft?"right-to-left":""}>\n                        </smart-button>`;break;case"connection":case"confirm":n.innerHTML=`<smart-button class="smart-popup-window-button ok primary"\n                            animation="${i.animation}" theme="${i.theme}" ${i.rightToLeft?"right-to-left":""}>\n                        </smart-button>\n                    <smart-button class="smart-popup-window-button cancel"\n                        animation="${i.animation}" theme="${i.theme}" ${i.rightToLeft?"right-to-left":""}>\n                    </smart-button>`}else"header"!==e||"task"!==t&&"confirm"!==t||(n.innerHTML='<span class="smart-popup-window-label"></span>');return n}_handleTabsContent(e,t){const i=this,n=t._target;if(!e|!n)return;const a=e.getAttribute("value");if("general"===a)return;let s=e.querySelector(".smart-gantt-popup-window-table"),r=e.querySelector(".smart-gantt-window-table-buttons"),o=e.querySelector(".smart-gantt-window-validation-message");r||(r=document.createElement("div"),r.classList.add("smart-gantt-window-table-buttons"),r.innerHTML=`<smart-button class="smart-gantt-chart-button" action="add">${i.localize("add")}</smart-button>\n                                 <smart-button class="smart-gantt-chart-button" disabled action="delete">${i.localize("delete")}</smart-button>`,e.insertBefore(r,s)),s||(s=document.createElement("smart-table"),s.classList.add("smart-gantt-popup-window-table"),s.editing=!0,s.editMode="row",s.keyboardNavigation=!0,s.wait=!0,s.hideSelectionColumn=!0,s.selection=!0,s.selectionMode="one",s.columnMinWidth="10px",s.addEventListener("rowEndEdit",(r=>{const o=r.detail.row;switch(a){case"dependency":{const e=i._tasks,t=o.name,a=e.indexOf(n),r=e.findIndex((e=>e.$.id===t));r>-1&&s.updateRow(o.$.id,{id:`${r}-${a}-${o.type}`});break}case"segments":{const e=o.dateStart,t=o.dateEnd;e.getTime&&t.getTime&&s.updateRow(o.$.id,{duration:parseFloat(i._convertDuration(i.nonworkingDays.length>0||i.nonworkingHours.length>0?i._getWorkingTime(e,t):t.getTime()-e.getTime(),!0).toFixed(2))});break}}i._applyTableValidation(e,s,t),i._isPopupWindowTableModified=!0})),e.innerHTML&&(e.innerHTML=""),e.appendChild(s));const l=i._getTabsTableData(a,n);s.selected.length&&(s.selected=[]),s.dataSource=l.source,s.columns=l.columns,s.wait=!1,delete i._isPopupWindowTableModified,o||(o=document.createElement("label"),o.classList.add("smart-gantt-window-validation-message"),e.appendChild(o)),o.textContent=""}_applyTableValidation(e,t,i){const n=this,a=e.getAttribute("value"),s=e.querySelector(".smart-gantt-window-validation-message"),r=i.querySelector(".smart-popup-window-button.ok"),o=t.dataSource,l=o.length;if(!s)return void(r&&(r.disabled=!1));if(!l)return s.textContent="",void(r&&(r.disabled=!1));let d="";if("segments"===a)if(l<2)d=n.localize("segmentsCountValidation");else{const e=i._target,t=e.dateStart.getTime(),a=e.dateEnd.getTime();let s={};for(let e=0;e<l;e+=1){const i=o[e],r=i.label,l=i.dateStart.getTime(),c=i.dateEnd.getTime();for(let e in s){const t=s[e],a=t.timeStart,r=t.timeEnd,o=l<=a&&c>=a,m=l<=r&&c>=r;(o||m)&&(d+=n.localize("segmentConflictError",{dateConflict:o?"dateStart":"dateEnd",label:i.label,conflictLabel:t.label})+"\r\n")}l>c?d+=n.localize("segmentStartError",{label:i.label})+"\r\n":l===c&&(d+=n.localize("segmentEndError",{label:i.label})+"\r\n"),(l<t||c>a)&&(d+=n.localize("segmentRangeError",{label:i.label})+"\r\n"),void 0===s[e]&&(s[e]={label:r,timeStart:l,timeEnd:c})}}else if("dependency"===a)for(let e=0;e<l;e+=1){const t=o[e].id.split("-");t[0]===t[1]&&(d+=n.localize("dependencyValidation")+"\r\n")}s.textContent=d,r&&(r.disabled=d.length>0)}_getTabsTableData(e,t){const i=this;if("dependency"===e){const e=i._getTaskConnections(t).connectedTasks,n={connectionTypes:[{label:i.localize("startToStart"),value:0},{label:i.localize("endToStart"),value:1},{label:i.localize("endToEnd"),value:2},{label:i.localize("startToEnd"),value:3}],tasks:(()=>{const e=i._tasks;let n=[];for(let i=0,a=e.length;i<a;i+=1){const a=e[i];a!==t&&n.push({value:a.$.id,label:a.label})}return n})()};return{source:new window.Smart.DataAdapter({dataSource:e&&e.length?e.map((e=>({id:e.startIndex+"-"+e.endIndex+"-"+e.type,name:e.startTask.$.id||"",type:e.type,lag:e.lag||0}))):[],dataFields:["id: any","name: any","type: number","lag: number"]}),columns:[{label:i.localize("id"),dataField:"id",dataType:"any",autoWidth:!1,allowEdit:!1},{label:i.localize("name"),dataField:"name",dataType:"any",width:"35%",autoWidth:!1,editor:i._getColumnEditorSetup("name",n),formatFunction:e=>{const t=n.tasks.find((t=>t.value===e.value));t&&(e.value=t.label)}},{label:i.localize("type"),dataField:"type",dataType:"number",width:"25%",autoWidth:!1,editor:i._getColumnEditorSetup("type",n),formatFunction:e=>{const t=n.connectionTypes.find((t=>t.value===e.value));t&&(e.value=t.label)}},{label:i.localize("lag"),dataField:"lag",dataType:"number",autoWidth:!1}]}}if("segments"===e){const e={task:t};return{source:new window.Smart.DataAdapter({dataSource:t.segments,dataFields:["label: string","dateStart: date","dateEnd: date","duration: number"]}),columns:[{label:i.localize("name"),dataField:"label",dataType:"string",autoWidth:!1,width:"20%"},{label:i.localize("dateStart"),dataField:"dateStart",dataType:"date",autoWidth:!1,editor:i._getColumnEditorSetup("dateStart",e),formatFunction:e=>{e.value=i._formatDate(e.data.dateStart)}},{label:i.localize("dateEnd"),dataField:"dateEnd",dataType:"date",autoWidth:!1,editor:i._getColumnEditorSetup("dateEnd",e),formatFunction:e=>{e.value=i._formatDate(e.data.dateEnd)}},{label:i.localize("duration"),dataField:"duration",dataType:"number",autoWidth:!1,width:"15%",allowEdit:!1}]}}return{source:[],columns:[]}}_getColumnEditorSetup(e,t){const i=this;switch(e){case"dateStart":case"dateEnd":return{template:'<smart-date-time-picker drop-down-append-to="body" wait></smart-date-time-picker>',onInit:(e,n,a,s)=>{const r=t.task;s||(s=new Date(r.dateStart)),a.rightToLeft=i.rightToLeft,a.animation=i.animation,a.theme=i.theme,a.min=r.dateStart,a.max=r.dateEnd,a.locale=i.locale,a.calendarButton=!0,a.dropDownDisplayMode="auto",a.enableMouseWheelAction=!0,a.formatString="yyyy-MMM-dd HH:mm:ss",a.value=new Date(Math.max(r.dateStart.getTime(),Math.min(r.dateEnd.getTime(),s.getTime()))),a.removeAttribute("wait")},getValue:e=>e.value.toDate()};case"name":return{template:'<smart-drop-down-list virtualized drop-down-append-to="body" wait></smart-drop-down-list>',onInit:(e,n,a,s)=>{a.rightToLeft=i.rightToLeft,a.animation=i.animation,a.theme=i.theme,a.dataSource=t.tasks,a.selectedValues=[s],a.removeAttribute("wait")},getValue:e=>e.selectedValues[0]};case"type":return{template:"<smart-input wait></smart-input>",onInit:(e,n,a,s)=>{const r=t.connectionTypes,o=r.find((e=>e.value===s));a.readonly=!0,a.rightToLeft=i.rightToLeft,a.animation=i.animation,a.theme=i.theme,a.dropDownButtonPosition="right",a.dataSource=r,a.value=(o||r[0]).label+"",a.removeAttribute("wait")},getValue:e=>{if(e.selectedValues.length)return e.selectedValues[0];const i=t.connectionTypes.find((t=>t.label===e.value));return i?i.value:void 0}}}}_popupWindowChangeHandler(e){const t=this,i=e.target,n=i.closest("smart-window")||(i.getRootNode()&&i.getRootNode().host?i.getRootNode().host:void 0);if(n._target)if(i.classList.contains("smart-gantt-chart-popup-window-tabs")){const a=n.querySelector(".smart-popup-window-button.ok");a&&(a.disabled=!1),t._handleTabsContent(i.getTabs()[e.detail.index],n)}else if(i.classList.contains("smart-gantt-popup-window-table")){const e=i.closest("smart-tab-item").querySelector('.smart-gantt-chart-button[action="delete"]');e&&(e.disabled=0===i.selected.length)}}_popupWindowClickHandler(e){const t=this;let i=(e.originalEvent||e).target;i.shadowRoot&&(i=(e.originalEvent||e).composedPath()[0]);const n=i.closest("smart-window")||(i.getRootNode()&&i.getRootNode().host?i.getRootNode().host:void 0),a=n._target;if(i.closest(".smart-popup-window-button.cancel"))return t._popupWindow&&t._popupWindow.confirmPopupWindow&&n!==t._popupWindow.confirmPopupWindow&&t._popupWindow.confirmPopupWindow.close(),n.close(),void delete n._target;if(i.closest(".smart-popup-window-button.ok")){if(n===t.$.connectionPopupWindow&&"number"==typeof a.type)t._removeConnection(a.startIndex+"-"+a.endIndex+"-"+a.type);else if(n===t.$.confirmPopupWindow){const e=a;void 0!==e.$._resourceId?t._removeResource(e):t._removeTask(e),n.close(),t.$.taskPopupWindow&&t.$.taskPopupWindow.close(),delete n._target}else{const e=n.shadowRoot||n,i=e.querySelectorAll(".smart-gantt-chart-popup-window-editor"),s=a;let r={};for(let e=0;e<i.length;e++){const n=i[e]._label,a=t.taskColumns.find((e=>e.value===n));if(a.customEditor&&a.getCustomEditorValue)r[n]=a.getCustomEditorValue(i[e]);else{const t=i[e].lastElementChild;let a;if(!t)continue;if(t.classList.contains("smart-hidden")){r[n]=void 0;continue}a=Smart.DateTimePicker&&t instanceof Smart.DateTimePicker?t.value.toDate?t.value.toDate():t.value:t instanceof HTMLInputElement&&"datetime-local"===t.type?new Date(t.value):Smart.DropDownList&&t instanceof Smart.DropDownList?t.selectedValues.slice(0):t.hasAttribute("list")?t.value.split(",").map((e=>e.trim())):t.value,a instanceof Date&&isNaN(a.getTime())&&(a=void 0),null!=a&&(r[n]=a)}}if(void 0!==s.$._resourceId)t._updateResource(s,r);else{const i=r.dateStart?r.dateStart:void 0,n=r.dateEnd?r.dateEnd:void 0;if((i&&i.getTime&&i.getTime()!==s.dateStart.getTime()||n&&n.getTime&&n.getTime()!==s.dateEnd.getTime())&&(r.duration=void 0),t._isPopupWindowTableModified){const i=e.querySelectorAll(".smart-gantt-popup-window-table");for(let e=0,n=i.length;e<n;e+=1){const n=i[e];n.closest('.smart-tab-item[value="dependency"]')?t._updateTaskDependencies(n,s):n.closest('.smart-tab-item[value="segments"]')&&t._updateTaskSegments(n,s)}}t._updateTask(s,r)}}return t._popupWindow&&t._popupWindow.confirmPopupWindow&&n!==t._popupWindow.confirmPopupWindow&&t._popupWindow.confirmPopupWindow.close(),n.close(),void delete n._target}if(i.closest(".smart-popup-window-button.delete"))return void t._openPopupWindow(n._target,!0);if(i.closest(".smart-popup-window-editor-toggle")){const e=i.closest('.smart-gantt-chart-popup-window-editor[value="deadline"]'),n=e?e.lastElementChild:void 0;if(n){const e=n.classList.contains("smart-hidden")?"remove":"add";n.classList[e]("smart-hidden"),i.textContent=t.localize(e)}return}const s=i.closest(".smart-gantt-chart-button");if(s){const e=i.closest("smart-tab-item"),r=e.querySelector(".smart-gantt-popup-window-table");if(!r)return;const o=s.getAttribute("action"),l=e.getAttribute("value"),d=a;switch(o){case"add":{let e;e="segments"===l?{label:`${t.localize("segment")} ${r.dataSource.length+1}`,dateStart:new Date(d.dateStart),dateEnd:new Date(d.dateEnd),duration:parseFloat((d.duration||0).toFixed(2))}:{id:"",name:"",type:0,lag:0},r.addRow(e),r.beginEdit(r.rows.length-1),t._isPopupWindowTableModified=!0;break}case"delete":{const e=r.selected;r.beginUpdate();for(let t=0,i=e.length;t<i;t+=1)r.removeRow(e[t]);r.endUpdate(),t._isPopupWindowTableModified=!0;break}}t._applyTableValidation(e,r,n)}}_updateTaskDependencies(e,t){const i=this,n=i._tasks.indexOf(t),a=i._getTaskConnections(t).connectedTasks,s=e.rows;for(let e=0,t=a.length;e<t;e+=1){const t=a[e];i._removeConnection(`${t.startIndex}-${t.endIndex}-${t.type}`)}for(let e=0,t=s.length;e<t;e+=1){const t=s[e].data,a=t.name,r=t.type;if(!i._getValidConnectionId(a,n,r,"_"))continue;const o=parseInt(t.lag);i._connectTask([a,n,r,isNaN(o)?0:o])}i._recycleConnections()}_updateTaskSegments(e,t){const i=e.rows;let n=[];for(let e=0,t=i.length;e<t;e+=1){const t=i[e].data,a=t.label,s=new Date(t.dateStart),r=new Date(t.dateEnd);isNaN(s)||isNaN(r)||n.push({label:"string"==typeof a?a:"",dateStart:s,dateEnd:r})}t.segments=n,this._validateTaskSegments(t)}_createTasks(e,t){const i=this,n={},a=[];e||(e=i.dataSource),i.dataSource instanceof Smart.DataAdapter&&(e=i._parseAdapterData(i.dataSource.toArray())),t||i.clearTasks();let s=[];if(function e(r,o){let l=[];if(!r||0===r.length)return[];for(let d=0;d<r.length;d++){let c,m=r[d];if("object"!=typeof m)continue;if(m=i._validateTaskProperties(m,o),!m)continue;const u=m.tasks,h=m.id;m.$.project=o,m.$.id=o?o.$.id+"."+d:d+"","string"!=typeof h&&"number"!=typeof h||(n[h]?a.push(h):n[h]=1),u instanceof Array&&u.length>0&&(m.synchronized&&(m.dateStart=m.minDateStart=m.maxDateStart=void 0,m.dateEnd=m.minDateEnd=m.maxDateEnd=void 0),m.type="project",c=e(u,m),c.length&&(m.hidden=!c.some((e=>!e.hidden)),m.hidden?c.forEach((e=>e.hidden=m.hidden)):i._synchronizeProjectVisibility(o,m))),(!m.type||["project","task","milestone"].indexOf(m.type)<0)&&(m.type="task"),o&&"project"===m.type&&c&&c.length>0?(l.push(m),l=l.concat(c)):(o||((t&&"project"===m.type&&m.synchronized||m.dateStart&&m.dateEnd&&!isNaN(m.dateStart.getTime())&&!isNaN(m.dateEnd.getTime()))&&s.push(m),c&&(s=s.concat(c))),l.push(m))}return o&&i._synchronizeProjectDates(o,l),l}(e),t)return s.slice(0);a.length&&console.warn(i.localize("duplicateIds",{elementType:i.nodeName.toLowerCase(),duplicates:a.toString()})),i._tasks=s.slice(0),i._handleResources()}_createTimeline(){const e=this;e._tasks&&0!==e._tasks.length?(delete e.__tasks,e._createConnections(),e._autoSchedule(),e._createTimelineCells(),e._insertTimelineTasks(),e.$.taskSplitter.refresh()):e._clearTasks()}_createConnections(){const e=this,t=e._tasks;e._connections=[];for(let i=0,n=t.length;i<n;i+=1)t[i].connections&&e._handleTaskConnections(i)}_createTooltip(){const e=this,t=e.tooltip;let i=e.$.tooltip;if(t.enabled)return i||(e.$.tooltip=i=document.createElement("smart-tooltip"),i.classList.add("smart-gantt-chart-tooltip"),i.setAttribute("smart-id","tooltip")),e.$tooltip||e._handleTooltipEvents(!0),i.rightToLeft=e.rightToLeft,i.theme=e.theme,i.openMode="manual",i.arrow=t.arrow,i.delay=t.delay,i.parentElement||e.$.container.appendChild(i),i;i&&(i.close(),i.remove())}_handleTooltipEvents(e){const t=this,i=t.$.tooltip;if(!i)return;let n=t.$tooltip;e?(n=t.$tooltip=Smart.Utilities.Extend(i),n.listen("close",t._tooltipVisibilityHandler.bind(t)),n.listen("closing",t._tooltipVisibilityHandler.bind(t)),n.listen("open",t._tooltipVisibilityHandler.bind(t)),n.listen("opening",t._tooltipVisibilityHandler.bind(t))):n&&(n.unlisten("close"),n.unlisten("closing"),n.unlisten("open"),n.unlisten("opening"),delete t.$tooltip)}_toggleTooltip(e){const t=this;if(t._dragDetails||!t.tooltip.enabled||!t.$.container.contains(e.target))return void t._closeTooltip();const i=t.getRootNode(),n={"smart-task-segment":null,"smart-timeline-task":null,"smart-gantt-chart-task-indicator":null,"smart-resource-timeline-view-cell":null,"smart-task-connection":null},a=(i.host?i.host.shadowRoot:i).elementsFromPoint(e.clientX,e.clientY);let s;for(let e=0,t=a.length;e<t;e+=1){const t=a[e],i=t.classList;if(i.contains("smart-task-container"))n["smart-timeline-task"]=t.closest(".smart-timeline-task");else for(let e in n)i.contains(e)&&(n[e]=t)}if(n["smart-task-segment"]){const e=n["smart-timeline-task"],t=e?e._cellObj.task:void 0;s=t&&t.segments&&t.segments.length?n["smart-task-segment"]:e}else if(n["smart-gantt-chart-task-indicator"])s=n["smart-gantt-chart-task-indicator"];else for(let e in n)if(n[e]){s=n[e];break}s?t._openTooltip(s,e):t._closeTooltip()}_getConnectionTypeName(e){const t=this;switch(e){case 0:return t.localize("startToStart");case 1:return t.localize("endToStart");case 2:return t.localize("endToEnd");case 3:return t.localize("startToEnd");default:return""}}_getSegmentTask(e){const t=this._tasks;for(let i=0,n=t.length;i<n;i+=1){const n=t[i];if(Array.isArray(n.segments)&&n.segments.indexOf(e)>-1)return n}}_getTooltipContent(e){const t=this;if(!e)return;const i=e.classList;let n,a;if(i.contains("smart-task-segment")){if(a=e._segmentObj,a){let e=a.label;if(void 0===e){const i=t._getSegmentTask(a);i&&(e=i.label)}n=`<label><b>${t.localize("segment")}</b>: ${e||""}</label>\n                           <label><b>${t.localize("dateStart")}</b>: ${t._formatDate(a.dateStart)||""}</label>\n                           <label><b>${t.localize("dateEnd")}</b>: ${t._formatDate(a.dateEnd)||""}</label>`}}else if(i.contains("smart-timeline-task"))a=e._cellObj.task,a&&!a.segments&&(n=`<label><b>${t.localize("task")}</b>: ${a.label||""}</label>\n                           <label><b>${t.localize("dateStart")}</b>: ${t._formatDate(a.dateStart)||""}</label>\n                           <label><b>${t.localize("dateEnd")}</b>: ${t._formatDate(a.dateEnd)||""}</label>`);else if(i.contains("smart-gantt-chart-task-indicator"))a=e._indicatorObj,a&&(n=a.label||"");else if(i.contains("smart-resource-timeline-view-cell")){if(!e.hasAttribute("load"))return;const i=e.closest(".smart-timeline-cell");if((e=e.closest(".smart-timeline-row"))&&e._cellObj&&(a=e._cellObj.resource),a){const s=t._getResourceTasks(a),r="hours"===t.resourceTimelineView?"h":"",o=t._tasks,l=t.$.resourceTimelineViewCells.children,d=Array.from(e.children).findIndex((e=>e===i));n=`<label><b>${t.localize("resource")}</b>: ${a.label||""}</label>\n                           <label><b>${t.localize("assignments")}</b>:</label>`;for(let e=0,i=s.length;e<i;e+=1){const i=s[e],c=o.indexOf(i),m=t._getResourceCellCapacity({cellDateRange:t._getCellDateRange(l[d]),cellTaskIndexAssigned:[c],index:d,resource:a,task:i,cellIndex:d});void 0!==m&&(n+=`<label>${t.localize("task")} #${c}: (${parseFloat(m.capacity.toFixed(1))}${r}) ${i.label||""}</label>`)}}}else i.contains("smart-task-connection")&&(a=t.getConnectionDetails(e.getAttribute("connection-id")),void 0!==a&&(n=`<label><b>${t.localize("startTask")}</b>: ${a.startTask.label||""}</label>\n                           <label><b>${t.localize("endTask")}</b>: ${a.endTask.label||""}</label>\n                           <label><b>${t.localize("type")}</b>: ${t._getConnectionTypeName(a.type)||""}</label>`,a.lag&&(n+=`<label><b>${t.localize("lag")}</b>: ${parseFloat(a.lag.toFixed(1))}</label>`)));return a?a.tooltip?a.tooltip+"":n||"":void 0}_openTooltip(e,t,i){const n=this,a=n.tooltip;if(i="string"==typeof i?i:n._getTooltipContent(e),!(a.enabled&&i&&e&&e.nodeName))return void n._closeTooltip();const s=n.$.tooltip||n._createTooltip();let r,o;if(i&&s.value!==i&&(s.value=i),s.selector=e,t&&t.pageX){const i=document.body.getBoundingClientRect(),n=e.getBoundingClientRect(),l=a,d=l.offset[0]||0,c=l.offset[1]||0,m=s.offsetWidth,u=s.offsetHeight;let h="bottom";"absolute"!==s.position&&(s.position="absolute",s.offset=[]),o=Math.min(i.left+i.width-m,t.pageX-m/2-d),r=n.top-u-c,r<i.top&&(r=n.bottom+c,h="top"),o<i.left&&(o=i.left+d,h="left"),h!==s.arrowDirection&&(s.arrowDirection=h),s.style.left=o+"px",s.style.top=r+"px"}else"auto"!==s.position&&(s.position="auto",s.offset=a.offset);s.visible||(n.getShadowRootOrBody().appendChild(s),s.open())}_closeTooltip(){const e=this.$.tooltip;e&&e.visible&&e.close()}_tooltipVisibilityHandler(e){const t=this,i=e.type,n=t.$.tooltip;e.target===n&&(e.stopPropagation(),t._fireTooltipVisibilityEvent(e)?e.preventDefault():"opening"===i?n.classList.remove("smart-visibility-hidden"):"closing"===i&&(n.hasAnimation?n.addEventListener("transitionend",(()=>{n.visible||(n.classList.add("smart-visibility-hidden"),n.style.top=n.style.left=0,t.$.container.appendChild(n))}),{once:!0}):t.$.container.appendChild(n)))}_fireTooltipVisibilityEvent(e){const t=this,i=e.type,n=t.$.tooltip,a=e.detail.owner;let s={target:n,owner:a};if(a)if(a.classList.contains("smart-task-connection")){s.type="connection";const e=t.getConnectionDetails(a.getAttribute("connection-id"));e&&(s.item=e)}else if(a.classList.contains("smart-gantt-chart-task-indicator"))s.type="indicator",a._indicatorObj&&(s.item=t._cloneObject(a._indicatorObj));else if(a.classList.contains("smart-task-segment"))s.type="segment",a._segmentObj&&(s.item=t._cloneObject(a._segmentObj));else if(a.classList.contains("smart-timeline-task"))s.type="task",a._cellObj&&a._cellObj.task&&(s.item=t._cloneObject(a._cellObj.task));else if(a.classList.contains("smart-resource-timeline-view-cell")){s.type="resource";const e=a.closest(".smart-timeline-row");e._cellObj&&(s.item=t._cloneObject(e._cellObj.resource))}let r=t.getAttribute("aria-owns")||"";switch(i){case"open":t.setAttribute("aria-owns",(r+" "+n.id).trim()),t.$.fireEvent(i,s);break;case"close":r=r.replace(n.id,"").trim(),r?t.setAttribute("aria-owns",r):t.removeAttribute("aria-owns"),t.$.fireEvent(i,s);break;case"closing":case"opening":if(t.$.fireEvent(i,s).defaultPrevented)return!0}}_parseAdapterData(e){let t={};for(let i=0,n=e.length;i<n;i+=1){const n=e[i],a=Object.assign({},n),s=n.parent,r=n.$.id;if(s&&s!==n){const e=s.$.id;t[e]||(t[e]=Object.assign({},s));const i=t[e];i.tasks||(i.tasks=[]),i.tasks.push(a)}else t[r]=a;delete a.parent,delete a.children,delete a.$}return Object.values(t)}_handleTaskConnections(e){const t=this,i=t._tasks;let n;if("number"==typeof e&&(n=e,e=i[e]),!e)return;void 0===n&&(n=i.indexOf(e));const a=e.connections,s=i.length;for(let e=0;e<a.length;e++){const i=a[e],r=t._getTaskIndexById(i.target);null==r||isNaN(r)||r<0||r>=s||r===n||t._connectTask([n,r,i.type,i.lag])}delete e.connections}_insertTasks(e,t,i){const n=this,a=n._tasks;if(t){const s=n._getProjectTasks(t,!0);if(s.length){const t=s[s.length-1];let r,o;"number"==typeof i&&i<s.length?r=s[i=Math.max(0,i)]:(r=t,o=!0);const l=n._getProjectTasks(r);i=o&&l.length?a.indexOf(l[l.length-1]):a.indexOf(r),a.splice.apply(a,[i+(o?1:0),0].concat(e))}else a.splice.apply(a,[a.indexOf(t)+1,0].concat(e))}else"number"==typeof i?(i+="",(i=a.findIndex((e=>e.$.id===i)))<0&&(i=a.length)):i=a.length,a.splice.apply(a,[i,0].concat(e))}_insertTimelineTasks(){const e=this,t=e._timelineVCells;t&&t.length?(e._recycleTimelineTasks(),e._refresh()):e._resetTimeline()}_recycleTimelineTasks(e){const t=this,i=t.$.taskIndicatorsContainer,n=i.children,a=t.$.taskTimelineCellsContainer.childElementCount,s=t._timelineVCells;for(;i.childElementCount>a;)i.firstElementChild.remove();if(t._closeTooltip(),!s||!s.length)return;const r=s.indexOf(t._getFirstContentCellInView()),o=t._getSelection("task",t.selectedTaskIds),l={timelineStart:t.dateStart.getTime(),timelineEnd:t.dateEnd.getTime()};for(let i=0,d=a;i<d;i++){const a=n[i],d=s[r+i];if(!d){a&&a.remove();continue}const c=d.task;t._snapToNearestDates(c),t._recycleTaskBars(d,i,o),t._setTimelineTaskBar(d,i),t._setTimelineTaskBaseline(d,i),t._setTaskBarProgress(c,i),t._setTaskBarLabel(c,i),t._setTaskIndicators(d,i,l),t._setTaskDeadline(d,i,l),e&&t._refreshTableColumnsData(c)}t._recycleConnections()}_ensureVisible(e,t="task"){const i=this;if(null==e)return;let n,a="task"===t?i._timelineVCells:i._timelineResourceVCells;n||(n=i.$[`${t}Table`]);const s=a.find((i=>i[t]===e));if(!s)return;let r,o;if("task"===t){const t=i._getTimelineTaskCellByDate(e.dateStart);if(r=i.$.taskTimelineContainer.offsetHeight,o=i,t){const e=i.scrollLeft,n=i.$.taskTimelineContainer.offsetWidth;t.left+t.width>e+n?i.scrollLeft=Math.max(0,t.left+t.width-n):t.left<e&&(i.scrollLeft=Math.max(0,t.left))}}else r=i.$.resourceTimelineContent.offsetHeight,o=i._resourceScrollView;const l=o.scrollTop;s.top+s.height>l+r?o.scrollTop=Math.max(0,s.top+s.height-r):s.top<l&&(o.scrollTop=Math.max(0,s.top))}_isTaskExpanded(e,t){if(!e||!e.$)return;let i,n=e.$[this.groupByResources?"group":"project"];if(!n)return!0;for(;n;){if(i=n.expanded,!i)return!1;if(n=n.$.project,n===t)break}return i}_getItemByTreeIndex(e,t,i){if(!t)return;const n=t.split(".");let a=this[`_${e}s`].filter((e=>!e.$.project))[t.split(".")[0]];if(a){if(!a[`${e}s`]||!a[`${e}s`].length)return i?null:a;for(let t=1;t<n.length;t++){const s=a[`${e}s`].filter((e=>!e.hidden&&e.$.project===a))[n[t]];if(!s||i&&"project"!==s.type)break;if(a=s,"project"!==a.type)break}return i?a&&"project"===a.type?a:void 0:a}}_getItemByTableId(e,t,i){if(null==t)return;const n=this[`_${e}s`];let a;for(let e=0,i=n.length;e<i;e+=1){const i=n[e];if(i.$.id===t){a=i;break}}return a?i?"project"===a.type?a:void 0:a:void 0}_tableChangeHandler(e){const t=e.target;(t.classList.contains("smart-task-table")||t.classList.contains("smart-resource-table"))&&(e.stopPropagation(),this._handleTableSelection(t===this.$.taskTable?"task":"resource",t.selected))}_tableColumnResizeHandler(e){const t=e.target,i=e.detail,n=t.classList.contains("smart-task-table");if(!n&&!t.classList.contains("smart-resource-table"))return;e.stopPropagation();const a=i.dataField,s=this[(n?"task":"resource")+"Columns"].find((e=>e.value===a));s&&(s.size=i.width),this.$.fireEvent("columnResize",i)}_tableSortFilterHandler(e){const t=this,i=e.target;let n;i.classList.contains("smart-task-table")?(n="task",t._createTimelineContent(),t._recycleTimelineTasks()):i.classList.contains("smart-resource-table")&&(n="resource",t._createResourceTimelineContent(),t._recycleResourceContent()),n&&(t._refresh(),e.stopPropagation(),t.$.fireEvent(e.type,Object.assign({type:n},e.detail)))}_taskTableExpandHandler(e){const t=this,i=e.target;if(!i.classList.contains("smart-task-table")&&!i.classList.contains("smart-resource-table"))return;const n=i===t.$.taskTable?"task":"resource";if(e.stopPropagation(),!t[`${n}s`]||!t[`${n}s`].length)return;const a=e.detail.record.itemId,s=t._getItemByTableId(n,a,!0);s&&(delete t._hoveredItem,s.expanded="collapse"!==e.type,t._createTimelineContent(),t._refresh(),t._recycleTimelineTasks(),t.$.fireEvent(e.type,{item:t._cloneObject(s),id:s.id||s.$.id,index:t._tasks.indexOf(s),label:s.label,value:s.value}))}_taskTableKeyDownHandler(e){const t=this,i=e.key;if(t.keyboardNavigation&&!t.disabled&&!t.readonly)switch(i){case"Delete":case"Enter":{const e=t.$.taskTable._focusedCell;if(!e||!e.closest)return;const n=e.closest("tbody tr");if(!n)return;const a=t._getVCellById("task",n.getAttribute("row-id"));a&&t._openPopupWindow(a.task,"Delete"===i);break}}}_getVCellById(e="task",t){const i="task"===e?this._timelineVCells:this._timelineResourceVCells;if(i&&i.length)for(let n=0,a=i.length;n<a;n+=1){const a=i[n][e];if(a.$&&a.$.id===t)return i[n]}}_getGroupVCellByPath(e,t){const i="task"===e?this._timelineVCells:this._timelineResourceVCells;if(i&&i.length)for(let n=0,a=i.length;n<a;n+=1){const a=i[n][e];if(a.$&&a.$.id===t)return i[n]}}_taskTableGroupEventHandler(e){const t=this,i=e.detail.action,n=e.target;if(["collapse","expand"].indexOf(i)<0||!n.classList.contains("smart-task-table")&&!n.classList.contains("smart-resource-table"))return;const a=n===t.$.taskTable?"task":"resource",s=t.$.taskTable._getGroupByIndex(e.detail.path),r=t._getGroupVCellByPath(a,s.$.id);if(!r||!r[a].isGroup)return;const o=r[a];e.stopPropagation(),o.expanded="collapse"!==i,t._createTimelineContent(),t._refresh(),t._recycleTimelineTasks(),t.$.fireEvent(i,{isGroup:!0,item:t._cloneObject(o),id:o.$.id,label:o.label})}_resetTimeline(){const e=this,t=e.$.taskTimelineContainer;if(e.$.taskTimelineCellsContainer.innerHTML="",e.$.timelineTasksContainer.innerHTML="",e.$.timelineConnectionsContainer.innerHTML="",e.$.timelineContent.style.height="",e.$.taskIndicatorsContainer.innerHTML="",e.rightToLeft&&e.scrollLeft!==t.scrollLeft){const i=e._getScrollLeft(e.scrollLeft);t.scrollLeft=i,e.$.mainSplitter.contains(e.$.resourceTimelineHeader)&&(e.$.resourceTimelineContent.scrollLeft=i)}e._closeTooltip(),e.$.container.style.removeProperty("--smart-gantt-chart-task-timeline-content-height")}_refreshTimeline(e){const t=this;e||(e=t.view);const i=t._getDateFromCell(t.scrollLeft,t._getFirstCellObjInView(),e),n=t.scrollTop;t.scrollLeft=0,t.scrollTop=0,t.$.mainSplitter.contains(t.$.resourceTimelineHeader)&&t._resourceScrollView&&(t._resourceScrollView.scrollLeft=0),t._resetTimeline(),t._createTimelineCells(),t._recycleTimelineTasks(!0),t.$.mainSplitter.contains(t.$.resourceSplitter)&&t._refreshResourceTimeline(),t._refresh(),t._scrollTo(i),t.scrollTop=n}_scrollTo(e,t){const i=this,n=i._timelineCells;let a;if(void 0!==e&&!isNaN(new Date(e).getTime()))for(let s=0;s<n.length;s++){const r=n[s],o=r.date;switch(i.view){case"quarter":case"year":if(o.getFullYear()===e.getFullYear()&&o.getMonth()===e.getMonth()){if(t){a=r.left;break}let i=new Date(e);i.setMonth(e.getMonth()+1),i.setDate(0),i=i.getDate(),a=r.left+(e.getDate()-1)/i*r.width}break;case"month":{let i=new Date(o),n=new Date(o);i.setDate(i.getDate()-i.getDay()),n.setDate(n.getDate()+(6-n.getDay())+1),n.setMilliseconds(n.getMilliseconds()-1),e.getTime()>=i.getTime()&&e.getTime()<=n.getTime()&&(a=r.left+(t||t?0:e.getDay()/7*r.width));break}case"week":o.getFullYear()===e.getFullYear()&&o.getMonth()===e.getMonth()&&o.getDate()===e.getDate()&&(a=r.left+parseFloat(e.getHours()+"."+e.getMinutes()+e.getSeconds())/24*r.width);break;case"day":o.getFullYear()===e.getFullYear()&&o.getMonth()===e.getMonth()&&o.getDate()===e.getDate()&&o.getHours()===e.getHours()&&(a=r.left+(t?0:parseFloat(e.getMinutes()+e.getSeconds())/60*r.width))}if(void 0!==a)return i.scrollLeft=a,void(i.$.mainSplitter.contains(i.$.resourceTimelineHeader)&&(i.$.resourceTimelineHeader.scrollLeft=i.$.resourceTimelineContent.scrollLeft=a,i._refreshResourceTimeline()))}}_updateConnection(e,t){const i=this,n=i._tasks,[a,s,r,o]=e,l=n[a],d=n[s];if(!l||!d||"number"!=typeof r)return;let c=i._connections,m=-1;c||(c=i._connections=[]);for(let e=0,t=c.length;e<t;e+=1){const t=c[e],i=t.startIndex,n=t.endIndex;if(i===a&&n===s||i===s&&n===a){m=e;break}}if(!t){if(m<0)c.push({startTask:n[a],endTask:n[s],startIndex:a,endIndex:s,type:r,lag:o});else{const e=c[m];if(!e)return;if(e.startIndex=a,e.startTask=n[a],e.endIndex=s,e.endTask=n[s],e.type=r,o!==e.lag){const t=parseInt(o);isNaN(t)||(e.lag=t)}}return!0}m>-1&&c.splice(m,1)}_createTimelineCells(){const e=this,t=e._tasks,i=new Date(e.properties.dateStart.value),n=new Date(e.properties.dateEnd.value);let a,s;if(isNaN(i.getTime())||(a=i),isNaN(n.getTime())||(s=n),t.length>0){let e=t[0].dateStart,i=t[0].dateEnd;for(let n=0;n<t.length;n++)t[n].dateStart&&t[n].dateEnd&&(e||(e=t[n].dateStart),i||(i=t[n].dateEnd),e.getTime()>t[n].dateStart.getTime()&&(e=t[n].dateStart),i.getTime()<t[n].dateEnd.getTime()&&(i=t[n].dateEnd));(!a||a.getTime()>e.getTime())&&(a=e),(!s||s.getTime()<i.getTime())&&(s=i)}a&&s&&(a=e._minMaxDateValidator(a),s=e._minMaxDateValidator(s),e._createTimelineHeader(a,e._getCellsCount(a,s)),e._createTimelineContent(),e._createDateMarkers(),e._refresh())}_getCellsCount(e,t,i){let n,a,s,r,o,l,d=new Date(e),c=new Date(t);const m=this,u=t.getFullYear()-e.getFullYear();if(a=n=Math.round(u)+1,"year"===i)return{year:a};if(d.setHours(d.getHours(),0,0,0),c.setHours(c.getHours(),0,0,0),l=Math.floor((t.getTime()-e.getTime())/36e5),l>0){let e=new Date(d);if(l=1,d.getFullYear()!==c.getFullYear()){let t=new Date(d.getFullYear()+1,0,1,0,0,0,0);for(;e.getTime()!==t.getTime();){const t=e.getTime();e.setHours(e.getHours()+1),e.getTime()===t&&e.setHours(e.getHours()+2),l++}const i=c.getFullYear()-t.getFullYear();for(let t=0;t<i;t++){const t=e.getFullYear();l+=24*((t%100==0?t%400==0:t%4==0)?366:365)-1,e.setFullYear(t+1)}}for(;e.getTime()<c.getTime();){const t=e.getTime();e.setHours(e.getHours()+1),e.getTime()===t&&e.setHours(e.getHours()+2),l++}}if("hour"===i)return{hour:l};if(d.setHours(0,0,0,0),c.setHours(23,59,59,999),o=n=Math.round((c.getTime()-d.getTime())/864e5),"day"===i)return{day:o};if(d.setDate(d.getDate()-d.getDay()),c.setDate(c.getDate()+6-c.getDay()),r=n=Math.round((c.getTime()-d.getTime())/6048e5),"week"===i)return{week:r};if("month"===this.view&&(0!==e.getDay()&&(e=new Date(e.setDate(e.getDate()-e.getDay()))),6!==t.getDay()&&(t=new Date(t.setDate(t.getDate()+6-t.getDay()))),-1!==m.firstDayOfWeek)){const t=e.getDay()-m.firstDayOfWeek;e.setDate(e.getDate()-e.getDay()+m.firstDayOfWeek-(t>=0?0:7))}if(e.getFullYear()!==t.getFullYear()){n=12-e.getMonth();const i=t.getFullYear();for(let a=e.getFullYear()+1;a<=i;a++)n+=a===t.getFullYear()?t.getMonth()+1:12}else n=t.getMonth()-e.getMonth()+1;return s=Math.ceil(n),"months"===i?{month:s}:("day"===this.view&&0===l&&(l=1),{year:a,month:s,week:r,day:o,hour:l})}_recycleTaskBars(e,t,i){const n=this,a=e.task,s=n.$.timelineTasksContainer,r=n.$.taskTimelineCellsContainer,o="project"===a.type&&a.synchronized,l=a.type,d=a.$.id,c=s.children[t],m=r.children[t];m._cellObj=e,m.setAttribute("row-id",d),m.style.top=e.top+"px",m.removeAttribute("hover"),c.removeAttribute("hover"),c.classList.contains(l)||(c.innerHTML="milestone"===l?'<div class="smart-task-container" aria-hidden="true">\n                    <div class="smart-task-connection-point start"></div>\n                    <div class="smart-task-segments"></div>\n                    <div class="smart-task-connection-point end"></div>\n                </div>':'<div class="smart-task-container" aria-hidden="true">\n                    <div class="smart-task-connection-point start"></div>\n                    <div class="smart-task-segments"></div>\n                    <div class="smart-timeline-task-progress-thumb"></div>\n                    <div class="smart-task-connection-point end"></div>\n                </div>'),a.connectionType&&(a.connectionType.includes("start")||c.querySelector(".start").classList.add("smart-hidden"),a.connectionType.includes("end")||c.querySelector(".end").classList.add("smart-hidden")),n._recycleSegments(a,c),delete c._cellStart,delete c._cellEnd,a.disableDrag||o&&!a.dragProject?c.setAttribute("disable-drag",""):c.removeAttribute("disable-drag"),a.disableResize||o?c.setAttribute("disable-resize",""):c.removeAttribute("disable-resize"),a.isGroup?c.setAttribute("resource-group",""):c.removeAttribute("resource-group"),i&&(i.indexOf(d)>-1?(c.setAttribute("selected",""),m.setAttribute("selected","")):(c.removeAttribute("selected"),m.removeAttribute("selected"))),a.id?c.id=a.id:c.id="ganttTask"+Math.floor(65536*(1+Math.random())).toString(16).substring(1),c._cellObj=e,c.className="smart-timeline-task "+l,c.setAttribute("row-id",d),a.class&&c.classList.add(a.class),c.setAttribute("aria-label",a.label+" Start date: "+n._toISODate(a.dateStart)+", End date: "+n._toISODate(a.dateEnd)),c.setAttribute("aria-selected","false")}_toISODate(e){const t=e.getFullYear(),i=e.getMonth()+1,n=e.getDate();return t+"-"+(i<10?"0"+i:i)+"-"+(n<10?"0"+n:n)}_recycleSegments(e,t){const i=this,n=t.querySelector(".smart-task-segments");let a,s=e.segments;if(!n)return;for(Array.isArray(s)&&s&&s.length&&"task"===e.type||(s=[e]);n.childElementCount>s.length;)n.children[0].remove();const r=document.createDocumentFragment(),o=n.children,l="milestone"===e.type?'<div class="smart-timeline-task-fill"></div>':'<div class="smart-timeline-task-fill">\n                     <div class="smart-timeline-task-progress"></div>\n                </div>\n                <div class="smart-timeline-task-label"></div>';for(let t=0,n=s.length;t<n;t+=1){const n=s[t];let d=o[t];n.dateStart=new Date(Math.max(e.dateStart.getTime(),n.dateStart.getTime())),n.dateEnd=new Date(Math.min(e.dateEnd.getTime(),n.dateEnd.getTime())),d?(delete d._cellStart,delete d._cellEnd):(d=document.createElement("div"),d.classList.add("smart-task-segment"),d.innerHTML=l,r.appendChild(d)),n.disableDrag?d.setAttribute("disable-drag",""):d.removeAttribute("disable-drag"),n.disableResize?d.setAttribute("disable-resize",""):d.removeAttribute("disable-resize"),d._segmentObj=n,d.setAttribute("aria-label",(n.label||"")+" Start date: "+i._toISODate(n.dateStart)+", End date: "+i._toISODate(n.dateEnd)),a=d}r.childElementCount&&n.appendChild(r),i._setTaskBarDeadline(e,a)}_createCells(e){let t,i=document.createDocumentFragment();for(let n=0;n<e;n++)t=document.createElement("div"),t.classList.add("smart-timeline-view-cell"),t.setAttribute("role","columnheader"),i.appendChild(t);return i}_getTimelineVisibleCellsCount(){const e=this,t=e._timelineCells;if(!t)return;const i=e._getFirstCellObjInView();if(!i)return t.length;const n=1-(i.left+i.width-e.scrollLeft)/t[0].width;return Math.min(t.length,Math.ceil(parseFloat((e.$.timeline.offsetWidth/i.width).toFixed(2))+n))}_getHeaderVisibleCellsCount(){const e=this;if(!e._timelineHeaderCells)return;const t=Math.abs(e.scrollLeft),i=e.$.timeline.offsetWidth,n=e._timelineHeaderCells;let a=0;for(let e=0;e<n.length;e++){const s=n[e];s.left+s.width>t&&s.left<i+t&&a++}return a}_getHeaderSubVisibleCellsCount(){const e=this;if(!e._timelineHeaderSubCells)return;const t=Math.abs(e.scrollLeft),i=e.$.timeline.offsetWidth,n=e._timelineHeaderSubCells;let a=0;for(let e=0;e<n.length;e++){const s=n[e];s.left+s.width>t&&s.left<i+t&&a++}return a}_refreshHeaderDate(e){const t=this,i=t._getCellsViewType(),n=t.$.timelineHeader.scrollLeft,a=t.$.timelineViewCells.children,s=t._timelineCells;let r;t._refreshHeaderSubDetailsDate(e),t._refreshHeaderDetailsDate(e);for(let e=0;e<s.length;e++){const t=s[e];if(n<=t.left+t.width){r=e;break}}for(let n=0;n<a.length;n++){const o=a[n],l=s[r];if(!l)break;r++;const d=l.date;o.innerHTML=`<div>${t._getDateString(new Date(d),i)}</div>`,e||(o._date=new Date(d),o.setAttribute("date",d.toLocaleDateString()),o.style.width=l.width+"px",o.style[t.rightToLeft?"right":"left"]=l.left+"px",l.weekend?o.setAttribute("weekend",""):o.removeAttribute("weekend"),l.nonworking?o.setAttribute("nonworking",""):o.removeAttribute("nonworking"))}}_getDateString(e,t,i){const n=this,a=["2-digit","numeric"][n.dayFormat]||"numeric";let s;if("year"===t||"quarter"===t)s=e.toLocaleDateString(n.locale,{year:n.yearFormat});else if("month"===t)s=e.toLocaleDateString(n.locale,{month:n.monthFormat}),"month"===n.view&&(s+=" "+e.toLocaleDateString(n.locale,{year:n.yearFormat}));else if("week"===t)s="numeric"!==n.weekFormat&&i?e.toLocaleDateString(n.locale,{day:a,month:n.monthFormat,year:n.yearFormat}):n._getWeekNumber(e);else if("day"===t)s="month"===n.view?e.toLocaleDateString(n.locale,{day:"numeric"})+" "+e.toLocaleDateString(n.locale,{weekday:n.dayFormat}):e.toLocaleDateString(n.locale,"day"===n.view?{day:a,month:n.monthFormat,year:n.yearFormat}:["long","short","narrow"].indexOf(n.dayFormat)>-1?{weekday:n.dayFormat}:{day:n.dayFormat});else if("hour"===t)if(s="default"===n.hourFormat?e.toLocaleTimeString(n.locale,{hour12:!1}):e.toLocaleDateString(n.locale,{hour:n.hourFormat}),"default"!==n.hourFormat)s.indexOf(",")>=0&&(s=s.substring(s.indexOf(",")+1).trim());else if(s.indexOf(":")!==s.lastIndexOf(":")&&s.indexOf(":")>=0){let e=s.toLowerCase().indexOf("am")>=0?" AM":"";e=s.toLowerCase().indexOf("pm")>=0?" PM":e,s=s.substring(0,s.lastIndexOf(":"))+e}return n.timelineHeaderFormatFunction?n.timelineHeaderFormatFunction(new Date(e),t,i,s):s}_refreshHeaderSubDetailsDate(e){const t=this,i=(t.view,t.scrollLeft),n=t.$.timelineViewSubDetails.children,a=t._timelineHeaderSubCells;let s;if(t.$.timelineViewSubDetails.classList.contains("smart-hidden"))return;for(let e=0;e<a.length;e++){const t=a[e];if(i<=t.left+t.width){s=e;break}}let r=[],o=0;for(let i=0;i<n.length;i++){const l=a[s],d=n[i];if(!l)continue;let c=new Date(l.date);"week"===t.view&&c.setDate(c.getDate()-c.getDay()),s++,c=new Date(Math.max(l.date.getTime(),c.getTime()));const m=e=>{var t=e.getMonth();return"Q"+(t>=9?4:t>=6?3:t>=3?2:1)};let u="";"quarter"===t.view||"year"===t.view?(u=m(c),"quarter"===t.view&&t.hideTimelineSecondHeaderDetails&&(u+=" "+c.getFullYear())):"month"===t.view&&(-1===t.firstDayOfWeek?u=t._getWeekNumber(c):((c.getDay()-t.firstDayOfWeek)%7==0&&i>0&&o++,u=o));const h=u+"_"+c.getFullYear();r[h]||(r[h]=[]),d.classList.remove("smart-visibility-hidden"),r[h].push({element:d,cell:l}),d.innerHTML=`<div>${u}</div>`,d.classList.add("middle"),e||(d._date=c,d.style[t.rightToLeft?"right":"left"]=l.left+"px",d.style.width=l.width+"px")}for(let e in r){const i=r[e];let n=0;for(let e=0;e<i.length;e++)n+=i[e].cell.width;if(i[0].element.style.width=n+"px","year"===t.view){const e=i[0].cell.date.toLocaleDateString(t.locale,{month:t.monthFormat}),n=i[i.length-1].cell.date.toLocaleDateString(t.locale,{month:t.monthFormat});i.length>1?i[0].element.innerHTML=`<div>${e}-${n}</div>`:i[0].element.innerHTML=`<div>${e}</div>`}else if("month"===t.view){const e=i[0].cell.date.toLocaleDateString(t.locale,{day:"numeric"})+" "+i[0].cell.date.toLocaleDateString(t.locale,{weekday:t.dayFormat}),n=i[i.length-1].cell.date.toLocaleDateString(t.locale,{day:"numeric"})+" "+i[i.length-1].cell.date.toLocaleDateString(t.locale,{weekday:t.dayFormat});i.length>1?i[0].element.innerHTML=`<div>${e}-${n}</div>`:i[0].element.innerHTML=`<div>${e}</div>`}if(t.timelineHeaderFormatFunction){const e=t.timelineHeaderFormatFunction(new Date(i[0].cell.date),t.view,!0,i[0].element.innerHTML);i[0].element.innerHTML!==e&&(i[0].element.innerHTML=e)}for(let e=1;e<i.length;e++)i[e].element.classList.add("smart-visibility-hidden")}}_refreshHeaderDetailsDate(e){const t=this,i=t.view,n=t.scrollLeft,a=t.$.timelineViewDetails.children,s=t._timelineHeaderCells;let r;for(let e=0;e<s.length;e++){const t=s[e];if(n<=t.left+t.width){r=e;break}}for(let n=0;n<a.length;n++){const o=s[r],l=a[n];let d=new Date(o.date);"week"===t.view&&d.setDate(d.getDate()-d.getDay()),r++,d=new Date(Math.max(o.date.getTime(),d.getTime())),l.innerHTML=`<div>${t._getDateString(d,i,!0)}</div>`,e||(l._date=d,l.style[t.rightToLeft?"right":"left"]=o.left+"px",l.style.width=o.width+"px")}}_getWeekNumber(e){let t,i=new Date(e.getFullYear(),0,1),n=Math.round((e.getTime()-i.getTime()-6e4*(e.getTimezoneOffset()-i.getTimezoneOffset()))/864e5)+1,a=i.getDay();return a=a>=0?a:a+7,a<4?(t=Math.floor((n+a-1)/7)+1,t>52&&(i=new Date(e.getFullYear()+1,0,1),a=i.getDay(),a=a>=0?a:a+7,t=a<4?1:53)):t="week"===this.view?function(e){var t=new Date(e.valueOf()),i=(e.getDay()+6)%7;t.setDate(t.getDate()-i+3);var n=t.valueOf();return t.setMonth(0,1),4!==t.getDay()&&t.setMonth(0,1+(4-t.getDay()+7)%7),1+Math.ceil((n-t)/6048e5)}(e):Math.round((n+a-1)/7),t}_convertDuration(e,t){if(!e)return 0;let i;switch(this.durationUnit){case"day":i=864e5;break;case"hour":i=36e5;break;case"minute":i=6e4;break;case"second":i=1e3;break;case"milisecond":return e;case"week":i=6048e5}return Math.max(0,t?e/i:e*i)}_createTimelineHeader(e,t){const i=this,n=i._getCellsViewType();if(!e){const t=i.$.timelineViewCells.children;if(0===t.length)return;e=t[0]._date}if("day"!==i.view&&e.setHours(0,0,0,0),-1!==i.firstDayOfWeek){const t=e.getDay()-i.firstDayOfWeek;e.setDate(e.getDate()-e.getDay()+i.firstDayOfWeek-(t>=0?0:7))}if(i.$.timelineContent.offsetWidth===i.$.timeline.offsetWidth&&i._timelineCells&&i._timelineCells[0]&&i._timelineCells[0].date.getTime()===e.getTime()&&i._timelineCells.length===t[i._getCellsViewType()])return void i._refresh();i.$.timelineContent.style.width=i.$.timelineHeaderContent.style.width="",i._createTimelineCellsObj(e,t),i._createTimelineHeaderCellsObj(e,t),i._createTimelineHeaderSubCellsObj(e,t),i.$.timelineViewDetails.innerHTML="",i.$.timelineViewDetails.appendChild(i._createCells(i._getHeaderVisibleCellsCount())),i.$.timelineViewSubDetails.innerHTML="",i.$.timelineViewCells.classList.remove("smart-hidden"),i.$.timelineViewSubDetails.classList.add("smart-hidden");let a=2;if("quarter"===i.view?(a=3,i.$.timelineViewSubDetails.classList.remove("smart-hidden"),i.$.timelineViewSubDetails.appendChild(i._createCells(i._getTimelineVisibleCellsCount()))):"month"===i.view&&"day"===i.monthScale?(a=3,i.$.timelineViewSubDetails.classList.remove("smart-hidden"),i.$.timelineViewSubDetails.appendChild(i._createCells(t.day))):"year"===i.view&&(a=3,i.$.timelineViewSubDetails.classList.remove("smart-hidden"),i.$.timelineViewSubDetails.appendChild(i._createCells(t.month))),i.hideTimelineHeader&&(i.$.timelineViewCells.classList.add("smart-hidden"),a--),i.hideTimelineHeaderDetails&&(i.$.timelineViewDetails.classList.add("smart-hidden"),a--),i.hideTimelineSecondHeaderDetails&&("quarter"===i.view?i.$.timelineViewDetails.classList.add("smart-hidden"):i.$.timelineViewSubDetails.classList.add("smart-hidden"),("year"===i.view||"month"===i.view&&"day"===i.monthScale||"quarter"===i.view)&&a--),i.$.taskTable.style.setProperty("--smart-table-column-header-height","calc("+a+" * var(--smart-gantt-chart-task-default-height) - calc("+a+" * var(--smart-border-width) / "+a+"))"),i.$.timelineViewCells.innerHTML="",i.$.timelineViewCells.appendChild(i._createCells(i._getTimelineVisibleCellsCount())),i.$.timelineContent.style.width=i.$.timelineHeaderContent.style.width=Math.max(t[n]*i._timelineCells[0].width,i.$.timeline.parentElement.offsetWidth)+"px",i.scrollLeft){const e=i._getScrollLeft(i.scrollLeft);i.$.timelineHeader.scrollLeft=e,i.$.mainSplitter.contains(i.$.resourceTimelineHeader)&&(i.$.resourceTimelineHeader.scrollLeft=e)}i._refreshHeaderDate(),i._setCurrentTimeIndicators()}_createTimelineContent(){const e=this,t=e.$.container,i=e.$.timelineContent,n=e._taskDefaultHeight,a=e.$.taskTimelineContainer,s=e.scrollLeft;if(i.style.height="",t.style.removeProperty("--smart-gantt-chart-task-timeline-content-height"),e._createTimelineVCells(n),i.style.height=e._timelineVCells.length*n+"px",t.style.setProperty("--smart-gantt-chart-task-timeline-content-height",e.$.timeline.offsetHeight+"px"),s||s!==a.scrollLeft){const t=e._getScrollLeft(e.scrollLeft);a.scrollLeft=t,e.$.mainSplitter.contains(e.$.resourceTimelineHeader)&&(e.$.resourceTimelineContent.scrollLeft=t)}e.scrollTop&&(a.scrollTop=e.scrollTop),e._recycleContentCells()}_createDateMarkers(){const e=this,t=e.dateMarkers;let i=[];delete e._markers;for(let n=0,a=t.length;n<a;n+=1){const a=t[n],s=e._dateValidator(void 0,a.date);if(s){const e={date:s},t=a.label,n=a.className;("string"==typeof t||"number"==typeof t&&!isNaN(t))&&(e.label=t),"string"==typeof n&&(e.className=n),i.push(e)}}i.length&&(e._markers=i),e._recycleDateMarkers()}_createTimelineRowCells(e,t){const i=this,n=e.children,a=e.querySelectorAll(".smart-task-bar-limiter"),s=document.createDocumentFragment(),[r,o]=i.rightToLeft?["right","left"]:["left","right"];t||(t=i.$.timelineViewCells.children);for(let e=0,t=a.length;e<t;e+=1)a[e].remove();const l=t.length;for(;e.childElementCount>l;)e.lastElementChild.remove();for(let t=e.childElementCount;t<l;t+=1){const e=document.createElement("div");e.classList.add("smart-timeline-cell"),s.appendChild(e)}s.childElementCount&&e.appendChild(s);for(let e=0;e<l;e+=1){const i=t[e],a=n[e];i.hasAttribute("weekend")?a.setAttribute("weekend",""):a.removeAttribute("weekend"),i.hasAttribute("nonworking")?a.setAttribute("nonworking",""):a.removeAttribute("nonworking"),a.style[o]=i.style[o],a.style[r]=i.style[r],a.style.width=i.style.width}for(let t=0,i=a.length;t<i;t+=1)e.appendChild(a[t])}_recycleTimelineRowCells(){const e=this,t=e.$.timelineViewCells.children,i=e.$.taskTimelineCellsContainer.children;for(let n=0,a=i.length;n<a;n+=1)e._createTimelineRowCells(i[n],t)}_createTimelineVCells(e){const t=this,i=t._tasks,n=t.$.taskTable.rows,a=t.groupByResources;let s=0,r={};t._timelineVCells=[];for(let o=0,l=n.length;o<l;o++){const l=n[o].data;let d=i[l.itemIndex];if(a)if(!d&&l.groupDataField){const e=l.$.id;d={$:{id:e,project:void 0},label:t._formatResourceGroupLabel(l.label),value:l.label,expanded:l.expanded,synchronized:!0,isGroup:!0,type:"project"},r[e]=d}else l.parent?(d.$.group=r[l.parent.$.id],t._synchronizeProjectDates(d.$.group,[d])):delete d.$.group;else delete d.$.group;!d.hidden&&t._isTaskExpanded(d)&&(t._timelineVCells.push({top:s,height:e,task:d}),s=parseFloat((s+e).toFixed(2)))}}_getCellsViewType(){const e=this;switch(e.view){case"quarter":case"year":return"month";case"month":return"day"===e.monthScale?"day":"week";case"week":return"day";case"day":return"hour"}}_createTimelineCellsObj(e,t){const i=this,n=i._getCellsViewType();t=t[n];const a=i.$.timeline.parentElement.offsetWidth;let s=Math.max(i._timelineCellSize,i._timelineCellMinSize),r=0,o=new Date(e);t*s<a&&(s=a/t),s=parseFloat(s.toFixed(2)),i._timelineCells=[];for(let e=0;e<t;e++){const e={left:r,width:s};if("year"===n||"quarter"===n)o.setMonth(0),e.date=new Date(o),o.setFullYear(o.getFullYear()+1);else if("month"===n)o.setDate(1),e.date=new Date(o),o.setMonth(o.getMonth()+1);else if("week"===n)o.setHours(0,0,0,0),o.setDate(o.getDate()-o.getDay()),e.date=new Date(o),o.setDate(o.getDate()+7);else if("day"===n)i.nonworkingDays.indexOf(o.getDay())>-1&&(e.nonworking=!0),o.setHours(0,0,0,0),e.date=new Date(o),o.setDate(o.getDate()+1),e.weekend=0===e.date.getDay()||6===e.date.getDay();else if("hour"===n){(i.nonworkingHours.indexOf(o.getHours())>-1||i.nonworkingDays.indexOf(o.getDay())>-1)&&(e.nonworking=!0),o.setHours(o.getHours(),0,0,0),e.date=new Date(o);const t=o.getTime();o.setHours(o.getHours()+1),t===o.getTime()&&o.setHours(o.getHours()+2),e.weekend=0===e.date.getDay()||6===e.date.getDay()}i._timelineCells.push(e),r=parseFloat((r+s).toFixed(2))}}_createTimelineHeaderSubCellsObj(e,t){const i=this,n=i._getCellsViewType();t="month"===i.view&&"day"===i.monthScale?t.day:t[n];const a=i.$.timeline.parentElement.offsetWidth;let s=Math.max(i._timelineCellSize,i._timelineCellMinSize),r=0,o=new Date(e);t*s<a&&(s=a/t),s=parseFloat(s.toFixed(2)),i._timelineHeaderSubCells=[];for(let e=0;e<t;e++){const e={left:r,width:s};if("year"===n||"quarter"===n)o.setMonth(0),e.date=new Date(o),o.setFullYear(o.getFullYear()+1);else if("month"===n)o.setDate(1),e.date=new Date(o),o.setMonth(o.getMonth()+1);else if("week"===n)o.setHours(0,0,0,0),o.setDate(o.getDate()-o.getDay()),e.date=new Date(o),o.setDate(o.getDate()+7);else if("day"===n)i.nonworkingDays.indexOf(o.getDay())>-1&&(e.nonworking=!0),o.setHours(0,0,0,0),e.date=new Date(o),o.setDate(o.getDate()+1),e.weekend=0===e.date.getDay()||6===e.date.getDay();else if("hour"===n){(i.nonworkingHours.indexOf(o.getHours())>-1||i.nonworkingDays.indexOf(o.getDay())>-1)&&(e.nonworking=!0),o.setHours(o.getHours(),0,0,0),e.date=new Date(o);const t=o.getTime();o.setHours(o.getHours()+1),t===o.getTime()&&o.setHours(o.getHours()+2),e.weekend=0===e.date.getDay()||6===e.date.getDay()}i._timelineHeaderSubCells.push(e),r=parseFloat((r+s).toFixed(2))}}_createTimelineHeaderCellsObj(e,t){const i=this;let n=i.view,a=0,s=new Date(e);"quarter"===n&&(n="year"),t=t[n],i._timelineHeaderCells=[];for(let e=0;e<t;e++){const t={};switch(t.date=new Date(s),n){case"quarter":case"year":s.setFullYear(s.getFullYear()+1);break;case"month":s.setDate(1),s.setMonth(s.getMonth()+1);break;case"week":s.setDate(s.getDate()+7);break;case"day":s.setDate(s.getDate()+1)}a=i._refreshViewDetailCell(t,a,e),i._timelineHeaderCells.push(t)}}_minMaxDateValidator(e){if(!e||isNaN(e.getTime()))return e;const t=new Date(this.min),i=new Date(this.max);return t&&(e=new Date(Math.max(t.getTime(),e.getTime()))),i&&(e=new Date(Math.min(i.getTime(),e.getTime()))),e}_dateValidator(e,t){const i=this;let n;if(t instanceof Date)return i._minMaxDateValidator(t);if(Smart.Utilities.DateTime&&t instanceof Smart.Utilities.DateTime)return i._minMaxDateValidator(t.toDate());if("string"!=typeof t)return i._minMaxDateValidator(e);{const e=/\d+:\d+:\d+/;if("new Date()"===t.trim()||"new Smart.Utilities.DateTime()"===t.trim())return i._minMaxDateValidator(new Date);if(isNaN(Date.parse(t))){const i=/(\d+[,-.\/]{1}\s*\d+[,-.\/]{1}\s*\d+)/;if(i.test(t)){const a=i.exec(t)[0].replace(/[,-.\/]/g,",").split(",");if(3===a.length){const[i,s]=parseInt(a[0])<parseInt(a[2])?[a[0],a[2]]:[a[2],a[0]];if(n=new Date(parseInt(s),parseInt(a[1])-1,parseInt(i)),e.test(t)){const i=e.exec(t)[0].split(":");n.setHours(i[0]||0,i[1]||0,i[2]||0)}t=n}}}else n=new Date(Date.parse(t)),e.test(t)||n.setHours(0,0,0,0),t=n}return i._minMaxDateValidator(new Date(t))}_currentTimeIndicatorIntervalValidator(e,t){return Math.max(1,t)}_getTaskBarPositionLimits(e,t){const i=this;function n(e){const t=i._getTimelineTaskCellByDate(e);if(t)return t.left+i._getTimelineTaskOffset(t,e)||0}return{min:n(e["min"+t]),max:n(e["max"+t])}}_getTimelineTaskOffset(e,t){if(!e)return;let i,n;switch(this.view){case"quarter":case"year":{const a=t.getHours()/24+t.getMinutes()/1440+t.getSeconds()/86400;i=new Date(e.date.getFullYear(),e.date.getMonth()+1,0),n=(t.getDate()-1+a)/i.getDate()*e.width;break}case"month":n=t.getDay()/7*e.width;break;case"week":n=parseFloat(t.getHours()+t.getMinutes()/60+t.getSeconds()/3600)/24*e.width;break;case"day":n=parseFloat(t.getMinutes()+t.getSeconds()/60)/60*e.width}return n}_getTaskBarSizeLimits(e,t){const i=this,n=i._getTaskBarDateRange(e);let a,s=0,r=i._convertDuration(e._cellObj.task.minDuration)||i._getMinDuration(e,t),o=i._convertDuration(e._cellObj.task.maxDuration);function l(a,s){if(!a)return;let r,o;"left"===t&&!i.rightToLeft||"right"===t&&i.rightToLeft?(a*=-1,o=n.dateEnd):o=n.dateStart,s&&Math.abs(r)===Math.abs(a)&&(r=0);let l=i._getTaskWorkingDateEnd({dateStart:o},a);const d=l.getTime()+60*(l.getTimezoneOffset()-o.getTimezoneOffset())*1e3,c=i._getTimelineTaskCellByDate(new Date(d));if(!c)return;const m=i._getTimelineTaskOffset(c,new Date(d));return i.rightToLeft?"left"===t?m-(i.$.timelineContent.offsetWidth-e.offsetLeft-e.offsetWidth-c.left):i.$.timelineContent.offsetWidth-e.offsetLeft-c.left-m:"left"===t?e.offsetLeft+e.offsetWidth-c.left-m:c.left-e.offsetLeft+m}if("left"===t&&!i.rightToLeft||"right"===t&&i.rightToLeft){const t=e._cellObj.task.maxDateStart,i=e._cellObj.task.minDateStart;i&&(s=60*(i.getTimezoneOffset()-n.dateEnd.getTimezoneOffset())*1e3,a=Math.abs(i.getTime()-n.dateEnd.getTime())+s,o=o?Math.min(a,o):a),t&&(s=60*(t.getTimezoneOffset()-n.dateEnd.getTimezoneOffset())*1e3,a=Math.abs(t.getTime()-n.dateEnd.getTime())+s,r=r?Math.max(a,r):a)}else{const t=e._cellObj.task.maxDateEnd,i=e._cellObj.task.minDateEnd;i&&(s=60*(i.getTimezoneOffset()-n.dateStart.getTimezoneOffset())*1e3,a=Math.abs(i.getTime()-n.dateStart.getTime())+s,r=r?Math.max(a,r):a),t&&(s=60*(t.getTimezoneOffset()-n.dateStart.getTimezoneOffset())*1e3,a=Math.abs(t.getTime()-n.dateStart.getTime())+s,o=o?Math.min(a,o):a)}return o&&(r=Math.min(r,o)),{min:l(r,!0),max:l(o)}}_getMinDuration(e,t){const i=this,n=i._taskBarMinWidth;if(!n||!i._timelineCells||0===i._timelineCells.length)return;const a=e._cellObj.task;let s,r,o=1;r=i.rightToLeft?parseFloat(e.style.right)||i.$.timelineContent.offsetWidth-e.offsetLeft-e.offsetWidth:parseFloat(e.style.left)||e.offsetLeft,"left"===t?(s=a.dateEnd,r+=parseFloat(e.style.width)||e.offsetWidth,o=-1):s=a.dateStart;const l=r+o*n;let d;for(let e=0;e<i._timelineCells.length;e++){const t=i._timelineCells[e];if(l<t.left)break;d=t}const c=i._getDateFromCell(l,d);return c?Math.abs(s.getTime()-c.getTime()):void 0}_createDelimiter(e,t){const i=this,n=i._dragDetails,a=n.segment,s=e.slice(0,3),r=document.createElement("div");if(r.classList.add("smart-task-bar-limiter",e),e.indexOf("date")>-1){if(!n[s]||!n[s].left)return;const[e,t]=a?[a.element,a.originalPosition.x]:[n.timelineTask,0],o=i.$.taskTimelineCellsContainer.children[i._getTaskDOMIndex(n.task)];s.indexOf("max")>-1?r.style.width=o.offsetWidth-n[s].left-t-e.offsetWidth+"px":r.style.width=n[s].left+t+"px"}else{if(!n[s].width)return;r.style["left"===t?"right":"left"]=n[s].width+"px"}return r}_doubleClickHandler(e){const t=this;let i=e.target;if(t.disabled||t.disableWindowEditor)return;t.shadowRoot&&i===t&&(i=e.composedPath()[0]);let n=i.closest?i.closest(".smart-task-connection"):void 0;if(n)t._openPopupWindow(n);else if(n=i.closest(".smart-timeline-task")||i.closest(".smart-table tbody tr[row-id]"),n&&t.$.taskSplitter.contains(n))if(n.classList.contains("smart-timeline-task"))t._openPopupWindow(n._cellObj.task);else{const e=t._getVCellById("task",n.getAttribute("row-id"));e&&t._openPopupWindow(e.task)}}_checkDoubleClick(e){const t=this;let i=e.target;if(t.shadowRoot&&i===t&&(i=e.composedPath()[0]),void 0===t._dblClickDetails&&(t._dblClickDetails={clicks:0}),clearTimeout(t._dblClickDetails.timeOut),i!==t._dblClickDetails.target&&(t._dblClickDetails.clicks=0),t._dblClickDetails.target=i,t._dblClickDetails.clicks++,t._dblClickDetails.timeOut=setTimeout((function(){t._dblClickDetails&&(t._dblClickDetails.clicks=0)}),250),2===t._dblClickDetails.clicks)return t._doubleClickHandler(e),t._dblClickDetails.clicks=0,!0}_downHandler(e){const t=this,i=e.originalEvent,n=t.shadowRoot||t.isInShadowDOM?i.composedPath()[0]:i.target,a=n.closest?n.closest(".smart-timeline-row")||n.closest(".smart-timeline-task"):null;if(e.stopPropagation(),delete t._itemClickDetails,t._dragDetails)return delete t._dragDetails,void t._setConnectionFeedback();const s=t.$.taskSplitter.contains(n)?"task":"resource";if((n.closest(".smart-timeline-content")||n.closest(`.smart-${s}-table`))&&requestAnimationFrame((()=>t.$[`${s}Table`].focus({preventScroll:!0}))),t._itemClickDetails={target:n},!t._isMobile&&0!==e.button)return;if(!a){if(n.classList.contains("smart-popup-window-modal")){if(t._popupWindow){const e=Object.keys(t._popupWindow);requestAnimationFrame((()=>t._popupWindow[e[e.length-1]].focus()))}return}return void((n.closest(".smart-table tbody tr[row-id]")&&!n.classList.contains("smart-arrow")||n.closest(".smart-task-connection"))&&t._checkDoubleClick(i))}if(n.closest(".smart-resource-timeline-view-cell")||t.disabled)return;const r=Array.from(t.$.timelineTasksContainer.children).find((e=>e._cellObj.task===a._cellObj.task));if(!r)return;const o=r._cellObj.task;if(!o)return;const l=t.$.timeline.getAttribute("task-bar-hovered");if(r.getElementsByClassName("smart-timeline-task-fill")[0]||l){if((n.closest(".smart-timeline-task-fill")||r.classList.contains("milestone")&&n.closest(".smart-task-container"))&&t._checkDoubleClick(i))return;const a=n.closest(".smart-timeline-task-progress-thumb"),s=e.pageX-window.pageXOffset,d=e.pageY-window.pageYOffset,c=t._dragDetails={},m=t.rightToLeft;let u,h=n.closest(".smart-task-segment");if(l&&!h){const e=r.querySelectorAll(".smart-task-segment");c.segments=e,h="left"===l&&!m||"right"===l&&m?e[0]:e[e.length-1]}if(c.target=(a||n).className,c.timelineTask=r,c.task=r._cellObj.task,c.taskDimensions={width:r.offsetWidth,height:r.offsetHeight,left:r.offsetLeft,top:r.offsetTop},c.coordinates={x:s,y:d},!e.ctrlKey&&h&&o.segments&&o.segments.length>1&&!t.disableSegmentDrag){const e=h.getBoundingClientRect(),t=h._segmentObj,i=c.task.segments,n=i.indexOf(t);c.segment={element:h,dimensions:{width:e.width,left:h.offsetLeft},offset:{x:s-e.left},originalSize:{width:e.width},isFirstSegment:0===n,isLastSegment:n===i.length-1,min:{},max:{}},u=c.segment.dimensions}const g=c.taskDimensions;t.rightToLeft?(g.right=t.$.timelineContent.offsetWidth-(g.left+g.width),c.originalPosition={x:g.right,y:g.top},c.segment&&(u.right=g.width-(u.left+u.width),c.segment.originalPosition={x:u.right})):(c.originalPosition={x:g.left,y:g.top},c.segment&&(c.segment.originalPosition={x:u.left}));const f=(a||r).getBoundingClientRect();if(c.offset={x:s-f.left,y:d-f.top},c.originalSize={width:g.width,height:g.height},a||!a&&"project"===o.type&&o.synchronized&&!o.dragProject)return void(n.closest(".smart-task-connection-point")&&(c.timelineTask=void 0,c.relatedConnections={}));("visible"===t.resizeHandlesVisibility||t._isMobile&&"auto"===t.resizeHandlesVisibility)&&(n.closest(".smart-timeline-task-fill")?t._checkTaskBarResizability(e):t.$.timeline.removeAttribute("task-bar-hovered")),c.min={},c.max={},t._setDragLimits(n)}}_documentMoveHandler(e){const t=this;if(!t._dragDetails||!t._dragDetails.target){let i=e.originalEvent.target;t.shadowRoot&&i===t&&(i=e.originalEvent.composedPath()[0]);const n=i.closest&&i.closest(".smart-table tbody tr[row-id]");return n&&n.data?t._handleTableItemHover(n.data.itemId,i):t._handleTimelineHover(e),t._checkTaskBarResizability(e),void t._toggleTooltip(e.originalEvent)}if(t._dragDetails.target.includes("smart-task-connection-point"))return t._setConnectionFeedback(e),t._handleTimelineHover(e),void t._autoScroll(e);if(t._dragDetails.target.includes("smart-timeline-task-progress-thumb"))t._handleTaskProgressChange(e);else if(t._autoScroll(e),!t._autoScrolling)if(t.$.timeline.hasAttribute("task-bar-hovered"))t._handleTaskBarResize(e);else if(t._dragDetails.target.includes("smart-timeline-task-fill")){const i=t._dragDetails.task;if(!i||i.disableDrag||"project"===i.type&&i.synchronized&&!i.dragProject)return;t._handleTaskBarDrag(e)}}_documentUpHandler(e){const t=this,i=e.originalEvent;let n=i.target;if(t._upHandler(),!t._dragDetails)return void t._handleItemClick(i);if(t._scrollView.disableSwipeScroll=t._touchmoveInside=!1,t.shadowRoot&&n===t&&(n=i.composedPath()[0]),t.hasAttribute("connecting-task")){const i=t._connectTask(e),n=t._tasks;if(t._setConnectionFeedback(),i){const e=i.taskStart,a=i.taskEnd,[s,r,o]=[n.indexOf(i.taskStart),n.indexOf(i.taskEnd),i.type];t.$.fireEvent("connectionEnd",{id:`${s}-${r}-${o}`,startIndex:s,startTaskId:"string"==typeof e.id||"number"==typeof e.id?e.id:e.$.id,endIndex:r,endTaskId:"string"==typeof a.id||"number"==typeof a.id?a.id:a.$.id,type:o}),t._autoSchedule(i.taskStart)}return t._isMobile&&t._handleTimelineHover(e,!0),void delete t._dragDetails}const a=t._dragDetails.task;if(!a)return void delete t._dragDetails;let s;const r=t._dragDetails.segment?t._dragDetails.segment.element:void 0;if(s||(s=Array.from(t.$.timelineTasksContainer.children).find((e=>e._cellObj.task===a))),t.hasAttribute("dragged")){t._snapToNearest(s,r),r||t._checkWorkingDays(s,r),t._refreshProject(a.$.project),t.groupByResources&&t._refreshProject(a.$.group),t._autoSchedule(a),t._resourceTreeRefreshTimeout?(clearTimeout(t._resourceTreeRefreshTimeout),delete t._resourceTreeRefreshTimeout,t._refreshAssignedResources(a)):(t.snapToNearest||t.nonworkingDays.length>0||t.nonworkingHours.length>0)&&t._refreshAssignedResources(a),t.removeAttribute("dragged");const e={id:"string"==typeof a.id||"number"==typeof a.id?a.id:a.$.id,item:t._cloneObject(a),dateStart:new Date(a.dateStart),dateEnd:new Date(a.dateEnd)};r&&(e.segment=t._cloneObject(r._segmentObj)),t.$.fireEvent("dragEnd",e)}else if(t.hasAttribute("progress-change"))t._resourceTreeRefreshTimeout&&(clearTimeout(t._resourceTreeRefreshTimeout),delete t._resourceTreeRefreshTimeout,t._refreshAssignedResources(a,["progress"])),t.removeAttribute("progress-change"),t.$.fireEvent("progressChangeEnd",{id:"string"==typeof a.id||"number"==typeof a.id?a.id:a.$.id,item:t._cloneObject(a),progress:a.progress||0});else if(t.hasAttribute("resized")){t._snapToNearest(s,r),t._refreshProject(a.$.project),t.groupByResources&&t._refreshProject(a.$.group),t._resourceTreeRefreshTimeout?(clearTimeout(t._resourceTreeRefreshTimeout),delete t._resourceTreeRefreshTimeout,t._refreshAssignedResources(a,["workload"])):t.snapToNearest&&t._refreshAssignedResources(a,["workload"]),t.removeAttribute("resized");const e={id:"string"==typeof a.id||"number"==typeof a.id?a.id:a.$.id,item:t._cloneObject(a),dateStart:a.dateStart,dateEnd:a.dateEnd};r&&(e.segment=t._cloneObject(r._segmentObj)),t.$.fireEvent("resizeEnd",e),t._autoSchedule(a)}else n.closest(".smart-timeline-task")===s&&(t._select("task",a.$.id,!0),delete t._dragDetails,t._handleItemClick(i));const o=t.$.timelineContent.querySelectorAll(".smart-task-bar-limiter");for(let e=0,t=o.length;e<t;e+=1)o[e].remove();delete t._dragDetails}_handleItemClick(e){const t=this,i=e.target;if(t._dragDetails||!t._itemClickDetails||t._itemClickDetails.target!==i)return void delete t._itemClickDetails;let n,a,s;if(i.closest(".smart-timeline-task-fill"))a=i.closest(".smart-timeline-task")._cellObj.task,s="task";else if(n=i.closest(".smart-task-connection"),n)a=n.getAttribute("connection-id").split("-"),a={source:a[0],target:a[1],type:a[2]},s="connection";else if(i.closest(".milestone"))a=i.closest(".milestone")._cellObj.task,s="milestone";else if(n=i.closest(".smart-table tbody tr"),n){const e=t._getVCellById(s,n.getAttribute("row-id"));s=t.$.taskTable.contains(n)?"task":"resource",a=e?e[s]:void 0}if(!a)return;const r={originalEvent:e,type:s,item:t._cloneObject(a)};r.id="connection"===s?`${a.source}-${a.target}-${a.type}`:"string"==typeof a.id||"number"==typeof a.id?a.id:a.$.id,delete t._itemClickDetails,t.$.fireEvent("itemClick",r)}_moveHandler(e){const t=this;t._isMobile||e.stopPropagation(),(t.hasAttribute("dragged")||t.hasAttribute("progress-change"))&&"touchmove"===e.originalEvent.type&&e.originalEvent.preventDefault()}_handleTableItemHover(e,t){const i=this,n=i._hoveredItem;let a,s;if(t&&([a,s]=i.$.taskSplitter.contains(t)?[i.$.taskTable,"task"]:[i.$.resourceTable,"resource"]),n&&"itemType"===n.type&&n.id===e)return;const r=i.$.mainSplitter.querySelectorAll("table tbody tr[hover]");for(let e=0;e<r.length;e++)r[e].removeAttribute("hover");if(void 0===e)return void i._handleTimelineHover({target:i});if(!a)return;i._setTableHoverState(a,e);const o=i.$["task"===s?"taskTimelineCellsContainer":"resourceTimelineCellsContainer"].children;for(let t=0,n=o.length;t<n;t+=1){const n=o[t];if(n._cellObj[s].$.id===e){i._handleTimelineHover({target:n});break}}}_setTableHoverState(e,t){const i=this;e||(e=i.$.taskTable);const n=e===i.$.taskTable?"task":"resource",a=e.querySelectorAll("table tbody tr");if(!i._isMobile&&i[n+"Columns"].length)for(let e=0;e<a.length;e++){let i=a[e];const n=i.data;n&&n.itemId===t&&i.setAttribute("hover","")}}_checkWorkingDays(e){const t=this,i=t._dragDetails;if(!(i&&i._taskDuration||t._timelineCells.length))return;if(!e.classList||!e.classList.contains("smart-timeline-task")||!t.hasAttribute("dragged")||0===t.nonworkingDays.length&&0===t.nonworkingHours.length||!i||!i._taskDuration)return;const n=e._cellObj,a=n.task,s=t._getTaskWorkingDateEnd(a),r=a.segments;let o=new Date(t._timelineCells[t._timelineCells.length-1].date);if("year"===t.view||"quarter"===t.view?(o.setMonth(o.getMonth()+1),o.setDate(0),o.setHours(23,59,59,999)):"month"===t.view?(o.setDate(o.getDate()+6-o.getDay()),o.setHours(23,59,59,999)):"week"===t.view?o.setHours(23,59,59,999):o.setHours(o.getHours(),59,59,999),s&&(a.dateEnd=a.maxDateEnd?new Date(Math.min(s.getTime(),a.maxDateEnd.getTime())):s),a.dateEnd=new Date(Math.min(o.getTime(),a.dateEnd.getTime())),a.duration=t._convertDuration(t.nonworkingDays.length>0||t.nonworkingHours.length>0?t._getWorkingTime(a.dateStart,a.dateEnd):a.dateEnd.getTime()-a.dateStart.getTime(),!0),r&&r.length>1){for(let e=0,i=r.length;e<i;e+=1)t._snapToNearestDates(r[e],!0);t._validateTaskSegments(a),a.segments.length!==r.length&&t._recycleSegments(a,e),t._setTaskBarSegments(n,e,!0),t._setTaskBarProgress(a)}t._setTimelineTaskBar(n,void 0,!0),t._refreshTaskConnections(n.task),t._refreshTableColumnsData(a,["dateEnd","duration","overdue"])}_getTaskWorkingDateEnd(e,t){const i=this;if(!e||!e.dateStart)return;let n,a,s=new Date(e.dateStart);if(t||(t=i._dragDetails?i._dragDetails._taskDuration:i._getWorkingTime(e.dateStart,e.dateEnd)),!i.adjustToNonworkingTime)return new Date(e.dateStart.getTime()+t);const r=t<0?-1:1,o=i.nonworkingDays,l=i.nonworkingHours;for(t=Math.abs(t);t>0;){const e=Math.min(t,36e5-(60*s.getMinutes()*1e3+1e3*s.getSeconds()+s.getMilliseconds()));if(o.indexOf(s.getDay())>-1)a=new Date(s),a.setHours(0,0,0,0),a.setDate(s.getDate()+1*r),n=Math.min(e,a.getTime()-s.getTime()),s=new Date(s.getTime()+n);else if(l.indexOf(s.getHours())>-1){a=new Date(s);const t=a.getTime();a.setHours(s.getHours()+1*r,0,0,0),t===a.getTime()&&a.setHours(s.getHours()+2*r,0,0,0),n=Math.min(e,a.getTime()-s.getTime()),s=new Date(s.getTime()+n)}else t-=e,s=new Date(s.getTime()+r*e)}return s}_createConnectingElement(e,t,i,n,a){const s=this;if(!s._connectionDetails||!s._connectionDetails.start)return;const r=s._connectionDetails,o=r.type,l=s.$.timelineConnectionsContainer;let d=r.connections.shift();d||(d=document.createElement("div"),d.classList.add("smart-task-connection")),d.style.width=d.style.width="","horizontal"===n?(d.style.width=Math.abs(i)+"px",d.style.height=""):(d.style.width="",d.style.height=Math.abs(i)+"px"),d.style[s.rightToLeft?"left":"right"]="",d.style[s.rightToLeft?"right":"left"]=e+"px",d.style.top=t+"px",d.setAttribute("connection-id",r.id);const c=r.start.task.label,m=0===o||3===o?"start":"end",u=r.end.task.label,h=0===o||1===o?"start":"end";if(d.setAttribute("aria-label","Connection between "+c+" ("+m+") and "+u+" ("+h+")"),a){let e=0===o||1===o?"right":"left";s.rightToLeft&&(e="left"===e?"right":"left"),d.setAttribute("arrow-direction",e)}else d.removeAttribute("arrow-direction");d.parentElement||l.appendChild(d)}_getConnectionType(e,t){if(!e||!t)return;let i,n;return"string"==typeof e?i=!e.includes("end"):e instanceof HTMLElement&&(i=!e.classList.contains("end")),"string"==typeof t?n=t.includes("end"):t instanceof HTMLElement&&(n=t.classList.contains("end")),i&&!n?0:i||n?!i&&n?2:i&&n?3:void 0:1}_setConnectionFeedback(e){const t=this,i=t._dragDetails;if(!i||!i.target||!e){const e=t._connectionFeedback;return e&&e.parentElement&&e.remove(),t.removeAttribute("connecting-task"),void delete t._connectionFeedback}if(!i.target||!i.target.includes("smart-task-connection-point"))return;const n=i.task,a=i.taskDimensions;if(!n)return;if(!t.hasAttribute("connecting-task")){if(t.$.fireEvent("connectionStart",{startIndex:t._tasks.indexOf(n)}).defaultPrevented)return void delete t._dragDetails.target;t.setAttribute("connecting-task",""),t._isMobile&&(t._scrollView.disableSwipeScroll=t._touchmoveInside=!0)}const s="milestone"===n.type,r=t.rightToLeft;let o=s?-1*a.height/2:0;t._dragDetails.target.includes("end")&&(o=s?-1*o:a.width),t._connectionFeedback||(t._connectionFeedback=document.createElement("div"),t._connectionFeedback.classList.add("smart-task-connection-feedback"));const l=t._dragDetails.coordinates.x+(r?-1:1)*o,d=t._dragDetails.coordinates.y,c=t._dragDetails.offset.x-(r?a.width:0),m=t._dragDetails.offset.y,u=e.pageX-window.pageXOffset+c,h=e.pageY-window.pageYOffset+m-a.height/2;r?(t._connectionFeedback.style.left="",t._connectionFeedback.style.right=a.right+o+"px"):(t._connectionFeedback.style.left=a.left+o+"px",t._connectionFeedback.style.right=""),t._connectionFeedback.style.top=a.top+a.height/2+"px",t._connectionFeedback.style.width=Math.sqrt(Math.pow(Math.abs(u-l),2)+Math.pow(Math.abs(h-d),2))+"px",t._connectionFeedback.style.transform=t.rightToLeft?"rotate("+180*(Math.atan2(d-h,l-u)||0)/Math.PI+"deg)":"rotate("+180*(Math.atan2(h-d,u-l)||0)/Math.PI+"deg)",t._connectionFeedback.parentElement||t.$.timelineContent.appendChild(t._connectionFeedback)}_connectTask(e){const t=this,i=t._tasks;let n,a,s,r,o,l,d,c,m;if(e.originalEvent){const r=e.originalEvent;let o=t._isMobile?document.elementFromPoint(r.pageX-window.pageXOffset,r.pageY-window.pageYOffset):r.target;if(!(t._dragDetails&&t._dragDetails.target&&o&&o.classList))return;if(t.shadowRoot&&o===t&&(o=t._isMobile?t.shadowRoot.elementFromPoint(r.pageX-window.pageXOffset,r.pageY-window.pageYOffset):r.composedPath()[0]),n=t._dragDetails.target.includes("smart-task-connection-point")?t._dragDetails.target:void 0,a=o.classList.contains("smart-task-connection-point")?o:void 0,n&&(l=t._dragDetails.task),a)s=a.closest(".smart-timeline-task");else if(t._isMobile&&o.classList.contains("smart-timeline-task-fill")&&(s=o.closest(".smart-timeline-task"),s)){const e=r.pageX-window.pageXOffset-s.getBoundingClientRect().left;a=s.querySelector(".smart-task-connection-point."+(e>=s.offsetWidth/2?"end":"start"))}if(!l||!s)return;d=s._cellObj.task;for(let e=0,t=i.length;e<t;e+=1){const t=i[e];if(t!==l)if(t!==d){if(void 0!==c&&void 0!==m)break}else m=e;else c=e}}else{if(!e||e.length<3)return;const n=t._getValidConnectionId(e[0],e[1],e[2],"_connectTask");if(void 0===n)return;[c,m]=[parseInt(n[0]),parseInt(n[1])],[l,d]=[i[c],i[m]],r=parseInt(e[2]),o=e[4]||0}if(!l||!d||l===d||l.isGroup||d.isGroup||t._isAutoScheduled(l,d)||t.hasAttribute("dragged")||t.hasAttribute("resized"))return;void 0===r&&(r=t._getConnectionType(n,a));let u=t._connections;return u||(t._connections=u=[]),t._updateConnection([c,m,r,o])?(e.originalEvent&&t._recycleConnections([{startIndex:c,endIndex:m,type:r}]),e.originalEvent&&t.$.fireEvent("itemInsert",{type:"connection",item:{source:c,target:m,type:r}}),{taskStart:l,taskEnd:d,type:r}):void 0}_recycleConnections(e){const t=this,i=t._tasks;if(e?Array.isArray(e)||(e=[e]):e=t._connections,!i||!i.length||!e)return;const n=t.$.timelineTasksContainer.children,a=t.$.timelineConnectionsContainer;let s,r=[];if(n.length){const a=n[0],o=(()=>{let e=[];for(let t=0,a=n.length;t<a;t+=1)e.push(i.indexOf(n[t]._cellObj.task));return e})(),l=a.querySelector(".smart-task-connection-point."+(t.rightToLeft?"end":"start")),d=t._baselineProportion,c=t.showBaseline?t._taskDefaultHeight/d:0;s={top:l.offsetTop,width:l.offsetWidth},s.offset=Math.abs(l.offsetLeft)-s.width;for(let n=0,a=e.length;n<a;n+=1){const a=e[n],l=a.startIndex,d=a.endIndex;if(o.indexOf(l)<0&&o.indexOf(d)<0)continue;const m=i[l],u=i[d],{vCellStart:h,vCellEnd:g}=t._getTasksVCell(m,u);if(!h||!g)continue;const f=a.type,p={start:{width:s.width,top:s.top,index:l,task:m},end:{width:s.width,top:s.top,index:d,task:u},type:f},_=t._getTaskBarDetails(h,t._getTimelineCellByDate(m.dateStart),t._getTimelineCellByDate(m.dateEnd)),T=t._getTaskBarDetails(g,t._getTimelineCellByDate(u.dateStart),t._getTimelineCellByDate(u.dateEnd));"milestone"===m.type&&(_.width=h.height-c),"milestone"===u.type&&(T.width=h.height-c),p.start.left=0===f||3===f?-1*(s.width+s.offset):_.width+s.offset,p.end.left=0===f||1===f?-1*(s.width+s.offset):T.width+s.offset,t._connectionDetails=p,_.height=T.height=h.height-c,_.type=m.type,T.type=u.type,t._setConnectionDetails(_,T),t._createTaskConnection(),r.push(t._connectionDetails.id),delete t._connectionDetails}}if(arguments.length)return;const o=Array.from(a.children);for(let e=0,t=o.length;e<t;e+=1){const t=o[e];r.indexOf(t.getAttribute("connection-id"))<0&&t.remove()}}_getTasksVCell(e,t){const i=this._timelineVCells;let n,a;for(let s=0,r=i.length;s<r;s+=1){const r=i[s];if(r.task===e&&(n=r),r.task===t&&(a=r),n&&a)break}return{vCellStart:n,vCellEnd:a}}_isAutoScheduled(e,t,i){const n=this,a=n._tasks;let s={};if(n.autoSchedule)return e instanceof HTMLElement&&(e=e._cellObj.task),t instanceof HTMLElement&&(t=t._cellObj.task),function e(t,r){const o=n._getTaskConnections().taskConnections,l=a.indexOf(t);s[l]=!0;for(let t=0;t<o.length;t++){const d=o[t],c=d.endIndex;if(c===r)return i&&n._removeConnection(l+"-"+c+"-"+d.type,!0),!0;if(!s[c]&&e(a[c],r))return!0}}(t,a.indexOf(e))}_setConnectionDetails(e,t){const i=this;if(!i._connectionDetails)return;const n=i._connectionDetails,a=n.start,s=n.end,r=n.type;if(!a||!s)return;let o,l=e.width,d=t.width,c=e.left,m=t.left,u=e.top,h=t.top,g=a.left,f=s.left;const p=a.index,_=s.index;if("milestone"===e.type&&(l=e.height,c-=l/2),"milestone"===t.type&&(d=t.height,m-=d/2),n.id=p+"-"+_+"-"+r,!n.connectionStartOffset||!n.connectionEndOffset){switch(r){case 0:g=Math.abs(g)-a.width,f=Math.abs(f)-s.width;break;case 1:g-=l,f=Math.abs(f)-s.width;break;case 2:g-=l,f-=d;break;default:g=Math.abs(g)-a.width,f-=d}n.start.offset=g+=a.width/2,n.end.offset=f+=s.width/2}if(0===r&&c>m||1===r&&c+l+g>m-f&&h>u||2===r&&m+d>c+l||3===r&&(c-g<m+d+f&&h>u||c-g>m+d+f&&u>h)){o=!0;let i=e;e=t,t=i,i=g,g=f,f=i,i=l,l=d,d=i,i=c,c=m,m=i,i=u,u=h,h=i}let T=c,b=m;!o&&1===r||o&&3===r?T+=l:!o&&3===r||o&&1===r?b+=d:2===r&&(T+=l,b+=d);let k=i.$.timelineConnectionsContainer.querySelectorAll('.smart-task-connection[connection-id^="'+p+"-"+_+'-"]');0===k.length&&(k=i.$.timelineConnectionsContainer.querySelectorAll('.smart-task-connection[connection-id^="'+_+"-"+p+'"]')),n.connections=[].slice.call(k),n.start.x=T,n.start.y=u+a.top,n.end.x=b,n.end.y=h+s.top,n.type=r,n.inverted=o}_createTaskConnection(){const e=this,t=e._connectionDetails;if(!t)return;const i=2*e._taskConnectionWidth,n=t.start.x,a=t.start.y,s=t.start.offset,r=t.start.top,o=t.end.x,l=t.end.y,d=t.end.offset,c=t.type,m=t.inverted,u=!m&&3===c||m&&1===c,h=!m&&1===c||m&&3===c;let g,f,p,_=n,T=o;u?(_=n-d,T=o+d):h&&(_=n+s,T=o-d);const b=_<=T&&u,k=_>=T&&h,y=2===c||h;!function d(u){g!==o&&(u?"horizontal"===u?(p=g-o+(b?-1:1)*s,g=_>T?g-Math.abs(p):g,e._createConnectingElement(g,f,(_===T?0:Math.abs(p))+(y?i:0),"horizontal"),g=_<T?g-p:g,d("vertical")):(p=Math.abs(f-l),f+=a<l?0:-1*p,g-=m&&1===c||!m&&3===c&&a>l?i:0,e._createConnectingElement(g,f,p,"vertical"),d()):(g?(p=Math.abs(g-o),g>=o&&(g+=-1*p,p+=i),e._createConnectingElement(g,f+(a<l?Math.abs(f-l):0),p,"horizontal",!t.inverted),g=o):(g=n,f=a,(0===c||!m&&3===c||m&&1===c)&&(g-=s),e._createConnectingElement(g,f,s,"horizontal",t.inverted),y&&(g+=s-i),b||k?(e._createConnectingElement(g,f-=a>l?r:0,r,"vertical"),f+=a<l?r:0):d("vertical")),d("horizontal")))}(),t.connections.map((e=>e.parentElement.removeChild(e)))}_getTaskIndexById(e,t){const i=this;if(t||(t=i._tasks),"number"==typeof e)return isNaN(parseInt(e))?-1:parseInt(e);if("object"==typeof e)return i._getItemIndex(e,"task");for(let i=0,n=t.length;i<n;i+=1)if(t[i].id===e)return i;return-1}_refreshTaskConnections(e){const t=this,i=e instanceof HTMLElement?e._cellObj.task:e,n=t._tasks.indexOf(i);if(void 0===n||e.classList&&e.classList.contains("smart-visibility-hidden"))return;let a;if(t._dragDetails&&(a=t._dragDetails.relatedConnections[n]),!a){a=[];const e=t._connections;if(!e||!e.length)return;for(let t=0,i=e.length;t<i;t+=1){const i=e[t];i.startIndex!==n&&i.endIndex!==n||a.push(i)}t._dragDetails&&(t._dragDetails.relatedConnections[n]=a)}t._recycleConnections(a)}_dragStartHandler(e){const t=this,i=e.target.closest;(t._dragDetails||i&&i.call(t,"smart-gantt-chart")===t)&&e.preventDefault()}_getFirstCellObjInView(e){const t=this;if(e||(e=t._timelineCells),!e)return;const i=Math.abs(t.scrollLeft);let n,a;for(let t=0;t<e.length;t++){const s=e[t];if(s.left+s.width>i){n=s;break}a=s}return!n&&a&&(n=i>a.left?a:e[0]),n}_getFirstContentCellInView(e="task"){const t=this;let i,n,a,s;if("task"===e?(i=t._timelineVCells,n=t.scrollTop):(i=t._timelineResourceVCells,n=t.$.resourceVerticalScrollBar.value),!i)return 0;for(let e=0;e<i.length;e++){const t=i[e];if(t.top+t.height>n){a=t;break}s=t}return!a&&s&&(a=n>s.left?s:i[0]),a}_getProjectTasks(e,t){const i=this,n=i.groupByResources&&e.isGroup?"group":"project",a=i._tasks;if(!e||"project"!==e.type)return[];let s=[];for(let r=0,o=a.length;r<o;r+=1){const o=a[r];o.$[n]===e&&(s.push(o),"project"!==o.type||t||(s=s.concat(i._getProjectTasks(o,t))))}return s}_getSubTaskLimits(e){const t=this;if(!e)return;const i=e._cellObj.task,n=t._getProjectTasks(i);let a,s;if(!n.length)return;let r=n[0],o=n[0];for(let e=0;e<n.length;e++){const t=n[e];n[e].dateEnd&&n[e].dateStart&&(r.dateStart||(r=t[e]),o.dateEnd||(o=t[e]),n[e].dateEnd.getTime()>o.dateEnd.getTime()&&(o=n[e]),n[e].dateStart.getTime()<r.dateStart.getTime()&&(r=n[e]))}const l=t.$.timelineContent.offsetWidth;let d,c,m;if(r&&(d=t._getTimelineSubTaskOffset(r),d&&(c=d.left,m=d.width,a=Math.max(0,t.rightToLeft?l-e.offsetLeft-e.offsetWidth-(l-c-m):e.offsetLeft-c))),o&&(d=t._getTimelineSubTaskOffset(o),d))if(c=d.left,m=d.width,t.rightToLeft){const t=l-e.offsetLeft-e.offsetWidth;s=Math.max(t,t+l-(l-c))}else s=Math.max(e.offsetLeft,e.offsetLeft+l-(c+m));return{min:a,max:s}}_getTimelineSubTaskOffset(e){const t=this,i=t.$.timelineTasksContainer.children[t._tasks.filter((e=>!e.hidden)).indexOf(e)];let n,a,s;if(i)n=i.offsetLeft,s=i.offsetWidth;else{const i=t._getTimelineTaskCellByDate(e.dateStart),r=t._getTimelineTaskCellByDate(e.dateEnd);i&&(n=i.left+t._getTimelineTaskOffset(i,e.dateStart)||0),r&&(a=r.left+t._getTimelineTaskOffset(r,e.dateEnd)||0),s=a-n}return{left:n,width:s}}_getTaskDragLimits(e){const t=this,i=t._dragDetails,n=i.segment?i.segment.element:void 0,a=n&&n.previousElementSibling?{}:t._getTaskBarPositionLimits(e._cellObj.task,"DateStart"),s=n&&n.nextElementSibling?{}:t._getTaskBarPositionLimits(e._cellObj.task,"DateEnd"),r=t._dragDetails.taskDimensions;let o={};return(a.min||s.min)&&(o.min=Math.max(a.min||0,Math.max(0,(s.min||0)-r.width))),s.max&&(o.max=Math.max(0,s.max-r.width)),a.max&&(o.max=o.max?Math.min(a.max,o.max):a.max),o}_getTaskBarDateRange(e){if(!e)return;const t=this,i=e.classList.contains("milestone"),n=parseFloat(e.style.width)||e.offsetWidth,a=i?n/2:n,s=t.rightToLeft?parseFloat(e.style.right)||t.$.timelineContent.offsetWidth-e.offsetLeft-a:parseFloat(e.style.left)||e.offsetLeft,r=e._cellStart,o=e._cellEnd,l=e._cellObj.task,d=l.minDateStart,c=l.maxDateEnd;let m,u;return m=t._getDateFromCell(s,r),!d||"project"===e._cellObj.task.type&&e._cellObj.task.synchronized||(m=new Date(Math.max(d.getTime(),m.getTime()))),u=i?new Date(m):t._getDateFromCell(s+a,o),!c||"project"===e._cellObj.task.type&&e._cellObj.task.synchronized||(u=new Date(Math.min(c.getTime(),u.getTime()))),{dateStart:m,dateEnd:u}}_getTaskBarDetails(e,t,i){const n=this,a=e.task;if(!e)return;let s=new Date(a.dateStart);const r=new Date(a.dateEnd);if(!n._dragDetails&&n.snapToNearest){let s,r,o=a.dateStart,l=a.dateEnd;const d=new Date(t.date),c=n._getDateFromCell(t.left+t.width,t),m=new Date(i.date),u=n._getDateFromCell(i.left+i.width,i);return s=c.getTime()-o.getTime()>=c.getTime()-d.getTime()?t.left:t.left+t.width,"milestone"!==a.type&&(r=u.getTime()-l.getTime()>=l.getTime()-m.getTime()?i.left-s:i.left-s+i.width),{left:s,width:r,top:e.top}}let o,l,d,c,m,u;switch(n.view){case"quarter":case"year":{d=new Date(s.getFullYear(),s.getMonth()+1,0).getDate(),c=new Date(r.getFullYear(),r.getMonth()+1,0).getDate();const e=s.getHours()/24+s.getMinutes()/1440+s.getSeconds()/86400,n=r.getHours()/24+r.getMinutes()/1440+r.getSeconds()/86400;o=t.left+(s.getDate()-1+e)/d*t.width,l=i.left+(r.getDate()-1+n)/c*i.width-o;break}case"month":m=parseFloat(s.getHours()+"."+s.getMinutes()+s.getSeconds())/24*(t.width/7),u=parseFloat(r.getHours()+"."+r.getMinutes()+r.getSeconds())/24*(t.width/7),o=t.left+s.getDay()/7*t.width+m,l=i.left+r.getDay()/7*i.width-o+u;break;case"week":m=parseFloat(s.getHours()+"."+s.getMinutes()+s.getSeconds())/24*t.width,u=parseFloat(r.getHours()+"."+r.getMinutes()+r.getSeconds())/24*t.width,o=t.left+m,l=i.left+(u-m)-t.left;break;case"day":m=parseFloat(s.getMinutes()+s.getSeconds()/60)/60*t.width,u=parseFloat(r.getMinutes()+r.getSeconds()/60)/60*t.width,o=t.left+m,l=i.left+(u-m)-t.left}return{width:"milestone"===a.type?"":l,left:o,top:e.top}}_snapToNearestDates(e,t){const i=this;if(!i.snapToNearest)return;if(e.classList&&e._cellObj&&(e=e._cellObj.task),!e)return;let n=e.dateStart,a=e.dateEnd;const{cellStart:s,cellEnd:r}={cellStart:i._getTimelineCellByDate(n),cellEnd:i._getTimelineCellByDate(a)},o=new Date(s.date),l=i._getDateFromCell(s.left+s.width,s),d=new Date(r.date),c=i._getDateFromCell(r.left+r.width,r);if(n=l.getTime()-n.getTime()>=l.getTime()-o.getTime()?o:l,"milestone"!==e.type&&(a=c.getTime()-a.getTime()>=c.getTime()-d.getTime()?d:c),e.dateEnd=a,a.getTime()<n.getTime()&&(n=new Date(a)),e.dateStart=n,e.duration=e.duration=i._convertDuration(i.nonworkingDays.length>0||i.nonworkingHours.length>0?i._getWorkingTime(e.dateStart,e.dateEnd):e.dateEnd.getTime()-e.dateStart.getTime(),!0),!t&&e.segments&&e.segments.length>1){const t=e.segments;for(let e=0,n=t.length;e<n;e+=1)i._snapToNearestDates(t[e],!0);i._validateTaskSegments(e)}}_getTimelineTaskCellByDate(e){if(!e)return;const t=this,i=t.view,n=t._timelineCells;for(let a=0;a<n.length;a++){const s=n[a];if(t._isDateInCell(s.date,e,i))return s}}_isDateInCell(e,t,i){switch(i){case"quarter":case"year":if(e.getYear()===t.getYear()&&e.getMonth()===t.getMonth())return!0;break;case"month":{let i=new Date(e);if(i.setDate(i.getDate()+(6-i.getDay())+1),i.setMilliseconds(i.getMilliseconds()-1),t.getTime()>=e.getTime()&&t.getTime()<=i.getTime())return!0;break}case"week":if(e.getYear()===t.getYear()&&e.getMonth()===t.getMonth()&&e.getDate()===t.getDate())return!0;break;case"day":if(e.getYear()===t.getYear()&&e.getMonth()===t.getMonth()&&e.getDate()===t.getDate()&&e.getHours()===t.getHours())return!0}}_handleInverted(e){const t=this;function i(e){e||(e="task");const i=t.$[`${e}Splitter`];if(!t.$.mainSplitter.contains(i))return;const[n,a,s,r,o]="task"===e?[t.$.tableSplitterItem,t.$.timelineSplitterItem,t,t.$.taskTimelineContainer,"scrollTop"]:[t.$.resourceTableItem,t.$.resourceTimelineSplitterItem,t.$.resourceVerticalScrollBar,t.$.resourceTimelineContent,"value"],l=t.treeSize!==n.size?n.style[i._measurements.dimension]:t.treeSize;n.size="",i.removeChild(a),t.inverted&&!t.rightToLeft||!t.inverted&&t.rightToLeft?i.insertBefore(a,n):i.appendChild(a),n.size=l,r.scrollTop=s[o]}(!e||t.inverted||t.rightToLeft)&&(i("task"),i("resource"))}_createResourceTimeline(){const e=this;if(e._handleResourcePanelVisibility(),e.$.taskSplitterItem._setSize("size",e.taskPanelSize),!e._resources||!e.$.mainSplitter.contains(e.$.resourceTable))return;const t=e.$.resourceSplitterItemHeader.innerHTML;(e.resourcePanelHeaderTemplate&&!t||!e.resourcePanelHeaderTemplate&&t)&&e._handleHeaderTemplate("resource"),e._setTable(e.$.resourceTable),e._recycleResourceHeaderCells(),e._createResourceTimelineContent(),e._synchronizeSplitters(e.$.taskSplitter,e.$.resourceSplitter),e.$.resourceTimelineContent.scrollLeft=e.$.resourceTimelineHeader.scrollLeft=e.$.timelineHeader.scrollLeft,e.$.resourceSplitter.refresh(),e._refresh(),e._highlightAssignedItem("task",e._getSelection("task",e.selectedTaskIds))}_createResourceTimelineContent(){const e=this,t=e._timelineVCells,i=t.length?t[0].height:e._taskDefaultHeight;e._createResourceTimelineVCells(i);const n=e._timelineResourceVCells.length*i;e.$.resourceTimelineCellsContainer.style.height=n+"px",e.$.container.style.setProperty("--smart-gantt-chart-resource-timeline-content-height",n+"px"),e._recycleResourceContent()}_recycleResourceContent(){const e=this;if(!e.$.mainSplitter.contains(e.$.resourceSplitterItem))return;const t=e._timelineResourceVCells,i=e.$.resourceTimelineCellsContainer,n=e._getFirstContentCellInView("resource"),a=e.$.tooltip;if(a&&i.contains(a.selector)&&e._closeTooltip(),!n)return void(i.innerHTML="");const s=t.indexOf(n),r=n.height,o=1-(n.top+r-Math.abs(e.$.resourceVerticalScrollBar.value))/r,l=t?t.length:0,d=!e.$.resourceSplitter.offsetHeight,c=e.$.resourceTimelineContent.offsetHeight,m=!d&&c?Math.min(l,Math.ceil((parseFloat((c/r).toFixed(2))+o).toFixed(2))):l,u=i.children,h=e.$.timelineViewCells.children,g=document.createDocumentFragment();for(;i.childElementCount>m;)i.lastElementChild.remove();for(let t=0;t<m;t+=1){let i=u[t];i||(i=document.createElement("div"),i.classList.add("smart-timeline-row"),g.appendChild(i)),e._createTimelineRowCells(i,h)}g.childElementCount&&i.appendChild(g);const f=i.children,p=e._getSelection("resource",e.selectedResourceIds);for(let i=0;i<m;i+=1){const n=t[s+i],a=f[i];if(!n){a&&a.remove();continue}const r=n.resource,o=r.$.id;p.indexOf(o)>-1?a.setAttribute("selected",""):a.removeAttribute("selected"),a._cellObj=n,a.setAttribute("row-id",o),a.style.top=n.top+"px",e._refreshResourceTimelineContent(r,a)}}_createResourceTimelineVCells(e){const t=this,i=t._resources,n=t.$.resourceTable.rows,a=t._timelineResourceVCells=[];let s=0;if(void 0===e){const i=t._timelineVCells;e=i.length?i[0].height:t._taskDefaultHeight}for(let t=0,r=n.length;t<r;t+=1){const r=i[n[t].data.itemIndex];r.hidden||(a.push({top:s,height:e,resource:r}),s=parseFloat((s+e).toFixed(2)))}}_handleResourcePanelVisibility(){const e=this,t=e.$.container,i=e._resources.filter((e=>!e.hidden)),n=e.$.mainSplitter,a=e.$.resourceSplitterItem,s=e.$.taskSplitterItem;if(!i||!i.length||e.hideResourcePanel)return a&&!a.size&&(a._size=a.style[n._measurements.dimension]),e._resourceScrollView&&(e._resourceScrollView.unlisten(),delete e._resourceScrollView),s.size="",s.min="",e.$.resourceTable&&e.$.resourceTable.clearSelection(),n.contains(a)&&(n.removeChild(a),e._refresh()),e._highlightAssignedItem("resource"),void t.removeAttribute("show-resource-panel");n.contains(a)||(s.min=e.taskPanelMin,e._createResourcePanel(),e._setupResourcePanel(),e._resourceScrollView=new Smart.Utilities.Scroll(e.$.resourceSplitterItem,e.$.horizontalScrollBar,e.$.resourceVerticalScrollBar)),t.setAttribute("show-resource-panel",""),e._synchronizeSplitters(e.$.taskSplitter,e.$.resourceSplitter)}_createResourcePanel(){const e=this,t=e.$.mainSplitter;let i=e.$.resourceSplitterItem;if(!i){i=document.createElement("smart-splitter-item"),i.classList.add("smart-resource-splitter-item"),i.innerHTML=`<div smart-id="resourceSplitterItemHeader" class="smart-resource-panel-header"></div>\n                <smart-splitter smart-id="resourceSplitter" wait class="smart-resource-splitter" auto-fit-mode="end">\n                    <smart-splitter-item smart-id="resourceTableItem" class="smart-resource-table-item">\n                        <smart-table wait smart-id="resourceTable" class="smart-resource-table" virtualization deferred-scroll-delay="0"></smart-table>\n                    </smart-splitter-item>\n                    <smart-splitter-item smart-id="resourceTimelineSplitterItem" class="smart-timeline-splitter-item">\n                        <div class="smart-timeline" smart-id="resourceTimeline">\n                            <div class="smart-timeline-container" role="presentation">\n                                <div class="smart-timeline-header" smart-id="resourceTimelineHeader" role="rowgroup">\n                                    <div class="smart-timeline-view-cells" smart-id="resourceTimelineViewCells" role="row"></div>\n                                </div>\n                                <div smart-id="resourceTimelineContent" class="smart-timeline-content" role="rowgroup">\n                                    <div smart-id="resourceTimelineCellsContainer" class="smart-timeline-cells-container" aria-hidden="true"></div>\n                                </div>\n                            </div>\n                        </div>\n                         <smart-scroll-bar wait smart-id="resourceVerticalScrollBar" class="smart-timeline-scroll-bar smart-resource-scroll-bar" \n                            orientation="vertical" aria-controls="[[${e.id||""}]]">\n                         </smart-scroll-bar>\n                    </smart-splitter-item>\n                </smart-splitter>`,t.contains(i)||t.appendChild(i);const n=Smart.Utilities,a=i.querySelectorAll(".smart-resource-panel-header, .smart-resource-splitter, .smart-resource-table-item, \n                .smart-resource-table, .smart-timeline-splitter-item, .smart-timeline, .smart-timeline-header, .smart-timeline-view-cells, .smart-timeline-content,\n                .smart-timeline-cells-container, .smart-timeline-scroll-bar"),[s,r,o,l,d,c,m,u,h,g,f]=a;e.$.resourceSplitterItem=i,e.$resourceSplitterItem=n.Extend(i),e.$.resourceSplitterItemHeader=s,e.$resourceSplitterItemHeader=n.Extend(s),e.$.resourceSplitter=r,r.hasResizeObserver=!1,r.wait=!1,e.$resourceSplitter=n.Extend(r),e.$.resourceTableItem=o,e.$resourceTableItem=n.Extend(o),e.$.resourceTable=l,l.hasResizeObserver=!1,e.$resourceTable=n.Extend(l),e.$.resourceTimelineSplitterItem=d,e.$resourceTimelineSplitterItem=n.Extend(d),e.$.resourceTimelineViewCells=u,e.$resourceTimelineViewCells=n.Extend(u),e.$.resourceTimeline=c,e.$resourceTimeline=n.Extend(c),e.$.resourceTimelineContent=h,e.$resourceTimelineContent=n.Extend(h),e.$.resourceTimelineHeader=m,e.$resourceTimelineHeader=n.Extend(m),e.$.resourceTimelineCellsContainer=g,e.$resourceTimelineCellsContainer=n.Extend(g),e.$.resourceVerticalScrollBar=f,e.$resourceVerticalScrollBar=n.Extend(f)}}_setupResourcePanel(){const e=this,t=e.rightToLeft,i=e.$.resourceSplitterItem,n=e.$.resourceTableItem,a=e.$.resourceTable,s=e.$.resourceTimelineSplitterItem,r=e.$.resourceVerticalScrollBar;e.$.mainSplitter.contains(i)?([e.$.resourceSplitter,a,e.$.resourceVerticalScrollBar].forEach((e=>e.rightToLeft=t)),a.$.virtualizationContainer._scrollView.disableSwipeScroll=!0,a.$.virtualizationContainer.verticalScrollBarVisibility="hidden",a.$.virtualizationContainer.disabled=!0,n.size=e.treeSize,n.min=e.treeMin,s.min=e.timelineMin,i.min=e.resourcePanelMin,i.size=i._size||e.resourcePanelSize,r.hasStyleObserver=!1,r.hasResizeObserver=!1,r.wait=!1):e.$.mainSplitter.appendChild(i)}_refreshResourceTimeline(){const e=this;e._resources&&e.$.mainSplitter.contains(e.$.resourceSplitter)&&(e._recycleResourceHeaderCells(),e._recycleResourceContent())}_getResourceCellWorkTime(e,t){const i=e.dateStart,n=e.dateEnd,a=t.dateStart,s=t.dateEnd,r=e.dateStart.getTime()<a.getTime()?a:i,o=n.getTime()>s.getTime()?s:n,l=Math.round(this._getWorkingTime(r,o)/36e5);return{value:Math.max(0,l),max:r.getTime()===a.getTime()&&o.getTime()===s.getTime()?l:Math.round(this._getWorkingTime(a,s)/36e5)}}_refreshResourceTimelineContent(e,t){const i=this,n=i._resources.indexOf(e),a=i._getResourceTasks(e);if(t||(t=(()=>{const t=i.$.resourceTimelineCellsContainer.children;for(let i=0,n=t.length;i<n;i+=1){const n=t[i];if(n._cellObj&&n._cellObj.resource===e)return n}})()),n<0||!t||!t.childElementCount)return;let s=t.children;const r=i.$.resourceTimelineViewCells.children,o=i._tasks.filter((e=>!e.hidden));for(let t=0,l=s.length;t<l;t+=1){const l=s[t];let d,c=l.firstElementChild;a.length&&!e.hidden?(c?(c.classList.remove("hide-left-border","hide-right-border"),c.removeAttribute("load"),c.innerHTML=c.style.height=""):(c=document.createElement("div"),c.classList.add("smart-resource-timeline-view-cell"),d=!0),e.class&&c.classList.add(e.class),i._setResourceCellLoad({cell:c,cellIndex:t,resource:e,resourceCell:l,resourceIndex:n,resourceTasks:a,tasks:o,viewCells:r}),c.hasAttribute("load")?d&&l.appendChild(c):c.remove()):c&&c.remove()}}_setResourceCellLoad(e){const t=this,i=t.resourceTimelineFormatFunction,{cell:n,cellIndex:a,resource:s,resourceCell:r,resourceIndex:o,resourceTasks:l,tasks:d,viewCells:c}=e;let m={};for(let e=0,u=l.length;e<u;e+=1){const u=l[e];if(u.hidden)continue;const h=d.indexOf(u),g=t._getCellDateRange(c[a]),{dateStart:f,dateEnd:p}=g;if(!f||f.getTime()>=u.dateEnd.getTime()||p.getTime()<=u.dateStart.getTime())continue;if(m[a]&&m[a].indexOf(h)<0?m[a].push(h):m[n]||(m[a]=[h]),"custom"===t.resourceTimelineMode){i&&(n.innerHTML=i.call(t,m[a]||[],o,new Date(f))||"");continue}const _=t._getResourceCellCapacity({cell:n,cellDateRange:g,cellTaskIndexAssigned:m,index:o,resource:s,task:u,cellIndex:a});if(!_)continue;const{capacity:T,maxCapacity:b}=_,k=parseFloat(((parseFloat(n.getAttribute("load"))||0)+(T||0)).toFixed(1));k>b?n.classList.add("warning"):n.classList.remove("warning"),"histogram"!==t.resourceTimelineMode?k&&n.setAttribute("load",k):t._setCellHistogram({cell:n,load:k,maxCapacity:b,previousViewCell:r.previousElementSibling})}}_getResourceCellCapacity(e){const t=this,i=t.resourceTimelineView,{cell:n,cellDateRange:a,cellTaskIndexAssigned:s,index:r,resource:o,task:l,cellIndex:d}=e;let c,m;if("tasks"===i)c=1,m=o.maxCapacity;else if("hours"===i){const e=t._getResourceCellWorkTime(l,a),i=e.max/24;c=parseFloat((e.value/e.max*o.capacity*i).toFixed(1)),m=Math.min(e.max,parseFloat((o.maxCapacity*i).toFixed(1)))}else{const e=t.resourceTimelineFormatFunction;if(!e)return;let i=e.call(t,s[d]||[],r,new Date(a.dateStart));if(null!=i)if(i="object"!=typeof i?[i]:Object.values(i),2===i.length)c=parseFloat(i[0])||0,m=parseFloat(i[1])||0;else if(1===i.length)return void(n&&n.setAttribute("load",i[0]))}return{capacity:c,maxCapacity:m}}_setCellHistogram(e){const{load:t,cell:i,maxCapacity:n,previousViewCell:a}=e,s=Math.min(100,100*parseFloat((t/n).toFixed(2))),r=a?a.firstElementChild:void 0;if(r){const e=parseFloat(r.style.height)||0;s?e===s?(i.classList.add("hide-left-border"),r.classList.add("hide-right-border")):e>s?(i.classList.add("hide-left-border"),r.classList.remove("hide-right-border")):e<s&&(i.classList.remove("hide-left-border"),r.classList.add("hide-right-border")):(i.classList.remove("hide-left-border"),r.classList.remove("hide-right-border"))}i.style.height=s+"%",t&&i.setAttribute("load",t+"/"+n)}_recycleResourceHeaderCells(){const e=this;if(!e.$.mainSplitter.contains(e.$.resourceSplitterItem))return;const t=e.$.resourceTimelineViewCells,i=t.children,n=e.$.timelineViewCells.children;let a=document.createDocumentFragment();for(;i.length>n.length;)i[0].remove();for(let e=0;e<n.length;e++){const t=n[e];let s=i[e];s||(s=t.cloneNode(!0),a.appendChild(s)),s.style.left=t.style.left,s.style.right=t.style.right,s.style.width=t.style.width,s.innerHTML=t.innerHTML,s._date=t._date,t.hasAttribute("weekend")?s.setAttribute("weekend",""):s.removeAttribute("weekend"),t.hasAttribute("nonworking")?s.setAttribute("nonworking",""):s.removeAttribute("nonworking")}a.childElementCount&&t.appendChild(a),e.$.resourceTimelineCellsContainer.style.width=e.$.resourceTimelineViewCells.style.width=e.$.timelineContent.style.width}_refreshResourceScrollBar(){const e=this,t=e.$.resourceVerticalScrollBar;if(!e.$.mainSplitter.contains(e.$.resourceSplitter))return;const i=Math.max(0,e.$.resourceTimelineCellsContainer.offsetHeight-e.$.resourceTimelineContent.offsetHeight);0===i&&"visible"===e.verticalScrollBarVisibility?(t.max=1,e.scrollHeight||e.$container.removeClass("vscroll")):i&&e.$container.addClass("vscroll"),t.max=i,t.disabled="disabled"===e.verticalScrollBarVisibility||e.disabled||i<=0,!e.$.container.classList.contains("vscroll")&&t.disabled?t.classList.add("smart-hidden"):(t.classList.remove("smart-hidden"),t.refresh(),e.$.container.classList.contains("hscroll")?e.$.horizontalScrollBar.classList.add("bottom-corner"):e.$.container.classList.contains("vscroll")||e.$.horizontalScrollBar.classList.remove("bottom-corner"))}_handleResources(e){const t=this,i=e?[e]:t._tasks;t._resources||(t._resources=[]);for(let e=0;e<i.length;e++){let n=i[e].resources;Array.isArray(n)||(n=[n].reduce(((e,t)=>e.concat(t)),[]));for(let a=0;a<n.length;a++){let s=n[a];if("object"!=typeof s||!s||void 0===s.id||null===s.id){"number"==typeof s&&(n[a]=s+"");continue}let r=t._resources.find((e=>e.id&&e.id.toString()===s.id.toString()))||{};t._setResource(r,s,i[e]),n[a]=r.id,Object.values(r).length&&!t._resources.includes(r)&&t._resources.push(r)}}t._refreshItemIds("resource");const n=t._resources;for(let e=0,i=n.length;e<i;e+=1)t._refreshResource(n[e])}_refreshAssignedResources(e,t=[]){const i=this;if(!e.$.id||i._tasks.indexOf(e)<0)return;const n=i._getTaskResources(e);for(let e=0;e<n.length;e++){const a=n[e];let s=[];i.resourceColumns.forEach((e=>{void 0!==e.formatFunction&&s.push(e.value)})),s.concat(t),i.$.mainSplitter.contains(i.$.resourceSplitter)&&i._refreshResourceTimelineContent(a),t.includes("workload")?i._refreshResource(a,"workload"):t.includes("progress")&&i._refreshResource(a,"progress"),s.length&&i._refreshTableColumnsData(a,s,"resource")}}_refreshResource(e,t){const i=this;if(!i._resources.length)return;const n=i._getResourceTasks(e),a=864e5;switch(t){case"progress":e.progress=parseFloat((n.reduce(((e,t)=>e+t.progress),0)/n.length).toFixed(2));break;case"workload":e.workload=parseFloat((i._convertDuration(n.reduce(((e,t)=>e+t.duration),0))/a*e.maxCapacity).toFixed(2));break;default:e.progress=parseFloat((n.reduce(((e,t)=>e+t.progress),0)/n.length).toFixed(2)),e.workload=parseFloat((i._convertDuration(n.reduce(((e,t)=>e+t.duration),0))/a*e.maxCapacity).toFixed(2))}i.$.mainSplitter.contains(i.$.resourceSplitter)&&i._refreshResourceTimelineContent(e)}_setResource(e,t){if(t&&"object"==typeof t)return e.id?e.id=e.id.trim():e.id=(t.id+"").trim(),e.$||(e.$={}),e.class=t.class||e.class,e.minCapacity=t.minCapacity||e.minCapacity||0,e.maxCapacity=t.maxCapacity||e.maxCapacity||24,e.progress=t.progress||e.progress||0,e.capacity=t.capacity||e.capacity||8,e.type=t.type||e.type,e.hidden=!!("boolean"==typeof t.hidden?t.hidden:e.hidden),e.workload=e.workload||0,t.label?e.label=t.label:void 0===e.label&&(e.label=""),t.value&&(e.value=t.value),e}insertResource(e,t){const i=this,n=Array.from(arguments).filter((e=>void 0!==e));let a,s=i._resources;if(1===n.length&&(t=n[0]),"object"!=typeof t)return void i.error(i.localize("incorrectArgument",{elementType:i.nodeName.toLowerCase(),methodName:"insertResources",argumentName:"resource"}));if(t.id&&s.find((e=>e.id&&e.id.toString()===t.id.toString())))return void i.updateResource(t.id,t);if(t.assignedTo&&(a=[t.assignedTo].reduce(((e,t)=>e.concat(t,[])))),!(t=i._setResource({},t)))return;i._refreshItemIds("resource"),s=i._resources;const r=i._getValidItemAndIndex(e,"resource").index;if(r<0?s.push(t):s.splice(r,0,t),i._tasks.length){if(void 0!==a){Array.isArray(a)||(a=[a]);for(let e=0,n=a.length;e<n;e+=1){const n=i._getValidItemAndIndex(a[e],"task");if(n){const e=n.item;!e||e.disableResources||e.resources.includes(t.id.toString())||e.resources.push(t.id)}}if(i._isUpdating)return void(i._isUpdating.type.resource=!0);i._highlightAssignedItem("task",i._getSelection("task",i.selectedTaskIds)),i._refreshResource(t)}if(i._isUpdating)return i._isUpdating.type.resource=!0,void(i._isUpdating.type.task=!0);if(i.groupByResources)i._refreshTableDataSource(),i._refreshTimeline();else if(i.taskColumns.find((e=>"resources"===e.value))){const e=i._tasks.filter((e=>e.resources.includes(t.id)));for(let t=0;t<e.length;t++)i._refreshTableColumnsData(e[t],["resources"])}}i._isUpdating?i._isUpdating.type.resource=!0:(i._createResourceTimeline(),i.$.fireEvent("itemInsert",{type:"resource",item:i._cloneObject(t)}))}_insertTimelineResource(e,t,i){const n=this,a=n.$.resourceTimelineCellsContainer,s=document.createElement("div");s.classList.add("smart-timeline-row"),s._resource=t,n._refreshResourceTimelineContent(t,s),n.$.resourceTimelineCellsContainer.insertBefore(s,e>-1?a.children[e]:void 0),n.$.container.style.setProperty("--smart-gantt-chart-resource-timeline-content-height",a.offsetHeight+"px"),n._refreshResourceScrollBar(),n._insertNewTreeItem(e,t,i,"resource"),n.$.resourceTree.refresh(),n._highlightAssignedItem("task",n._getSelection("task",n.selectedTaskIds))}updateResource(e,t){if(void 0===e)return;const i=this._getValidItemAndIndex(e,"resource");i&&i.item&&this._updateResource(i.item,t)}removeResource(e){if(void 0===e)return;const t=this._getValidItemAndIndex(e,"resource");t&&t.item&&this._removeResource(t.item)}_getResourceTasks(e){const t=this._resources,i=this._tasks;if(!e||!t.length||!i.length)return;let n=[];for(let t=0;t<i.length;t++)i[t].resources.includes(e.id)&&n.push(i[t]);return n}_getTaskResources(e){const t=this;if(!e)return[];const i=[e.resources].reduce(((e,t)=>e.concat(t)),[]);let n=[];for(let e=0;e<i.length;e++){const a=t._resources.find((t=>t.id&&t.id.toString()===i[e].toString()));a&&n.push(a)}return n}_resourceValidator(e,t){const i=this;return Array.isArray(t)||t instanceof Smart.ObservableArray||"number"==typeof t||"string"==typeof t||null==t?t:(i.error(i.localize("invalidValue",{elementType:i.nodeName.toLowerCase(),property:"resources",typeOne:"array",typeTwo:"number"})),null)}_handleTaskProgressChange(e){const t=this,i=t._dragDetails.task,n=t._dragDetails.timelineTask;if(t.disableTaskProgressChange)return;if(!t.hasAttribute("progress-change")){if(t.$.fireEvent("progressChangeStart",{id:"string"==typeof i.id||"number"==typeof i.id?i.id:i.$.id,item:t._cloneObject(i),progress:i.progress||0}).defaultPrevented)return void delete t._dragDetails.target;t._closeTooltip(),t.setAttribute("progress-change",""),t._scrollView.disableSwipeScroll=t._touchmoveInside=!0}const{left:a,width:s}=n.getBoundingClientRect(),r=e.pageX-window.pageXOffset;t._dragDetails.progress||(t._dragDetails.progress=i.progress/100*s),t._dragDetails.progress=Math.max(0,Math.min(s,t._dragDetails.progress+(t.rightToLeft?-1:1)*(r-t._dragDetails.coordinates.x))),t._dragDetails.coordinates.x=Math.max(a+t._dragDetails.offset.x,Math.min(a+s+t._dragDetails.offset.x,r));const o=t._dragDetails.task.progress=t._dragDetails.progress/s*100;i.progress=parseFloat(o.toFixed(2)),t._setTaskBarProgress(i,n),t._refreshTableColumnsData(i,["progress"]),clearTimeout(t._resourceTreeRefreshTimeout),t.$.mainSplitter.contains(t.$.resourceSplitter)&&(t._resourceTreeRefreshTimeout=setTimeout((function(){t._refreshAssignedResources(i,["progress"]),delete t._resourceTreeRefreshTimeout}),t.resourcePanelRefreshRate))}_handleTaskSegmentDrag(e){const t=this,i=t._dragDetails,n=i.segment,a=n.element,s=a._segmentObj;if(!s||s.disableDrag)return;const r=i.task,o=t._dragDetails.timelineTask,l=n.isFirstSegment,d=n.isLastSegment,c=t.rightToLeft,m=c?"right":"left";i.timelineRow||(i.timelineRow=Array.from(t.$.taskTimelineCellsContainer.children).find((e=>e._cellObj.task===r)));const u=i.timelineRow;if(!t.hasAttribute("dragged")){if(t.$.fireEvent("dragStart",{id:"string"==typeof r.id||"number"==typeof r.id?r.id:r.$.id,item:t._cloneObject(r),dateStart:r.dateStart,dateEnd:r.dateEnd,segment:t._cloneObject(s)}).defaultPrevented)return void delete i.timelineTask;if(t.setAttribute("dragged",""),t._closeTooltip(),t._touchmoveInside=!0,l||d){const e=t._createDelimiter("min-date"),i=t._createDelimiter("max-date");e&&u.appendChild(e),i&&u.appendChild(i)}}if(l){const n=i.size?i.size.width:i.originalSize.width;t._handleTaskResize(e,c?"right":"left"),i.segments||(i.segments=o.querySelectorAll(".smart-task-segment"));const a=i.size.width-n,s=i.segments;for(let e=0,t=s.length;e<t;e+=1){const t=s[e];0!==e&&(t.style[m]=(parseFloat(t.style[m])||t.offsetLeft)+a+"px")}}else{if(!d)return void t._handleSegmentDrag(e);{const s=n.dimensions;t._handleTaskResize(e,c?"left":"right"),a.style[m]=i.size.width-s.width+"px"}}t._refreshTask(o,[a]),t._refreshProject(r.$.project),t.groupByResources&&t._refreshProject(r.$.group),clearTimeout(t._resourceTreeRefreshTimeout),t.$.mainSplitter.contains(t.$.resourceSplitter)&&(t._resourceTreeRefreshTimeout=setTimeout((function(){t._refreshAssignedResources(o._cellObj.task),delete t._resourceTreeRefreshTimeout}),t.resourcePanelRefreshRate))}_handleSegmentDrag(e){const t=this,i=t._dragDetails,n=i.segment,a=n.element,s=i.task,r=t._dragDetails.timelineTask,o=t.rightToLeft,l=o?"right":"left";i.timelineRow||(i.timelineRow=Array.from(t.$.taskTimelineCellsContainer.children).find((e=>e._cellObj.task===s)));const d=i.timelineRow,{left:c}=d.getBoundingClientRect(),m=i.taskDimensions.left;n.position||(n.position={x:n.originalPosition.x});const u=r.offsetWidth,h=e.pageX-window.pageXOffset;let g=0,f=n.min.left||0,p=n.max.left;o&&(f=u-(f+n.dimensions.width),p=u-p),n.position.x=Math.max(f,Math.min(p,n.position.x+(o?-1:1)*(h-i.coordinates.x))),void 0!==p&&(g=o?m+n.min.left:m+n.max.left,n.position.x=Math.min(p,n.position.x)),f=m+(o?n.max.left-n.dimensions.width:f),i.coordinates.x=Math.max(c+n.offset.x+f,Math.min(c+n.offset.x+g,h)),a.style[l]=n.position.x+"px",t._refreshTaskSegments(r,[a])}_handleTaskBarDrag(e){const t=this;if(t.disableTaskDrag)return;const i=t._dragDetails;if(Math.abs(e.pageX-i.coordinates.x)<=5)return void(t._scrollView.disableSwipeScroll=!0);if(i.segment)return void t._handleTaskSegmentDrag(e);const n=i.task,a=i.timelineTask;i.timelineRow||(i.timelineRow=Array.from(t.$.taskTimelineCellsContainer.children).find((e=>e._cellObj.task===n)));const s=i.timelineRow;if(!t.hasAttribute("dragged")){if(t.$.fireEvent("dragStart",{id:"string"==typeof n.id||"number"==typeof n.id?n.id:n.$.id,item:t._cloneObject(n),dateStart:n.dateStart,dateEnd:n.dateEnd}).defaultPrevented)return void delete i.timelineTask;t.setAttribute("dragged",""),t._closeTooltip(),t._touchmoveInside=!0;const e=t._createDelimiter("min-date"),a=t._createDelimiter("max-date");e&&s.appendChild(e),a&&s.appendChild(a)}i.position||(i.position={x:i.originalPosition.x,y:i.originalPosition.y});const r=s.getBoundingClientRect().left,o=s.offsetWidth,l=a.offsetWidth,d=i.min.left||0,c=i.max.left,m=e.pageX-window.pageXOffset,u=t.rightToLeft;let h=0;i.position.x=Math.max(d,Math.min(o-l,i.position.x+(u?-1:1)*(m-i.coordinates.x))),void 0!==c&&(i.position.x=Math.min(c,i.position.x),h=o-l-c),i.coordinates.x=u?Math.max(r+i.offset.x+h,Math.min(r+o-(l-i.offset.x+d),m)):Math.max(r+i.offset.x+d,Math.min(r+o-(l-i.offset.x+h),m));const g=n.dateStart.getTime(),f=n.dateEnd.getTime();a.style[u?"right":"left"]=i.position.x+"px",t._refreshTask(a),t._refreshProject(n.$.project),t.groupByResources&&t._refreshProject(n.$.group),"project"===n.type&&n.dragProject&&t._refreshProjectTasks(n,{startTime:n.dateStart.getTime()-g,endTime:n.dateEnd.getTime()-f}),clearTimeout(t._resourceTreeRefreshTimeout),t.$.mainSplitter.contains(t.$.resourceSplitter)&&(t._resourceTreeRefreshTimeout=setTimeout((function(){t._refreshAssignedResources(a._cellObj.task),delete t._resourceTreeRefreshTimeout}),t.resourcePanelRefreshRate))}_handleTaskBarResize(e){const t=this;if(t.disableTaskResize)return;const i=t._dragDetails;if(i.segment)return void t._handleTaskSegmentResize(e);const n=i.timelineTask,a=i.task;if(!t.hasAttribute("resized")){if(t.$.fireEvent("resizeStart",{id:"string"==typeof a.id||"number"==typeof a.id?a.id:a.$.id,item:t._cloneObject(a),dateStart:a.dateStart,dateEnd:a.dateEnd}).defaultPrevented)return void t.$.timeline.removeAttribute("task-bar-hovered");t.setAttribute("resized",""),t._closeTooltip(),t._scrollView.disableSwipeScroll=t._touchmoveInside=!0}t._handleTaskResize(e,t.$.timeline.getAttribute("task-bar-hovered")),t._updateSegmentsOnTaskResize(),t._refreshTask(n),t._refreshProject(a.$.project),t.groupByResources&&t._refreshProject(a.$.group),clearTimeout(t._resourceTreeRefreshTimeout),t.$.mainSplitter.contains(t.$.resourceSplitter)&&(t._resourceTreeRefreshTimeout=setTimeout((function(){t._refreshAssignedResources(n._cellObj.task,["workload"]),delete t._resourceTreeRefreshTimeout}),t.resourcePanelRefreshRate))}_updateSegmentsOnTaskResize(){const e=this,t=e._dragDetails,i=t.task,n=t.timelineTask;if(!i||!i.segments)return;let a;t&&t.segments?a=t.segments:t.segments=a=n.querySelectorAll(".smart-task-segment");const s=a.length,r=t.size.width,o=e.rightToLeft?"right":"left";for(let t=0;t<s;t+=1){const i=a[t],n=i.style.width?parseFloat(i.style.width):i.offsetWidth,l=i.style[o]?parseFloat(i.style[o]):0;if(l+n>r){const t=r-(l+n),a=n+t;a<e._taskBarMinWidth&&(i.style[o]=l+t+"px"),i.style.width=a+"px"}else t===s-1&&(i.style.width=r-l+"px")}}_handleTaskSegmentResize(e){const t=this,i=t._dragDetails,n=i.segment,a=n.element,s=a._segmentObj;if(!s||s.disableResize)return;const r=i.task,o=t._dragDetails.timelineTask,l=n.isFirstSegment,d=n.isLastSegment,c=t.rightToLeft,m=c?"right":"left";if(!t.hasAttribute("resized")){if(t.$.fireEvent("resizeStart",{id:"string"==typeof r.id||"number"==typeof r.id?r.id:r.$.id,item:t._cloneObject(r),dateStart:r.dateStart,dateEnd:r.dateEnd,segment:t._cloneObject(s)}).defaultPrevented)return void t.$.timeline.removeAttribute("task-bar-hovered");t.setAttribute("resized",""),t._closeTooltip(),t._scrollView.disableSwipeScroll=t._touchmoveInside=!0}const u=t.$.timeline.getAttribute("task-bar-hovered");if(l&&("left"===u&&!c||"right"===u&&c)){const s=i.size?i.size.width:i.originalSize.width;void 0===n.size&&(n.size={width:n.originalSize.width}),t._handleTaskResize(e,u),i.segments||(i.segments=o.querySelectorAll(".smart-task-segment"));const r=i.size.width-s,l=i.segments;for(let e=0,t=l.length;e<t;e+=1){const t=l[e];0!==e&&(t.style[m]=(parseFloat(t.style[m])||t.offsetLeft)+r+"px")}a.style.width=(n.size.width+=r)+"px"}else{if(!d||!("right"===u&&!c||"left"===u&&c))return t._handleSegmentResize(e,u),void t._refreshTaskSegments(o,[a]);{const s=i.size?i.size.width:i.originalSize.width;void 0===n.size&&(n.size={width:n.originalSize.width}),t._handleTaskResize(e,u),a.style.width=(n.size.width+=i.size.width-s)+"px"}}t._refreshTask(o,[a]),t._refreshProject(r.$.project),t.groupByResources&&t._refreshProject(r.$.group),clearTimeout(t._resourceTreeRefreshTimeout),t.$.mainSplitter.contains(t.$.resourceSplitter)&&(t._resourceTreeRefreshTimeout=setTimeout((function(){t._refreshAssignedResources(o._cellObj.task,["workload"]),delete t._resourceTreeRefreshTimeout}),t.resourcePanelRefreshRate))}_handleSegmentResize(e,t){const i=this,n=i._dragDetails,a=n.task,s=n.segment,r=s.element,o=i.rightToLeft,l=n.taskDimensions.left;n.timelineRow||(n.timelineRow=Array.from(i.$.taskTimelineCellsContainer.children).find((e=>e._cellObj.task===a)));const d=n.timelineRow;s.position||(s.position={x:s.originalPosition.x}),s.size||(s.size={width:s.originalSize.width});const c=e.pageX-window.pageXOffset;let m=s.size.width,u=s.min.width||0,h=s.max.width,g=s.min.left||0,f=s.max.left,p=r.offsetLeft,{left:_}=d.getBoundingClientRect(),T="object"==typeof e?c-n.coordinates.x:e;if(_+=l,"left"===t&&!o||"right"===t&&o)if(o){const e=n.taskDimensions.width;T=T<0?-1*Math.min(Math.abs(T),m-u):Math.min(h-m,Math.abs(T)),m=Math.max(u,Math.min(h,m+T)),r.style.left="",r.style.right=(p=Math.max(e-g,(parseFloat(r.style.right)||d.offsetWidth-p-m)-T))+"px",n.coordinates.x=Math.max(_+e-p+u,Math.min(_+e-p,c))}else T=T>0?Math.min(T,m-(u||0)):-1*Math.min(h-m,Math.abs(T)),m=Math.max(u,Math.min(p+m,m-T)),r.style.right="",r.style.left=(p=Math.max(g,(parseFloat(r.style.left)||p)+T))+"px",n.coordinates.x=Math.max(_+g+u,Math.min(_+p+m-u,c));else o?(T<0&&(T=-1*Math.min(h-m,Math.abs(T))),m=Math.max(u,Math.min(p+m,m-T)),f-=s.dimensions.width,n.coordinates.x=Math.max(_+f,Math.min(_+f+h,c))):(T>0&&(T=Math.min(h-m,T)),m=Math.max(u,Math.min(h,m+T)),n.coordinates.x=Math.max(_+p+u,Math.min(_+p+h,c)));r.style.width=(s.size.width=m)+"px"}_handleTaskResize(e,t){const i=this,n=i._dragDetails,a=n.task;n.position||(n.position={x:n.originalPosition.x,y:n.originalPosition.y}),n.size||(n.size={width:n.originalSize.width}),n.timelineRow||(n.timelineRow=Array.from(i.$.taskTimelineCellsContainer.children).find((e=>e._cellObj.task===a)));const s=n.timelineRow,r=n.timelineTask,o=n.segment,l=e.pageX-window.pageXOffset;let d=n.size.width,c=n.min.width||0,m=n.max.width,u=s.getBoundingClientRect().left,h=i.rightToLeft,g="object"==typeof e?l-n.coordinates.x:e;if("left"===t&&!h||"right"===t&&h)if(o&&(h?(u-=o.dimensions.width-o.offset.x,c=Math.max(o.max.left+o.min.width,c)):(u+=o.offset.x,c=Math.max(n.taskDimensions.width-o.max.left+o.min.width,c))),h){g<0?g=-1*Math.min(Math.abs(g),d-(c||0)):void 0!==m&&(g=Math.min(m-d,Math.abs(g))),d=n.size.width=Math.max(c,Math.min(s.offsetWidth-r.offsetLeft,d+g));const e=r.offsetLeft;r.style.left="",r.style.right=(n.position.x=Math.max(0,(parseFloat(r.style.right)||s.offsetWidth-r.offsetLeft-r.offsetWidth)-g))+"px",n.coordinates.x=Math.max(u+r.offsetLeft+c,Math.min(u+e+d,l))}else g>0?g=Math.min(g,d-(c||0)):void 0!==m&&(g=-1*Math.min(m-d,Math.abs(g))),d=n.size.width=Math.max(c,Math.min(r.offsetLeft+d,d-g)),r.style.right="",r.style.left=(n.position.x=Math.max(0,(parseFloat(r.style.left)||r.offsetLeft)+g))+"px",n.coordinates.x=Math.max(u+r.offsetLeft,Math.min(u+r.offsetLeft+d-c,l));else h?(o&&(u+=o.offset.x,c=Math.max(n.taskDimensions.width-o.min.left+o.min.width,c)),g<0&&void 0!==m&&(g=-1*Math.min(m-d,Math.abs(g))),d=n.size.width=Math.max(c,Math.min(r.offsetLeft+r.offsetWidth,d-g)),r.style.width=n.size.width+"px",n.coordinates.x=Math.max(u+r.offsetLeft,Math.min(u+r.offsetLeft+d-c,l))):(o&&(u-=o.dimensions.width-o.offset.x,c=Math.max(o.min.left+o.min.width,c)),g>0&&void 0!==m&&(g=Math.min(m-d,g)),d=n.size.width=Math.max(c,Math.min(s.offsetWidth-r.offsetLeft,d+g)),n.coordinates.x=Math.max(u+r.offsetLeft+c,Math.min(u+r.offsetLeft+(m||d),l)));r.style.width=n.size.width+"px"}_handleTimelineConnectionHover(e){const t=this;if(!(t.shadowRoot||t).contains(e))return;const i=t.$.timelineConnectionsContainer.children,n=e.closest(".smart-task-connection");if(n||!t.$.timelineConnectionsContainer.querySelector(".smart-task-connection[hover]")){if(n){const e=n.getAttribute("connection-id");for(let t=0;t<i.length;t++){const n=i[t];n.getAttribute("connection-id")===e?n.setAttribute("hover",""):n.removeAttribute("hover")}t._hoveredConnectionTasks=n.tasks}}else for(let e=0;e<i.length;e++)i[e].removeAttribute("hover")}_resetItemHover(){const e=this;if(e._hoveredItem){const t=e.$.mainSplitter.querySelectorAll(".smart-timeline-task[hover], .smart-timeline-row[hover], tr[hover]");for(let e=0;e<t.length;e++)t[e].removeAttribute("hover");e.$.timeline.removeAttribute("task-bar-hovered"),delete e._hoveredItem}}_handleTimelineHover(e,t){const i=this,n=i._isMobile;if(!e||n)return void i._resetItemHover();const a=e.originalEvent||e;let s="task",r=a.pageX&&n?document.elementFromPoint(a.pageX-window.pageXOffset,a.pageY-window.pageYOffset):a.target;if(a.pageX&&i.shadowRoot&&r===i&&(r=a.pageX&&n?i.shadowRoot.elementFromPoint(a.pageX-window.pageXOffset,a.pageY-window.pageYOffset):a.composedPath()[0]),!r||!r.closest||r===i||t)return void i._resetItemHover();i.$.resourceSplitter&&i.$.resourceSplitter.contains(r)?s="resource":i._handleTimelineConnectionHover(r);let o=r.closest(".smart-timeline-row")||r.closest(".smart-timeline-task");if(!o||!(i.shadowRoot||i).contains(o))return void i._resetItemHover();const l=o._cellObj[s],d=l.$.id,c=i._hoveredItem;if(!(c&&c.type===s&&c.id===d||(i._resetItemHover(),l.isGroup||("task"===s&&o.classList.contains("smart-timeline-row")&&(o=i.$.timelineTasksContainer.querySelector(`.smart-timeline-task[row-id="${d}"]`)),!o||i._connectionFeedback&&o.contains(i._connectionFeedback)||(o.setAttribute("hover",""),i._hoveredItem={id:d,type:s},n))))){const e=("task"===s?i.$.taskTimelineCellsContainer:i.$.resourceTimelineCellsContainer).querySelector(`.smart-timeline-row[row-id="${d}"]`);e&&(e.setAttribute("hover",""),i._handleTableItemHover(d,r))}}_getScrollLeft(e){return this.rightToLeft?e*=-1:e}_synchronizeSplitters(e,t){if(this.$.mainSplitter.contains(this.$.resourceSplitter)){const i=e._measurements,n=e.items,a=t.items,[s,r,o]=[i.dimension,i.minDimension,i.maxDimension],[l,d]=[a[0],n[0]],[c,m]=[a[1],n[1]];t.keepProportionsOnResize=!0,t.setAttribute("orientation-change",""),[r,o,s].forEach((e=>{const t=e===s?"size":e===r?"min":"max";l.set(t,""),c.set(t,""),l[t]=d.style[e],c[t]=m.style[e]})),t.removeAttribute("orientation-change"),t.keepProportionsOnResize=!1}}_resizeEventHandler(e){const t=this,i=t.$.taskSplitter;function n(e){e.refresh(),e===i&&t._synchronizeSplitters(i,t.$.resourceSplitter)}if(e&&"resizeEnd"===e.type){if(e.target===t.$.taskTreeSplitter||e.target===t.$.resourceTreeSplitter)return void n(e.target);e.target===t.$.resourceSplitter&&t._synchronizeSplitters(t.$.resourceSplitter,i)}if(!t._timelineCells)return void t._refresh();t.$.mainSplitter.refresh(),n(i);const a=t._getScrollLeft(t.scrollLeft);t._autoSchedule(),t._createTimelineCells(),t._recycleTimelineTasks(),t._recycleTimelineRowCells(),t._refreshResourceTimeline(),t._refresh(),t.$.taskTable.refresh(),t.$.timelineHeader.scrollLeft=t.$.taskTimelineContainer.scrollLeft=a,t.$.taskTable.scrollTop=t.$.taskTimelineContainer.scrollTop=t.scrollTop,t.$.mainSplitter.contains(t.$.resourceTimelineHeader)&&(t.$.resourceTimelineHeader.scrollLeft=t.$.resourceTimelineContent.scrollLeft=a,t.$.resourceTable.refresh(),t.$.resourceTable.scrollTop=t.$.resourceTimelineContent.scrollTop=t.$.resourceVerticalScrollBar.value),t._positionWindow()}_recycle(e){const t=this,i=e&&"horizontal"===e.context.orientation;if(e&&!i||(t._recycleHeaderCells(t.$.timelineViewCells),t._recycleHeaderCells(t.$.timelineViewDetails),t.$.timelineViewSubDetails.classList.contains("smart-hidden")||t._recycleHeaderSubCells(t.$.timelineViewSubDetails),t._recycleResourceContent()),i)return;if(t._recycleResourceContent(),t._recycleContentCells(),t._recycleTimelineTasks(),!e)return;const n=Math.round(e.detail.value);e.target!==t.$.resourceVerticalScrollBar?t._refreshTableScrollTop(t.$.taskTable,n):t._refreshTableScrollTop(t.$.resourceTable,n)}_recycleContentCells(){const e=this,t=e._getFirstContentCellInView(),i=e.$.taskTimelineCellsContainer,n=e.$.timelineTasksContainer;if(!t)return void(i.innerHTML=n.innerHTML="");const a=t.height,s=1-(t.top+a-Math.abs(e.scrollTop))/a,r=e._timelineVCells?e._timelineVCells.length:0,o=!e.$.taskSplitter.offsetHeight,l=e.$.taskTimelineContainer.offsetHeight,d=!o&&l?Math.min(r,Math.ceil((parseFloat((l/a).toFixed(2))+s).toFixed(2))):r,c=e.$.timelineViewCells.children,m=document.createDocumentFragment();for(;i.childElementCount>d;)i.lastElementChild.remove();for(;n.childElementCount>d;)n.lastElementChild.remove();for(let t=i.childElementCount;t<d;t+=1){const t=document.createElement("div");t.classList.add("smart-timeline-row"),e._createTimelineRowCells(t,c),m.appendChild(t)}m.childElementCount&&i.appendChild(m);for(let e=n.childElementCount;e<d;e+=1){const e=document.createElement("div");e.classList.add("smart-timeline-task"),m.appendChild(e)}m.childElementCount&&n.appendChild(m)}_getCellIndexByDate(e){const t=this._timelineCells;let i=[];if(e&&e.length&&t){Array.isArray(e)||(e=[e]);for(let t=0,n=e.length;t<n;t+=1){const n=e[t];e[t]=n.getTime?n.getTime():n,i[t]=-1}for(let n=0,a=t.length;n<a;n+=1){const a=t[n],s=e.indexOf(a.date.getTime());if(s>-1&&(i[s]=n,i.every((e=>-1!==e))))break}return 1===i.length?i[0]:i}}_recycleDateMarkers(){const e=this,t=e.$.timelineMarkers,i=e._markers;if(!i||e.hideDateMarkers)return void(t.childElementCount&&(t.innerHTML=""));const n=e.$.timelineViewCells.children,a=n[0]._date,s=n[n.length-1]._date,[r,o]=e._getCellIndexByDate([a,s]);if(!a||!s)return;const l=a.getTime(),d=e._getCellDateRange({_date:s}).dateEnd.getTime(),c=t.children,[m,u]=e.rightToLeft?["right","left"]:["left","right"],h=document.createDocumentFragment();let g=0;for(let t=0,n=i.length;t<n;t+=1){const n=i[t],a=i[t].date,s=a.getTime();if(s<l||s>d)continue;const f=e._getTimelineCellByDate(a,r,o);if(f){const t=f.left+e._getTimelineTaskOffset(f,a),i=n.label,s=n.className;let r=c[g];r||(r=document.createElement("div"),h.appendChild(r)),r.className="smart-gantt-chart-date-marker",void 0!==i&&(r.firstElementChild||(r.innerHTML='<div class="smart-gantt-chart-marker-label"></div>'),r.firstElementChild.textContent=i+""),void 0!==s&&r.classList.add(s),r.style[u]="",r.style[m]=t+"px",g++}}for(h.childElementCount&&t.insertBefore(h,t.firstElementChild);c.length>g;)c[c.length-1].remove()}_refreshTableScrollTop(e,t){this.$.mainSplitter.contains(e)&&void 0!==t&&(e.scrollTop=t)}_recycleHeaderCells(e){let t=this,i=e.children,n=t.scrollLeft,a=e===t.$.timelineViewCells,s=a?t._timelineCells:t._timelineHeaderCells;if(e===t.$.timelineViewSubDetails&&(a=!1,s=t._timelineHeaderSubCells),!s.length)return;let r=document.createDocumentFragment();for(;i.length;)r.appendChild(e.firstElementChild);let o=t._getFirstCellObjInView(s),l=1-(o.left+o.width-Math.abs(n))/s[0].width,d=r.children.length,c=a?Math.ceil((parseFloat((t.$.timeline.offsetWidth/o.width).toFixed(2))+l).toFixed(2)):t._getHeaderVisibleCellsCount();if(e===t.$.timelineViewSubDetails&&(c=t._getHeaderSubVisibleCellsCount()),d>c)for(;r.children.length&&r.children.length!==c;)r.removeChild(r.firstElementChild);else if(d<c){const e=t._createCells(c-d);for(;e.children.length;)r.appendChild(e.firstElementChild)}const m=[t.rightToLeft?"right":"left"],u=a?t._getCellsViewType():t.view;let h=s.indexOf(o);for(let e=0;e<r.children.length;e++){const i=r.children[e],n=s[h];if(!n)break;let o=new Date(n.date);a||"week"!==t.view||(o.setDate(o.getDate()-o.getDay()),o=new Date(Math.max(n.date.getTime(),o.getTime()))),i.style[m]=n.left+"px",i.style.width=n.width+"px",i._date=o,i.innerHTML=`<div>${t._getDateString(o,u,!a)}</div>`,n.weekend?i.setAttribute("weekend",""):i.removeAttribute("weekend"),n.nonworking?i.setAttribute("nonworking",""):i.removeAttribute("nonworking"),h++}e.appendChild(r),a&&(t._recycleTimelineRowCells(),t._recycleResourceHeaderCells(),t._recycleDateMarkers(),t._setTodayCell())}_recycleHeaderSubCells(e){let t=this,i=e.children,n=t.scrollLeft,a=t._timelineHeaderSubCells;if(!a.length)return;let s=document.createDocumentFragment();for(;i.length;)s.appendChild(e.firstElementChild);let r=t._getFirstCellObjInView(a),o=(r.left,r.width,Math.abs(n),a[0].width,s.children.length),l=t._getHeaderSubVisibleCellsCount();if(o>l)for(;s.children.length&&s.children.length!==l;)s.removeChild(s.firstElementChild);else if(o<l){const e=t._createCells(l-o);for(;e.children.length;)s.appendChild(e.firstElementChild)}const d=[t.rightToLeft?"right":"left"],c=t.view;let m=a.indexOf(r);for(let e=0;e<s.children.length;e++){const i=s.children[e],n=a[m];if(!n)break;let r=new Date(n.date);"week"===t.view&&(r.setDate(r.getDate()-r.getDay()),r=new Date(Math.max(n.date.getTime(),r.getTime()))),i.style[d]=n.left+"px",i.style.width=n.width+"px",i._date=r,i.innerHTML=`<div>${t._getDateString(r,c,!0)}</div>`,n.weekend?i.setAttribute("weekend",""):i.removeAttribute("weekend"),n.nonworking?i.setAttribute("nonworking",""):i.removeAttribute("nonworking"),m++}e.appendChild(s),t._refreshHeaderSubDetailsDate()}_refresh(){const e=this;let t="disabled"===e.verticalScrollBarVisibility;function i(){const t=e.$.timelineHeader,i=t.scrollWidth-t.offsetWidth;return i>0&&"hidden"!==e.horizontalScrollBarVisibility||"visible"===e.horizontalScrollBarVisibility?e.$container.addClass("hscroll"):e.$container.removeClass("hscroll"),i}function n(){let i=Math.max(0,e.$.timelineContent.offsetHeight-e.$.taskTimelineContainer.offsetHeight);return i>0&&"hidden"!==e.verticalScrollBarVisibility||"visible"===e.verticalScrollBarVisibility?e.$container.addClass("vscroll"):e.$.mainSplitter.contains(e.$.resourceSplitter)?(i=1,t=!0,e.$.resourceVerticalScrollBar.max||e.$container.removeClass("vscroll")):e.$container.removeClass("vscroll"),i}const a=e.scrollWidth,s=e.scrollHeight;let r=i(),o=n();o&&s===o||(r=i()),r&&a===r||(o=n()),e.scrollWidth=r,e.scrollHeight=o,e.$.verticalScrollBar.disabled=t,e.$.horizontalScrollBar.refresh(),e.$.verticalScrollBar.refresh(),e.$.mainSplitter.contains(e.$.resourceSplitter)&&(e._refreshResourceScrollBar(),e._refreshTableScrollTop(e.$.resourceTable))}_refreshProjectTasks(e,t){const i=this,n=i._getProjectTasks(e);if(!n.length)return;const a=i.nonworkingDays,s=i.nonworkingHours,r=i._timelineVCells;for(let e=0,o=n.length;e<o;e++){const o=n[e];if(o){const e=i._getTaskDOMIndex(o),n=r[e],l=o.segments;if(o.dateStart=new Date(Math.max(i.dateStart.getTime(),o.dateStart.getTime()+t.startTime)),o.dateEnd=new Date(Math.min(i.dateEnd.getTime(),o.dateEnd.getTime()+t.endTime)),o.duration=i._convertDuration(a.length>0||s.length>0?i._getWorkingTime(o.dateStart,o.dateEnd):o.dateEnd.getTime()-o.dateStart.getTime(),!0),l&&l.length>1){for(let e=0,i=l.length;e<i;e+=1){const i=l[e];i.dateStart=new Date(i.dateStart.getTime()+t.startTime),i.dateEnd=new Date(i.dateEnd.getTime()+t.endTime)}i._validateTaskSegments(o)}n&&(i._recycleTaskBars(n,e),i._setTimelineTaskBar(n,e),l&&l.length>1&&i._setTaskBarProgress(o),i._refreshTaskConnections(o),i._refreshTableColumnsData(o,["dateStart","dateEnd","duration","overdue"]))}}}_refreshProject(e){const t=this;function i(e){let i,n,a;if(e instanceof HTMLElement)i=e.offsetLeft,a=e.offsetWidth;else if(e){const s=t._getTimelineTaskCellByDate(e.dateStart),r=t._getTimelineTaskCellByDate(e.dateEnd);s&&r&&(i=s.left+t._getTimelineTaskOffset(s,e.dateStart)||0,n=r.left+t._getTimelineTaskOffset(r,e.dateEnd)||0,a=n-i)}return[i,a]}if(!e)return;const n=t.groupByResources&&e.isGroup?"group":"project";if(e.synchronized)for(;e&&e.synchronized;){const a=t._getProjectTasks(e);let s=a[0],r=a[0];for(let e=0;e<a.length;e++)s.dateStart.getTime()>=a[e].dateStart.getTime()&&(s=a[e]),r.dateEnd.getTime()<=a[e].dateEnd.getTime()&&(r=a[e]);const o=t.$.timelineTasksContainer.children,l=t.$.timelineContent.offsetWidth;let d,c,m;for(let t=0,i=o.length;t<i;t+=1){const i=o[t],n=i._cellObj?i._cellObj.task:void 0;n&&(n===e?d=i:n===s?c=i:n===e&&(m=i))}if(!d){s&&(e.dateStart=s.dateStart),r&&(e.dateEnd=r.dateEnd),e=e.$[n];continue}s&&(e.dateStart=s.dateStart);let[u,h]=i(c||s);void 0!==u&&void 0!==h&&(t.rightToLeft?(d.style.width=d.offsetWidth-(l-u-h-(l-d.offsetLeft-d.offsetWidth))+"px",d.style.right=c?c.style.right:u+"px"):(d.style.width=d.offsetWidth-(u-d.offsetLeft)+"px",d.style.left=c?c.style.left:u+"px")),r&&(e.dateEnd=r.dateEnd),[u,h]=i(m||r),void 0!==u&&void 0!==h&&(t.rightToLeft?d.style.width=Math.max(0,d.offsetWidth-(l-d.offsetLeft-(l-u)))+"px":d.style.width=Math.max(0,d.offsetWidth-(d.offsetLeft+d.offsetWidth-(u+h)))+"px"),t._refreshTask(d),e=e.$[n]}else t._refreshProject(e.$[n])}_refreshTask(e,t){const i=this,n=i._getTaskBarCellRange(e),a=n.cellStart,s=n.cellEnd;if(!n||!a||!s)return;e._cellStart=a,e._cellEnd=s;const r=i._getTaskBarDateRange(e);if(!r)return;const o=e._cellObj.task;if(Array.from(i.$.taskTimelineCellsContainer.children).find((e=>e._cellObj.task===o))){if(o.dateStart=r.dateStart,o.dateEnd=r.dateEnd,o.duration=o.duration=i._convertDuration(i.nonworkingDays.length>0||i.nonworkingHours.length>0?i._getWorkingTime(o.dateStart,o.dateEnd):o.dateEnd.getTime()-o.dateStart.getTime(),!0),e.setAttribute("aria-label",o.label+" Start date: "+i._toISODate(o.dateStart)+", End date: "+i._toISODate(o.dateEnd)),i._refreshTaskConnections(e),t)Array.isArray(t)&&i._refreshTaskSegments(e,t);else{const t=i._dragDetails;let n;e.classList.contains("task")?t&&t.segments?n=t.segments:t.segments=n=e.querySelectorAll(".smart-task-segment"):n=e.querySelectorAll(".smart-task-segment"),i._refreshTaskSegments(e,n)}i._refreshTableColumnsData(o,["dateStart","dateEnd","duration","overdue"])}}_refreshTaskSegments(e,t){const i=this,n=e._cellObj.task;if(!n||!n.segments||!n.segments.length)return void i._setTaskBarDeadline(n,t?t[0]:void 0);const a=i.nonworkingDays.length>0||i.nonworkingHours.length>0,s=i.rightToLeft,r=s?"right":"left",o=parseFloat(e.style[r])||e.offsetLeft;let l;for(let n=0,d=t.length;n<d;n+=1){const d=t[n],c=d._segmentObj,m=i._getSegmentCellRange(d),u=m.cellStart,h=m.cellEnd;if(!m||!u||!h)continue;const g=parseFloat(d.style.width)||d.offsetWidth,f=o+parseFloat(d.style[r])||(s?(parseFloat(e.style.width)||e.offsetWidth)-(d.offsetLeft+d.offsetWidth):d.offsetLeft);d._cellStart=u,d._cellEnd=h,l=d;let p=i._getDateFromCell(f,u),_=i._getDateFromCell(f+g,h);c.dateStart=p,c.dateEnd=_,c.duration=i._convertDuration(a?i._getWorkingTime(p,_):_.getTime()-p.getTime(),!0),e.setAttribute("aria-label",(c.label||"")+" Start date: "+i._toISODate(p)+", End date: "+i._toISODate(_))}i._setTaskBarProgress(n,e),i._setTaskBarDeadline(n,l)}_refreshTaskResources(e,t=[]){const i=this;if(e&&(t||(t=i._getTaskResources(e)),t.length))for(let e=0;e<t.length;e++){const n=t[e];i._refreshResource(n),i._refreshTableColumnsData(n,void 0,"resource")}}_refreshTableColumnsData(e,t,i){const n=this;if(i||(i="task"),!e)return;const a=n[`${i}Columns`],s=n.$[`${i}Table`];if(!n.$.mainSplitter.contains(s))return;const r=e.$.id;t=t?t.map((e=>a.find((t=>t.value===e)))):a;for(let i=0;i<t.length;i++){const a=t[i];a&&s.setValue(r,a.value,n._formatColumnData(e,a))}n.$[`${i}Splitter`].refresh()}_removeConnection(e,t){const i=this,n=i.$.connectionPopupWindow,a=i.$.timelineConnectionsContainer;if(e.classList&&e.classList.contains("smart-task-connection")?e=e.getAttribute("connection-id"):e+="",void 0===e)return;const s=a.querySelectorAll('.smart-task-connection[connection-id^="'+e+(e.indexOf("-")<0?"-":"")+'"]'),r=i._tasks,o=e.split("-"),l=parseInt(o[1]);for(let e=0;e<s.length;e++)a.removeChild(s[e]);let d;const c=parseInt(o[0]),m=parseInt(o[1]),u=parseInt(o[2]);if(n&&void 0!==n._target&&"number"==typeof n._target.type){const t=n._target;d=t.startIndex+"-"+t.endIndex+"-"+t.type===e}i._updateConnection([c,m,u],!0),!t&&i.autoSchedule&&(i._autoScheduleRestore(r[l],parseInt(o[2])),i._autoSchedule(r[l])),d&&i.$.fireEvent("itemRemove",{type:"connection",id:`${c}-${m}-${u}`,item:{source:c,target:m,type:u}})}_removeTaskConnections(e,t){const i=this,n=i._connections;if(n&&n.length){for(let t=0,i=n.length;t<i;t+=1)n[t].startTask===e&&(n.splice(t,1),i--);e.connections=[],t&&i._recycleConnections()}}_removeTask(e){const t=this,i=t._tasks;if(!e||!i||!i.length)return;const n=t._getSelection("task",t.selectedTaskIds),a=t.$.taskPopupWindow;let s;if(t._highlightAssignedItem("task",[e]),a&&a._target===e&&a.close(),"project"===e.type){const n=t._getProjectTasks(e);for(let e=0,t=n.length;e<t;e+=1)i.splice(i.indexOf(n[e]),1)}if(i.splice(i.indexOf(e),1),t._refreshItemIds(),t._refreshConnectionIds(),t._isUpdating)return t._isUpdating.type.task=!0,void(t._isUpdating.type.resource=!0);t._refreshSelectedItems(),t._refreshTableDataSource(),t._refreshTimeline(),t._selected&&t._selected.task&&(s=t._selected.task.map((e=>e.$.id)),n.toString()!==s.toString()&&(t.$.taskTable.selected=t._getSelection("task",t.selectedTaskIds))),t.$.fireEvent("itemRemove",{type:"task",id:"string"==typeof e.id||"number"==typeof e.id?e.id:e.$.id,item:t._cloneObject(e)})}_removeResource(e){const t=this,i=t._resources,n=i.indexOf(e);if(e&&!(n<0)){if(t._isUpdating)return i.splice(n,1),t._isUpdating.type.resource=!0,void(t._isUpdating.type.task=!0);if(i.splice(n,1),t.groupByResources)t._refreshTableDataSource(),t._createTimelineContent(),t._refresh(),t._recycleTimelineTasks();else if(t.taskColumns.find((e=>"resources"===e.value))){const i=t._tasks.filter((t=>t.resources.includes(e.id)));for(let e=0;e<i.length;e++)t._refreshTableColumnsData(i[e],["resources"])}if(!i.filter((e=>!e.hidden)).length)return t._createResourceTimeline(),t._resizeEventHandler(),void a();t._refreshResourceTimeline(),t._refreshTableDataSource("resource"),t.$.mainSplitter.contains(t.$.resourceSplitter)?(t._refreshResourceScrollBar(),t._resizeEventHandler(),a()):a()}function a(){t.$.fireEvent("itemRemove",{type:"resource",id:"string"==typeof e.id||"number"==typeof e.id?e.id:e.$.id,item:t._cloneObject(e)})}}_updateTask(e,t){const i=this,n=i._tasks;if(!e||!n||!n.length)return;const a=i.$.taskPopupWindow,s=i._getSelection("task",i.selectedTaskIds);a&&a._target===e&&a.close();let r,o=i._getTaskResources(e);for(let a in t){let s=e[a],l=t[a];if("type"===a&&s!==l&&["task","project","milestone"].indexOf(l)>-1&&"project"===s){const t=i._getProjectTasks(e);for(let e=0,i=t.length;e<i;e+=1)n.splice(n.indexOf(t[e]),1);delete e.tasks}if("project"!==e.type||!e.synchronized||!(a.toLowerCase().indexOf("date")>-1||a.toLowerCase().indexOf("duration")>-1))if("dateEnd"===a&&new Date(s).getTime()!==new Date(l).getTime()&&(r=!0),"tasks"!==a)"connections"===a&&(i._removeTaskConnections(e),i._handleTaskConnections(e)),e[a]=l,"resources"===a&&(i._handleResources(e),e.disableResources||(o=o.concat(i._getTaskResources(e)),o=o.filter(((e,t)=>o.indexOf(e)===t)))),"milestone"!==e.type||"dateStart"!==a&&"dateEnd"!==a||(e.dateEnd=e.dateStart=l);else if("project"===e.type){const t=i._getProjectTasks(e);for(let e=0,i=t.length;e<i;e+=1)n.splice(n.indexOf(t[e]),1);const a=i._createTasks(l,!0);for(let t=0,i=a.length;t<i;t+=1)a[t].$.project=e;i._insertTasks(a,e,n.indexOf(e))}}r&&delete e.duration;const l=e.$,d=e.$.project;if(i._validateTaskProperties(e,d),e.$=l,d&&i._synchronizeProjectDates(d),"project"===e.type&&e.hidden&&i._getProjectTasks(e).forEach((t=>t.hidden=e.hidden)),i._synchronizeProjectVisibility(e.$.project,e),i._refreshItemIds(),i._refreshConnectionIds(),i._isUpdating)return void(i._isUpdating.type.task=!0);let c;i._selected&&i._selected.task&&i._setSelection("task",c=i._selected.task.map((e=>e.$.id))),i._refreshTableDataSource(),i._refreshTimeline(),i._ensureVisible(e),c&&s.toString()!==c.toString()&&(i.$.taskTable.selected=c.slice(0)),i._refreshTaskResources(e,o),i._highlightAssignedItem("task",i._getSelection("task",i.selectedTaskIds)),i.$.fireEvent("itemUpdate",{type:"task",id:"string"==typeof e.id||"number"==typeof e.id?e.id:e.$.id,item:i._cloneObject(e)})}_updateResource(e,t){const i=this;if(!e)return;const n=e.hidden;if(i._setResource(e,t),i._isUpdating)i._isUpdating.type.resource=!0;else{if(i.groupByResources)i._refreshTableDataSource(),i._refreshTimeline();else if(i.taskColumns.find((e=>"resources"===e.value))){const t=i._tasks.filter((t=>t.resources.includes(e.id)));for(let e=0;e<t.length;e++)i._refreshTableColumnsData(t[e],["resources"])}if(n!==e.hidden)return i._createResourceTimeline(),void i.$.fireEvent("itemUpdate",{type:"resource",id:"string"==typeof e.id||"number"==typeof e.id?e.id:e.$.id,item:i._cloneObject(e)});if(i._refreshTableColumnsData(e,void 0,"resource"),i.$.mainSplitter.contains(i.$.resourceTimelineCellsContainer)){const t=i.$.resourceTimelineCellsContainer.children;for(let n=0;n<t.length;n++){const a=t[n];a._resource===e&&i._refreshResourceTimelineContent(e,a)}}i.$.fireEvent("itemUpdate",{type:"resource",id:"string"==typeof e.id||"number"==typeof e.id?e.id:e.$.id,item:i._cloneObject(e)})}}_select(e="task",t){const i=this;if(i.disableSelection||!t)return void i._unselectAll(e);let n,a;"task"===e?(n="selectedTaskIds",a=i._tasks):(n="selectedResourceIds",a=i._resources);const s=a.findIndex((e=>e.$.id===t)),r=i._getSelection(e,i[n]);s<0||(r.indexOf(t)>-1?i.$[`${e}Table`].unselect(t):i.$[`${e}Table`].select(t))}_handleTableSelection(e="task",t){const i=this;if(i.disableSelection||!t.length)return void i._unselectAll(e);let n,a,s,r,o,l=i._selected;l||(l=i._selected={});const d=t[t.length-1],c=l[e]=[];"task"===e?(o=i._tasks,n="selectedTaskIds",a=i.$.taskTimelineCellsContainer.children,s=i.$.timelineTasksContainer.children):(o=i._resources,n="selectedResourceIds",a=i.$.resourceTimelineCellsContainer.children,s=[]);for(let e=0,i=o.length;e<i;e+=1){const i=o[e];t.indexOf(i.$.id)>-1&&c.push(i)}for(let i=0,n=a.length;i<n;i+=1){const n=a[i],o=s[i],l=n._cellObj[e].$.id;d===l&&(r=s[i]),t.indexOf(l)>-1?(n.setAttribute("selected",""),n.setAttribute("aria-selected","true"),o&&o.setAttribute("selected","")):(n.removeAttribute("selected"),n.setAttribute("aria-selected","false"),o&&o.removeAttribute("selected"))}const m=i[n].slice(0);if(i._setSelection(e,t),!i._tableChangeEventFired){const n=document.scrollingElement||document.documentElement,a=n.scrollLeft,s=n.scrollTop;i._highlightAssignedItem(e,t),i.$[`${e}Table`].focus({preventScroll:!0}),window.scrollTo(a,s)}if("task"===e&&r){const e=r._cellStart;if(i.scrollLeft>e.left||e.left+r.offsetWidth>i.scrollLeft+i.$.timeline.offsetWidth){const t=i._timelineCells.indexOf(e);i._scrollTo((i._timelineCells[t-1]?i._timelineCells[t-1]:e).date)}}i._noChangeEvent||i.$.fireEvent("change",{type:e,value:i[n].slice(0),oldValue:m})}_setSelection(e="task",t){const i=this;let[n,a]="task"===e?[i._tasks,"selectedTaskIds"]:[i._resources,"selectedResourceIds"],s=[];for(let e=0,i=t.length;e<i;e+=1){const i=t[e],a=n.find((e=>e.$.id===i));a&&s.push(void 0!==a.id?a.id:i)}i.set(a,s)}_getSelection(e="task",t){const i="task"===e?this._tasks:this._resources;let n=t.slice(0);if(!t||!t.length)return n;for(let e=0,a=i.length;e<a;e+=1){const a=i[e],s=t.indexOf(a.id);s>-1&&(n[s]=a.$.id)}return n}_highlightAssignedItem(e,t){const i=this,[n,a]="task"===e?["resource","_getTaskResources"]:["task","_getResourceTasks"],s=i.$[`${n}Table`],r=i[`_${n}s`];if(!s||!i.$.mainSplitter.contains(s)||!r.length)return;t&&Array.isArray(t)||(t=[]);let o=[];for(let n=0,s=t.length;n<s;n+=1){const s=i._getValidItemAndIndex(t[n],e);s&&(o=o.concat(i[a](s.item).filter((e=>!e.hidden))))}i._tableChangeEventFired=!0,s.selected=o.map((e=>e.$.id)),o.length&&i._ensureVisible(o[0],n),delete i._tableChangeEventFired}_selectResource(e){const t=this,i=t._resources.indexOf(e);if(i<0)return void t._unselectAll("resource");const n=t.$.resourceTimelineCellsContainer.children[i];n&&n.hasAttribute("selected")?t._unselectAllTasks():t.$.resourceTree.focus({preventScroll:!0})}_snapToNearest(e,t){const i=this;if(!(i.snapToNearest&&e&&e.classList&&e.classList.contains("smart-timeline-task")&&e._cellObj))return;const n=e._cellObj.task,a=n.segments;if(t&&t.classList.contains("smart-task-segment")){const n=a.indexOf(t._segmentObj),s=0===n,r=n===a.length-1;if(i._handleSnapToNearestSegment(e,t,s?"first":r?"last":void 0),i._refreshTaskSegments(e,[t]),!s&&!r)return;i._refreshTask(e,!0)}else i._handleSnapToNearest(i._getTaskBarCellRange(e),e),i._refreshTask(e);if(a&&a.length>1){for(let e=0,t=a.length;e<t;e+=1)i._snapToNearestDates(a[e],!0);i._validateTaskSegments(n),n.segments.length!==a.length&&i._recycleSegments(n,e),i._setTaskBarSegments(e._cellObj,e,!0),i._setTaskBarProgress(n)}if("project"!==n.type||!n.dragProject)return;const s=i._getProjectTasks(n);if(s&&Array.isArray(s))for(let e=0;e<s.length;e++){const t=i.$.timelineTasksContainer.children[i._tasks.indexOf(s[e])];t&&i._snapToNearest(t)}}_handleSnapToNearestSegment(e,t,i){const n=this,a=n.rightToLeft,s=a?"right":"left",r=parseFloat(e.style[s])||0,o=t,l=n._getSegmentCellRange(t),d=l.cellStart,c=l.cellEnd,m="first"===i,u="last"===i;let h=parseFloat(o.style.width)||o.offsetWidth,g=parseFloat(o.style[s])||0,f=r+g;if(n.hasAttribute("dragged")){const t=c.width-(f+h-c.left);let n;if(f-d.left<=t?(n=d.left-r,o.style[s]=Math.max(0,m?0:n)+"px"):(n=g+t,o.style[s]=Math.max(0,m?0:n)+"px"),i){const t=parseFloat(e.style.width)||e.offsetWidth;m&&(e.style[s]=r+(n-g)+"px"),e.style.width=t+(m?-1:1)*(n-g)+"px"}}else if(n.hasAttribute("resized")){const t=d===c?n._taskBarMinWidth:0;let l;if("left"===n.$.timeline.getAttribute("task-bar-hovered")){if(l=f-d.left,l-=l>=d.width/2?d.width-t:0,f-=l,o.style[s]=Math.max(0,m?0:f-r)+"px",l=f+h>c.left+c.width/2?c.left+c.width-(f+h):c.left-(f+h),o.style.width=Math.max(t,h+l)+"px",i){const t=parseFloat(e.style.width)||e.offsetWidth;m&&!a&&(e.style[s]=f+"px",e.style.width=t+l+"px"),u&&a&&(e.style.width=t+l+"px")}}else if(f>d.left+d.width/2?(f=d.left+d.width,o.style[s]=Math.max(0,m?0:f-r)+"px"):(f=d.left,o.style[s]=Math.max(0,m?0:f-r)+"px"),l=f+h-c.left,l=-1*(l-(l>=d.width/2?c.width:t)),o.style.width=h+l+"px",i){const t=parseFloat(e.style.width)||e.offsetWidth;m&&a&&(e.style[s]=f+"px",e.style.width=t+l+"px"),u&&!a&&(e.style.width=t+l+"px")}}}_handleSnapToNearest(e,t){const i=this;if(!e)return;const n=i.rightToLeft?"right":"left",a=e.cellStart,s=e.cellEnd;let r=parseFloat(t.style.width)||t.offsetWidth,o=parseFloat(t.style[n])||0;if(i.hasAttribute("dragged")){const e=s.width-(o+r-s.left);o-a.left<=e?t.style[n]=a.left+"px":t.style[n]=o+e+"px"}else if(i.hasAttribute("resized")){const e=a===s?i._taskBarMinWidth:0;let l;"left"===i.$.timeline.getAttribute("task-bar-hovered")?(l=o-a.left,l-=l>=a.width/2?a.width-e:0,t.style[n]=(o-=l)+"px",l=o+r>s.left+s.width/2?s.left+s.width-(o+r):s.left-(o+r),t.style.width=Math.max(e,r+l)+"px"):(o>a.left+a.width/2?t.style[n]=a.left+a.width+"px":t.style[n]=a.left+"px",o=parseFloat(t.style[n])||0,l=o+r-s.left,l=-1*(l-(l>=a.width/2?s.width:e)),t.style.width=r+l+"px")}}_setDragLimits(e){const t=this,i=t._dragDetails;if(!i)return;const n=i.timelineTask;if(!n||!e)return;const a=t.$.timeline.getAttribute("task-bar-hovered"),s=n._cellObj.task;if(a){if(s.disableResize)return void delete t._dragDetails;const e=t._getTaskBarSizeLimits(n,a);i.min.width=e.min,i.max.width=e.max,t._setSegmentLimits(a);const r=t._createDelimiter("min",a),o=t._createDelimiter("max",a);r&&n.appendChild(r),o&&n.appendChild(o)}else if(e.closest(".smart-task-connection-point"))i.timelineTask=void 0;else if(e.closest(".smart-timeline-task")===n){let e;if(t._connections){const i=t._tasks.indexOf(n._cellObj.task);e=t._connections.some((e=>e.startIndex===i||e.endIndex===i))}if(s.disableDrag||e&&t.autoSchedule&&t.autoScheduleStrictMode)return void delete i.target;i._taskDuration=t._getWorkingTime(s.dateStart,s.dateEnd),n.classList.contains("milestone")&&(i.target="smart-timeline-task-fill");const a=t._getTaskDragLimits(n),r=t.rightToLeft?t.$.timelineContent.offsetWidth-n.offsetLeft-n.offsetWidth:n.offsetLeft;if(void 0!==a.min&&(i.min.left=a.min,"project"===n._cellObj.task.type&&a.min>r&&(i.min.left=r)),void 0!==a.max&&(i.max.left=a.max,"project"===n._cellObj.task.type&&a.max<r&&(i.max.left=r)),"project"===s.type&&s.dragProject&&!t.synchronized){const e=t._getSubTaskLimits(n);void 0!==e.min&&(i.min.left=i.min.left?Math.max(i.min.left,e.min):e.min),void 0!==e.max&&(i.max.left=i.max.left?Math.min(i.max.left,e.max):e.max)}else"milestone"===s.type&&(i.target="smart-timeline-task-fill");t._setSegmentLimits()}else i.timelineTask=void 0;i.relatedConnections={}}_setSegmentLimits(e){const t=this,i=t._dragDetails;if(!i||!i.segment)return;const n=i.segment;if(n){const a=n.element,s=n.dimensions,r=a.previousElementSibling,o=a.nextElementSibling;if(n.min.width=e?t._taskBarMinWidth:0,t.rightToLeft){if(r)n.min.left="left"===e?s.left+s.width:r.offsetLeft-(e?0:s.width),"right"===e&&(n.max.width=r.offsetLeft-s.left);else if(!e){const e=t._getTaskBarSizeLimits(i.timelineTask,"right");i.min.width=e.min,i.max.width=e.max}if(o)n.max.left="right"===e?n.dimensions.left:o.offsetLeft+o.offsetWidth+s.width,e&&"left"!==e||(n.max.width=s.left+s.width-(o.offsetLeft+o.offsetWidth));else if(!e){const e=t._getTaskBarSizeLimits(i.timelineTask,"left");i.min.width=e.min,i.max.width=e.max}}else{if(r)n.min.left="right"===e?s.left:r.offsetLeft+r.offsetWidth+(e||o?0:s.width),"left"===e&&(n.max.width=s.left+s.width-n.min.left);else if(!e){const e=t._getTaskBarSizeLimits(i.timelineTask,"left");i.min.width=e.min,i.max.width=e.max}if(o)n.max.left="left"===e?s.left+s.width:o.offsetLeft-s.width,e&&"right"!==e||(n.max.width=o.offsetLeft-s.left);else if(!e){const e=t._getTaskBarSizeLimits(i.timelineTask,"right");i.min.width=e.min,i.max.width=e.max}}}}_setScrollBars(){const e=this;e._scrollView||(e._scrollView=new Smart.Utilities.Scroll(e.$.taskSplitterItem,e.$.horizontalScrollBar,e.$.verticalScrollBar));const t=e._scrollView.vScrollBar,i=e._scrollView.hScrollBar;i.$.addClass("smart-hidden"),t.$.addClass("smart-hidden"),t.hasStyleObserver=!1,i.hasStyleObserver=!1,t.hasResizeObserver=!1,i.hasResizeObserver=!1,t.rightToLeft=i.rightToLeft=e.rightToLeft,i.wait=!1,e._refresh()}_getWorkingTime(e,t){const i=this;if(!e||!t)return;if(!i.adjustToNonworkingTime)return t.getTime()-e.getTime();const n=i.nonworkingHours,a=i.nonworkingDays;function s(e,t){let i,s,r=t.getTime()-e.getTime(),o=new Date(e),l=0;for(;r>0;){const e=Math.min(r,36e5-(60*o.getMinutes()*1e3+1e3*o.getSeconds()+o.getMilliseconds()));if(a.indexOf(o.getDay())>-1)s=new Date(o),s.setHours(0,0,0,0),s.setDate(o.getDate()+1),i=Math.min(e,s.getTime()-o.getTime()),o=new Date(o.getTime()+i),r-=i;else if(n.indexOf(o.getHours())>-1){s=new Date(o);const t=s.getTime();s.setHours(o.getHours()+1,0,0,0),t===s.getTime()&&s.setHours(o.getHours()+2,0,0,0),i=Math.min(e,s.getTime()-o.getTime()),o=new Date(o.getTime()+i),r-=i}else l+=e,r-=e,o=new Date(o.getTime()+e)}return l}if(e.getFullYear()===t.getFullYear())return s(e,t);let r=new Date(e.getFullYear()+1,0,1,0,0,0,0),o=s(e,r);if(t.getFullYear()>r.getFullYear()){const e=Math.max(0,t.getFullYear()-r.getFullYear());for(let t=0;t<e;t++){let e=i._getWorkingDaysBetweenDays(r);o+=60*(24*e-e*i.nonworkingHours.length)*60*1e3,r.setFullYear(r.getFullYear()+1)}}return o+=s(r,t),o}_getWorkingDaysBetweenDays(e){const t=this,i=e.getFullYear(),n=(i%100==0?i%400==0:i%4==0)?366:365;let a=new Date(e),s=0;for(let e=0;e<n;e++)t.nonworkingDays.indexOf(a.getDay())<0&&s++,a.setDate(a.getDate()+1);return s}_setFocusable(){const e=this;e.disabled||e.unfocusable?e.tabIndex=-1:e.tabIndex=e.tabIndex>0?e.tabIndex:0}_setTaskBarLabel(e,t){const i=this;void 0===t&&(t=i._getTaskDOMIndex(e));const n=i.$.timelineTasksContainer.children[t];if(!n)return;const a=n.querySelector(".smart-task-segments").children;let s=e.segments;Array.isArray(s)&&s&&s.length&&"task"===e.type||(s=[e]);for(let i=0,n=s.length;i<n;i+=1){const n=s[i],r=a[i],o=r?r.getElementsByClassName("smart-timeline-task-label")[0]:void 0;if(!o)continue;o.firstElementChild||(o.innerHTML="<div></div>");let l=o.firstElementChild;"string"==typeof n.label||"number"==typeof n.label?l.textContent=n.formatFunction?n.formatFunction(n.label||"",t)||"":n.label||"":l.textContent=e.formatFunction?n.formatFunction(e.label||"",t)||"":e.label||""}}_setTaskBarProgress(e,t){const i=this;if("number"==typeof t?t=i.$.timelineTasksContainer.children[t]:void 0===t&&(t=i.$.timelineTasksContainer.children[i._getTaskDOMIndex(e)]),!t||!e)return;let n=e.progress;const a=t.querySelector(".smart-timeline-task-progress-thumb");if(!a)return;n=Math.min(100,Math.max(0,n))||0;const s=e.dateStart.getTime(),r=e.dateEnd.getTime(),o=t.querySelector(".smart-task-segments").children;let l,d,c=e.segments,m=0;c&&c.length||(c=[e]);for(let e=0,t=c.length;e<t;e+=1){const t=c[e],i=o[e],a=i?i.querySelector(".smart-timeline-task-progress"):void 0;if(!a)continue;const u=(t.dateStart.getTime()-s)/(r-s)*100,h=(t.dateEnd.getTime()-s)/(r-s)*100,g=Math.max(0,Math.min(100,(n-u)/(h-u)*100));a.style.width=g+"%",a.removeAttribute("value"),i.removeAttribute("show-progress-label"),n>=u?(m=Math.max(u,Math.min(n,h)),l=a,d=i):l||(l=a,d=i)}if(a.style[i.rightToLeft?"left":"right"]="",a.style[i.rightToLeft?"right":"left"]=m+"%",!l||!i.showProgressLabel)return;const u=i.progressLabelFormatFunction;d.setAttribute("show-progress-label",""),l.setAttribute("value",u?u(n)+"":parseFloat(n.toFixed(2))+"%")}_setTaskDeadline(e,t,i){const n=this,a=e.task,{timelineStart:s,timelineEnd:r}=i,o=a.deadline,l=n.$.timelineDeadlines,d=l.children,c=o&&o.getTime&&!isNaN(o.getTime())?o.getTime():void 0;let m;for(let e=0,i=d.length;e<i;e+=1){const i=d[e];if(parseInt(i.getAttribute("task-index"))===t){m=i;break}}if(!c||c<s||c>r)return void(m&&m.remove());const u=n._getTimelineCellByDate(o),[h,g]=n.rightToLeft?["right","left"]:["left","right"];m||(m=document.createElement("div"),m.classList.add("smart-gantt-chart-task-deadline"),m.setAttribute("task-index",t),l.appendChild(m)),m.setAttribute("date",o.toString()),m.setAttribute("title",n._formatDate(o)),m.style.top=e.top+"px",m.style[g]="",m.style[h]=u.left+(n._getTimelineTaskOffset(u,o)||0)+"px"}_setTaskBarDeadline(e,t){const i=this,n=e.deadline;if(!n||!n.getTime||isNaN(n)||!t)return;const a=e.deadline.getTime()-e.dateEnd.getTime();if(!e.deadline||a>0)return t.removeAttribute("deadline"),void(e.overdue=!1);e.overdue=!0,t.setAttribute("deadline",`${i.localize("overdue")}: ${Math.round(i._convertDuration(Math.abs(a),!0))} ${i.durationUnit+"s"}`)}_setTaskIndicators(e,t,i){const n=this,a=e.task,{timelineStart:s,timelineEnd:r}=i,[o,l]=n.rightToLeft?["right","left"]:["left","right"],d=n.$.taskIndicatorsContainer,c=d.children,m=a.indicators;let u;for(let e=0,i=c.length;e<i;e+=1){const i=c[e];if(parseInt(i.getAttribute("task-index"))===t){u=i;break}}if(!Array.isArray(m))return void(u&&u.remove());const h=document.createDocumentFragment(),g=document.createDocumentFragment();u||(u=document.createElement("div"),u.classList.add("smart-gantt-chart-indicator"),u.setAttribute("task-index",t),h.appendChild(u));const f=u.children;for(;f.childElementCount>m.length;)f.firstElementChild.remove();for(let t=0,i=m.length;t<i;t+=1){let i=f[t];const a=m[t],d=a.date;if(!d||!d.getTime){i&&i.remove();continue}const c=d.getTime();if(c<s||c>r){i&&i.remove();continue}const u=n._getTimelineCellByDate(d),h=a.label,p=a.className,_=a.icon;i||(i=document.createElement("div"),g.appendChild(i)),i.className="smart-gantt-chart-task-indicator",i._indicatorObj=a;const T=i.classList;"string"==typeof p&&T.add(p),_?(T.add("icon"),i.style.setProperty("--smart-gantt-chart-indicator-icon",`'${_}'`)):T.contains("icon")&&(T.remove("icon"),i.style.removeProperty("--smart-gantt-chart-indicator-icon")),i.textContent=h||"",i.style.top=e.top+"px",i.style[l]="",i.style[o]=u.left+(n._getTimelineTaskOffset(u,d)||0)+"px"}g.childElementCount&&u.appendChild(g),h.childElementCount&&d.appendChild(h)}_setTimelineTaskBar(e,t,i){const n=this,a=e.task,s=void 0===t?n._getTaskDOMIndex(a):t,r=n.$.timelineTasksContainer.children,o=r[s];let l,d;if(0===r.length||!o||!o.classList||!o.classList.contains("smart-timeline-task"))return;const c=a.dateStart instanceof Date?a.dateStart:new Date(a.dateStart),m=a.dateEnd instanceof Date?a.dateEnd:new Date(a.dateEnd);if(l=!i&&o._cellStart||n._getTimelineCellByDate(c),d=!i&&o._cellEnd||n._getTimelineCellByDate(m),!l||!d)return void o.classList.add("smart-visibility-hidden");o._cellStart=l,o._cellEnd=d,o.classList.remove("smart-visibility-hidden");const u=n._getTaskBarDetails(e,l,d);u&&(o.style[n.rightToLeft?"left":"right"]="",o.style[n.rightToLeft?"right":"left"]=u.left+"px",o.style.width=u.width?u.width+"px":"",o.style.top=u.top+"px"),n._setTaskBarSegments(e,o,i)}_setTimelineTaskBaseline(e,t){const i=this,n=e.task,a=i.$.timelineBaselinesContainer;if(!i.showBaseline)return void(a.innerHTML&&(a.innerHTML=""));const s=n.planned,r=a.children;let o;for(let e=0,i=r.length;e<i;e+=1){const i=r[e];if(parseInt(i.getAttribute("task-index"))===t){o=i;break}}if(!s||"milestone"===n.type||!s.dateStart||!s.dateEnd)return void(o&&o.remove());const l=s.dateStart,d=s.dateEnd,c=i._getTimelineCellByDate(l),m=i._getTimelineCellByDate(d);if(!c||!m)return;o||(o=document.createElement("div"),o.classList.add("smart-gantt-chart-task-baseline"),o.setAttribute("task-index",t),a.appendChild(o));const[u,h]=i.rightToLeft?["right","left"]:["left","right"],g=i._getTaskBarDetails(e,c,m);if(g){const e=o.style;e.width=g.width?g.width+"px":"",e.top=g.top+"px",e[u]=g.left+"px",e[h]=""}o.setAttribute("aria-label",n.label+" Start date: "+i._toISODate(l)+", End date: "+i._toISODate(d))}_setTaskBarSegments(e,t,i){const n=this,a=e.task,s=t.querySelector(".smart-task-segments").children;let r,o,l=a.segments;if(Array.isArray(l)&&l&&l.length&&"task"===a.type||(l=[a]),1===l.length){const e=s[0].style;return void(e.right=e.left=e.width="")}const d=n.rightToLeft,c=parseFloat(t.style[d?"right":"left"]);let m;for(let e=0,t=l.length;e<t;e+=1){const t=l[e],a=s[e];if(!a)continue;const u=t.dateStart instanceof Date?t.dateStart:new Date(t.dateStart),h=t.dateEnd instanceof Date?t.dateEnd:new Date(t.dateEnd);r=!i&&a._cellStart||n._getTimelineCellByDate(u),o=!i&&a._cellEnd||n._getTimelineCellByDate(h),a._cellStart=r,a._cellEnd=o;const g=n._getTaskBarDetails({task:t},r,o);g&&(a.style[d?"left":"right"]="",a.style[d?"right":"left"]=Math.max(0,g.left-c)+"px",a.style.width=g.width+"px"),m=a}n._setTaskBarDeadline(a,m)}_setCurrentTimeIndicators(){const e=this;if(clearInterval(e._currentTimeIndicatorInterval),delete e._currentTimeIndicatorInterval,e.currentTimeIndicator||e.shadeUntilCurrentTime)e._refreshTimeIndicators(),e._currentTimeIndicatorInterval=setInterval(e._refreshTimeIndicators.bind(e),1e3*e.currentTimeIndicatorInterval);else{const t=e.$.timelineIndicatorsContainer;t&&t.remove()}}_refreshTimeIndicators(){const e=this,t=new Date,i=e.view,n=e._getTodayCellObj(t);let a=e.$.timelineIndicatorsContainer;if(!n)return a&&a.remove(),clearInterval(e._currentTimeIndicatorInterval),void delete e._currentTimeIndicatorInterval;a||(e.$.timelineIndicatorsContainer=a=document.createElement("div"),a.classList.add("smart-gantt-chart-time-indicators-container"),a.setAttribute("role","presentation"));const s=new Date(n.date);let r,o,l=t.getMinutes();switch(i){case"quarter":case"year":{const e=new Date(t.getFullYear(),t.getMonth()+1,1,0,0,0,0);e.setDate(0),l+=24*t.getDate()*60,r=24*e.getDate()*60;break}case"month":l+=24*(t.getDay()+1)*60,r=10080;break;case"week":l+=60*t.getHours(),r=1440;break;case"day":r=s.getHours()+60}o={cellObj:n,minutes:l,max:r,today:t},e._refreshCurrentTimeShader(o),e._refreshCurrentTimeIndicator(o),a.childElementCount||(clearInterval(e._currentTimeIndicatorInterval),delete e._currentTimeIndicatorInterval),a.parentElement||e.$.timelineContent.appendChild(a)}_refreshCurrentTimeIndicator(e){const t=this,i=t.$.timelineIndicatorsContainer;let n=i.querySelector(".smart-gantt-chart-current-time-indicator");if(!t.currentTimeIndicator||!e)return void(n&&n.remove());const{cellObj:a,minutes:s,max:r}=e;n||(n=document.createElement("div"),n.classList.add("smart-gantt-chart-current-time-indicator")),t.rightToLeft?n.style.right=a.left+a.width*(s/r)+"px":n.style.left=a.left+a.width*(s/r)+"px",n.setAttribute("aria-label","Current Time Indicator"),n.parentElement||i.appendChild(n),t._setTodayCell(a.date)}_refreshCurrentTimeShader(e){const t=this.$.timelineIndicatorsContainer;let i=t.querySelector(".smart-gantt-chart-current-time-shader");if(!this.shadeUntilCurrentTime||!e)return void(i&&i.remove());const{cellObj:n,minutes:a,max:s}=e;i||(i=document.createElement("div"),i.classList.add("smart-gantt-chart-current-time-shader")),i.style.width=n.left+n.width*(a/s)+"px",i.setAttribute("aria-label","Current Time Shader"),i.parentElement||t.appendChild(i)}_setTodayCell(e){const t=this;if(e)e instanceof Date&&(e=e.getTime());else{let i=0;e=new Date,"day"===t.view&&(i=e.getHours()),e.setHours(i,0,0,0),e=e.getTime()}if("number"!=typeof e)return;const i=t.$.timelineViewCells.children;for(let t=0;t<i.length;t++){const n=i[t],a=new Date(n._date);a&&(a.getTime()===e?n.setAttribute("current",""):n.removeAttribute("current"))}}_getTodayCellObj(e){const t=this.view,i=this._timelineCells;e&&e.getTime||(e=new Date);for(let n=0,a=i.length;n<a;n+=1){const a=i[n],s=a.date;switch(t){case"quarter":case"year":if(e.getFullYear()===s.getFullYear()&&e.getMonth()===s.getMonth())return a;break;case"month":{const t=new Date(e);if(t.setDate(e.getDate()-e.getDay()),e.getFullYear()===s.getFullYear()&&e.getMonth()===s.getMonth()&&t.getDate()===s.getDate())return a;break}case"week":if(e.getFullYear()===s.getFullYear()&&e.getMonth()===s.getMonth()&&e.getDate()===s.getDate())return a;break;case"day":if(e.getFullYear()===s.getFullYear()&&e.getMonth()===s.getMonth()&&e.getDate()===s.getDate()&&s.getHours()===e.getHours())return a}}}_getTaskDOMIndex(e){const t=this.$.timelineTasksContainer.children;if(!e||void 0===e.$.id)return-1;for(let i=0,n=t.length;i<n;i+=1)if(t[i]._cellObj.task===e)return i;return-1}_getTimelineCellByDate(e,t,i){const n=this,a=n._timelineCells;if(!a||0===a.length)return;const s=a.length-1;i=Math.min(s,"number"==typeof i?i:s);for(let s=t=Math.min(i,Math.max(0,"number"==typeof t?t:0));s<=i;s++){const t=a[s];if(!t)continue;const i=t.date;switch(n.view){case"quarter":case"year":if(i.getFullYear()===e.getFullYear()&&i.getMonth()===e.getMonth())return t;break;case"month":{const n=new Date(i);let a=new Date(i);if(a.setDate(a.getDate()+(6-a.getDay())+1),a.setMilliseconds(a.getMilliseconds()-1),e.getTime()>=n.getTime()&&e.getTime()<=a.getTime())return t;break}case"week":if(i.getFullYear()===e.getFullYear()&&i.getMonth()===e.getMonth()&&i.getDate()===e.getDate())return t;break;case"day":if(i.getFullYear()===e.getFullYear()&&i.getMonth()===e.getMonth()&&i.getDate()===e.getDate()&&i.getHours()===e.getHours())return t}}const r=a[0],o=a[a.length-1];return e.getTime()<r.date.getTime()?r:e.getTime()>o.date.getTime()?o:void 0}_refreshViewDetailCell(e,t,i){const n=this,a=n._timelineCells,s=e.date;let r=0,o=0===i?0:void 0;for(void 0===t&&(t=0);t<a.length;t++){const e=a[t],i=n._getCellWidth(e,s);if(i)void 0===o&&(o=e.left+e.width-i),r+=i;else if(e.date.getTime()>s.getTime())break}return n._isLastWeekCellNotFull&&(delete n._isLastWeekCellNotFull,t--),e.width=r,e.left=o,t}_getCellWidth(e,t){const i=this,n=e.date,a=(e,t)=>e.getFullYear()===t.getFullYear(),s=(e,t)=>e.getMonth()===t.getMonth(),r=e.width;switch(i.view){case"month":{let e=new Date(n),o=new Date(e),l=0;for(o.setDate(o.getDate()+(6-e.getDay())+1),o.setMilliseconds(o.getMilliseconds()-1);e.getTime()<=o.getTime();)a(e,t)&&s(e,t)&&l++,e.setDate(e.getDate()+1);if(0===l)return;i._isLastWeekCellNotFull=l/7!=1;let d=r*l/7;return d<70?70:d}case"quarter":case"year":if(a(n,t))return r;break;case"week":{const e=new Date(t),i=new Date(t);if(e.setDate(t.getDate()-t.getDay()),i.setDate(t.getDate()+(6-t.getDay())),n.getTime()>=e.getTime()&&n.getTime()<=i.getTime())return r;break}case"day":if(a(n,t)&&s(n,t)&&n.getDate()===t.getDate())return r}}_getCellByOffsetLeft(e){const t=this._timelineCells;if(!e)return;let i;for(let n=0;n<t.length&&!(t[n].left>=e);n++)i=t[n];return i}_unselectAll(e,t){const i=this,n=i.$[`${e}TimelineCellsContainer`];let a;delete i._selected;const s=n.querySelectorAll(".smart-timeline-row[selected]");for(let e=0;e<s.length;e++)s[e].removeAttribute("selected");if("task"===e){a="selectedTaskIds";const e=i.$.timelineTasksContainer.querySelectorAll(".smart-timeline-task[selected]");for(let t=0;t<e.length;t++)e[t].removeAttribute("selected"),e[t].setAttribute("aria-selected","false")}else a="selectedResourceIds";if(i[`_${e}TreeChangeEventFired`]||i.$[e+"Table"].clearSelection(),i._highlightAssignedItem(e),t)return;const r=i[a].slice(0);r.length&&(i[a]=[],i._noChangeEvent||i.$.fireEvent("change",{value:[],oldValue:r,type:e}))}_getSegmentCellRange(e){const t=this;if(!e.classList||!e.classList.contains("smart-task-segment"))return;const i=e.closest(".smart-timeline-task");if(!i)return;let n,a,s=i._cellStart,r=i._cellEnd;s&&r||({cellStart:s,cellEnd:r}=t._getTaskBarCellRange(i));const o=t.rightToLeft,l=parseFloat(e.style.width)||e.offsetWidth,d=t._timelineCells;let c=parseFloat(i.style[o?"right":"left"]);c&&!isNaN(c)||(c=i.offsetLeft,o&&(c=t.$.timelineContent.offsetWidth-c));const m=c+parseFloat(e.style[o?"right":"left"])||(o?(parseFloat(i.style.width)||i.offsetWidth)-(e.offsetLeft+e.offsetWidth):e.offsetLeft),u=parseFloat((m+l).toFixed(2));for(let e=d.indexOf(s),t=d.indexOf(r);e<=t;e++){const t=d[e],i=t.left,s=t.width,r=parseFloat((i+s).toFixed(2));if(m>=i&&m<=r&&(n=t),!a&&u>i&&u<=r&&(a=t),n&&a)break}return n||(n=a||d[0]),a||(a=d[d.length-1]),{cellStart:n,cellEnd:a}}_getTaskBarCellRange(e){const t=this;if(!e.classList||!e.classList.contains("smart-timeline-task"))return;let i=parseFloat(e.style.width)||e.offsetWidth;const n=t._timelineCells,a=t.$.timelineContent,s=parseFloat(e.style[t.rightToLeft?"right":"left"])||(t.rightToLeft?(parseFloat(a.style.width)||a.offsetWidth)-(e.offsetLeft+e.offsetWidth):e.offsetLeft);let r,o;e.classList.contains("milestone")&&(i/=2);const l=parseFloat((s+i).toFixed(2));for(let e=0;e<n.length;e++){const t=n[e],i=t.left,a=t.width,d=parseFloat((i+a).toFixed(2));if(s>=i&&s<=d&&(r=t),!o&&l>i&&l<=d&&(o=t),r&&o)break}return r||(r=e.classList.contains("milestone")&&o?o:n[0]),o||(o=n[n.length-1]),{cellStart:r,cellEnd:o}}_getDateFromCell(e,t,i){if(!t)return new Date;const n=this,a=new Date(t.date);let s,r=0,o=0,l=new Date(a);switch(l.setHours(0,0,0,0),i||(i=n.view),i){case"quarter":case"year":s=new Date(a.getFullYear(),a.getMonth()+1,0).getDate(),r=1,l.setDate(s);break;case"month":r=a.getDate(),s=7,l.setDate(l.getDate()+6);break;case"week":s=1,r=a.getDate();break;case"day":s=1/24,r=a.getDate(),o=a.getHours()}l.setHours(23,59,59,999);const d=parseFloat(((e-t.left)/t.width*s).toFixed(12)),c=Math.min(s,Math.floor(d)),m=d%1*24,u=Math.floor(m),h=60*Math.abs(m-u),g=Math.floor(h),f=60*Math.abs(h-g),p=Math.floor(f),_=1e3*Math.abs(f-p),T=Math.floor(_),b=new Date(a.getFullYear(),a.getMonth(),r+c,o+u,g,p,T);return b.getTime()>l?l:b}_getCellDateRange(e){if(!e||!e._date)return;const t=new Date(e._date);let i=new Date(t);switch(i.setHours(0,0,0,0),this.view){case"quarter":case"year":i.setDate(1),i.setMonth(i.getMonth()+1),i.setDate(0);break;case"month":i.setDate(i.getDate()+6);break;case"day":return i.setHours(t.getHours(),59,59,999),{dateStart:t,dateEnd:i}}return i.setHours(23,59,59,999),{dateStart:t,dateEnd:i}}_getTasksJSON(){const e=this;let t=e._tasks;return function t(i,n){if(!i)return;let a=[];for(let s=0;s<i.length;s++){const r=i[s];let o;if(!r.$.project&&!n||r.$.project===n){const i=e._getTaskConnections(r).taskConnections;o=e._cloneObject(r,!0),i.length&&(o.connections=i.map((e=>{const t={target:e.endIndex,type:e.type};return e.lag&&(t.lag=e.lag),t}))),o.tasks=t(e._getProjectTasks(r),r),delete o.$,a.push(o)}}return a}(t)}_cloneObject(e,t){let i={};for(let n in e){let a=e[n];"tasks"!==n&&("connections"!==n?a instanceof Date?i[n]=t?a.toISOString():new Date(a):i[n]=a:i[n]=JSON.parse(JSON.stringify(a)))}return t||delete i.$,i}_setTable(e){const t=this;e||(e=t.$.taskTable);const[i,n]=e===t.$.taskTable?[t.taskColumns,"task"]:[t.resourceColumns,"resource"];if(!t.contains(e))return;if(!i.length)return void(t.$[n+"Table"].dataSource=[]);const a=t._getTableColumns(n);"task"===n&&(e.filterRow=t.filterRow,[e.grouping,e.groupFormatFunction]=t.groupByResources?[!0,t._formatResourceGroups.bind(t)]:[!1,null]),e.isRendered&&e.resetState("expanded"),e.style.setProperty("--smart-table-row-height",""),e.columns=a,e.dataSource=t._getTableDataSource(n,a),e.wait&&(t.$.taskTable.hasResizeObserver=!1,e.$.virtualizationContainer._scrollView.disableSwipeScroll=!0,e.$.virtualizationContainer.verticalScrollBarVisibility="hidden",e.$.virtualizationContainer.disabled=!0,e.columnMinWidth=t.columnMinWidth,e.columnResize=t.columnResize,e.columnResizeFeedback=t.columnResizeFeedback,e.filtering=t[`${n}Filtering`],e.sort=t.sortFunction,e.sortMode=t.sortMode,e.keyboardNavigation=t.keyboardNavigation,e.selectionByHierarchy=!1,e.selection=!t.disableSelection,e.hideSelectionColumn=!t.showSelectionColumn,e.onKeyboardScroll=(i,n)=>{const a=e===t.$.taskTable?t:t._resourceScrollView;n!==a.scrollTop&&(a.scrollTop=n)},e.wait=!1),e.$.virtualizationContainer.scrollTop="task"===n?t.scrollTop:t.$.resourceVerticalScrollBar.value,t._refresh()}_formatResourceGroups(e){const t=this,i=t._resources,n=e.data.data.resources.split(",");let a=[];for(let e=0,t=i.length;e<t;e+=1){const t=i[e],s=t.id+"";n.indexOf(s)>-1&&a.push(t.label||t.value||t.id)}t.resourceGroupFormatFunction?e.template=t.resourceGroupFormatFunction(n):e.template="<strong>"+(a.length?a.join(", "):t.localize("unassigned"))+"</strong>"}_formatResourceGroupLabel(e){const t=this,i=t._resources,n=e.split(",");if(!e)return t.localize("unassigned");let a=[];for(let e=0,t=i.length;e<t;e+=1){const t=i[e],s=t.id+"";n.indexOf(s)>-1&&a.push(t.label||t.value||t.id)}return a.length?a.join(", "):t.localize("unassigned")}_getTableColumns(e="task"){const t=this,i=["dateStart","dateEnd","minDateStart","maxDateStart","minDateEnd","maxDateEnd"],n=["progress","capacity","workload","maxCapacity","minCapacity"];let a="task"===e?t.taskColumns:t.resourceColumns,s=[];"task"===e&&t.groupByResources&&!a.find((e=>"resources"===e.value))&&(a=a.slice(0),a.push({label:"",value:"resources",hidden:!0}));for(let r=0,o=a.length;r<o;r++){const o=a[r],l=o.value,d={};d.label=t.localize(o.label)||o.label,d.dataField=l,l.startsWith("date")||i.indexOf(l)>-1?d.dataType="date":d.dataType="overdue"===l?"boolean":l.startsWith("duration")||n.indexOf(l)>-1?"number":"string",o.hidden&&(d.visible=!1),"function"==typeof o.formatFunction?d.formatFunction=i=>{const n=t._getValidItemAndIndex(i.data.itemId,e).item,a=i.column.toLowerCase();let s=i.value;a.indexOf("date")>-1?s=new Date(s):"resources"===a&&(s=s?s.split(","):[]),i.template=o.formatFunction.call(t,s,n?t._cloneObject(n):void 0)}:["date","number"].indexOf(d.dataType)>-1?d.formatFunction=i=>{const n=t._getValidItemAndIndex(i.data.itemId,e).item,a=t._formatColumnData(t._cloneObject(n),o);i.template=a}:"overdue"===l&&(d.formatFunction=e=>{const t=e.cell;e.value+""=="true"?t.setAttribute("overdue",""):t.removeAttribute("overdue"),e.value=""},d.width=t._taskDefaultHeight),o.size&&(d.width=o.size),s.push(d)}return s}_getTableDataSource(e="task",t){const i=this,n="task"===e?i._getTableData(i._tasks,i.taskColumns,e):i._getTableData(i._resources,i.resourceColumns,e),a=i.groupByResources,s=(()=>{let e=[];e.push("itemId: string"),e.push("projectId: string"),e.push("itemIndex: number"),a&&e.push("resources: string");for(let i=0,n=t.length;i<n;i+=1){const n=t[i];e.push(`${n.dataField}: ${n.dataType}`)}return e})();return i.groupByResources?new window.Smart.DataAdapter({dataFields:s,dataSource:n,groupBy:["resources"],id:"itemId"}):new window.Smart.DataAdapter({dataFields:s,dataSource:n,keyDataField:"itemId",parentDataField:"projectId",id:"itemId"})}_refreshTableDataSource(e="task"){const t=this,i="task"===e?t.$.taskTable:t.$.resourceTable;t.contains(i)&&(i.resetState("expanded"),i.dataSource=t._getTableDataSource(e,t._getTableColumns(e)))}_refreshColumnsHeaders(e){const t=this;e||(e="task");const i=t.$[`${e}Table`].columns,n=t[`${e}Columns`];for(let e=0,a=i.length;e<a;e++)i[e].label=t.localize(n[e].label)||n[e].label;!arguments.length&&t.$.mainSplitter.contains(t.$.resourceSplitter)&&t._refreshColumnsHeaders("resource")}_getTaskResourceIds(e){const t=e.resources,i=this._resources.map((e=>e.id));let n=[];if(Array.isArray(t))for(let e=0,a=t.length;e<a;e+=1){const a=t[e].id||t[e];i.indexOf(a)>-1&&n.push(a)}return n.sort()}_getTableData(e,t,i){const n=this,a=n.groupByResources;i||(i="task");const s=t.map((e=>e.value));let r=[],o=[];for(let l=0,d=e.length;l<d;l+=1){const d=e[l];if(d.hidden||a&&d.disableResources)continue;const c={},m=d.$.project,u=n._getTaskResourceIds(d);for(let e=0,a=s.length;e<a;e+=1)c[s[e]]=n._formatColumnData(d,t[e],i);c.expanded=a||d.expanded,c.itemId=d.$.id||d.id||"",c.itemIndex=l,u&&u.length?c.resources=u.toString():delete c.resources,d.$&&m&&(m.$.id?c.projectId=d.$.project.$.id:o.push(((e,t)=>{e.projectId=t.$.id}).bind(null,d,m))),r.push(c)}for(let e=0,t=o.length;e<t;e+=1)o[e]();return r}_formatColumnData(e,t){const i=this,n=t.value;let a=e[n];if(n){const e=(n+"").toLowerCase();if(e.indexOf("date")>-1||t.dateFormat)return i._formatDate(a,t);if(e.indexOf("duration")>-1||t.numberFormat){const e=parseFloat(a.toFixed(1));return t.numberFormat?i._formatNumber(e,t.numberFormat):e}}return null!=a?a.toString():i.localize("unassigned")}_formatDate(e,t){const i=this;if(e=Date.parse(e),!isNaN(e)){let n=t?t.dateFormat:void 0;if("string"==typeof n)return new Smart.Utilities.DateTime(new Date(e)).toString(n);if("object"==typeof n)n=t.dateFormat;else{const e=i.view;n={year:"numeric",month:"2-digit",day:"numeric"},["day","week"].indexOf(e)>-1&&(n.hour="numeric",n.minute="numeric",n.second="numeric")}return new Intl.DateTimeFormat(i.locale,n).format(new Date(e))}}_formatNumber(e,t,i){const n=this;if("object"==typeof t)return new Intl.NumberFormat(n.locale,t).format(""+e);i||(i={percentSymbol:"%",currencySymbol:"$",currencySymbolPosition:"before",decimalSeparator:".",thousandsSeparator:","});const a=e=>"number"==typeof e&&isFinite(e);if(""===t||null===t)return e;let s;a(e)||(e*=1),t.length>1&&(s=parseInt(t.slice(1),10));let r={},o=t.charAt(0).toUpperCase();switch(r.thousandsSeparator=i.thousandsSeparator,r.decimalSeparator=i.decimalSeparator,o){case"D":case"d":case"F":case"f":r.decimalPlaces=s;break;case"N":case"n":r.decimalPlaces=0;break;case"C":case"c":r.decimalPlaces=s,"before"===i.currencySymbolPosition?r.prefix=i.currencySymbol:r.suffix=i.currencySymbol;break;case"P":case"p":r.suffix=i.percentSymbol,r.decimalPlaces=s;break;default:throw"Bad number format specifier: "+o}if(a(e)){const t=e<0;let i=e+"";const n=r.decimalSeparator?r.decimalSeparator:".";let s;if(a(r.decimalPlaces)){var l=r.decimalPlaces,d=Math.pow(10,l);if(i=(e*d).toFixed(0)/d+"",s=i.lastIndexOf("."),l>0)for(s<0?(i+=n,s=i.length-1):"."!==n&&(i=i.replace(".",n));i.length-1-s<l;)i+="0"}else{let t=e+"";s=t.lastIndexOf("."),s>0&&void 0===l&&"."!==n&&(t=t.replace(".",n))}if(r.thousandsSeparator){const e=r.thousandsSeparator;s=i.lastIndexOf(n),s=s>-1?s:i.length;let a=i.substring(s),o=-1;for(var c=s;c>0;c--)o++,o%3==0&&c!==s&&(!t||c>1)&&(a=e+a),a=i.charAt(c-1)+a;i=a}return i=r.prefix?r.prefix+i:i,i=r.suffix?i+r.suffix:i,i}return e}_validateDate(e,t){return e[t]=this._dateValidator(void 0,e[t]),e[t]&&!isNaN(e[t].getTime())||(e[t]=void 0),e[t]}_validateTaskProperties(e,t){const i=this;if(e.$={},e.tasks instanceof Array&&e.tasks.length>0?e.type="project":(!e.type||["project","task","milestone"].indexOf(e.type)<0)&&(e.type="task"),i._validateTaskDuration(e),void 0===e.hidden&&t&&(e.hidden=t.hidden),e.hidden=!!e.hidden,void 0===e.resources?e.resources=[]:e.resources=[e.resources].reduce(((e,t)=>e.concat(t)),[]),"project"===e.type?e.expanded=!!e.expanded:delete e.expanded,e.progress=Math.min(Math.max(0,parseFloat(e.progress)||0),100),i._validateTaskDates(e,t),i._validateTaskSegments(e),i._validateTaskIndicators(e),i._validateTaskPlannedDates(e),e.deadline){const t=i._validateDate(e,"deadline");!t||isNaN(t.getTime())?delete e.deadline:e.dateEnd&&(e.overdue=e.deadline.getTime()-e.dateEnd.getTime()<0)}else e.overdue=!1,delete e.deadline;if(!e.dateStart&&!e.dateEnd&&"project"===e.type&&!e.synchronized)return;const n=e.connections;if(n instanceof Array){for(let e=0;e<n.length;e++){const t=n[e],i=t.target="string"==typeof t.target?t.target:parseInt(t.target),a=t.type=parseInt(t.type);null==i||"number"==typeof i&&isNaN(i)||isNaN(a)?(n.splice(n.indexOf(t),1),e--):t.lag=parseInt(t.lag)||0}e.connections=e.connections.map((e=>Object.assign({},e)))}else e.connections=[];return e.class=e.class?e.class+"":"",e.class=void 0!==e.class&&null!==e.class?e.class:"",e}_validateTaskIndicators(e){const t=this,i=e.indicators;if(!i||!Array.isArray(i)||!i.length)return void delete e.indicators;let n=[];for(let e=0,a=i.length;e<a;e+=1){const a=i[e];if("object"!=typeof a)continue;const s=t._validateDate(a,"date");s&&s.getTime&&!isNaN(s.getTime())&&n.push(a)}e.indicators=n}_validateTaskSegments(e){const t=this,i=e.segments;if(!i||!Array.isArray(i)||i.length<2||"task"!==e.type)return void delete e.segments;const n=t.nonworkingDays.length>0||t.nonworkingHours.length>0;let a,s=[],r=[];for(let e=0,n=i.length;e<n;e+=1){const n=i[e];if("object"!=typeof n)continue;let a=parseFloat(n.duration);isNaN(a)&&delete n.duration,t._validateTaskDates(n),n.dateStart&&n.dateEnd&&s.push(n)}s.sort(((e,t)=>e.dateStart.getTime()-t.dateStart.getTime()));for(let i=0,o=s.length;i<o;i+=1){const o=s[i];let l=o.dateStart,d=o.dateEnd;o.dateStart=l=new Date(Math.max(e.dateStart.getTime(),l.getTime())),o.dateEnd=d=new Date(Math.min(e.dateEnd.getTime(),d.getTime())),a&&a.dateEnd.getTime()>l.getTime()&&(o.dateStart=l=new Date(a.dateEnd.getTime()+1e3),l.getTime()>=d.getTime())||l.getTime()>d.getTime()||(o.duration=t._convertDuration(n?t._getWorkingTime(l,d):d.getTime()-l.getTime(),!0),a=o,r.push(o))}r.length<2?delete e.segments:(r[0].dateStart=new Date(e.dateStart),r[r.length-1].dateEnd=new Date(e.dateEnd),e.segments=r)}_validateTaskDuration(e){const t=this;let i=t._convertDuration(parseFloat(e.duration))||0,n=t._convertDuration(parseFloat(e.minDuration))||0,a=t._convertDuration(parseFloat(e.maxDuration))||0;n&&a&&(a=Math.max(n,a)),i&&(n?i=Math.max(n,i):a&&(i=Math.min(i,a))),e.duration=t._convertDuration(i,!0),e.minDuration=t._convertDuration(n,!0),e.maxDuration=t._convertDuration(a,!0)}_validateTaskDates(e,t){const i=this,n=i._convertDuration(e.minDuration),a=i._convertDuration(e.maxDuration);let s=i._convertDuration(e.duration);if(void 0!==e.minDateStart&&(e.minDateStart=i._validateDate(e,"minDateStart")),void 0!==e.maxDateStart&&(e.maxDateStart=i._validateDate(e,"maxDateStart")),e.minDateStart&&e.maxDateStart&&(e.maxDateStart=new Date(Math.max(e.minDateStart.getTime(),e.maxDateStart.getTime()))),void 0!==e.minDateEnd&&(e.minDateEnd=i._validateDate(e,"minDateEnd")),void 0!==e.maxDateEnd&&(e.maxDateEnd=i._validateDate(e,"maxDateEnd")),e.minDateEnd&&e.maxDateEnd&&(e.maxDateEnd=new Date(Math.max(e.minDateEnd.getTime(),e.maxDateEnd.getTime()))),e.dateStart=i._validateDate(e,"dateStart"),e.dateEnd=i._validateDate(e,"dateEnd"),e.dateStart||(e.minDateStart?e.dateStart=e.minDateStart:e.maxDateStart?e.dateStart=e.maxDateStart:e.dateStart=i.dateStart),e.dateEnd||(e.minDateEnd?e.dateEnd=e.minDateEnd:e.maxDateEnd&&(e.dateEnd=e.maxDateEnd)),e.minDateStart&&(e.dateStart=new Date(Math.max(e.minDateStart.getTime(),e.dateStart.getTime()))),e.maxDateStart&&(e.dateStart=new Date(Math.min(e.maxDateStart.getTime(),e.dateStart.getTime()))),e.minDateEnd&&(e.dateEnd=new Date(Math.max(e.minDateEnd.getTime(),e.dateEnd.getTime()))),e.maxDateEnd&&(e.dateEnd=new Date(Math.min(e.maxDateEnd.getTime(),e.dateEnd.getTime()))),e.dateStart&&(i.min&&(s=Math.min(e.dateStart.getTime()-i.min.getTime(),s),e.duration=i._convertDuration(s,!0)),i.max&&(s=Math.min(i.max.getTime()-e.dateStart.getTime(),s),e.duration=i._convertDuration(s,!0))),!e.dateStart&&s&&e.dateEnd&&(e.dateStart=new Date(e.dateEnd.getTime()-s)),"task"!==e.type||e.dateStart&&!isNaN(e.dateStart.getTime())||!t||(e.dateStart=new Date(t.dateStart)),n&&e.dateStart)if(i.adjustToNonworkingTime&&(i.nonworkingDays.length>0||i.nonworkingHours.length>0)){const t=i._getTaskWorkingDateEnd(e,n);e.dateEnd=new Date(Math.max(e.dateEnd?e.dateEnd.getTime():0,t.getTime()))}else e.dateEnd=new Date(Math.max(e.dateEnd?e.dateEnd.getTime():0,e.dateStart.getTime()+n));if(s&&e.dateStart&&(i.adjustToNonworkingTime&&(i.nonworkingDays.length>0||i.nonworkingHours.length>0)?e.dateEnd=i._getTaskWorkingDateEnd(e,s):e.dateEnd=new Date(e.dateStart.getTime()+s)),s||a){let t;t=i.adjustToNonworkingTime&&(i.nonworkingDays.length>0||i.nonworkingHours.length>0)?i._getTaskWorkingDateEnd(e,Math.max(s,a)):new Date(e.dateStart.getTime()+Math.max(s,a)),e.dateEnd.getTime()>t.getTime()&&(e.dateEnd=t)}"task"===e.type&&!e.dateEnd&&t&&(e.dateEnd=new Date(t.dateEnd)),e.dateStart=i._minMaxDateValidator(e.dateStart),e.dateEnd=i._minMaxDateValidator(e.dateEnd),"milestone"===e.type&&(e.dateStart=i._validateDate(e,"dateStart"),e.dateEnd=i._validateDate(e,"dateEnd"),e.dateStart=e.dateEnd=new Date(Math.max(e.dateStart?e.dateStart.getTime():0,e.dateEnd?e.dateEnd.getTime():0))),(e.dateStart||e.dateEnd||"project"!==e.type||e.synchronized)&&("milestone"!==e.type&&e.dateStart&&(e.dateEnd&&e.dateStart.getTime()>e.dateEnd.getTime()||!e.dateEnd)&&(e.dateEnd=new Date(e.dateStart.getTime()+36e5*("day"===i.view?1:24))),e.dateStart&&e.dateEnd&&(e.duration=i._convertDuration(i.nonworkingDays.length>0||i.nonworkingHours.length>0?i._getWorkingTime(e.dateStart,e.dateEnd):e.dateEnd.getTime()-e.dateStart.getTime(),!0)))}_validateTaskPlannedDates(e){const t=this;if(!e)return;const i=e.type,n=e.planned;if("milestone"===i||!n)return;const a=t._validateDate(n,"dateStart"),s=t._validateDate(n,"dateEnd");a&&s&&(n.duration=t._convertDuration(t.nonworkingDays.length>0||t.nonworkingHours.length>0?t._getWorkingTime(a,s):s.getTime()-a.getTime(),!0))}_synchronizeProjectDates(e,t){const i=this;if(e){void 0===t&&(t=i._getProjectTasks(e));for(let a=0,s=t.length;a<s;a+=1){const s=t[a];e.synchronized&&(s.dateStart&&(e.dateStart=n(s,"dateStart","min")),s.dateEnd&&(e.dateEnd=n(s,"dateEnd","max")),s.minDateStart&&(e.minDateStart=n(s,"minDateStart","max")),s.maxDateStart&&(e.maxDateStart=n(s,"maxDateStart","min")),s.minDateEnd&&(e.minDateEnd=n(s,"minDateEnd","max")),s.maxDateEnd&&(e.maxDateEnd=n(s,"maxDateEnd","min")),e.dateStart&&e.dateEnd&&(e.duration=i._convertDuration(i.nonworkingDays.length>0||i.nonworkingHours.length>0?i._getWorkingTime(e.dateStart,e.dateEnd):e.dateEnd.getTime()-e.dateStart.getTime(),!0)))}e.$&&i._synchronizeProjectDates(e.$.project,t)}function n(t,i,n){const a=e[i];let s=t[i];return void 0===a?new Date(s):s instanceof Date?new Date(Math[n](a.getTime(),s.getTime())):void 0}}_synchronizeProjectVisibility(e,t){const i=this;e&&e.hidden&&!t.hidden&&(e.hidden=t.hidden,e.$&&i._synchronizeProjectVisibility(e.$.project,e))}_mouseWheelHandler(e){const t=this,i=(t.shadowRoot||t).querySelector(".smart-task-popup-window");if(i&&i.modal&&i.opened)return void e.stopPropagation();if(t.disabled||!t.computedHorizontalScrollBarVisibility&&!t.computedVerticalScrollBarVisibility)return;if(e.shiftKey)return void t._handleHorizontalScroll(e);const n=t.$.resourceSplitterItem;t.$.mainSplitter.contains(n)&&n.contains(e.target)?t._handleVerticalScroll(e,!0):t.$.taskSplitterItem.contains(e.target)&&t._handleVerticalScroll(e)}_handleVerticalScroll(e,t){const i=this;let n,a,s,r;if(t){if(n=i.$.resourceVerticalScrollBar,n.classList.contains("smart-hidden")||n.disabled)return!0;a=n.value,s=n.max,r=i._resourceScrollView}else{if(!i.computedVerticalScrollBarVisibility||i.$.verticalScrollBar.disabled)return!0;a=i.scrollTop,s=i.scrollHeight,r=i}if(0===a&&e.deltaY<0||a===s&&e.deltaY>0)return void e.stopPropagation();const o=i.$[t?"resourceTable":"taskTable"];if(e.stopPropagation(),e.preventDefault(),a+=i._getScrollCoefficient(e,i.offsetHeight),r){const e=o.$.virtualizationContainer;e.scrollHeight!==r.scrollHeight&&(e.scrollHeight=r.scrollHeight),r.scrollTo(a,void 0)}o.scrollTop=a,i._hoveredItem&&i._handleTableItemHover()}_handleHorizontalScroll(e){const t=this;if(!t.computedHorizontalScrollBarVisibility)return!0;const i=t.scrollLeft;(0===i&&e.deltaX<0||i===t.scrollHeight&&e.deltaX>0)&&e.stopPropagation(),e.stopPropagation(),e.preventDefault(),t.scrollWidth>0&&t.scrollTo(void 0,t.scrollLeft+t._getScrollCoefficient(e,t.offsetWidth))}_handleHeaderTemplate(e="task"){const t=this;if(!("content"in document.createElement("template")))return void t.error(t.localize("htmlTemplateNotSuported",{elementType:t.nodeName.toLowerCase()}));const i=t.$[`${e}SplitterItemHeader`],n=t.$[`${e}SplitterItem`],a="task"===e?"headerTemplate":"resourcePanelHeaderTemplate";let s=t[a];if(n.removeAttribute("show-header"),i.innerHTML="",!s)return;if("function"==typeof s)return s(i,{}),void(i.innerHTML?n.setAttribute("show-header",""):n.removeAttribute("show-header"));if("string"==typeof s&&(s=document.getElementById(s)),null===s||!("content"in s))return void t.error(t.localize("invalidTemplate",{elementType:t.nodeName.toLowerCase(),property:a}));let r=document.importNode(s.content,!0);if(n.setAttribute("show-header",""),t.shadowRoot)return i.innerHTML="<slot></slot>",void t.appendChild(r);i.appendChild(r)}_handleCollapseExpandMethods(e,t){const i=this,n=i._tasks;if(null==e||!n||!n.length)return;const a=i._getValidItemAndIndex(e);if(!a||!a.item)return void i.error(i.localize("incorrectArgument",{elementType:i.nodeName.toLowerCase(),methodName:"collapse",argumentName:"task"}));let s=a.item;"project"!==s.type&&(s=s.$.project),s&&(s.hidden?s.expanded="expand"===t:i.$.taskTable["expand"===t?"expandRow":"collapseRow"](s.$.id))}_getValidItemAndIndex(e,t="task"){const i=this,n="task"===t?i._tasks:i._resources;let a;if(null==e||!n||!n.length)return{};if("string"==typeof e||"number"==typeof e){const t=e.toString();let i,s;for(let a=0,r=n.length;a<r;a+=1){const r=n[a];if(!i){const n=r.id;if(null!=n&&n.toString&&n.toString()===t){i=r,e=a;break}}r.$.id===t&&(s=r,e=a)}a=i||s}else"object"==typeof e&&(a=n[i._getItemIndex(e,t)],e=n.indexOf(a));return{item:a,index:e}}_horizontalScrollbarHandler(e){const t=this,i=t._getScrollLeft(e.detail.value);e.stopPropagation&&e.stopPropagation(),t.$.timelineHeader.scrollLeft=t.$.taskTimelineContainer.scrollLeft=i,t.$.mainSplitter.contains(t.$.resourceTimelineHeader)&&(t.$.resourceTimelineHeader.scrollLeft=t.$.resourceTimelineContent.scrollLeft=i),t._recycle(e),e.context.min!==e.context.value?e.context.max===e.context.value&&(t._handleInfiniteTimeline(),t.$.fireEvent("scrollRightReached")):t.$.fireEvent("scrollLeftReached")}_verticalScrollbarHandler(e){const t=this,i=e.target,n=Math.round(e.detail.value);e.stopPropagation&&e.stopPropagation(),i&&i===t.$.resourceVerticalScrollBar?t.$.resourceTable.scrollTop=t.$.resourceTimelineContent.scrollTop=n:(t.$.taskTimelineContainer.scrollTop=n,t.$.taskTable.scrollTop=n),t._recycle(e),e.context.max!==e.context.value?e.context.min===e.context.value&&t.$.fireEvent("scrollTopReached"):t.$.fireEvent("scrollBottomReached")}_handleInfiniteTimeline(){const e=this,t=e._timelineCells;if(!e.infiniteTimeline||!t||!t.length)return;const i=e.infiniteTimelineStep,n=t[t.length-1].date;switch(e.view){case"quarter":case"year":n.setMonth(n.getMonth()+i);break;case"month":n.setDate(n.getDate()+7*i);break;case"week":n.setDate(n.getDate()+i);break;case"day":n.setHours(n.getHours()+i)}e.set("dateEnd",n),e._createTimelineCells(),e._recycleTimelineTasks(!0),e.$.mainSplitter.contains(e.$.resourceSplitter)&&e._refreshResourceTimeline(),e._refresh()}_nonworkingDayValidator(e,t){return this._nonworkingDateTimeValidator(e,t)}_nonworkingTimeValidator(e,t){return this._nonworkingDateTimeValidator(e,t,!0)}_nonworkingDateTimeValidator(e,t,i){const n=this,[a,s,r]=i?[0,23,24]:[0,6,7];let o=[];function l(e){let t=Math.max(a,Math.min(s,parseInt(e[0]))),i=Math.max(a,Math.min(s,parseInt(e[1])));if(!isNaN(t)&&!isNaN(i)){for(;t!==i;)o.push(t),t=t===s?a:++t;o.push(t)}return o}for(let e=0;e<t.length;e++){const i=t[e];"number"!=typeof i||isNaN(i)?"string"==typeof i?o=l(i.split("-").map((e=>parseInt(e)))):Array.isArray(i)&&(o=l(i)):o.push(Math.max(a,Math.min(s,parseInt(i))))}return o.length===r&&(o.pop(),n.warn(n.localize("invalidNonworkingRange",{elementType:n.nodeName.toLowerCase(),property:i?"nonworkingHours":"nonworkingDays"}))),o}});