
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-scheduler",class extends Smart.ScrollViewer{static get properties(){return{available:{value:[],type:"array"},autoHeightAllDayCells:{value:!1,type:"boolean"},autoScrollStep:{value:30,type:"number"},colorScheme:{value:["#D50000","#E67C73","#F4511E","#F6BF26","#33B679","#0B8043","#039BE5","#3F51B5","#7986CB","#8E24AA","#616161",""],type:"array"},currentTimeIndicator:{value:!1,type:"boolean"},currentTimeIndicatorInterval:{value:1,validator:"_currentTimeIndicatorIntervalValidator",type:"number"},contextMenuDataSource:{value:null,type:"any",reflectToAttribute:!1},contextMenuClipboardActions:{value:!1,type:"boolean"},eventTemplate:{value:null,type:"any",reflectToAttribute:!1},eventCollectorTemplate:{value:null,type:"any"},eventRenderMode:{allowedValues:["classic","modern"],value:"modern",type:"string"},eventTooltipTemplate:{value:null,type:"any"},cellTemplate:{value:null,type:"any",reflectToAttribute:!1},dateCurrent:{value:new Date,type:"any",validator:"_dateValidator"},dataExport:{value:{header:{value:!0,type:"boolean"},columns:{value:[],type:"array"},style:{value:null,type:"object"},fileName:{value:"smartScheduler",type:"string?"},pageOrientation:{value:"portrait",type:"string"}},type:"object"},dataSource:{value:[],type:"any",reflectToAttribute:!1},dateSelectorFormatFunction:{value:null,reflectToAttribute:!1,type:"function?"},dayFormat:{value:"numeric",allowedValues:["2-digit","numeric"],type:"string"},disableAutoScroll:{value:!1,type:"boolean"},disableDrag:{value:!1,type:"boolean"},disableDrop:{value:!1,type:"boolean"},disableResize:{value:!1,type:"boolean"},disableSelection:{value:!1,type:"boolean"},disableWindowEditor:{value:!1,type:"boolean"},disableContextMenu:{value:!1,type:"boolean"},disableEventMenu:{value:!1,type:"boolean"},disableViewMenu:{value:!1,type:"boolean"},disableDateMenu:{value:!1,type:"boolean"},dragFeedbackFormatFunction:{value:null,type:"function?",reflectToAttribute:!1},dragOffset:{value:[10,10],type:"array"},filterable:{value:!1,type:"boolean"},filter:{value:null,type:"any"},filterMode:{value:"equals",allowedValues:["contains","containsIgnoreCase","doesNotContain","doesNotContainIgnoreCase","equals","equalsIgnoreCase","startsWith","startsWithIgnoreCase","endsWith","endsWithIgnoreCase"],type:"string"},firstDayOfWeek:{value:0,type:"number",defaultValue:0,validator:"_firstDayOfWeekValidator"},footerTemplate:{value:null,type:"any",reflectToAttribute:!1},groupByDate:{value:!1,type:"boolean"},groupOrientation:{allowedValues:["horizontal","vertical"],value:"horizontal",type:"string"},groupTemplate:{value:null,type:"any",reflectToAttribute:!1},groups:{value:[],type:"array"},hourEnd:{value:23,type:"number",validator:"_hourValidator"},hourStart:{value:0,type:"number",validator:"_hourValidator"},hourFormat:{value:"numeric",allowedValues:["numeric","2-digit"],type:"string"},headerTemplate:{value:null,type:"any",reflectToAttribute:!1},headerDatePosition:{value:"near",allowedValues:["near","far"],type:"string"},headerNavigationStyle:{value:"flat",allowedValues:["flat","raised"],type:"string"},headerViewPosition:{value:"far",allowedValues:["near","far"],type:"string"},hideAllDay:{value:!1,type:"boolean"},hideNonworkingWeekdays:{value:!1,type:"boolean"},hideOtherMonthDays:{value:!1,type:"boolean"},hideTodayButton:{value:!1,type:"boolean"},hideViewMenuCheckableItems:{value:!1,type:"boolean"},hideWeekend:{value:!1,type:"boolean"},legendLocation:{allowedValues:["header","footer"],value:"footer",type:"string"},legendPosition:{allowedValues:["near","far"],value:"near",type:"string"},legendLayout:{allowedValues:["auto","","menu"],value:"auto",type:"string"},legendLayoutMenuBreakpoint:{value:10,type:"number"},max:{value:new Date(2100,0,1),type:"any",validator:"_dateValidator"},maxEventsPerCell:{value:null,type:"number?"},min:{value:new Date(1900,0,1),type:"any",validator:"_dateValidator"},messages:{extend:!0,value:{en:{invalidValue:"{{elementType}}: Invalid {{property}} value. {{property}} should be of type {{typeOne}} or {{typeTwo}}.",invalidTimeZone:"{{elementType}}: Invalid timeZone value. TimeZone should be the id of an allowed timeZone value.",incorrectArgument:"{{elementType}}: Incorrect argument {{argumentName}} in method {{methodName}}.",exceptionExists:"{{elementType}}: Trying to add an exception via {{methodName}} that already exists. Cannot have duplicate exception of the same event on same date.",noId:"smartScheduler requires an id in order to save/load/clear a state.",agenda:"Agenda",agendaPlaceholder:"No events to display",day:"Day",week:"Week",month:"Month",allDay:"All Day",timelineDay:"Timeline Day",timelineWeek:"Timeline Week",timelineMonth:"Timeline Month",newEvent:"New Event",ok:"Ok",cancel:"Cancel",delete:"Delete",label:"Label",dateStart:"Start Date",dateEnd:"End Date",repeat:"Repeat",description:"Description",repeatFreq:"Repeat",repeatInterval:"Repeat Every",repeatOn:"Repeat On",repeatEnd:"End Repeat",repeatEndOption:"Never",repeatEndOnOption:"On",repeatEndAfterOption:"After",repeatEndAfter:"occurrence(s)",hidden:"Hidden",hourly:"Hourly",daily:"Daily",weekly:"Weekly",monthly:"Monthly",yearly:"Yearly",repeatConfirm:"Do you want to edit only the current event or the whole series ?",repeatConfirmLabel:"Edit Repeating Event",create:"Create new",edit:"Edit",cut:"Cut",copy:"Copy",paste:"Paste",editEvent:"Edit event",editSeries:"Edit series",eventException:"Event Exception",collector:"more",repeatEveryHour:"hours",repeatEveryDay:"days",repeatEveryWeek:"weeks",repeatEveryMonth:"months",repeatEveryYear:"years",backgroundColor:"Background Color",status:"Status",resources:"Resources",selectPlaceholder:"Select...",none:"None",free:"Free",busy:"Busy",tentative:"Tentative",outOfOffice:"Out of Office",exceptions:"Exceptions",resetExceptions:"Reset Exceptions",notifications:"Notification(s)",notificationMessage:"is starting on",today:"Today",agendaShortcut:"A",dayShortcut:"D",weekShortcut:"W",monthShortcut:"M",timelineDayShortcut:"T+D",timelineWeekShortcut:"T+W",timelineMonthShortcut:"T+M",showWeekends:"Show weekends",beforeAt:"before at",days:"days",weeks:"weeks",placeholder:"Add notification",placeholderLink:"Add video conferencing",placeholderSetLink:"Set video conferencing link",invalidConferenceLink:"Invalid video conference link.",now:"Now",dateTabLabel:"DATE",timeTabLabel:"TIME",hours:"Hours",minutes:"Minutes",am:"am",pm:"pm",loadingIndicatorPlaceholder:"Loading...",duplicate:"Copy",deleteConfirm:"Do you want to delete only the current event or the whole repeating series ?",deleteConfirmLabel:"Delete Repeating Event",deleteConfirmEvent:"Delete Event",deleteConfirmSeries:"Delete Series",joinWith:"Join with {{value}}",join:"Join the meeting"}},type:"object"},minuteFormat:{value:"2-digit",allowedValues:["numeric","2-digit"],type:"string"},monthFormat:{value:"long",allowedValues:["2-digit","numeric","long","short","narrow"],type:"string"},mouseWheelStep:{value:50,type:"number"},nonworkingDays:{value:[],type:"array",validator:"_nonworkingDayValidator"},nonworkingHours:{value:[],type:"array",validator:"_nonworkingTimeValidator"},notificationInterval:{value:60,validator:"_currentTimeIndicatorIntervalValidator",type:"number"},resizeHandlesVisibility:{allowedValues:["auto","hidden","visible"],value:"auto",type:"string"},resizeInterval:{value:0,type:"number"},resources:{value:[],type:"any",reflectToAttribute:!1},restrictedDates:{value:[],type:"array",validator:"_datesValidator"},restricted:{value:[],type:"array"},restrictedHours:{value:[],type:"array",validator:"_nonworkingTimeValidator"},scrollButtonsPosition:{value:"near",allowedValues:["near","far","both"],type:"string"},shadeUntilCurrentTime:{value:!1,type:"boolean"},showLegend:{value:!1,type:"boolean"},sortBy:{value:null,type:"string?"},sortFunction:{value:null,type:"function?"},sortOrder:{allowedValues:["asc","desc","custom"],value:"asc",type:"string"},spinButtonsDelay:{value:80,type:"number"},spinButtonsInitialDelay:{value:0,type:"number"},statuses:{value:[{label:"None",value:void 0},{label:"Free",value:"free"},{label:"Tentative",value:"tentative"},{label:"Busy",value:"busy"},{label:"Out of Office",value:"outOfOffice"}],type:"array"},timelineHeaderFormatFunction:{value:null,type:"function?",reflectToAttribute:!1},timelineDayScale:{value:"hour",allowedValues:["hour","halfHour","quarterHour","tenMinutes","fiveMinutes"],type:"string"},timeRulerTicks:{value:!1,type:"boolean"},timeZone:{value:"local",type:"string",validator:"_timeZoneValidator"},timeZones:{value:[],type:"array",validator:"_timeZonesValidator"},tooltipDelay:{value:0,type:"number"},tooltipOffset:{value:[],type:"array"},undoRedoSteps:{value:100,type:"number"},view:{value:"day",type:"string",validator:"_viewValidator"},viewType:{allowedValues:["agenda","day","week","month","timelineDay","timelineWeek","timelineMonth"],defaultReflectToAttribute:!0,value:"day",type:"string",validator:"_viewTypeValidator"},views:{value:["day","week","month"],type:"array",validator:"_viewsValidator"},viewSelectorType:{allowedValues:["auto","tabs","menu"],value:"menu",type:"string"},viewStartDay:{value:"firstDayOfWeek",type:"string",allowedValues:["dateCurrent","firstDayOfWeek"]},weekdayFormat:{value:"short",allowedValues:["long","short","narrow"],type:"string"},yearFormat:{value:"numeric",allowedValues:["2-digit","numeric"],type:"string"},windowCustomizationFunction:{value:null,reflectToAttribute:!1,type:"function?"}}}template(){return'<div id="container" role="presentation">\n                    <div id="header" class="smart-scheduler-header" role="heading" aria-level="1">\n                        <div id="dateSelectorContainer" class="smart-scheduler-date-nav" role="presentation">\n                            <smart-button today id="todayDate" right-to-left="[[rightToLeft]]" class="smart-scheduler-nav"></smart-button>\n                            <smart-repeat-button prev id="previousDate" initial-delay="[[spinButtonsInitialDelay]]" delay="[[spinButtonsDelay]]"\n                             aria-label="Previous date" class="smart-scheduler-nav"></smart-repeat-button>\n                             <smart-repeat-button next id="nextDate" initial-delay="[[spinButtonsInitialDelay]]" delay="[[spinButtonsDelay]]"\n                              aria-label="Next date" class="smart-scheduler-nav"></smart-repeat-button>\n                            <smart-button current id="currentDate" right-to-left="[[rightToLeft]]" class="smart-scheduler-nav"></smart-button>\n                        </div>\n                        <div id="viewSelectorContainer" class="smart-scheduler-view-nav" role="presentation">\n                            <div id="viewItemsContainer" class="smart-scheduler-items-container" role="listbox" aria-label="View Items"></div>\n                            <smart-button id="viewItemsButton" class="smart-scheduler-view-items-button smart-visibility-hidden"\n                            aria-label="View Selector DropDown" right-to-left="[[rightToLeft]]"></smart-button>\n                        </div>\n                    </div>\n                    <div class="smart-scheduler-view-container" id="viewContent" role="presentation">\n                        <div id="timeline" class="smart-scheduler-view">\n                                <div id="timelineHeaderHorizontal" class="smart-scheduler-view-header-horizontal" role="rowgroup">\n                                    <div class="smart-scheduler-view-time-container" id="timelineViewCellsContainer" role="row">\n                                        <div class="smart-scheduler-view-label-container" id="timelineViewCellsLabelContainer" role="presentation"></div>\n                                        <div class="smart-scheduler-view-header-horizontal-content" id="timelineHeaderHorizontalContent" role="presentation">\n                                            <div class="smart-scheduler-view-details" role="row"></div>\n                                            <div class="smart-scheduler-view-time" role="row">\n                                                <div class="smart-scheduler-cells" role="presentation"></div>\n                                            </div>\n                                        </div>\n                                    </div>\n                                    <div class="smart-scheduler-view-all-day" id="timelineViewAllDay" role="row">\n                                        <div class="smart-scheduler-view-all-day-label-container" id="timelineAllDayLabelContainer" role="presentation">\n                                            <div class="smart-scheduler-view-all-day-label" id="timelineViewAllDaylabel" role="presentation"></div>\n                                            <div class="smart-scheduler-time-zone-container" id="timelineTimeZoneLabelContainer"></div>\n                                        </div>\n                                        <div class="smart-scheduler-view-all-day-content" id="timelineViewAllDayContent" role="presentation">\n                                            <div class="smart-scheduler-cells-container" id="timelineViewAllDayCellsContainer" role="row"></div>\n                                            <div class="smart-scheduler-events-container" id="allDayEventsContainer" role="menu"></div>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div id="timelineHeaderVertical" class="smart-scheduler-view-header-vertical" role="rowgroup">\n                                    <div class="smart-scheduler-view-header-vertical-content" id="timelineHeaderVerticalContent" role="presentation">\n                                        <div class="smart-scheduler-view-time" role="row">\n                                            <div class="smart-scheduler-cells" role="presentation"></div>\n                                        </div>\n                                    </div>\n                                </div>\n                                <div id="timelineContainer" class="smart-scheduler-scrollable-container" role="rowgroup">\n                                    <div id="timelineContent" class="smart-scheduler-content" role="presentation">\n                                        <div id="timelineCellsContainer" class="smart-scheduler-cells-container" role="presentation"></div>\n                                        <div id="timelineEventsContainer" class="smart-scheduler-events-container" role="menu"></div>\n                                        <div id="timelineIndicatorsContainer" class="smart-scheduler-indicators-container" role="presentation"></div>\n                                    </div>\n                                </div>\n                        </div>\n                        <smart-scroll-bar wait id="verticalScrollBar" class="smart-scheduler-view-scroll-bar" orientation="vertical"\n                        right-to-left="[[rightToLeft]]" aria-controls="[[id]]" animation="[[animation]]"></smart-scroll-bar>\n                        <smart-scroll-bar wait id="horizontalScrollBar" class="smart-scheduler-view-scroll-bar"\n                        right-to-left="[[rightToLeft]]" aria-controls="[[id]]" animation="[[animation]]"></smart-scroll-bar>\n                    </div>\n                    <div id="footer" class="smart-scheduler-footer"></div>\n                    <smart-tooltip id="tooltip" class="smart-scheduler-tooltip" role="presentation" position="auto" arrow open-mode="manual"\n                        right-to-left="[[rightToLeft]]"  delay="[[tooltipDelay]]" offset="[[tooltipOffset]]"></smart-tooltip>\n                </div>'}static get listeners(){return{down:"_downHandler","document.move":"_documentMoveHandler","document.up":"_documentUpHandler","document.dragstart":"_dragStartHandler","container.click":"_containerClickHandler","container.contextmenu":"_containerContextMenuHandler","container.wheel":"_mouseWheelHandler","horizontalScrollBar.change":"_horizontalScrollbarHandler","verticalScrollBar.change":"_verticalScrollbarHandler",keydown:"_keyDownHandler",keyup:"_keyUpHandler",move:"_moveHandler",dragover:"_dragoverHandler",drop:"_dropHandler",resize:"_resizeEventHandler","tooltip.open":"_tooltipVisibilityHandler","tooltip.opening":"_tooltipVisibilityHandler","tooltip.closing":"_tooltipVisibilityHandler","tooltip.close":"_tooltipVisibilityHandler","tooltip.change":"_tooltipChangeHandler","tooltip.click":"_tooltipClickHandler","tooltip.keydown":"_tooltipKeyDownHandler","tooltip.keyup":"_tooltipKeyUpHandler","tooltip.down":"_tooltipDownHandler","tooltip.contextmenu":"_tooltipContextMenuHandler","timeline.focus":"_timelineFocusHandler","timeline.focusin":"_timelineFocusHandler","timeline.focusout":"_timelineFocusHandler"}}static get styleUrls(){return["smart.scheduler.css"]}static get requires(){return{"Smart.Window":"smart.window.js","Smart.Calendar":"smart.calendar.js","Smart.Tooltip":"smart.tooltip.js"}}propertyChangedHandler(e,t,n){super.propertyChangedHandler(e,t,n);const i=this;switch(e){case"contextMenuClipboardActions":{const e=i.$.tooltip;e.visible&&e.contains(i._contextList)&&i._getContextMenu(e.selector);break}case"dataSource":i._handleDataAdapter(),i._createEvents(),i._createTimeline(),i.closeWindow();break;case"disabled":i._setFocusable(),i._refreshEvents();break;case"disableSelection":i._handleCellSelection();break;case"disableContextMenu":case"disableDateMenu":case"disableEventMenu":case"disableViewMenu":i.$.tooltip.close();break;case"disableWindowEditor":i.closeWindow();break;case"currentTimeIndicator":case"shadeUntilCurrentTime":i._setCurrentTimeIndicators();break;case"eventRenderMode":i._refreshEvents();break;case"filter":case"filterable":case"filterMode":if("filter"===e){const e=i._legend;e&&i.$.container.contains(e)&&e.querySelectorAll(".smart-scheduler-legend-res-item").forEach((e=>{e.removeAttribute("unselected"),e.setAttribute("aria-selected",!0)})),delete i._eventsBetween,i._createTimeline()}else i._refreshTimelineEvents();break;case"autoHeightAllDayCells":case"firstDayOfWeek":case"viewStartDay":case"max":case"min":i._calendar&&(i._calendar[e]=n),i._createTimeline(),i._refreshDateNavButtons();break;case"maxEventsPerCell":i._refreshEvents();break;case"hideAllDay":["day","week"].indexOf(i.viewType)>-1&&i._createTimeline();break;case"hideOtherMonthDays":i._refreshTimelineEvents();break;case"hideWeekend":case"hideNonworkingWeekdays":i._checkHideWekendItem(),i.viewType.toLowerCase().indexOf("day")<0&&i._createTimeline();break;case"hideViewMenuCheckableItems":i._refreshViewSelector();break;case"timeZone":i._events.forEach((e=>i._setEventTimeZone(e,t))),i._createTimeline();break;case"timeZones":i._createTimeline();break;case"dateCurrent":case"groups":case"groupOrientation":case"hourStart":case"hourEnd":case"nonworkingDays":case"nonworkingHours":case"timelineDayScale":case"resources":case"rightToLeft":{const t=i.$.schedulerWindow,r=i.$.confirmSchedulerWindow;if([i.$.toast,i.$.tooltip,i._calendar,i._list,t,r].forEach((t=>t?t[e]=n:void 0)),t&&t.opened){const i=t.querySelectorAll(".smart-element[event-editor]"),r=n?"left":"right";for(let t=0;t<i.length;t++){const a=i[t];a[e]=n,a.calendarButtonPosition?a.calendarButtonPosition=r:"none"!==a.dropDownButtonPosition&&(a.dropDownButtonPosition=r)}}"resources"===e&&i._setLegend(),i._createTimeline(),i._refreshDateSelector();break}case"sortBy":case"sortOrder":case"sortFunction":i._createTimeline();break;case"undoRedoSteps":delete i._undoRedoHistory;break;case"view":i._handleViewSelection(),i._createTimeline(),i._refreshDateSelector(),i._scrollToView(),i.$.fireEvent("viewChange",{oldValue:t,value:n});break;case"views":i._refreshViewSelector();break;case"viewSelectorType":i._setHeader();break;case"headerTemplate":i._setHeader(),i._createTimeline();break;case"footerTemplate":i._setFooter(),i._createTimeline();break;case"cellTemplate":case"groupTemplate":i._templates&&delete i._templates[e],i._createTimeline();break;case"unfocusable":i._setFocusable(),i._refreshEvents();break;case"hourFormat":case"minuteFormat":case"dayFormat":case"monthFormat":case"weekdayFormat":case"yearFormat":case"dateSelectorFormatFunction":case"timelineHeaderFormatFunction":case"messages":case"locale":{i._createTimeline(),i._setHeader(),i._calendar&&"locale"===e&&(i._calendar[e]=n);const t=i.$.schedulerWindow,r=i.$.confirmSchedulerWindow;if(t&&t.opened){const e=t._target;t.close(),i._openWindow(e.event,e.originalTarget)}else if(r&&r.opened){const e=r._target;r.close(),i._openWindow(e.event,e.originalTarget)}break}case"legendLocation":case"showLegend":i._setLegend(),i._createTimeline();break;case"restrictedDates":case"restrictedHours":delete i._eventsBetween,i._createTimeline();break;case"windowCustomizationFunction":{const e=i.$.schedulerWindow||i.$.confirmSchedulerWindow;if(!e)return;if(null===n)e.clear();else if(e.opened){const t=e===i.$.confirmSchedulerWindow?"confirm":"";i.windowCustomizationFunction(e,t,i._cloneObject(e._target))}break}}}attached(){const e=this;super.attached(),e._scrollView||(e._scrollView=new Smart.Utilities.Scroll(e.$.timeline,e.$.horizontalScrollBar,e.$.verticalScrollBar));const t=[e.$.schedulerWindow,e.$.confirmSchedulerWindow],n=e.$.tooltip;n.visible&&e.getShadowRootOrBody().appendChild(n);for(let n=0;n<t.length;n++){const i=t[n];if(i&&i.opened){const t=e.$schedulerWindow;e._handleModal(!0),t.listen("open",e._windowOpenHandler.bind(e)),t.listen("close",e._windowCloseHandler.bind(e)),t.listen("closing",e._windowClosingHandler.bind(e)),t.listen("click",e._windowClickHandler.bind(e)),t.listen("change",e._windowChangeHandler.bind(e)),t.listen("keydown",e._windowKeyDownHandler.bind(e)),i.hasAnimation&&i.listen("transitionend",e._windowTransitionendHandler.bind(e)),e.getShadowRootOrBody().appendChild(i)}}e.$.container.contains(e.$.toast)||e._checkNotifications(!0)}detached(){const e=this;super.detached(),e._scrollView&&(e._scrollView.unlisten(),e._scrollView.disableSwipeScroll=!1,delete e._scrollView),e._touchmoveInside=!1,delete e._dragDetails,Smart.Scheduler.schedulerStart===e&&(Smart.Scheduler.feedback.remove(),delete Smart.Scheduler.schedulerStart,delete Smart.Scheduler.hoveredCell,delete Smart.Scheduler.hoveredScheduler,delete Smart.Scheduler.feedback);const t=[e.$.schedulerWindow,e.$.confirmSchedulerWindow],n=e.$.tooltip;e.$.container.contains(n)||e.$.container.appendChild(n),e._removeToast();for(let n=0;n<t.length;n++){const i=t[n];if(e._handleModal(),i){i.remove();const t=i===e.$.schedulerWindow?e.$schedulerWindow:e.$confirmSchedulerWindow;t.unlisten("open"),t.unlisten("close"),t.unlisten("closing"),t.unlisten("click"),t.unlisten("change"),t.unlisten("keydown"),t.unlisten("transitionend")}}}ready(){this._customScrollView=!0,super.ready()}render(){const e=this,t=e.viewType.toLowerCase();if(0!==e.firstDayOfWeek&&t.indexOf("week")>-1&&e.dateCurrent&&e.dateCurrent.getDay()!==e.firstDayOfWeek){const t=e.dateCurrent.getDay()-e.firstDayOfWeek;e.dateCurrent=e.dateCurrent.setDate(e.dateCurrent.getDate()-e.dateCurrent.getDay()+e.firstDayOfWeek-(t>0?0:7))}e._isViewUpdated=!0,e._setViewType(e.view),delete e._isViewUpdated,e.hasAttribute("role")||e.setAttribute("role","grid"),window.rrule&&window.rrule.RRule||e.error(e.localize("missingReference",{elementType:e.nodeName.toLowerCase(),files:"rrule.min.js"})),e._rRule=window.rrule.RRule,Smart.Utilities.Core.isMobile&&(e._isMobile=!0,e.$.timeline.setAttribute("mobile","")),e._handleDataAdapter(),e._setFocusable(),e._setScrollBars(),e._setHeader(),e._setFooter(),e._createEvents(),e._createTimeline(),e.checkLicense(),super.render()}get events(){const e=this,t=e._events;return e.isReady&&t&&t.length?t.map((t=>e._cloneObject(t))):[]}addEvent(e){this.insertEvent(e)}containsEvent(e){return!!this._containsEvent(e)}clearState(){const e=this;e.id?window.localStorage.removeItem("smartScheduler"+e.id):e.warn(e.localize("noId"))}getState(){const e=this,t=e._events||[];return{dateCurrent:e.dateCurrent.toISOString(),dataSource:JSON.parse(JSON.stringify(t.map((t=>e._cloneObject(t,!0))))),timeZone:e.timeZone}}loadState(e){const t=this;if(!e){if(!t.id)return;e=JSON.parse(window.localStorage.getItem("smartScheduler"+t.id))}if(!e)return;let n=JSON.parse(JSON.stringify(e.dataSource)),i=new Date(e.dateCurrent),r=e.timeZone;i instanceof Date&&!isNaN(i.getTime())&&(t.set("dateCurrent",i),t._refreshDateSelector()),Array.isArray(n)&&(t.set("dataSource",n),t._createEvents(void 0,r),t._createTimeline())}saveState(e){const t=this;t.id?(e||(e=t.getState()),window.localStorage.setItem("smartScheduler"+t.id,JSON.stringify(e))):t.warn(t.localize("noId"))}createEvent(e,t,n,i,r,a=""){const l={label:e,value:t,id:t,dateStart:n,dateEnd:i,description:a,allDay:r};this.addEvent(l)}insertEvent(e,t){const n=this,i=n._events;if(i.indexOf(e)>-1||n._containsEvent(e))return;const r=n._createEvents(Array.isArray(e)?e:[e])[0];if(!r)return;const a=n._cloneObject(r);n.$.fireEvent("itemChanging",{type:"inserting",item:a}).defaultPrevented||("number"==typeof t?i.splice(Math.max(0,Math.min(i.length,t)),0,r):i.push(r),n._isUpdating||(n._refreshTimelineEvents(),n._updateUndoRedo(void 0,n._cloneObject(r),"itemInsert"),n.$.fireEvent("itemInsert",{item:a}),n.$.fireEvent("itemChange",{type:"insert",item:a})))}updateEvent(e,t){const n=this,i=n._events;if(!(e="number"==typeof e&&i?i[e]:n._containsEvent(e)))return;const r=n._cloneObject(e);if(!n.$.fireEvent("itemChanging",{type:"updating",item:r}).defaultPrevented){for(let n in t)e[n]=t[n];e.dateStart=n._dateValidator(void 0,e.dateStart),e.dateEnd=n._dateValidator(void 0,e.dateEnd),e.dateEnd=new Date(Math.max(e.dateStart.getTime(),e.dateEnd.getTime())),n._isUpdating||(n._refreshTimelineEvents(),n.$.fireEvent("itemUpdate",{item:r}),n.$.fireEvent("itemChange",{type:"update",item:r}))}}removeEvent(e){const t=this,n=t._events;if(!(e="number"==typeof e&&n?n[e]:t._containsEvent(e)))return;const i=t._cloneObject(e);t.$.fireEvent("itemChanging",{type:"removing",item:i}).defaultPrevented||(n.splice(n.indexOf(e),1),t._isUpdating||(t._refreshTimelineEvents(),t._updateUndoRedo(t._cloneObject(e),void 0,"itemRemove"),t.$.fireEvent("itemRemove",{item:i}),t.$.fireEvent("itemChange",{type:"remove",item:i})))}getEventExceptions(e){const t=this,n=t._events;if(!(e="number"==typeof e&&n?n[e]:t._containsEvent(e))||!e.repeat)return[];const i=e.repeat.exceptions;return i&&i.length?i:[]}addEventException(e,t){const n=this,i=n._events;if(!(e="number"==typeof e&&i?i[e]:n._containsEvent(e))||!e.repeat)return[];if(!(t&&"object"==typeof t&&t.date instanceof Date))return;const r=t.date;let a=e.repeat.exceptions;a||(a=e.repeat.exceptions=[]),delete t.repeat;for(let e=0,t=a.length;e<t;e+=1)if(a[e].date.getTime()===r.getTime())return void n.error(n.localize("exceptionExists",{elementType:n.nodeName.toLowerCase(),elementMethod:"addEventException"}));n.$.fireEvent("itemChanging",{type:"exceptionInserting",item:n._cloneObject(e)}).defaultPrevented||(a.push(t),n._isUpdating||(n._refreshTimelineEvents(),n.$.fireEvent("itemChange",{type:"exceptionInsert",item:n._cloneObject(e)})))}updateEventException(e,t,n){const i=this,r=i._events;if(!(e="number"==typeof e&&r?r[e]:i._containsEvent(e))||!e.repeat||null==t||!n||"object"!=typeof n)return[];const a=e.repeat.exceptions;if(!a||!a.length)return[];let l;if("number"==typeof t&&(l=a.indexOf(t)),!l){const e=t instanceof Date?t:new Date(n.date);for(let n=0,i=a.length;n<i;n+=1){const i=a[n];if(n===t&&(l=i),i.id===t||i.date.getTime()===e.getTime()){l=i;break}}}if(l){if(i.$.fireEvent("itemChanging",{type:"exceptionUpdating",item:i._cloneObject(e)}).defaultPrevented)return;for(let e in n)"date"!==e&&"repeat"!==e&&"$"!==e&&(l[e]="dateStart"===e||"dateEnd"===e?i._dateValidator(void 0,n[e]):n[e]);if(l.dateEnd=new Date(Math.max(l.dateStart.getTime(),l.dateEnd.getTime())),i._isUpdating)return;i._refreshTimelineEvents(),i.$.fireEvent("itemChange",{type:"exceptionUpdate",item:i._cloneObject(e)})}}removeEventException(e,t){const n=this,i=n._events;if(!(e="number"==typeof e&&i?i[e]:n._containsEvent(e))||!e.repeat)return;const r=e.repeat.exceptions;if(!r||!r.length)return;let a=r.indexOf(t);if(a<0){const e=new Date(t);for(let n=0,i=r.length;n<i;n+=1){const i=r[n];if(n===t&&(a=n),i.id===t||i.date.getTime()===e.getTime()){a=n;break}}}if(a>-1){if(n.$.fireEvent("itemChanging",{type:"exceptionRemoving",item:n._cloneObject(e)}).defaultPrevented)return;if(r.splice(a,1),r.length||delete e.repeat.exceptions,n._isUpdating)return;n._refreshTimelineEvents(),n.$.fireEvent("itemChange",{type:"exceptionRemove",item:n._cloneObject(e)})}}exportData(e,t){const n=this;if(!Smart.Utilities.DataExporter)return void n.error(n.localize("missingReference",{elementType:n.nodeName.toLowerCase(),methodName:"exportData",files:"smart.export.js"}));try{new JSZip}catch(e){return void n.error(n.localize("missingReference",{elementType:n.nodeName.toLowerCase(),methodName:"exportData",files:"jszip.min.js"}))}if("pdf"===e&&!window.pdfMake)return void n.error(n.localize("missingReference",{elementType:n.nodeName.toLowerCase(),methodName:"exportData",files:"pdfMake.min.js"}));const i=n._events;if(!i||!i.length)return;if("ical"===(e+"").toLowerCase())return n._exportToICal(t);const r=new Smart.Utilities.DataExporter({exportHeader:n.dataExport.header,pageOrientation:n.dataExport.pageOrientation,style:n.dataExport.style}),a=n._getExportRecord();let l={columns:[]};for(let e in a)l.columns.push({label:a[e],dataField:e});r.header=l,n._setExportStyles(r,e);let o=[];for(let e=0;e<i.length;e++)o.push(n._getExportRecord(i[e]));return r.exportData(o,e,n.dataExport.fileName,t)}getDataSource(){const e=this,t=e._events;return t&&t.length?JSON.parse(JSON.stringify(t.map((t=>e._cloneObject(t,!0))))):""}getResources(){const e=this.resources;return e&&e.length?JSON.parse(JSON.stringify(e)):""}print(){const e=this,t=e.dataExport.fileName;e.dataExport.fileName=null;const n=e.exportData("html"),i=window.open("","","width=800,height=500"),r=i.document.open(),a='<!DOCTYPE html><html><head><meta charset="utf-8" /><title>'+t+"</title></head><body>"+n+"</body></html>";try{r.write(a),r.close(),setTimeout((function(){i.print(),i.close()}),100)}catch(e){}e.dataExport.fileName=t}refresh(e){const t=this;e?t.isRendered&&t._createTimeline():t._refresh()}beginUpdate(){const e=this;e._isUpdating||(e._isUpdating=!0,e.$.fireEvent("beginUpdate"))}endUpdate(){const e=this;e._isUpdating&&(e._refreshTimelineEvents(),e.$.fireEvent("endUpdate"))}addView(e,t,n,i,r,a){const l=this,o={label:t,type:e,value:n,hideWeekend:i,hideNonworkingWeekdays:r,additionalDays:a};l.views.push(o),l._refreshViewSelector(),l.refresh()}setView(e){const t=this,n=t.view,i=t.views.find((t=>t.value&&t.value===e));e!==n&&(t.set("view",e),e=i?i.type:e,t._createTimeline(),t._refreshDateSelector(),t._checkHideWekendItem(),t._scrollToView(i),t._handleViewSelection(),t.$.fireEvent("viewChange",{oldValue:n,value:e}))}scrollToDate(e,t,n){const i=this;if(e instanceof Date)e=new Date(e);else{if(e instanceof HTMLElement&&(!e.classList.contains("smart-scheduler-cell")||!i.$.timeline.contains(e)))return;if("object"==typeof e){const t=new Date(i.dateCurrent);e.year=void 0!==e.year?e.year:t.getFullYear(),e.month=void 0!==e.month?e.month:t.getMonth(),e.date=void 0!==e.date?e.date:t.getDate(),e=new Date(e.year,e.month,e.date,e.hours,e.getMinutes)}else if("string"==typeof e){if(e.indexOf("Date")>=0){e=(e=e.replace("new Date(","").replace(")","")).split(", ");let t="";for(let n=0;n<e.length;n++)t+=e[n],n<2?t+="-":2===n?t+=" ":n<e.length-1&&(t+=":");e=t}e=new Date(e)}}e&&!isNaN(e.getTime())&&i._scrollTo(e,t,n)}scrollToEvent(e){const t=this,n=t._events;(e="number"==typeof e&&n?n[e]:t._containsEvent(e))&&t._scrollTo(e)}openNotification(e,t){const n=this;if(!(e+=""))return;n._setToast();const i=n.$.toast;if(i){if("object"==typeof t)for(let e in t)i[e]=t[e];n._appendToast(),i.open(e)}}closeNotifications(){this._checkNotifications(!0)}openWindow(e){const t=this;let n=e;if(void 0===e||"object"==typeof e){if(e=t._containsEvent(e))return void t._openWindow(e);e=new Date(t.dateCurrent)}else if("string"==typeof e){if(n=t._events.find((t=>t.id+""===e)),n)return void t._openWindow(n);n||(n=new Date(e))}else if("number"==typeof e)return n=t._events[e],void(n&&t._openWindow(n));if(e instanceof Date){if(isNaN(e.getTime()))return;e={dateStart:new Date(t.dateCurrent)}}"object"!=typeof e||e.dateStart||(e.dateStart=new Date(t.dateCurrent)),(e=t._createEvents([e]))&&t._openWindow(e[0])}closeWindow(){const e=this.$.confirmSchedulerWindow,t=this.$.schedulerWindow;t&&(t.close(),delete t._target),e&&(e.close(),delete e._target)}occurrences(e,t=100){const n=this,i=n._events,r=n._rRule;if("number"==typeof e&&i)e=i[e];else{const t=n._containsEvent(e);t&&(e=t)}if(!e)return;const a=n._getEventRepeatOptions(e);return a?(t=parseInt(t),t=isNaN(t)?100:t,new r(a).all(((e,n)=>!(!a.count&&n===t))).map((e=>new Date(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds())))):void 0}occurrencesBetween(e,t,n){const i=this,r=i._events,a=i._rRule;if("number"==typeof e&&r)e=r[e];else{const t=i._containsEvent(e);t&&(e=t)}if(!e||isNaN(new Date(t).getTime())||isNaN(new Date(n).getTime()))return;const l=i._getEventRepeatOptions(e);return l?(t=new Date(Math.min(t.getTime(),n.getTime())),n=new Date(Math.max(t.getTime(),n.getTime())),new a(l).between(new Date(Date.UTC(...i._getDateArgs(t))),new Date(Date.UTC(...i._getDateArgs(n))),!0).map((e=>new Date(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds())))):void 0}occurrenceAfter(e,t){return this._occurrence(e,t,"after")}occurrenceBefore(e,t){return this._occurrence(e,t,"before")}getCellDateRange(e){if(e&&this.$.timelineCellsContainer.contains(e)&&e.classList.contains("smart-scheduler-cell"))return e.classList.contains("scale")&&(e=e.children[0]),this._getCellDateRange(e)}undo(e){return this._handleUndoRedo("undo",e)}redo(e){return this._handleUndoRedo("redo",e)}deleteUndoRedoHistory(){this._updateUndoRedo()}canUndo(){return this._isUndoPossible()}canRedo(){return this._isRedoPossible()}_occurrence(e,t,n){const i=this,r=i._rRule;if(!r||!e||isNaN(new Date(t).getTime()))return;const a=i._getEventRepeatOptions(e);if(!a)return;const l=new r(a)[n](new Date(Date.UTC(...i._getDateArgs(t))),!0);return l?new Date(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate(),l.getUTCHours(),l.getUTCMinutes(),l.getUTCSeconds()):void 0}openEventTooltip(e){const t=this,n=t.$.tooltip,i=t._events;if((e="number"==typeof e&&i?i[e]:t._containsEvent(e))&&n){const n=t.$.timeline.querySelectorAll(".smart-scheduler-event");for(let i=0;i<n.length;i++){const r=n[i].$?[n[i]]||0:void 0;if(r&&r.some((t=>{const n=t.$?t.$.event:void 0;return n&&(n===e||n.$&&n.$.event===e)}))){delete t._openEventMenu,t._handleTooltipContent(r[0]);break}}}}closeEventTooltip(){const e=this.$.tooltip;e.visible&&e.contains(this._eventList)&&e.close()}isEventRestricted(e){return e&&e.classList&&e.classList.contains("smart-scheduler-event")&&(e=e.$?e.$.event:void 0),!!(e&&e.dateStart instanceof Date&&e.dateEnd instanceof Date)&&this._isEventRestricted(e)}isDateRestricted(e){return e&&e.classList&&e.classList.contains("smart-scheduler-cell")&&(e=e.$&&e.$.cellObj?new Date(e.$.cellObj.time):void 0),!(!e||void 0===e.getTime||isNaN(e.getTime()))&&this._isDateRestricted(e)}isHourRestricted(e){return e&&e.classList&&e.classList.contains("smart-scheduler-cell")&&(e=e.$&&e.$.cellObj?new Date(e.$.cellObj.time):void 0),this._isHourRestricted(e)}_checkDoubleClick(e){const t=this;if(void 0===t._dblClickDetails&&(t._dblClickDetails={clicks:0}),clearTimeout(t._dblClickDetails.timeOut),e!==t._dblClickDetails.target&&(t._dblClickDetails.clicks=0),t._dblClickDetails.target=e,t._dblClickDetails.clicks++,t._dblClickDetails.timeOut=setTimeout((function(){t._dblClickDetails&&(t._dblClickDetails.clicks=0),t._openEventMenu&&(t._handleTooltipContent(t._openEventMenu),delete t._openEventMenu)}),250),2===t._dblClickDetails.clicks)return t._doubleClickHandler(e),t._dblClickDetails.clicks=0,delete t._openEventMenu,!0}_cloneObject(e,t,n){const i=this;let r={};for(let n in e){let a=e[n];if(a instanceof Date)r[n]=t?a.toISOString():new Date(a);else if("repeat"===n){if(r[n]=Object.assign({},a),r[n].exceptions){const e=r[n].exceptions=r[n].exceptions.slice();for(let t=0;t<e.length;t++)e[t]=i._cloneObject(e[t])}}else r[n]=a}return n||(delete r.$,r.repeat&&r.repeat.exceptions&&r.repeat.exceptions.forEach((e=>delete e.$))),r}_doubleClickHandler(e){const t=this;if(t.disabled||t.disableWindowEditor)return;const n=t.$.tooltip;let i=e.closest?e.closest(".smart-scheduler-cell:not(.scale)"):void 0;if(t.$.timelineContainer.contains(i)||t.$.timelineViewAllDay.contains(i))t._openWindow();else if(i=e.classList.contains("smart-scheduler-event")?e:e.closest(".smart-scheduler-event-content"),i&&(t.$.timeline.contains(i)||n.contains(i))){i=i.closest(".smart-scheduler-event");let e=i&&i.$?i.$:void 0;if(!e||e.events)return;e=e.event;const r=e.$?e.$.event:void 0,a=r&&r.repeat?r.repeat.exceptions:void 0;let l;if(a&&a.indexOf(e)>-1)l=e;else{const t=i.$;l=r?Object.assign({},e,{dateStart:t.dateStart,dateEnd:t.dateEnd}):e}n.close(),t._openWindow(l,r?i:void 0)}}_createEventFromSelection(e){const t=this;if(e||(e=t._selectedCellObj),e instanceof HTMLElement&&e.$&&(e={from:e.$.cellObj,to:e.$.cellObj}),!e||!e.from)return;const n=e.from,i=e.to;if(t.hideOtherMonthDays&&new Date(n.time).getMonth()!==new Date(t.dateCurrent).getMonth())return;const r=new Date(Math.min(n.time,i.time)),a=new Date(Math.max(n.time,i.time)),l=n.horizontal.group||n.vertical.group;!n.allDay&&t.viewType.toLowerCase().indexOf("month")<0?a.setHours(a.getHours(),a.getMinutes()+60/t._getCellsScaleCount(),0,0):a.setHours(23,59,59,999);const o={allDay:!!n.allDay,dateStart:r,dateEnd:a};if(l)for(let e in l)o[e]=l[e];return t._isEventRestricted(o)?void 0:o}_downHandler(e){const t=this,n=t.$.tooltip,i=e.originalEvent;let r=t.shadowRoot||t.isInShadowDOM?i.composedPath()[0]:i.target;if(e.stopPropagation(),0===e.button&&n.contains(t._contextList)&&r&&r.closest&&!r.closest(".smart-scheduler-nav[current]")&&!r.closest(".smart-scheduler-view-items-button")&&!n.contains(r)&&n.close(),t._dragDetails)return t._endDrag(),t._endResize(),delete t._dragDetails,clearInterval(t._scrollInterval),void delete t._scrollInterval;if(!t.$.timeline.contains(r)&&!t.$.tooltip.contains(r))return;if(t._isMobile&&(t.$.timelineContent.classList.add("hide-overlay"),r=(t.shadowRoot||document).elementFromPoint(i.pageX-window.pageXOffset,i.pageY-window.pageYOffset),t.$.timelineContent.classList.remove("hide-overlay")),!r||!r.closest)return;t._dragDetails={target:r,button:e.button,timestamp:Date.now()};const a=r.closest(".smart-scheduler-cell:not(.scale)");if(a&&a.$&&(t.$.timelineContainer.contains(a)||t.$.timelineViewAllDay.contains(a))){const n=a.$.cellObj;if(!n)return;if(t._dragDetails.timelineCellObj=Object.assign({},n),0===e.button&&t._checkDoubleClick(r))return;if(t._isMobile)return;if(0===e.button&&e.shiftKey&&t._selectedCellObj)t._handleCellSelection(t._selectedCellObj.from,n);else{if(0!==e.button&&t._isCellObjSelected(n))return;t._handleCellSelection(n)}return void(t._dragDetails.selectedCellObj=Object.assign({},t._selectedCellObj))}const l=r.closest(".smart-scheduler-event");if(l){if(0===e.button&&t._checkDoubleClick(r))return;t._dragDetails.schedulerEvent=l,t._dragDetails.coordinates={x:e.pageX,y:e.pageY},t._dragDetails.originialEvent=e,("visible"===t.resizeHandlesVisibility||t._isMobile&&"auto"===t.resizeHandlesVisibility)&&t._checkEventResizability(e)}}_dropHandler(e){const t=this,n=Smart.Scheduler.hoveredScheduler,i=Smart.Scheduler.hoveredCell,r=document.body;delete Smart.Scheduler.hoveredScheduler,delete Smart.Scheduler.hoveredCell,delete Smart.Scheduler.schedulerStart,delete Smart.Scheduler.feedback,n&&(n.removeAttribute("dragged"),clearInterval(n._scrollInterval),delete n._scrollInterval,i&&i.classList.remove("smart-scheduler-feedback")),i&&t.$.fireEvent("dropoverCell",{target:e.target,allDay:i.hasAttribute("all-day"),date:i.getAttribute("date")}),r.classList.remove("smart-dragging"),r.classList.remove("smart-dragging-disabled"),t._scrollView.disableSwipeScroll=t._touchmoveInside=!1,t._list&&(t._list.disableSwipeScroll=t._list._touchmoveInside=!1),delete t._dragDetails}_dragoverHandler(e){this._setDropTarget(e)}_documentMoveHandler(e){const t=this,n=e.originalEvent,i=t._dragDetails,r=Smart.Scheduler.schedulerStart;let a=t.shadowRoot||t.isInShadowDOM?n.composedPath()[0]:n.target;if(r)t._setDropTarget(e);else if(!i)return void t._checkEventResizability(e);if(i&&0===i.button)if(t.$.timeline.getAttribute("event-hovered"))t._handleEventResize(e);else if(t.disableDrag||!i.schedulerEvent||r){if(r===t){const n=t.dragOffset,i=Smart.Scheduler.feedback;if(!i)return;return i.parentElement||document.body.appendChild(i),t.rightToLeft?i.style.left=e.pageX-n[0]-i.offsetWidth+"px":i.style.left=e.pageX+n[0]+"px",void(i.style.top=e.pageY+n[1]+"px")}if(t._isMobile){const e=t.$.tooltip;r===t&&e.visible&&e.close()}else if(!t.disableSelection&&"agenda"!==t.viewType&&!e.shiftKey){Smart.Utilities.Core.Browser.Firefox&&(a=(t.shadowRoot||document).elementFromPoint(n.pageX-window.pageXOffset,n.pageY-window.pageYOffset));const e=i.timelineCellObj,r=t.$.timeline.contains(a)?a.closest(".smart-scheduler-cell:not(.scale)"):void 0;e&&r&&t._selectCell(e,r)}}else t._setDragStart(e)}_documentUpHandler(e){const t=this,n=e.originalEvent,i=t._dragDetails,r=n.pageX-window.pageXOffset,a=n.pageY-window.pageYOffset;let l=t.shadowRoot||t.isInShadowDOM?n.composedPath()[0]:n.target;if(t._isMobile&&(t.$.timelineContent.classList.add("hide-overlay"),l=(t.shadowRoot||document).elementFromPoint(r,a),t.$.timelineContent.classList.remove("hide-overlay")),t._upHandler(),clearInterval(t._scrollInterval),delete t._scrollInterval,i&&Smart.Scheduler.schedulerStart)return void t._endDrag(e,l);if(i&&t.hasAttribute("resized"))return void t._endResize(e);const o=t.$.tooltip;if(!o.visible||o.contains(l)||(t.shadowRoot||t).contains(l)||o.close(),l&&l.closest){if(!i){const e=t.$.schedulerWindow;return void(t.contains(l)&&l.classList.contains("smart-scheduler-window-modal")&&e&&e.focus())}{const n=l.closest(".smart-scheduler-event");if(i.schedulerEvent===n){t._handleCellSelection(),t.$.fireEvent("itemClick",{item:n,type:"event",itemObj:t._cloneObject(n.$.event)});const e=!t._isMobile||Date.now()-i.timestamp<250;!o.contains(l)&&e&&0===i.button&&(t._dblClickDetails&&0===t._dblClickDetails.clicks?(t._handleTooltipContent(n),delete t._openEventMenu):t.disableEventMenu?delete t._openEventMenu:t._openEventMenu=n)}else{delete t._openEventMenu;const n=o.selector;0!==i.button||e.shiftKey&&t._selectedCellObj||o.contains(l)&&n&&n.classList.contains("smart-scheduler-cell")||t._handleCellSelection(i.timelineCellObj,l)}}}delete t._dragDetails}_handleDataAdapter(){const e=this;if(e.dataSource&&e.dataSource instanceof Smart.DataAdapter){const t=e.querySelector(".smart-loader-container");if(t&&t.remove(),e.dataSource.url){const t=document.createElement("div");t.classList.add("smart-loader-container","smart-scheduler-loading-container"),t.innerHTML=`<span id='loadingIndicator' class='smart-scheduler-loader smart-loader'></span>\n                <span id='loadingIndicatorPlaceholder' class ='smart-loader-label'>${e.localize("loadingIndicatorPlaceholder")}</span>`,e.appendChild(t)}e.dataSource.notify((function(t){if(e.dataSource._updating)return;const n=e.querySelector(".smart-loader-container");n&&n.remove();let i=t.data,r=t.index;switch(t.action){case"add":case"insert":i=e._parseAdapterData(i.length?i:[i]),e.insertEvent(i,r);break;case"update":i=e._parseAdapterData(i.length?i:[i]),e.updateEvent(r,i);break;case"remove":case"removeLast":e.removeEvent(void 0!==r?r:e._events.length-1);break;case"bindingComplete":e.dataSource.canNotify=!1,e.dataSource.dataSource=e._parseAdapterData(e.dataSource.toArray()).filter((e=>void 0!==e)),e.dataSource.canNotify=!0,e._createEvents(),e._createTimeline(),e.closeWindow()}}))}}_parseAdapterData(e){const t=this,n=["month","agenda"].indexOf(t.viewType.toLowerCase())>-1;Array.isArray(e)||(e=Array.from(e));for(let i=0;i<e.length;i++){const r=e[i],a=r.dateStart,l=r.dateEnd;let o=[];if(!n&&a instanceof Date&&l instanceof Date&&l.getTime()-a.getTime()>=864e5&&(r.allDay=!0),r.rrule&&t._parseIcalRrule(r),r.extdate){let e=r.extdate;e.indexOf("EXDATE:")>=0&&(e=e.substring(e.indexOf("EXDATE:")+7)),e.indexOf(",")>=0?o=e.split(","):o.push(e)}if(r.reccurenceId){const n=e.find((e=>e.uid===r.uid&&!e.reccurenceId));if(!n)continue;t._parseICalReccurenceId(r,n,o),e[i]=void 0}r.alarm&&t._parseICalAlarm(r),r.categories&&t._parseICalCategories(r)}return e}_parseIcalRrule(e){const t=this,n=t._rRule;if(!n)return;const i=n.parseString(e.rrule);let r;if(i){let a;switch(n.FREQUENCIES[i.freq].toLowerCase()){case"weekly":void 0!==i.byweekday&&(a=(Array.isArray(i.byweekday)?i.byweekday:Array.from(i.byweekday)).map((e=>(e.weekday+1+7)%7)));break;case"monthly":void 0!==i.bymonthday&&(a=i.bymonthday);break;case"yearly":void 0!==i.bymonth&&void 0!==i.bymonthday&&(a={month:i.bymonth-1,date:i.bymonthday})}e.repeat={repeatFreq:n.FREQUENCIES[i.freq].toLowerCase(),repeatInterval:i.interval,repeatOn:a},i.until instanceof Date?r=new Date(Date.UTC(...t._getUTCDateArgs(i.until))):"number"==typeof i.count&&(r=i.count),void 0!==r&&(e.repeat.repeatEnd=r)}}_parseICalReccurenceId(e,t,n){const i=e.reccurenceId;if(!e)return;const r=this._cloneObject(e);delete r.repeat,r.date=(e=>{let t;e.indexOf("VALUE=DATE:")>-1&&(e=e.replace("VALUE=DATE:",""),t=!0);const n=/^(\d{4})(\d{2})(\d{2})(T(\d{2})(\d{2})(\d{2})Z)?$/.exec(e);if(!n)throw new Error("Invalid DATE value: "+e);return t?new Date(n[1],n[2]-1,n[3],0,0,0,0):new Date(Date.UTC(n[1],n[2]-1,n[3],n[5]||0,n[6]||0,n[7]||0))})(i),n.indexOf(r.date)>-1&&(r.hidden=!0),t.repeat&&(t.repeat.exceptions||(t.repeat.exceptions=[]),t.repeat.exceptions.push(r))}_parseICalAlarm(e){if(!e)return;const t=JSON.parse(e.alarm),n=e.dateStart.getTime();if(Array.isArray(t)){let i=[],r=/^(-)?P(\d+)DT(\d{1,2})H(\d{1,2})M(\d{1,2})S$/;for(let e=0;e<t.length;e++){const a=t[e],l=a.TRIGGER;if(r.test(l)){const e=r.exec(l);if(!e)continue;let t,o=parseInt(e[2]),s="-"===e[1]?-1:1,d=new Date(n);d.setDate(d.getDate()+s*o),d=new Date(d.getTime()+s*(1e3*(e[3]||0)*60*60+1e3*(e[4]||0)*60+1e3*(e[5]||0))),o>28?(o=Math.round(o/7),t="weeks"):t="days",i.push({interval:o,type:t,time:[d.getHours(),d.getMinutes()],message:a.description||""})}}delete e.alarm,e.notifications=i}}_parseICalCategories(e){e&&(e.categories.split(",").forEach((t=>{const n=t.split("/");void 0!==n[1]&&(e[n[0]]=parseInt(n[1]))})),delete e.categories)}_exportToICal(e){const t=this,n=t.id,i=t._rRule,r=t.resources,a=t._getUTCDate(new Date),l=t._events;let o=`BEGIN:VCALENDAR\r\nPRODID:-//HTMLElements//Smart Scheduler//EN\r\nVERSION:2.0\r\nCALSCALE:GREGORIAN\nMETHOD:PUBLISH\r\nX-WR-CALNAME:${n}\r\nX-WR-TIMEZONE:${t.timeZone}\r\n`;for(let e=0;e<l.length;e++){const s=l[e],d=t._getEventRepeatOptions(s,!0),c=r.filter((e=>s[e.value])),u=s.status,h=s.id?s.id:n+Math.floor(65536*(1+Math.random())).toString(16).substring(1);if(o+="BEGIN:VEVENT\r\n",o+=t._getICalEventDates(s),o+=`DTSTAMP:${a}\r\nUID:${h}\r\nCREATED:${a}\r\nDESCRIPTION:${s.description||""}\r\nTRANSP:${u&&"free"!==u?"OPAQUE":"TRANSPARENT"}\r\nSEQUENCE:0\r\nSTATUS:${t._getICalStatus(s.status)}\r\nSUMMARY:${s.label||""}\r\n`,c.length&&(o+=`CATEGORIES:${c.map((e=>`${e.value}/${s[e.value]}`)).toString()}\r\n`),o+=t._getICalNotifications(s),d){const e=s.repeat.exceptions;if(delete d.dtstart,o+=new i(d).toString()+"\r\n",e&&e.length){for(let n=0;n<e.length;n++){const i=e[n];i.hidden&&(o+=`EXDATE;VALUE=DATE:${t._getUTCDate(i.date,s.allDay)}\r\n`)}o+="END:VEVENT\r\n";for(let n=0;n<e.length;n++){const i=e[n];if(!i.hidden&&i.dateStart&&i.dateEnd){const e=r.filter((e=>i[e.vlaue]));o+="BEGIN:VEVENT\r\n",o+=t._getICalEventDates(i),o+=`DTSTAMP:${a}\r\nUID:${h}\r\nRECURRENCE-ID${s.allDay?";VALUE=DATE":""}:${t._getUTCDate(i.date,s.allDay)}\r\nCREATED:${a}\r\nDESCRIPTION:${i.description||""}\r\nSEQUENCE:1\r\nSTATUS:${t._getICalStatus(i.status)}\r\nSUMMARY:${i.label||""}\r\n`,e.length&&(o+=`CATEGORIES:${e.map((e=>`${e.value}/${i[e.value]}`)).toString()}\r\n`),o+="END:VEVENT\r\n"}}continue}}o+="END:VEVENT\r\n"}o+="END:VCALENDAR";const s=(new Smart.Utilities.DataExporter).downloadFile(o,"text/calendar",t.dataExport.fileName);return e&&s&&e(s),s}_getICalEventDates(e){const t=this;if(!e.dateStart||!e.dateEnd)return"";if(e.allDay||e.$&&e.$.event.allDay){const n=new Date(e.dateEnd);return n.setDate(n.getDate()+1),`DTSTART;VALUE=DATE:${t._getUTCDate(e.dateStart,!0)}\r\nDTEND;VALUE=DATE:${t._getUTCDate(n,!0)}\r\n`}return`DTSTART:${t._getUTCDate(e.dateStart)}\r\nDTEND:${t._getUTCDate(e.dateEnd)}\r\n`}_getICalNotifications(e){let t="";if(!e)return t;const n=e.notifications;if(n&&n.length){const i=e.dateStart.getTime();for(let e=0;e<n.length;e++){const r=n[e],a="days"===r.type||0===r.type?r.interval:7*r.interval,l=r.time,o=new Date(i-24*a*60*60*1e3);o.setHours(l[0]%23,l[1]%60,0,0);let s=o.getTime()-i;const d=s<0?"-":"";s=Math.abs(s);const c=Math.max(0,Math.floor(s/864e5));s-=1e3*c*60*60*24;const u=Math.max(0,Math.floor(s/36e5));s-=1e3*u*60*60;const h=Math.max(0,Math.floor(s/6e4));t+=`BEGIN:VALARM\r\nACTION:DISPLAY\r\nDESCRIPTION:${r.message}\r\nTRIGGER:${d}P${c}DT${u}H${h}M0S\r\nEND:VALARM\r\n`}}return t}_getUTCDate(e,t){function n(e){return e<10?`0${e}`:`${e}`}return e instanceof Date||(e=new Date(e)),t?`${e.getFullYear()}${e.getMonth()+1}${e.getDate()}`:`${e.getUTCFullYear()}${n(e.getUTCMonth()+1)}${n(e.getUTCDate())}T${n(e.getUTCHours())}${n(e.getUTCMinutes())}${n(e.getUTCSeconds())}Z`}_getICalStatus(e){switch(e){case"tentative":return"TENTATIVE";case"canceled":return"CANCELED";case"draft":return"DRAFT";case"final":return"FINAL";case"in-process":return"IN-PROCESS";case"needs-action":return"NEEDS-ACTION";default:return"CONFIRMED"}}_setDropTarget(e){const t=this,n=e.originalEvent?e.originalEvent:e;let i,r=t.shadowRoot||t.isInShadowDOM?n.composedPath()[0]:n.target,a=Smart.Scheduler.hoveredCell,l=Smart.Scheduler.hoveredScheduler;if((t.shadowRoot||t).contains(r)&&(l&&l!==t&&(l.removeAttribute("dragged"),clearInterval(l._scrollInterval),delete l._scrollInterval),Smart.Scheduler.hoveredScheduler=l=t,t.setAttribute("dragged","")),t._isMobile&&l&&(l.$.timelineContent.classList.add("hide-overlay"),r=(t.shadowRoot||document).elementFromPoint(n.pageX-window.pageXOffset,n.pageY-window.pageYOffset),l.$.timelineContent.classList.remove("hide-overlay")),r&&r.closest&&!r.closest(".smart-scheduler-groups-container")&&(i=r.closest(".smart-scheduler-cell:not(.scale)")),i&&i!==a&&(t.shadowRoot||t).contains(i)){const e=document.body;a&&a.classList.remove("smart-scheduler-feedback"),t.disableDrop&&delete Smart.Scheduler.hoveredCell,Smart.Scheduler.hoveredCell=i,i.hasAttribute("restricted")?(e.classList.remove("smart-dragging"),e.classList.add("smart-dragging-disabled")):(i.classList.add("smart-scheduler-feedback"),e.classList.remove("smart-dragging-disabled"),e.classList.add("smart-dragging")),Smart.Scheduler.hoveredScheduler=l=t}else i||(l!==t||t.$.container.contains(r)||(t.removeAttribute("dragged"),clearInterval(t._scrollInterval),delete t._scrollInterval,delete Smart.Scheduler.hoveredScheduler),a&&(a.classList.remove("smart-scheduler-feedback"),delete Smart.Scheduler.hoveredCell));l&&l._autoScroll(n)}_setDragStart(e){const t=this,n=t.$.tooltip,i=t._dragDetails;let r=!0;if(t._isMobile&&(r=Date.now()-i.timestamp>=250,n.contains(i.schedulerEvent)&&t._list?t._list.disableSwipeScroll=t._list._touchmoveInside=r:t._scrollView.disableSwipeScroll=t._touchmoveInside=r),!r||Math.abs(e.pageX-i.coordinates.x)<5&&Math.abs(e.pageY-i.coordinates.y)<5)return;if(i.schedulerEvent.hasAttribute("collector")||"agenda"===t.viewType||i.resizeDetails)return;const a=i.schedulerEvent.$.event;if(!a||a.disableDrag)return;const l=t._cloneObject(a);if(t.$.fireEvent("dragStart",{target:i.schedulerEvent,item:l,itemDateRange:{dateStart:new Date(l.dateStart),dateEnd:new Date(l.dateEnd)},originalEvent:i.originialEvent}).defaultPrevented)return;i.originalBodyOverflow={overflowX:document.body.style.overflowX,overflowY:document.body.style.overflowY,overflow:document.body.style.overflow};const o=(document.scrollingElement||document.documentElement).scrollHeight>document.documentElement.clientHeight,s=(document.scrollingElement||document.documentElement).scrollWidth>document.documentElement.clientWidth;document.body.style.overflow=document.body.style.overflowX=document.body.style.overflowY="",o&&!s?document.body.style.overflowX="hidden":s&&!o?document.body.style.overflowY="hidden":s||o||(document.body.style.overflow="hidden"),n.contains(i.schedulerEvent)&&t._list&&(t._list.disableSwipeScroll=t._list._touchmoveInside=!0),n.close(),Smart.Scheduler.schedulerStart=t,Smart.Scheduler.feedback=t._createDragFeedback(l),t._dragDetails.schedulerEventObj=l,t._scrollView.disableSwipeScroll=t._touchmoveInside=!0,t.setAttribute("dragged",""),document.body.classList.add("smart-dragging")}_endDrag(e,t){const n=this;if(!Smart.Scheduler.schedulerStart)return;const i=n._dragDetails,r=Smart.Scheduler.schedulerStart,a=Smart.Scheduler.schedulerStart._dragDetails.schedulerEvent,l=Smart.Scheduler.schedulerStart._dragDetails.schedulerEventObj,o=Smart.Scheduler.hoveredScheduler,s=Smart.Scheduler.hoveredCell,d=document.body;if(r!==n)return;let c={},u={};if(l&&(u={dateStart:l.dateStart,dateEnd:l.dateEnd}),Smart.Scheduler.feedback.remove(),delete Smart.Scheduler.hoveredScheduler,delete Smart.Scheduler.hoveredCell,delete Smart.Scheduler.schedulerStart,delete Smart.Scheduler.feedback,i.originalBodyOverflow&&(d.style.overflow=i.originalBodyOverflow.overflow,d.style.overflowX=i.originalBodyOverflow.overflowX,d.style.overflowY=i.originalBodyOverflow.overflowY),o&&(o.removeAttribute("dragged"),clearInterval(o._scrollInterval),delete o._scrollInterval,s)){const t={event:e,schedulerEvent:a,hoveredCell:s,hoveredScheduler:o,schedulerEventObj:l};s.classList.remove("smart-scheduler-feedback"),n._setEventDropDates(t),n._completeEventDragDrop(t),c.dateStart=t.newDateStart,c.dateEnd=t.newDateEnd,i.schedulerEventObj=t.schedulerEventObj}e&&(n.$.fireEvent("dragEnd",{target:t,item:i.schedulerEventObj,itemDateRange:c,originalEvent:e}).defaultPrevented&&setTimeout((()=>{n.updateEvent(i.schedulerEventObj,u)})),n.$.fireEvent("itemChange",{type:"drag",item:i.schedulerEventObj})),d.classList.remove("smart-dragging"),d.classList.remove("smart-dragging-disabled"),r.removeAttribute("dragged"),n._scrollView.disableSwipeScroll=n._touchmoveInside=!1,n._list&&(n._list.disableSwipeScroll=n._list._touchmoveInside=!1);const h=n._handleEventFocus({type:"focusin",target:a});h&&h.focus({preventScroll:!0}),delete n._dragDetails}_endResize(e){const t=this,n=t._dragDetails,i=n?n.resizeDetails:void 0;if(t.removeAttribute("resized"),!n||!i)return;const r=n.schedulerEvent;let a={};r.removeAttribute("resized"),e?(t._setEventResizeDates(a),t._completeEventResize(a),i.schedulerEventObj.dateStart=a.dateStart,i.schedulerEventObj.dateEnd=a.dateEnd,t.$.fireEvent("resizeEnd",{target:n.schedulerEvent,item:i.schedulerEventObj,itemDateRange:a,originalEvent:e.originialEvent||e}),t.$.fireEvent("itemChange",{type:"resize",item:i.schedulerEventObj})):(r.style.left=i.originalPosition.x+"px",r.style.top=i.originalPosition.y+"px",r.style.width=i.originalSize.width+"px",r.style.height=i.originalSize.height+"px"),t._scrollView.disableSwipeScroll=t._touchmoveInside=!1,delete t._dragDetails,t._handleEventHover(),t._refreshTimelineEvents(),r.focus({preventScroll:!0}),t._handleEventFocus({type:"focusin",target:r})}_completeEventResize(e){const t=this,n=t._dragDetails,i=n.resizeDetails,r=i.cellObj,a=e.dateStart,l=e.dateEnd;if(!(r&&e&&a&&l))return;const o=n.schedulerEvent;let s=o.$.event;if(!o||!s||i.otherMonthDate||s.dateStart.getTime()===a.getTime()&&s.dateEnd.getTime()===l.getTime())return;if(t._isEventRestricted({dateStart:a,dateEnd:l}))return;const d=s.$&&s.$.event?s.$.event:void 0;let c;d?(c=t._cloneObject(d),t._handleEventExceptionDrop(s)):c=t._cloneObject(s);const u=s.dateStart.getTime()!==a.getTime();s.dateStart=new Date(a),s.dateEnd=new Date(l),["day","week"].indexOf(t.viewType)>-1&&s.allDay&&!i.isAllDay&&delete s.allDay,u&&(o.$.cellTime=a.getTime()),t._validateEventDateRange(s),t._updateUndoRedo(c,t._cloneObject(d||s),"resizeEnd")}_setEventResizeDates(e){const t=this,n=t._dragDetails,i=n.resizeDetails,r=i.cellObj;if(!r)return;const a=i.side,l=n.schedulerEvent,[o,s]="left"===a||"right"===a?["x","width"]:["y","height"];let d=l.$.event;if(!i.resizeFromMiddle&&i.originalPosition[o]===i.position[o]&&i.originalSize[s]===i.size[s])return e.dateStart=new Date(d.dateStart),void(e.dateEnd=new Date(d.dateEnd));const c=t.viewType,u=t.rightToLeft,h=60/t._getCellsScaleCount(),m=r.date,v=i.scaleIndex||0;let g,f;if("top"===a)f="dateStart",g=new Date(d.dateStart),g.setHours(m.getHours(),m.getMinutes()+h*v,0,0);else if("bottom"===a)f="dateEnd",g=new Date(d.dateEnd),g.setHours(m.getHours(),m.getMinutes()+h*(v+1),0,0);else{f="left"===a&&!u||"right"===a&&u?"dateStart":"dateEnd";const e=d[f];if("month"===c){const n=t._getCellObjOffset(l,i.position,"dateStart"===f?"bottom":"top").cellObj;g=new Date(e);const r=g.getHours(),a=g.getMinutes(),o="dateEnd"===f&&0===r&&0===a;g=new Date(n.date),g.setDate(g.getDate()+(m.getDay()-t.firstDayOfWeek+7)%7),o?g.setDate(g.getDate()+1):g.setHours(e.getHours(),e.getMinutes(),e.getSeconds())}else if(g=new Date(m),"timelineMonth"===c)"dateEnd"===f&&0===g.getHours()&&0===g.getMinutes()?(g.setDate(g.getDate()+1),g.setHours(0,0,0,0)):g.setHours(e.getHours(),e.getMinutes(),e.getSeconds());else if(["day","week"].indexOf(c)>-1&&i.isAllDay)g=new Date(m),"dateEnd"===f&&g.setHours(23,59,59,999);else{const e=t.view,n=t.views.find((t=>t.value&&t.value===e))||{};"timelineWeek"===c&&n&&n.hideHours?"dateEnd"===f?g.setHours(23,59,59,999):g.setHours(0,0,0,0):g.setMinutes(m.getMinutes()+h*(v+("dateStart"===f?0:1)),0,0)}}"dateStart"===f?(e.dateStart=g,e.dateEnd=new Date(d.dateEnd)):(e.dateStart=new Date(d.dateStart),e.dateEnd=g),t.hideOtherMonthDays&&e.dateStart.getMonth()!==t.dateCurrent.getMonth()&&(i.otherMonthDate=!0)}_completeEventDragDrop(e){const t=this,n=e.event,i=e.schedulerEvent,r=e.hoveredCell,a=e.hoveredScheduler,l=e.schedulerEventObj,o=e.newDateStart,s=e.newDateEnd,d=t.view,c=t.views.find((e=>e.value&&e.value===d))||{},u=c&&c.groupOrientation?c.groupOrientation:t.groupOrientation,h=i.$.event,m=h.$?h.$.event:void 0,v=r.$.cellObj,g=v[u].group,f=h.dateStart.getTime(),p=r.$.cellObj.time;let w,y;const _=JSON.parse(JSON.stringify(l));_.dateStart=o,_.dateEnd=s;for(let e in g)_[e]=g[e];if(!(a.disableDrop||n&&"keydown"===n.type&&"Escape"===n.key||e.otherMonthDate)&&o&&s&&!t._isEventRestricted(_)){if(a===t?(y=t._cloneObject(m||h),w=h):w=l,a===t&&f===p||t._handleEventExceptionDrop(h,w),w.dateStart=new Date(o),w.dateEnd=new Date(s),["day","week"].indexOf(t.viewType)>-1&&(w.allDay=!!v.allDay),f!==p&&(i.$.cellTime=p),w.allDay||delete w.allDay,g&&!t._isEventPartOfGroup(h,g)){t.groups.forEach((e=>delete w[e]));for(let e in g)w[e]=g[e]}a===t?(t._validateEventDateRange(w),t._refreshTimelineEvents(),e.schedulerEventObj=t._cloneObject(m||w),t._updateUndoRedo(y,t._cloneObject(m||w),"dragEnd")):(m||t.removeEvent(h),a.insertEvent(w))}}_setEventDropDates(e){const t=this,n=e.schedulerEvent,i=e.hoveredScheduler,r=e.hoveredCell,a=n.$.event,l=r.$.cellObj,o=a.dateStart.getTime(),s=r.$.cellObj.time,d=l[t.groupOrientation].group;if(i===t&&o===s&&!!l.allDay==!!a.allDay&&(!d||t._isEventPartOfGroup(a,d)))return e.newDateStart=new Date(a.dateStart),void(e.newDateEnd=new Date(a.dateEnd));const c=e.schedulerEventObj,u=["day","week"].indexOf(t.viewType)>-1,h=i===t?a:c;let m,v;if(m=new Date(s),u&&!!h.allDay!=!!l.allDay)v=t._getCellDateRange(l).dateEnd;else{const e=h.dateEnd.getTime()-h.dateStart.getTime();v=new Date(m.getTime()+e)}u&&l.allDay&&(m.setHours(0,0,0,0),0!==v.getHours()&&0!==v.getMinutes()&&0!==v.getSeconds()&&v.setHours(23,59,59,999)),e.newDateStart=m,e.newDateEnd=v,t.hideOtherMonthDays&&m.getMonth()!==t.dateCurrent.getMonth()&&(e.otherMonthDate=!0)}_checkEventResizability(e){const t=this,n=t._dragDetails,i=e.originalEvent||e;let r=i.target;if(t._isMobile){if(!n)return;t.$.timelineContent.classList.add("hide-overlay"),r=(t.shadowRoot||document).elementFromPoint(i.pageX-window.pageXOffset,i.pageY-window.pageYOffset),t.$.timelineContent.classList.remove("hide-overlay")}else t.shadowRoot&&r===t&&(r=e.originalEvent.composedPath()[0]);const a=t.$.timeline;let l=r&&r.closest&&!t.disabled?r.closest(".smart-scheduler-event"):void 0;if(t._handleEventHover(l),!l||t.disableResize||"agenda"===t.viewType)return;const o=l.$?l.$.event:void 0;if(!a.contains(l)||l.hasAttribute("collector")||!o||o.disableResize)return;const s=t.viewType,d=t.$.timelineViewAllDay.contains(l),c=e.pageX-window.pageXOffset,u=e.pageY-window.pageYOffset,h="visible"===t.resizeHandlesVisibility||t._isMobile?20:5,m=l.getBoundingClientRect();if(s.toLowerCase().indexOf("timeline")>-1||"month"===s||d){if(Math.round(m.left)+h>=c&&Math.round(m.left)-h<=c)return void a.setAttribute("event-hovered","left");if(Math.round(m.right)+h>=c&&Math.round(m.right)-h<=c)return void a.setAttribute("event-hovered","right")}else{if(Math.round(m.top)+h>=u&&Math.round(m.top)-h<=u)return void a.setAttribute("event-hovered","top");if(Math.round(m.bottom)+h>=u&&Math.round(m.bottom)-h<=u)return void a.setAttribute("event-hovered","bottom")}a.hasAttribute("event-hovered")&&a.setAttribute("event-hovered","")}_handleEventHover(e){const t=this,n=t.$.timeline;if(!e&&!n.hasAttribute("event-hovered")||e&&e.hasAttribute("hover"))return;const i=e&&e.$?e.$.event:void 0;let r=[].concat(Array.from(t.$.timelineEventsContainer.children),Array.from(t.$.allDayEventsContainer.children));t._eventList&&(r=r.concat(Array.from(t._eventList.children)));for(let t=0;t<r.length;t++){const n=r[t],a=n.$.event;n===e||i&&i===a?n.setAttribute("hover",""):n.removeAttribute("hover")}i||e?n.setAttribute("event-hovered",""):n.removeAttribute("event-hovered")}_handleEventResize(e){const t=this,n=t._dragDetails,i=n?n.schedulerEvent:void 0;if(t.disableResize||!n||!i||"agenda"===t.viewType||t._isMobile&&Date.now()-n.timestamp<250)return;t.hasAttribute("resized")||t._setResizeStart(i);const r=n.resizeDetails;if(!r)return;const a=e.pageX-window.pageXOffset,l=e.pageY-window.pageYOffset,o=r.side,s=t.$.timelineContainer.getBoundingClientRect();let d;d=r.rightToLeft?s.right-a:a-s.left;const c={x:Math.max(0,d+t.scrollLeft),y:Math.max(0,l-s.top+t.scrollTop)},u=t._getCellObjOffset(i,c,o);if(t._autoScroll(e),u)if(r.cellObj=u.cellObj,r.scaleIndex=u.scaleIndex,"left"===o||"right"===o){if(!t._resizeEventHorizontal(u,o))return}else if(!t._resizeEventVertical(u,o))return}_setResizeStart(e){const t=this,n=t._dragDetails,i=e.$.event,r=t.$.timeline,a=t._eventList;if(!i||i.disableResize||Smart.Scheduler.schedulerStart||a&&a.contains(e))return;const l=t._cloneObject(i);if(t.$.fireEvent("resizeStart",{target:n.schedulerEvent,item:l,itemDateRange:{dateStart:new Date(i.dateStart),dateEnd:new Date(i.dateEnd)},originalEvent:n.originialEvent}).defaultPrevented)return;t.$.tooltip.close(),t.setAttribute("resized",""),e.setAttribute("resized",""),t._scrollView.disableSwipeScroll=t._touchmoveInside=!0;const o=t.rightToLeft,s=parseFloat(e.style[o?"right":"left"]),d=parseFloat(e.style.top),c={width:parseFloat(e.style.width),height:parseFloat(e.style.height)},u=r.getAttribute("event-hovered"),h={x:s,y:d},m=e.closest(".smart-scheduler-events-container").children;let v;for(let t=0;t<m.length;t++){const n=m[t],r=n.$?n.$.event:void 0,a=parseFloat(n.style.left),l=parseFloat(n.style.top);r===i&&e!==n&&("left"===u&&(l<d||l===d&&a<s)||"right"===u&&(l>d||l===d&&a>s))&&(n.classList.add("smart-hidden"),v=!0)}n.resizeDetails={side:u,originalSize:c,originalPosition:h,position:{x:h.x,y:h.y},size:{width:c.width,height:c.height},isAllDay:t.$.timelineViewAllDay.contains(e),rightToLeft:o,resizeFromEnd:"bottom"===u||"right"===u&&!o||"left"===u&&o,resizeFromMiddle:v,schedulerEventObj:l}}_resizeEventHorizontal(e,t){const n=this._dragDetails,i=n.schedulerEvent,r=this.rightToLeft,a=n.resizeDetails;let l,o=a.position.x,s=e.offset;if("left"===t&&!r||"right"===t&&r){const e=a.originalPosition.x;if(o===s)return;if(o<s?(s=o<e?Math.min(e,s):s,l=a.size.width-(s-o)):(s=o>e?Math.max(e,s):s,l=a.size.width+(o-s)),l<=0)return;a.position.x=s,r?(i.style.left="",i.style.right=s+"px"):(i.style.right="",i.style.left=s+"px")}else{if(o+=a.size.width,s+=e.size,o===s)return;if(l=o<s?a.size.width+(s-o):a.size.width-(o-s),l<=0)return}return a.size.width=l,i.style.width=a.size.width+"px",!0}_resizeEventVertical(e,t){const n=this._dragDetails,i=n.schedulerEvent,r=n.resizeDetails;let a,l=r.position.y,o=e.offset;if("top"===t){const e=r.originalPosition.y;if(l===o)return;if(l<o?(o=l<e?Math.min(e,o):o,a=r.size.height-(o-l)):(o=l>e?Math.max(e,o):o,a=r.size.height+(l-o)),a<=0)return;r.position.y=o,i.style.top=o+"px"}else{if(l+=r.size.height,o+=e.size,l===o)return;if(a=l<o?r.size.height+(o-l):r.size.height-(l-o),a<=0)return}return r.size.height=a,i.style.height=r.size.height+"px",!0}_getCellObjOffset(e,t,n){const i=this,r=i._dragDetails.resizeDetails,a=i._timelineCells,l=e.$.event,o=r.isAllDay?1:i._getCellsScaleCount(),[s,d,c,u]="right"===n||"left"===n?["width","left","horizontal","x"]:["height","top","vertical","y"],h=r.resizeFromEnd,m=a[c],v=r.originalSize[s];let g,f,p,w,y,_=r.originalPosition[u],b=_,D=t[u];h?(_=parseFloat((_+v).toFixed(2)),D=Math.max(b,D),w=b):(b=parseFloat((b+v).toFixed(2)),D=Math.min(b,D),y=b);for(let e=0;e<m.length;e++){const t=m[e];if(t.group&&!i._isEventPartOfGroup(l,t.group))continue;const n=parseFloat((t[d]+t[s]).toFixed(2));f||(void 0===w?n>D&&(f=t):n>w&&(f=t)),void 0===y?t[d]<=D&&(p=t):t[d]<y&&(p=t),D!==b&&t[d]<=D&&n>=D&&(g=t)}if(g||(g=h&&b===D||!h&&b!==D?f:p),!g)return;let C,E=g[d],T=parseFloat((g[s]/o).toFixed(2));for(let e=0;e<o;e++){const t=parseFloat((g[d]+T*e).toFixed(2));(b!==D&&t===D||t+T===D||t<D&&t+T>=D)&&(E=t,C=e)}return _>E&&_<parseFloat((E+T).toFixed(2))&&(h&&D<=_?T=_-E:!h&&D>=_&&(E=_)),{offset:E,size:T,cellObj:g,scaleIndex:C}}_handleEventExceptionDrop(e,t){const n=e.$?e.$.event:void 0;if(t||(t=e),e!==t)return delete t.repeat,void delete t.date;if(!n)return;const i=n.repeat;if(t.date||(t.date=new Date(t.dateStart)),delete t.repeat,i){const e=i.exceptions;e?e.indexOf(t)<0&&e.push(t):i.exceptions=[t]}}_dragStartHandler(e){const t=this,n=e.target.closest;if((t._dragDetails||n&&n.call(t,"smart-scheduler")===t)&&e.target){let t=e.target;for(;t;){if(t.className&&t.className.indexOf("smart-scheduler")>=0)return void e.preventDefault();t=t.parentNode}}}_autoScroll(e){const t=this,n=t.$.timelineContainer,i=(e.originalEvent||e).target,r=t.autoScrollStep,a=t._dragDetails,l=t.rightToLeft;function o(n,i){i?(t.scrollTop-=r*n,a&&(a.coordinates.y+=r*n)):(t.scrollLeft-=(l?-1:1)*r*n,a&&(a.coordinates.x+=r*n)),t.hasAttribute("resized")&&t._handleEventResize(e)}if(t.disableAutoScroll||!e||!n.contains(i)||!t.hasAttribute("dragged")&&!t.hasAttribute("resized"))return void clearInterval(t._scrollInterval);clearInterval(t._scrollInterval);const s=n.getBoundingClientRect(),d=!(!a||!a.resizeDetails)&&a.resizeDetails.isAllDay;t._scrollInterval=setInterval((function(){(t.scrollLeft||l)&&e.clientX<=s.left+50?o(1):t.scrollLeft!==(l?0:t.scrollWidth)&&e.clientX>=s.left+s.width-50?o(-1):d||(t.scrollTop&&e.clientY<=s.top+50?o(1,!0):t.scrollTop!==t.scrollHeight&&e.clientY>=s.top+s.height-50?o(-1,!0):(clearInterval(t._scrollInterval),t._scrollInterval=void 0))}),1)}_createDragFeedback(e){const t=this,n=t.theme,i=t.rightToLeft,r=t._dragDetails.schedulerEvent;let a=document.createElement("div");return t.dragFeedbackFormatFunction?a.innerHTML=t.dragFeedbackFormatFunction(e)||"":(a=r.cloneNode(!0),a.setAttribute("view-type",t.viewType),a.setAttribute("event-render-mode",t.eventRenderMode)),a.classList.remove("smart-scheduler-event"),a.classList.add("smart-scheduler-drag-feedback"),a.setAttribute("parent-scheduler-id",t.id),t._isMobile&&a.setAttribute("mobile",""),n&&a.setAttribute("theme",n),i&&a.setAttribute("right-to-left",""),a}_containsEvent(e){const t=this._events;if(!e)return;if(t.indexOf(e)>-1)return e;const n=["label","description"],i=this.groups,r="string"==typeof e?e:e.id;for(let a=0;a<t.length;a++){const l=t[a];if(void 0!==l.id&&l.id+""===r)return l;if((void 0===l.id||l.id+""==r+"")&&n.every((t=>l[t]instanceof Date?new Date(l[t]).getTime()===new Date(e[t]).getTime():l[t]===e[t]))&&(!i.length||i.every((t=>e[t]===l[t]))))return l}}_keyDownHandler(e){const t=this;if(t.readonly||t.hasAttribute("modal"))return void delete t._keyPressed;const n=t.$.tooltip,i=e.key,r=t.$.viewItemsContainer,a=e.target;switch(i){case"End":case"Home":case"ArrowUp":case"ArrowDown":case"ArrowLeft":case"ArrowRight":case"PageDown":case"PageUp":e.preventDefault(),t._handleKeyNavigation(e);break;case"Enter":case"Escape":if("Enter"===i){if(n.contains(a)){const i=n.querySelector("[selected]");if(!i)return;if(a===r){const e=t.$.showWeekendItem;e&&e.hasAttribute("selected")&&t._checkHideWekendItem(e),n.close(),t.$.viewItemsButton.focus({preventScroll:!0})}else a.classList.contains("smart-scheduler-event-button")?(t._deleteEventViaWindow(a.closest(".smart-scheduler-event").$.event),n.close(),t.$.timeline.focus({preventScroll:!0})):i.classList.contains("smart-scheduler-event")?t._doubleClickHandler(i):i.classList.contains("smart-scheduler-context-menu-item")&&t._handleContextMenuItemClick(i);e.preventDefault()}else if(a.classList.contains("smart-scheduler-event"))t._doubleClickHandler(a);else if(a.classList.contains("smart-scheduler-legend-res-item")){if(!t.filterable)return;t._handleLegendItemClick(a)}else a===t.$.timeline&&(t._openWindow(),e.preventDefault());break}"Escape"===i&&(Smart.Scheduler.schedulerStart===t?(t._endDrag(e,t),e.preventDefault()):t.hasAttribute("resized")&&(t._endResize(),e.preventDefault())),n.close(),n.selector&&n.selector.focus({preventScroll:!0});break;case"Tab":{const i=a;let r;if((i.classList.contains("smart-scheduler-event")||i.classList.contains("smart-scheduler-view"))&&(r=Array.from(t.$.timeline.querySelectorAll(".smart-scheduler-event"))),!r)break;const l=r.indexOf(i),o=l<0?r[0]:r[l+(e.shiftKey?-1:1)];if(n.visible&&n.contains(i))return;o&&(e.preventDefault(),o.focus({preventScroll:!0}));break}case"c":case"C":case"x":case"X":!t._dragDetails&&e.ctrlKey&&a.classList.contains("smart-scheduler-event")&&(t._updateClipboard(a.$.event,"c"===i?"copy":"cut"),t._handleEventCut(a));break;case"z":case"Z":case"y":case"Y":{const n=t.getRootNode(),r=n?n.activeElement.classList:void 0;if(!r.contains("smart-scheduler-event")&&!r.contains("smart-scheduler-view")&&!r.contains("smart-scheduler"))return;!t._dragDetails&&e.ctrlKey&&t._handleUndoRedo("z"===i?"undo":"redo");break}case"v":case"V":!t._dragDetails&&e.ctrlKey&&a.classList.contains("smart-scheduler-view")&&t._selectedCellObj&&t._pasteEvent(t._selectedCellObj.from);break;case"Delete":if(!t._dragDetails&&a.classList.contains("smart-scheduler-event")&&!a.hasAttribute("collector")){if(t.$.fireEvent("eventShortcutKey",{key:i,target:a,eventObj:t._cloneObject(a.$.event)}).defaultPrevented)return;e.preventDefault(),t._handleEventMenuDelete(a)}break;case" ":t.filterable&&a.classList.contains("smart-scheduler-legend-res-item")&&t._handleLegendItemClick(a);break;default:if(a===r||a.closest(".smart-scheduler-view-items-button")){let a=t._keyPressed;a||(a=t._keyPressed={}),a[i.toLowerCase()]=!0;const l=Object.keys(a),o=Array.from(r.children).find((e=>{const t=(e.getAttribute("shortcut-key")||"").toLowerCase().split("+");return t.forEach((e=>e.trim())),l.length===t.length&&l.every((e=>t.indexOf(e)>-1))}));o&&(t._handleViewSelection(o),e.preventDefault(),n.close())}}}_keyUpHandler(e){const t=this;if(t.disabled||t.readonly)return void delete t._keyPressed;let n=t._keyPressed;n&&(delete n[e.key.toLowerCase()],Object.keys(n).length||delete t._keyPressed)}_handleContextMenuItemClick(e){const t=this,n=t.$.tooltip,i=n.selector,r=e.getAttribute("value");let a;switch(r){case"create":if(i.classList.contains("smart-scheduler-cell"))if(t._selectedCellObj)a=t._createEventFromSelection();else{const e=t._getCellDateRange(i),n=i.$.cellObj,r=n.vertical.group||n.horizontal.group;if(a={dateStart:e.dateStart,dateEnd:e.dateEnd,allDay:i.hasAttribute("all-day")},r)for(let e in r)a[e]=r[e]}else if(i.classList.contains("smart-scheduler-event")){const e=Object.assign({},i.$.event);a={dateStart:new Date(e.dateStart),dateEnd:new Date(e.dateEnd),allDay:e.allDay}}t._openWindow(a);break;case"edit":t._doubleClickHandler(i);break;case"copy":case"cut":i.classList.contains("smart-scheduler-event")&&!i.hasAttribute("collector")&&(t._updateClipboard(i.$.event,r),t._handleEventCut(i));break;case"paste":if(e.hasAttribute("disabled"))return;i.classList.contains("smart-scheduler-cell")&&t._pasteEvent(i);break;case"delete":if(!i.classList.contains("smart-scheduler-event")||i.hasAttribute("collector"))return;t._handleEventMenuDelete(i)}if(e instanceof HTMLElement){const n={item:e,type:"context",value:e.getAttribute("value")};a&&(n.itemObj=t._cloneObject(a)),t.$.fireEvent("itemClick",n)}n.close()}_updateClipboard(e,t){const n=this;if(!e||!t)return void delete n._clipboard;n._clipboard={target:e,action:t};let i=[],r=[];const a=n.locale,l={year:n.yearFormat,month:n.monthFormat,day:n.dayFormat,hour:n.hourFormat,minute:n.minuteFormat},o=[{label:"id",value:"Id"},{label:"label",value:"Label"},{label:"description",value:"Description"},{label:"dateStart",value:"Date Start"},{label:"dateEnd",value:"Date End"},{label:"allDay",value:"All Day"},{label:"repeat",value:"Repeat"},{label:"notifications",value:"Notifications"}];for(let t=0;t<o.length;t++){const n=o[t].label;if(void 0!==e[n]){let s=e[n];s instanceof Date?s=new Intl.DateTimeFormat(a,l).format(new Date(s)):"repeat"===n?s=(Object.keys(s).length>0)+"":"notifications"===n&&(s=(Array.isArray(s)&&s.length>0)+""),r.push(o[t].value),i.push(s+"")}}if(i=r.join(",")+"\n"+i.join(","),navigator.clipboard)navigator.clipboard.writeText(i);else if(document.execCommand){const e=document.createElement("textarea"),t=n.getRootNode().activeElement;return e.value=i,e.style.position="fixed",document.body.appendChild(e),e.focus({preventScroll:!0}),e.select(),document.execCommand("copy"),document.body.removeChild(e),void(t&&t.focus({preventScroll:!0}))}}_handleEventCut(e){const t=this,n=t._clipboard,i=Array.from(t.$.timelineEventsContainer.children).concat(Array.from(t.$.allDayEventsContainer.children));let r;if(n&&"cut"===n.action||(e=void 0),e?r=e.$.event:!e&&n&&"cut"===n.action&&(r=n.target),r&&r.$&&r.$.event){const e=r.$.event;e&&e.repeat&&(!e.repeat.exceptions||e.repeat.exceptions.indexOf(r)<0)&&(r=void 0)}for(let e=0;e<i.length;e++){const t=i[e];r&&t.$&&t.$.event===r?t.setAttribute("cut",""):t.removeAttribute("cut")}}_pasteEvent(e){const t=this,n=t._clipboard;if(!n)return;let i=n.target;if(!i)return;if(!(e=e instanceof HTMLElement?e.$.cellObj:e))return;const r=i.$&&i.$.event?i.$.event:void 0;if(r&&r.repeat&&(!r.repeat.exceptions||r.repeat.exceptions.indexOf(i)<0))return;const a=t.view,l=t.views.find((e=>e.value&&e.value===a))||{},o=e[l&&l.groupOrientation?l.groupOrientation:t.groupOrientation].group,s=["day","week"].indexOf(t.viewType)>-1;let d,c,u,h;switch(n.action){case"copy":{if(r)return;const e=t.localize("duplicate"),n=new RegExp(`\\s?-\\s?${e}\\s?(\\(([0-9]+)\\))?$`,"g"),a=t._events;let l=(i.label+"").replace(n,""),o=0;i=t._cloneObject(i);for(let e=0;e<a.length;e++){const t=a[e];if(t.label.indexOf(l)>-1&&(n.lastIndex=0,n.test(t.label))){n.lastIndex=0;const e=n.exec(t.label);o=Math.max(o,parseInt(e[2])||1)+1}}i.label=o>1?`${l} - ${e} (${o})`:`${l} - ${e}`,delete i.id,t._events.push(i),u="itemInsert";break}case"cut":h=t._cloneObject(r||i),o&&!t._isEventPartOfGroup(i,o)&&t.groups.forEach((e=>delete i[e])),t._updateClipboard(),u="itemUpdate"}if(d=new Date(e.time),c=s&&!!i.allDay!=!!e.allDay?t._getCellDateRange(e).dateEnd:new Date(d.getTime()+(i.dateEnd.getTime()-i.dateStart.getTime())),s&&(e.allDay&&(d.setHours(0,0,0,0),0!==c.getHours()&&0!==c.getMinutes()&&0!==c.getSeconds()&&c.setHours(23,59,59,999)),i.allDay=!!e.allDay),i.allDay||delete i.allDay,i.dateStart=d,i.dateEnd=c,o)for(let e in o)i[e]=o[e];t._validateEventDateRange(i),t._refreshTimelineEvents(),"itemInsert"===u?t._updateUndoRedo(void 0,t._cloneObject(r||i),u):t._updateUndoRedo(h,t._cloneObject(r||i),u);const m=t._cloneObject(r||i);t.$.fireEvent(u,{item:m}),t.$.fireEvent("itemChange",{item:m})}_handleKeyNavigation(e){const t=this,n=t.viewType.toLowerCase(),i=n.indexOf("timeline")>-1,r=t.$.tooltip,a=t.rightToLeft,l=e.key;let o=t.enableShadowDOM?e.composedPath()[0]:e.target;if(r.visible){const e=r.$.content instanceof HTMLElement?r.$.content.querySelector("[tabindex]"):null;e&&(e.focus({preventScroll:!0}),o=e)}if(o===t.$.timeline){const r=t.$.timelineContent,o=t.$.timelineViewAllDay,s=o.offsetHeight>0;if(!t._selectedCellObj)return t._handleCellSelection((s?o:r).querySelector(".smart-scheduler-cell:not(.scale)")),void(t._selectedCellObj&&t._scrollTo(t._selectedCellObj.to));const d=t._selectedCellObj[e.shiftKey?"to":"from"],c=t._getCellsScaleCount(),u=d.scaleIndex||0,h=c-1;let m,v,[g,f,p]=[d.horizontal,d.vertical,u],w=d.allDay;switch(l){case"Home":case"End":m=t._timelineCells[i?"horizontal":"vertical"],[v,p,w]="Home"===l?[m[0],0,!e.shiftKey&&s]:[m[m.length-1],h,!1],[g,f]=i?[v,f]:[g,v];break;case"ArrowUp":case"ArrowDown":case"ArrowLeft":case"ArrowRight":{const e=["ArrowUp","ArrowDown"].indexOf(l)>-1,n=a&&"ArrowRight"===l||!a&&"ArrowLeft"===l||"ArrowUp"===l?-1:1;[m,v]=e?[t._timelineCells.vertical,f]:[t._timelineCells.horizontal,g],e&&i||!e&&!i?v=m[m.indexOf(v)+n]:(p+=n,(p<0||p>h)&&(v=m[m.indexOf(v)+n],p=p>h?0:h)),[g,f]=e?[g,v]:[v,f];break}case"PageDown":case"PageUp":{if(i||d.allDay)break;const e=d.vertical.top+t._scrollViewSize.height*("PageUp"===l?-1:1),n=t._timelineCells.vertical;f=t._timelineCells.vertical.find((t=>t.top>=e)),f||(f="PageUp"===l?n[0]:n[n.length-1]);break}}e.shiftKey||(w&&"ArrowDown"===l?(f=t._timelineCells.vertical[0],p=0,w=!1):"ArrowUp"!==l||f||(w=s));const y=t._getCellByObj({horizontal:g,vertical:f,scaleIndex:p,allDay:w});if(y){const i=t._selectedCellObj.from;t._handleCellSelection("agenda"!==n&&e.shiftKey&&!!i.allDay==!!w?i:y,y)}}else if(o===t.$.viewItemsContainer){const e=t.$.viewItemsContainer.children,n=Array.from(e).find((e=>e.hasAttribute("selected")));let i;n&&"Home"!==l?"End"===l?i=e[e.length-1]:(t.$.tooltip.contains(o)&&("ArrowUp"===l||"ArrowDown"===l)||t.$.header.contains(o)&&("ArrowLeft"===l||"ArrowRight"===l))&&(i=n["ArrowUp"===l||"ArrowLeft"===l&&!a||"ArrowRight"===l&&a?"previousElementSibling":"nextElementSibling"]):i=e[0],i&&n!==i&&t._handleViewSelection(i)}else if(o===t._list){const e=(t._list.contains(t._eventList)?t._eventList:t._contextList).children,n=Array.from(e).find((e=>e.hasAttribute("selected")));let i;n&&"Home"!==l?"End"===l?i=e[e.length-1]:"ArrowUp"!==l&&"ArrowDown"!==l||(i=n["ArrowUp"===l?"previousElementSibling":"nextElementSibling"]):i=e[0],i&&n!==i&&t._handleEventItemSelection(e,i)}}_handleEventItemSelection(e,t){const n=this;if((n._eventList||n._contextList)&&(n._list.contains(n._eventList)?n._eventList:n._contextList)){e||(e=(n._list.contains(n._eventList)?n._eventList:n._contextList).children);for(let n=0;n<e.length;n++){const i=e[n];i===t?i.setAttribute("selected",""):i.removeAttribute("selected")}}}_getCellByObj(e){const t=this;if(!e)return;if(!t._scrollTo(e))return;const n=e.allDay,i=n?t.$.timelineViewAllDay:t.$.timelineCellsContainer,r=Array.from(i.querySelectorAll(".smart-scheduler-cell:not(.scale)"));n&&delete e.vertical;const a=Object.keys(e);return r.find((t=>a.every((n=>e[n]===t.$.cellObj[n]||void 0===t.$.cellObj[n]))))}_scrollTo(e,t,n){const i=this,r=i._getCellsScaleCount(),a=i.viewType.toLowerCase().indexOf("timeline")>-1;let l,o,s,d,c,u,h,m;if(e instanceof HTMLElement&&e.classList.contains("smart-scheduler-event")||i._events&&i._events.indexOf(e)>-1){const t=i._scrollToEvent(e);if(!t)return;[l,o,s,d]=[t.hCell,t.vCell,t.scaleIndex,t.allDay]}else if(e instanceof Date){let t=i._getCellObjByDate(e);if(!t&&(i.navigateToDate(e),t=i._getCellObjByDate(e),!t))return;[l,o,s,d]=[t.hCell,t.vCell,t.scaleIndex,t.allDay]}else{if(e instanceof HTMLElement&&e.$&&(e=e.$.cellObj),!e)return;l=e.horizontal||e,o=e.vertical||e,s=e.scaleIndex||0,d=e.allDay}const v=()=>{const e=i[c];t||e>m?(i[c]=m,i.isCompleted||(i.$.timelineContainer[c]=i[c],i._recycle())):e+h<m+u&&(i[c]=Math.max(0,m+u-h),i.isCompleted||(i.$.timelineContainer[c]=i[c],i._recycle()))};return l&&([c,u,h]=["scrollLeft",l.width/(a?r:1),i._scrollViewSize.width],m=l.left+u*(a?s:0),v()),o&&!d&&([c,u,h]=["scrollTop",o.height/(a?1:r),i._scrollViewSize.height],m=o.top+u*(a?0:s),n&&(t&&(m=Math.max(0,m+u-h)),m+=(i._scrollViewSize.height-u)/2),v()),!0}_scrollToEvent(e){const t=this;if(!e)return;e instanceof HTMLElement&&e.classList.contains("smart-scheduler-event")&&!t.$.timeline.contains(e)&&(e=e.$?e.$.event:void 0);const n=t._events;if(!e||!n||n.indexOf(e)<0)return;const i=t._getEventHorizontallCellObjs(e),r=t._getEventVerticalCellObjs(e),a=i.start||i.first,l=r.start||r.first;let o=0;return e.allDay||(o=t._getEventScaleIndex(e,t.viewType.indexOf("timeline")>-1?a:l).start),{hCell:a,vCell:r,scaleIndex:o,allDay:e.allDay}}_getCellObjByDate(e){if(!(e instanceof Date)||!e||isNaN(e.getTime()))return;const t=this,n=t.viewType.toLowerCase(),i=t._timelineCells.horizontal,r=t._timelineCells.vertical,a=n.indexOf("month")>-1;let l,o,s,[d,c,u,h,m]=[e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getDay()];if("agenda"===n){if(o=r.find((e=>{const t=e.date;return t.getFullYear()===d&&t.getMonth()===c&&t.getDate()===u})),!o)return}else if(n.indexOf("timeline")<0){if(l=i.find((e=>{const t=e.date;return a&&t.getDay()===m||t.getFullYear()===d&&t.getMonth()===c&&t.getDate()===u})),a&&(s=new Date,s.setDate(s.getDate()-s.getDay()+t.firstDayOfWeek),[d,c,u,h,m]=[s.getFullYear(),s.getMonth(),s.getDate(),s.getHours(),s.getDay()]),o=r.find((e=>{const t=e.date;return a?t.getFullYear()===d&&t.getMonth()===c&&t.getDate()===u&&t.getHours()===h:t.getHours()===h})),!l||!o)return}else if(l=i.find((e=>{const t=e.date;return t.getFullYear()===d&&t.getMonth()===c&&t.getDate()===u&&(a||t.getHours()===h)})),!l)return;return{hCell:l,vCell:o,scaleIndex:Math.floor(e.getMinutes()/60*t._getCellsScaleCount())}}_mouseWheelHandler(e){const t=this,n=e.target;t.$.viewSelectorContainer.contains(n)?t._handleViewNavigation(e):t.disabled||n.closest(".smart-scheduler-window-modal")||(e.shiftKey&&t.computedHorizontalScrollBarVisibility?t._handleHorizontalScroll(e):t.computedVerticalScrollBarVisibility&&t._handleVerticalScroll(e))}_handleCellSelection(e,t){const n=this,i=n._dragDetails?n._dragDetails.selectedCellObj:n._selectedCellObj;let r,a,l,o;i&&(r=i.from,a=i.to),n.disableSelection?n._selectCell():n._selectCell(e,t),n._selectedCellObj&&(l=n._selectedCellObj.from,o=n._selectedCellObj.to);const s={dateStart:void 0,dateEnd:void 0,group:void 0};let d,c,u,h,m,v;r&&(d=new Date(r.time),c=new Date(a.time),m=r.horizontal.group||r.vertical.group),l&&(u=new Date(l.time),v=l.horizontal.group||l.vertical.group,s.dateStart=u,s.group=v,h=new Date(o.time),s.dateEnd=h),(r&&!l||!r&&l||d&&(d.getTime()!==u.getTime()||c.getTime()!==h.getTime()||m!==v))&&n.$.fireEvent("change",s)}_selectCell(e,t){const n=this;function i(){const e=n.$.timeline.querySelectorAll(".smart-scheduler-cell[selected]");for(let t=0;t<e.length;t++)e[t].removeAttribute("selected");delete n._selectedCellObj}if(t||(t=e),!e||"agenda"===n.viewType)return void i();let r=e,a=t;if(e.closest){const t=e.closest(".smart-scheduler-cell:not(.scale)");if(!t||!n.$.timeline.contains(t))return;r=t.$?t.$.cellObj:void 0}if(t.closest){const e=t.closest(".smart-scheduler-cell:not(.scale)");if(!e||!n.$.timeline.contains(e))return;a=e.$?e.$.cellObj:void 0}if(!r||!a||n._isMobile&&Object.keys(r).some((e=>r[e]!==a[e]))||void 0===r.time||void 0===a.time)return;if(r.allDay&&!a.allDay){const e=n.$.timelineViewAllDayCellsContainer.children;for(let t=0;t<e.length;t++){const n=e[t];if(!n.$)continue;const i=n.$.cellObj;if(i.horizontal===a.horizontal){a=i;break}}}if(r.allDay!==a.allDay)return;const l=n.view,o=n.views.find((e=>e.value&&e.value===l))||{},s=o&&o.groupOrientation?o.groupOrientation:n.groupOrientation,d=(r[s]||r).group;if(d!==(a[s]||a).group)return;i();let c,[u,h]=[r.time,a.time];if("agenda"===n.viewType&&u!==h)return;let m={};if(u>h){const e=u;u=h,h=e}m.from=Object.assign({},r),m.to=Object.assign({},a),n._selectedCellObj=m;const v=(r.allDay?n.$.timelineViewAllDay:n.$.timelineContent).querySelectorAll(".smart-scheduler-cell:not(.scale)");for(let e=0;e<v.length;e++){if(c=v[e],c.removeAttribute("selected"),!c.$)continue;const t=c.$.cellObj;if((t[s]||t).group!==d)continue;const n=t.time,i=Object.keys(t);n>=u&&n<=h&&c.setAttribute("selected",r===a||i.every((e=>t[e]===r[e]))?"start":"")}n._scrollTo(a)}_isCellObjSelected(e){const t=this,n=t._selectedCellObj;if(!n||!e)return;const i=n.from,r=n.to,a=t.view,l=t.views.find((e=>e.value&&e.value===a))||{},o=l&&l.groupOrientation?l.groupOrientation:t.groupOrientation;if((i[o]||i).group!==(e[o]||e).group)return;const s=Math.min(i.time,r.time),d=Math.max(i.time,r.time),c=e.time;return c>=s&&c<=d||void 0}_getCellTime(e){if(!e)return 0;const t=this,n=t.viewType;let i,r;if(e instanceof HTMLElement&&e.closest(".smart-scheduler-cell:not(.scale)")){if(!e.$||!e.$.cellObj)return 0;i=e.$.cellObj}else i=e;if("agenda"===n)return i.vertical.date.getTime();if("month"===n){r=new Date(i.vertical.date);const e=new Date(i.horizontal.date).getDay()-t.firstDayOfWeek;return r.setDate(r.getDate()+(e<0?7+e:e)),r.getTime()}const a=i.scaleIndex||0,l=60/t._getCellsScaleCount()*60*1e3;return n.indexOf("timeline")<0?(r=new Date(i.horizontal.date),i.allDay||r.setHours(i.vertical.date.getHours())):r=new Date(i.horizontal.date),r.getTime()+l*a}_handleVerticalScroll(e){const t=this;if(!t.computedVerticalScrollBarVisibility)return!0;const n=t.scrollTop;0===n&&e.deltaY<0||n===t.scrollHeight&&e.deltaY>0?e.stopPropagation():(e.preventDefault(),t.mouseWheelStep>0?t.scrollTop=n+(e.deltaY<0?-t.mouseWheelStep:t.mouseWheelStep):t.scrollTo(n+t._getScrollCoefficient(e,t.offsetHeight)))}_handleHorizontalScroll(e){const t=this;if(!t.computedHorizontalScrollBarVisibility)return!0;const n=t.scrollLeft;0===n&&e.deltaY<0||n===t.scrollWidth&&e.deltaY>0?e.stopPropagation():(e.preventDefault(),t.scrollWidth>0&&t.scrollTo(void 0,t.scrollLeft+t._getScrollCoefficient(e,t.offsetWidth)))}_horizontalScrollbarHandler(e){const t=this;t._hscrollTimer&&clearTimeout(t._hscrollTimer),t.$.timelineContainer.scrollLeft=t._getScrollLeft(e.detail.value),t.dataSource&&t.dataSource.length>100?(t._recycle(e,!1),t._hscrollTimer=setTimeout((()=>{t._recycle(e)}),25)):t._recycle(e)}_verticalScrollbarHandler(e){const t=this;t._scrollTimer&&clearTimeout(t._scrollTimer),t.$.timelineContainer.scrollTop=Math.round(e.detail.value),t.dataSource&&t.dataSource.length>100?(t._recycle(e,!1),t._scrollTimer=setTimeout((()=>{t._recycle(e)}),25)):t._recycle(e)}_recycle(e,t){const n=this,i=n._timelineCells,r=n.$.tooltip;if(i.vertical&&i.horizontal){if(r.visible&&n.$.timeline.contains(r.selector)&&r.close(),!e)return n._recycleHeaderCells(n.$.timelineHeaderHorizontalContent),n._recycleHeaderCells(n.$.timelineHeaderVerticalContent),n._refreshTimelineContentCells(),n._refreshTimelineAllDayCells(),void(!1!==t&&n._refreshEvents());if("horizontal"===e.context.orientation)return n._recycleHeaderCells(n.$.timelineHeaderHorizontalContent),n._refreshTimelineContentCells(),n._refreshTimelineAllDayCells(),void(!1!==t&&n._refreshEvents());n._recycleHeaderCells(n.$.timelineHeaderVerticalContent),n._refreshTimelineContentCells(),!1!==t&&n._refreshEvents()}}_recycleHeaderCells(e){const t=this,n=t.rightToLeft,[i,r,a,l]=e===t.$.timelineHeaderHorizontalContent?["horizontal","left","width","scrollLeft"]:["vertical","top","height","scrollTop"],o=e.querySelector(".smart-scheduler-view-time"),s=t._timelineCells[i];if(!s||!s.length)return;const d=t._getFirstCellObjInView(i),c=t._getTimelineVisibleCellsCount(i),u=o.children;for(let e=0;e<u.length;e++){const l=u[e],o=l.children;let h=document.createDocumentFragment();for(;o.length;)h.appendChild(l.firstElementChild);t._recycleContainerCells({fragment:h,cellsNeeded:c});let m=s.indexOf(d);for(let l=0;l<h.children.length;l++){const o=h.children[l],d=s[m];if(o.$={cellObj:d},!d)break;"horizontal"===i?n?(o.style.left="",o.style.right=d.left+"px"):(o.style.right="",o.style.left=d.left+"px"):o.style[r]=d[r]+"px",o.style[a]=d[a]+"px",o.innerHTML=`<div>${d.noLabel?"":t._getDateString({date:new Date(d.date),timeZone:u[e].timeZone},i)}</div>`,d.weekend?o.setAttribute("weekend",""):o.removeAttribute("weekend"),d.nonworking?o.setAttribute("nonworking",""):o.removeAttribute("nonworking"),d.separator?o.setAttribute("separator",""):o.removeAttribute("separator"),d.groupSeparator?o.setAttribute("group-separator",""):o.removeAttribute("group-separator"),d.showLabel?o.setAttribute("show-label",d.showLabel):o.removeAttribute("show-label"),d.restricted?o.setAttribute("restricted",""):o.removeAttribute("restricted"),m++}l.appendChild(h)}t._refreshHeaderDetailCells(i),t._refreshHeaderGroupCells(i),e[l]="scrollLeft"===l?t._getScrollLeft(t[l]):t[l]}_moveHandler(e){const t=this;t._isMobile||e.stopPropagation(),(t.hasAttribute("dragged")||t.hasAttribute("resized"))&&"touchmove"===e.originalEvent.type&&e.originalEvent.preventDefault()}_getScrollLeft(e){return this.rightToLeft?e*=-1:e}_containerClickHandler(e){const t=this;if(t.readonly||t.hasAttribute("modal"))return;const n=t.$.tooltip;let i=(e||e.originalEvent).target;if(t.$.dateSelectorContainer.contains(i)){const e=i.closest(".smart-scheduler-nav");return e&&e.hasAttribute("current")&&t.disableDateMenu?void n.close():void t._handleDateSelection(e)}if(!n.contains(i)){if(i.closest(".smart-scheduler-view-items-button")){if(t.disableViewMenu)return void n.close();const e=n.visible&&!n.contains(t.$.viewItemsContainer);return t._handleTooltipContent(t.$.viewItemsButton),void(e||n.toggle())}if(i.classList.contains("smart-scheduler-legend-res-item"))t._handleLegendItemClick(i);else if(t._isMobile&&(t.$.timelineContent.classList.add("hide-overlay"),i=(t.shadowRoot||document).elementFromPoint(e.pageX-window.pageXOffset,e.pageY-window.pageYOffset),t.$.timelineContent.classList.remove("hide-overlay")),!i.closest(".smart-scheduler-event")&&(n.close(),t.$.viewSelectorContainer.contains(i))){const e=i.closest(".smart-scheduler-nav");if(e)return void t._handleViewNavigation(e);const n=i.closest(".smart-scheduler-item");n===t.$.showWeekendItem?t._checkHideWekendItem(n):t._handleViewSelection(n)}}}_handleLegendItemClick(e){const t=this,n=t._legend;if(!t.filterable||!n)return;e.hasAttribute("unselected")?(e.removeAttribute("unselected"),e.setAttribute("aria-selected",!0)):(e.setAttribute("unselected",""),e.setAttribute("aria-selected",!1));const i=n.querySelectorAll(".smart-scheduler-legend-res-item[unselected]");let r=[],a={};for(let e=0;e<i.length;e++){const t=i[e],n=t.getAttribute("resource"),r=t.getAttribute("resource-id");a[n]||(a[n]=[]),a[n].push(r+"")}for(let e in a)r.push({name:e,value:t=>!a[e].includes(t+"")});t.set("filter",null),r.length&&t.set("filter",r),t._refreshTimelineEvents()}_containerContextMenuHandler(e){const t=this;let n=e.target;if(t.disableContextMenu)return;const i=e.pageX-window.pageXOffset,r=e.pageY-window.pageYOffset;if(t._isMobile&&(t.$.timelineContent.classList.add("hide-overlay"),n=(t.shadowRoot||document).elementFromPoint(i,r),t.$.timelineContent.classList.remove("hide-overlay")),t.$.timelineContent.contains(n)||t.$.timelineViewAllDayContent.contains(n)){if(e.preventDefault(),n=n.closest(".smart-scheduler-event")||n.closest(".smart-scheduler-cell"),!n||t.disableContextMenu)return;n.classList.contains("smart-scheduler-event")&&t._handleCellSelection(),t._handleTooltipContent(n,{x:e.pageX,y:e.pageY})}else t.$.tooltip.close()}_handleViewNavigation(e){const t=this;let n;if(!e)return;const i=t.$.viewItemsContainer;n=e instanceof Smart.RepeatButton?10*(e.hasAttribute("prev")?-1:1):e.deltaY,i.scrollLeft+=t._getScrollLeft(n);const r=t._viewButtons;if(!r)return;n=i.scrollLeft;const a=r.prev,l=r.next;a.disabled=!n,l.disabled=i.offsetWidth+Math.abs(n)===i.scrollWidth}_handleDateSelection(e){const t=this,n=t.$.tooltip;if(e instanceof HTMLElement)if(e.hasAttribute("prev"))n.close(),t._navigateDate(-1);else if(e.hasAttribute("current")){const e=n.visible&&!n.contains(t._calendar);t._handleTooltipContent(t.$.currentDate),e||n.toggle()}else e.hasAttribute("next")?(n.close(),t._navigateDate(1)):e.hasAttribute("today")&&(n.close(),t._navigateDate())}navigateToDate(e){const t=this;if(e instanceof Date)e=new Date(e);else{if(e instanceof HTMLElement&&(!e.classList.contains("smart-scheduler-cell")||!t.$.timeline.contains(e)))return;if("object"==typeof e){const n=new Date(t.dateCurrent);e.year=void 0!==e.year?e.year:n.getFullYear(),e.month=void 0!==e.month?e.month:n.getMonth(),e.date=void 0!==e.date?e.date:n.getDate(),e=new Date(e.year,e.month,e.date,e.hours,e.getMinutes)}else if("string"==typeof e){if(e.indexOf("Date")>=0){e=(e=e.replace("new Date(","").replace(")","")).split(", ");let t="";for(let n=0;n<e.length;n++)t+=e[n],n<2?t+="-":2===n?t+=" ":n<e.length-1&&(t+=":");e=t}e=new Date(e)}}let n=e;t._refreshDateNavButtons(n),n.getTime()>t.max||n.getTime()<t.min||(t.set("dateCurrent",n),t.dateCurrent.getTime()!==n.getTime()&&t.$.fireEvent("dateChange",{oldValue:new Date(t.dateCurrent),value:new Date(n)}),t._calendar&&(t._calendar.selectedDates=[new Date(n)],t.$.tooltip.contains(t._calendar))||(t._createTimeline(),t._refreshDateSelector()))}_navigateDate(e){const t=this,n=t.viewType.toLowerCase();let i=t.dateCurrent,r=new Date(i);if(void 0===e)r=new Date;else{if(r.setHours(0,0,0,0),n.includes("day"))r.setDate(r.getDate()+e);else if(n.includes("week")||"agenda"===n){r.setDate(r.getDate()+7*e);const n=t.views.find((e=>e.value&&e.value===t.view))||{};if(n.additionalDays){let t=new Smart.Utilities.DateTime(i);t=t.addDays(e*(6+n.additionalDays)),r=t.toDate(),r.setHours(0,0,0,0)}}else{let t=new Date(r);e>0?(t.setDate(1),t.setMonth(t.getMonth()+2),t.setDate(0)):t.setDate(0),r.setMonth(r.getMonth()+e),r.getMonth()!==t.getMonth()&&(r=t)}r.setHours(i.getHours(),i.getMinutes(),i.getSeconds(),i.getMilliseconds())}t._refreshDateNavButtons(r),r.getTime()>t.max||r.getTime()<t.min||(t.set("dateCurrent",r),i.getTime()!==r.getTime()&&t.$.fireEvent("dateChange",{oldValue:new Date(i),value:new Date(r)}),t._calendar&&(t._calendar.selectedDates=[new Date(r)],t.$.tooltip.contains(t._calendar))||(t._createTimeline(),t._scrollTo(r),t._refreshDateSelector()))}_refreshDateNavButtons(e){const t=this;e||(e=t.dateCurrent);const n=t.$.dateSelectorContainer,i=n.querySelector(".smart-scheduler-nav[prev]"),r=n.querySelector(".smart-scheduler-nav[next]");i&&(i.disabled=e.getTime()<=t.min),r&&(r.disabled=e.getTime()>=t.max)}_handleTooltipContent(e,t){const n=this,i=n.$.tooltip;if(e){if(e===n.$.currentDate){i.selector=e,i.position="auto",i.arrow=!0;let t=n._calendar;t||(t=document.createElement("smart-calendar"),t.firstDayOfWeek=n.firstDayOfWeek,t.selectionMode="oneExtended",t.selectedDates=[new Date(n.dateCurrent)],t.max=n.max,t.min=n.min,t.rightToLeft=n.rightToLeft,t.locale=n.locale,t.id=n.id+"Calendar",t.classList.add("smart-scheduler-calendar-popup"),n._calendar=t),r(t)}else if(e===n.$.viewItemsButton)i.selector=e,i.position="auto",i.arrow=!0,r(n.$.viewItemsContainer),n._handleViewSelection(),n._checkHideWekendItem();else if(e.classList.contains("smart-scheduler-event")||e.classList.contains("smart-scheduler-cell")){let a,l=n._list;if(l||(n._list=l=document.createElement("smart-scroll-viewer"),l.horizontalScrollBarVisibility="hidden"),l.theme=n.theme,l.tabIndex=n.tabIndex,l.rightToLeft=n.rightToLeft,n.inverted?l.setAttribute("inverted",""):l.removeAttribute("inverted"),a=t?n._getContextMenu(e):n._getEventList(e),!a||!a.innerHTML)return;if(n._handleEventItemSelection(),l.contains(a)){if(i.selector===e&&i.contains(l)){if(t){const e=n.getBoundingClientRect();return i.style.top=Math.min(t.y+1,e.bottom+window.pageYOffset-i.offsetHeight)+"px",i.style.left=Math.min(t.x+1,e.right+window.pageXOffset-i.offsetWidth)+"px",i.visible&&n._fireTooltipVisibilityEvent({type:"opening",detail:{owner:i.selector}})?(n._skipEventFiring=!0,i.close(),void delete n._skipEventFiring):void i.open()}return i.visible&&i.selector&&i.selector.focus({preventScroll:!0}),l.refresh(),void i.toggle()}}else l.isCompleted&&l.removeAll(),l.appendChild(a);if(i.selector=e,r(l),l.refresh(),t){const e=n.getBoundingClientRect();i.style.top=Math.min(t.y+1,e.bottom+window.pageYOffset-i.offsetHeight)+"px",i.style.left=Math.min(t.x+1,e.right+window.pageXOffset-i.offsetWidth)+"px"}if(i.visible)return n._fireTooltipVisibilityEvent({type:"opening",detail:{owner:i.selector}})?(n._skipEventFiring=!0,i.close(),void delete n._skipEventFiring):void(t||i.reposition());i.visible||i.open()}}else i.close();function r(e){e&&!i.contains(e)&&(i.clear(),i.appendChild(e))}}_getContextMenu(e){const t=this,n=t.$.tooltip;let i,r,a=t._contextList,l=t.contextMenuDataSource;if(e.classList.contains("smart-scheduler-event")&&!e.hasAttribute("collector")){const n=e.$?e.$.event:void 0;n&&n.$&&n.$.event&&(r=!0),l||(l=["create","edit","delete"],t.contextMenuClipboardActions&&["copy","cut"].forEach((e=>l.push(e))))}else{if(!e.classList.contains("smart-scheduler-cell"))return void n.close();i=!0,l||(l=["create"],t.contextMenuClipboardActions&&l.push("paste"))}n.position="absolute",n.arrow=!1,a||(t._contextList=a=document.createElement("div"),a.classList.add("smart-scheduler-context-menu"),a.setAttribute("role","listbox"),a.setAttribute("aria-label","Context Menu"));const o=document.createDocumentFragment(),s=Array.from(a.children),d=t.hideOtherMonthDays;let c=["copy","cut"];for(let e=0;e<s.length;e++){const t=s[e];l.indexOf(t.getAttribute("value"))<0&&t.remove()}for(let n=0;n<l.length;n++){const a=l[n];let u,h,m=s[n];"object"==typeof a?(u=a.label,h=a.value):u=h=a+"",m||(m=document.createElement("div"),m.classList.add("smart-scheduler-context-menu-item"),m.setAttribute("role","option")),m.parentElement||o.appendChild(m),e.hasAttribute("restricted")||d&&e.hasAttribute("other-month")?m.setAttribute("disabled",""):i&&"paste"===h?t._clipboard?m.removeAttribute("disabled"):m.setAttribute("disabled",""):r&&c.indexOf(h)>-1?m.setAttribute("disabled",""):m.removeAttribute("disabled"),m.innerHTML=t.localize(u)||u,m.setAttribute("value",h)}return a.appendChild(o),a}_getEventList(e){const t=this;if(!e.classList.contains("smart-scheduler-event")||!e.$)return;const n=e.hasAttribute("collector"),i=n?e.$.events:[e.cloneNode(!0)];let r=t._eventList;if(!i||!i.length)return void(r&&(r.innerHTML=""));const a=t.$.tooltip;a.position="auto",a.arrow=!0,r||(r=document.createElement("div"),r.classList.add("smart-scheduler-collector-event-list"),r.setAttribute("role","menu"),r.id=t.id+"EventMenu",t._eventList=r),r._target=e;const l=document.createDocumentFragment(),o=Array.from(r.children),s={isAllDayEvent:t.$.timelineViewAllDay.contains(e),isTooltipEvent:!0};for(let e=0;e<o.length;e++){const t=o[e];i.indexOf(t)<0&&t.remove()}for(let r=0;r<i.length;r++){const a=i[r];n||(a.$=e.$),s.eventObj=a.$.event,s.isAllDayEvent=s.eventObj.allDay,t._setEventCellContent(a,s),l.appendChild(i[r])}return r.appendChild(l),r}_tooltipVisibilityHandler(e){const t=this,n=e.type,i=t.$.tooltip,r=t.getRootNode().host||t.getRootNode();e.stopPropagation(),t._skipEventFiring||!t._fireTooltipVisibilityEvent(e)?(r===document||document.body.contains(r))&&("opening"===n?(i.classList.remove("smart-visibility-hidden"),t.getShadowRootOrBody().appendChild(i)):"closing"===n&&(t.hasAnimation?i.addEventListener("animationend",(()=>{i.visible||(i.classList.add("smart-visibility-hidden"),i.style.top=i.style.left=0,t.$.container.appendChild(i))}),{once:!0}):t.$.container.appendChild(i))):e.preventDefault()}_fireTooltipVisibilityEvent(e){const t=this,n=e.type,i=t.$.tooltip,r=i.contains(t._contextList),a=i.contains(t._eventList),l=e.detail.owner;let o,s={target:i,owner:l};if(r)if(l.classList.contains("smart-scheduler-event"))s.eventObj=[t._cloneObject(l.$.event)];else{let e,n;if(t._selectedCellObj){const i=t._selectedCellObj.from,r=t._selectedCellObj.to,a=Math.min(i.time,r.time),l=Math.max(i.time,r.time);e=a===l?[new Date(a)]:[new Date(a),new Date(l)],n=i.vertical.group||i.horizontal.group}else{const t=l.$.cellObj;e=[new Date(t.time)],n=t.vertical.group||t.horizontal.group}s.cellObj={date:e},n&&(s.group=n)}else a&&(l.$.events?s.eventObj=l.$.events.map((e=>t._cloneObject(e.$.event))):l.$.event&&(s.eventObj=[t._cloneObject(l.$.event)]));if("open"===n||"close"===n){r?o="contextMenu":a?o="eventMenu":i.contains(t._calendar)?o="dateMenu":i.contains(t.$.viewItemsContainer)&&(o="viewMenu");let e=(t.getAttribute("aria-owns")||"")+" "+i.id;return"open"===n?t.setAttribute("aria-owns",e.trim()):t.hasAttribute("aria-owns")&&(e=t.getAttribute("aria-owns").replace(i.id,"").trim(),e?t.setAttribute("aria-owns",e):t.removeAttribute("aria-owns")),void(o&&t.$.fireEvent(o+("open"===n?"Open":"Close"),s))}if(r?o="opening"===n?"contextMenuOpening":"contextMenuClosing":a&&(o="opening"===n?"eventMenuOpening":"eventMenuClosing"),o&&t.$.fireEvent(o,s).defaultPrevented)return!0}_tooltipChangeHandler(e){const t=this,n=t._calendar;if(e.target===n){e.stopPropagation();const i=t.dateCurrent;return t.set("dateCurrent",n.selectedDates[0]||t.dateCurrent),t.dateCurrent.getTime()!==i.getTime()&&t.$.fireEvent("dateChange",{oldValue:new Date(t.dateCurrent),value:new Date(i)}),t._refreshDateSelector(),t._createTimeline(),void e.context.close()}}_tooltipClickHandler(e){const t=this,n=t.$.tooltip,i=t.isInShadowDOM?(e||e.originalEvent).composedPath()[0]:(e||e.originalEvent).target;if(t.$.viewItemsContainer.contains(i)){const e=i.closest(".smart-scheduler-item");return e===t.$.showWeekendItem?t._checkHideWekendItem(e):t._handleViewSelection(e),void n.close()}const r=i.closest(".smart-scheduler-event");if(r)return i.closest(".smart-scheduler-event-button")?void t._handleEventMenuDelete(r):void t._doubleClickHandler(i);const a=i.closest(".smart-scheduler-context-menu-item");a&&t._handleContextMenuItemClick(a)}_handleEventMenuDelete(e){const t=this,n=t.$.tooltip,i=e.$?e.$.event:void 0;if(n.close(),!i)return void t.$.timeline.focus({preventScroll:!0});const r=i.$?i.$.event:void 0;if(r){const n=r&&r.repeat?r.repeat.exceptions:void 0;t._openWindow(n&&n.indexOf(i)>-1?i:Object.assign({},i,{dateStart:e.$.dateStart,dateEnd:e.$.dateEnd}),e,"deleteConfirm")}else t._deleteEventViaWindow(i),t.$.timeline.focus({preventScroll:!0})}_tooltipKeyDownHandler(e){this._keyDownHandler(e)}_tooltipKeyUpHandler(e){this._keyUpHandler(e)}_tooltipDownHandler(e){e.stopPropagation(),this._downHandler(e)}_tooltipContextMenuHandler(e){const t=e.target;t&&t.closest&&t.closest(".smart-scheduler-event")&&e.preventDefault()}_timelineFocusHandler(e){const t=this;if("focusin"===e.type||"focusout"===e.type)return void t._handleEventFocus(e);if(t.readonly||t.hasAttribute("modal"))return;const n=t.$.timelineViewAllDay,i=n.offsetHeight>0;if(!(t._isMobile||t._dragDetails&&t._dragDetails.timelineCellObj))if(t._selectedCellObj){const n=e.relatedTarget,i=t.$.schedulerWindow,r=t.$.confirmWindow;if(i&&i.contains(n)||r&&r.contains(n))return;t._selectedCellObj.from.time!==t._selectedCellObj.to.time&&t._handleCellSelection(t._selectedCellObj.from)}else t._handleCellSelection((i?n:t.$.timelineContent).querySelector(".smart-scheduler-cell:not(.scale)"))}_handleEventFocus(e){const t=e&&"focusin"===e.type?e.target:void 0,n=t&&t.$?t.$.event:void 0,i=this.$.timeline.querySelectorAll(".smart-scheduler-event");let r;for(let e=0;e<i.length;e++){const a=i[e],l=a.$.event;a===t||n&&n===l?(a.setAttribute("focus",""),r=a):a.removeAttribute("focus")}return r}_handleViewSelection(e){const t=this,n=t.$.showWeekendItem,i=t.$.viewItemsContainer.children,r=t.view;let a;if(e instanceof HTMLElement&&(a=e.$?e.$.value:null),a||(a=t.view),a===r||!t.$.fireEvent("viewChanging",{oldValue:r,value:a}).defaultPrevented){for(let t=0;t<i.length;t++){const n=i[t];n.removeAttribute("selected"),!e&&n.$&&n.$.value===a&&(e=n)}e&&e.setAttribute("selected",""),e!==n&&(a!==r&&(t.set("view",a),t._createTimeline(),t._refreshDateSelector(),t._checkHideWekendItem(),t._scrollToView(e),t.$.fireEvent("viewChange",{oldValue:r,value:a})),t.$.viewItemsButton.innerHTML=`<span>${e?e.textContent.trim():t.localize(a)||a}</span>`)}}_checkHideWekendItem(e){const t=this,n=t.viewType.toLowerCase().indexOf("day")<0,i=t.view,r=t.views.find((e=>e.value&&e.value===i))||{},a=r&&void 0!==r.hideWeekend?r.hideWeekend:void 0,l=a&&r.hideWeekend||t.hideWeekend;if(!e){if(!(e=t.$.showWeekendItem)||!e.parentElement)return;return e&&(l&&n?e.removeAttribute("checked"):e.setAttribute("checked","")),void(t.viewType.toLowerCase().indexOf("day")>-1?e.setAttribute("disabled",""):e.removeAttribute("disabled"))}if(!e||!e.parentElement||e!==t.$.showWeekendItem)return;e.hasAttribute("checked")?(e.removeAttribute("checked"),t.set("hideWeekend",!0)):(e.setAttribute("checked",""),t.set("hideWeekend",!1));const o=t.hideWeekend;void 0!==a&&(r.hideWeekend=o),l!==o&&n&&t._createTimeline()}_scrollToView(e){const t=this;if("tabs"!==t.viewSelectorType)return;const n=t.$.viewItemsContainer;if(!(e=e||n.querySelector(".smart-scheduler-item[selected]")))return;const i=n.offsetWidth,r=e.offsetLeft,a=r+e.offsetWidth;let l=n.scrollLeft;l>r?l=n.scrollLeft=r:l+i<a&&(l=n.scrollLeft=a-i);const o=t._viewButtons;o&&(o.prev.disabled=!l,o.next.disabled=Math.abs(l)+i===n.scrollWidth)}_resizeEventHandler(e){const t=this;function n(){if(t._noResizeHandler)return void delete t._noResizeHandler;t._refreshHeaderControlsVisibility();const e=t.$.tooltip;t._positionWindow(),t._createTimeline(),e.visible&&(e.contains(t._contextList)?e.close():e.reposition()),t._refreshViewSelector(),t._resizeLegend&&t._resizeLegend()}(e?t.enableShadowDOM?e.composedPath()[0]:e.target:void 0)===t&&(clearTimeout(t._resizeTimeout),t.resizeInterval?t._resizeTimeout=setTimeout(n.bind(t),t.resizeInterval):n())}_setScrollBars(){const e=this;e._scrollView||(e._scrollView=new Smart.Utilities.Scroll(e.$.timeline,e.$.horizontalScrollBar,e.$.verticalScrollBar));const t=e._scrollView.vScrollBar,n=e._scrollView.hScrollBar;n.$.addClass("smart-hidden"),t.$.addClass("smart-hidden"),t.hasStyleObserver=!1,n.hasStyleObserver=!1,t.hasResizeObserver=!1,n.hasResizeObserver=!1,n.wait=!1,t.wait=!1,e._refresh()}_setFocusable(){const e=this;if(e.disabled||e.unfocusable)return e.removeAttribute("tabindex"),e.$.timeline.removeAttribute("tabindex"),void e.$.viewItemsContainer.removeAttribute("tabindex");const t=e.tabIndex>0?e.tabIndex:0;e.tabIndex=t,e.$.tooltip.tabIndex=t,e.$.timeline.tabIndex=t,e.$.viewItemsContainer.tabIndex=t}_toHex(e){function t(e){const t=new Array("0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f");return isNaN(e)?"00":t[(e-e%16)/16]+t[e%16]}return(e=e.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/))?"#"+t(e[1])+t(e[2])+t(e[3]).toUpperCase():"#ffffff"}_setExportStyles(e,t){const n=this;if(e.style)return;const i=e.header.columns,r=window.getComputedStyle(n),a={height:r.getPropertyValue("--smart-scheduler-timeline-header-horizontal-cells-size"),border:"1px solid "+n._toHex(r.borderColor),fontFamily:"Helvetica",fontSize:r.fontSize,color:n._toHex(r.color),backgroundColor:n._toHex(r.backgroundColor),fontWeight:"400"},l={border:"1px solid "+n._toHex(r.borderColor),fontFamily:r.fontFamily,fontSize:r.fontSize},o=n._timelineCells;let s,d;o&&o.vertical&&o.horizontal&&(s=o.vertical[0]?o.vertical[0].height:void 0,d=o.horizontal[0]?o.horizontal[0].width:void 0),void 0===s&&(s=Math.max(parseFloat(r.getPropertyValue("--smart-scheduler-timeline-cell-height"))||0,parseFloat(r.getPropertyValue("--smart-scheduler-timeline-cell-min-height")||0))),void 0===d&&(d=Math.max(parseFloat(r.getPropertyValue("--smart-scheduler-timeline-cell-width"))||0,parseFloat(r.getPropertyValue("--smart-scheduler-timeline-cell-min-width")||0))),"pdf"===t?d=100/i.length+"%":d+="px",s+="px";for(let e=0;e<i.length;e++){const t=i[e];a[t.dataField]={textAlign:"center",width:d},l[t.dataField]={textAlign:"start",format:t.dataField.indexOf("date")>-1?"f":""}}e.style={border:"1px solid "+n._toHex(r.borderColor),borderCollapse:"collapse",header:a,columns:l,rows:{height:s}}}_getExportRecord(e){const t=this,n=t.locale,i=t._events,r=t.resources,a=i[0],l=t.yearFormat,o=t.monthFormat,s=t.dayFormat,d=t.hourFormat,c=t.minuteFormat;let u=t.dataExport.columns,h={};if(!u||!u.length){const e=["id","label","description","dateStart","dateEnd"];u=Object.keys(a).filter((t=>e.indexOf(t)>-1)),r.forEach((e=>u.push(e.value)))}for(let a=0;a<u.length;a++){const m=u[a],v=r.find((e=>e.value===m));if(e){if(v&&e[v.value]){if(v&&v.dataSource){const t=v.dataSource.find((t=>t.id===e[v.value]));h[m]=t&&t.label||""}}else{const t=e[m];t instanceof Date?h[m]=new Intl.DateTimeFormat(n,{year:l,month:o,day:s,hour:d,minute:c}).format(t):h[m]=t||""}h._keyDataField=i.indexOf(e)}else h[m]=(v?v.label:t.localize(m)||m)||""}return h}_refresh(){const e=this;function t(){const t=e.$.timelineContent.offsetWidth-e.$.timelineContainer.offsetWidth;return t>0&&"hidden"!==e.horizontalScrollBarVisibility||"visible"===e.horizontalScrollBarVisibility?e.$container.addClass("hscroll"):e.$container.removeClass("hscroll"),t}function n(){const t=e.$.timelineContent.offsetHeight-e.$.timelineContainer.offsetHeight;return t>0&&"hidden"!==e.verticalScrollBarVisibility||"visible"===e.verticalScrollBarVisibility?e.$container.addClass("vscroll"):e.$container.removeClass("vscroll"),t}const i=e.scrollWidth,r=e.scrollHeight;let a=t(),l=n();l&&r===l||(a=t()),a&&i===a||(l=n()),e.scrollWidth=a,e.scrollHeight=l,e.$.horizontalScrollBar.refresh(),e.$.verticalScrollBar.refresh()}_setHeader(){const e=this,t=e.$.header,n=e.$.todayDate;if(e.headerTemplate)e._applyTemplate("headerTemplate",t);else{const n=e.$.dateSelectorContainer;t.contains(n)||(t.innerHTML="",t.appendChild(n),t.appendChild(e.$.viewSelectorContainer)),e._setLegend(t)}t.contains(n)&&(n.innerHTML=`<span>${e.localize("today")}</span>`),e._refreshDateSelector(),e._refreshViewSelector(),e._refreshHeaderControlsVisibility()}_refreshHeaderControlsVisibility(){const e=this,t=e.viewSelectorType;if("tabs"===t||"auto"===t&&!e._isMobile)return;const n=e.offsetWidth,i=e.$.todayDate,r=e.$.currentDate;n<=500?i.classList.add("smart-hidden"):i.classList.remove("smart-hidden"),n<=320?r.classList.add("smart-hidden"):r.classList.remove("smart-hidden")}_setFooter(){const e=this,t=e.$.footer;if(null===e.footerTemplate)return t.innerHTML=null,e._setLegend(t),void(t.children.length||e.$.container.removeAttribute("show-footer"));e.$.container.setAttribute("show-footer",""),e._applyTemplate("footerTemplate",t)}_setLegend(e){const t=this,n=t.$.footer,i="header"===t.legendLocation?t.$.header:n;if(e&&e!==i)return;let r=t._legend;if(!t.showLegend)return r&&(r.innerHTML="",r.remove()),void(i!==n||n.children.length||t.$.container.removeAttribute("show-footer"));r||(r=t._legend=document.createElement("div"),r.classList.add("smart-scheduler-legend"),r.setAttribute("role","presentation"));const a=t.resources,l=1===a.length,o=r.children;for(let e=0;e<a.length;e++)a[e].dataSource.length&&t._refreshLegendItems(e,l);for(;a.length<o.length;)o.lastElementChild.remove();i.contains(r)||i.appendChild(r)}_refreshLegendItems(e,t){const n=this,i=n.resources[e],r=n._legend;let a,l,o=r.children[e];o||(o=document.createElement("div"),o.classList.add("smart-scheduler-legend-item"),o.setAttribute("role","listbox")),o.setAttribute("resource",i.value+"");const s=o.children;for(let e=0;e<s.length;e++){const t=s[e];t.classList.contains("smart-scheduler-legend-res-label")?a=t:t.classList.contains("smart-scheduler-legend-res-items")&&(l=t)}a||t?a&&t&&a.remove():(a=document.createElement("label"),a.classList.add("smart-scheduler-legend-res-label"),a.id=n.id+"LegendResourceLabel"),a&&(a.textContent=i.label||"",o.setAttribute("aria-labelledby",a.id)),l||(l=document.createElement("div"),l.classList.add("smart-scheduler-legend-res-items"),l.setAttribute("role","presentation")),n._refereshLegendResItems(i,l),o.contains(l)||o.appendChild(l),t||o.contains(a)||o.insertBefore(a,l),r.contains(o)||r.appendChild(o)}_refereshLegendResItems(e,t){const n=this,i=n.filter,r=t.children,a=Math.max(n.tabIndex,0),l=e.dataSource,o=e.value;let s=0;for(let e=0;e<l.length;e++){const n=l[e];let d=r[e];if(d||(d=document.createElement("div"),d.classList.add("smart-scheduler-legend-res-item"),d.setAttribute("role","option")),d.innerHTML=`<span>${n.label||""}</span>`,d.title=n.label,s+=n.label.length,d.setAttribute("aria-label",n.label),d.setAttribute("resource",o+""),d.setAttribute("resource-id",n.id+""),i&&Array.isArray(i)){let e=i.find((e=>e.name===o));e&&"function"==typeof e.value&&!e.value(n.id)?d.setAttribute("unselected",""):d.removeAttribute("unselected")}else d.removeAttribute("unselected");n.disabled?(d.setAttribute("disabled",""),d.removeAttribute("tabindex"),d.removeAttribute("aria-selected")):(d.removeAttribute("disabled"),d.setAttribute("tabindex",a),d.hasAttribute("unselected")?d.setAttribute("aria-selected",!1):d.setAttribute("aria-selected",!0)),n.backgroundColor?d.style.setProperty("--smart-scheduler-legend-item-background",n.backgroundColor):d.style.removeProperty("--smart-scheduler-legend-item-background"),t.contains(d)||t.appendChild(d)}for(;l.length<r.length;)t.lastElementChild.remove();n._resizeLegend=()=>{let e=14*s*.52;const i=[...t.querySelectorAll(".smart-scheduler-legend-res-item")];i.forEach((e=>{e.classList.remove("smart-hidden")})),"auto"===this.legendLayout?e>n.offsetWidth?(t.querySelectorAll("span").forEach((e=>{e.classList.add("smart-hidden")})),n.offsetWidth<550||i.length>n.legendLayoutMenuBreakpoint?(i.forEach((e=>{e.classList.add("smart-hidden")})),n._legendList.close(),n._legendList.classList.remove("smart-hidden")):(n._legendList.close(),n._legendList.classList.add("smart-hidden"))):(n._legendList.close(),n._legendList.classList.add("smart-hidden"),t.querySelectorAll("span").forEach((e=>{e.classList.remove("smart-hidden")}))):""===this.legendLayout?(n._legendList.close(),n._legendList.classList.add("smart-hidden"),t.querySelectorAll("span").forEach((e=>{e.classList.remove("smart-hidden")}))):"menu"===this.legendLayout&&(t.querySelectorAll("span").forEach((e=>{e.classList.add("smart-hidden")})),i.forEach((e=>{e.classList.add("smart-hidden")})),n._legendList.close(),n._legendList.classList.remove("smart-hidden"))},(()=>{const e=document.createElement("smart-check-input");e.classList.add("smart-scheduler-legend-list"),e.dataSource=l.map((e=>{const t=e.label,n=""+e.id;return{label:t,color:e.backgroundColor,value:n}})),e.readonly=!0,e.dataSource.length>10?e.dropDownHeight=200:e.dropDownHeight="auto",e.dropDownOpenPosition="auto",e.dropDownButtonPosition="none",e.checkAll(),e.onItemClick=e=>{const n=e.detail.index;t.children[n].click()},t.appendChild(e),n._legendList=e,e.classList.add("smart-hidden")})(),n._resizeLegend()}_refreshDateSelector(){const e=this,t=e.locale,n=e.$.currentDate;if(!e.$.header.contains(n))return;let i=new Smart.Utilities.DateTime(new Date(e.dateCurrent)).toDate(e.timeZone);isNaN(i.getTime())&&(i=new Date);let r="";if(e.dateSelectorFormatFunction)r=e.dateSelectorFormatFunction(i)+"";else{const n=e.viewType.toLowerCase(),a=e.dayFormat,l=e.monthFormat,o=e.yearFormat;if(n.indexOf("day")>-1)r=new Intl.DateTimeFormat(t,{day:a}).format(i);else if(n.indexOf("week")>-1||"agenda"===n){let s=new Date(i);"agenda"!==n&&s.setDate(s.getDate()-s.getDay()+e.firstDayOfWeek),"dateCurrent"===e.viewStartDay&&(s=new Date(i));let d=new Date(s);d.setDate(d.getDate()+6);const c=e.views.find((t=>t.value&&t.value===e.view))||{};if(c.additionalDays){let e=new Smart.Utilities.DateTime(s);e=e.addDays(6+c.additionalDays),d=e.toDate()}r=new Intl.DateTimeFormat(t,{day:a}).format(s),s.getMonth()!==d.getMonth()&&(r+=" "+new Intl.DateTimeFormat(t,{month:l}).format(s)),s.getFullYear()!==d.getFullYear()&&(r+=" "+new Intl.DateTimeFormat(t,{year:o}).format(s)),r+="-"+new Intl.DateTimeFormat(t,{day:a}).format(d),i=d}r+=" "+new Intl.DateTimeFormat(t,{month:l}).format(i)+" "+new Intl.DateTimeFormat(t,{year:o}).format(i)}n.innerHTML=r}_refreshViewSelector(){const e=this,t=e.views,n=e.viewSelectorType,i=e.$.viewSelectorContainer,r=e.$.viewItemsContainer,a=e.$.viewItemsButton,l=e.$.tooltip,o=l.contains(r);let s=e.$.showWeekendItem;if(!e.$.header.contains(a))return;for(i.classList.add("smart-visibility-hidden"),a.classList.add("smart-visibility-hidden"),i.classList.remove("no-overflowing"),r.remove(),s&&s.remove();t.length<r.children.length;)r.firstElementChild.remove();for(;t.length>r.children.length;){const e=document.createElement("div");e.classList.add("smart-scheduler-item"),e.setAttribute("role","option"),r.appendChild(e)}const d=r.children;for(let n=0;n<d.length;n++){const i=d[n],r=t[n];let a,l;if("string"==typeof t[n])i.innerHTML="<div>"+e.localize(a=t[n])+"</div>";else{const t=r.label;a=r.value,i.innerHTML="<div>"+("string"!=typeof t&&isNaN(t)?e.localize(a):t)+"</div>",l=r.shortcutKey}void 0===l&&(l=e.localize(a+"Shortcut")),l?i.setAttribute("shortcut-key",e.localize(l)||l):i.removeAttribute("shortcut-key"),i.$={value:a}}if(i.appendChild(r),e._viewButtons)for(let t in e._viewButtons)e._viewButtons[t].remove();const c=i.offsetWidth-r.offsetWidth<0;if("tabs"===n){let t,n;return o&&l.close(),c&&(e._viewButtons||(t=document.createElement("smart-repeat-button"),n=document.createElement("smart-repeat-button"),t.classList.add("smart-scheduler-nav"),n.classList.add("smart-scheduler-nav"),t.setAttribute("prev",""),n.setAttribute("next",""),t.setAttribute("aria-label","Previous View"),n.setAttribute("aria-label","Next View"),e._viewButtons={prev:t,next:n}),t=e._viewButtons.prev,n=e._viewButtons.next,i.classList.add("no-overflowing"),i.insertBefore(t,r),i.appendChild(n),e._scrollToView()),i.removeAttribute("show-menu"),i.classList.remove("smart-visibility-hidden"),void e._handleViewSelection()}delete e._viewButtons,"menu"===n||c?(e.hideViewMenuCheckableItems?s&&s.remove():r.contains(s)||(s||(s=e.$.showWeekendItem=document.createElement("div"),s.classList.add("smart-scheduler-item"),s.setAttribute("checkable",""),s.setAttribute("separator","")),s.innerHTML="<div>"+e.localize("showWeekends")+"</div>",e._checkHideWekendItem(),r.appendChild(s)),o?(l.clear(),l.appendChild(r)):r.remove(),i.setAttribute("show-menu",""),a.classList.remove("smart-visibility-hidden")):(i.removeAttribute("show-menu"),o&&l.close()),i.classList.remove("smart-visibility-hidden"),e._handleViewSelection()}_checkNotifications(e){const t=this,n=t._events,i=t.$.toast;if(e&&(i&&i.isCompleted&&i.items.forEach((e=>{e.classList.contains("smart-scheduler-event-notification")&&i.closeItem(e)})),delete t._notificationObj,delete t._notificationsInterval),clearInterval(t._notificationsInterval),!n)return t._removeToast(),delete t._notificationsInterval,void delete t._notificationObj;let r=t._notificationObj;if(r||(r=t._notificationObj={events:n.filter((e=>Array.isArray(e.notifications)))}),!r.events)return t._removeToast(),void delete t._notificationsInterval;t._notificationsInterval||t._refreshNotifications(),t._notificationsInterval=setInterval(t._refreshNotifications.bind(t),1e3*t.notificationInterval)}_removeToast(){const e=this,t=e.$.toast;if(t){const n=e.$toast;n.unlisten("open"),n.unlisten("close"),t.remove()}}_appendToast(){const e=this,t=e.$.toast;if(!e.$.container.contains(t)){const n=e.$toast;n.listen("open",e._toastVisibilityHandler.bind(e)),n.listen("close",e._toastVisibilityHandler.bind(e)),e.$.container.appendChild(t)}}_toastVisibilityHandler(e){const t=this.$.toast;e.target===t&&(e.stopPropagation(),this.$.fireEvent("open"===e.type?"notificationOpen":"notificationClose",e.detail))}_refreshNotifications(){const e=this,t=e._notificationObj;if(!t)return void clearInterval(e._notificationsInterval);const n=t.events;let i=new Date;if(i.setSeconds(0,0),i=i.getTime(),t.time===i)return;t.time=i;const r=e._getNotificationEvents(n,i);let a=[];for(let e=0;e<r.length;e++){const t=r[e],n=t.dateStart.getTime(),l=t.notifications;Array.isArray(l)&&l.forEach((e=>{const r=(e.interval||0)*("days"===e.type||0===e.type?1:7),l=e.time,o=new Date(n-24*r*60*60*1e3);o.setHours(l[0]%23,l[1]%60,0,0),o.getTime()===i&&a.push({dateStart:t.dateStart,label:t.label,message:e.message,iconType:e.iconType})}))}e._notifyForUpcomingEvents(a)}_getNotificationEvents(e,t){const n=this;let i=[];const r=t+24192e5,a=n._rRule,l={isMonthView:!0,hourStart:n.hourStart,hourEnd:n.hourEnd,restrictedDates:n.restrictedDates,restrictedHours:n.restrictedHours,dateStart:new Date(t),dateEnd:new Date(r),rRule:a,targetEvents:i};for(let o=0;o<e.length;o++){const s=e[o],d=s.dateStart,c=s.dateEnd;if(!d||!c)continue;const u=d.getTime(),h=c.getTime();if(s.repeat&&a){const e=n._getEventRepeatOptions(s);if(e){l.event=s,l.repeatObj=s.repeat,l.options=e,l.eventTimeStart=u,l.eventTimeEnd=h,n._setRepeatingEvents(l);continue}}else u>=t&&u<=r&&i.push(s)}return i}_notifyForUpcomingEvents(e){const t=this;if(!e.length)return;t._setToast();const n=t.$.toast;t._appendToast();const i=t.dayFormat,r=t.monthFormat,a=t.weekdayFormat,l=t.locale,o=t.hourFormat,s=t.minuteFormat,d=Smart.Utilities.DateTime,c=t.timeZone;for(let u=0;u<e.length;u++){const h=e[u],m=new d(h.dateStart).toDate(c),v=h.message?h.message:h.label+" "+t.localize("notificationMessage")+" "+new Intl.DateTimeFormat(l,{day:i,weekday:a,month:r}).format(m)+" at "+new Intl.DateTimeFormat(l,{hour:o,minute:s}).format(m);n.open(v,h.iconType)}}_setToast(){const e=this;let t=e.$.toast;t||(e.$.toast=t=document.createElement("smart-toast"),t.appendTo=e.$.timeline,t.showCloseButton=!0,t.itemClass="smart-scheduler-event-notification",e.$toast=Smart.Utilities.Extend(t)),t.rightToLeft=e.rightToLeft,t.theme=e.theme,t.animation=e.animation}_createEvents(e,t){const n=this;let i=void 0!==e;if(i||(e=n.dataSource,n._clearEvents()),n.dataSource instanceof Smart.DataAdapter&&(e="ics"===n.dataSource.dataSourceType?n.dataSource.dataSource:n.dataSource.toArray()),!Array.isArray(e)||!e.length)return;const r=n.viewType;let a=[];for(let i=0;i<e.length;i++){const l=e[i];if(!l)continue;let o,s,d=l.allDay;if("string"==typeof d&&(d="true"===d),d=!!d,o=n._dateValidator(void 0,l.dateStart),s=n._dateValidator(void 0,l.dateEnd),!o||!o.getTime())continue;switch(s&&s.getTime()||(s=new Date(o),s.setHours(s.getHours(),s.getMinutes()+60/n._getCellsScaleCount(),0,0)),s=new Date(Math.max(o.getTime(),s.getTime())),r){case"week":case"day":case"timelineWeek":case"timelineDay":d&&s.setHours(23,59,59,999);break;default:d&&0===s.getHours()&&0===s.getMinutes()&&0===s.getSeconds()&&0===s.getMilliseconds()&&(s=new Date(s.getTime()-1))}const c=Object.assign({},l,{dateStart:o,dateEnd:s,allDay:d,label:l.label||""});let u=c.repeat;if(u){u=c.repeat=Object.assign({},u);const e=["hourly","daily","weekly","monthly","yearly"];for(let t in u)if("repeatFreq"===t&&e.indexOf(u[t])<0)u[t]=e[0];else if("repeatInterval"===t)u[t]=isNaN(u[t])?1:u[t];else if("exceptions"===t){let e=u[t];e=Array.isArray(e)?e.slice():[e];for(let t=0;t<e.length;t++){let i=e[t];void 0===i.date?i={date:n._parseDate(i)}:(i=Object.assign({},i),i.date?i.date instanceof Date||(i.date=n._parseDate(i.date)):i.date=new Date(i.dateStart)),i.dateStart?i.dateStart instanceof Date||(i.dateStart=n._parseDate(i.dateStart)):i.dateStart=new Date(i.date),i.dateEnd?i.dateEnd instanceof Date||(i.dateEnd=n._parseDate(i.dateEnd)):i.dateEnd=new Date(i.dateStart.getTime()+c.dateEnd.getTime()-c.dateStart.getTime()),delete i.$,e[t]=i}e&&(u[t]=e)}}n._containsEvent(c)||(n._setEventTimeZone(c,t),a.push(c))}if(i)return a;n._removeToast(),delete n._notificationsInterval,delete n._notificationObj,n._events=a}_setEventTimeZone(e,t="local"){const n=(new(0,Smart.Utilities.DateTime)).timeZones,i=this.timeZone.toLowerCase(),r=(t||this.timeZone).toLowerCase();if(!e||!e.dateStart||!e.dateEnd)return;if(t&&i===r)return;const a=n.find((e=>e.id.toLowerCase()===i));if(!a)return;let l=n.find((e=>e.id.toLowerCase()===r)),o=new Date(e.dateStart),s=new Date(e.dateEnd);const d=n.find((e=>"local"===e.id.toLowerCase()));l||(l=d);const c=d.offset,u=60*(-1*o.getTimezoneOffset()-d.offset)*1e3,h=60*(-1*s.getTimezoneOffset()-d.offset)*1e3,m=60*l.offset*1e3,v=60*a.offset*1e3;if(e.allDay||(e.dateStart=new Date(o.getTime()-u-m+v),e.dateEnd=new Date(s.getTime()-h-m+v)),e.repeat&&e.repeat.exceptions){const t=e.repeat.exceptions;for(let e=0;e<t.length;e++){const n=t[e];if(n.allDay)continue;const i=60*(-1*n.date.getTimezoneOffset()-c)*1e3,r=60*(-1*n.dateStart.getTimezoneOffset()-c)*1e3,a=60*(-1*n.dateEnd.getTimezoneOffset()-c)*1e3;n.date=new Date(n.date.getTime()-i-m+v),n.dateStart=new Date(n.dateStart.getTime()-r-m+v),n.dateEnd=new Date(n.dateEnd.getTime()-a-m+v)}}}_clearEvents(){const e=this;e._events=[],e._eventList&&(e._eventList.innerHTML=null),e.$.timelineEventsContainer.innerHTML="",e.$.allDayEventsContainer.innerHTML="",delete e._eventsBetween,e.rendered&&e._refreshTimelineEvents()}_refreshEvents(){const e=this,t=e._events,n=e.$.timelineEventsContainer,i=e.$.allDayEventsContainer,r=e._timelineCells;if(!(t&&r.horizontal&&r.horizontal.length&&r.vertical&&r.vertical.length))return n.innerHTML="",i.innerHTML="",void delete e._eventsBetween;let a=e._eventsBetween?e._eventsBetween.eventCellDetails:void 0,l=[],o={};const s=e.view,d=e.views.find((e=>e.value&&e.value===s))||{},c=d?parseFloat(d.maxEventsPerCell):NaN;if(isNaN(c)?null!==e.maxEventsPerCell&&(o.maxEventsPerCell=e.maxEventsPerCell):o.maxEventsPerCell=c,a){const t=a.eventGroups,n=a.cellRanges,i=a.allDayEventGroups,r=a.allDayEventCellRanges;for(let i=0;i<t.length;i++)o.events=t[i],o.eventCells=n[i],l=l.concat(e._createTimelineEvents(o));for(let t=0;t<i.length;t++)o.events=i[t],o.eventCells=r[t],o.isAllDay=!0,l=l.concat(e._createTimelineEvents(o))}else l=e._createViewEvents();if(e.hasAttribute("resized"))return;const u=Array.from(n.children).concat(Array.from(i.children)),h=e._eventList;for(let e=0;e<u.length;e++){const t=u[e];l.indexOf(t)<0&&(t.remove(),h&&h._target===t&&(h.innerHTML="",delete h._target))}e._handleEventCut()}_createViewEvents(){const e=this,t=e._events,n=e._timelineCells.groups,i=e._getViewEvents();let r=[];const a=e.$.timeline.querySelectorAll(".smart-scheduler-event[collector]");for(let e=0;e<a.length;e++)a[e].$&&(a[e].$.events=a[e].$.events.reduce(((e,n)=>(t.indexOf(n)>-1&&e.push(n),e)),[]));return r=n&&n.length>0?e._createGroupedEvents(i,n):e._createNonGroupedEvents(i),r}_createNonGroupedEvents(e){const t=this;let n=[],i={};const r={eventGroups:[],cellRanges:[],allDayEventGroups:[],allDayEventCellRanges:[]},a=t.view,l=t.views.find((e=>e.value&&e.value===a))||{},o=l?parseFloat(l.maxEventsPerCell):NaN;isNaN(o)?null!==t.maxEventsPerCell&&(i.maxEventsPerCell=t.maxEventsPerCell):i.maxEventsPerCell=o;const s=t._getTimelineEventCells(e,[]),d=t._separateAllDayEvents(e,s);return d.events.length&&(i.events=d.events,i.eventCells=d.eventCells,r.eventGroups.push(d.events),r.cellRanges.push(d.eventCells),n=n.concat(t._createTimelineEvents(i))),d.allDayEvents.length&&(i.events=d.allDayEvents,i.eventCells=d.allDayEventCells,i.isAllDay=!0,r.allDayEventGroups.push(d.allDayEvents),r.allDayEventCellRanges.push(d.allDayEventCells),n=n.concat(t._createTimelineEvents(i))),t._eventsBetween.eventCellDetails=r,n}_createGroupedEvents(e,t){const n=this;let i=[],r={};const a=n.view,l=n.views.find((e=>e.value&&e.value===a))||{},o=l?parseFloat(l.maxEventsPerCell):NaN;isNaN(o)?null!==n.maxEventsPerCell&&(r.maxEventsPerCell=n.maxEventsPerCell):r.maxEventsPerCell=o;const s={eventGroups:[],cellRanges:[],allDayEventGroups:[],allDayEventCellRanges:[]};let d=[];const c=t[t.length-1].cells;let u={events:[],eventCells:[]};for(let t=0;t<c.length;t++){const a=e.filter((e=>n._isEventPartOfGroup(e,c[t]))),l=n._getTimelineEventCells(a,d),o=n._separateAllDayEvents(a,l);u.events=u.events.concat(o.allDayEvents),u.eventCells=u.eventCells.concat(o.allDayEventCells),o.events.length&&(r.events=o.events,r.eventCells=o.eventCells,s.eventGroups.push(o.events),s.cellRanges.push(o.eventCells),i=i.concat(n._createTimelineEvents(r)))}const h=u.events.slice();n._sortEventCellObjs(u.events,["day","week"].indexOf(n.viewType)>-1),u.eventCells=u.events.map((e=>u.eventCells[h.indexOf(e)]));for(let e=0;e<u.events.length;e++)r.events=u.events,r.eventCells=u.eventCells,r.isAllDay=!0,s.allDayEventGroups.push(u.events),s.allDayEventCellRanges.push(u.eventCells),i=i.concat(n._createTimelineEvents(r));return n._eventsBetween.eventCellDetails=s,i}_separateAllDayEvents(e,t){let[n,i,r,a]=[[],[],[],[]];if(["day","week"].indexOf(this.viewType)<0)r=e,a=t;else for(let l=0;l<e.length;l++){const o=e[l];o.allDay||o.dateEnd.getTime()-o.dateStart.getTime()>=864e5?(n.push(o),i.push(t[l])):(r.push(o),a.push(t[l]))}return{allDayEvents:n,allDayEventCells:i,events:r,eventCells:a}}_getViewEvents(){const e=this,t=e.viewType.toLowerCase(),n=e.dateCurrent,i=e.firstDayOfWeek;let r=new Date(n),a=new Date(n);if("agenda"===t)r.setHours(0,0,0,0),a.setDate(a.getDate()+6),a.setHours(23,59,59,999);else if(t.indexOf("month")>-1)if(r.setDate(1),e.hideOtherMonthDays)r.setHours(0,0,0,0),a=new Date(r),a.setDate(32),a.setDate(0),a.setHours(23,59,59,999);else{r.setDate(r.getDate()-(r.getDay()-i+7)%7),r.setHours(0,0,0,0),a=new Date(r);for(let e=0;e<5;e++)a.setDate(a.getDate()+7);a.setDate(a.getDate()+6),a.setHours(23,59,59,999)}else if(t.indexOf("week")>-1){"dateCurrent"!==e.viewStartDay&&r.setDate(r.getDate()-r.getDay()+i),a.setDate(r.getDate()+6),r.setHours(0,0,0,0);const t=e.views.find((t=>t.value&&t.value===e.view))||{};if(t.additionalDays){let e=new Smart.Utilities.DateTime(r);e=e.addDays(6+t.additionalDays),a=e.toDate()}a.setHours(23,59,59,999)}else t.indexOf("day")>-1&&(r.setHours(0,0,0,0),a.setHours(23,59,59,999));return e._getEventsBetween(r,a)}_refreshTimelineEvents(){const e=this;delete e._eventsBetween,"agenda"===e.viewType?e._createTimeline():(e._refreshEvents(),e._checkNotifications(!0))}_getTimelineEventCells(e,t){const n=this,i=["day","week"].indexOf(n.viewType)>-1,r=n.hideAllDay;let a=[];for(let l=0;l<e.length;l++){const o=e[l];let s,d=[];i&&(o.allDay||o.dateEnd.getTime()-o.dateStart.getTime()>=864e5)&&(s=!0),o.hidden||s&&r?a.push(d):(d=n._getEventTimelineCells(o,t,s),a.push(n._getEventTimelineCellRanges(d,s)))}return a}_createTimelineEvents(e){const t=this,n=e.events,i=e.eventCells,r=e.isAllDay,a=t.viewType,l=t.view,o=t.views.find((e=>e.value&&e.value===l))||{},s=t.eventRenderMode,d=e.maxEventsPerCell,c="classic"===s?"month"===a?t._monthViewNumberSize:0:t._eventCollectorSize,u=["day","week"].indexOf(a)>-1,h=t._getCellSize(),m=h[u?"width":"height"]-c,v=void 0!==d?m/d:Math.min(m,t._eventSize);let g={events:n,eventCells:i,viewType:a,viewDetails:o,isAllDayEvent:r,isMobile:t.$.timeline.hasAttribute("mobile"),isDayOrWeekView:u,rightToLeft:t.rightToLeft,eventRenderMode:s,eventSize:v,collectorSize:c,usedEventCells:[],eventIndexes:[],maxEventsPerCell:d};return r?(g.cellSize={height:t._allDayCellSize,width:h.width},g.spaceAvailable=t._allDayCellSize-c,g.currentEvents=t.$.allDayEventsContainer.children,void 0!==d&&(g.eventSize=g.spaceAvailable/d),t._setVerticalTimelineEvents(g)):(g.cellSize=h,g.spaceAvailable=m,g.currentEvents=t.$.timelineEventsContainer.children,u?t._setHorizontalTimelineEvents(g):t._setVerticalTimelineEvents(g)),g.usedEventCells}_setHorizontalTimelineEvents(e){const t=this,n=e.events,i=e.eventCells,r=e.eventRenderMode;if("modern"===r&&e.isMobile)return t._setAgendaOrMobileEvents(e);const a=e.eventIndexes,l=e.spaceAvailable,o="classic"===r?1:void 0!==e.maxEventsPerCell?e.eventSize:t._eventSize,[s,d]=[t.scrollTop,t.scrollLeft],[c,u]=[s+t._scrollViewSize.height,d+t._scrollViewSize.width],h=t._getEventsCollisionIndexes(e),m=h.eventOverlaps,v=h.eventCollisionsCount;for(let h=0;h<n.length;h++){const g=i[h],f=n[h];let p=v[h];for(let i=0;i<g.length;i++){const w=g[i],y=w[0];if(!y)continue;const _=w[w.length-1],[b,D]=[y.vertical,_.vertical],[C,E]=[y.horizontal,_.horizontal];if(D.top+D.height<s||b.top>c||E.left+E.width<d||C.left>u)continue;const T=a[h],S=m.filter((e=>e.indexOf(f)>-1));for(let e=0;e<S.length;e++){const t=S[e].reduce(((e,t)=>Math.max(e,v[n.indexOf(t)]||1)),1);p=Math.max(p,t)}"modern"===r&&(p=Math.min(Math.floor(l/o),p));let O=1;for(let e=T+1;e<p&&S.every((t=>t.map((e=>a[n.indexOf(e)])).indexOf(e)<0));e++)O++;e.eventObj=f,e.cellEventsCount=p,e.cellRange=w,e.eventIndex=T,e.eventSize=l/p*O,"modern"===r&&(T+1)*o>l?t._addEventToCollector(e):t._setEventCell(e)}}return e.usedEventCells}_getAllEventCollisions(e,t,n){const i=this;n||(n=t);for(let r=0;r<n.length;r++){let a=e.filter((e=>n[r].some((t=>e.indexOf(t)>-1))&&t.indexOf(e)<0));a.length&&(t=i._getAllEventCollisions(e,t.concat(a),a))}return t}_getEventsCollisionIndexes(e){const t=this,n=e.events,i=e.eventCells,r=e.eventIndexes;let a=[],l=[],o=0;for(let s=0;s<n.length;s++){const d=n[s];if(!i[s].length)continue;e.eventObj=d;const c=t._getEventsInCollision(e);let u=a.filter((e=>c.some((t=>e.indexOf(t)>-1))));if(l[s]=c.length,u.length){o!==l[s]&&(u=t._getAllEventCollisions(a,u)),u.sort(((e,t)=>t.length-e.length));let e=Math.max(c.length,u[0].length);u.forEach((t=>t.forEach((t=>{const i=n.indexOf(t);l[i]=Math.max(l[i]||0,e)}))))}o=Math.max(o,l[s]),a[s]=c,r[s]=c.indexOf(d)}return{eventOverlaps:a,eventCollisionsCount:l}}_getEventsInCollision(e){const t=this,n=t._getEventCellDetails(e),i=n.eventCellStartTime,r=n.eventCellEndTime,a=n.hCellGroup,l=n.vCellGroup,o=e.isDayOrWeekView&&void 0!==l?void 0:l||a;let s=e.events,d=[],c=[];for(let e=0;e<s.length;e++){const n=s[e];if(o&&!t._isEventPartOfGroup(n,o))continue;const a=n.dateStart.getTime(),l=n.dateEnd.getTime();a>=i&&a<=r?d.push(n):l>i&&a<r&&c.push(n)}return!d.length&&c.length&&(d=c,c=[]),t._sortEventCellObjs(d,e.isDayOrWeekView),t._getOrderedEventCollision(e,d,c)}_sortEventCellObjs(e,t){t?e.sort(((e,t)=>{const n=e instanceof HTMLElement?e.$.event:e,i=t instanceof HTMLElement?t.$.event:t,r=n.dateStart.getTime(),a=i.dateStart.getTime();return r===a?i.dateEnd.getTime()-n.dateEnd.getTime():r-a})):e.sort(((e,t)=>{const n=e instanceof HTMLElement?e.$.event:e,i=t instanceof HTMLElement?t.$.event:t;n.dateStart.getTime(),i.dateStart.getTime()}))}_getOrderedEventCollision(e,t,n){const i=e.events,r=e.eventIndexes,a=Math.max(e.eventsInCollision||1,t.length+n.length);let l=[];if(n.length){const e=n.map((e=>r[i.indexOf(e)]));for(let i=0;i<a;i++){const r=n[e.indexOf(i)];if(r)l.push(r);else{const e=t.find((e=>l.indexOf(e)<0));e&&l.push(e)}}n.forEach((e=>l.indexOf(e)<0?l.push(e):null))}else l=t;return l}_getEventCellDetails(e){const t=this,n=t.viewType;if("month"===n)return t._getMonthEventCellDetails(e);const i=t.view,r=t.views.find((e=>e.value&&e.value===i))||{},a=e.eventObj,l=a.dateStart,o=a.dateEnd,s=t._getEventHorizontallCellObjs(a),d=t._getEventVerticalCellObjs(a),c=d.start||d.first,u=c.group;let h,m,v,g=s.start,f=0;if(g||(g=s.first),m=g.group,h=g.date,e.isAllDayEvent)h>l.getTime()&&(h=new Date(l),h.setHours(h.getHours(),0,0,0)),v=new Date(h),v.setHours(23,59,59,999),h=h.getTime(),v=v.getTime();else{let e=t._getCellsScaleCount();f=t._getEventScaleIndex(a,n.indexOf("timeline")>-1?g:c).start,h=t._getCellTime({horizontal:g,vertical:c,scaleIndex:f}),h>l.getTime()?(h=new Date(l),h.setHours(h.getHours(),0,0,0),h=h.getTime(),e=1):h<l.getTime()&&(h=new Date(h),h.setMinutes(l.getMinutes()),h=h.getTime()),v=h,"timelineMonth"===n||"timelineWeek"===n&&r&&r.hideHours?v+=86399999:v+=60/e*60*1e3-1,v>o.getTime()&&(v=new Date(v),v.setMinutes(o.getMinutes()),v=v.getTime())}return{eventCellStartTime:h,eventCellEndTime:v,hCellGroup:m,vCellGroup:u}}_getMonthEventCellDetails(e){const t=this,n=e.eventObj,i=n.dateStart,r=n.dateEnd,a=t._getEventVerticalCellObjs(n);let l,o,s,d,c,u=a.start||a.first;u=a.start,d=u.group;const h=new Date(u.date),m=new Date(u.date),v=Object.assign({},n);m.setDate(m.getDate()+6),m.setHours(23,59,59,999),h.setHours(0,0,0,0),v.dateStart=new Date(Math.max(i.getTime(),h.getTime())),v.dateEnd=new Date(Math.min(r.getTime(),m.getTime()));const g=t._getEventHorizontallCellObjs(v);return l=g.start,l||(l=g.first),s=l.group,o=l.date,o=t._getCellTime({horizontal:l,vertical:u,scaleIndex:0}),o>i.getTime()&&(o=new Date(i),o=o.getTime()),c=o+864e5-1,c>r.getTime()&&(c=new Date(c),c.setMinutes(r.getMinutes()),c=c.getTime()),{eventCellStartTime:o,eventCellEndTime:c,hCellGroup:s,vCellGroup:d}}_getEventScaleIndex(e,t){const n=this,i=n._getCellsScaleCount(),r=60/i,a=e.dateStart,l=e.dateEnd;let o,s,d,c,u=0,h=r;if(t){const e=t.date;let r=new Date(e),u=new Date(e);n.viewType.indexOf("timeline")<0&&(r=new Date(a),u=new Date(l),r.setHours(e.getHours(),e.getMinutes(),0,0),u.setHours(e.getHours(),e.getMinutes(),0,0)),r=r.getTime(),u=r+36e5,a.getTime()<=r&&(d=!0,o=0),l.getTime()>=u&&(c=!0,s=i-1)}if(void 0===o||void 0===s){const e=a.getMinutes(),t=l.getMinutes();for(let n=0;n<i;n++)!d&&u<=e&&h>=e&&(o=n),!c&&u<t&&h>=t&&(s=n),u+=r,h+=r}return{start:o||0,end:s||0}}_getEventVisibleDateRange(e){const t=this,n=e.dateStart,i=e.dateEnd;if(t.viewType.toLowerCase().indexOf("day")>-1)return{dateStart:n,dateEnd:i};const r=t.view,a=t.views.find((e=>e.value&&e.value===r))||{};let l,o,s=new Date(n),d=new Date(i),c=[];if(0===d.getHours()&&0===d.getMinutes()&&0===d.getSeconds()&&(d.setDate(d.getDate()-1),d.setHours(23,59,59,999)),(t.hideNonworkingWeekdays||a.hideNonworkingWeekdays)&&(t.nonworkingDays||a.nonworkingDays).forEach((e=>c.push(e))),(t.hideWeekend||a.hideWeekend)&&[0,6].forEach((e=>c.push(e))),![0,1,2,3,4,5,6].every((e=>c.indexOf(e)>-1))){for(;c.indexOf(s.getDay())>-1;)s.setDate(s.getDate()+1),l=!0;for(;c.indexOf(d.getDay())>-1;)d.setDate(d.getDate()-1),o=!0;return s.getTime()<=d.getTime()?{dateStart:l?s:n,dateEnd:o?d:i}:void 0}}_getEventHorizontallCellObjs(e){const t=this,n=t.hourStart,i=t.hourEnd,r=t._getEventVisibleDateRange(e);if(!r)return;const a=r.dateStart,l=r.dateEnd,o=a.getHours(),s=l.getHours(),d=a.getMinutes()+a.getSeconds()+a.getMilliseconds()===0,c=l.getMinutes()+l.getSeconds()+l.getMilliseconds()===0,u=l.getTime()>a.getTime()&&c,h=t.viewType,m=t.view,v=t.views.find((e=>e.value&&e.value===m))||{},g=a.getFullYear()===l.getFullYear()&&a.getMonth()===l.getMonth()&&a.getDate()===l.getDate();return t._getEventCellObjs(e,(function(r,m){let f;arguments.length?(f=!0,m||(m=r)):(r=a,m=l);let p=new Date(r),w=new Date(m);switch(h){case"agenda":p=a,w=l;break;case"day":case"week":case"timelineMonth":if(f)p.setHours(0,0,0,0),w.setHours(23,59,59,999);else{if(e.allDay||"day"!==h)w=new Date(l);else{const e=new Date(a);e.setHours(23,59,59,999),w=new Date(Math.min(l.getTime(),e.getTime()))}w.setHours(w.getHours(),w.getMinutes(),0,0),u&&(w=new Date(w.getTime()-1),w.setHours(w.getHours(),59,59,999))}break;case"timelineDay":case"timelineWeek":if("timelineWeek"===h&&v&&v.hideHours)return!f&&u&&(w=new Date(l.getTime()-1),w.setHours(w.getHours(),59,59,999)),{start:p.getDay(),end:w.getDay()};if(f){const e=r.getHours(),t=m.getHours();g&&(o<n&&(s<n||s===n&&c)||(o>i||o===n&&d)&&s>i)?(p.setHours(e,0,0,0),w.setHours(t,59,59,999)):(p.setHours(e===n&&o<n?o:e,0,0,0),w.setHours(t===i&&s>i?s:t,59,59,999))}else if(u&&(w=new Date(w.getTime()-1),w.setHours(w.getHours(),59,59,999)),!g){if(o>i){p.setHours(0),p.setDate(p.getDate()+1),p.setHours(n);const e=t._getEventVisibleDateRange({dateStart:p,dateEnd:w});p=e&&e.dateStart.getTime()<w.getTime()?e.dateStart:new Date(r)}if(s<n||s===n&&c){w.setHours(0),w.setDate(w.getDate()-1),w.setHours(i);const e=t._getEventVisibleDateRange({dateStart:p,dateEnd:w});w=e&&e.dateEnd.getTime()>p.getTime()?e.dateEnd:new Date(m)}s>i&&w.setHours(i)}break;case"month":return!f&&u&&(w=new Date(l.getTime()-1),w.setHours(w.getHours(),59,59,999)),{start:p.getDay(),end:w.getDay()}}return p=p.getTime(),w=w.getTime(),{start:p,end:w}}),"horizontal")}_getEventVerticalCellObjs(e){const t=this,n=t.hourStart,i=t.hourEnd,r=t._getEventVisibleDateRange(e);if(!r)return;const a=r.dateStart,l=r.dateEnd,o=a.getHours(),s=l.getHours(),d=l.getTime()>a.getTime()&&l.getMinutes()+l.getSeconds()+l.getMilliseconds()===0,c=t.viewType;return t._getEventCellObjs(e,(function(e,t){let r;arguments.length?(r=!0,t||(t=e)):(e=a,t=l);let u=new Date(e),h=new Date(t);switch(c){case"day":case"week":if(u=new Date(a),h=new Date(l),r){h=new Date(u);const r=e.getHours(),a=t.getHours();s<=n&&o<=n||o>=i&&s>=i?(u.setHours(r,0,0,0),h.setHours(a,59,59,999)):(u.setHours(r===n&&o<n?o:r,0,0,0),h.setHours(a===i&&s>i?s:a,59,59,999))}else u.setHours(u.getHours(),u.getMinutes(),0,0),h.setHours(h.getHours(),h.getMinutes(),0,0),d&&(h=new Date(h.getTime()-1),h.setHours(h.getHours(),59,59,999));break;case"agenda":r&&(u.setHours(0,0,0,0),h.setHours(23,59,59,999));break;case"month":r?(u.setHours(0,0,0,0),h=new Date(e),h.setDate(h.getDate()+6),h.setHours(23,59,59,999)):d&&(h=new Date(h.getTime()-1),h.setHours(h.getHours(),59,59,999));break;case"timelineDay":case"timelineWeek":case"timelineMonth":return{start:0,end:0}}return u=u.getTime(),h=h.getTime(),{start:u,end:h}}),"vertical")}_getEventCellObjs(e,t,n="horizontal"){const i=this,r=i._timelineCells;if(!r||!r[n])return;const a=r[n],l=t(),o=l.start,s=l.end;let d,c,u,h,m,v;for(let n=0;n<a.length;n++){const r=a[n],l=r.date,g=r.group;if(g&&!i._isEventPartOfGroup(e,g))continue;const f=t(l,l),p=f.start,w=f.end;!d&&o>=p&&o<=w&&(d=r),s>=p&&s<=w&&(c=r),u||(u=r,m=p),h=r,v=p}return!d&&o<=m&&s>m&&(d=u),!c&&d&&(c=s>=m&&s<=v?d:h),{start:d,end:c,first:u,last:h}}_setVerticalTimelineEvents(e){const t=this,n=e.events,i=e.eventCells,r=e.eventRenderMode;if("agenda"===e.viewType||"modern"===r&&e.isMobile)return t._setAgendaOrMobileEvents(e);const a=e.isAllDayEvent,l=e.spaceAvailable,o=e.eventSize,s=Math.floor(l/o),d=e.eventIndexes,[c,u]=[t.scrollTop,t.scrollLeft],[h,m]=[c+t._scrollViewSize.height,u+t._scrollViewSize.width];let v,g;if("classic"===r||t.autoHeightAllDayCells){const n=t._getEventsCollisionIndexes(e,"vertical");v=n.eventOverlaps,g=n.eventCollisionsCount}t.autoHeightAllDayCells&&(t._allDayCellSize=t.__allDayCellSize);for(let f=0;f<n.length;f++){const p=i[f],w=n[f];e.eventObj=w;for(let i=0;i<p.length;i++){const y=p[i],_=y[0];if(!_)continue;e.cellRange=y;let b=d[f];if(void 0===b){const n=t._getEventsInCollision(e);e.cellEventsCount=n.length,d[f]=n.indexOf(w)}if(!a){const e=y[y.length-1],[t,n]=[_.vertical,e.vertical],[i,r]=[_.horizontal,e.horizontal];if(n.top+n.height<c||t.top>h||r.left+r.width<u||i.left>m)continue}if(e.eventIndex=b=d[f],!t.autoHeightAllDayCells&&"modern"===r&&(b+1)*o>l)t._addEventToCollector(e);else{if("classic"===r||t.autoHeightAllDayCells){const i=v.filter((e=>e.indexOf(w)>-1)),r=v[f].reduce(((e,t)=>Math.max(e,g[n.indexOf(t)]||1)),1);let a=1;for(let e=b+1;e<r&&i.every((t=>t.map((e=>d[n.indexOf(e)])).indexOf(e)<0));e++)a++;e.isMaxSizeReached=r>s,e.cellEventsCount=r,e.eventSize=Math.min(o,l/r*a),t.autoHeightAllDayCells&&(e.eventSize=o,t._allDayCellSize=Math.max(t._allDayCellSize,25+o*r),t.style.setProperty("--smart-scheduler-timeline-header-all-day-cells-size",t._allDayCellSize+"px"),t._refresh())}t._setEventCell(e)}}}}_setAgendaOrMobileEvents(e){const t=this,n=e.events,i=e.isAllDayEvent,r=e.eventCells,a="agenda"===e.viewType;let l,o,s,d;i||([l,o]=[t.scrollTop,t.scrollLeft],[s,d]=[l+t._scrollViewSize.height,o+t._scrollViewSize.width]);for(let c=0;c<n.length;c++){const u=r[c],h=n[c];e.eventObj=h,u.forEach((n=>{if(n[0])if(e.cellRange=n,i)a?t._setEventCell(e):t._addEventToCollector(e);else{const i=n[0],r=n[n.length-1],[c,u]=[i.vertical,r.vertical],[h,m]=[i.horizontal,r.horizontal];u.top+u.height>=l&&c.top<=s&&m.left+m.width>=o&&h.left<=d&&(a?t._setEventCell(e):t._addEventToCollector(e))}}))}return e.usedEventCells}_addEventToCollector(e){const t=this,n=e.viewType,i=n.indexOf("timeline")>-1,r=e.eventObj,a=e.cellRange,l=e.usedEventCells,o=t.$.allDayEventsContainer,s=e.isAllDayEvent,d=e.isDayOrWeekView,c="month"===n,u=s?o:t.$.timelineEventsContainer,h=t._getCellsScaleCount(),m=t._setEventCell(e,!0),v=a.length,g=t.hasAttribute("tabindex")?t.tabIndex:void 0;let f=document.createDocumentFragment(),p={tabIndex:g};e:for(let n=0;n<v;n++){const o=a[n],u=o.scaleIndex,g=o.vertical.group||o.horizontal.group;let w;w=s?1:1===v?t._getEventScaleIndex(r,i?o.horizontal:o.vertical).end+1:n===v-1?u+1:h;for(let i=0===n&&u||0;i<w;i++){o.scaleIndex=i;const n=t._getCellTime(o);let a=t._findCollector(e,n,g);if(a){const e=a.$.events;e.map((e=>e.$.event)).indexOf(r)<0&&(e.push(m),t._sortEventCellObjs(e,d))}else a=document.createElement("div"),a.classList.add("smart-scheduler-event"),a.setAttribute("collector",""),a.setAttribute("role","menuitem"),a.setAttribute("aria-haspopup",!0),a.$={group:g,cellTime:n,collector:!0,events:[m]},f.appendChild(a);if(c&&1===new Date(n).getDate()?a.setAttribute("first-month-day",""):a.removeAttribute("first-month-day"),p.eventCollector=a,p.cellObj=o,t._setEventCollectorStyles(e,p),t._setEventCellContent(a,e),l.indexOf(a)<0&&l.push(a),d&&!s)break e}o.scaleIndex=u}f.children.length&&u.appendChild(f)}_findCollector(e,t,n){const i=this;if(!e)return;const r=e.currentEvents;for(let e=0;e<r.length;e++){const a=r[e];if(a.$.events&&a.$.cellTime===t&&(!n||i._isEventPartOfGroup(a.$.group,n)))return a}}_setEventCollectorStyles(e,t){const n=this,i=e.cellSize,r=e.eventRenderMode,a=t.eventCollector,l=t.cellObj,o=t.tabIndex,s=e.isMobile,d=e.rightToLeft?"right":"left",c=e.isAllDayEvent,u=e.isDayOrWeekView,h=n._getCellOffset(l);let m=e.collectorSize;a.style[e.rightToLeft?"left":"right"]="","modern"===r&&s?(m=Math.min(i.width,i.height),a.style.width=a.style.height=m+"px",a.style[d]=h.left+(i.width-m)/2+"px",a.style.top=h.top+(i.height-m)/2+"px"):(a.style.top=h.top+"px",a.style.height=n._eventCollectorSize+"px",u&&!c?(a.style[d]=h.left+i.width-m+"px",a.style.width=m+"px"):(a.style[d]=h.left+"px",a.style.width=Math.max(0,i.width)+"px")),void 0!==o?a.tabIndex=o:a.removeAttribute("tabindex")}_removeEventFromCollector(e){const t=this,n=e.eventObj,i=e.cellRange;let r;for(let a=0;a<i.length;a++){const l=i[a],o=l.vertical.group||l.horizontal.group,s=t._getCellTime(l),d=t._findCollector(e,s,o);if(d){const i=d.$.events,a=i.map((e=>e.$.event)).indexOf(n);a>-1&&(r=i.splice(a,1)[0]),i.length?t._setEventCellContent(d,e):d.remove()}}return r}_findEventElement(e,t,n){if(!e)return;const i=e.currentEvents;for(let e=0;e<i.length;e++){const r=i[e];if(r.$.event===n&&r.$.cellTime===t)return r}}_setEventCell(e,t){const n=this,i=e.viewType,r=e.eventObj,a=e.usedEventCells,l=r.$?r.$.event:void 0,o=r.dateStart,s=r.dateEnd,d=r.status,c=n._getCellTime(e.cellRange[0]),u=e.isAllDayEvent?n.$.allDayEventsContainer:n.$.timelineEventsContainer,h=n._dragDetails,m=n.tabIndex;let v,g,f=n._findEventElement(e,c,r);if(!t){const t=n._removeEventFromCollector(e);!f&&t&&(f=t)}if(!f||!n.hasAttribute("resized")||f!==h.schedulerEvent){if(f?f.classList.remove("smart-hidden"):(f=document.createElement("div"),f.classList.add("smart-scheduler-event"),f.setAttribute("role","menuitem"),f.setAttribute("aria-haspopup",!0)),n._setEventCellStyles(e,{eventCell:f}),"agenda"===i?(v=new Date(c),v.setHours(o.getHours(),o.getMinutes())):v=new Date(o),f.$||(f.$={}),g=f.$,g.cellTime=c,g.dateStart=v,g.dateEnd=new Date(v.getTime()+s.getTime()-o.getTime()),g.event=r,n.resources.forEach((e=>{void 0!==r[e.value]&&f.setAttribute(e.value,r[e.value])})),d&&n.statuses.some((e=>e.value===d))?f.setAttribute("status",d):f.removeAttribute("status"),l){const e=l.repeat.exceptions;f.setAttribute("repeating",""),e&&e.indexOf(r)>-1?f.setAttribute("exception",""):f.removeAttribute("exception")}else f.removeAttribute("repeating"),f.removeAttribute("exception");if(r.allDay?f.setAttribute("all-day",""):f.removeAttribute("all-day"),t)return f;n._setEventCellContent(f,e),n.hasAttribute("tabindex")?f.tabIndex=m:f.removeAttribute("tabindex"),r.disableResize?f.setAttribute("disable-resize",""):f.removeAttribute("disable-resize"),f.setAttribute("title",r.label),a.indexOf(f)<0&&a.push(f),u.contains(f)||u.appendChild(f)}}_setEventCellStyles(e,t){const n=this,i=e.viewType,r=e.eventObj,a=e.eventIndex,l=t.eventCell,o=e.collectorSize,s=e.cellRange,d=e.cellSize,c=s[0],u=s[s.length-1],h=n._getCellOffset(c),m=e.isDayOrWeekView,v=e.isAllDayEvent,g=e.rightToLeft?"right":"left",f=i.indexOf("timeline")>-1,p=e.viewDetails,w=["timelineDay","timelineWeek"].indexOf(i)>-1,y=r.class?Array.isArray(r.class)?r.class:[r.class]:[];let _=r.backgroundColor,b=r.color;if(!_||!b){const e=n.resources.find((e=>void 0!==r[e.value]));if(e&&e.dataSource){const t=e.dataSource.find((t=>t.id===r[e.value]));t&&(_=_||t.backgroundColor,b=b||t.color)}}if(l.style[e.rightToLeft?"left":"right"]="",l.style.setProperty("--smart-scheduler-event-background",n._getRGBA(_)),l.style.setProperty("--smart-scheduler-event-focus",n._getRGBA(_,-1)),l.style.setProperty("--smart-scheduler-event-hover",n._getRGBA(_,-2)),l.style.setProperty("--smart-scheduler-event-color",n._getRGBA(b)),l.style.setProperty("--smart-scheduler-event-color-hover",n._getRGBA(b)),l.style.setProperty("--smart-scheduler-event-color-focus",n._getRGBA(b)),"agenda"===i)l.style.top=h.top+"px",l.style[g]=h.left+"px",l.style.width=d.width+"px",l.style.height=d.height+"px";else{const t=e.cellEventsCount,s=u.scaleIndex;let _,b=0,D=0,C=e.eventSize;if((w||m)&&(b=n._getEventCellOffset(r,c)),c===u&&(u.scaleIndex=n._getEventScaleIndex(r,f?u.horizontal:u.vertical).end),_=n._getCellOffset(u),m&&!v){b=parseFloat((d.height*b).toFixed(2)),D=parseFloat((d.height*n._getEventCellOffset(r,u,!0)).toFixed(2));const e=D+_.top-h.top-b;l.style.height=(0===e?d.height:e)+"px",l.style.width=C+"px",l.style.top=h.top+b+"px",l.style[g]=h.left+a*((d.width-o)/t)+"px"}else{"timelineDay"!==i&&("timelineWeek"!==i||p&&p.hideHours)?(D=d.width,b=0):(b=parseFloat((d.width*b).toFixed(2)),D=parseFloat((d.width*n._getEventCellOffset(r,u,!0)).toFixed(2)));const s=D+_.left-h.left-b;l.style.height=C+"px",l.style.width=(0===s?d.width:s)+"px",l.style[g]=h.left+b+"px","classic"===n.eventRenderMode&&e.isMaxSizeReached?l.style.top=h.top+o+a*((d.height-o)/t)+"px":l.style.top=h.top+o+a*C+"px"}y.length?y.forEach((e=>l.classList.add(e))):"smart-scheduler-event"!==l.className&&(l.className="smart-scheduler-event"),void 0!==r.id?l.id=r.id+"":delete r.id,u.scaleIndex=s}}_getEventCellOffset(e,t,n){if(void 0===t.scaleIndex)return 0;const i=["day","week"].indexOf(this.viewType)>-1?"vertical":"horizontal",r=60/this._getCellsScaleCount()*60*1e3;let a=n?e.dateEnd:e.dateStart,l=t[i].date;return l=new Date(l.getTime()+r*t.scaleIndex),"vertical"===i&&(l=new Date(a.getFullYear(),a.getMonth(),a.getDate(),l.getHours(),l.getMinutes(),0,0),l.getHours()!==a.getHours())?n?1:0:(l=l.getTime(),a=a.getTime(),Math.max(0,Math.min(1,l>a?n?1:0:parseFloat(((a-l)/r).toFixed(2)))))}_getRGBA(e,t){if(!e)return"";const n=/^#(.)(.)(.)$/gi.exec(e),i=void 0!==t&&t<0?parseFloat((1+t/10).toFixed(2)):void 0;let r,a,l,o;if(n)r=parseInt(n[1]+n[1],16),a=parseInt(n[2]+n[2],16),l=parseInt(n[3]+n[3],16),t<0&&(t=parseFloat((1+t/10).toFixed()));else{const n=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})?$/i.exec(e);if(!n)return"";r=parseInt(n[1],16),a=parseInt(n[2],16),l=parseInt(n[3],16),o=parseInt(n[4],16)/255,isNaN(o)||(t=parseFloat((void 0!==t&&t<0?o+t/10:o).toFixed(2)))}return void 0!==t&&t<0&&(t=i),`rgba(${r},${a},${l},${t||1})`}_getCellRanges(e,t="horizontal"){if(!e)return[];const n=this._timelineCells[t],i=e.start,r=e.end,a=e.first,l=e.last;if(!i&&!r||!a&&!l)return[];const o=e.start||a,s=e.end||l,d=n.indexOf(o),c=n.indexOf(s),u=n.indexOf(a),h=n.indexOf(l);let m=[];return m=d>c?[{fromIndex:d,toIndex:h},{fromIndex:u,toIndex:c}]:[{fromIndex:d,toIndex:c}],m}_getEventTimelineCells(e,t,n){const i=this,r=i.viewType,a="agenda"===r,l=new Date(e.dateStart),o=new Date(e.dateEnd),s=i._timelineCells.horizontal,d=i._timelineCells.vertical;let c=[];if("month"===r)return i._getEventTimelineCellsMonth(e);if(n){const t={height:i._allDayCellSize,top:0,date:new Date(i.dateCurrent)};return t.date.setHours(0,0,0,0),i._getCellRanges(i._getEventHorizontallCellObjs(e)).forEach((n=>{const r=n.fromIndex,a=n.toIndex;for(let n=r;n<=a;n++){const r=s[n],a=r.group;a&&!i._isEventPartOfGroup(e,a)||c.push({allDay:!0,horizontal:r,vertical:t})}})),c}const u=Object.assign({},e),h=r.indexOf("timeline")>-1;let m,v;return i._getCellRanges(i._getEventHorizontallCellObjs(e)).forEach((n=>{const g=n.fromIndex,f=n.toIndex;for(let n=g;n<=f;n++){const p=s[n],w=new Date(p.date),y=p.group;let _,b=new Date(p.date);if(!y||i._isEventPartOfGroup(e,y)){if(l.getTime()>=w.getTime()&&w.setHours(l.getHours(),l.getMinutes()),b.setHours(o.getHours(),o.getMinutes()),b.getTime()<w.getTime())if("timelineWeek"===r||"timelineDay"===r)for(;b.getTime()<w.getTime();){const e=b.getHours();b.setHours(e+1,0,0,0),e===b.getHours()&&b.setHours(b.getHours()+2,0,0,0)}else b.setDate(b.getDate()+1),b.setHours(0,0,0,0);a||(u.dateStart=w,u.dateEnd=b),i._getCellRanges(i._getEventVerticalCellObjs(u),"vertical").forEach((r=>{const l=r.fromIndex,o=r.toIndex;for(let r=l;r<=o;r++){const s=d[r],w=s.group;if(w&&!i._isEventPartOfGroup(u,w))continue;if(a&&(_&&_.date.getTime()===s.date.getTime()||t.some((e=>e.horizontal===p&&e.vertical===s))))continue;const y={horizontal:p,vertical:s};h&&n!==g||r!==l?h&&n!==f||r!==o||(void 0===v&&(v=i._getEventScaleIndex(e,h?p:s).end),y.scaleIndex=v):(void 0===m&&(m=i._getEventScaleIndex(e,h?p:s).start),y.scaleIndex=m),_=s,c.push(y),t.push(y)}}))}}})),c}_getEventTimelineCellsMonth(e){const t=this,n=new Date(e.dateStart),i=new Date(e.dateEnd),r=t._timelineCells.horizontal,a=t._timelineCells.vertical,l=Object.assign({},e);let o=[];return t._getCellRanges(t._getEventVerticalCellObjs(e),"vertical").forEach((s=>{const d=s.fromIndex,c=s.toIndex;for(let s=d;s<=c;s++){const u=a[s],h=new Date(u.date),m=new Date(u.date),v=u.group;v&&!t._isEventPartOfGroup(e,v)||(m.setDate(m.getDate()+6),m.setHours(23,59,59,999),h.setHours(0,0,0,0),l.dateStart=new Date(Math.max(n.getTime(),h.getTime())),l.dateEnd=new Date(Math.min(i.getTime(),m.getTime())),t._getCellRanges(t._getEventHorizontallCellObjs(l)).forEach((n=>{const i=n.fromIndex,a=n.toIndex;for(let n=i;n<=a;n++){const i=r[n],a=u.group;if(a&&!t._isEventPartOfGroup(e,a))continue;const l={horizontal:i,vertical:u};s!==d&&s!==c||(l.scaleIndex=0),o.push(l)}})))}})),o}_getEventTimelineCellRanges(e,t){const n=this,i=n.viewType;if(!e.length)return[];if("agenda"===i)return e.map((e=>[e]));{let r,a=[],l=[];const o=["day","week"].indexOf(i)>-1&&!t;for(let t=0;t<e.length;t++){const i=e[t];if(!r){a.push(r=i);continue}const s=i.horizontal,d=i.vertical,c=r.horizontal,u=r.vertical,h=n._getCellOffset(i,void 0===d.scaleIndex),m=n._getCellOffset(r,void 0===d.scaleIndex);!o&&(d!==u||m.right!==h.left)||o&&(s!==c||m.bottom!==h.top)?(l.push(a),a=[i]):a.push(i),r=i}return a.length&&l.push(a),l}}_getCellSize(e){const t=this,n=t.viewType;let i,r;if(e){let t=e;if(e instanceof HTMLElement&&(t=e.$?e.$.cellObj:void 0),!t)return{width:0,height:0};i=t.vertical,r=t.horizontal}else{const e=t._timelineCells,n=e.vertical,a=e.horizontal;if(!n.length||!a.length)return{width:0,height:0};i=n[0],r=a[0]}const a=t._getCellsScaleCount();let l,o;switch(n){case"agenda":case"month":case"timelineMonth":l=r.width,o=i.height;break;case"day":case"week":l=r.width,o=i.height/a;break;case"timelineDay":case"timelineWeek":l=r.width/a,o=i.height}return{width:l,height:o}}_getCellOffset(e,t){const n=this.viewType;let i,r,a=e;if(!e)return{left:0,top:0};if(e instanceof HTMLElement&&(a=e.$?e.$.cellObj:void 0),!a)return{left:0,top:0};i=a.vertical,r=a.horizontal;const l=this._getCellsScaleCount(),o=t||a.allDay?0:a.scaleIndex||0;let s,d;switch(n){case"agenda":case"month":case"timelineMonth":s=r.left,d=i.top;break;case"day":case"week":s=r.left,d=parseFloat((i.top+i.height/l*o).toFixed(2));break;case"timelineDay":case"timelineWeek":s=parseFloat((r.left+r.width/l*o).toFixed(2)),d=i.top}return{left:s,right:parseFloat((s+r.width).toFixed(2)),top:d,bottom:parseFloat((d+i.height).toFixed(2))}}_getCellDateRange(e){const t=this;let n=e;if(e instanceof HTMLElement&&(n=e&&e.$?e.$.cellObj:void 0),!n)return;const i=t.viewType;let r=new Date(n.time?n.time:t._getCellTime(n)),a=new Date(r);switch(i){case"agenda":case"month":case"timelineMonth":a.setHours(23,59,59,999);break;case"week":case"day":case"timelineWeek":case"timelineDay":n.allDay?a.setHours(23,59,59,999):a=new Date(a.getTime()+60/t._getCellsScaleCount()*60*1e3)}return{dateStart:r,dateEnd:a}}_setEventCellContent(e,t){const n=this,i=t.eventObj;if(!e||!i)return;const r=t.isDayOrWeekView,a=t.isAllDayEvent;let l=e.querySelector(".smart-scheduler-event-content");if(e.$&&e.$.events){const t=e.$.events;if(l||(e.innerHTML='<div class="smart-scheduler-event-content"><div></div></div>',l=e.firstElementChild),n.eventCollectorTemplate)n._applyTemplate("eventCollectorTemplate",l,t.map((e=>n._cloneObject(e))));else{const e=n.eventRenderMode,i=n.$.timeline.hasAttribute("mobile"),o=t.length+(i||"modern"===e&&r&&!a?"":" "+n.localize("collector"));l.firstElementChild.textContent=o}return}l||(e.innerHTML='<div class="smart-scheduler-event-content"></div><div class="smart-scheduler-event-button"></div>',l=e.firstElementChild);const o=e.querySelector(".smart-scheduler-event-button");let s;if(o&&(o.tabIndex=t.tabIndex),t.isTooltipEvent&&n.eventTooltipTemplate)n._applyTemplate("eventTooltipTemplate",l,n._cloneObject(i));else if(n.eventTemplate)n._applyTemplate("eventTemplate",l,n._cloneObject(i));else{const e=void 0!==t.isMonthView?t.isMonthView:["timelineMonth","month"].indexOf(n.viewType)>-1;let r=l.querySelector(".smart-scheduler-event-time"),a=i.label;s=l.querySelector(".smart-scheduler-event-label");const o=n.locale,d=i.dateStart,c=i.dateEnd;let u;if(t.isAllDayEvent||e){const e="short",t=n.dayFormat;if(d.getFullYear()===c.getFullYear()&&d.getMonth()===c.getMonth()&&d.getDate()===c.getDate())u=new Intl.DateTimeFormat(o,{day:t,month:e}).format(d);else{const n=new Intl.DateTimeFormat(o,{day:t,month:e});u=n.format(d)+" - "+n.format(c)}}else{const e=new Intl.DateTimeFormat(o,{hour:n.hourFormat,minute:n.minuteFormat});u=e.format(d)+" - "+e.format(c)}if(r&&s||(i.label+""?l.innerHTML='\n                            <div role="presentation"><label class="smart-scheduler-event-label"></label></div>\n                            <div role="presentation"><label class="smart-scheduler-event-time"></label></div>':l.innerHTML='<div role="presentation"><label class="smart-scheduler-event-time"></label></div>',s=l.querySelector(".smart-scheduler-event-label"),r=l.querySelector(".smart-scheduler-event-time")),s&&(s.textContent=a),r&&(r.textContent=u,s&&e&&t.eventSize<45?l.setAttribute("single-line",""):l.removeAttribute("single-line")),t.isTooltipEvent&&i.conference&&/^(ftp|http|https):\/\/[^ "]+$/.test(i.conference)){const e=document.createElement("div");e.innerHTML=`<a target="_blank" href="${i.conference}" class="info">${n.localize("join")}</a>`,e.classList.add("meeting");const t=i.conference;t.startsWith("https://zoom.us/")?e.innerHTML=`<a target="_blank" href="${i.conference}" class="info">${n.localize("joinWith",{value:"Zoom"})}</a>`:t.startsWith("https://meet.google.com/")?e.innerHTML=`<a target="_blank" href="${i.conference}" class="info">${n.localize("joinWith",{value:"Google Meet"})}</a>`:t.startsWith("https://teams.microsoft.com/")&&(e.innerHTML=`<a target="_blank" href="${i.conference}" class="info">${n.localize("joinWith",{value:"Microsoft Teams"})}</a>`),l.appendChild(e)}}}_createTimeline(){const e=this,t=e.resizeTrigger,n=e.scrollTop,i=e.scrollLeft,r=e.$.timeline;let a,l;t&&(a=t.offsetWidth,l=t.offsetHeight,t.style.display="none"),delete e._selectedCellObj,delete e._eventsBetween,e._createTimelineHeader(),e._refreshTimelineContentCells(),e._handleMenuAria(),r.classList.contains("no-agenda")?r.setAttribute("agenda-placeholder",e.localize("agendaPlaceholder")):r.removeAttribute("agenda-placeholder"),e.scrollTop=n,e.scrollLeft=i,t&&(t.style.display=null,a===t.offsetWidth&&l===t.offsetHeight||(e._noResizeHandler=!0)),e._refreshEvents(),e._checkNotifications()}_createTimelineHeader(){const e=this,t=e.$.timelineContent;if(t.style.width=t.style.height=null,Smart.Utilities.Core.Browser.Chrome){const t=e.$.timelineHeaderVertical;t.style.display="none",t.offsetHeight,t.style.display=null}e._validateEventDateRange(),e._createTimelineCellsObj(),e._createTimelineHeaderCells("horizontal"),e._createTimelineHeaderCells("vertical"),e._refreshTimelineHeaderCells(),e._refreshTimelineAllDayCells(),e._refresh()}_validateEventDateRange(e){const t=this.viewType;if(["month","agenda"].indexOf(t.toLowerCase())>-1)return;const n="day"===t||"week"===t,i=e?[e]:this._events;for(let e=0;e<i.length;e++){const t=i[e],r=t.dateStart,a=t.dateEnd;n&&a.getTime()-r.getTime()>=864e5&&(t.allDay=!0),t.allDay&&(t.dateStart.setHours(0,0,0,0),t.dateEnd.setHours(23,59,59,999))}}_handleMenuAria(){const e=this,t=e.$.currentDate,n=e.$.viewItemsButton,i=e.$.tooltip;t.setAttribute("aria-haspopup",!0),n.setAttribute("aria-controls",i.id),n.setAttribute("aria-haspopup",!0)}_handleTimelineGroupHeader(e){const t=this,n=t._timelineCells.groups;let i=t.$.groupsContainer;if(!n||!n.length||"agenda"===t.viewType&&!Object.keys(e.vertical).length)return void(i&&i.remove());i||(i=document.createElement("div"),i.classList.add("smart-scheduler-groups-container"),i.innerHTML='\n                        <div class="smart-scheduler-view-groups-label-container" role="presentation"></div>\n                        <div class="smart-scheduler-view-groups-content" role="presentation">\n                            <div class="smart-scheduler-view-header-groups-container" role="presentation"></div>\n                        </div>',t.$.groupsContainer=i);const r=t.view,a=t.views.find((e=>e.value&&e.value===r))||{},l="vertical"!==(a&&a.groupOrientation?a.groupOrientation:t.groupOrientation)?t.$.timelineHeaderHorizontal:t.$.timelineHeaderVertical;l.contains(i)||l.insertBefore(i,l.firstElementChild)}_handleTimeZoneHeader(e){const t=this;e||(e="horizontal",t._handleTimeZoneHeader("vertical"));const n=t.viewType.toLowerCase(),i=n.indexOf("timeline")>-1,r=("vertical"===e?t.$.timelineHeaderVerticalContent:t.$.timelineHeaderHorizontalContent).querySelector(".smart-scheduler-view-time"),a=r.children,l=t.$.timelineViewCellsLabelContainer,o=!i&&"agenda"!==n&&"vertical"===e||"horizontal"===e&&i;let s=t.timeZones.slice(0);const d=t.$.viewDetailsLabel,c=t.$.timelineViewAllDay,u=t.$.timelineTimeZoneLabelContainer;if(u.remove(),d&&d.remove(),t._recycleContainerCells({fragment:r,cellsNeeded:1+(o&&n.indexOf("month")<0?s.length:0),className:"smart-scheduler-cells"}),s.push(t.timeZone),(i&&o||!i)&&t._recycleContainerCells({fragment:l,cellsNeeded:!i&&n.indexOf("month")<0&&"agenda"!==n?s.length:0,className:"smart-scheduler-time-zone"}),c.offsetHeight&&l.offsetHeight&&(t.$.timelineViewAllDaylabel.style.maxWidth=l.offsetWidth+"px"),o){const e=u.parentElement;t._recycleContainerCells({fragment:u,cellsNeeded:1===a.length?0:a.length,className:"smart-scheduler-time-zone"}),a.length&&e&&e.appendChild(u)}}_createTimelineHeaderCells(e="vertical"){const t=this,n=t.viewType.toLowerCase(),i=n.indexOf("timeline")>-1,r="vertical"===e?t.$.timelineHeaderVerticalContent:t.$.timelineHeaderHorizontalContent,a=r.querySelector(".smart-scheduler-view-time"),l=r.querySelector(".smart-scheduler-view-details"),o=a.children,s=!i&&"agenda"!==n&&"vertical"===e||"horizontal"===e&&i;let d=t.timeZones.slice(0);const c=t._getTimelineVisibleCellsCount(e),u=t.timeZone,h=o.length;d.push(t.timeZone);for(let e=0;e<h;e++){const n=o[e],i=d[e];n.timeZone=1===h?u:i.id||i,t._recycleContainerCells({fragment:n,cellsNeeded:c})}if(l&&t._recycleContainerCells({fragment:l,cellsNeeded:t._getTimelineVisibleCellsCount({orientation:e,type:"details"})}),t._createTimelineHeaderGroupCells(e),s){const e=t.$.timelineTimeZoneLabelContainer,r=t.$.timelineViewCellsLabelContainer;e.remove();const a=t.$.timelineAllDayLabelContainer;let o=t.$.viewDetailsLabel;if(i&&n.indexOf("week")>-1&&l?(o||(o=document.createElement("div"),o.classList.add("smart-scheduler-view-details-label"),t.$.viewDetailsLabel=o),o.parentElement||r.appendChild(o)):o&&o.parentElement&&o.remove(),!e.children.length)return;!i&&a.offsetHeight?a.appendChild(e):r.offsetHeight&&r.appendChild(e)}}_createTimelineHeaderGroupCells(e){const t=this,n=t.view,i=t.viewType,r=i.indexOf("timeline")>-1,a=t.views.find((e=>e.value&&e.value===n))||{},l=t._timelineCells,o=l.groups,s=a&&a.groupOrientation?a.groupOrientation:t.groupOrientation;let d=t.$.groupsContainer;if("vertical"===e&&"vertical"!==s||("horizontal"===e&&"day"!==i||!e)&&"vertical"===s)return;if(d&&d.remove(),!o||!o.length||"agenda"===i&&!l.vertical.length)return;const c=t._timelineCells.groups,u=d.querySelector(".smart-scheduler-view-header-groups-container"),h=u.children;t._recycleContainerCells({fragment:u,cellsNeeded:c.length,className:"smart-scheduler-cell-container",role:"row"});for(let n=0;n<h.length;n++)t._recycleContainerCells({fragment:h[n],cellsNeeded:t._getTimelineVisibleCellsCount({orientation:e,type:"groups",resource:c[n].resource})});let m="vertical"===e||i.toLowerCase().indexOf("month")>-1?0:t.timeZones.length+("month"===i?0:1);if(r&&(m=m>1?1:0),"agenda"===i&&(m="vertical"!==s&&t._timelineCells.vertical.length?1:0),t._recycleContainerCells({fragment:d.querySelector(".smart-scheduler-view-groups-label-container"),cellsNeeded:m,className:"smart-scheduler-time-zone"}),!d.parentElement&&e===s){const n="horizontal"===e?t.$.timelineHeaderHorizontal:t.$.timelineHeaderVertical;n.insertBefore(d,n.firstElementChild)}}_recycleContainerCells(e){const t=this,n=e.fragment;if(!n)return;const i=n.children,r=n.children.length,a=e.cellsNeeded,l=e.className,o=e.role,s=e.isBackwards?"lastElementChild":"firstElementChild";if(r>a)for(;i.length&&i.length!==a;)n.removeChild(n[s]);else r<a&&n.appendChild(t._createCells(a-r,l,o))}_createTimelineCellsObj(){const e=this,t=e.viewType,n=t.indexOf("timeline")>-1,i=e._getCellsCount(),r=e._getCellsScaleCount(),a=window.getComputedStyle(e);e.timeZones.length>0&&n&&"timelineMonth"!==t?e.$.timeline.setAttribute("show-vertical-header",""):e.$.timeline.removeAttribute("show-vertical-header");let l=Math.max(parseFloat(a.getPropertyValue("--smart-scheduler-timeline-cell-height"))||0,parseFloat(a.getPropertyValue("--smart-scheduler-timeline-cell-min-height")||0)),o=Math.max(parseFloat(a.getPropertyValue("--smart-scheduler-timeline-cell-width"))||0,parseFloat(a.getPropertyValue("--smart-scheduler-timeline-cell-min-width")||0));e._eventSize=parseFloat(a.getPropertyValue("--smart-scheduler-event-size"))||0,e._allDayCellSize=parseFloat(a.getPropertyValue("--smart-scheduler-timeline-header-all-day-cells-size"))||e.$.timelineViewAllDay.offsetHeight,e.__allDayCellSize||(e.__allDayCellSize=e._allDayCellSize),e._eventCollectorSize=parseFloat(a.getPropertyValue("--smart-scheduler-event-collector-size"))||0,e._monthViewNumberSize="month"!==t?0:parseFloat(a.getPropertyValue("--smart-scheduler-month-view-number-size"))||0,t.indexOf("timeline")>-1?o*=r:l*=r,e._timelineCells={},e._scrollViewSize={},e.groups.length&&(e._timelineCells.groups=e._getTimelineCellsObjGroups()),e._handleTimelineGroupHeader(i),e._handleTimeZoneHeader(),e._refresh(),e._handleTimelineContentSize(i,l,"height");let s=e.$.timelineContainer.offsetHeight;e._handleTimelineContentSize(i,o,"width"),s!==(s=e.$.timelineContainer.offsetHeight)&&e._handleTimelineContentSize(i,l,"height"),e._scrollViewSize.height=s,e._scrollViewSize.width=e.$.timelineContainer.offsetWidth,e._timelineCells.horizontal=e._getTimelineCellsObjHorizontal(i.horizontal,o),e._timelineCells.vertical=e._getTimelineCellsObjVertical(i.vertical,l),"timelineWeek"===t&&(e._timelineCells.details=e._getTimelineCellsObjDetails())}_getResourceGroups(){const e=this,t=e.groups,n=e.resources;let i,r=[],a=[];if(!t.length||!n.length)return a;for(let a=0;a<t.length;a++){const l=n.find((e=>e.value===t[a]));if(!l||!l.dataSource.length)continue;const o=e._getResourceData(l);if(Object.keys(o).length){const t=Object.values(o),n=i?i.cells.length:1;let a=[];e._applyResourceSorting(l,t);for(let e=0;e<n;e++)for(let n=0;n<t.length;n++){const r={resource:l.value,label:t[n].label,group:i?Object.assign({},i.cells[e].group):{},groupSeparator:!0};r.group[l.value]=t[n].id,a.push(r)}r.push(i={resource:l.value,groups:t,cells:a})}}return r}_getResourceData(e){const t=e?e.dataSource:void 0;if(!t||!t.length)return;let n={};for(let e=0;e<t.length;e++){const i=t[e];n[i.id]={id:i.id,label:i.label,color:i.color}}return n}_applyResourceSorting(e,t){const n=this,i=e.sortFunction?e.sortFunction:n.sortFunction,r=e.sortBy?e.sortBy:n.sortBy,a=e.sortOrder?e.sortOrder:n.sortOrder;if(!r)return;const l=(e,t)=>{const n=e[r],i=t[r];return"string"==typeof n&&"string"==typeof i?n.toLowerCase().localeCompare(i.toLowerCase()):"boolean"==typeof n&&"boolean"==typeof i?n===i:n instanceof Date&&i instanceof Date?n.getTime()-i.getTime():n-i};switch(a){case"asc":case"ascending":t.sort(((e,t)=>l(e,t)));break;case"desc":case"descending":t.sort(((e,t)=>l(t,e)));break;case"custom":"function"==typeof i&&t.sort(i);break;default:return}}_getTimelineCellsObjGroups(){const e=this,t=e._getResourceGroups();let n=[];if(!t.length)return n;for(let e=t.length-1;e>-1;e--){const i=t[e];if(n.length){const e=n.slice(0);n=[],i.groups.forEach((t=>{e.forEach((e=>{const r=Object.assign({},e);r.group=Object.assign({},r.group),r.group[i.resource]=t.id,n.push(r)}))}))}else i.groups.forEach((e=>{const t={label:e.label,color:e.color,group:{},resource:i.resource,groupSeparator:!0};t.group[i.resource]=e.id,n.push(t)}))}if(n.length){const t=e.view,n=e.views.find((e=>e.value&&e.value===t))||{},i=n&&n.groupOrientation?n.groupOrientation:e.groupOrientation;e.$.timeline.setAttribute("show-group-header",i)}else e.$.timeline.removeAttribute("show-group-header");return t[t.length-1].cells=n,t}_getTimelineCellsObjHorizontal(e,t){const n=this,i=n.view,r=n.viewType,a=i.indexOf("timeline")>-1,l=n.views.find((e=>e.value&&e.value===i))||{},o=new Date(n.dateCurrent);a?o.setHours(n.hourStart,0,0,0):o.setHours(0,0,0,0);const s=n.firstDayOfWeek;let d,c;switch(r){case"week":case"timelineWeek":"dateCurrent"!==n.viewStartDay&&o.setDate(o.getDate()-o.getDay()+s),c=n.hideWeekend||l.hideWeekend,d=n.hideNonworkingWeekdays||l.hideNonworkingWeekdays;break;case"month":case"timelineMonth":o.setDate(1),a||"dateCurrent"!==n.viewStartDay&&o.setDate(o.getDate()-o.getDay()+s),o.setHours(0,0,0,0),c=n.hideWeekend||l.hideWeekend,d=n.hideNonworkingWeekdays||l.hideNonworkingWeekdays}return n._getCellsObject({orientation:"horizontal",cells:[],cellSize:t,cellCount:e,date:o,hideWeekend:c,hideNonworkingWeekdays:d,hourStart:n.hourStart,hourEnd:n.hourEnd,viewSize:n.$.timelineContent.offsetWidth,viewDetails:l,offset:0})}_getCellsObject(e){const t=this,n=t.view,i=t.viewType,r=e.viewDetails||t.views.find((e=>e.value&&e.value===n))||{},a=t._timelineCells.groups,l=r&&r.groupOrientation?r.groupOrientation:t.groupOrientation,o=e.cellCount,s=e.viewSize,d=e.orientation,c=e.cells;let u,h=e.cellSize,[m,v]="horizontal"===d?["width","left"]:["height","top"];if(e.restrictedDates=t.restrictedDates,e.restrictedHours=t.restrictedHours,a&&a.length&&(u=a[a.length-1].cells),!u||!u.length||"horizontal"===d&&"vertical"===l||"vertical"===d&&"vertical"!==l)o*h<s&&(h=s/o),e.cellSize=parseFloat(h.toFixed(2)),"agenda"===i&&u&&u.length&&(e.groups=u),t._createCellObjects(e);else{const n=u.length;if(1===o){let e=s/n;e>=h&&(h=e)}else{const e=o*n;e*h<s&&(h=s/e)}if(e.cellSize=parseFloat(h.toFixed(2)),t.groupByDate&&d===l)e.groupHeader=a[a.length-1],t._createCellObjects(e);else{for(let n=0;n<u.length;n++){const i=u[n];i[v]=e.offset,e.size=0,e.group=i.group,t._createCellObjects(e),i[m]=e.size||0,t._refreshGroupHeaderCells(d,i)}c.length||t._createCellObjects(e)}}return c}_refreshGroupHeaderCells(e="horizontal",t){const n=t.group,i=this._timelineCells.groups;if(!i)return;let r=t.date,a=r?"cellsByDate":"cells";const[l,o]="horizontal"===e?["width","left"]:["height","top"];i.forEach((e=>{if(e.resource!==t.resource){const i=e[a];for(let e=0;e<i.length;e++){const a=i[e],s=a.group;r&&r.getTime()!==a.date.getTime()||Object.keys(s).every((e=>s[e]===n[e]))&&(a[l]=(void 0===a[l]?0:a[l])+t[l],void 0===a[o]&&(a[o]=t[o]))}}}))}_createCellObjects(e){const t=this;"horizontal"===e.orientation?t._createCellsObjectHorizontal(e):t._createCellsObjectVertical(e)}_createCellsObjectHorizontal(e){if(!e)return[];const t=this,n=t.viewType,i=n.indexOf("timeline")>-1,r=e.cells,a=new Date(e.date),l=e.cellSize,o=e.cellCount,s=e.hideWeekend,d=e.hideNonworkingWeekdays,c=e.hourStart,u=e.hourEnd,h=e.group,m=e.groupHeader,v=e.viewDetails,g=["timelineDay","timelineWeek"].indexOf(n)>-1;let f,p,w,y,_,b=e.offset,D=0;"agenda"===n?p=w=y=_=[]:(p=t.nonworkingDays,w=t.nonworkingHours,y=e.restrictedDates,_=e.restrictedHours),g?a.setHours(c):a.setHours(0,0,0,0);for(let C=0;C<o;C++){if(f={width:l},d){let e=0;const t=a.getHours();for(;e<7&&p.indexOf(a.getDay())>-1;)a.setDate(a.getDate()+1),e++;a.setHours(t)}if(s&&[0,6].indexOf(a.getDay())>-1){const e=a.getHours();a.setDate(a.getDate()+1),a.setHours(e)}if(f.restricted=t._isDateRestricted(a,y),!f.restricted&&i&&(f.restricted=t._isHourRestricted(a,_)),t.restricted)for(let e=0;e<t.restricted.length;e++){const n=t.restricted[e];t._isDateRestricted(a,[n.date])&&0===n.hours.length&&(f.restricted=!0)}if("agenda"===n?f.noLabel=!0:f.weekend=0===a.getDay()||6===a.getDay(),f.nonworking=p.indexOf(a.getDay())>-1,g&&(f.nonworking=f.nonworking||w.indexOf(a.getHours())>-1),m?(e.offset=b,e.date=a,t._createCellsObjByDate(f,e),b=e.offset):(h&&(f.group=h),f.left=b,f.date=new Date(a),r.push(f),b=parseFloat((b+l).toFixed(2))),!i||"timelineMonth"===n||"timelineWeek"===n&&v&&v.hideHours)a.setDate(a.getDate()+1),a.setHours(0,0,0,0);else{const e=a.getHours();"timelineWeek"===n&&e===u?(a.setDate(a.getDate()+1),a.setHours(c)):(a.setHours(a.getHours()+1),e===a.getHours()&&a.setHours(a.getHours()+2))}D+=l}f&&h&&(f.groupSeparator=!0),e.offset=b,e.size=D}_getTimelineCellsObjVertical(e,t){const n=this;return n._getCellsObject({orientation:"vertical",cells:[],date:new Date(n.dateCurrent),cellSize:t,cellCount:e,viewSize:n._scrollViewSize.height,offset:0})}_isEventPartOfGroup(e,t){if(e)return t=t.group||t,Object.keys(t).every((n=>e[n]&&e[n]===t[n]))}_createCellsObjByDate(e,t){const n=this,i=t.groupHeader;if(!i)return;const[r,a]="horizontal"===t.orientation?["width","left"]:["height","top"],l=i.cells,o=t.date,s=e[r],d=t.cells,c=t.agendaItem;let u=t.offset;n._createGroupCellsByDate(t,c);const h=i.cellsByDate,m=l.length,v=m%2==0?"center":"offset";for(let i=0;i<m;i++){const g=l[i],f=g.group;if(c&&!n._isEventPartOfGroup(c,f))continue;const p=Object.assign({},e),w=h.find((e=>e.date.getTime()===o.getTime()&&Object.keys(f).every((t=>f[t]===e.group[t]))));w&&(w[a]=void 0===w[a]?u:w[a],w[r]=p[r]+(c&&w[r]||0),p[a]=u,p.date=new Date(o),p.group=g.group,c||(i===m-1&&(p.groupSeparator=!0),i===Math.round(m/2)&&(p.showLabel=v)),n._refreshGroupHeaderCells(t.orientation,w),d.push(p),u=parseFloat((u+s).toFixed(2)))}t.offset=u}_createGroupCellsByDate(e,t){const n=this,i=e.date,r=n._timelineCells.groups;if(i)for(let a=0;a<r.length;a++){const l=r[a];let o=l.cellsByDate;o||(o=l.cellsByDate=[]);const s=l.cells;for(let r=0;r<s.length;r++){let a;if(t){if(!n._isEventPartOfGroup(t,s[r]))continue;a=o.find((e=>e.date.getTime()===i.getTime()&&e.group[e.resource]===t[e.resource]))}a=a||Object.assign({},s[r]),a.date||(a.date=new Date(i)),a.separator=!!e.separator,a.groupSeparator=t?!a.separator:r===s.length-1,o.includes(a)||o.push(a)}}}_createCellsObjectVertical(e){const t=this;if(!e)return;const n=t.firstDayOfWeek,i=t.viewType,r=i.indexOf("timeline")>-1,a=e.cells,l=new Date(e.date),o=e.cellCount,s=e.viewSize,d=t.nonworkingHours,c=e.group,u=e.groups,h=e.groupHeader;let m,v=e.offset,g=0,f=e.cellSize;if("agenda"===i){const n=Object.keys(o).sort(((e,t)=>parseInt(e)-parseInt(t)));for(let i of n){let n=o[i],r=f;if(c)n=n.filter((e=>t._isEventPartOfGroup(e,c)));else if(u)n=t._getAgendaGroupEvents(n);else if(h){const e=h.cells;let i=n.slice(0);n=[];for(let r=0;r<e.length;r++)n.push(...i.filter((n=>t._isEventPartOfGroup(n,e[r]))))}const l=n.length,d=new Date(parseInt(i));l*r<s&&(r=s/l),r=parseFloat(f.toFixed(2));for(let i=0;i<l;i++){const o=d;m={height:r,separator:i===l-1,weekend:0===o.getDay()||6===o.getDay(),nonworking:t.nonworkingDays.indexOf(o.getDay())>-1},i>0&&(m.noLabel=!0),h?(e.offset=v,e.date=o,e.agendaItem=n[i],e.separator=m.separator,t._createCellsObjByDate(m,e),v=e.offset):(c&&(m.group=c),m.top=v,m.date=o,a.push(m),v=parseFloat((v+r).toFixed(2))),g+=r}}t.$.timeline.classList[a.length?"remove":"add"]("no-agenda")}else if(r)for(let n=0;n<o;n++)l.setHours(0,0,0,0),m={height:f,weekend:0===l.getDay()||6===l.getDay()},h?(e.offset=v,e.date=l,t._createCellsObjByDate(m,e),v=e.offset):(c&&(m.group=c),m.top=v,m.date=new Date(l),a.push(m),v=parseFloat((v+f).toFixed(2))),g+=f;else{let r;"month"===i?(l.setDate(1),l.setDate(l.getDate()-(l.getDay()-n+7)%7),l.setHours(0,0,0,0)):(l.setHours(t.hourStart,0,0,0),r=e.restrictedHours);for(let n=0;n<o;n++)m={height:f},h?(e.offset=v,e.date=l,t._createCellsObjByDate(m,e),v=e.offset):(c&&(m.group=c),m.top=v,m.date=new Date(l),a.push(m),v=parseFloat((v+f).toFixed(2))),g+=f,"month"===i?l.setDate(l.getDate()+7):(m.nonworking=d.indexOf(l.getHours())>-1,l.setHours(l.getHours()+1),r&&(m.restricted=t._isHourRestricted(l,r)))}m&&c&&(m.groupSeparator=!0),e.offset=v,e.size=g}_getTimelineCellsObjDetails(){const e=this,t=e.view,n=e.views.find((e=>e.value&&e.value===t));if("timelineWeek"!==e.viewType||n&&n.hideHours)return[];function i(e){let t="";if(!a&&e)for(const n in e)t+=n+e[n];return t}const r=e.hourStart,a=e.groupByDate,l=e._timelineCells.horizontal;let o,s={};for(let e=0;e<l.length;e++){const t=l[e],n=t.date,a=n.getDate()+i(t.group);if(o=s[a],o||(o=s[a]={width:0,left:t.left}),o.width+=t.width,t.groupSeparator&&(o.groupSeparator=t.groupSeparator),!o.date){const e=new Date(n);e.setHours(r,0,0,0),o.date=e}}return s=Object.values(s).sort(((e,t)=>e.left-t.left)),s}_getAgendaGroupEvents(e){const t=this,n=t._timelineCells.groups;let i;n&&n.length&&(i=n[n.length-1].cells);const r={};let a=0;for(let n=0;n<i.length;n++)r[n]=e.filter((e=>t._isEventPartOfGroup(e,i[n]))),r[n].length>r[a].length&&(a=n);return r[a]}_handleTimelineContentSize(e,t,n){const i=this,r=i.view,a=i.viewType,l=i._timelineCells.groups,o=i.views.find((e=>e.value&&e.value===r))||{},s=o&&o.groupOrientation?o.groupOrientation:i.groupOrientation,d="agenda"===a&&Object.keys(e.vertical).length?i.$.timelineHeaderVertical.offsetWidth:Math.max(i.$.timelineViewCellsLabelContainer.offsetWidth,i.$.timelineViewAllDaylabel.offsetWidth),c="width"===n?Math.max(0,i.$.timeline.offsetWidth-d):i.$.timelineContainer.offsetHeight;let u=0,h=[],m=e["width"===n?"horizontal":"vertical"];if(l&&l.length&&(h=l[l.length-1].cells),"agenda"===a&&"height"===n)for(let e in m){let n=m[e];h.length&&(n="horizontal"===s?i._getAgendaGroupEvents(n):n.filter((e=>h.some((t=>i._isEventPartOfGroup(e,t)))))),u+=n.length*t}else{let e=1;i.groups.length&&("vertical"!==s&&"width"===n||"vertical"===s&&"height"===n)&&(e=Math.max(h.length,1)),1===m?c<t?u=t*e:(u=c/e,u<t&&(u=t*e)):(m*=e,m*t<c&&(t=c/m),u=m*(t=parseFloat(t.toFixed(2))))}u=Math.max(u,c,t),i.$.timelineContent.style[n]=u===c?"":u+"px",i._refresh()}_createCells(e,t="smart-scheduler-cell",n="gridcell"){let i,r=document.createDocumentFragment();Array.isArray(t)||(t=[t]);for(let a=0;a<e;a++)i=document.createElement("div"),t.forEach((e=>i.classList.add(e))),i.setAttribute("role",n),r.appendChild(i);return r}_refreshTimelineContentCells(){const e=this,t=e._timelineCells;if(!t||!t.vertical||!t.horizontal)return;const n=e.$.timelineContainer,i=e.$.timelineCellsContainer,r=e.$.timelineContent,a=e.view,l=e.viewType,o=e.views.find((e=>e.value&&e.value===a))||{},s=o&&o.groupOrientation?o.groupOrientation:e.groupOrientation,d=e._getVisibleCellObj();if(!d)return;const c={viewType:l,isTimelineView:l.indexOf("timeline")>-1,visibleCellObjs:d,groupOrientation:s,locale:e.locale,timeZone:e.timeZone,isRightToLeft:e.rightToLeft,dateCurrent:e.dateCurrent,restrictedDates:e.restrictedDates,restrictedHours:e.restrictedHours};i.remove(),e._recycleContainerCells({fragment:i,cellsNeeded:d[e.viewType.indexOf("timeline")>-1?"horizontal":"vertical"].length,className:"smart-scheduler-cell-container",role:"row"}),e._refreshContainerCells(i,c),r.insertBefore(i,r.firstElementChild),n.scrollTop=e.scrollTop,n.scrollLeft=e._getScrollLeft(e.scrollLeft),e._setCurrentTimeIndicators()}_getVisibleCellObj(){const e=this,t=e._timelineCells;if(!t||!t.vertical||!t.horizontal)return;const n=t.vertical,i=t.horizontal,[r,a]=[e.scrollTop,e.scrollLeft],[l,o]=[r+e._scrollViewSize.height,a+e._scrollViewSize.width];let[s,d]=[[],[]];for(let e=0;e<n.length;e++){const t=n[e];t.top+t.height>=r&&t.top<=l&&s.push(t)}for(let e=0;e<i.length;e++){const t=i[e];t.left+t.width>=a&&t.left<=o&&d.push(t)}return{vertical:s,horizontal:d}}_refreshContainerCells(e,t){const n=this,i=t.viewType,r=t.groupOrientation,a=t.isTimelineView,l=t.visibleCellObjs,o=e.children,s=e===n.$.timelineCellsContainer,d=t.isRightToLeft,c=t.dateCurrent,u=t.restrictedDates,h=t.restrictedHours,m=new Date;let v,g,f,p,w,y,_;if(s)a?(f=l.horizontal,[w,y,_]=["horizontal","left","width"]):(f=l.vertical,[w,y,_]=["vertical","top","height"]),v=l.vertical,p=n._getCellsScaleCount();else if(a?(v=l.horizontal,f=l.vertical,[w,y,_]=["vertical","top","height"]):(v=l.vertical,f=l.horizontal,[w,y,_]=["horizontal","left","width"]),n._selectedCellObj){const e=n._selectedCellObj.from;if(!e.allDay){const t=n._selectedCellObj.to;g={lastTime:e.time,fromTime:Math.min(e.time,t.time),toTime:Math.max(e.time,t.time),group:e[r]?e[r].group:void 0}}}for(let l=0;l<o.length;l++){const b=o[l],D=f[l];let C;if(D.nonworking?b.setAttribute("nonworking",""):b.removeAttribute("nonworking"),D.weekend?b.setAttribute("weekend",""):b.removeAttribute("weekend"),D.separator?b.setAttribute("separator",""):b.removeAttribute("separator"),C=D.groupSeparator,s)a||"vertical"!==r||(C=v[l].groupSeparator),C&&(a&&"vertical"!==r||!a&&"vertical"===r)?b.setAttribute("group-separator",""):b.removeAttribute("group-separator"),b.$={cellObj:D},n._refreshScaleCells(b,t,p);else{b.$||(b.$={cellObj:{}});const t=b.$.cellObj;t.scaleIndex=e._scaleIndex,a?(t.horizontal=e.$.cellObj,t.vertical=D):(t.horizontal=D,t.vertical=e.$.cellObj);const l=t[r]?t[r].group:void 0;if(l)for(const e in l)b.setAttribute(e,l[e]||"");C&&(!a&&"vertical"!==r||a&&"vertical"===r)?b.setAttribute("group-separator",""):b.removeAttribute("group-separator");const o=new Date(t.time=n._getCellTime(t));if(n._isDateRestricted(o,u)||n._isHourRestricted(o,h)?b.setAttribute("restricted",""):b.removeAttribute("restricted"),n.restricted)for(let e=0;e<n.restricted.length;e++){const t=n.restricted[e];if(n._isDateRestricted(o,[t.date])){const e=o.getHours();for(let n=0;n<t.hours.length;n++){const i=t.hours[n];Array.isArray(i)?e>=i[0]&&e<=i[1]&&b.setAttribute("restricted",""):e===i&&b.setAttribute("restricted","")}}}n._refreshAvailableState(D,b,o),o.getFullYear()===m.getFullYear()&&o.getMonth()===m.getMonth()&&o.getDate()===m.getDate()?b.setAttribute("today",""):b.removeAttribute("today",""),n._setCellContent(b,o),b.setAttribute("aria-haspopup",!0),"month"===i&&o.getMonth()!==c.getMonth()?b.setAttribute("other-month",""):b.removeAttribute("other-month"),b.setAttribute("date",o),b.removeAttribute("selected"),g&&l===g.group&&t.time>=g.fromTime&&t.time<=g.toTime&&b.setAttribute("selected",t.time===g.lastTime?"start":"")}b.style.top=b.style.left=b.style.right=b.style.width=b.style.height="",b.style[_]=D[_]+"px","horizontal"===w?b.style[d?"right":"left"]=D.left+"px":b.style[y]=D[y]+"px"}}getViewDates(){const e=this.querySelectorAll(".smart-scheduler-cell");let t=null,n=null;for(let i=0;i<e.length;i++)!e[i].hasAttribute("all-day")&&e[i].hasAttribute("date")&&(t||(t=e[i]),n=e[i]);if(t&&n){const e=new Date(t.getAttribute("date")),i=new Date(n.getAttribute("date"));return e.setHours(0,0,0,0),i.setHours(23,59,59,999),[e,i]}return null}_refreshScaleCells(e,t,n){const i=this,r=t.visibleCellObjs,a=t.isTimelineView,l=e.children;i._recycleContainerCells({fragment:e,cellsNeeded:n,className:["smart-scheduler-cell","scale"],role:"presentation"});const o=a?"width":"height",s=l.length,d=e.$.cellObj,c=r[a?"vertical":"horizontal"].length;for(let r=0;r<s;r++){const a=l[r];a.$=e.$,a._scaleIndex=r,d.nonworking?a.setAttribute("nonworking",""):a.removeAttribute("nonworking"),a.style.width=a.style.height=null,a.style[o]=100/n+"%",i._recycleContainerCells({fragment:a,cellsNeeded:c}),i._refreshContainerCells(a,t),delete a._scaleIndex}}getDateFromCoordinates(e,t){const n=this.querySelectorAll(".smart-scheduler-cell");for(let i=0;i<n.length;i++){const r=n[i],a=r.getBoundingClientRect();if(r.hasAttribute("date")&&a.left<=e&&a.right>=e&&a.top<=t&&a.bottom>=t){const e=r.getAttribute("date");return new Date(e)}}return null}getIsAllDayCellFromCoordinates(e,t){const n=this.querySelectorAll(".smart-scheduler-cell");for(let i=0;i<n.length;i++){const r=n[i],a=r.getBoundingClientRect();if(r.hasAttribute("date")&&a.left<=e&&a.right>=e&&a.top<=t&&a.bottom>=t&&r.hasAttribute("all-day"))return!0}return!1}_refreshAvailableState(e,t,n){const i=this;if(i.available&&i.available.length){t.setAttribute("restricted",""),e.restricted=!0;for(let r=0;r<i.available.length;r++){const a=i.available[r],l=e.group?Object.keys(e.group)[0]:null;if(!e.group||void 0===a[l]||e.group&&e.group[l]===a[l])if("string"==typeof a.start&&5===a.start.length&&a.start.indexOf(":")>=0){const i=a.start.split(":"),r=parseInt(i[0]),l=parseInt(i[1]),o=a.end.split(":"),s=parseInt(o[0]),d=parseInt(o[1]),c=new Date(n.getFullYear(),n.getMonth(),n.getDate(),r,l,0),u=new Date(n.getFullYear(),n.getMonth(),n.getDate(),s,d,0);c<=n&&n<=u&&(t.removeAttribute("restricted"),e.restricted=!1)}else if("string"==typeof a.start&&a.start.length<=2){const i=parseInt(a.start),r=parseInt(a.end),l=new Date(n.getFullYear(),n.getMonth(),n.getDate(),i,0,0),o=new Date(n.getFullYear(),n.getMonth(),n.getDate(),r,0,0);l<=n&&n<=o&&(t.removeAttribute("restricted"),e.restricted=!1)}else if(a.date){if(a.date.getFullYear()===n.getFullYear()&&a.date.getMonth()===n.getMonth()&&a.date.getDate()===n.getDate()){const i=n.getHours();if(a.hours)for(let n=0;n<a.hours.length;n++){const r=a.hours[n];Array.isArray(r)?i>=r[0]&&i<=r[1]&&(t.removeAttribute("restricted",""),e.restricted=!1):i===r&&(t.removeAttribute("restricted",""),e.restricted=!1)}else t.removeAttribute("restricted",""),e.restricted=!1}}else if("number"==typeof a.start){const i=a.start,r=a.end,l=new Date(n.getFullYear(),n.getMonth(),n.getDate(),i,0,0),o=new Date(n.getFullYear(),n.getMonth(),n.getDate(),r,0,0);l<=n&&n<=o&&(t.removeAttribute("restricted"),e.restricted=!1)}else{const i=new Smart.Utilities.DateTime(a.start).toDate(),r=new Smart.Utilities.DateTime(a.end).toDate();i<=n&&n<=r&&(t.removeAttribute("restricted"),e.restricted=!1)}}}}_refreshTimelineAllDayCells(){const e=this,t=new Date,n=e.restrictedHours,i=e.viewType.toLowerCase(),r=e.$.timelineViewAllDayContent,a=e.$.timelineViewAllDayCellsContainer;if(i.indexOf("timeline")>-1||i.indexOf("month")>-1)return void(a.innerHTML="");a.remove();const l=a.children,o=e.locale,s=e.rightToLeft,d={height:e._allDayCellSize,top:0},c=e.$.timelineHeaderHorizontalContent.querySelector(".smart-scheduler-cells").children;e._recycleContainerCells({fragment:a,cellsNeeded:"agenda"===i?0:c.length});for(let i=0;i<l.length;i++){const r=l[i],a=c[i],u=a.$.cellObj;r.$||(r.$={cellObj:{}});const h=r.$.cellObj;h.horizontal=u,h.vertical=d,h.allDay=!0,r.setAttribute("all-day","");const m=h.horizontal.group;if(m)for(const e in m)r.setAttribute(e,m[e]||"");const v=new Date(h.time=e._getCellTime(h));u.restricted||n.length?r.setAttribute("restricted",""):r.removeAttribute("restricted"),v.getFullYear()===t.getFullYear()&&v.getMonth()===t.getMonth()&&v.getDate()===t.getDate()?r.setAttribute("today",""):r.removeAttribute("today",""),e._setCellContent(r,v),r.setAttribute("date",v.toLocaleDateString(o)),u.groupSeparator?r.setAttribute("group-separator",""):r.removeAttribute("group-separator"),u.weekend?r.setAttribute("weekend",""):r.removeAttribute("weekend"),u.nonworking?r.setAttribute("nonworking",""):r.removeAttribute("nonworking"),e._refreshAvailableState(u,r,v),s?(r.style.left="",r.style.right=a.style.right):(r.style.right="",r.style.left=a.style.left),r.style.width=a.style.width}r.insertBefore(a,r.firstElementChild),r.scrollLeft=e._getScrollLeft(e.scrollLeft)}_getCellsScaleCount(){const e=this,t=e.viewType,n=e.view;if(["timelineMonth","month","agenda"].indexOf(t)>-1)return 1;if("timelineWeek"===t){const t=e.views.find((e=>e.value&&e.value===n))||{};if(t&&t.hideHours)return 1}switch(e.timelineDayScale){case"hour":return 1;case"halfHour":return 2;case"quarterHour":return 4;case"tenMinutes":return 6;case"fiveMinutes":return 12;default:return 1}}_getTimelineVisibleCellsCount(e="horizontal"){const t=this,n=e.orientation||e,i=e.type,r=e.resource;let a=t._timelineCells[n];if(i&&(a=r?t._timelineCells.groups.find((e=>e.resource===r))[t.groupByDate?"cellsByDate":"cells"]:t._timelineCells[i]),!a)return 0;const l=t._getFirstCellObjInView({orientation:n,type:i,resource:r});if(!l)return 0;const[o,s,d]="horizontal"===n?["left","width",t.scrollLeft]:["top","height",t.scrollTop];let c;if("vertical"===n?c=t._scrollViewSize.height:(c=t.$.timelineHeaderHorizontalContent.offsetWidth||t.$.timelineViewAllDayContent.offsetWidth,!c&&t.hideAllDay&&"day"===t.viewType&&(c=t.offsetWidth),"agenda"===t.viewType&&t._timelineCells.vertical.length&&(c-=t.$.timelineHeaderVertical.offsetWidth)),i){let e=0;if("details"===i&&("timelineWeek"!==t.viewType||"vertical"===n))return e;for(let t=a.indexOf(l);t<a.length;t++){const n=a[t];n[o]+n[s]>=d&&n[o]<c+d&&e++}return e}const u=1-(l[o]+l[s]-d)/a[0][s];return isNaN(u)||!isFinite(u)?0:Math.min(a.length,Math.ceil(parseFloat((c/l[s]+u).toFixed(2))))}_getFirstCellObjInView(e="horizontal"){const t=this,n=e.orientation||e,i=e.type,r=e.resource,a=t._timelineCells;if(!a)return;let l,o,s;const[d,c,u]="horizontal"===n?["scrollLeft","left","width"]:["scrollTop","top","height"],h=Math.abs(t[d]);s=a[n],i&&(s=r?t._timelineCells.groups.find((e=>e.resource===r))[t.groupByDate?"cellsByDate":"cells"]:t._timelineCells[i]);for(let e=0;e<s.length;e++){const t=s[e];if(t[c]+t[u]>=h){l=t;break}o=t}return!l&&o&&(l=h>o[c]?o:s[0]),l}_getCellsCount(e){const t=this,n=t.dateCurrent,i=new Date(t.dateCurrent);e||(e=t.view);const r=t.viewType,a=t.views.find((t=>t.value&&t.value===e))||{},l=t.nonworkingDays;let[o,s,d,c]=[0,0,0,0,0];const u=t.hideNonworkingWeekdays||a.hideNonworkingWeekdays,h=t.hideWeekend||a.hideWeekend;switch(h&&(c=2,u&&(c-=(l.includes(0)?1:0)+(l.includes(6)?1:0))),r){case"agenda":s=t._getAgendaEvents(i,a),o=1;break;case"day":s=t._getDayHours(i),o=1;break;case"month":case"week":s="month"===r?6:t.hourEnd-t.hourStart+1,o=7-(u?l.length:0)-c,a.additionalDays&&(o+=a.additionalDays);break;case"timelineDay":o=t._getDayHours(i),s=1;break;case"timelineWeek":{const e=t.firstDayOfWeek,n=a&&a.hideHours;let r=new Date(i);s=1,r.setDate(r.getDate()-r.getDay()+e);for(let e=0;e<7;e++)(!h||h&&[0,6].indexOf(r.getDay())<0)&&(!u||u&&l.indexOf(r.getDay())<0)&&(o+=n?1:t._getDayHours(r),d++),r.setDate(r.getDate()+1);break}case"timelineMonth":{const e=new Date(n);e.setDate(1),e.setMonth(e.getMonth()+1),e.setDate(0),o=e.getDate(),s=1;break}}return{horizontal:o,vertical:s,detail:d}}_getAgendaEvents(e,t){const n=this;if(!t){const e=n.view;t=n.views.find((t=>t.value&&t.value===e))||{}}e||(e=new Date(n.currentDate));const i=n.hideNonworkingWeekdays||t.hideNonworkingWeekdays,r=n.hideWeekend||t.hideWeekend,a=n.nonworkingDays,l=new Date(e),o=n.hourStart,s=n.hourEnd;l.setHours(0,0,0,0);const d=new Date(l);d.setDate(l.getDate()+6),d.setHours(23,59,59,999);const[c,u]=[l.getTime(),d.getTime()],h=n._getEventsBetween(c,u);let m={};if(!h||!h.length)return m;for(let e=0;e<h.length;e++){const t=h[e],n=t.dateStart,d=t.dateEnd,v=n.getTime(),g=d.getTime();if(!(v>=u||g<=c||t.hidden))for(let e=0;e<7;e++){const n=new Date(l);if(n.setDate(n.getDate()+e),i&&a.indexOf(n.getDay())>-1||r&&[0,6].indexOf(n.getDay())>-1)continue;n.setHours(o,0,0,0);const d=new Date(n);d.setHours(s,59,59,999);const c=n.getTime(),u=d.getTime();if(c<=g&&u>=v){let e=m[c];e||(m[c]=e=[]),e.push(t)}}}for(let e in m)m[e].sort(((e,t)=>e.dateStart.getTime()-t.dateStart.getTime()));return m}_getEventsBetween(e,t){const n=this;if(!e||!t)return[];e instanceof Date&&(e=e.getTime()),t instanceof Date&&(t=t.getTime());let i=n._eventsBetween;if(n._eventsBetween){if(i.timeStart===e&&i.timeEnd===t)return i.events}else i=n._eventsBetween={timeStart:e,timeEnd:t,events:[]};let r=[];const a=n._events,l=n._rRule,o=n.restrictedDates,s=n.restrictedHours,d={isMonthView:n.viewType.toLowerCase().indexOf("month")>-1,restrictedDates:n.restrictedDates,restrictedHours:n.restrictedHours,hourStart:n.hourStart,hourEnd:n.hourEnd,dateStart:new Date(e),dateEnd:new Date(t),rRule:l,targetEvents:r};for(let i=0;i<a.length;i++){const c=a[i],u=c.repeat,h=c.dateStart,m=c.dateEnd,v=h.getTime(),g=m.getTime();if(n._applyFiltering(c)){if(u&&l){const e=n._getEventRepeatOptions(c);if(e){d.event=c,d.repeatObj=u,d.options=e,d.eventTimeStart=v,d.eventTimeEnd=g,n._setRepeatingEvents(d);continue}}else if(n._isEventRestricted(c,o,s)||v>t||g<e)continue;r.push(c)}}return r.sort(((e,t)=>e.dateStart.getTime()-t.dateStart.getTime())),i.timeStart=e,i.timeEnd=t,i.events=r}_applyFiltering(e){const t=this;if(!t.filterable)return!0;const n=t.filter;if("function"==typeof n)return!!n(t._cloneObject(e));if(!Array.isArray(n))return!0;if(!n.length)return!0;for(let i=0;i<n.length;i++){const r=n[i];if(void 0===r.name)continue;const a=e[r.name],l=r.value;return"function"==typeof l?!!l(a):t._checkFilterMode(a+"",l+"")}}_checkFilterMode(e,t){switch(this.filterMode){case"startsWith":return 0===e.indexOf(t);case"startsWithIgnoreCase":return 0===e.toLowerCase().indexOf(t.toLowerCase());case"doesNotContain":return e.indexOf(t)<0;case"doesNotContainIgnoreCase":return e.toLowerCase().indexOf(t.toLowerCase())<0;case"contains":return e.indexOf(t)>-1;case"containsIgnoreCase":return e.toLowerCase().indexOf(t.toLowerCase())>-1;case"equals":return 0===e.localeCompare(t);case"equalsIgnoreCase":return 0===e.toLowerCase().localeCompare(t.toLowerCase());case"endsWith":return e.endsWith(t);case"endsWithIgnoreCase":return e.toLowerCase().endsWith(t.toLowerCase())}}_isEventRestricted(e,t,n){const i=this;if(!e)return!1;const r=e.dateStart,a=e.dateEnd,l=r.getTime(),o=a.getTime();let s;if(t||(t=i.restrictedDates),n||(n=i.restrictedHours),n.length){let e=Math.max(1,Math.min(23,Math.floor((a.getTime()-r.getTime())/36e5))),t=r.getHours();if(e>0)for(s=[];e>=0;)s.push(t),t=23===t?0:t+1,e--;if(s&&n.some((e=>s.includes(e))))return!0}for(let e=0;e<t.length;e++){const n=t[e],i=n.getTime();let r=new Date(n);if(r.setHours(23,59,59,999),r=r.getTime(),l<=r&&o>=i)return!0}if(i.restricted)for(let e=0;e<i.restricted.length;e++){const t=i.restricted[e];if(i._isDateRestricted(r,[t.date])){const e=r.getHours();for(let n=0;n<t.hours.length;n++){const i=t.hours[n];if(Array.isArray(i)){if(e>=i[0]&&e<=i[1])return!0}else if(e===i)return!0}}}if(i.available&&i.available.length){let t=!0;for(let n=0;n<i.available.length;n++){const a=i.available[n],l=i.resources.length>0?i.resources[0].value:null;if(!l||void 0===e[l]||l&&e[l]===a[l])if("string"==typeof a.start&&5===a.start.length&&a.start.indexOf(":")>=0){const e=a.start.split(":"),n=parseInt(e[0]),i=parseInt(e[1]),l=a.end.split(":"),o=parseInt(l[0]),s=parseInt(l[1]),d=new Date(r.getFullYear(),r.getMonth(),r.getDate(),n,i,0),c=new Date(r.getFullYear(),r.getMonth(),r.getDate(),o,s,0);d<=r&&r<=c&&(t=!1)}else if("string"==typeof a.start&&a.start.length<=2){const e=parseInt(a.start),n=parseInt(a.end),i=new Date(r.getFullYear(),r.getMonth(),r.getDate(),e,0,0),l=new Date(r.getFullYear(),r.getMonth(),r.getDate(),n,0,0);i<=r&&r<=l&&(t=!1)}else if(a.date){if(a.date.getFullYear()===r.getFullYear()&&a.date.getMonth()===r.getMonth()&&a.date.getDate()===r.getDate()){const e=r.getHours();if(a.hours)for(let n=0;n<a.hours.length;n++){const i=a.hours[n];Array.isArray(i)?e>=i[0]&&e<=i[1]&&(t=!1):e===i&&(t=!1)}else t=!1}}else if("number"==typeof a.start){const e=a.start,n=a.end,i=new Date(r.getFullYear(),r.getMonth(),r.getDate(),e,0,0),l=new Date(r.getFullYear(),r.getMonth(),r.getDate(),n,0,0);i<=r&&r<=l&&(t=!1)}else{const e=new Smart.Utilities.DateTime(a.start).toDate(),n=new Smart.Utilities.DateTime(a.end).toDate();e<=r&&r<=n&&(t=!1)}}return t}return!1}_isDateRestricted(e,t){const n=this;if(!e||!e.getTime||isNaN(e.getTime()))return!1;const i=e.getFullYear(),r=e.getMonth(),a=e.getDate();t||(t=n.restrictedDates);for(let e=0;e<t.length;e++){const n=t[e],l=n.getFullYear(),o=n.getMonth(),s=n.getDate();if(i===l&&r===o&&a===s)return!0}return!1}_isHourRestricted(e,t){const n=this;return e instanceof Date&&(e=e.getHours()),void 0!==e&&!isNaN(e)&&(t||(t=n.restrictedHours),t.includes(e))}_setRepeatingEvents(e){const t=this,n=e.isMonthView,i=e.hourStart,r=e.hourEnd,a=e.rRule,l=e.dateStart,o=e.dateEnd,s=e.restrictedDates,d=e.restrictedHours,c=l.getTime(),u=o.getTime(),h=e.event,m=e.options,v=e.repeatObj,g=e.eventTimeStart,f=e.eventTimeEnd,p=v.exceptions,w=e.targetEvents,y=h.dateStart,_=h.dateEnd;let b=l;y.getFullYear()===_.getFullYear()&&y.getMonth()===_.getMonth()&&y.getDate()===_.getDate()||(b=h.dateStart);let D=new a(m).between(new Date(Date.UTC(...t._getDateArgs(b))),new Date(Date.UTC(...t._getDateArgs(o))),!0);if(!D.length){const e=new a(m).before(new Date(Date.UTC(...t._getDateArgs(l))));e&&new Date(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes()).getTime()+f-g>=c&&D.push(e)}for(let e=0;e<D.length;e++){let a=D[e];a=new Date(a.getUTCFullYear(),a.getUTCMonth(),a.getUTCDate(),a.getUTCHours(),a.getUTCMinutes());let l,o=new Date(a),m=new Date(a.getTime()+f-g);if(!(t._isEventRestricted(h,s,d)||o.getTime()>u||m.getTime()<c)&&(p&&(l=p.find((e=>{const t=e.date;return h.allDay&&t.setHours(a.getHours(),a.getMinutes(),a.getSeconds(),a.getMilliseconds()),t.getTime()===a.getTime()}))),l&&(o=l.dateStart,m=l.dateEnd),o&&!isNaN(o.getTime())||(o=new Date(a)),m&&!isNaN(m.getTime())||(m=new Date(o.getTime()+f-g)),n||!(o.getHours()<i&&m.getHours()<i||o.getHours()>r&&m.getHours()>r))){if(l)l.dateStart&&!isNaN(l.dateStart.getTime())||(l.dateStart=o),l.dateEnd&&!isNaN(l.dateEnd.getTime())||(l.dateEnd=m),l.$={event:h};else if(l=t._cloneObject(h,!1,!0),l.dateStart=o,l.dateEnd=m,l.$={event:h},p){const e=l.dateStart.getTime(),t=l.dateEnd.getTime();for(let n=0;n<p.length;n++){const i=p[n],r=i.date.getTime();r>e&&r<=t&&(void 0===i.dateStart&&(i.dateStart=new Date(o)),void 0===i.dateEnd&&(i.dateEnd=new Date(m)),w.push(i))}}w.push(l)}}}_getEventRepeatOptions(e,t){const n=this,i=n._rRule;if(!e||!e.repeat||!i)return;const r=e.repeat,a=r.repeatFreq,l=a?i[a.toUpperCase()]:void 0;if(void 0===l)return;const o=r.repeatOn,s=r.repeatEnd;let d={freq:l,wkst:(n.firstDayOfWeek-1+7)%7,interval:r.repeatInterval||1};const c=n._getRepeatOnCondition(a,o);switch(a){case"weekly":d.byweekday=c.map((e=>(e-1+7)%7));break;case"monthly":d.bymonthday=c;break;case"yearly":d.bymonth=c.index+1,d.bymonthday=c.value}return s instanceof Date?d.until=new Date(Date.UTC(...n[t?"_getUTCDateArgs":"_getDateArgs"](s))):"number"!=typeof s||isNaN(s)||(d.count=s),d.dtstart=new Date(Date.UTC(...n[t?"_getUTCDateArgs":"_getDateArgs"](e.dateStart))),d}_getUTCDateArgs(e){if(!isNaN(new Date(e).getTime()))return[e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes()]}_getDateArgs(e){if(!isNaN(new Date(e).getTime()))return[e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes()]}_getRepeatOnCondition(e,t){if(!e||!t)return[];let n;if("weekly"===e){let e=[];Array.isArray(t)||(t=[t]);for(let i=0;i<t.length;i++)n=t[i],"string"==typeof n&&(n=isNaN(parseInt(n))?new Date(n):parseInt(n)),n instanceof Date&&!isNaN(n.getTime())?e.push(n.getDay()):e.push(Math.max(0,Math.min(6,parseInt(t[i])||0)));return e}if("monthly"===e)return Array.isArray(t)&&(t=t[0]),n=t,"string"==typeof n&&(n=isNaN(parseInt(n))?new Date(n):parseInt(n)),n=n instanceof Date&&!isNaN(n.getTime())?n.getDate():Math.max(0,Math.min(31,parseInt(t)||0)),n;if("yearly"===e){let e,i;if(Array.isArray(t)&&(t=t[0]),n=t,"string"==typeof n&&(n=isNaN(parseInt(n))?new Date(n):parseInt(n)),n instanceof Date&&!isNaN(n.getTime()))e=n.getMonth(),i=n.getDate();else{let n=t,r=t;"object"==typeof t&&(n=t.month,r=t.date),e=Math.max(0,Math.min(11,parseInt(n)||0)),i=Math.max(0,Math.min(31,parseInt(r)||0))}return{index:e,value:i}}}_getDayHours(e){const t=this,n=new Date(e||t.dateCurrent),i=n.getDate(),r=t.hourStart,a=t.hourEnd;let l=0;for(n.setHours(r,0,0,0);i===n.getDate()&&n.getHours()<=a;){l++;const e=n.getHours();n.setHours(n.getHours()+1,0,0,0),e===n.getHours()&&n.setHours(n.getHours()+2,0,0,0)}return l}_getDateString(e,t="horizontal",n){const i=this,r=i.locale,a=i.view,l=i.viewType,o=i.views.find((e=>e.value&&e.value===a)),s=l.indexOf("timeline")>-1,d=e.timeZone||i.timeZone;let c;if(e=e.timeZone&&e.timeZone===i.timeZone?e.date||e:new Smart.Utilities.DateTime(e.date||e).toDate(d),s){if("vertical"===t)return"";c="timelineMonth"===l||"timelineWeek"===l&&(n||o&&o.hideHours)?new Intl.DateTimeFormat(r,{day:i.dayFormat,weekday:i.weekdayFormat}).format(e):new Intl.DateTimeFormat(r,{hour:i.hourFormat,minute:i.minuteFormat}).format(e)}else if("horizontal"===t){if("day"===l)return"";"week"===l?c=new Intl.DateTimeFormat(r,{day:i.dayFormat,weekday:i.weekdayFormat}).format(e):"month"===l&&(c=new Intl.DateTimeFormat(r,{weekday:i.weekdayFormat}).format(e))}else{if("month"===l)return"";c="agenda"===l?new Intl.DateTimeFormat(r,{day:i.dayFormat,weekday:i.weekdayFormat}).format(e):new Intl.DateTimeFormat(r,{hour:i.hourFormat,minute:i.minuteFormat}).format(e)}return i.timelineHeaderFormatFunction?i.timelineHeaderFormatFunction(e,t,n,c):c}_setGroupContent(e){const t=this,n=e.$.cellObj;if(t.groupTemplate)t._applyTemplate("groupTemplate",e,n);else{const i=t.resources.find((e=>e.value===n.resource));if(!i)return void(e.innerHTML="");let r;n.group&&(r=n.label);let a=r||i.label;t.timelineHeaderGroupFormatFunction&&(a=t.timelineHeaderGroupFormatFunction(r,i,a)),e.innerHTML=`<div>${a}</div>`}}_applyTemplate(e,t,n){const i=this;let r,a=i[e];if("groupTemplate"===e){if(r=i.resources.find((e=>e.value===n.resource)),r){const e=n.group[n.resource];n=r.dataSource.find((t=>t.id===e))}n||(n=r)}i._templates||(i._templates={});const l=i._templates;if("function"==typeof a)return a.call(i,t,n),void delete l[e];if("string"==typeof a){const e=a;if(a=document.getElementById(a),!a){if(a=e,"object"==typeof n)for(let e in n)a=a.replaceAll("{{"+e+"}}",n[e]);else{const e=/{{\s*\w*\s*}}/gm;let t=[],i=a;if(e.test(i)){const n=i.match(e);t||(t=[]),n&&n.forEach((e=>{t.includes(e)||t.push(e)}))}if(t)for(let e=0;e<t.length;e++){const r=t[e];i=i.replace(r,"object"==typeof n?n[r.replace(/{{|}}/gm,"").trim()]||"":n)}a=i}return void(t.innerHTML=a)}}if(!("content"in document.createElement("template")))return i.error(i.localize("htmlTemplateNotSuported",{elementType:i.nodeName.toLowerCase()})),void delete l[e];if(null===a||!("content"in a))return i.error(i.localize("invalidTemplate",{elementType:i.nodeName.toLowerCase(),property:"groupTemplate"})),void delete l[e];let o=l[e];o||(o=l[e]={}),t.innerHTML="";const s=document.importNode(a.content,!0);if("cellTemplate"===e)n=new Intl.DateTimeFormat(i.locale,{day:i.dayFormat}).format(n);else if("eventCollectorTemplate"===e||"headerTemplate"===e||"footerTemplate"===e)return t.innerHTML="",void t.appendChild(s);const d=s.childNodes,c=o.bindings;let u;c&&(u=c);for(let e=0;e<d.length;e++){let i=d[e].outerHTML;if(i){if(!c){const e=/{{\s*\w*\s*}}/gm;if(e.test(i)){const t=i.match(e);u||(u=[]),t&&t.forEach((e=>{u.includes(e)||u.push(e)}))}}if(u)for(let e=0;e<u.length;e++){const t=u[e];i=i.replace(t,"object"==typeof n?n[t.replace(/{{|}}/gm,"").trim()]||"":n)}t.innerHTML+=i}}u&&(o.bindings=u)}_setCellContent(e,t){const n=this;t=new Date(t||n.dateCurrent),n.cellTemplate?n._applyTemplate("cellTemplate",e,t):"month"===n.viewType?1!==t.getDate()||e.hasAttribute("today")?e.innerHTML=`<div>${new Intl.DateTimeFormat(n.locale,{day:n.dayFormat}).format(t)}</div>`:e.innerHTML=`<div>${new Intl.DateTimeFormat(n.locale,{month:"short",day:n.dayFormat}).format(t)}</div>`:e.innerHTML=""}_setCurrentTimeIndicators(){const e=this;clearInterval(e._currentTimeIndicatorInterval),delete e._currentTimeIndicatorInterval,e._refreshIndicators(),(e.currentTimeIndicator||e.shadeUntilCurrentTime)&&(e._currentTimeIndicatorInterval=setInterval(e._refreshIndicators.bind(e),1e3*e.currentTimeIndicatorInterval))}_refreshIndicators(){const e=this,t=e.viewType,n=new Date,i=e.$.timelineCellsContainer,r=60/e._getCellsScaleCount(),a=t.toLowerCase().indexOf("month")>-1,l=i.querySelectorAll(".smart-scheduler-cell:not(.scale)");let o,s=[];for(let e=0;e<l.length;e++){const t=l[e],i=new Date(t.$.cellObj.time);if(t.$&&n.getFullYear()===i.getFullYear()&&n.getMonth()===i.getMonth()&&n.getDate()===i.getDate()){if(!a&&i.getHours()!==n.getHours()||i.getMinutes()+r<n.getMinutes()||i.getMinutes()>n.getMinutes())continue;s.push(t)}}if(s.length){const e=s[0].$.cellObj,t=new Date(e.time),i=e.scaleIndex||0;let l,d;a?(d=60*n.getHours()+n.getMinutes(),l=1440):(d=n.getMinutes(),l=t.getMinutes()+r),o={cells:s,minutes:d,max:l,scaleIndex:i}}e._refreshCurrentTimeIndicator(o),e._refreshCurrentTimeShader(o)}_refreshCurrentTimeIndicatorHeader(){const e=this,t=e.currentTimeIndicator,n=e.timeZone,i=new Date,r=i.getFullYear(),a=i.getMonth(),l=i.getDate(),o=i.getHours(),s=e.viewType.toLowerCase(),d=e=>{let t=new Date(e);for(let e=0;e<6;e++){if(t.getFullYear()===r&&t.getMonth()===a&&t.getDate()===l)return!0;t.setDate(t.getDate()+7)}},c=s.indexOf("agenda")>-1,u=s.indexOf("timeline")>-1,h=s.indexOf("month")>-1;function m(e,i){let s;const m=!c&&!h&&(i&&!u||!i&&u);for(let t=0;t<e.length;t++){const i=e[t];if(i.timeZone===n){s=i.children;break}}if(s)for(let e=0;e<s.length;e++){const n=s[e];if(!n.$||!n.$.cellObj)return;const i=n.$.cellObj.date;if(t){if(h&&!u){d(i)?n.setAttribute("current",""):n.removeAttribute("current");continue}if(i.getDate()===l&&(!m||i.getFullYear()===r&&i.getMonth()===a&&i.getHours()===o)){n.setAttribute("current","");continue}}n.removeAttribute("current")}}m(e.$.timelineHeaderHorizontalContent.querySelectorAll(".smart-scheduler-cells")),m(e.$.timelineHeaderVerticalContent.querySelectorAll(".smart-scheduler-cells"),!0)}_refreshCurrentTimeIndicator(e){const t=this,n=t.viewType,i=t.$.timelineIndicatorsContainer;let r=i.querySelector(".smart-scheduler-current-time");if(t._refreshCurrentTimeIndicatorHeader(),!t.currentTimeIndicator||"agenda"===n||!e)return r&&r.remove(),void(i.firstElementChild||(clearInterval(t._currentTimeIndicatorInterval),delete t._currentTimeIndicatorInterval));const[a,l,o,s]=[e.cells,e.minutes,e.max,e.scaleIndex],d=a.length,c=t._getCellsScaleCount();r||(r=document.createElement("div"),r.classList.add("smart-scheduler-current-time"),r.setAttribute("role","presentation"));const u=r.children;t._recycleContainerCells({fragment:r,cellsNeeded:d,className:"smart-scheduler-current-time-indicator"});for(let e=0;e<u.length;e++){const t=a[e],i=u[e],r=t.closest(".smart-scheduler-cell-container");let d;n.toLowerCase().indexOf("timeline")>-1?(d=parseFloat(r.style.width)/c*(s+1),i.style.width=t.style.width,i.style.height=t.style.height,i.style.left=parseFloat(r.style.left)+d*(l/o)+"px",i.style.top=t.style.top):(d=parseFloat(r.style.height)/c*(s+1),i.style.width=t.style.width,i.style.height=t.style.height,i.style.left=t.style.left,i.style.top=parseFloat(r.style.top)+d*(l/o)+"px"),i.setAttribute("aria-label","Current Time Indicator")}r.parentElement||i.appendChild(r)}_refreshCurrentTimeShader(e){const t=this,n=t.$.timelineIndicatorsContainer;let i=n.querySelector(".smart-scheduler-shader");if(!t.shadeUntilCurrentTime||"agenda"===t.viewType)return i&&i.remove(),void(t.currentTimeIndicator||(clearInterval(t._currentTimeIndicatorInterval),delete t._currentTimeIndicatorInterval));i||(i=document.createElement("div"),i.classList.add("smart-scheduler-shader"));const r=i.children;if(e)t._shadeUntilToday(i,e);else{const e=t._getCellShadeRangesByDate(),a=e.length;if(t._recycleContainerCells({fragment:i,cellsNeeded:a,className:"smart-scheduler-shade"}),!a&&(i.remove(),!n.firstElementChild))return clearInterval(t._currentTimeIndicatorInterval),void delete t._currentTimeIndicatorInterval;for(let n=0;n<a;n++){const i=e[n],a=i.hFrom,l=i.hTo,o=t._getFirstShadeCell(i.vFrom.$.cellObj,!0),s=t._getFirstShadeCell(i.vTo.$.cellObj,!0,!0),d=r[n];t._recycleContainerCells({fragment:d,cellsNeeded:1,className:"smart-scheduler-shade-section"});const c=d.children[0];c.style.width=parseFloat(l.style.left)+parseFloat(l.style.width)-parseFloat(a.style.left)+"px",c.style.height=parseFloat(s.style.top)+parseFloat(s.style.height)-parseFloat(o.style.top)+"px",c.style.left=a.style.left,c.style.top=o.style.top}}i.parentElement||n.insertBefore(i,n.firstElementChild)}_shadeUntilToday(e,t){const n=this;if(!t)return void(e.innerHTML="");const i=e.children,r=n.viewType,a=r.indexOf("month")>-1,l=n._getCellsScaleCount(),[o,s,d,c]=[t.cells,t.minutes,t.max,t.scaleIndex],u=o?o.length:1;n._recycleContainerCells({fragment:e,cellsNeeded:u,className:"smart-scheduler-shade"});for(let e=0;e<u;e++){const t=o[e],u=i[e],h=t.closest(".smart-scheduler-cell-container"),m=t.$.cellObj.horizontal,v=t.$.cellObj.vertical;let g;if(r.toLowerCase().indexOf("timeline")>-1){n._recycleContainerCells({fragment:u,cellsNeeded:1,className:"smart-scheduler-shade-section"});const e=u.children[0],i=n._getFirstShadeCell(m);g=parseFloat(h.style.width)/l*(c+1),e.style.width=parseFloat(h.style.left)-parseFloat(i.style.left)+g*(s/d)+"px",e.style.height=t.style.height,e.style.left=i.style.left,e.style.top=t.style.top}else{n._recycleContainerCells({fragment:u,cellsNeeded:a?3:2,className:"smart-scheduler-shade-section"});const e=u.children[0],i=u.children[1],r=n._getFirstShadeCell(m),o=n._getFirstShadeCell(v,!0),f=n._getFirstShadeCell(v,!0,!0);if(g=parseFloat(h.style.height)/l*(c+1),e.style.top=o.style.top,e.style.left=r.style.left,a){e.style.width=parseFloat(t.style.left)-parseFloat(r.style.left)+"px",e.style.height=parseFloat(h.style.top)-parseFloat(o.style.top)+parseFloat(h.style.height)+"px";const a=n._getFirstShadeCell(m,void 0,!0),l=u.children[2];i.style.width=parseFloat(a.style.left)+parseFloat(a.style.width)-parseFloat(r.style.left)-parseFloat(e.style.width)+"px",i.style.height=parseFloat(h.style.top)-parseFloat(o.style.top)+"px",i.style.top=o.style.top,i.style.left=parseFloat(r.style.left)+parseFloat(e.style.width)+"px",l.style.top=parseFloat(i.style.top)+parseFloat(i.style.height)+"px",l.style.left=i.style.left,l.style.width=t.style.width,l.style.height=g*(s/d)+"px"}else e.style.width=parseFloat(t.style.left)+parseFloat(t.style.width)-parseFloat(r.style.left)+"px",e.style.height=parseFloat(h.style.top)-parseFloat(o.style.top)+g*(s/d)+"px",i.style.top=parseFloat(e.style.top)+parseFloat(e.style.height)+"px",i.style.left=r.style.left,i.style.width=parseFloat(t.style.left)-parseFloat(r.style.left)+"px",i.style.height=parseFloat(f.style.top)+parseFloat(f.style.height)-parseFloat(i.style.top)+"px"}}}_getFirstShadeCell(e,t,n){const i=(t?this.$.timelineHeaderVerticalContent:this.$.timelineHeaderHorizontalContent).querySelectorAll(".smart-scheduler-view-time .smart-scheduler-cell"),r=e.group;if(!r)return n?i[i.length-1]:i[0];let a;for(let e=0;e<i.length;e++){const t=i[e],l=t.$.cellObj.group;if(l&&Object.keys(l).every((e=>l[e]===r[e]))&&(a=t,!n))return a}return a}_getCellShadeRangesByDate(){const e=this,t=e.viewType.indexOf("timeline")>-1,n=new Date,i=n.getFullYear(),r=n.getMonth(),a=n.getDate(),l=n.getHours(),o=e.$.timelineHeaderHorizontalContent.querySelectorAll(".smart-scheduler-view-time .smart-scheduler-cell"),s=e.$.timelineHeaderVerticalContent.querySelectorAll(".smart-scheduler-cell"),d=e=>{let t,i;for(let r=0;r<s.length;r++){if(i=s[r],!i.$)continue;const a=new Date(i.$.cellObj.date);a.setDate(e.getDate());const l=a.getTime()||0;if(!t&&l<=n.getTime()&&(t=i),t&&l>n.getTime())break}return t&&i?{from:t,to:i}:void 0},c=e=>e.getFullYear()===i&&e.getMonth()===r&&e.getDate()===a;let u,h,m,v=[];for(let e=0;e<o.length;e++){const i=o[e],r=i.$.cellObj.date;!u&&r.getTime()<=n.getTime()&&(u=i),!c(r)||t&&r.getHours()!==l||(m=d(r),h=m?i:h,h&&(m=d(h.$.cellObj.date),m&&v.push({hFrom:u,hTo:h,vFrom:m.from,vTo:m.to})),u=void 0),h=i}return u&&!v.length&&(h=o[o.length-1],(h.$?h.$.cellObj.date.getTime():0)>n.getTime()&&(h=u),m=h.$?d(h.$.cellObj.date):void 0,m&&v.push({hFrom:u,hTo:h,vFrom:m.from,vTo:m.to})),v}_refreshTimelineHeaderCells(e){const t=this;e||(e="horizontal",t._refreshTimelineHeaderCells("vertical")),"horizontal"===e&&t.$.timelineViewAllDay.offsetHeight&&(t.$.timelineViewAllDaylabel.innerHTML=`<div>${t.localize("allDay")}</div>`);const[n,i,r,a]="horizontal"===e?["scrollLeft","left","width",t.$.timelineHeaderHorizontalContent]:["scrollTop","top","height",t.$.timelineHeaderVerticalContent],l=t.$.timelineTimeZoneLabelContainer,o=t.timeZones,s=t.rightToLeft,d=a.querySelector(".smart-scheduler-view-time"),c=t.viewType,u=c.indexOf("timeline")>-1,h=d.children,m=t[n],v=t._timelineCells[e];let g,f;for(let e=0;e<v.length;e++){const t=v[e];if(m<=t[i]+t[r]){g=e;break}}(l.parentElement&&!u&&"agenda"!==c&&"vertical"===e||u&&"horizontal"===e)&&(f=l.children);for(let n=0;n<h.length;n++){const a=h[n],l=a.children;let d=g;if(f){const e=o.find((e=>e.id===a.timeZone));f[n]&&(f[n].innerHTML=e?`<div>${e.label}</div>`:"")}for(let n=0;n<l.length;n++){const o=l[n],c=v[d];if(!c)break;d++,o.$={cellObj:c},o.innerHTML=`<div>${c.noLabel?"":t._getDateString({date:new Date(c.date),timeZone:a.timeZone},e)}</div>`,o.style[r]=c[r]+"px","horizontal"===e?s?(o.style.left="",o.style.right=c[i]+"px"):(o.style.right="",o.style.left=c[i]+"px"):o.style[i]=c[i]+"px",c.weekend?o.setAttribute("weekend",""):o.removeAttribute("weekend"),c.nonworking?o.setAttribute("nonworking",""):o.removeAttribute("nonworking"),c.separator?o.setAttribute("separator",""):o.removeAttribute("separator"),c.groupSeparator?o.setAttribute("group-separator",""):o.removeAttribute("group-separator"),c.showLabel?o.setAttribute("show-label",c.showLabel):o.removeAttribute("show-label"),c.restricted?o.setAttribute("restricted",""):o.removeAttribute("restricted")}}t._refreshHeaderDetailCells(e),t._refreshHeaderGroupCells(e),a[n]="scrollLeft"===n?t._getScrollLeft(t[n]):t[n]}_refreshHeaderGroupCells(e){const t=this,n=t._timelineCells.groups,i=t.$.groupsContainer,r=t.groupByDate;let a,l,o,s,d;if(!i)return;if(d=i.querySelector(".smart-scheduler-view-header-groups-container"),s="horizontal"===e?t.$.timelineHeaderHorizontal:t.$.timelineHeaderVertical,!n||!d||!s.contains(d))return;[a,l,o]="vertical"===e?["top","height","scrollTop"]:["left","width","scrollLeft"];let c=d.children,u=document.createDocumentFragment();for(;c.length;)u.appendChild(d.firstElementChild);c=u.children;for(let i=0;i<c.length;i++){const o=c[i],s=n[i];t._refreshAdditionalHeaderCells({orientation:e,fragment:o,type:"groups",offset:a,size:l,cellsObj:s[r?"cellsByDate":"cells"],resource:s.resource})}d.appendChild(u),t.$.groupsContainer.querySelector(".smart-scheduler-view-groups-content")[o]="scrollLeft"===o?t._getScrollLeft(t[o]):t[o]}_refreshHeaderDetailCells(e,t){const n=this,i=n._timelineCells.details;let r,a,l,o;if(!i||"horizontal"!==e||"timelineWeek"!==n.viewType)return;if(l=n.$.timelineHeaderHorizontalContent,o=l.querySelector(".smart-scheduler-view-details"),!o)return;[r,a]=["left","width"];let s=o.children,d=document.createDocumentFragment();for(;s.length;)d.appendChild(o.firstElementChild);n._refreshAdditionalHeaderCells({orientation:e,fragment:d,type:"details",offset:r,size:a,cellsObj:i,refreshContentOnly:t}),o.appendChild(d)}_refreshAdditionalHeaderCells(e){const t=this,n="agenda"===t.viewType,i=e.orientation,r=e.fragment,[a,l,o,s,d]=[e.type,e.offset,e.size,e.cellsObj,e.resource],c=t._getFirstCellObjInView({orientation:i,type:a,resource:d});if(!c)return;t._recycleContainerCells({fragment:r,cellsNeeded:t._getTimelineVisibleCellsCount({orientation:i,type:a,resource:d})});const u=Array.from(r.children),h=s.indexOf(c),m=t.rightToLeft,v="top"===l?l:"left";for(let e=0;e<u.length;e++){const r=u[e],d=s[h+e];if(r.$={cellObj:d},"groups"===a){if(!d[o]&&n){r.remove();continue}t._setGroupContent(r)}else{const e=d.date;r.innerHTML=`<div>${d.noLabel?"":t._getDateString({date:new Date(e)},i,!0)}</div>`}if(d.groupSeparator?r.setAttribute("group-separator",""):r.removeAttribute("group-separator"),d.separator?r.setAttribute("separator",""):r.removeAttribute("separator"),d.group){const e=d.group;for(const t in e)r.setAttribute(t,e[t]||"")}r.style.top=r.style.left=r.style.width=r.style.height=null,r.style[o]=d[o]+"px","left"===v?m?(r.style.left="",r.style.right=d[l]+"px"):(r.style.right="",r.style.left=d[l]+"px"):(r.style.left="",r.style.right="",r.style[v]=d[l]+"px")}}_createWindow(e){const t=this,n=e?e+"SchedulerWindow":"schedulerWindow";if(t.$[n])return t.$[n];const i=document.createElement("smart-window");return i.classList.add("smart-scheduler-window"),e?(i.classList.add(e),i.id=t.id+"ConfirmWindow"):i.id=t.id+"Window",i.setAttribute("smart-id",n),t.$[n]=i,t["$"+n]=Smart.Utilities.Extend(i),i.rightToLeft=t.rightToLeft,i.theme=t.theme,i.animation=t.animation,i.disableSnap=!0,i.headerButtons=["close"],i}_openWindow(e,t,n){const i=this;if(!e&&!(e=i._createEventFromSelection()))return;if([i.$.schedulerWindow,i.$.confirmSchedulerWindow].some((e=>e&&e.opened))||i.disableWindowEditor)return;const r=t?"confirm":"";function a(){function t(){i._positionWindow(),l.opened?(l.bringToFront(),l._handleActiveState(),l._onOpenCallback&&l._onOpenCallback()):l.open()}if(i.windowCustomizationFunction?i.windowCustomizationFunction(l,r,i._cloneObject(e)):(i._setPopupWindowTemplate("header",r,n),i._setPopupWindowTemplate("footer",r,n),i._setPopupWindowTemplate("content",r,n)),!l.opened){const e=i["$"+(r?r+"SchedulerWindow":"schedulerWindow")];e.unlisten("transitionend"),e.unlisten("open"),e.unlisten("close"),e.unlisten("closing"),e.unlisten("click"),e.unlisten("change"),e.unlisten("keydown"),r||(l._onOpenCallback=()=>{((l.shadowRoot||l).querySelector(".smart-input")||l).focus({preventScroll:!0})}),l.hasAnimation&&e.listen("transitionend",i._windowTransitionendHandler.bind(i)),e.listen("open",i._windowOpenHandler.bind(i)),e.listen("close",i._windowCloseHandler.bind(i)),e.listen("closing",i._windowClosingHandler.bind(i)),e.listen("click",i._windowClickHandler.bind(i)),e.listen("change",i._windowChangeHandler.bind(i)),e.listen("keydown",i._windowKeyDownHandler.bind(i))}l.shadowRoot?(l.importStyle(Smart.Utilities.Core.getScriptLocation()+Smart.StyleBaseUrl.replace("/scoped/","/smart.textbox.css")),i._onShadowDomLoaded(l,"smart.window.css",t)):t();const a=(i.getAttribute("aria-owns")||"")+" "+l.id;i.setAttribute("aria-owns",a.trim())}if(!e)return;const l=i._createWindow(r);i.$.fireEvent("editDialogOpening",{target:l,type:r,item:i._cloneObject(e)}).defaultPrevented||(l._target={event:e,originalTarget:t,windowType:n},l.parentElement||i.getShadowRootOrBody().appendChild(l),l.isCompleted?a():l.whenReady((()=>a())))}_positionWindow(){const e=this,t=e.getShadowRootOrBody(),n=[e.$.schedulerWindow,e.$.confirmSchedulerWindow];for(let i=0;i<n.length;i++){const r=n[i];if(!r||!t.contains(r))continue;const a=e.getBoundingClientRect();if(r.opened||(r.style.left=r.style.top=""),r.querySelector(".smart-scheduler-window-repeat")){const e=r.offsetWidth;!r.hasAttribute("horizontal")&&2*e<=a.width?r.setAttribute("horizontal",""):r.hasAttribute("horizontal")&&e>a.width&&r.removeAttribute("horizontal")}else r.removeAttribute("horizontal");e._isMobile?(r.setAttribute("mobile",""),r.style.left=a.left+window.pageXOffset+"px",r.style.top=a.top+window.pageYOffset+"px",r.style.width=a.width+"px",r.style.height=a.height+"px"):(r.style.left=Math.max(a.left+window.pageXOffset,a.left+window.pageXOffset+a.width/2-r.offsetWidth/2)+"px",r.style.top=Math.max(a.top+window.pageYOffset,a.top+window.pageYOffset+a.height/2-r.offsetHeight/2)+"px")}}_windowTransitionendHandler(e){const t=this,n=e.target;if(!n.classList.contains("smart-scheduler-window"))return;let i,r;n.classList.contains("confirm")?(i=t.$.confirmSchedulerWindow,r=t.$confirmSchedulerWindow):(i=t.$.schedulerWindow,r=t.$schedulerWindow),i.opened||"visibility"!==e.propertyName||(r.unlisten("transitionend"),i.remove())}_windowOpenHandler(e){const t=this,n=e.target;if(!n.classList.contains("smart-scheduler-window"))return;const i=n.classList.contains("confirm")?t.$confirmSchedulerWindow:t.$schedulerWindow,r=n._target.event;i&&(t._handleModal(!0),n===t.$.schedulerWindow?t.$.fireEvent("editDialogOpen",{target:e.target,editors:t._windowEditors,item:t._cloneObject(r)}):t.$.fireEvent("editDialogOpen",{target:e.target,item:t._cloneObject(r)}),i.unlisten("open"))}_windowClosingHandler(e){const t=this,n=e.target;if(!n.classList.contains("smart-scheduler-window"))return;const i=n.classList.contains("confirm")?t.$confirmSchedulerWindow:t.$schedulerWindow;if(i){const r={target:e.target,item:t._cloneObject(e.target._target.event)};if(n===t.$.schedulerWindow&&(r.editors=t._windowEditors),t.$.fireEvent("editDialogClosing",r).defaultPrevented)return void e.preventDefault();if(i.unlisten(e.type),t.hasAttribute("aria-owns")){const e=t.getAttribute("aria-owns").replace(i.id,"").trim();e?t.setAttribute("aria-owns",e):t.removeAttribute("aria-owns")}}}_windowCloseHandler(e){const t=this,n=e.target;if(!n.classList.contains("smart-scheduler-window"))return;const i=n.classList.contains("confirm")?t.$confirmSchedulerWindow:t.$schedulerWindow;if(i){const r=e.target._target.event;t._handleModal(),n===t.$.schedulerWindow?t.$.fireEvent("editDialogClose",{target:e.target,editors:t._windowEditors,item:t._cloneObject(r)}):t.$.fireEvent("editDialogClose",{target:e.target,item:t._cloneObject(r)}),i.unlisten("close"),i.unlisten("click"),i.unlisten("keydown"),t.hasAttribute("aria-owns")&&t.removeAttribute("aria-owns"),t.hasAnimation||i.remove();const a=t._getEventCell(n._target.originalTarget||r);(a||t.$.timeline).focus({preventScroll:!0})}}_getEventCell(e){if(e instanceof HTMLElement&&(e=e.$.event),!e)return;const t=this.$.timelineEventsContainer.children;for(let n=0;n<t.length;n++){const i=t[n],r=i.$?i.$.event:void 0;if(!r)continue;const a=r.$?r.$.event:void 0;if(r===e||a&&(a===e||e.$&&a===e.$.event))return i}}_windowChangeHandler(e){const t=this,n=e.target,i=n.closest(".smart-scheduler-window.confirm")?t.$.confirmSchedulerWindow:t.$.schedulerWindow;if(e.stopPropagation(),i!==t.$.schedulerWindow)return;const r=n.closest(".smart-scheduler-window-editor"),a=r?r.getAttribute("type"):void 0;if(a)if(a.indexOf("repeatEnd")>-1){const e=n.closest(".smart-scheduler-window-editor[multiple]");if(e){const t=e.children;for(let e=0;e<t.length;e++){const i=t[e],r=i.querySelector("[event-editor]");r&&(r.disabled=!i.contains(n))}}}else if(t._windowEditors&&n.hasAttribute("event-editor"))if("allDay"!==a)if("repeat"!==a){if("repeatFreq"===a)return t._setPopupWindowEditor(t._windowEditors.repeatOn),void t._setPopupWindowEditor(t._windowEditors.repeatInterval);"dateStart"!==a&&"dateEnd"!==a?"resources"!==a||t._setResourceDataEditor(t._windowEditors.resourceData):t._handleEditorDateValidation(n)}else i._target.event&&(t._createWindowEditor("repeat"),t._positionWindow());else t._handleEditorAllDay(n,i)}_windowKeyDownHandler(e){const t=this,n=e.target.closest(".smart-scheduler-window.confirm")?t.$.confirmSchedulerWindow:t.$.schedulerWindow;if(e.stopPropagation(),n!==t.$.schedulerWindow||"Enter"!==e.key)return;const i=n.getRootNode().activeElement,r=t._windowEditors,a=n._target.event;a&&r&&r.label&&r.label.contains(i)&&(t._updateEventViaWindow(a,r),n.close(),delete n._target)}_handleEditorDateValidation(e){const t=this,n=t._windowEditors.dateStart,i=t._windowEditors.dateEnd,r=t._windowEditors.allDay?t._windowEditors.allDay.querySelector("[event-editor]"):void 0;if(!n||!i)return;const a=n.querySelector("[event-editor]"),l=i.querySelector("[event-editor]"),o={dateStart:a.value.toDate(),dateEnd:l.value.toDate(),allDay:!!r&&r.checked};e===a?(o.type="end",l.value=t._getValidDate(o)):e===l&&(o.type="start",a.value=t._getValidDate(o))}_handleEditorAllDay(e){const t=this,n=t._windowEditors.dateStart,i=t._windowEditors.dateEnd;if(!n||!i)return;const r=n.querySelector("[event-editor]"),a=i.querySelector("[event-editor]"),l=e.checked;let o=r.value.toDate(),s=a.value.toDate();if(l){const e={dateStart:o,dateEnd:s,allDay:l,type:"start"};r.formatString="yyyy-MMM-dd",a.formatString="yyyy-MMM-dd",o.setHours(t.hourStart,0,0,0),s.setHours(t.hourEnd,0,0,0),r.value=t._getValidDate(e),e.type="end",a.value=t._getValidDate(e)}else{const e=t.hourStart,n=t.$.schedulerWindow;n&&n._target?(o=n._target.event.dateStart,s=n._target.event.dateEnd):(s=new Date(o),o.setHours(e,0,0,0),s.setHours(e,60/t._getCellsScaleCount(),0,0)),r.value=o,a.value=s,r.formatString="yyyy-MMM-dd HH:mm",a.formatString="yyyy-MMM-dd HH:mm"}}_windowClickHandler(e){const t=this;let n=(e.originalEvent||e).target;n.shadowRoot&&(n=(e.originalEvent||e).composedPath()[0]);const i=n.closest(".smart-scheduler-window.confirm")?t.$.confirmSchedulerWindow:t.$.schedulerWindow,r=n.closest(".smart-scheduler-window-button"),a=t._windowEditors,l=i._target.event,o=i._target.windowType;if(i&&r)if(r.classList.contains("ok")&&a?t._updateEventViaWindow(l,a):r.classList.contains("delete")&&t._deleteEventViaWindow(l),i.close(),delete i._target,r.classList.contains("edit-event")){if(l.date||(l.date=new Date(l.dateStart)),delete l.repeat,"deleteConfirm"===o)return l.hidden=!0,void t._updateEventViaWindow(l);t._openWindow(l)}else if(r.classList.contains("edit-series")&&l.$){if("deleteConfirm"===o)return delete l.$.event.repeat,void t._updateEventViaWindow(l);t._openWindow(l.$.event)}}_deleteEventViaWindow(e){const t=this,n=t._events.indexOf(e),i=e.$?e.$.event:void 0;if(i){const n=i.repeat?i.repeat.exceptions:void 0,r=n?n.indexOf(e):void 0;r>-1&&(n.splice(r,1),t._refreshTimelineEvents())}else if(n>-1){const i=t._cloneObject(e);if(t.$.fireEvent("itemChanging",{type:"removing",item:i}).defaultPrevented)return;t._events.splice(n,1),t._refreshTimelineEvents(),t._updateUndoRedo(t._cloneObject(e),void 0,"itemRemove"),t.$.fireEvent("itemRemove",{item:i}),t.$.fireEvent("itemChange",{type:"remove",item:i})}}_updateEventViaWindow(e,t){const n=this,i=n._events.indexOf(e),r=e.$?e.$.event:void 0,a=i<0;if(!a&&n.$.fireEvent("itemChanging",{type:"updating",item:n._cloneObject(e)}).defaultPrevented)return;if(a&&!r&&n.$.fireEvent("itemChanging",{type:"inserting",item:n._cloneObject(e)}).defaultPrevented)return;let l,o="Update";if(t&&n._updateEventSettings(e,t),a)if(r){if(r.repeat){const t=r.repeat;t.exceptions||(t.exceptions=[]);const i=t.exceptions;delete t.repeat,i.indexOf(e)<0&&t.exceptions.push(e),l=n._cloneObject(r)}}else o="Insert",l=n._cloneObject(e),n._events.push(e),n._updateUndoRedo(void 0,l,"itemInsert");else l=n._cloneObject(e);n.$.fireEvent("item"+o,{item:l}),n.$.fireEvent("itemChange",{type:o.toLowerCase(),item:l}),n._validateEventDateRange(e),n._refreshTimelineEvents()}_updateEventSettings(e,t){const n=this,i=Object.keys(t);for(let r=0;r<i.length;r++){const a=i[r],l=t[a].querySelectorAll("[event-editor]"),o=l[0];if(o)switch(a){case"allDay":e[a]=o.checked,o.checked&&(e.dateStart.setHours(0,0,0,0),e.dateEnd.setHours(23,59,59,999),e.dateEnd=n._getValidDate({dateStart:e.dateStart,dateEnd:e.dateEnd,allDay:!0,type:"end"}));break;case"dateEnd":case"dateStart":{const t=o.value.toDate();let i,r;"dateStart"===a?(i=t,r=e.dateEnd):(i=e.dateStart,r=t),r=n._getValidDate({dateStart:i,dateEnd:r,type:"end"}),n._isEventRestricted({dateStart:i,dateEnd:r})||(e.dateStart=i,e.dateEnd=r);break}case"conference":e[a]=o.value;break;case"description":case"label":e[a]=o.value;break;case"exceptions":e.repeat&&o.checked&&delete e.repeat.exceptions;break;case"notifications":o.value.length?e.notifications=o.value.slice(0):delete e.notifications;break;case"hidden":e.$&&e.$.event&&(e[a]=o.checked);break;case"backgroundColor":e[a]=o.value,e[a]||delete e[a];break;case"resources":n._updateEventResources(e,t,o);break;case"resoruceData":break;case"status":{const t=n.statuses[o.selectedIndex];t&&t.value?e[a]=t.value:delete e[a];break}default:n._updateEventRepeating(e,t,a,l)}}}_updateEventResources(e,t,n){const i=this.resources;if(!n.value)return void i.forEach((t=>delete e[t.value]));const r=t.resourceData.querySelectorAll(".smart-scheduler-window-editor[resource-type]");let a,l=[];for(let t=0;t<r.length;t++){const n=r[t],o=n.querySelector("[event-editor]"),s=n.getAttribute("resource-type");if(!o||o.value&&o.selectedIndex<0){l.push(s);continue}const d=i.find((e=>e.value===s));if(d){const t=d.dataSource[o.selectedIndex];a=!0,t?(e[s]=t.id,l.push(s)):delete e[s]}}a&&i.forEach((t=>{l.indexOf(t.value)<0&&delete e[t.value]}))}_updateEventRepeating(e,t,n,i){const r=i[0];if("repeat"===n)r.checked?e.repeat=e.repeat||{}:delete e.repeat;else{if(n.toLowerCase().indexOf("repeat")<0||!e.repeat)return;"object"!=typeof e.repeat&&(e.repeat={});const a=e.repeat;switch(n){case"repeatEnd":case"repeatEndAfter":case"repeatEndOn":{const e=t[n].querySelector(".smart-radio-button");if(e&&e.checked){const e=r.value;a.repeatEnd="repeatEndOn"===n?e.toDate():parseInt(e)}break}case"repeatFreq":a[n]=r.value.toLowerCase();break;case"repeatInterval":a[n]=parseInt(r.value);break;case"repeatOn":switch(a.repeatFreq){case"weekly":a[n]=r.selectedValues;break;case"monthly":a[n]=r.value;break;case"yearly":{const e=i[1]?parseInt(i[1].value):0;a[n]={month:r.selectedIndex,date:e};break}}}}}_updateUndoRedo(e,t,n){const i=this;if(!t&&!e)return void delete i._undoRedoHistory;let r=i._undoRedoHistory;if(r||(r=i._undoRedoHistory={currentStep:1,steps:[]}),n){const a=r.currentStep;a!==r.steps.length&&(r.steps=a<1?[]:r.steps.slice(0,a)),r.steps.length===i.undoRedoSteps&&r.steps.shift(),r.steps.push({oldValue:e,newValue:t,action:n,timeStamp:Date.now()})}r.currentStep=Math.max(1,r.steps.length)}_isUndoPossible(){const e=this._undoRedoHistory;if(e)return e.steps.length&&e.currentStep>0}_isRedoPossible(){const e=this._undoRedoHistory;if(!e)return;const t=e.steps;return t.length&&e.currentStep<t.length}_handleUndoRedo(e="undo",t){const n=this,i=n._undoRedoHistory;if(!i)return;const r=i.steps,a="undo"===e?0:1,l=r[(isNaN(t)?i.currentStep+a:t)-1];if(l){const t=n._events;let o,s,d;switch("undo"===e?l.newValue&&!l.oldValue?(s="delete",o=l.newValue):!l.newValue&&l.oldValue?(s="insert",o=l.oldValue):l.newValue&&l.oldValue&&(s="update",o=l.oldValue):l.newValue&&!l.oldValue?(s="insert",o=l.newValue):!l.newValue&&l.oldValue?(s="delete",o=l.oldValue):l.newValue&&l.oldValue&&(s="update",o=l.newValue),s){case"insert":d=o,t.push(d);break;case"delete":d=n._containsEvent(o),d&&t.splice(t.indexOf(d),1);break;case"update":if(d=n._containsEvent(l.newValue),d){for(let e in d)delete d[e];const e=n._cloneObject(o);for(let t in e)d[t]=e[t]}}if(d)return i.currentStep=Math.max(0,r.indexOf(l)+a),n.$.tooltip.close(),n.closeWindow(),n._refreshTimelineEvents(),n.$.fireEvent(l.action,{operation:e,eventObj:n._cloneObject(d),itemDateRange:{dateStart:new Date(o.dateStart),dateEnd:new Date(o.dateEnd)}}),n.unfocusable||n.$.timeline.focus({preventScroll:!0}),!0}}_getValidDate(e){const[t,n,i,r]=[e.dateStart,e.dateEnd,e.type,e.allDay];let a=new Date(t),l=new Date(n);if(isNaN(a)||isNaN(l)||n.getTime()>t.getTime())return"start"===i?a:l;for("start"===i?a=new Date(l):l=new Date(a);a.getTime()>l.getTime();){const e=a.getTime();"start"===i?(a.setHours(a.getHours()-1),a.getTime()===e&&a.setHours(a.getHours()-2)):(l.setHours(l.getHours()+1),l.getTime()===e&&l.setHours(l.getHours()+2))}return r&&a.getFullYear()===l.getFullYear()&&a.getMonth()===l.getMonth()&&a.getDate()===l.getDate()&&(l.setHours(0,0,0,0),l.setDate(l.getDate()+1)),"start"===i?a:l}_handleModal(e){const t=this;let n=(t.shadowRoot||t).querySelector(".smart-scheduler-window-modal");e?(n||(n=document.createElement("div"),n.classList.add("smart-scheduler-window-modal")),n.parentElement||(t.$.container.appendChild(n),t.setAttribute("modal",""))):n&&n.parentElement&&(n.parentElement.removeChild(n),t.removeAttribute("modal"))}_onShadowDomLoaded(e,t,n){requestAnimationFrame((function i(){const r=(e.shadowRoot||e.getRootNode()).querySelectorAll("link");for(let e=0;e<r.length;e++)if(-1!==r[e].href.indexOf(t))return void n();requestAnimationFrame(i)}))}_setPopupWindowTemplate(e,t,n){const i=this,r=i.$[t?t+"SchedulerWindow":"schedulerWindow"];if(!r)return;if("content"===e)return void i._setWindowContent(t,n);if(r[e+"Template"]||(r[e+"Template"]=i._createWindowTemplate(e,t)),t)return void i._setWindowTypeSection(e,t,n);const a=r._target.event,l=a.$&&a.$.event,o=i._events.indexOf(a)<0&&!l;let s;if(l&&l.repeat.exceptions&&(s=l.repeat.exceptions.indexOf(a)>-1),"header"===e){const e=(r.shadowRoot||r).querySelector(".smart-scheduler-window-label");a&&e&&(e.innerHTML=o?i.localize("newEvent"):l&&!s?i.localize("eventException"):a.label)}else if("footer"===e){const e=(r.shadowRoot||r).querySelectorAll(".smart-scheduler-window-button");for(let t=0;t<e.length;t++){const n=e[t];n.innerHTML='<span class="smart-icon"></span>',n.theme=i.theme,n.rightToLeft=i.rightToLeft,n.animation=i.animation,n.classList.contains("ok")?(n.innerHTML+=i.localize("ok"),n.setAttribute("aria-label","ok")):n.classList.contains("cancel")?(n.innerHTML+=i.localize("cancel"),n.setAttribute("aria-label","cancel")):n.classList.contains("delete")&&(n.innerHTML+=i.localize("delete"),n.setAttribute("aria-label","delete"),n.classList[o||l&&!s?"add":"remove"]("smart-hidden"));const r=n.querySelector(".smart-ripple");r&&r.parentElement.removeChild(r)}}}_setWindowTypeSection(e,t,n){const i=this,r=i.$[t?t+"SchedulerWindow":"schedulerWindow"];if(t&&r)if("confirm"!==t);else if("header"===e){const e=(r.shadowRoot||r).querySelector(".smart-scheduler-window-label");e&&(e.innerHTML=i.localize(n?n+"Label":"repeatConfirmLabel")||"")}else if("footer"===e){const e=(r.shadowRoot||r).querySelectorAll(".smart-scheduler-window-button");for(let t=0;t<e.length;t++){const r=e[t];r.theme=i.theme,r.rightToLeft=i.rightToLeft,r.animation=i.animation,r.classList.contains("edit-event")?(r.innerHTML=i.localize(n?n+"Event":"editEvent"),r.setAttribute("aria-label","edit-event")):r.classList.contains("edit-series")&&(r.innerHTML=i.localize(n?n+"Series":"editSeries"),r.setAttribute("aria-label","edit-series"));const a=r.querySelector(".smart-ripple");a&&a.parentElement.removeChild(a)}}}_setWindowContent(e,t){const n=this,i=n.$[e?e+"SchedulerWindow":"schedulerWindow"];if(e){let r=i.querySelector(".smart-scheduler-confirm-label");if(!i.content||i.content.innerHTML&&!r)return;return r||(r=document.createElement("label"),r.classList.add("smart-scheduler-confirm-label"),i.appendChild(r)),void("confirm"===e&&r&&(r.innerHTML=n.localize(t||"repeatConfirm")||""))}const r=i._target.event,a=[].slice.call(i.getElementsByClassName("smart-scheduler-window-editor"));i.innerHTML&&!a.length||r&&(n._createWindowEditor(),n._createWindowEditor("repeat"),r.id&&i.setAttribute("aria-controls",r.id))}_createWindowEditor(e="main"){const t=this,n=t.$.schedulerWindow,i=n._target.event,r=t._windowEditors;let a=n.querySelector(".smart-scheduler-window-content-wrapper"),l=n.querySelector(`.smart-scheduler-window-${e}`),o=i.repeat,s=i.$&&i.$.event;if(r&&r.repeat){const e=r.repeat.querySelector("[event-editor]");e&&(o=e.checked)}if(a||(a=document.createElement("div"),a.classList.add("smart-scheduler-window-content-wrapper"),n.appendChild(a)),"repeat"===e&&(!o||s))return void(l&&l.remove());if(!l){if(r){const t="main"===e?r.label:r.repeatFreq;t&&(l=t.closest(`.smart-scheduler-window-${e}`))}l||(l=document.createElement("div"),l.classList.add(`smart-scheduler-window-${e}`),l.innerHTML=t._getWindowEditorTemplate(e))}a.contains(l)||a.appendChild(l);const d=l.querySelectorAll(".smart-scheduler-window-editor[type]");for(let e=0;e<d.length;e++)t._setPopupWindowEditor(d[e])}_getWindowEditorTemplate(e){return e&&"main"!==e?"repeat"===e?'\n                <div class="smart-scheduler-window-editor" type="repeatFreq">\n                    <label></label>\n                    <smart-input readonly event-editor drop-down-button-position="right"></smart-input>\n                </div>\n                <div class="smart-scheduler-window-editor" type="repeatInterval">\n                    <label></label>\n                    <smart-number-input min="1" event-editor></smart-number-input>\n                </div>\n                <div class="smart-scheduler-window-editor" type="repeatOn" multiple>\n                    <label></label>\n                </div>\n                <div class="smart-scheduler-window-editor" multiple>\n                    <div class="smart-scheduler-window-editor" type="repeatEnd">\n                        <label></label>\n                        <smart-radio-button group-name="repeat"></smart-radio-button>\n                    </div>\n                    <div class="smart-scheduler-window-editor" type="repeatEndOn">\n                        <smart-radio-button group-name="repeat"></smart-radio-button>\n                        <smart-date-time-picker calendar-button drop-down-append-to="body" event-editor\n                        enable-mouse-wheel-action drop-down-display-mode="auto"></smart-date-time-picker>\n                    </div>\n                    <div class="smart-scheduler-window-editor" type="repeatEndAfter">\n                        <smart-radio-button group-name="repeat"></smart-radio-button>\n                        <smart-number-input min="1" event-editor></smart-number-input>\n                        <label></label>\n                    </div>\n                </div>\n                <div class="smart-scheduler-window-editor smart-hidden" type="exceptions">\n                    <label></label>\n                    <smart-check-box event-editor></smart-check-box>\n                </div>':void 0:'\n            <div class="smart-scheduler-window-editor" type="label">\n                <label></label>\n                <smart-input event-editor></smart-input>\n            </div>\n            <div class="smart-scheduler-window-editor" multiple>\n                <div class="smart-scheduler-window-editor" type="dateStart">\n                    <label></label>\n                    <smart-date-time-picker calendar-button drop-down-append-to="body" event-editor\n                    enable-mouse-wheel-action drop-down-display-mode="auto"></smart-date-time-picker>\n                </div>\n                <div class="smart-scheduler-window-editor" type="dateEnd">\n                    <label></label>\n                    <smart-date-time-picker calendar-button drop-down-append-to="body" event-editor\n                        enable-mouse-wheel-action drop-down-display-mode="auto"></smart-date-time-picker>\n                </div>\n            </div>\n            <div class="smart-scheduler-window-editor" type="description">\n                <label></label>\n                <smart-text-area event-editor></smart-text-area>\n            </div>\n            <div class="smart-scheduler-window-editor" multiple>\n                <div class="smart-scheduler-window-editor" type="allDay">\n                    <label></label>\n                    <smart-switch-button event-editor></smart-switch-button>\n                </div>\n                <div class="smart-scheduler-window-editor" type="hidden">\n                    <label></label>\n                    <smart-switch-button event-editor></smart-switch-button>\n                </div>\n                <div class="smart-scheduler-window-editor" type="repeat">\n                    <label></label>\n                    <smart-switch-button event-editor></smart-switch-button>\n                </div>\n            </div>\n            <div class="smart-scheduler-window-editor" type="conference">\n                <label></label>\n                <smart-input event-editor></smart-input>\n                <div style="color: var(--smart-error);" class="smart-hidden smart-invalid-conference-link-label"></div>\n                <div class="smart-hidden" class="smart-conference-link"></div>\n            </div>\n            <div class="smart-scheduler-window-editor" type="notifications">\n                <label></label>\n                <smart-notification-panel event-editor></smart-notification-panel>\n            </div>\n            <div class="smart-scheduler-window-editor" multiple>\n                <div class="smart-scheduler-window-editor" type="backgroundColor">\n                    <label></label>\n                    <smart-color-input event-editor></smart-color-input>\n                </div>\n                <div class="smart-scheduler-window-editor" type="status">\n                    <label></label>\n                    <smart-input event-editor></smart-input>\n                </div>\n            </div>\n            <div class="smart-scheduler-window-editor smart-hidden" type="resources">\n                <label></label>\n                <smart-check-input event-editor disabled></smart-check-input>\n            </div>\n            <div class="smart-scheduler-window-editor smart-hidden" multiple type="resourceData"></div>\n            </div>'}_setPopupWindowEditor(e){const t=this,n=e.getAttribute("type"),i=e.querySelector("label"),r=t.$.schedulerWindow._target.event,a=r.$&&r.$.event;let l=e.querySelector("[event-editor]");if(!r)return;t._windowEditors||(t._windowEditors={});const o=t._windowEditors,s=t.rightToLeft;if(o[n]||(o[n]=e),i&&(i.id=t.id+n+"Label",i.innerHTML=t.localize(n)),"label"===n||"description"===n)l.value=void 0!==r[n]?r[n]+"":"";else if(n.indexOf("date")>-1){const e=!!r.allDay;l.formatString=e?"yyyy-MMM-dd":"yyyy-MMM-dd HH:mm",l.calendarButtonPosition=s?"left":"right",l.value=new Date(r[n])}else if("allDay"===n||"repeat"===n)l.checked=!!r[n],e.classList["repeat"===n&&a?"add":"remove"]("smart-hidden");else if("notifications"===n)t._setNotificationEditor(e,l);else if("conference"===n){const e=l.nextElementSibling;e.innerHTML=t.localize("invalidConferenceLink"),e.classList.add("smart-hidden");const a=l.nextElementSibling.nextElementSibling;a.innerHTML=`<smart-button class="info">${t.localize("join")}</smart-button>`,a.classList.add("smart-hidden"),i.innerHTML=`<div class="smart-notification-panel">\n               <div class="smart-notification-placeholder" role="button" smart-id="placeholder" tabindex="0">${t.localize("placeholderLink")}</div>\n            </div>`,i.onclick=()=>{l.classList.contains("smart-hidden")&&(l.classList.remove("smart-hidden"),i.innerHTML=`<div class="smart-notification-panel">\n                <div role="button" smart-id="placeholder" tabindex="0">${t.localize("placeholderSetLink")}</div>\n             </div>`,l.focus())},a.onclick=e=>{e.target&&e.target.classList.contains("smart-button")&&window.open(a.getAttribute("link"),"_blank")};const o=()=>{l.value.startsWith("https://zoom.us/")?a.innerHTML=`<smart-button class="info">${t.localize("joinWith",{value:"Zoom"})}</smart-button>`:l.value.startsWith("https://meet.google.com/")?a.innerHTML=`<smart-button class="info">${t.localize("joinWith",{value:"Google Meet"})}</smart-button>`:l.value.startsWith("https://teams.microsoft.com/")&&(a.innerHTML=`<smart-button class="info">${t.localize("joinWith",{value:"Microsoft Teams"})}</smart-button>`),a.setAttribute("link",l.value),a.classList.remove("smart-hidden")},s=()=>{/^(ftp|http|https):\/\/[^ "]+$/.test(l.value)?(e.classList.add("smart-hidden"),o()):(e.classList.remove("smart-hidden"),a.classList.add("smart-hidden"))};l.onchange=l.onkeyup=()=>{const n=/^(ftp|http|https):\/\/[^ "]+$/.test(l.value);t._typing&&clearTimeout(t._typing),t._typing=setTimeout((()=>{n?(e.classList.add("smart-hidden"),o()):(e.classList.remove("smart-hidden"),a.classList.add("smart-hidden"))}),300)},l.classList.add("smart-hidden"),r[n]?(l.value=r[n],l.classList.remove("smart-hidden"),i.innerHTML=`<div class="smart-notification-panel">\n                <div role="button" smart-id="placeholder" tabindex="0">${t.localize("placeholderSetLink")}</div>\n             </div>`,o(),s()):l.value=""}else if("repeatFreq"===n){const e=["hourly","daily","weekly","monthly","yearly"],n=r.repeat?(r.repeat.repeatFreq+"").toLowerCase():e[0];l.dataSource=[{label:t.localize(e[0]),value:e[0]},{label:t.localize(e[1]),value:e[1]},{label:t.localize(e[2]),value:e[2]},{label:t.localize(e[3]),value:e[3]},{label:t.localize(e[4]),value:e[4]}],l.value=t.localize(e.indexOf(n)>-1?n:e[0])}else if("repeatInterval"===n){const e=parseInt(r.repeat?r.repeat.repeatInterval:void 0);if(l.value=isNaN(e)?1:e,i&&o.repeatFreq){const e=o.repeatFreq.querySelector("[event-editor]");if(e){const n={hourly:"repeatEveryHour",daily:"repeatEveryDay",weekly:"repeatEveryWeek",monthly:"repeatEveryMonth",yearly:"repeatEveryYear"},r=e.dataSource[Math.max(0,e.selectedIndex)].value||"";i.innerHTML+=` (${t.localize(n[r.toLowerCase()])||""})`}}}else if("repeatOn"===n)t._setRepeatOnEditor(e,l);else if(n.indexOf("repeatEnd")>-1){let i=r.repeat?r.repeat.repeatEnd:void 0,a=i;switch(n){case"repeatEnd":a=!a;break;case"repeatEndOn":a=a instanceof Date;break;case"repeatEndAfter":a="number"==typeof a&&!isNaN(a)}const o=e.querySelector(".smart-radio-button");o&&(o.innerHTML=t.localize(n+"Option"),o.checked=a,t._setEditorCommonProperties(o)),l&&(l instanceof Smart.DateTimePicker?(i=new Date(i),l.formatString="yyyy-MMM-dd",l.calendarButtonPosition=s?"left":"right",l.value=a&&!isNaN(i.getTime())?i:new Date):(i=parseInt(i),l.value=a&&!isNaN(i)?i:1),l.disabled=o&&!o.checked)}else if("exceptions"===n){const n=!a&&r.repeat&&r.repeat.exceptions&&r.repeat.exceptions.length;l.checked=!1,l.innerHTML=t.localize("resetExceptions"),e.classList[n?"remove":"add"]("smart-hidden")}else if("hidden"===n)l.checked=!!r[n],e.classList[a?"remove":"add"]("smart-hidden");else if("backgroundColor"===n){l.dataSource||(l.dataSource=r.colorScheme||t.colorScheme);const e=l.$.scrollView;e&&e.classList.add("smart-scheduler-color-input"),l.valueDisplayMode="colorBox",l.value=r.backgroundColor||""}else"status"===n?t._setStatusEditor(e,l):"resources"===n?t._setResourceEditor(e,l):"resourceData"===n&&t._setResourceDataEditor(e);l&&i&&l.setAttribute("aria-labelledby",i.id),t._setEditorCommonProperties(l)}_setEditorCommonProperties(e){const t=this;if(e){const n=e.messages,i=t.messages,r=t.locale;if(n)for(let e in n.en){const t=i[r][e];void 0!==t&&(n[r]||(n[r]={}),n[r][e]=t)}e.locale=t.locale,e.rightToLeft=t.rightToLeft,e.animation=t.animation,e.theme=t.theme}}_setNotificationEditor(e,t){const n=this,i=n.$.schedulerWindow._target.event;i?(t.value=Array.isArray(i.notifications)?i.notifications.slice():[],t.hourStart=n.hourStart,t.hourFormat=n.hourFormat,t.minuteFormat=n.minuteFormat,t.timeZone=n.timeZone,n._setEditorCommonProperties(t)):t.value=[]}_setStatusEditor(e,t){const n=this,i=n.statuses,r=n.$.schedulerWindow._target.event;if(!r||!i.length)return void e.classList.add("smart-hidden");const a=r.status,l=i.find((e=>e.value===a));e.classList.remove("smart-hidden"),t.dataSource=n.statuses.map((e=>{const t=void 0===e.value?"none":e.value;return e.label=n.localize(t)||t})),t.value=l?n.localize(l.label)||l.label:"",t.readonly=!0,t.placeholder=n.localize("selectPlaceholder"),t.dropDownButtonPosition=n.rightToLeft?"left":"right",n._setEditorCommonProperties(t)}_setResourceEditor(e,t){const n=this,i=n.resources,r=n.$.schedulerWindow._target.event;let a=[],l=[];r&&i.length?(e.classList.remove("smart-hidden"),a=i.map((e=>(e&&r[e.value]&&l.push(e.label),{label:e.label,value:e.value}))),t.readonly=!0,t.placeholder=n.localize("selectPlaceholder"),t.dropDownButtonPosition=n.rightToLeft?"left":"right",t.disabled=!i.length,t.dataSource=a,t.value=l.toString(),n._setEditorCommonProperties(t),t.wait&&(t.wait=!1)):e.classList.add("smart-hidden")}_setResourceDataEditor(e){const t=this,n=t.resources,i=t.$.schedulerWindow._target.event;let r,a,l=Array.from(e.querySelectorAll(".smart-scheduler-window-editor")),o=[];if(i&&n.length){t._windowEditors.resources&&(a=t._windowEditors.resources.querySelector("[event-editor]"),a&&a.value&&(r=a.selectedValues));for(let a=0;a<n.length;a++){const s=n[a],d=s.label,c=s.value,u=s.dataSource;if(!u||!r)continue;const h=r.length;if(h&&r.indexOf(c)>-1||!h&&i[c]){const n=u.find((e=>s&&e.id===i[c]));let r,a,h=l.find((e=>e.getAttribute("resource-type")===c));h?(r=h.querySelector("label"),a=h.querySelector("[event-editor]")):(h=document.createElement("div"),r=document.createElement("label"),a=document.createElement("smart-input"),a.setAttribute("event-editor",""),h.appendChild(r),h.appendChild(a),h.classList.add("smart-scheduler-window-editor"),h.setAttribute("resource-type",c),e.appendChild(h)),o.push(h),t._setEditorCommonProperties(a),r.innerHTML=t.localize(d)||d,a.dataSource=s.dataSource.map((e=>Object.create({label:e.label,value:e.value}))),a.value=n?n.label:"",a.dropDownButtonPosition=t.rightToLeft?"left":"right",a.readonly=!0,a.placeholder=t.localize("selectPlaceholder")}}for(let e=0;e<l.length;e++)o.indexOf(l[e])<0&&l[e].remove();e.classList.remove("smart-hidden")}else e.classList.add("smart-hidden")}_setRepeatOnEditor(e){const t=this,n=t.$.schedulerWindow._target.event,i=t._windowEditors,r=i.repeatOn,a=i.repeatFreq.querySelector("[event-editor]").value.toLowerCase();let l,o=n.repeat?n.repeat.repeatOn:void 0;if(!n||!a||["weekly","monthly","yearly"].indexOf(a)<0)return void e.classList.add("smart-hidden");r.$||(r.$={});const s=r.$;for(let e in s)e!==a&&s[e]&&s[e].remove();void 0===o&&(o=new Date(n.dateStart));let d=s[a];switch(a){case"weekly":d||(d=document.createElement("smart-button-group"),d.dataSource=t._getWeekDays(),d.selectionMode="zeroOrMany",d.setAttribute("event-editor",""),s[a]=d),t._setEditorCommonProperties(d),d.selectedValues=t._getRepeatOnCondition(a,o).map((e=>e.toString()));break;case"monthly":d||(d=document.createElement("smart-number-input"),d.min=1,d.max=31,d.setAttribute("event-editor",""),s[a]=d),t._setEditorCommonProperties(d),d.value=t._getRepeatOnCondition(a,o).toString();break;case"yearly":{let e,n;if(!d){d=document.createElement("div");const e=document.createElement("smart-input"),n=document.createElement("smart-number-input");e.dataSource=t._getMonthNames(),e.dropDownButtonPosition=t.rightToLeft?"left":"right",e.readonly=!0,n.min=1,n.max=31,e.setAttribute("event-editor",""),n.setAttribute("event-editor",""),t._setEditorCommonProperties(e),t._setEditorCommonProperties(n),d.appendChild(e),d.appendChild(n),d.classList.add("smart-scheduler-window-editor"),s[a]=d}e||(e=d.querySelector("smart-input")),n||(n=d.querySelector("smart-number-input")),l=t._getRepeatOnCondition(a,o),e.selectedIndex=l.index,n.value=l.value.toString();break}}d=s[a],e.contains(d)||e.appendChild(d),e.classList.remove("smart-hidden")}_getMonthNames(){const e=[],t=this.monthFormat,n=this.locale,i=new Date;i.setMonth(0);for(let r=0;r<12;r++)e.push({label:new Intl.DateTimeFormat(n,{month:t}).format(i),value:i.getMonth()}),i.setMonth(i.getMonth()+1);return e}_getWeekDays(){const e=this,t=[],n=e.weekdayFormat,i=e.locale,r=new Date;r.setDate(r.getDate()-r.getDay()+e.firstDayOfWeek);for(let e=0;e<7;e++)t.push({label:new Intl.DateTimeFormat(i,{weekday:n}).format(r),value:r.getDay()}),r.setDate(r.getDate()+1);return t}_createWindowTemplate(e,t){const n=this,i=n.animation,r=n.theme,a=n.rightToLeft,l=document.createElement("template");return"footer"===e?t?"confirm"===t&&(l.innerHTML=`\n                    <smart-button class="smart-scheduler-window-button edit-event"\n                        animation="${i}" theme="${r}" ${a?"right-to-left":""}>\n                    </smart-button>\n                    <smart-button class="smart-scheduler-window-button edit-series"\n                        animation="${i}" theme="${r}" ${a?"right-to-left":""}>\n                    </smart-button>`):l.innerHTML=`<smart-button class="smart-scheduler-window-button ok primary"\n                        animation="${i}" theme="${r}" ${a?"right-to-left":""}>\n                    </smart-button>\n                    <smart-button class="smart-scheduler-window-button cancel"\n                        animation="${i}" theme="${r}" ${a?"right-to-left":""}>\n                    </smart-button>\n                    <smart-button class="smart-scheduler-window-button delete secondary"\n                        animation="${i}" theme="${r}" ${a?"right-to-left":""}>\n                    </smart-button>`:"header"===e&&(l.innerHTML='<span class="smart-scheduler-window-label"></span>'),l}_currentTimeIndicatorIntervalValidator(e,t){return Math.max(1,t)}_hourValidator(e,t){return Math.max(0,Math.min(23,t))}_datesValidator(e,t){const n=this;let i=[];for(let e=0;e<t.length;e++){const r=n._parseDate(t[e]);isNaN(r)||(r.setHours(0,0,0,0),i.push(r))}return i}_dateValidator(e,t){return t=this._parseDate(t),this._minMaxDateValidator(isNaN(t)?e:t)}_parseDate(e){let t;if(e instanceof Date)return e;if(Smart.Utilities.DateTime&&e instanceof Smart.Utilities.DateTime)return e.toDate();if("string"==typeof e){const n=/\d+:\d+:\d+/;if("new Date()"===e.trim()||"new Smart.Utilities.DateTime()"===e.trim())return new Date;if(isNaN(Date.parse(e))){const i=/(\d+[,-.\/]{1}\s*\d+[,-.\/]{1}\s*\d+)/;if(i.test(e)){const r=i.exec(e)[0].replace(/[,-.\/]/g,",").split(",");if(3===r.length){const[i,a]=parseInt(r[0])<parseInt(r[2])?[r[0],r[2]]:[r[2],r[0]];if(t=new Date(parseInt(a),parseInt(r[1])-1,parseInt(i)),n.test(e)){const i=n.exec(e)[0].split(":");t.setHours(i[0]||0,i[1]||0,i[2]||0)}e=t}}}else t=new Date(Date.parse(e)),n.test(e)||t.setHours(0,0,0,0),e=t}return new Date(e)}_firstDayOfWeekValidator(e,t){return Math.min(6,Math.max(0,t))}_minMaxDateValidator(e){if(!e||isNaN(e.getTime()))return e;const t=new Date(this.min),n=new Date(this.max);return t&&(e=new Date(Math.max(t.getTime(),e.getTime()))),n&&(e=new Date(Math.min(n.getTime(),e.getTime()))),e}_nonworkingDayValidator(e,t){return this._nonworkingDateTimeValidator(e,t)}_nonworkingTimeValidator(e,t){return this._nonworkingDateTimeValidator(e,t,!0)}_nonworkingDateTimeValidator(e,t,n){let i=[];const[r,a]=[0,n?23:6];for(let e=0;e<t.length;e++){const l=t[e];if("number"!=typeof l||isNaN(l))if(Array.isArray(l)){let e=Math.max(r,Math.min(a,parseInt(l[0]))),t=Math.max(r,Math.min(a,parseInt(l[1])));if(!isNaN(e)&&!isNaN(t)){for(;e!==t;)i.push(e),e=e===a?r:++e;i.push(e)}}else{const e=this._dateValidator(l,l);e instanceof Date&&i.push(n?e.getHours():e.getDay())}else i.push(Math.max(r,Math.min(a,parseInt(l))))}return i}_setViewType(e){const t=this,n=t.views.find((t=>t.value&&t.value===e));e=n?n.type:e,t.set("viewType",t.properties.viewType.allowedValues.indexOf(e)>-1?e:"day")}_timeZoneValidator(e,t){const n=this,i=(new Smart.Utilities.DateTime).timeZones;t||(t="local"),t=t.toLowerCase();const r=i.find((e=>e.id.toLowerCase()===t));return r?r.id:(n.error(n.localize("invalidTimeZone",{elementType:n.nodeName.toLowerCase()})),e)}_timeZonesValidator(e,t){const n=this;let i=[];for(let e=0;e<t.length;e++){const r=t[e],a=r.id||r;null!==n._timeZoneValidator(null,a)&&i.push({id:a,label:r.label||a})}return i}_viewValidator(e,t){const n=this;return n._isViewUpdated=!0,n._setViewType(t),delete n._isViewUpdated,t}_viewTypeValidator(e,t){return this._isViewUpdated?t:e}_viewsValidator(e,t){const n=this,i=n.properties.viewType.allowedValues;let r=[];for(let e=0;e<t.length;e++){const a=t[e];"string"==typeof a&&i.includes(a)?r.push(a):"object"==typeof a&&i.includes(a.type)&&(a.value=a.value||a.type,a.label=void 0===a.label?n.localize(a.type):a.label+"",r.push(a))}return r}}),Smart("smart-notification-panel",class extends Smart.BaseElement{static get properties(){return{hourStart:{value:0,type:"number"},hourFormat:{value:"numeric",allowedValues:["numeric","2-digit"],type:"string"},messages:{extend:!0,value:{en:{beforeAt:"before at",days:"days",weeks:"weeks",placeholder:"Add notification",hours:"Hours",minutes:"Minutes",am:"am",pm:"pm"}},type:"object"},minuteFormat:{value:"2-digit",allowedValues:["numeric","2-digit"],type:"string"},placeholder:{value:"placeholder",type:"string"},timeZone:{value:"local",type:"string"},value:{value:[],type:"array"}}}template(){return'<div id="container" role="presentation">\n                    <div id="notificationsContainer" class="smart-notification-container" role="group"></div>\n                    <div id="placeholder" class="smart-notification-placeholder" role="button"></div>\n                    <smart-input wait right-to-left="[[rightToLeft]]" readonly id="typeInput" class="smart-notification-editor smart-hidden"></smart-input>\n                    <smart-time-input wait right-to-left="[[rightToLeft]]" id="timeInput" class="smart-notification-editor smart-hidden"></smart-time-input>\n                    <smart-number-input wait right-to-left="[[rightToLeft]]" id="intervalInput" class="smart-notification-editor smart-hidden"></smart-number-input>\n                </div>'}static get listeners(){return{"document.click":"_clickHandler",keydown:"_keyDownHandler","container.change":"_containerChangeHandler"}}static get requires(){return{"Smart.Input":"smart.input.js","Smart.TimeInput":"smart.timeinput.js","Smart.NumberInput":"smart.numberinput.js"}}propertyChangedHandler(e,t,n){const i=this;if("placeholder"!==e){if("rightToLeft"===e){const e=n?"left":"right";i.$.typeInput.dropDownButtonPosition=e,i.$.intervalInput.dropDownButtonPosition=e}else"locale"===e?(i.$.placeholder.textContent=i.localize(i.placeholder),i._handleNotificationEditors()):super.propertyChangedHandler(e,t,n);i._handleNotifications()}else i.$.placeholder.textContent=i.localize(i.placeholder)}render(){const e=this;e.hasAttribute("role")||e.setAttribute("role","dialog"),e.$.placeholder.textContent=e.localize(e.placeholder),e._handleNotifications(),e._handleNotificationEditors(),e._setFocusable(),super.render()}_setFocusable(){const e=this,t=e.$.placeholder;if(e.disabled||e.unfocusable)return e.removeAttribute("tabindex"),void t.removeAttribute("tabindex");const n=e.tabIndex>0?e.tabIndex:0;e.tabIndex=n,t.setAttribute("tabindex",n);const i=e.$.notificationsContainer.children;for(let e=0;e<i.length;e++){const t=i[e];Array.from(t.children).forEach((e=>{e instanceof HTMLLabelElement||(e.tabIndex=n)}))}}_keyDownHandler(e){const t=this;if(t.disabled||t.readonly)return;const n=e.target;switch(e.key){case"Enter":(n.closest(".smart-notification-item")||n.closest(".smart-notification-placeholder"))&&(e.preventDefault(),t._clickHandler({target:n}));break;case"Escape":case"Tab":t._hideEditor()}}_clickHandler(e){const t=this;let n=e.target;if(!n||!n.closest||!t.$.container.contains(n)||t.disabled||t.readonly)return void t._hideEditor();if(n.closest(".smart-notificaiton-editor"))return;if(n.closest(".smart-notification-placeholder"))return t._createNotificaiton(),void t._hideEditor();const i=n.closest(".smart-notification-item");if(!i){if(t._editor&&!t._editor.classList.contains("smart-hidden")&&n.closest(".smart-notification-editor"))return;return void t._hideEditor()}t._hideEditor();const r=i._notificationObj;if(n.hasAttribute("delete"))return void t._deleteNotification(i);const a=n.closest(".smart-input");if(!a)return;let l;n.hasAttribute("interval")?(l=t.$.intervalInput,l.value=r.interval,l.min=0,l.max="days"===r.type?28:4):n.hasAttribute("type")?(l=t.$.typeInput,l.value=l.dataSource.find((e=>e.value===r.type)).label):n.hasAttribute("time")&&(l=t.$.timeInput,l.dateTimeFormat={hour:t.hourFormat,minute:t.minuteFormat},l.value=r.time),l._notificationObj=r,l.classList.remove("smart-hidden"),l.wait=!1,l.style.width=a.offsetWidth+"px",l.style.height=a.offsetHeight+"px",l.style.top=a.offsetTop+"px",l.style.left=a.offsetLeft+"px",l&&l.open(),t._editor=l}_hideEditor(){const e=this,t=e._editor;if(!t)return;const n=e._editor._notificationObj;n&&(t===e.$.timeInput?n.time=t.value:t===e.$.typeInput?n.type=t.value:n.interval=t.value,e._refreshNotificationItem(n)),t.close&&t.close(),e._editor.classList.add("smart-hidden"),delete e._editor}_createNotificaiton(){const e=this,t=e._notifications;if(!t)return;const n={interval:1,type:"days",time:[e.hourStart,0]};t.push(n),e._refreshNotificationItems()}_deleteNotification(e){const t=this._notifications;if(!t||!e)return;const n=e._notificationObj;if(delete e._notificationObj,e.remove(),!n)return;const i=t.indexOf(n);i<0||(t.splice(i,1),this._refreshNotificationItems())}_containerChangeHandler(e){const t=this,n=e.target,i=n._notificationObj;n===t.$.timeInput?i.time=n.value:n===t.$.typeInput?i.type=n.dataSource.find((e=>e.label===n.value)).value:n===t.$.intervalInput&&(i.interval=n.value),t._refreshNotificationItem(i)}_refreshNotificationItem(e){const t=this,n=t.$.notificationsContainer.children;for(let i=0;i<n.length;i++){const r=n[i];if(r._notificationObj===e){let n=new Date;n.setHours(e.time[0],e.time[1]);const i=r.children;for(let r=0;r<i.length;r++){const a=i[r];a.hasAttribute("interval")?a.textContent=e.interval:a.hasAttribute("type")?a.textContent=t.localize(e.type)||e.type:a.hasAttribute("time")&&(a.textContent=n.toLocaleTimeString(t.locale,{hour:t.hourFormat,minute:t.minuteFormat}))}}}}_refreshNotificationItems(){const e=this,t=e.$.notificationsContainer,n=e._notifications;for(;t.firstElementChild;)delete t.firstElementChild._notificationObj,t.firstElementChild.remove();if(n&&n.length){const i=document.createDocumentFragment();for(let t=0;t<n.length;t++)i.appendChild(e._createNotificationItem(n[t]));i.children.length&&t.appendChild(i)}e._setFocusable(),e.set("value",n)}_handleNotifications(){const e=this,t=e.value;let n;e.$.notificationsContainer.innerHTML="",n=e._notifications=[];for(let e=0;e<t.length;e++){const i=t[e];let r=i.interval,a=i.type,l=i.time;if(void 0===r||void 0===a||void 0===l)continue;l instanceof Date?l=[l.getHours(),l.getMinutes()]:Array.isArray(l)||(l=[]),a=a&&"days"!==a?"weeks":"days","days"===a?r=Math.max(0,Math.min(28,r)):(a="weeks",r=Math.max(0,Math.min(4,r))),l[0]=Math.max(0,Math.min(23,l[0]||0)),l[1]=Math.max(0,Math.min(59,l[1]||0));const o={interval:r,type:a,time:l};n.push(o)}e._refreshNotificationItems()}_createNotificationItem(e){const t=this,n=document.createElement("div");n.classList.add("smart-notification-item"),n.setAttribute("role","group");let i=new Smart.Utilities.DateTime(new Date).toDate(t.timeZone);return i.setHours(e.time[0],e.time[1]),n.innerHTML=`\n            <div class="smart-input" interval>${e.interval}</div>\n            <div class="smart-input" type>${t.localize(e.type)||e.type}</div>\n            <label>${t.localize("beforeAt")||""}</label>\n            <div class="smart-input" time>${i.toLocaleTimeString(t.locale,{hour:t.hourFormat,minute:t.minuteFormat})}</div>\n            <div class="smart-button" delete aria-label="Delete" role="button"></div>`,n._notificationObj=e,n}_handleNotificationEditors(){const e=this,t=e.rightToLeft,n=e.locale,i=e.theme,r=e.$.intervalInput,a=e.$.typeInput,l=e.$.timeInput,o=e.messages;[r,a,l].forEach((e=>{const r=e.messages;for(let e in r.en){const t=o[n][e];void 0!==t&&(r[n]||(r[n]={}),r[n][e]=t)}e.rigtToLeft=t,e.locale=n,e.theme=i}));const s=t?"left":"right";l.dropDownButtonPosition="none",a.dropDownButtonPosition=s,r.dropDownButtonPosition=s,a.dataSource=[{label:e.localize("days"),value:"days"},{label:e.localize("weeks"),value:"weeks"}]}});