
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-time-picker",class extends Smart.BaseElement{static get properties(){return{autoSwitchToMinutes:{value:!1,type:"boolean"},footer:{value:!1,type:"boolean"},footerTemplate:{value:null,type:"any?"},format:{value:"12-hour",allowedValues:["12-hour","24-hour"],type:"string"},minuteInterval:{value:1,type:"number"},name:{value:"",type:"string"},selection:{value:"hour",allowedValues:["hour","minute"],type:"string"},value:{value:new Date,type:"any",reflectToAttribute:!1},view:{value:"portrait",allowedValues:["landscape","portrait"],type:"string"}}}static get listeners(){return{keydown:"_keydownHandler",resize:"_resizeHandler","header.click":"_headerClickHandler","picker.down":"_pickerDownHandler","picker.move":"_pickerMoveHandler","document.move":"_documentMoveHandler","document.up":"_documentUpHandler"}}static get requires(){return{"Smart.Utilities.NumericProcessor":"smart.numeric.js","Smart.Utilities.BigNumber":"smart.math.js","Smart.Utilities.Draw":"smart.draw.js"}}static get styleUrls(){return["smart.timepicker.css"]}template(){return'<div id="container" role="presentation">\n                <div id="header" class="smart-header smart-unselectable" role="heading" aria-level="1">\n                    <div id="hourMinuteContainer" class="smart-hour-minute-container">\n                        <div id="hourContainer" class="smart-hour-container" role="button"></div>\n                        <div role="presentation">:</div>\n                        <div id="minuteContainer" class="smart-minute-container" role="button"></div>\n                    </div>\n                    <div id="ampmContainer" class="smart-am-pm-container" role="presentation">\n                        <div id="amContainer" class="smart-am-container" role="button">AM</div>\n                        <div id="pmContainer" class="smart-pm-container" role="button">PM</div>\n                    </div>\n                </div>\n                <div id="main" class="smart-main-container">\n                    <div id="svgContainer" class="smart-svg-container">\n                        <div id="picker" class="smart-svg-picker" role="slider"></div>\n                    </div>\n                    <div id="footer" class="smart-footer"></div>\n                </div>\n                <input id="hiddenInput" type="hidden" name="[[name]]">\n            </div>'}ready(){super.ready()}render(){this._createElement(),super.render()}setHours(e){const t=this;(e=24===e?0:Math.max(0,Math.min(e,23)))<12?t._selectAmPm("am"):t._selectAmPm("pm"),"12-hour"===t.format&&(0===e?e=12:e>12&&(e-=12)),t._updateHours(e,arguments[1]),"hour"===t.selection&&(t._inInnerCircle="24-hour"===t.format&&(0===e||e>12),t._drawArrow(!0,e,arguments[2]),t.hasAnimation||(t._inInnerCircle=!1))}setMinutes(e){const t=this;e=60===e?0:Math.max(0,Math.min(e,59)),t._updateMinutes(e),"minute"===t.selection&&t._drawArrow(!0,e,arguments[1])}propertyChangedHandler(e,t,a){super.propertyChangedHandler(e,t,a);const r=this;switch(e){case"disabled":case"unfocusable":r._setFocusable();break;case"footer":case"view":r._resizeHandler();break;case"footerTemplate":r._validateFooterTemplate();break;case"format":{let e=r.value.getHours();"12-hour"===a?(r.$ampmContainer.removeClass("smart-hidden"),r.value.getHours()<12?r._selectAmPm("am"):r._selectAmPm("pm"),0===e?e=12:e>12&&(e-=12)):r.$ampmContainer.addClass("smart-hidden"),r.$.hourContainer.innerHTML=e,"hour"===r.selection&&(r.$.picker.setAttribute("aria-valuenow",e),r._draw.clear(),r._renderSVG());break}case"minuteInterval":{const e=Math.max(1,Math.min(a,60));e!==a&&(r.minuteInterval=e),"minute"===r.selection&&(r.interval=e);break}case"selection":"hour"===a?r._changeToHourSelection():r._changeToMinuteSelection();break;case"value":{r._oldValue=t,r._validateValue();const e=r.value.getHours()===t.getHours(),a=r.value.getMinutes()===t.getMinutes();e&&a||(a?r.setHours(r.value.getHours()):(e||r.setHours(r.value.getHours(),!0),r.setMinutes(r.value.getMinutes()))),delete r._oldValue;break}}}_applyInitialSettings(){const e=this,t=e.value;let a,r;a=t.getHours(),r=t.getMinutes(),"12-hour"===e.format?a<12?(e._ampm="am",e.$amContainer.addClass("smart-selected"),0===a&&(a=12)):(e._ampm="pm",e.$pmContainer.addClass("smart-selected"),a>12&&(a-=12)):e.$ampmContainer.addClass("smart-hidden"),r=r.toString(),1===r.length&&(r="0"+r),e.$.hourContainer.innerHTML=a,e.$.minuteContainer.innerHTML=r,"hour"===e.selection?(e.$hourContainer.addClass("smart-selected"),e.$.picker.setAttribute("aria-valuenow",a)):(e.$minuteContainer.addClass("smart-selected"),e.$.picker.setAttribute("aria-valuenow",r))}_changeSelection(e,t){const a=this,r=e.pageX,n=e.pageY,i=a._getCenterCoordinates(),s=Math.sqrt(Math.pow(i.x-r,2)+Math.pow(i.y-n,2));if(a._measurements.center=i,"down"===e.type){if(s>a._measurements.radius)return void e.stopPropagation();a._dragging=!0}"24-hour"===a.format&&"hour"===a.selection&&s<a._measurements.radius-50?a._inInnerCircle=!0:a._inInnerCircle=!1;let o=-1*Math.atan2(n-i.y,r-i.x)*180/Math.PI;o<0&&(o+=360),a._angle=o;let l=a._numericProcessor.getValueByAngle(a._angle);"hour"===a.selection?("24-hour"===a.format&&a._inInnerCircle?0!==l&&12!==l?l+=12:l=0:0===l&&(l=12),a._updateHours(l)):(60===l&&(l=0),a._updateMinutes(l)),void 0!==a._oldTimePart&&(cancelAnimationFrame(a._animationFrameId),delete a._animationFrameId,a._drawArrow(!0,l,t))}_changeToHourSelection(){const e=this,t=e._centralCircle.parentElement||e._centralCircle.parentNode;let a=e.value.getHours();cancelAnimationFrame(e._animationFrameId),delete e._animationFrameId,e.interval=1,e.$hourContainer.addClass("smart-selected"),e.$minuteContainer.removeClass("smart-selected"),t.removeChild(e._centralCircle),t.removeChild(e._arrow),t.removeChild(e._head),e._getMeasurements(),e._numericProcessor.getAngleRangeCoefficient(),e._draw.clear(),t.appendChild(e._centralCircle),t.appendChild(e._arrow),t.appendChild(e._head),e._renderHours(),"24-hour"===e.format&&(0===a||a>12)?e._inInnerCircle=!0:"12-hour"===e.format&&(a%=12,0===a&&(a=12)),e._drawArrow(!0,void 0,!0),e._inInnerCircle=!1,e.$.picker.firstElementChild.setAttribute("aria-hidden",!0),e.$.picker.setAttribute("aria-valuenow",a)}_changeToMinuteSelection(){const e=this,t=e._centralCircle.parentElement||e._centralCircle.parentNode;e._inInnerCircle=!1,cancelAnimationFrame(e._animationFrameId),delete e._animationFrameId,e.interval=e.minuteInterval,e.$hourContainer.removeClass("smart-selected"),e.$minuteContainer.addClass("smart-selected"),t.removeChild(e._centralCircle),t.removeChild(e._arrow),t.removeChild(e._head),e._getMeasurements(),e._numericProcessor.getAngleRangeCoefficient(),e._draw.clear(),t.appendChild(e._centralCircle),t.appendChild(e._arrow),t.appendChild(e._head),e._renderMinutes(),e._drawArrow(!0,void 0,!0),e.$.picker.firstElementChild.setAttribute("aria-hidden",!0),e.$.picker.setAttribute("aria-valuenow",e.value.getMinutes())}_computeArrowBodyPoints(e,t,a,r){const n=Math.sin(t),i=Math.cos(t),s=e-a*i+r*n,o=e+a*n+r*i,l=e+a*i+r*n,d=e-a*n+r*i,u="M "+(e+a*i)+","+(e-a*n)+" L "+(e-a*i)+","+(e+a*n)+" L "+s+","+o+" "+l+","+d;return this._headCenter={x:(s+l)/2,y:(o+d)/2},u}_createElement(){const e=this;e.setAttribute("role","dialog"),e.coerce=!0,e.min=0,e._drawMin="0",e.startAngle=-270,e.endAngle=90,e._angleDifference=e.endAngle-e.startAngle,e.ticksVisibility="none",e._tickIntervalHandler={},e._tickIntervalHandler.labelsSize={},e._distance={majorTickDistance:0,minorTickDistance:0,labelDistance:10},e._measurements={},e._validateInitialPropertyValues(),e._applyInitialSettings(),e._numericProcessor=new Smart.Utilities.DecimalNumericProcessor(e),e._draw=new Smart.Utilities.Draw(e.$.picker),e._isVisible()?(e._setPickerSize(),e._getMeasurements(),e._numericProcessor.getAngleRangeCoefficient(),e._renderSVG(),e._setFocusable(),e.$.hiddenInput.value=e.value,e.enableShadowDOM&&e.appendChild(e.$.hiddenInput)):e._renderingSuspended=!0}_documentMoveHandler(e){const t=this;t._dragging&&t._changeSelection(e,!0)}_documentUpHandler(){const e=this;e._dragging?(e._inInnerCircle=!1,e._dragging=!1,e.autoSwitchToMinutes&&"hour"===e.selection&&(e.hasAnimation?function t(){e._animationFrameId?requestAnimationFrame(t):(e.$picker.addClass("animate"),setTimeout((function(){e.selection="minute",e._changeToMinuteSelection()}),250),setTimeout((function(){e.$picker.removeClass("animate")}),550))}():(e.selection="minute",e._changeToMinuteSelection()))):e.hasAttribute("focus")&&(e.$.fireEvent("blur"),e.removeAttribute("focus"))}_drawArrow(e,t,a){const r=this,n="hour"===r.selection,i="12-hour"===r.format;let s,o,l=r._oldTimePart;if(delete r._oldTimePart,void 0===t&&(n?(t=r.value.getHours(),i&&t>12&&(t-=12)):t=r.value.getMinutes()),void 0===l||a||!r.hasAnimation)return void r._drawArrowSVG(e,t);if(n&&!i)return void r._animate24HourView(l,t);n?(s=.2,o=12,t%=o,l%=o):(s=1,o=60);let d=t-l,u=l-t;d<0&&(d+=o),u<0&&(u+=o),u<d&&(s*=-1),function a(){l+=s,l=parseFloat((l%o).toFixed(1)),l<0&&(l+=o),r._drawArrowSVG(e,l),e=!0,l!==t%o?r._animationFrameId=requestAnimationFrame(a):delete r._animationFrameId}()}_animate24HourView(e,t){const a=this;let r=.2;a._inInnerCircle=!1;const n=0===e||e>12,i=0===t||t>12;if(n!==i){if(e=n?Math.abs(e-12):(e+12)%24,a._inInnerCircle=i,a._drawArrowSVG(!0,e),e===t)return}else a._inInnerCircle=i;let s=e,o=t;a._inInnerCircle&&(0===o&&s<18?o=12:0===s&&o<18&&(s=12));let l=o-s,d=s-o;l<0&&(l+=12),d<0&&(d+=12),d<l&&(r*=-1),function n(i){a._inInnerCircle=i,i?((e=parseFloat((e+r).toFixed(1)))<0?e+=24:e<1&&(e+=12),12!==e&&24!==e||(e=0)):(12!==(e+=r)&&(e=parseFloat((e%12).toFixed(1))),e<=0&&(e+=12)),a._drawArrowSVG(!0,e),e!==t?a._animationFrameId=requestAnimationFrame((function(){n(i)})):(delete a._animationFrameId,a._inInnerCircle=!1)}(a._inInnerCircle)}_drawArrowSVG(e,t){const a=this,r=a._measurements,n=a._numericProcessor.getAngleByValue(t);let i;i=a._inInnerCircle?a._computeArrowBodyPoints(r.radius,n,1,r.innerRadius-a._largestLabelSize/2-45):a._computeArrowBodyPoints(r.radius,n,1,r.innerRadius-a._largestLabelSize/2),e?(a._arrow.setAttribute("d",i),a._head.setAttribute("cx",a._headCenter.x),a._head.setAttribute("cy",a._headCenter.y),a._head.setAttribute("r",a._largestLabelSize),a._headRect=a._head.getBoundingClientRect(),t%1==0&&a._highlightLabel(t)):(a._arrow=a._draw.path(i,{class:"smart-needle"}),a._head=a._draw.circle(a._headCenter.x,a._headCenter.y,a._largestLabelSize,{class:"smart-needle-central-circle"}),a._headRect=a._head.getBoundingClientRect())}_drawLabel(e,t,a){const r=this,n=r._measurements,i=n.radius,s={class:"smart-label smart-unselectable","font-size":n.fontSize,"font-family":n.fontFamily,"font-weight":n.fontWeight,"font-style":n.fontStyle};"hour"===r.selection?r._plotInnerCircle?t>0?t+=12:t="00":0===t&&(t=12):1===t.toString().length&&(t="0"+t);const o=r._draw.measureText(t,0,s),l=i-a-r._largestLabelSize/2,d=i+l*Math.sin(e),u=i+l*Math.cos(e);r._draw.text(t,Math.round(d)-o.width/2,Math.round(u)-o.height/2,o.width,o.height,0,s).setAttribute("value",parseFloat(t))}_getCenterCoordinates(){const e=this.$.picker.getBoundingClientRect(),t=this._measurements.radius,a=document.body.scrollLeft||document.documentElement.scrollLeft,r=document.body.scrollTop||document.documentElement.scrollTop;return{x:e.left+a+t,y:e.top+r+t}}_getMeasurements(){const e=this,t=e._measurements,a=document.createElement("div");let r,n,i,s,o,l;a.className="smart-label",a.style.position="absolute",a.style.visibility="hidden",e.$.svgContainer.appendChild(a),"hour"===e.selection?(r="1",n="23",e.max=12,e._drawMax="12",e._range=12):(r="00",n="55",e.max=60,e._drawMax="60",e._range=60),a.innerHTML=r,i=a.offsetWidth,o=a.offsetHeight,a.innerHTML=n,s=a.offsetWidth,l=a.offsetHeight,e._largestLabelSize=Math.max(i,o,s,l),e._tickIntervalHandler.labelsSize.minLabelSize=o,e._tickIntervalHandler.labelsSize.maxLabelSize=l;const d=window.getComputedStyle(a);t.fontSize=d.fontSize,t.fontFamily=d.fontFamily,t.fontWeight=d.fontWeight,t.fontStyle=d.fontStyle,e.$.svgContainer.removeChild(a)}_headerClickHandler(e){const t=this;if(!t.disabled&&!t.readonly)switch(e.target){case t.$.hourContainer:"hour"!==t.selection&&(t.selection="hour",t._changeToHourSelection());break;case t.$.minuteContainer:"minute"!==t.selection&&(t.selection="minute",t._changeToMinuteSelection());break;case t.$.amContainer:if(!t.$amContainer.hasClass("smart-selected")){t._selectAmPm("am");const e=new Date(t.value.getTime());t.value.setHours(t.value.getHours()-12),t.$.hiddenInput.value=t.value,t.$.fireEvent("change",{value:t.value,oldValue:e})}break;case t.$.pmContainer:if(!t.$pmContainer.hasClass("smart-selected")){t._selectAmPm("pm");const e=new Date(t.value.getTime());t.value.setHours(t.value.getHours()+12),t.$.hiddenInput.value=t.value,t.$.fireEvent("change",{value:t.value,oldValue:e})}}}_highlightLabel(e){const t=this;if(t._highlightedLabel){if(parseFloat(t._highlightedLabel.getAttribute("value"))===e)return;t._highlightedLabel.classList.remove("smart-selected"),t._highlightedLabel=void 0}let a;"hour"===t.selection?(void 0===e&&(e=t.value.getHours()),"12-hour"===t.format&&(0===e?e=12:e>12&&(e-=12)),a=e):(void 0===e&&(e=t.value.getMinutes()),a=5*Math.round(e/5),60===a&&(a=0));const r=t.$.picker.querySelector('.smart-label[value="'+a+'"]');r&&(a===e||t._overlapsLabel(r))&&(t._highlightedLabel=r,r.classList.add("smart-selected"))}_isVisible(){const e=this;return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)}_keydownHandler(e){const t=this;if(t._dragging)return;const a=(t.shadowRoot||t.getRootNode()).activeElement,r=e.key;if(!t.$.header.contains(a)||"Enter"!==r&&" "!==r){if(a===t.$.picker&&!e.altKey){let a;if("ArrowRight"===r||"ArrowUp"===r?a=1:"ArrowLeft"!==r&&"ArrowDown"!==r||(a=-1),a)if(e.preventDefault(),"hour"===t.selection){let e=t.value.getHours();0===e&&-1===a?e=23:23===e&&1===a?e=0:e+=a,"12-hour"===t.format&&(e>=12&&t.$amContainer.hasClass("smart-selected")?e-=12:e<12&&t.$pmContainer.hasClass("smart-selected")&&(e+=12)),t.setHours(e,void 0,!0)}else{let e=t.value.getMinutes();a*=t.minuteInterval,e+a>=60?e=0:e<-1*a?e=60%a==0?60+a:60-60%a:e+=a,t.setMinutes(e,!0)}}}else e.preventDefault(),t._headerClickHandler({target:a})}_overlapsLabel(e){const t=this,a=e.getBoundingClientRect();let r=t._headRect;return 0===r.height&&(r=t._headRect=t._head.getBoundingClientRect()),!(a.right-10<r.left||a.left+10>r.right||a.bottom-10<r.top||a.top+10>r.bottom)}_parseDateString(e,t){const a=e.indexOf("Date("),r=e.indexOf(")");let n=e;if(-1!==a&&-1!==r){if(n=e.slice(a+5,r),n=n.replace(/'/g,"").replace(/"/g,"").replace(/^\s+|\s+$|\s+(?=\s)/g,""),""===n.trim())return new Date;if(new RegExp(/(^(\d+)(\s*,\s*\d+)+$)/g).test(n))return n=n.replace(/\s/g,""),n=n.split(","),n.map((function(e,t){n[t]=parseInt(e)})),n.unshift(null),n=new(Function.prototype.bind.apply(Date,n)),n}if(""===n.trim())return t;if(!isNaN(n))return new Date(parseInt(n,10));try{n=new Date(n)}catch(e){n=t}return isNaN(n.getTime())?t:n}_pickerDownHandler(e){const t=this;t.disabled||t.readonly||!Smart.Utilities.Core.isMobile&&1!==e.which||(t._changeSelection(e),t.$.fireEvent("focus"),t.setAttribute("focus",""))}_pickerMoveHandler(e){"touchmove"===e.originalEvent.type&&e.originalEvent.preventDefault()}_renderHours(){const e=this;e._highlightedLabel=void 0,e._majorTicksInterval=1,e._numericProcessor.addGaugeTicksAndLabels(),"24-hour"===e.format?(e._plotInnerCircle=!0,e._distance.labelDistance=55,e._numericProcessor.addGaugeTicksAndLabels(),e._plotInnerCircle=!1,e._distance.labelDistance=10,e.$.picker.setAttribute("aria-valuemin",0),e.$.picker.setAttribute("aria-valuemax",23)):(e.$.picker.setAttribute("aria-valuemin",1),e.$.picker.setAttribute("aria-valuemax",12))}_renderMinutes(){const e=this;e._highlightedLabel=void 0,e._majorTicksInterval=5,e._numericProcessor.addGaugeTicksAndLabels(),e.$.picker.setAttribute("aria-valuemin",0),e.$.picker.setAttribute("aria-valuemax",59)}_renderSVG(){const e=this;if(e._isVisible()&&!e._renderingSuspended){if(e._centralCircle=e._draw.circle(e._measurements.radius,e._measurements.radius,4,{class:"smart-needle-central-circle"}),"hour"===e.selection&&"24-hour"===e.format&&(0===e.value.getHours()||e.value.getHours()>12)&&(e._inInnerCircle=!0),e._drawArrow(!1),e._inInnerCircle=!1,"hour"===e.selection){e.interval=1,e._renderHours();let t=e.value.getHours();"12-hour"===e.format&&t>12&&(t-=12),e._highlightLabel(t)}else e.interval=e.minuteInterval,e._renderMinutes(),e._highlightLabel(e.value.getMinutes());e.$.picker.firstElementChild.setAttribute("aria-hidden",!0)}else e._renderingSuspended=!0}refresh(){const e=this;let t=!1;e.isRendered&&(e._isVisible()?(e._renderingSuspended=!1,t=!0,e._getMeasurements(),e._numericProcessor.getAngleRangeCoefficient(),e._setPickerSize(),e._sizeChanged||t?(e._draw.clear(),e._renderSVG(),e._sizeChanged=!1):(e._headRect=e._head.getBoundingClientRect(),e._highlightLabel())):e._renderingSuspended=!0)}_resizeHandler(){this.refresh()}_selectAmPm(e){const t=this;"am"===e?(t._ampm="am",t.$pmContainer.removeClass("smart-selected"),t.$amContainer.addClass("smart-selected")):(t._ampm="pm",t.$amContainer.removeClass("smart-selected"),t.$pmContainer.addClass("smart-selected"))}_setFocusable(){const e=this;if(e.disabled||e.unfocusable)return e.$.hourContainer.removeAttribute("tabindex"),e.$.minuteContainer.removeAttribute("tabindex"),e.$.amContainer.removeAttribute("tabindex"),e.$.pmContainer.removeAttribute("tabindex"),void e.$.picker.removeAttribute("tabindex");const t=e.tabIndex>0?e.tabIndex:0;e.$.hourContainer.tabIndex=t,e.$.minuteContainer.tabIndex=t,e.$.amContainer.tabIndex=t,e.$.pmContainer.tabIndex=t,e.$.picker.tabIndex=t}_setPickerSize(){const e=this,t=e.$.svgContainer.offsetWidth,a=e.$.svgContainer.offsetHeight;let r=.9*Math.min(t,a);void 0!==e._pickerSize&&e._pickerSize!==r?e._sizeChanged=!0:e._sizeChanged=!1,e._pickerSize=r,e._measurements.radius=r/2,e._measurements.innerRadius=e._measurements.radius-10,r+="px",e.$.picker.style.width=r,e.$.picker.style.height=r}_updateHours(e,t){const a=this;let r=e;"12-hour"===a.format?"am"===a._ampm?12===r&&(r=0):r<12&&(r+=12):r=e;const n=void 0!==a._oldValue?a._oldValue:new Date(a.value.getTime()),i=n.getHours();r!==i?(a._oldTimePart=i,void 0===a._oldValue&&a.value.setHours(r),a.$.hourContainer.innerHTML=e,!0!==t&&(a.$.hiddenInput.value=a.value,a.$.fireEvent("change",{value:a.value,oldValue:n})),"hour"===a.selection&&a.$.picker.setAttribute("aria-valuenow",e)):delete a._oldTimePart}_updateMinutes(e){const t=this,a=void 0!==t._oldValue?t._oldValue:new Date(t.value.getTime()),r=a.getMinutes();e!==r?(t._oldTimePart=r,void 0===t._oldValue&&t.value.setMinutes(e),"minute"===t.selection&&t.$.picker.setAttribute("aria-valuenow",e),1===(e=e.toString()).length&&(e="0"+e),t.$.minuteContainer.innerHTML=e,t.$.hiddenInput.value=t.value,t.$.fireEvent("change",{value:t.value,oldValue:a})):delete t._oldTimePart}_validateFooterTemplate(){const e=this,t=e.footerTemplate;if(null===t)return void(e.$.footer.innerHTML="");let a;if(t instanceof HTMLTemplateElement?a=t:"string"==typeof t&&(a=document.getElementById(t),a instanceof HTMLTemplateElement||(a=void 0)),void 0===a)return e.footerTemplate=null,void(e.$.footer.innerHTML="");const r=document.importNode(a.content,!0);if(e.enableShadowDOM)return e.$.footer.innerHTML="<slot></slot>",void e.appendChild(r);e.$.footer.appendChild(r)}_validateInitialPropertyValues(){const e=this;e._validateFooterTemplate(),e.minuteInterval=Math.max(1,Math.min(e.minuteInterval,60)),e._validateValue()}_validateValue(){const e=this,t=e.value,a=void 0!==e._oldValue?this._oldValue:new Date;if(!(t instanceof Date))if("string"==typeof t){if(/^\d{1,2}:\d{1,2}$/.test(t)){const r=t.split(":");return void(e.value=new Date(a.getFullYear(),a.getMonth(),a.getDate(),parseFloat(r[0]),parseFloat(r[1])))}e.value=e._parseDateString(t,a)}else e.value=a}});