
/* Smart UI v15.2.0 (2023-04-20) 
Copyright (c) 2011-2023 jQWidgets. 
License: https://htmlelements.com/license/ */ //

Smart("smart-window",class extends Smart.ContentElement{static get properties(){return{collapsed:{value:!1,type:"boolean"},closeOnMaskClick:{value:!1,type:"boolean"},disableEscape:{value:!1,type:"boolean"},disableSnap:{value:!1,type:"boolean"},footerPosition:{value:"bottom",allowedValues:["bottom","none"],type:"string"},footerTemplate:{value:null,type:"any"},headerButtons:{value:["close","maximize","minimize"],type:"array"},headerPosition:{value:"top",allowedValues:["top","bottom","left","right","none"],type:"string"},headerTemplate:{value:null,type:"any"},disableKeyboard:{value:!1,type:"boolean"},label:{value:"",type:"string"},liveResize:{value:!1,type:"boolean"},maximized:{value:!1,type:"boolean"},modal:{value:!1,type:"boolean"},minimized:{value:!1,type:"boolean"},opened:{value:!1,type:"boolean"},pinned:{value:!1,type:"boolean"},resizeIndicator:{value:!1,type:"boolean"},resizeMode:{allowedValues:["none","horizontal","vertical","both","top","bottom","left","right"],value:"none",type:"string"},windowParent:{value:null,type:"any"}}}static get listeners(){return{"document.dragstart":"_dragStartHandler","document.focusin":"_documentFocusInEventHandler","document.move":"_documentMoveHandler","document.up":"_documentUpHandler","document.wheel":"_mouseWheelHandler","document.selectstart":"_documentSelectStartHandler",down:"_downHandler",focus:"_focusHandler",blur:"_focusHandler",move:"_moveHandler",keydown:"_keyDownHandler",keyup:"_keyUpHandler"}}get hasStyleObserver(){return!1}static get styleUrls(){return["smart.button.css","smart.window.css"]}template(){return'<div role="presentation">\n                    <div class="smart-content-container" id="container">\n                        <div id="headerSection" class="smart-header-section" role="heading" aria-level="1">\n                            <div id="header" class="smart-header" role="presentation">[[label]]</div>\n                            <div id="buttonsContainer" class="smart-buttons-container" role="presentation">\n                                <button id="pinButton" class="smart-button smart-element smart-pin-button" aria-label="Pin"></button>\n                                <button id="collapseButton" class="smart-button smart-element smart-collapse-button" aria-label="Collapse"></button>\n                                <button id="minimizeButton" class="smart-button smart-element smart-minimize-button"aria-label="Minimize"></button>\n                                <button id="maximizeButton" class="smart-button smart-element smart-maximize-button" aria-label="Maximize"></button>\n                                <button id="closeButton" class="smart-button smart-element smart-close-button" aria-label="Close"></button>\n                            </div>\n                        </div>\n                        <div class="smart-content" inner-h-t-m-l="[[innerHTML]]"><content></content></div>\n                        <div id="footer" class="smart-footer"></div>\n                    </div>\n                </div>'}propertyChangedHandler(e,t,a){const i=this;switch(e){case"collapsed":a?i.collapse(!0):i.expand(!0);break;case"disabled":case"unfocusable":i._setFocusable();break;case"headerTemplate":case"footerTemplate":i._applyLayoutTemplate(i.$[e.split(/[T]/)[0]],a);break;case"headerButtons":i._setHeaderButtons();break;case"headerPosition":{const e=i.minimized;i._preventEventFiring=!0,i.restore(),delete i._preventEventFiring,e&&i.minimize();break}case"label":i.$.header.innerHTML=i.label;break;case"maximized":a?i.maximize(!0):i.restore(e);break;case"modal":i._setModal(),i.setAttribute("aria-modal",a);break;case"minimized":a?i.minimize(!0):i.restore(e);break;case"opened":a?i.open(!0):i.close(!0);break;case"resizeMode":i.$.container.classList.remove("smart-window-resizing-bottom-right","smart-window-resizing-top-right","smart-window-resizing-top-left","smart-window-resizing-bottom-left","smart-window-resizing-top","smart-window-resizing-bottom","smart-window-resizing-left","smart-window-resizing-right");break;case"windowParent":i._setElementParent(a);break;default:super.propertyChangedHandler(e,t,a)}}ready(){super.ready(),this._windowParent={initialParent:this.parentElement}}render(){const e=this,t=e.animation;e.$.header.id||(e.$.header.id=e.id+"Header"),e.$.content.id||(e.$.content.id=e.id+"Content"),e.opened||(e.animation="none"),e._windowParent={initialParent:e.parentElement},e.$.addClass("smart-window"),e._createElement(),e._setElementParent(e.windowParent),e._setHeaderButtons(),e.headerTemplate&&e._applyLayoutTemplate(e.$.header,e.headerTemplate),e.footerTemplate&&e._applyLayoutTemplate(e.$.footer,e.footerTemplate),e.opened?e.open():e.close(),e.maximized&&e.maximize(!0),e.minimized&&e.minimize(!0),e.collapsed&&e.collapse(!0),e.pinned?e.pin():e.unpin(),e._setFocusable(),e.animation=t,e.setAttribute("aria-modal",e.modal),e.setAttribute("aria-labelledby",e.$.header.id),e._setupDismissTargets(),super.render()}refresh(){const e=this;e.headerTemplate&&e._applyLayoutTemplate(e.$.header,e.headerTemplate),e.footerTemplate&&e._applyLayoutTemplate(e.$.footer,e.footerTemplate),e.opened?e.open():e.close(),e.maximized&&e.maximize(!0),e.minimized&&e.minimize(!0),e.collapsed&&e.collapse(!0),e.pinned?e.pin():e.unpin()}static get requires(){return{"Smart.Button":"smart.button.js"}}_setFocusable(){const e=this;if(e.disabled||e.unfocusable)e.removeAttribute("tabindex");else{let t=e.tabIndex>0?e.tabIndex:0;e.setAttribute("tabindex",t)}}appendChild(e){const t=this;if(!t.isCompleted||e instanceof HTMLElement&&e.classList.contains("smart-resize-trigger-container")){const e=Array.prototype.slice.call(arguments,2);return HTMLElement.prototype.appendChild.apply(t,e.concat(Array.prototype.slice.call(arguments)))}e?t.$.content.appendChild(e):t.error(t.localize("invalidNode",{elementType:t.nodeName.toLowerCase(),method:"appendChild",node:"node"}))}updateLabel(e){this.label=e}updateContent(e){this.content=e}move(e,t){const a=this,i=e=>"number"==typeof e?e+"px":"string"==typeof e?e:void 0;void 0!==e&&(a.style.left=i(e)),void 0!==t&&(a.style.top=i(t))}collapse(e){const t=this;!e&&t.collapsed||(t.collapsed=!0,t.$.fireEvent("collapse"),"left"===t.headerPosition||"right"===t.headerPosition?t.style.width="":t.style.height="")}close(e){const t=this;if(e||!t.$.hasClass("smart-visibility-hidden")){if(t.isCompleted){if(t.$.fireEvent("closing").defaultPrevented)return;t.$.addClass("smart-visibility-hidden"),t.opened=!1,t.isRendered&&t.$.fireEvent("close")}else t.$.addClass("smart-visibility-hidden"),t.opened=!1;t._setModal(),t.removeAttribute("ontop")}}attached(){super.attached();const e=this;e.isRendered,e._windowParent.parent&&e._windowParent.parent!==e.getShadowRootOrBody()&&e._windowParent.parent.querySelectorAll("smart-window, smart-dialog-window, smart-progress-window, smart-wait-window, smart-alert-window, smart-prompt-window, smart-multiline-prompt-window")&&"static"===window.getComputedStyle(e._windowParent.parent).getPropertyValue("position")&&(e._windowParent.parent.style.position="relative"),e.opened&&e._modal&&e.parentElement.insertBefore(e._modal,e)}bringToFront(){const e=this;if(!e.parentElement)return;const t=e.parentElement.closest(".smart-window");if(t)return void t.bringToFront();const a=document.body.getElementsByClassName("smart-window");let i=[];for(let e=0;e<a.length;e++){const t=a[e];t.removeAttribute("ontop"),t.opened&&i.push(t)}1===i.length&&i[0]===e||e.setAttribute("ontop","")}clear(){const e=this;e.isCompleted&&"Smart-WINDOW"===e.nodeName&&(e.innerHTML=e.$.content.innerHTML="")}detached(){super.detached();const e=this;e._windowParent.parent&&!e._windowParent.parent.querySelectorAll("smart-window, smart-dialog-window, smart-progress-window, smart-wait-window, smart-alert-window, smart-prompt-window, smart-multiline-prompt-window")&&(e._windowParent.parent.style.position=""),e._modal&&e._modal.parentElement&&e._modal.parentElement.removeChild(e._modal),e._resizeDummy&&e._resizeDummy.parentElement&&e._handleWindowResizeDummy(),e._refreshMinimizedWindowsPosition()}expand(e){const t=this;(e||t.collapsed)&&(t.collapsed=!1,t.$.fireEvent("expand"),t.maximized?"left"===t.headerPosition||"right"===t.headerPosition?t.style.width=Math.max(t._windowParent.scrollElement.scrollWidth,t._windowParent.element.clientWidth)-t._windowParent.borderWidth+"px":t.style.height=Math.max(t._windowParent.scrollElement.scrollHeight,t._windowParent.element.clientHeight)-t._windowParent.borderWidth+"px":"left"===t.headerPosition||"right"===t.headerPosition?t.style.width=t.className.indexOf("smart-window-snapped-")<0&&t._dragDetails?t._dragDetails.width+"px":"":t.style.height=t.className.indexOf("smart-window-snapped-")<0&&t._dragDetails?t._dragDetails.height+"px":"")}maximize(e){const t=this;if(!e&&t.maximized)return;t.minimized&&t._restoreFromMinimization(e),t._setDragDetails("minimize"),"none"!==t.resizeMode&&t.$.container.classList.remove("smart-window-resizing-bottom-right","smart-window-resizing-top-right","smart-window-resizing-top-left","smart-window-resizing-bottom-left","smart-window-resizing-top","smart-window-resizing-bottom","smart-window-resizing-left","smart-window-resizing-right"),t._snapDummy&&t.$.hasClass("smart-window-snapped-"+t._snapDummy._position)&&t.classList.remove("smart-window-snapped-"+t._snapDummy._position),t.maximized=!0,t.$.fireEvent("maximize"),t.style.left=t.style.top=0,t.style.maxWidth=t.style.maxHeight="none";const a=t._windowParent.scrollElement.scrollHeight,i=t._windowParent.scrollElement.scrollWidth,n=t._windowParent.element.clientHeight,o=t._windowParent.element.clientWidth,s=Math.max(a,n),r=Math.max(i,o);"top"===t.headerPosition||"bottom"===t.headerPosition?(t.style.width=i>o?r-t._windowParent.borderWidth+"px":"100%",t.collapsed||(t.style.height=a>n?s-t._windowParent.borderWidth+"px":"100%")):(t.collapsed||(t.style.width=i>o?r-t._windowParent.borderWidth+"px":"100%"),t.style.height=a>n?s-t._windowParent.borderWidth+"px":"100%"),"100%"!==t.style.height&&t.addEventListener("transitionend",(function e(){if(!t.maximized||!t.hasAnimation)return;const a=t._windowParent.scrollElement.scrollHeight,i=t._windowParent.element.clientHeight,n=Math.max(a,i);("top"===t.headerPosition||"bottom"===t.headerPosition)&&t.collapsed||(t.style.height=a>i?n-t._windowParent.borderWidth+"px":"100%"),t.removeEventListener("transitionend",e)}))}minimize(e){const t=this;if(!e&&t.minimized)return;t.maximized&&(t._preventEventFiring=!0,t.restore(),delete t._preventEventFiring),t._setDragDetails(),t.minimized=!0,t.$.fireEvent("minimize"),t._snapDummy&&t.$.hasClass("smart-window-snapped-"+t._snapDummy._position)&&(t.$.removeClass("smart-window-snapped-"+t._snapDummy._position),t.style.right=t.style.top=t.style.left="");const a=t._getAllMinimizedWindows(t._windowParent.element);if(a.length>0){const e=a[a.length-1];t.style.left=(e.offsetLeft+e.offsetWidth+t._dragDetails.minWidth+10>t._windowParent.element.clientWidth?e.offsetLeft:e.offsetLeft+e.offsetWidth+5)+"px",t.style.top=e.offsetTop+"px"}else t.style.left="5px",t.style.top=t._windowParent.element.clientHeight+t._windowParent.scrollElement.scrollTop-t.$.headerSection.offsetHeight-5+"px";t.style.width="",t.style.height=t.$.headerSection.offsetHeight+"px"}_createElement(){this.setAttribute("role","dialog")}removeChild(e){const t=this;if(!t.isCompleted){const e=Array.prototype.slice.call(arguments,2);return HTMLElement.prototype.removeChild.apply(t,e.concat(Array.prototype.slice.call(arguments)))}e?t.$.content.removeChild(e):t.error(t.localize("invalidNode",{elementType:t.nodeName.toLowerCase(),method:"removeChild",node:"node"}))}restore(e){const t=this;if("maximized"===e||t.maximized?(t.maximized=!1,t.style.width=t.style.height=t.style.top=t.style.left=""):("minimized"===e||t.minimized)&&t._restoreFromMinimization(e),t._preventEventFiring||t.$.fireEvent("restore"),t.style.maxWidth=t.style.maxHeight="",t._dragDetails){if(t.style.left=Math.max(0,Math.min(t._dragDetails.windowX,t._windowParent.element.clientWidth-t._dragDetails.width))+"px",t.style.top=Math.max(0,Math.min(t._dragDetails.windowY,t._windowParent.scrollElement.scrollHeight-t._dragDetails.height))+"px",t.collapsed)return void("top"===t.headerPosition||"bottom"===t.headerPosition?t.style.width=t._dragDetails.width+"px":t.style.height=t._dragDetails.height+"px");t._dragDetails.resized&&(t.style.width=t._dragDetails.width+"px",t.style.height=t._dragDetails.height+"px")}}toggle(){const e=this;e.opened?e.close():e.open()}openModal(){this.modal=!0,this.open()}open(e){const t=this;if(e||t.$.hasClass("smart-visibility-hidden")){if(t.isCompleted){if(t.$.fireEvent("opening").defaultPrevented)return;t.$.removeClass("smart-visibility-hidden"),t.opened=!0,t.$.fireEvent("open")}else t.$.removeClass("smart-visibility-hidden"),t.opened=!0;t.bringToFront(),t._setModal(),t._handleActiveState(),t.hasAnimation?t.addEventListener("transitionend",a):a()}function a(e){if(!t.hasAnimation||e&&e.target===t){if(t.removeEventListener("transitionend",a),t._onOpenCallback)return void t._onOpenCallback();t.focus()}}}_setupDismissTargets(){const e=this;if(e.querySelector('[data-dismiss="modal"]')){const t=e.querySelectorAll('[data-dismiss="modal"]'),a=()=>{e.close()};for(let e=0;e<t.length;e++)t[e].removeEventListener("click",a,null),t[e].addEventListener("click",a)}}pin(){this.pinned=!0}unpin(){this.pinned=!1}_applyLayoutTemplate(e,t){const a=this;if(!t)return e.innerHTML="",void(e===a.$.header&&a.label&&(e.innerHTML=a.label));"content"in document.createElement("template")?(t instanceof HTMLTemplateElement||(t=document.getElementById(t)),null!==t&&"content"in t?(e.innerHTML="",e.appendChild(document.importNode(t.content,!0))):a.error(a.localize("invalidTemplate",{elementType:a.nodeName.toLowerCase(),property:e===a.$.footer?"footerTemplate":"headerTemplate"}))):a.error(a.localize("htmlTemplateNotSuported",{elementType:a.nodeName.toLowerCase()}))}_cancelDragging(e){const t=this;if(t._dragDetails&&t._dragDetails.started&&"drag"===t._dragDetails.type){if(!e){const a=t.getBoundingClientRect();e={pageX:a.left,pageY:a.top}}t.$.fireEvent("dragEnd",{left:e.pageX,top:e.pageY}),t.removeAttribute("dragged"),t._dragDetails.started=!1,delete t._mouseManipulation}}_documentFocusInEventHandler(e){const t=this;t._changingFocus&&(t.contains(e.target)||t.contains(e.composedPath()[0])||t.focus(),delete t._changingFocus)}_downHandler(e){const t=this;let a=Smart.Utilities.Core.isMobile?document.elementFromPoint(e.pageX-window.pageXOffset,e.pageY-window.pageYOffset):e.originalEvent.target;if((t.shadowRoot||t.isInShadowDOM)&&(a=e.originalEvent.composedPath()[0]),e.stopPropagation(),t.disabled||!Smart.Utilities.Core.isMobile&&1!==e.which)return;if(t._tabsWindow&&(t._tabsWindow._isAutoHideWindowClicked=!0),t.hasAttribute("ontop")||t.bringToFront(),a.closest&&a.closest(".smart-buttons-container")===t.$.buttonsContainer){if(t._buttonPressed=a.closest(".smart-button"),t._buttonPressed)return}else if(a.getRootNode()&&a.getRootNode().host&&(t._buttonPressed=a.getRootNode().host,t._buttonPressed.closest(".smart-buttons-container")===t.$.buttonsContainer))return;t._isWindowContentClicked=a.closest(".smart-content");let i=t.closest("smart-docking-layout");if(t.isInShadowDOM&&!i){let e=t.getRootNode().host;for(;e&&(i=e.closest("smart-docking-layout"),!i)&&e.getRootNode();)e=e.getRootNode().host}if(!(t instanceof Smart.TabsWindow&&i&&i.disabled)){if(t._handleActiveState(),!(t instanceof Smart.TabsWindow&&i))return a.closest(".smart-header-section")===t.$.headerSection&&(void 0===t._dblClickDetails&&(t._dblClickDetails={clicks:0}),clearTimeout(t._dblClickDetails.timeOut),t._dblClickDetails.clicks++,t._dblClickDetails.timeOut=setTimeout((function(){t._dblClickDetails&&(t._dblClickDetails.clicks=0)}),300),2===t._dblClickDetails.clicks)?(t._headerDblCickHandler(e),void(t._dblClickDetails.clicks=0)):void(t.maximized||(Smart.Utilities.Core.isMobile&&t._moveHandler(e),!t.pinned&&!t.minimized&&t.$.container.className.indexOf("smart-window-resizing")<0&&(a=a.closest(".smart-header-section"),a&&a===t.$.headerSection&&(t._mouseManipulation=!0,t._setDragDetails("drag",e))),"none"!==t.resizeMode&&t.$.container.className.indexOf("smart-window-resizing")>-1&&(t._mouseManipulation=!0,t._setDragDetails("resize",e))));t.$.hasClass("smart-docking-layout-auto-hide-window")&&(Smart.Utilities.Core.isMobile&&t._moveHandler(e),"none"!==t.resizeMode&&t.$.container.className.indexOf("smart-window-resizing")>-1&&(t._mouseManipulation=!0,t._setDragDetails("resize",e)))}}_documentMoveHandler(e){const t=this;!t._dragDetails||!t._dragDetails.started||t.minimized||!t._mouseManipulation||Math.abs(e.pageX-t._dragDetails.x)<=5&&Math.abs(e.pageY-t._dragDetails.y)<=5||(t.hasAttribute("dragged")||t.hasAttribute("resized")||t.$.fireEvent(t._dragDetails.type+"Start",{left:e.pageX,top:e.pageY,width:t.offsetWidth,height:t.offsetHeight}),e.stopPropagation(),"drag"!==t._dragDetails.type||t.pinned?(t._dragDetails.resized=!0,t._resize(t._dragDetails.side,e),t._dragDetails.x=Math.max(t._windowParent.offsetLeft+t._dragDetails.left,Math.min(t._windowParent.offsetLeft+t._dragDetails.left+(t._dragDetails.side.toLowerCase().indexOf("left")>-1?0:t._dragDetails.newWidth),e.pageX)),t._dragDetails.y=Math.max(t._windowParent.offsetTop+t._dragDetails.top,Math.min(t._windowParent.offsetTop+t._dragDetails.top+(t._dragDetails.side.toLowerCase().indexOf("top")>-1?0:t._dragDetails.newHeight),e.pageY))):(t.setAttribute("dragged",""),t._snapDummy&&t.$.hasClass("smart-window-snapped-"+t._snapDummy._position)&&(t.$.removeClass("smart-window-snapped-"+t._snapDummy._position),t.style.right=t.style.top=t.style.left="",t.collapsed||(t.style.height=t._dragDetails.height+"px",t.style.width=t._dragDetails.width+"px")),t._drag(e,"both"),t._dragDetails.x=Math.max(t._windowParent.offsetLeft+t._dragDetails.offsetX-t._windowParent.scrollElement.scrollLeft,Math.min(t._windowParent.offsetLeft+t._windowParent.element.offsetWidth-(t._windowParent.element.offsetWidth-t.offsetLeft)+t._dragDetails.offsetX,e.pageX)),t._dragDetails.y=Math.max(t._windowParent.offsetTop+t._dragDetails.offsetY-t._windowParent.scrollElement.scrollTop,Math.min(t._windowParent.offsetTop+t._windowParent.element.offsetHeight-(t._windowParent.element.offsetHeight-t.offsetTop)+t._dragDetails.offsetY,e.pageY)),e.pageX>=t._windowParent.offsetLeft+t._windowParent.scrollElement.scrollWidth-1?t._handleSnapping("right"):e.pageY<=t._windowParent.offsetTop?t._handleSnapping("top"):e.pageX<=t._windowParent.offsetLeft?t._handleSnapping("left"):t._handleSnapping()))}_documentUpHandler(e){const t=this,a=t.shadowRoot||t.isInShadowDOM?e.originalEvent.composedPath()[0]:e.originalEvent.target;if(t.disabled)return t.removeAttribute("active"),delete t._buttonPressed,void delete t._isWindowContentClicked;if(t._dragDetails&&t._dragDetails.started&&(t.hasAttribute("resized")&&(t.$.fireEvent(t._dragDetails.type+"End",{left:e.pageX,top:e.pageY,width:t._dragDetails.newWidth,height:t._dragDetails.newHeight}),t.removeAttribute("resized"),t._handleWindowResizeDummy(),t.$.container.classList.remove("smart-window-resizing-bottom-right","smart-window-resizing-top-right","smart-window-resizing-top-left","smart-window-resizing-bottom-left","smart-window-resizing-top","smart-window-resizing-bottom","smart-window-resizing-left","smart-window-resizing-right")),setTimeout((function(){t.$.removeClass("no-transition")}),20),t.hasAttribute("dragged")&&(t.$.fireEvent(t._dragDetails.type+"End",{left:e.pageX,top:e.pageY}),t.removeAttribute("dragged")),t._dragDetails.started=!1,delete t._mouseManipulation),t._snapDummy&&!t._snapDummy.classList.contains("smart-visibility-hidden")){switch(t._snapDummy._position){case"left":case"top":t.style.left=t.style.top="0",t.style.right="auto";break;case"right":t.style.left="auto",t.style.top=t.style.right="0"}t.style.width="top"===t._snapDummy._position?"100%":"50%",t.style.height="100%",t.$.addClass("smart-window-snapped-"+t._snapDummy._position),t._handleSnapping()}t._modal&&a===t._modal&&!t._isWindowContentClicked&&(t.closeOnMaskClick?t.close():t.focus()),t._isWindowButton(a)&&t.focus(),delete t._isWindowContentClicked,delete t._buttonPressed;const i=t.shadowRoot&&t._windowParent.element&&t._windowParent.element.getRootNode()?t._windowParent.element.getRootNode().activeElement:document.activeElement;if(!t.hasAttribute("active")||i===t)return;if(!a.closest)return;let n=a.closest(".smart-window");for(;n&&n!==t;)n=n.parentElement,n&&(n=n.closest(".smart-window"));t.opened&&n!==t&&t.removeAttribute("active")}_documentSelectStartHandler(e){this._dragDetails&&this._dragDetails.started&&e.preventDefault()}_drag(e,t){const a=this;if(!e||a.pinned||a.maximized)return;let i,n;a._dragDetails&&a._dragDetails.started||a._setDragDetails("drag",e),a.$.addClass("no-transition"),"object"==typeof e?(i=e.pageX-a._dragDetails.x,n=e.pageY-a._dragDetails.y):i=n=e;const o=Math.max(a._windowParent.element.clientHeight,a._windowParent.scrollElement.scrollHeight),s=Math.max(a._windowParent.element.clientWidth,a._windowParent.scrollElement.scrollWidth);switch(t){case"horizontal":a._dragDetails.windowX=Math.max(0,Math.min(a._dragDetails.windowX+i,s-a.offsetWidth)),a.style.left=a._dragDetails.windowX+"px";break;case"vertical":a._dragDetails.windowY=Math.max(0,Math.min(a._dragDetails.windowY+n,o-a.offsetHeight)),a.style.top=a._dragDetails.windowY+"px";break;case"both":a._dragDetails.windowX=Math.max(0,Math.min(a._dragDetails.windowX+i,s-a.offsetWidth)),a._dragDetails.windowY=Math.max(0,Math.min(a._dragDetails.windowY+n,o-a.offsetHeight)),a.style.left=a._dragDetails.windowX+"px",a.style.top=a._dragDetails.windowY+"px"}a._dragDetails.top=a.offsetTop,a._dragDetails.left=a.offsetLeft}_dragStartHandler(e){this._dragDetails&&this._dragDetails.started&&e.preventDefault()}_focusHandler(e){const t=this;"focus"===e.type?(t.setAttribute("focus",""),t.bringToFront()):t._buttonPressed||(t.removeAttribute("focus"),t._dragDetails&&t._dragDetails.started&&t._handleWindowResizeDummy())}_getAllMinimizedWindows(e){const t=this;let a=[];e||(e=t._windowParent.element);const i=e.querySelectorAll("smart-window");for(let e=0;e<i.length;e++)i[e]!==t&&i[e].hasAttribute("minimized")&&a.push(i[e]);return a.sort((function(e,t){let a=e.getBoundingClientRect(),i=t.getBoundingClientRect();return a.right-i.right})),a}_handleSnapping(e){const t=this;e?t.disableSnap||t.collapsed||(t._snapDummy||(t._snapDummy=document.createElement("div"),t._snapDummy.addEventListener("transitionend",(function(){t._snapDummy.classList.contains("smart-visibility-hidden")&&t._snapDummy.parentElement&&t._snapDummy.parentElement.removeChild(t._snapDummy)}))),t._snapDummy.className="smart-window-snap-"+e+"-feedback",t._snapDummy._position=e,t._snapDummy.parentElement||t._windowParent.element.appendChild(t._snapDummy)):t._snapDummy&&t._snapDummy.parentElement&&t._snapDummy.classList.add("smart-visibility-hidden")}_headerDblCickHandler(e){const t=this,a=t.shadowRoot||t.isInShadowDOM?e.originalEvent.composedPath()[0]:e.originalEvent.target;a!==t.$.headerSection&&a!==t.$.header||t.$.maximizeButton&&0===t.$.maximizeButton.offsetHeight||(t.maximized?t.restore():t.maximize())}_isWindowButton(e){const t=this;for(;e&&(e.closest&&e.closest(".smart-buttons-container"))!==t.$.buttonsContainer;)e=e.getRootNode().host;if(!e)return;const a=/smart-(\w+[-]*\w*)-button/gi;if((e=e.closest(".smart-button"))&&e===t._buttonPressed)switch(e){case t.$.closeButton:return t.close(),!0;case t.$.collapseButton:return t.collapsed?t.expand():t.collapse(),!0;case t.$.maximizeButton:return t.maximized?t.restore():t.maximize(),!0;case t.$.minimizeButton:return t.minimized?t.restore():t.minimize(),!0;case t.$.pinButton:return t.pinned?t.unpin():t.pin(),!0;default:if(!a.test(e.className))return;return t.$.fireEvent(Smart.Utilities.Core.toCamelCase(e.className.match(a).toString().replace("smart-","").replace("-button","")),{button:e}),!0}}_keyDownHandler(e){const t=this;if(delete t._changingFocus,t.disabled||(t.hasAttribute("dragged")||t.hasAttribute("resized"))&&t._mouseManipulation)return;const a="ArrowDown"===e.key||"ArrowRight"===e.key?10:-10,i=t.enableShadowDOM&&t._windowParent.element.getRootNode()?t._windowParent.element.getRootNode().activeElement:document.activeElement;if(!t.disableKeyboard)switch(e.key){case"ArrowUp":case"ArrowDown":case"ArrowLeft":case"ArrowRight":{if(t.minimized||i!==t)return;let n=e.key.indexOf("Right")>-1||e.key.indexOf("Left")>-1;e.preventDefault();const o=(t.isInShadowDOM?t.getRootNode().host:t).closest("smart-docking-layout");if(!n&&e.altKey&&!(t instanceof Smart.TabsWindow&&o))return void("ArrowUp"===e.key?t.maximize():t.restore());if(t.maximized)return;if(t.$.addClass("no-transition"),e.ctrlKey&&"none"!==t.resizeMode&&!t.collapsed)return n=-1===["horizontal","vertical","both"].indexOf(t.resizeMode)?t.resizeMode:n?"right":"bottom",t.hasAttribute("dragged")&&t._cancelDragging(e),t.hasAttribute("resized")||t.$.fireEvent("resizeStart",{position:{x:e.pageX,y:e.pageY}}),void t._resize(n,a);t.pinned||(t.hasAttribute("dragged")||(t.setAttribute("dragged",""),t.$.fireEvent("dragStart",{left:e.pageX,top:e.pageY})),t._drag(a,n?"horizontal":"vertical")),t.$.removeClass("no-transition");break}case"Escape":t.disableEscape||t.headerButtons.indexOf("close")>-1&&t.close();break;case"p":e.altKey&&t.headerButtons.indexOf("pin")>-1&&(t.pinned?t.unpin():t.pin());break;case"c":e.altKey&&t.headerButtons.indexOf("collapse")>-1&&(t.collapsed?t.expand():t.collapse());break;case"m":e.altKey&&t.headerButtons.indexOf("minimize")>-1&&(t.minimized?t.restore():t.minimize());break;case"Tab":t.opened&&t.modal&&(t._changingFocus=!0);break;case"Enter":case" ":{let a;if(t.shadowRoot||t.isInShadowDOM?(a=e.composedPath()[0],t._buttonPressed=a.getRootNode().host):(a=e.target.closest&&e.target.closest(".smart-button"),t._buttonPressed=a),!a)return;t._isWindowButton(a),delete t._buttonPressed;break}}}_keyUpHandler(e){const t=this;if(e.key&&!t.disableKeyboard){if("Control"===e.key&&t._dragDetails&&t.hasAttribute("resized")&&!t._mouseManipulation){if(!t._dragDetails.started)return;"drag"!==t._dragDetails.type&&(t.removeAttribute("resized"),t.$.fireEvent("resizeEnd",{left:e.pageX,top:e.pageY,width:t._dragDetails.newWidth,height:t._dragDetails.newHeight}),t._handleWindowResizeDummy()),t._dragDetails.started=!1}e.key.indexOf("Arrow")>-1&&t.hasAttribute("dragged")&&!t._mouseManipulation&&t._cancelDragging(e)}}_mouseWheelHandler(e){const t=this;!t.disabled&&t._dragDetails&&t._dragDetails.started&&(e.deltaY<0&&t._windowParent.scrollElement.scrollTop+e.deltaY<=0?t.style.top=Math.max(0,t._dragDetails.windowY)+"px":e.deltaY>0&&(t._dragDetails.windowY+t.offsetHeight+e.deltaY>=t._windowParent.scrollElement.scrollHeight||t._windowParent.scrollElement.scrollTop+t._windowParent.element.clientHeight===t._windowParent.scrollElement.scrollHeight)||("drag"===t._dragDetails.type?(t._dragDetails.windowY+=e.deltaY,t.style.top=t._dragDetails.windowY+"px"):(t._dragDetails.height+=e.deltaY,t.style.height=t._dragDetails.height+"px")))}_moveHandler(e){const t=this;if(!(t.disabled||t.collapsed||t.maximized||t.minimized||(Smart.Utilities.Core.isMobile&&navigator.platform&&/iPad|iPhone|iPod/.test(navigator.platform)&&t.hasAttribute("dragged")&&e.originalEvent.preventDefault(),t._mouseManipulation||(t.$.container.className.indexOf("smart-window-resizing")>-1&&t.$.container.classList.remove("smart-window-resizing-bottom-right","smart-window-resizing-top-right","smart-window-resizing-top-left","smart-window-resizing-bottom-left","smart-window-resizing-top","smart-window-resizing-bottom","smart-window-resizing-left","smart-window-resizing-right"),"none"===t.resizeMode)))){const a=t.getBoundingClientRect(),i=e.clientY<a.top+10,n=e.clientY>a.bottom-10,o=e.clientX>a.right-10,s=e.clientX<a.left+10;switch(t.resizeMode){case"none":break;case"both":if(t.resizeIndicator)return void(n&&o&&t.$.container.classList.add("smart-window-resizing-bottom-right"));if(s||o)return i?void t.$.container.classList.add("smart-window-resizing-top-"+(s?"left":"right")):n?void t.$.container.classList.add("smart-window-resizing-bottom-"+(s?"left":"right")):void t.$.container.classList.add("smart-window-resizing-"+(s?"left":"right"));if(i||n){if(o)return void t.$.container.classList.add("smart-window-resizing-"+(i?"top-right":"bottom-right"));if(s)return void t.$.container.classList.add("smart-window-resizing-"+(i?"top-left":"bottom-left"));t.$.container.classList.add("smart-window-resizing-"+(i?"top":"bottom"))}break;case"horizontal":if(t.resizeIndicator)return void(n&&o&&t.$.container.classList.add("smart-window-resizing-right"));if(s)return void t.$.container.classList.add("smart-window-resizing-left");o&&t.$.container.classList.add("smart-window-resizing-right");break;case"vertical":if(t.resizeIndicator)return void(n&&o&&t.$.container.classList.add("smart-window-resizing-bottom"));if(i)return void t.$.container.classList.add("smart-window-resizing-top");n&&t.$.container.classList.add("smart-window-resizing-bottom");break;case"top":if(i){if(t.resizeIndicator&&!s)return;t.$.container.classList.add("smart-window-resizing-top")}break;case"bottom":if(n){if(t.resizeIndicator&&!o)return;t.$.container.classList.add("smart-window-resizing-bottom")}break;case"left":if(s){if(t.resizeIndicator&&!i)return;t.$.container.classList.add("smart-window-resizing-left")}break;case"right":if(o){if(t.resizeIndicator&&!n)return;t.$.container.classList.add("smart-window-resizing-right")}}}}_handleActiveState(){const e=this,t=document.querySelectorAll(".smart-window");for(let a=0;a<t.length;a++)t[a].contains(e)||e.contains(t[a])||(t[a].removeAttribute("active"),t[a].removeAttribute("focus"));e.setAttribute("active","")}_handleWindowResizeDummy(){const e=this;if(e._resizeDummy||(e._resizeDummy=document.createElement("div"),e._resizeDummy.classList.add("smart-window-resize-feedback")),!e.hasAttribute("resized"))return e._resizeDummy&&e._resizeDummy.remove(),void(!e.liveResize&&"resize"===e._dragDetails.type&&e._dragDetails.started&&(e.style.top=e._dragDetails.top+"px",e.style.left=e._dragDetails.left+"px",e.style.width=e._dragDetails.newWidth+"px",e.style.height=e._dragDetails.newHeight+"px"));e._resizeDummy.parentElement||e._resizeDummy.getRootNode().host||(e._resizeDummy.style.width=e.offsetWidth+"px",e._resizeDummy.style.height=e.offsetHeight+"px",e._resizeDummy.style.top=e.offsetTop+"px",e._resizeDummy.style.left=e.offsetLeft+"px",e._windowParent.element.appendChild(e._resizeDummy))}_resize(e,t){const a=this;let i;if((!a._dragDetails||a._dragDetails&&"drag"===a._dragDetails.type)&&a._setDragDetails("resize"),!a._dragDetails)return;a._dragDetails.started=!0,a.hasAttribute("resized")||(a.setAttribute("resized",""),a.hasAnimation&&a.$.addClass("no-transition")),a.liveResize||a._handleWindowResizeDummy();const n=a._snapDummy&&a.$.hasClass("smart-window-snapped-"+a._snapDummy._position)?"snapWindowWidth":"width";switch(e){case"left":i="object"==typeof t?t.pageX-a._dragDetails.x:t,i=i>0?Math.min(i,a._dragDetails[n]-a._dragDetails.minWidth):-1*Math.min(a._dragDetails.maxWidth?a._dragDetails.maxWidth-a._dragDetails[n]:a._dragDetails.left,Math.abs(i)),a._dragDetails[n]=Math.min(a._dragDetails[n]+a._dragDetails.left-a._windowParent.scrollElement.scrollLeft,a._dragDetails[n]-i),a._dragDetails.windowX=Math.max(a._windowParent.scrollElement.scrollLeft,a._dragDetails.windowX+i),"object"!=typeof t&&(a._dragDetails[n]=Math.max(a._dragDetails[n],a._dragDetails.minWidth)),a._dragDetails[n]>=a._dragDetails.minWidth&&(a._dragDetails.left=a._dragDetails.windowX,a._dragDetails.newWidth=a._dragDetails[n]);break;case"right":{const e=a._windowParent.element.clientWidth!==a._windowParent.element.offsetWidth?a._windowParent.borderWidth:0,n=a._snapDummy&&a.$.hasClass("smart-window-snapped-"+a._snapDummy._position)?"snapWindowWidth":"width";i="object"==typeof t?t.pageX-a._dragDetails.x:t,i>0&&a._dragDetails.maxWidth&&(i=Math.min(a._dragDetails.maxWidth-a._dragDetails[n],i)),a._dragDetails[n]=Math.min(a._windowParent.element.clientWidth+a._windowParent.scrollElement.scrollLeft-a._dragDetails.left-e,Math.max(0,a._dragDetails[n]+i)),"object"!=typeof t&&(a._dragDetails[n]=Math.max(a._dragDetails[n],a._dragDetails.minWidth)),a._dragDetails.left=a.offsetLeft,a._dragDetails.newWidth=Math.max(a._dragDetails.minWidth,a._dragDetails[n]);break}case"top":a._snapDummy&&a.$.hasClass("smart-window-snapped-"+a._snapDummy._position)&&(a._dragDetails.height=a._dragDetails.snapWindowHeight),i="object"==typeof t?t.pageY-a._dragDetails.y:t,i=i>0?Math.min(i,a._dragDetails.height-a._dragDetails.minHeight):-1*Math.min(a._dragDetails.maxHeight?a._dragDetails.maxHeight-a._dragDetails.height:a._dragDetails.top,Math.abs(i)),a._dragDetails.snapWindowHeight=a._dragDetails.height=Math.min(a._dragDetails.height+a._dragDetails.top-a._windowParent.scrollElement.scrollTop,a._dragDetails.height-i),a._dragDetails.windowY=Math.max(a._windowParent.scrollElement.scrollTop,a._dragDetails.windowY+i),"object"!=typeof t&&(a._dragDetails.snapWindowHeight=a._dragDetails.height=Math.max(a._dragDetails.height,a._dragDetails.minHeight)),a._dragDetails.height>=a._dragDetails.minHeight&&(a._dragDetails.top=a._dragDetails.windowY,a._dragDetails.newHeight=a._dragDetails.height),a._dragDetails.newWidth=Math.max(a._dragDetails[n],a._dragDetails.newWidth);break;case"bottom":a._snapDummy&&a.$.hasClass("smart-window-snapped-"+a._snapDummy._position)&&(a._dragDetails.height=a._dragDetails.snapWindowHeight),i="object"==typeof t?t.pageY-a._dragDetails.y:t,i>0&&a._dragDetails.maxHeight&&(i=Math.min(a._dragDetails.maxHeight-a._dragDetails.height,i)),a._dragDetails.snapWindowHeight=a._dragDetails.height=Math.min(a._windowParent.element.clientHeight+a._windowParent.scrollElement.scrollTop-a._dragDetails.top-a._windowParent.borderWidth,Math.max(0,a._dragDetails.height+i)),"object"!=typeof t&&(a._dragDetails.snapWindowHeight=a._dragDetails.height=Math.max(a._dragDetails.height,a._dragDetails.minHeight)),a._dragDetails.newHeight=Math.max(a._dragDetails.minHeight,a._dragDetails.height),a._dragDetails.newWidth=Math.max(a._dragDetails[n],a._dragDetails.newWidth);break;case"bottomLeftCorner":a._resize("bottom",t),a._resize("left",t);break;case"bottomRightCorner":a._resize("bottom",t),a._resize("right",t);break;case"topLeftCorner":a._resize("top",t),a._resize("left",t);break;case"topRightCorner":a._resize("top",t),a._resize("right",t)}const o=a.liveResize?a:a._resizeDummy;a._dragDetails.newHeight=Math.max(a._dragDetails.snapWindowHeight,a._dragDetails.newHeight),o.style.top=a._dragDetails.top+"px",o.style.left=a._dragDetails.left+"px",o.style.width=a._dragDetails.newWidth+"px",o.style.height=a._dragDetails.newHeight+"px"}_restoreFromMinimization(){const e=this;e.minimized=!1,e.style.width=e.style.height=e.style.top=e.style.left="",e._refreshMinimizedWindowsPosition()}_refreshMinimizedWindowsPosition(){const e=this,t=e._getAllMinimizedWindows();if(0===t.length)return;let a;t[0].style.left="5px";for(let i=1;i<t.length;i++)parseFloat(t[i-1].style.left)+t[i-1].offsetWidth+t[i].offsetWidth+10<e._windowParent.element.clientWidth?(t[i].style.left=parseFloat(t[i-1].style.left)+t[i-1].offsetWidth+5+"px",t[i].style.top=t[i-1].offsetTop+"px",a=t[i]):(t[i].style.left=parseFloat(a.style.left)+"px",t[i].style.top=a.offsetTop+"px")}_setHeaderButtons(){const e=this,t=e.headerButtons,a=e.$.buttonsContainer.children,i=function(t){const a=e.$.buttonsContainer.getElementsByClassName("smart-"+(t+"").split(/(?=[A-Z])/).join("-").toLowerCase()+"-button")[0];return a&&a.classList.remove("smart-hidden"),a};for(let e=0;e<a.length;e++)a[e].classList.add("smart-hidden");if(t.length>0)for(let a=0;a<t.length;a++){let n=i(t[a]);if(!n){const e=(t[a]+"").split(/(?=[A-Z])/);n=document.createElement("button"),n.setAttribute("aria-label",e.map((e=>e.slice(0,1).toUpperCase()+e.slice(1))).join(" ")),n.classList.add("smart-"+e.join("-").toLowerCase()+"-button","smart-button","smart-element")}e.$.buttonsContainer.insertBefore(n,e.$.buttonsContainer.firstElementChild)}}_setDragDetails(e,t){const a=this;if(a._dragDetails||(a._dragDetails={}),void 0===a._dragDetails.minWidth||void 0===a._dragDetails.minHeight||void 0===a._dragDetails.maxWidth||void 0===a._dragDetails.maxHeight){const e=getComputedStyle(a);a._dragDetails.minWidth=parseFloat(e.getPropertyValue("min-width"))||0,a._dragDetails.minHeight=parseFloat(e.getPropertyValue("min-height"))||0,a._dragDetails.maxWidth=parseFloat(e.getPropertyValue("max-width"))||0,a._dragDetails.maxHeight=parseFloat(e.getPropertyValue("max-height"))||0}a._dragDetails.windowX=a.offsetLeft,a._dragDetails.windowY=a.offsetTop;const i=a.getBoundingClientRect();if(a._snapDummy&&a.$.hasClass("smart-window-snapped-"+a._snapDummy._position))"right"===a.headerPosition&&a.collapsed&&(a._dragDetails.offsetX=i.left+a.offsetWidth-t.clientX);else{const n=a.parentElement===document.body?document.documentElement.getBoundingClientRect():a.parentElement?a.parentElement.getBoundingClientRect():document.documentElement.getBoundingClientRect(),o=window.scrollX||window.pageXOffset,s=window.scrollY||window.pageYOffset;a._windowParent.offsetLeft=n.left+o,a._windowParent.offsetTop=n.top+s,t&&"object"==typeof t&&(a._dragDetails.offsetX=t.clientX-i.left,a._dragDetails.offsetY=t.clientY-i.top),a.collapsed||(a.hasAnimation&&"minimize"===e?(a._dragDetails.width=a._dragDetails.width?a._dragDetails.width:a.offsetWidth,a._dragDetails.height=a._dragDetails.height?a._dragDetails.height:a.offsetHeight):(a._dragDetails.width=a.offsetWidth,a._dragDetails.height=a.offsetHeight),(a.style.width||a.style.height)&&(a._dragDetails.resized=!0))}if("minimize"!==e&&e&&(a._dragDetails.type=e,a._dragDetails.started=!0,a._dragDetails.snapWindowWidth=a.offsetWidth,a._dragDetails.snapWindowHeight=a.offsetHeight,t&&"object"==typeof t?(a._dragDetails.x=t.pageX,a._dragDetails.y=t.pageY):(a._dragDetails.x=a.offsetLeft,a._dragDetails.y=a.offsetTop),"resize"===e)){if("none"===a.resizeMode)return void delete a._dragDetails;a._dragDetails.top=a.offsetTop,a._dragDetails.left=a.offsetLeft,a._dragDetails.newWidth=a._dragDetails.width,a._dragDetails.newHeight=a._dragDetails.height,a.$container.hasClass("smart-window-resizing-right")?a._dragDetails.side="right":a.$container.hasClass("smart-window-resizing-left")?a._dragDetails.side="left":a.$container.hasClass("smart-window-resizing-top")?a._dragDetails.side="top":a.$container.hasClass("smart-window-resizing-bottom")?a._dragDetails.side="bottom":a.$container.hasClass("smart-window-resizing-top-left")?a._dragDetails.side="topLeftCorner":a.$container.hasClass("smart-window-resizing-bottom-left")?a._dragDetails.side="bottomLeftCorner":a.$container.hasClass("smart-window-resizing-top-right")?a._dragDetails.side="topRightCorner":a.$container.hasClass("smart-window-resizing-bottom-right")&&(a._dragDetails.side="bottomRightCorner")}}_setElementParent(e){const t=this;if(t._windowParent.element=void 0,t._windowParent.parent&&!t._windowParent.parent.querySelectorAll("smart-window, smart-dialog-window, smart-progress-window, smart-wait-window, smart-alert-window, smart-prompt-window, smart-multiline-prompt-window")&&(t._windowParent.parent.style.position=""),e instanceof HTMLElement)t._windowParent.element=e;else if("string"==typeof e)if("body"===e){const e=t.getRootNode();t._windowParent.element=e&&e.host?t.getShadowRootOrBody():document.body}else t._windowParent.element=document.getElementById(e);if(t._windowParent.element||(t._windowParent.initialParent?t._windowParent.element=t._windowParent.initialParent.parentElement?t._windowParent.initialParent:t.getShadowRootOrBody():t._windowParent.element=t.getShadowRootOrBody()),t.parentElement!==t._windowParent.element&&t._windowParent.element.appendChild(t),t._windowParent.element===document.body)t._windowParent.element=document.documentElement,t._windowParent.scrollElement=document.scrollingElement,t._windowParent.parent=document.body,t._windowParent.borderWidth=0;else{if(t.parentElement instanceof Smart.Window&&!t.parentElement.isCompleted)return void t.parentElement.whenRendered((function(){t.parentElement.appendChild(t),t._setElementParent(t.windowParent)}));t._windowParent.element instanceof Smart.Window&&(t._windowParent.element=t._windowParent.element.$.content);const e=getComputedStyle(t.parentElement),a=e.getPropertyValue("position");t._windowParent.borderWidth=2*parseInt(e.getPropertyValue("border-width")||0),t._windowParent.parent=t.parentElement,t._windowParent.scrollElement=t._windowParent.element,"static"===a&&(t.parentElement.style.position="relative")}t._setModal(),t.style.left&&t.offsetLeft>t._windowParent.scrollElement.scrollWidth&&(t.style.left=t._windowParent.scrollElement.scrollWidth-t.offsetWidth+"px"),t.style.top&&t.offsetTop>t._windowParent.scrollElement.scrollHeight&&(t.style.top=t._windowParent.scrollElement.scrollHeight-t.offsetHeight+"px")}_setModal(){const e=this;if(e._windowParent&&(delete e._changingFocus,e._windowParent.element))if(e.modal)if(e._modal||(e._modal=document.createElement("div"),e._modal.classList.add("smart-modal")),e._windowParent.parent!==document.body?e._modal.setAttribute("nested-modal",""):e._modal.removeAttribute("nested-modal"),e._modal._window=e,e.opened&&!e._modal.parentElement){const t=parseInt(getComputedStyle(e).getPropertyValue("z-index"));isNaN(t)||(e._modal.style.zIndex=t-1),e.parentElement.insertBefore(e._modal,e)}else e._modal.parentElement&&e._modal.parentElement.removeChild(e._modal);else e._modal&&e._modal.parentElement&&(e._modal.parentElement.removeChild(e._modal),delete e._modal)}}),Smart("smart-dialog-window",class extends Smart.Window{static get properties(){return{cancelLabel:{value:"Cancel",type:"string"},confirmLabel:{value:"Ok",type:"string"},disableSnap:{value:!0,readOnly:!0,type:"boolean"},headerButtons:{value:["close"],type:"array"},modal:{value:!0,readOnly:!0,type:"boolean",defaultReflectToAttribute:!0}}}static get listeners(){return{"footer.click":"_footerClickHandler"}}template(){return'<div role="presentation">\n                    <div class="smart-content-container" id="container">\n                        <div id="headerSection" class="smart-header-section" role="heading" aria-level="1">\n                            <div id="header" class="smart-header">[[label]]</div>\n                            <div id="buttonsContainer" class="smart-buttons-container">\n                                <button id="pinButton" class="smart-pin-button" aria-label="Pin"></button>\n                                <button id="collapseButton" class="smart-button smart-element smart-collapse-button" aria-label="Collapse"></button>\n                                <button id="minimizeButton" class="smart-button smart-element smart-minimize-button" aria-label="Minimize"></button>\n                                <button id="maximizeButton" class="smart-button smart-element smart-maximize-button" aria-label="Maximize"></button>\n                                <button id="closeButton" class="smart-button smart-element smart-close-button" aria-label="Close"></button>\n                            </div>\n                        </div>\n                        <div class="smart-content">\n                            <content></content>\n                        </div>\n                        <div id="footer" class="smart-footer">\n                            <button id="confirmButton" class="smart-button smart-element smart-confirm-button">[[confirmLabel]]</button>\n                            <button id="cancelButton" class="smart-button smart-element smart-cancel-button">[[cancelLabel]]</button>\n                        </div>\n                    </div>\n                </div>'}_createElement(){const e=this;e.setAttribute("role","alertdialog"),e.setAttribute("aria-describedby",e.$.content.id)}_footerClickHandler(e){const t=this,a=e.target;a.closest(".smart-confirm-button")?t.$.fireEvent("confirm"):a.closest(".smart-cancel-button")&&t.$.fireEvent("cancel")}_keyDownHandler(e){const t=this;if(delete t._changingFocus,t.disabled||(t.hasAttribute("dragged")||t.hasAttribute("resized"))&&t._mouseManipulation)return;if(t.disableKeyboard)return;e.stopPropagation();const a="ArrowDown"===e.key||"ArrowRight"===e.key?10:-10,i=t.enableShadowDOM&&t._windowParent.element.getRootNode()?t._windowParent.element.getRootNode().activeElement:document.activeElement;switch(e.key){case"ArrowUp":case"ArrowDown":case"ArrowLeft":case"ArrowRight":{if(t.minimized||i!==t)return;const n=e.key.indexOf("Right")>-1||e.key.indexOf("Left")>-1;if(e.preventDefault(),!n&&e.altKey)return void("ArrowUp"===e.key?t.maximize():t.restore());if(t.$.addClass("no-transition"),t.maximized)return;if(e.ctrlKey&&"none"!==t.resizeMode)return t.hasAttribute("dragged")&&t._cancelDragging(e),t.hasAttribute("resized")||t.$.fireEvent("resizeStart",{position:{x:e.pageX,y:e.pageY}}),void t._resize(n?"right":"bottom",a);t.pinned||(t.hasAttribute("dragged")||(t.setAttribute("dragged",""),t.$.fireEvent("dragStart",{left:e.pageX,top:e.pageY})),t._drag(a,n?"horizontal":"vertical")),t.$.removeClass("no-transition");break}case"Escape":t.disableEscape||t.headerButtons.indexOf("close")>-1&&t.close();break;case"Tab":t.opened&&t.modal&&(t._changingFocus=!0);break;case"Enter":case" ":{let a;if(t.shadowRoot||t.isInShadowDOM?(a=e.composedPath()[0],t._buttonPressed=a.getRootNode().host):(a=e.target.closest&&e.target.closest(".smart-button"),t._buttonPressed=a),!a)return;t._isWindowButton(a),delete t._buttonPressed;break}}}}),Smart("smart-alert-window",class extends Smart.DialogWindow{static get properties(){return{headerButtons:{value:[],type:"array"}}}_createElement(){const e=this;e.setAttribute("role","alertdialog"),e.setAttribute("aria-describedby",e.$.content.id)}}),Smart("smart-prompt-window",class extends Smart.DialogWindow{static get properties(){return{autoComplete:{allowedValues:["none","manual","auto","inline"],type:"string",value:"manual"},confirmLabel:{value:"Ok",type:"string"},cancelLabel:{value:"Cancel",type:"string"},disableSnap:{value:!0,readOnly:!0,type:"boolean"},displayMode:{value:"default",allowedValues:["default","escaped"],type:"string"},headerButtons:{value:["close"],type:"array"},form:{value:"",type:"string"},hint:{value:null,type:"any?"},maxLength:{value:null,type:"number?"},minLength:{value:2,type:"number"},messages:{extend:!0,value:{en:{missingReference:"{{elementType}}: Missing reference to {{files}}."}},type:"object"},modal:{value:!0,readOnly:!0,type:"boolean",defaultReflectToAttribute:!0},name:{value:"",type:"string"},placeholder:{value:"",type:"string"},promptLabel:{value:"",type:"string?"},required:{value:!1,type:"boolean"},requiredMessage:{value:"",type:"string"},selectAllOnFocus:{value:!1,type:"boolean"},value:{value:"",type:"string"}}}template(){return'<div role="presentation">\n                    <div class="smart-content-container" id="container">\n                        <div id="headerSection" class="smart-header-section" role="heading" aria-level="1">\n                            <div id="header" class="smart-header">[[label]]</div>\n                            <div id="buttonsContainer" class="smart-buttons-container">\n                                <button id="closeButton" class="smart-button smart-element smart-close-button" aria-label="Close"></button>\n                            </div>\n                        </div>\n                        <div class="smart-content">\n                            <content></content>\n                            <smart-text-box id="textBox"\n                                animation="[[animation]]"\n                                auto-complete="[[autoComplete]]"\n                                max-length="[[maxLength]]"\n                                value="{{value}}"\n                                form="[[form]]"\n                                label="[[promptLabel]]"\n                                hint="[[hint]]"\n                                display-mode="[[displayMode]]"\n                                max-length="[[maxLength]]"\n                                placeholder="[[placeholder]]"\n                                required="[[required]]"\n                                required-message="[[requiredMessage]]"\n                                select-all-on-focus="[[selectAllOnFocus]]"\n                                theme="[[theme]]"\n                                right-to-left="[[rightToLeft]]">\n                            </smart-text-box>\n                        </div>\n                        <div id="footer" class="smart-footer">\n                            <button id="confirmButton" class="smart-button smart-element smart-confirm-button flat">[[confirmLabel]]</button>\n                            <button id="cancelButton" class="smart-button smart-element smart-cancel-button flat">[[cancelLabel]]</button>\n                        </div>\n                    </div>\n                </div>'}static get listeners(){return{"footer.click":"_footerClickHandler"}}static get requires(){return{"Smart.TextBox":"smart.textbox.js"}}_footerClickHandler(e){const t=this,a=e.target;a.closest(".smart-confirm-button")?t.$.fireEvent("confirm",{value:t.$.textBox.value}):a.closest(".smart-cancel-button")&&t.$.fireEvent("cancel",{value:t.$.textBox.value})}_keyDownHandler(e){const t=this;function a(){t._dragDetails&&(t._dragDetails.started=!1),t.$.removeClass("no-transition")}if(delete t._changingFocus,t.disabled||t._dragDetails&&t._dragDetails.started)return;if(t.disableKeyboard)return;e.stopPropagation();const i="ArrowDown"===e.key||"ArrowRight"===e.key?10:-10,n=t.enableShadowDOM&&t._windowParent.element.getRootNode()?t._windowParent.element.getRootNode().activeElement:document.activeElement;switch(t.$.removeClass("no-transition"),e.key){case"ArrowUp":case"ArrowDown":if(n!==t)return;if(e.preventDefault(),e.altKey)return"ArrowUp"===e.key?t.maximize():t.restore(),void a();if(t.$.addClass("no-transition"),e.ctrlKey)return t._resize("bottom",i),void a();t._drag(i,"vertical");break;case"ArrowLeft":case"ArrowRight":if(n!==t)return;if(e.preventDefault(),t.$.addClass("no-transition"),e.ctrlKey)return t._resize("right",i),void a();t._drag(i,"horizontal"),t.$.removeClass("no-transition");break;case"Escape":t.disableEscape||t.headerButtons.indexOf("close")>-1&&t.close();break;case"Tab":t.opened&&t.modal&&(t._changingFocus=!0);break;case"Enter":case" ":{let a;if(t.shadowRoot||t.isInShadowDOM?(a=e.composedPath()[0],t._buttonPressed=a.getRootNode().host):(a=e.target.closest&&e.target.closest(".smart-button"),t._buttonPressed=a),!a)return;t._isWindowButton(a),delete t._buttonPressed;break}}a()}}),Smart("smart-multiline-prompt-window",class extends Smart.PromptWindow{static get properties(){return{autoCapitalize:{value:"none",allowedValues:["none","words","characters"],type:"string"},autoExpand:{value:!1,type:"boolean"},headerButtons:{value:["close"],type:"array"},horizontalScrollBarVisibility:{type:"string",value:"auto",allowedValues:["auto","disabled","hidden","visible"]},modal:{value:!0,readOnly:!0,type:"boolean",defaultReflectToAttribute:!0},selectionDirection:{value:"none",allowedValues:["forward","backward","none"],type:"string"},selectionEnd:{value:0,reflectToAttribute:!1,type:"number"},selectionStart:{value:0,reflectToAttribute:!1,type:"number"},spellCheck:{value:!1,type:"boolean"},verticalScrollBarVisibility:{type:"string",value:"auto",allowedValues:["auto","disabled","hidden","visible"]},wrap:{value:"soft",allowedValues:["hard","soft","off"],type:"string"}}}template(){return'<div role="presentation">\n                    <div class="smart-content-container" id="container">\n                        <div id="headerSection" class="smart-header-section" role="heading" aria-level="1">\n                            <div id="header" class="smart-header">[[label]]</div>\n                            <div id="buttonsContainer" class="smart-buttons-container">\n                                <button id="closeButton" class="smart-button smart-element smart-close-button" aria-label="Close"></button>\n                            </div>\n                        </div>\n                        <div class="smart-content">\n                            <content></content>\n                           <smart-multiline-text-box id="textBox"\n                                animation="[[animation]]"\n                                horizontal-scroll-bar-visibility= "[[horizontalScrollBarVisibility]]"\n                                vertical-scroll-bar-visibility= "[[verticalScrollBarVisibility]]"\n                                auto-capitalize="[[autoCapitalize]]"\n                                auto-expand = "[[autoExpand]]"\n                                selection-direction= "[[selectionDirection]]"\n                                selection-end= "[[selectionEnd]]"\n                                selection-start="[[selectionStart]]"\n                                spell-check= "[[spellCheck]]"\n                                wrap="[[wrap]]"\n                                max-length="[[maxLength]]"\n                                value="{{value}}"\n                                form="[[form]]"\n                                label="[[promptLabel]]"\n                                hint="[[hint]]"\n                                display-mode="[[displayMode]]"\n                                max-length="[[maxLength]]"\n                                placeholder="[[placeholder]]"\n                                required="[[required]]"\n                                required-message="[[requiredMessage]]"\n                                select-all-on-focus="[[selectAllOnFocus]]"\n                                theme="[[theme]]"\n                                right-to-left="[[rightToLeft]]">\n                           </smart-multiline-text-box>\n                        </div>\n                        <div id="footer" class="smart-footer">\n                            <button id="confirmButton" class="smart-button smart-element smart-confirm-button flat">[[confirmLabel]]</button>\n                            <button id="cancelButton" class="smart-button smart-element smart-cancel-button flat">[[cancelLabel]]</button>\n                        </div>\n                    </div>\n                </div>'}static get listeners(){return{"footer.click":"_footerClickHandler"}}static get requires(){return{"Smart.MultilineTextBox":"smart.multilinetextbox.js"}}_footerClickHandler(e){const t=this,a=e.target;a.closest(".smart-confirm-button")?t.$.fireEvent("confirm",{value:t.$.textBox.value}):a.closest(".smart-cancel-button")&&t.$.fireEvent("cancel",{value:t.$.textBox.value})}}),Smart("smart-progress-window",class extends Smart.Window{static get properties(){return{completeLabel:{value:"Continue",type:"string"},disableSnap:{value:!0,readOnly:!0,type:"boolean"},headerButtons:{value:["close"],type:"array"},indeterminate:{value:!1,type:"boolean"},inverted:{value:!1,type:"boolean"},formatFunction:{value:null,type:"function"},max:{value:100,type:"number"},modal:{value:!0,readOnly:!0,type:"boolean",defaultReflectToAttribute:!0},min:{value:0,type:"number"},showProgressValue:{value:!1,type:"boolean"},value:{value:0,type:"number?"}}}template(){return'<div role="presentation">\n                    <div class="smart-content-container" id="container">\n                        <div id="headerSection" class="smart-header-section" role="heading" aria-level="1">\n                            <div id="header" class="smart-header">[[label]]</div>\n                            <div id="buttonsContainer" class="smart-buttons-container">\n                                <button id="closeButton" class="smart-button smart-element smart-close-button" aria-label="Close"></button>\n                            </div>\n                        </div>\n                        <div class="smart-content" inner-h-t-m-l="[[innerHTML]]">\n                            <content></content>\n                        </div>\n                        <div id="footer" class="smart-footer">\n                            <smart-progress-bar id="progressBar"\n                                animation="[[animation]]"\n                                min="[[min]]"\n                                max="[[max]]"\n                                indeterminate="[[inditerminate]]"\n                                inverted="[[inverted]]"\n                                format-function="[[formatFunction]]"\n                                show-progress-value="[[showProgressValue]]"\n                                theme="[[theme]]"\n                                right-to-left="[[rightToLeft]]"\n                                value="{{value}}">\n                            </smart-progress-bar>\n                            <button id="completeButton" class="smart-button smart-element smart-complete-button smart-visibility-hidden">[[completeLabel]]</button>\n                        </div>\n                    </div>\n                </div>'}static get requires(){return{"Smart.ProgressBar":"smart.progressbar.js"}}propertyChangedHandler(e,t,a){const i=this;switch(e){case"value":i._handleCompletion();break;default:super.propertyChangedHandler(e,t,a)}}_createElement(){this.setAttribute("role","dialog"),this._handleCompletion()}_handleCompletion(){const e=this;e.$.completeButton&&(e.value>=e.max?(e.$completeButton.removeClass("smart-visibility-hidden"),e.$progressBar.addClass("smart-visibility-hidden")):(e.$completeButton.addClass("smart-visibility-hidden"),e.$progressBar.removeClass("smart-visibility-hidden")))}_keyDownHandler(e){const t=this;function a(){t._dragDetails&&(t._dragDetails.started=!1),t.$.removeClass("no-transition")}if(delete t._changingFocus,t.disabled||t._dragDetails&&t._dragDetails.started)return;if(t.disableKeyboard)return;e.stopPropagation();const i="ArrowDown"===e.key||"ArrowRight"===e.key?10:-10,n=t.enableShadowDOM&&t._windowParent.element.getRootNode()?t._windowParent.element.getRootNode().activeElement:document.activeElement;switch(t.$.removeClass("no-transition"),e.key){case"ArrowUp":case"ArrowDown":if(n!==t)return;if(e.preventDefault(),e.altKey)return"ArrowUp"===e.key?t.maximize():t.restore(),void a();if(t.$.addClass("no-transition"),e.ctrlKey)return t._resize("bottom",i),void a();t._drag(i,"vertical"),t.$.removeClass("no-transition");break;case"ArrowLeft":case"ArrowRight":if(n!==t)return;if(e.preventDefault(),t.$.addClass("no-transition"),e.ctrlKey)return t._resize("right",i),void a();t._drag(i,"horizontal"),t.$.removeClass("no-transition");break;case"Escape":t.disableEscape||t.headerButtons.indexOf("close")>-1&&t.close();break;case"Tab":t.opened&&t.modal&&(t._changingFocus=!0);break;case"Enter":case" ":{let a;if(t.shadowRoot||t.isInShadowDOM?(a=e.composedPath()[0],t._buttonPressed=a.getRootNode().host):(a=e.target.closest&&e.target.closest(".smart-button"),t._buttonPressed=a),!a)return;t._isWindowButton(a),delete t._buttonPressed;break}}a()}}),Smart("smart-tabs-window",class extends Smart.Window{static get properties(){return{disableSnap:{value:!0,readOnly:!0,type:"boolean"},dropPosition:{value:["all"],type:"array"},addNewTab:{value:!1,type:"boolean"},allowToggle:{value:!1,type:"boolean"},autoHide:{value:!1,type:"boolean"},autoHideWindow:{value:null,type:"any"},dataSource:{value:null,type:"array?",reflectToAttribute:!1},tabCloseButtonMode:{value:"default",allowedValues:["default","selected"],type:"string"},tabCloseButtons:{value:!1,type:"boolean"},messages:{value:{en:{ambiguousIndexes:"smart-tabs: Initially set smart-tab-item indexes are ambiguous and are ignored in favour of the HTML structure.",detailsObjectRequired:'smart-tabs: The method "insert" requires a details Object to be passed as a second argument.',invalidIndex:'smart-tabs: "{{method}}" method accepts an index of type number.',referenceNodeNotChild:"smart-tabs: Passed {{argument}} is not part of this smart-tabs element.",tabItemRequired:'smart-tabs: The method "{{method}}" requires a "smart-tab-item" element to be passed as an argument.'}},type:"object",extend:!0},tabOverflow:{value:"auto",allowedValues:["auto","hidden","scroll"],type:"string"},tabReorder:{value:!1,type:"boolean"},tabResize:{value:!1,type:"boolean"},tabScrollButtonsPosition:{value:"both",allowedValues:["near","far","both"],type:"string"},selectedIndex:{value:null,type:"number?"},selectionMode:{value:"click",allowedValues:["click","dblclick","mouseenter","none"],type:"string"},collapsed:{value:!1,type:"boolean"},collapsible:{value:!1,type:"boolean"},locked:{value:!1,type:"boolean"},max:{value:"",type:"any"},min:{value:"",type:"any"},size:{value:"",type:"any"},tabLayout:{value:"scroll",allowedValues:["scroll","dropdown","wrap","shrink"],type:"string",defaultReflectToAttribute:!0},tabPosition:{value:"top",allowedValues:["top","bottom","left","right","hidden"],type:"string"},tabTextOrientation:{value:"horizontal",allowedValues:["horizontal","vertical"],type:"string"},layout:{value:null,type:"any"}}}static get listeners(){return{"tabsElement.blur":"_tabsFocusHandler","tabsElement.change":"_tabsChangeHandler","tabsElement.focus":"_tabsFocusHandler","autoHideWindow.close":"_autoHideWindowCloseHandler","autoHideWindow.open":"_autoHideWindowOpenHandler"}}template(){return'<div role="presentation">\n                    <div class="smart-content-container" id="container">\n                        <div id="headerSection" class="smart-header-section" role="heading" aria-level="1">\n                            <div id="header" class="smart-header">[[label]]</div>\n                            <div id="buttonsContainer" class="smart-buttons-container">\n                                <button id="minimizeButton" class="smart-button smart-element smart-minimize-button" aria-label="Minimize"></button>\n                                <button id="maximizeButton" class="smart-button smart-element smart-maximize-button" aria-label="Maximize"></button>\n                                <button id="closeButton" class="smart-button smart-element smart-close-button" aria-label="Close"></button>\n                            </div>\n                        </div>\n                        <div id="contentSection" class="smart-content">\n                           <smart-tabs id="tabsElement"\n                                animation="[[animation]]"\n                                add-new-tab="[[addNewTab]]"\n                                allow-toggle="[[allowToggle]]"\n                                close-button-mode="[[tabCloseButtonMode]]"\n                                close-buttons="[[tabCloseButtons]]"\n                                disabled="[[disabled]]"\n                                overflow="[[tabOverflow]]"\n                                reorder="[[tabReorder]]"\n                                resize="[[tabResize]]"\n                                scroll-buttons-position="[[tabScrollButtonsPosition]]"\n                                selected-index="{{selectedIndex}}"\n                                selection-mode="[[selectionMode]]"\n                                tab-layout="[[tabLayout]]"\n                                tab-position="[[tabPosition]]"\n                                tab-text-orientation="[[tabTextOrientation]]"\n                                theme="[[theme]]"\n                                right-to-left="[[rightToLeft]]">\n                                <content></content>\n                            </smart-tabs>\n                        </div>\n                        <div id="footer" class="smart-footer smart-hidden"></div>\n                    </div>\n                </div>'}static get requires(){return{"Smart.Tabs":"smart.tabs.js"}}appendChild(e){const t=this;if(!t.isCompleted||e instanceof HTMLElement&&e.classList.contains("smart-resize-trigger-container")){const e=Array.prototype.slice.call(arguments,2);return HTMLElement.prototype.appendChild.apply(t,e.concat(Array.prototype.slice.call(arguments)))}e?(e instanceof Smart.TabItem||t.error(t.localize("tabItemRequired",{method:"removeChild"})),t.$.tabsElement.appendChild(e)):t.error(t.localize("invalidNode",{elementType:t.nodeName.toLowerCase(),method:"appendChild",node:"node"}))}insert(e,t){this.$.tabsElement.insert(e,t);const a=this.$.tabsElement._tabs[e];a&&(a.draggable=void 0===t.draggable||t.draggable,a.floatable=void 0===t.floatable||t.floatable)}insertBefore(e,t){this.$.tabsElement.insertBefore(e,t)}removeAt(e){this.$.tabsElement.removeAt(e)}removeChild(e){const t=this;if(!t.isCompleted||e instanceof HTMLElement&&e.classList.contains("smart-resize-trigger-container")){const e=Array.prototype.slice.call(arguments,2);return HTMLElement.prototype.removeChild.apply(t,e.concat(Array.prototype.slice.call(arguments)))}e?(e instanceof Smart.TabItem||t.error(t.localize("tabItemRequired",{method:"removeChild"})),(t.shadowRoot||t).contains(e)||t.error(t.localize("referenceNodeNotChild",{argument:"node"})),t.$.tabsElement.removeChild(e)):t.error(t.localize("invalidNode",{elementType:t.nodeName.toLowerCase(),method:"removeChild",node:"node"}))}refreshTabHeader(){const e=this;e.$.tabsElement&&e.$.tabsElement.isCompleted&&e.$.tabsElement.refreshTabHeader()}refreshTabs(){const e=this;e.$.tabsElement&&e.$.tabsElement.isCompleted&&e.$.tabsElement._applyTabOverflow()}select(e){this.$.tabsElement.select(e)}update(e,t,a){this.$.tabsElement.update(e,t,a)}get items(){return this.isCompleted&&this.$.tabsElement?this.$.tabsElement._tabs:null}get itemLabels(){return this.$?this.$.tabsElement._tabLabelContainers:null}get siblings(){const e=this;let t=[];if(!e.isCompleted)return t;const a=e.closest("smart-splitter");if(!a||!a.closest("smart-docking-layout"))return t;const i=a._items;if(!i||!i.length)return t;for(let n=0;n<i.length;n++){const o=i[n];o!==e.closest("smart-splitter-item")&&o.querySelector("smart-tabs-window").closest("smart-splitter")===a&&t.push(o.querySelector("smart-tabs-window"))}return t}propertyChangedHandler(e,t,a){const i=this;switch("collapsed"!==e&&super.propertyChangedHandler(e,t,a),e){case"theme":""!==t&&(i.$.closeButton.classList.remove(t),i.$.collapseButton.classList.remove(t),i.$.maximizeButton.classList.remove(t),i.$.pinButton.classList.remove(t)),i._applyTheme(a);break;case"autoHideWindow":i._handleAutoHideWindow();break;case"autoHide":a||(null!==i.$.tabsElement.selectedIndex&&(i.$.tabsElement._tabs[i.$.tabsElement.selectedIndex]._autoHideWindowSize=void 0),i._autoHideWindow&&i._autoHideWindow.close());break;case"dataSource":i.$.tabsElement.dataSource=a;break;case"layout":i._handleLayoutProperty();break;case"collapsible":case"collapsed":case"locked":case"max":case"min":case"size":{const n=i.getRootNode(),o=(n&&n.host?n.host:i).closest("smart-docking-layout"),s=i.closest("smart-splitter-item");if(!o)return void("collapsed"===e&&super.propertyChangedHandler(e,t,a));s&&(s[e]=a);break}}}_applyTheme(e){if(""!==e){const t=this.$.buttonsContainer.children;for(let a=0;a<t.length;a++)t[a].classList.add(e)}}_autoHideWindowCloseHandler(){const e=this;e.allowToggle&&null!==e.$.tabsElement.selectedIndex&&e.$.tabsElement.select(e.$.tabsElement.selectedIndex),e._autoHideWindow&&e._moveContent(e._autoHideWindow.items[0],e._autoHideWindow._tab)}_autoHideWindowOpenHandler(){const e=this;e.$.tabsElement.selectedIndex&&e._handleAutoHide(e.$.tabsElement.selectedIndex)}_createElement(){const e=this;e.setAttribute("role","dialog"),e.$.tabsElement.$.tabHeaderControls&&!e.$.tabsElement.$.tabHeaderControls.innerHTML&&e.$.tabsElement.$tabHeaderControls.addClass("smart-hidden"),e.$.tabsElement.dataSource=e.dataSource,e._applyTheme(e.theme),e._handleAutoHideWindow(),e.autoHide&&e._handleAutoHide(e.$.tabsElement.selectedIndex),e.allowToggle||e.selectedIndex||null===e.$.tabsElement.selectedIndex||(e.selectedIndex=e.$.tabsElement.selectedIndex,e.$.tabsElement.setAttribute("selected-index",e.selectedIndex)),e._handleLayoutProperty();const t=(e.isInShadowDOM?e.getRootNode().host:e||e).closest("smart-docking-layout"),a=e.closest("smart-splitter-item");t&&a&&(a.collapsible=e.collapsible,a.collapsed=e.collapsed,a.min=e.min,a.max=e.max,a.size=e.size,a.locked=e.locked)}attached(){super.attached();const e=this;e.classList.add("smart-window"),e.shadowRoot&&e.$.root.classList.add("smart-window")}_handleLayoutProperty(){const e=this;let t=e.closest("smart-docking-layout");if(Smart.DockingLayout){if(!e.ownerLayout&&e.getRootNode()){let a=e.getRootNode().host;for(;a;){if(!a.closest)return;if(a.closest("smart-docking-layout")){t=a.closest("smart-docking-layout");break}a=a.getRootNode()?a.getRootNode().host:void 0}}t?e.layout=t:e.layout instanceof Smart.DockingLayout||"string"==typeof e.layout&&(e.layout=document.getElementById(e.layout))}}_headerDblCickHandler(e){const t=this,a=t.shadowRoot||t.isInShadowDOM?e.originalEvent.composedPath()[0]:e.originalEvent.target;e.ctrlKey||a!==t.$.headerSection&&a!==t.$.header||t.$.maximizeButton&&0===t.$.maximizeButton.offsetHeight||(t.maximized?t.restore():t.maximize())}_documentUpHandler(e){const t=this;let a=e.originalEvent.target.closest?e.originalEvent.target.closest(".smart-window"):e.originalEvent.target,i=a===t||a===t._autoHideWindow||t._isAutoHideWindowClicked,n=t.closest("smart-docking-layout");(t.shadowRoot||t.isInShadowDOM)&&(a=e.originalEvent.composedPath()[0],i=a.getRootNode()===t.shadowRoot||a.closest(".smart-window")===t||a.closest(".smart-window")===t._autoHideWindow||t._isAutoHideWindowClicked),n=((t.isInShadowDOM?t.getRootNode().host:t)||t).closest("smart-docking-layout"),n&&n.disabled?delete t._isWindowContentClicked:(super._documentUpHandler(e),delete t._isAutoHideWindowClicked,t.autoHide&&t._autoHideWindow&&(i&&t._autoHideWindow.opened||(t.selectedIndex=null,t._autoHideWindow.parentElement&&t._autoHideWindow.parentElement.closest(".smart-window")===t&&t._autoHideWindow.close())))}_handleAutoHide(e){const t=this;if(!t.autoHide||null===e)return;if(t._autoHideWindow||t._handleAutoHideWindow(!0),!t._autoHideWindow)return;t._autoHideWindow._tabsWindow&&t._autoHideWindow._tabsWindow!==t&&(t._autoHideWindow._tabsWindow.selectedIndex=null);const a=t.$.tabsElement._tabs[e];t._autoHideWindow._tab!==a&&t._moveContent(t._autoHideWindow.items[0],t._autoHideWindow._tab),t._autoHideWindow.label=a.label,t._autoHideWindow.draggable=a.draggable,t._autoHideWindow.floatable=a.floatable,t._autoHideWindow._tab=a,t._autoHideWindow.headerButtons=t.headerButtons,t._moveContent(t._autoHideWindow._tab,t._autoHideWindow.items[0]),t._autoHideWindow.bringToFront(),t._setAutoHideWindowSize(e),t._autoHideWindow.open(),t._autoHideWindow._tabsWindow=t,t._autoHideWindow.controlledBy&&t._autoHideWindow.controlledBy.removeAttribute("aria-controls"),t._autoHideWindow.controlledBy=t.$.tabsElement._tabLabelContainers[e],t._autoHideWindow.controlledBy.setAttribute("aria-controls",t._autoHideWindow.id)}_moveHandler(e){const t=this,a=t.closest("smart-docking-layout");a&&a.items.indexOf(t)>-1||(Smart.Utilities.Core.isMobile&&navigator.platform&&/iPad|iPhone|iPod/.test(navigator.platform)&&t.layout instanceof Smart.DockingLayout&&t.layout.hasAttribute("dragged")&&e.originalEvent.preventDefault(),super._moveHandler(e))}_setAutoHideWindowSize(e){const t=this;if(!t._autoHideWindow)return;t._autoHideWindow.$.addClass("no-transition"),t._autoHideWindow.style.maxWidth=t._autoHideWindow.style.maxHeight="";const a=t.$.tabsElement._tabs[e],i=(t._autoHideWindow.isInShadowDOM?t._autoHideWindow.getRootNode().host:t._autoHideWindow).closest("smart-docking-layout")||t._autoHideWindow.parentElement;let n,o;if(a){if("top"===t.tabPosition||"bottom"===t.tabPosition){t._autoHideWindow.resizeMode="top"===t.tabPosition?"bottom":"top",t._autoHideWindow.style.width=t.$.tabsElement.offsetWidth+"px",n=i.getBoundingClientRect(),o=t.$.tabsElement.getBoundingClientRect();let e=a._autoHideWindowSize&&parseFloat(a._autoHideWindowSize)||"";Smart.DockingLayout&&i instanceof Smart.DockingLayout&&(e&&(e=Math.min(i.$.itemsContainer.offsetHeight,e)+"px"),t._autoHideWindow.style.maxHeight=i.$.itemsContainer.offsetHeight+"px"),t._autoHideWindow.style.height=e,t._autoHideWindow.style.left=o.left-n.left+"px",t._autoHideWindow&&("top"===t.tabPosition?t._autoHideWindow.style.top=o.top+-n.top+o.height+"px":t._autoHideWindow.style.top=o.top-n.top-t._autoHideWindow.offsetHeight+"px")}else{t._autoHideWindow.resizeMode="left"===t.tabPosition?"right":"left",t._autoHideWindow.style.height=t.$.tabsElement.offsetHeight+"px";let e=a._autoHideWindowSize&&parseFloat(a._autoHideWindowSize)||"";i instanceof Smart.DockingLayout&&(e&&(e=Math.min(i.$.itemsContainer.offsetWidth,e)+"px"),t._autoHideWindow.style.maxWidth=i.$.itemsContainer.offsetWidth+"px"),t._autoHideWindow.style.width=e,n=i.getBoundingClientRect(),o=t.$.tabsElement.getBoundingClientRect(),t._autoHideWindow.style.top=o.top-n.top+"px","left"===t.tabPosition?t._autoHideWindow.style.left=o.left-n.left+t.$.tabsElement.offsetWidth+"px":t._autoHideWindow.style.left=o.left-n.left-t._autoHideWindow.offsetWidth+"px"}t._autoHideWindow._dragDetails&&(t._autoHideWindow._dragDetails.maxWidth=void 0),t._autoHideWindow._setDragDetails("resize"),t._autoHideWindow._dragDetails.started=!1,t._autoHideWindow.$.removeClass("no-transition")}}_handleAutoHideWindow(e){const t=this;if(t.autoHideWindow){if(t._autoHideWindow&&t._autoHideWindow.parentElement.removeChild(t._autoHideWindow),"string"==typeof t.autoHideWindow)return void(t._autoHideWindow=document.getElementById(t.autoHideWindow));if(t.autoHideWindow instanceof Smart.Window)return void(t._autoHideWindow=t.autoHideWindow)}if(!e||t._autoHideWindow||2===t.$.contentSection.children.length&&t.$.contentSection.children[1]instanceof Smart.Window)return;const a=document.createElement("smart-window");a.$=Smart.Utilities.Extend(a),a.disableSnap=a.pinned=!0,a.headerButtons=["close"],t.$.contentSection.appendChild(a),t._autoHideWindow=a}_moveContent(e,t){if(!e||!t)return;const a=[].slice.call(e.$.content.childNodes);for(let e=0;e<a.length;e++)t.appendChild(a[e])}_tabsChangeHandler(e){const t=this;if(e.target===t.$.tabsElement&&t.autoHide){if(t._autoHideWindow||t._handleAutoHideWindow(!0),null!==e.detail.oldIndex&&t._autoHideWindow.opened&&(t.$.tabsElement._tabs[e.detail.oldIndex]._autoHideWindowSize=t._autoHideWindow.style["right"===t.$.tabsElement.tabPosition||"left"===t.$.tabsElement.tabPosition?"width":"height"]),!t.autoHide||null===e.detail.index||void 0===e.detail.index)return t._autoHideWindow.setAttribute("active",""),void t._autoHideWindow.close();t._handleAutoHide(e.detail.index)}}_tabsFocusHandler(e){const t=this;"focus"===e.type?(t.bringToFront(),t.setAttribute("focus","")):t.removeAttribute("focus")}}),Smart("smart-wait-window",class extends Smart.ProgressWindow{static get properties(){return{headerButtons:{value:[],type:"array"},disableSnap:{value:!0,readOnly:!0,type:"boolean"},modal:{value:!0,readOnly:!0,type:"boolean",defaultReflectToAttribute:!0},pinned:{value:!0,type:"boolean",readOnly:!0}}}template(){return'<div role="presentation">\n                    <div class="smart-content-container" id="container">\n                        <div id="headerSection" class="smart-header-section" role="heading" aria-level="1">\n                            <div id="header" class="smart-header">[[label]]</div>\n                            <div id="buttonsContainer" class="smart-buttons-container">\n                                <button id="closeButton" class="smart-button smart-element smart-close-button" aria-label="Close"></button>\n                            </div>\n                        </div>\n                        <div class="smart-content">\n                            <content></content>\n                            <smart-progress-bar id="progressBar" animation="[[animation]]" indeterminate theme="[[theme]]" right-to-left="[[rightToLeft]]"></smart-progress-bar>\n                        </div>\n                        <div id="footer" class="smart-footer"></div>\n                    </div>\n                </div>'}_keyDownHandler(e){const t=this;function a(){t._dragDetails&&(t._dragDetails.started=!1),t.$.removeClass("no-transition")}if(delete t._changingFocus,t.disabled||t._dragDetails&&t._dragDetails.started)return;const i=t.shadowRoot||t._windowParent.element.getRootNode()?t._windowParent.element.getRootNode().activeElement:document.activeElement;e.stopPropagation();const n="ArrowDown"===e.key||"ArrowRight"===e.key?10:-10;switch(t.$.removeClass("no-transition"),e.key){case"ArrowUp":case"ArrowDown":if(i!==t)return;if(e.preventDefault(),e.altKey)return"ArrowUp"===e.key?t.maximize():t.restore(),void a();if(t.$.addClass("no-transition"),e.ctrlKey)return t._resize("bottom",n),void a();t._drag(n,"vertical");break;case"ArrowLeft":case"ArrowRight":if(i!==t)return;if(e.preventDefault(),t.$.addClass("no-transition"),e.ctrlKey)return t._resize("right",n),void a();t._drag(n,"horizontal");break;case"Tab":t.opened&&t.modal&&(t._changingFocus=!0);break;case"Enter":case" ":{let a;if(t.shadowRoot||t.isInShadowDOM?(a=e.composedPath()[0],t._buttonPressed=a.getRootNode().host):(a=e.target.closest&&e.target.closest(".smart-button"),t._buttonPressed=a),!a)return;t._isWindowButton(a),delete t._buttonPressed;break}}a()}});