import { eventScope, TouchRecord, } from '../utils/';
var activeScrollbar;
export function touchHandler(scrollbar) {
    var target = scrollbar.options.delegateTo || scrollbar.containerEl;
    var touchRecord = new TouchRecord();
    var addEvent = eventScope(scrollbar);
    var damping;
    var pointerCount = 0;
    addEvent(target, 'touchstart', function (evt) {
        // start records
        touchRecord.track(evt);
        // stop scrolling
        scrollbar.setMomentum(0, 0);
        // save damping
        if (pointerCount === 0) {
            damping = scrollbar.options.damping;
            scrollbar.options.damping = Math.max(damping, 0.5); // less frames on touchmove
        }
        pointerCount++;
    });
    addEvent(target, 'touchmove', function (evt) {
        if (activeScrollbar && activeScrollbar !== scrollbar)
            return;
        touchRecord.update(evt);
        var _a = touchRecord.getDelta(), x = _a.x, y = _a.y;
        scrollbar.addTransformableMomentum(x, y, evt, function (willScroll) {
            if (willScroll && evt.cancelable) {
                evt.preventDefault();
                activeScrollbar = scrollbar;
            }
        });
    });
    addEvent(target, 'touchcancel touchend', function (evt) {
        var delta = touchRecord.getEasingDistance(damping);
        scrollbar.addTransformableMomentum(delta.x, delta.y, evt);
        pointerCount--;
        // restore damping
        if (pointerCount === 0) {
            scrollbar.options.damping = damping;
        }
        touchRecord.release(evt);
        activeScrollbar = null;
    });
}
//# sourceMappingURL=touch.js.map