import clamp from 'lodash-es/clamp';
var animationIDStorage = new WeakMap();
export function scrollTo(scrollbar, x, y, duration, _a) {
    if (duration === void 0) { duration = 0; }
    var _b = _a === void 0 ? {} : _a, _c = _b.easing, easing = _c === void 0 ? defaultEasing : _c, callback = _b.callback;
    var options = scrollbar.options, offset = scrollbar.offset, limit = scrollbar.limit;
    if (options.renderByPixels) {
        // ensure resolved with integer
        x = Math.round(x);
        y = Math.round(y);
    }
    var startX = offset.x;
    var startY = offset.y;
    var disX = clamp(x, 0, limit.x) - startX;
    var disY = clamp(y, 0, limit.y) - startY;
    var start = Date.now();
    function scroll() {
        var elapse = Date.now() - start;
        var progress = duration ? easing(Math.min(elapse / duration, 1)) : 1;
        scrollbar.setPosition(startX + disX * progress, startY + disY * progress);
        if (elapse >= duration) {
            if (typeof callback === 'function') {
                callback.call(scrollbar);
            }
        }
        else {
            var animationID = requestAnimationFrame(scroll);
            animationIDStorage.set(scrollbar, animationID);
        }
    }
    cancelAnimationFrame(animationIDStorage.get(scrollbar));
    scroll();
}
/**
 * easeOutCubic
 */
function defaultEasing(t) {
    return Math.pow((t - 1), 3) + 1;
}
//# sourceMappingURL=scroll-to.js.map