import { ScrollbarThumb } from './thumb';
import { setStyle, } from '../utils/';
var ScrollbarTrack = /** @class */ (function () {
    function ScrollbarTrack(direction, thumbMinSize) {
        if (thumbMinSize === void 0) { thumbMinSize = 0; }
        /**
         * Track element
         */
        this.element = document.createElement('div');
        this._isShown = false;
        this.element.className = "scrollbar-track scrollbar-track-" + direction;
        this.thumb = new ScrollbarThumb(direction, thumbMinSize);
        this.thumb.attachTo(this.element);
    }
    /**
     * Attach to scrollbar container element
     *
     * @param scrollbarContainer Scrollbar container element
     */
    ScrollbarTrack.prototype.attachTo = function (scrollbarContainer) {
        scrollbarContainer.appendChild(this.element);
    };
    /**
     * Show track immediately
     */
    ScrollbarTrack.prototype.show = function () {
        if (this._isShown) {
            return;
        }
        this._isShown = true;
        this.element.classList.add('show');
    };
    /**
     * Hide track immediately
     */
    ScrollbarTrack.prototype.hide = function () {
        if (!this._isShown) {
            return;
        }
        this._isShown = false;
        this.element.classList.remove('show');
    };
    ScrollbarTrack.prototype.update = function (scrollOffset, containerSize, pageSize) {
        setStyle(this.element, {
            display: pageSize <= containerSize ? 'none' : 'block',
        });
        this.thumb.update(scrollOffset, containerSize, pageSize);
    };
    return ScrollbarTrack;
}());
export { ScrollbarTrack };
//# sourceMappingURL=track.js.map