var smoothScroller = (function (exports) {
  'use strict';

  function isWindow(obj) {
    return obj != null && obj === obj.window;
  }

  function find(selector, context) {
    if (context === void 0) {
      context = null;
    }

    if (selector instanceof HTMLElement || selector instanceof Node || isWindow(selector)) {
      return [selector];
    } else if (selector instanceof NodeList) {
      return [].slice.call(selector);
    } else if (typeof selector === 'string') {
      var startElement = context ? find(context)[0] : document;
      return [].slice.call(startElement.querySelectorAll(selector));
    }

    return [];
  }
  // completely on IE.
  //


  function canIuseNativeCustom() {
    try {
      var p = new CustomEvent('t', {
        detail: {
          a: 'b'
        }
      });
      return p.type === 't' && p.detail.a === 'b';
    } catch (e) {
      return false;
    }
  } // Lousy polyfill for the Custom Event constructor for IE.


  var IECustomEvent = function CustomEvent(type, params) {
    var e = document.createEvent('CustomEvent');

    if (params) {
      e.initCustomEvent(type, params.bubbles, params.cancelable, params.detail);
    } else {
      e.initCustomEvent(type, false, false, undefined);
    }

    return e;
  };

  var DomassistCustomEvent = false;

  function fire(selector, type, params) {
    if (params === void 0) {
      params = {};
    }

    if (Array.isArray(selector)) {
      return selector.forEach(function (item) {
        return fire(item, type, params);
      });
    }

    if (!DomassistCustomEvent) {
      DomassistCustomEvent = canIuseNativeCustom() ? CustomEvent : IECustomEvent;
    }

    var els = find(selector);

    if (els.length) {
      if (params.bubbles !== false) {
        params.bubbles = true;
      }

      els.forEach(function (el) {
        var event = new DomassistCustomEvent(type, params);
        el.dispatchEvent(event);
      });
      return els;
    }
  }

  /* global window,document */
  var duration = 1000;

  var ease = function ease(t, b, c, d) {
    if ((t /= d / 2) < 1) return c / 2 * t * t * t * t + b; //eslint-disable-line

    return -c / 2 * ((t -= 2) * t * t * t - 2) + b;
  };

  var animate = function animate(startTime, start, end, callback) {
    if (callback === void 0) {
      callback = function callback() {};
    }

    var time = new Date().getTime();
    var difference = end - start;
    var goingUp = difference < 0;

    if (difference === 0) {
      return;
    }

    var delta = time - startTime;
    var to = Math.round(ease(delta, start, difference, duration));

    if (!goingUp && to > end) {
      to = end;
    }

    if (goingUp && to < end) {
      to = end;
    }

    if (delta > duration) {
      to = end;
    }

    window.scrollTo(0, to);

    if (to === end) {
      setTimeout(callback);
      return;
    }

    if (to < 0) {
      return;
    }

    window.requestAnimationFrame(function () {
      return animate(startTime, start, end, callback);
    });
  };

  var scroll = function scroll(target, hash, offset, silent) {
    if (offset === void 0) {
      offset = 0;
    }

    if (silent === void 0) {
      silent = false;
    }

    if (!target) {
      return;
    }

    fire(target, 'smoothscroll:start', {
      bubbles: true
    });
    var rect = target.getBoundingClientRect();
    var scrollY = window.pageYOffset || document.documentElement.scrollTop;
    var adjustedOffset = Math.round(rect.top + scrollY) + offset;
    var startTime = new Date();

    if (!target.hasAttribute('tabindex')) {
      target.tabIndex = '-1';
    }

    if (!silent) {
      window.history.pushState(null, 'Scroll', hash);
    }

    animate(startTime.getTime(), scrollY, adjustedOffset, function () {
      fire(target, 'smoothscroll:end', {
        bubbles: true
      });
    });
    target.focus();
  };

  var listenEvent = function listenEvent(el, offset) {
    if (el.dataset.smoothActive) {
      return;
    }

    el.dataset.smoothActive = true;
    el.addEventListener('click', function (e) {
      var hash = el.getAttribute('href');

      if (hash[0] !== '#') {
        return;
      }

      e.preventDefault();
      scroll(document.querySelector(hash), hash, offset);
    });
  };

  var init = function init(query, offset) {
    if (query === void 0) {
      query = '[data-smooth]';
    }

    if (offset === void 0) {
      offset = 0;
    }

    if (!window.requestAnimationFrame) {
      return;
    }

    var els = query;

    if (typeof query === 'string') {
      els = document.querySelectorAll(query);
    }

    if (els instanceof Element) {
      els = [els];
    }

    for (var i = 0, c = els.length; i < c; i++) {
      var el = els[i];
      listenEvent(el, offset);
    }
  };
  window.addEventListener('DOMContentLoaded', function () {
    init();
  });

  exports.init = init;
  exports.scroll = scroll;

  return exports;

}({}));
//# sourceMappingURL=smooth-scroller.bundle.js.map
