type AllowedTarget =
    | string
    | HTMLElement
    | NodeList
    | Array<HTMLElement>;

interface ZoomOption {
    background?: string;
    useMaximumSize?: boolean;
    onTransitionEnd?: (img: HTMLImageElement) => void;
    onClick?: (img: HTMLImageElement) => void;
}

declare function Zoom(
    selector?: AllowedTarget,
    options?: ZoomOption
): {
    zoom: (img: HTMLImageElement) => void;
    attach: (target: AllowedTarget) => void;
};

export { Zoom as default };
