'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _language = require('./language');

var _language2 = _interopRequireDefault(_language);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function traverse(vNode, fn) {
  fn(vNode);
  if (vNode.children) {
    vNode.children.forEach(function (child) {
      traverse(child, fn);
    });
  }
}

function wrapVNode(vNode, parent) {
  var children = vNode.children;

  if (children && typeof children.map === 'function') {
    children = children.map(function (k) {
      return wrapVNode(k, vNode);
    });
  }
  vNode.parent = parent;
  return vNode;
}

function match(sel, vNode) {
  var selector = (0, _language2.default)(sel);
  var matched = [];

  var wrappedVNode = wrapVNode(vNode);

  traverse(wrappedVNode, function (node) {
    var result = undefined;
    if (node.data && node.data.vnode) {
      result = selector(node.data.vnode);
    } else if (node.data && node.data.fn) {
      var _node$data;

      result = selector((_node$data = node.data).fn.apply(_node$data, _toConsumableArray(node.data.args)));
    } else {
      result = selector(node);
    }
    if (result) {
      if (!Array.isArray(result)) {
        result = [result];
      }
      matched.push.apply(matched, result);
    }
  });
  return matched;
}

exports.default = match;