'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _cssauron = require('cssauron');

var _cssauron2 = _interopRequireDefault(_cssauron);

var _selectorParser = require('./selectorParser');

var _selectorParser2 = _interopRequireDefault(_selectorParser);

var _classNameFromVNode = require('./classNameFromVNode');

var _classNameFromVNode2 = _interopRequireDefault(_classNameFromVNode);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function LanguageSpecification() {}

LanguageSpecification.prototype.tag = function tag(vNode) {
  return (0, _selectorParser2.default)(vNode.sel).tagName;
};

LanguageSpecification.prototype.class = function klass(vNode) {
  return (0, _classNameFromVNode2.default)(vNode);
};

LanguageSpecification.prototype.id = function id(vNode) {
  if (vNode.data && vNode.data.props && vNode.data.props.id) {
    return vNode.data.props.id;
  }
  return (0, _selectorParser2.default)(vNode.sel).id;
};

LanguageSpecification.prototype.children = function children(vNode) {
  return vNode.children || [];
};

LanguageSpecification.prototype.parent = function parent(vNode) {
  return vNode.parent || vNode;
};

LanguageSpecification.prototype.contents = function contents(vNode) {
  return vNode.text;
};

LanguageSpecification.prototype.attr = function attributes(vNode, attr) {
  if (vNode.data) {
    var _vNode$data = vNode.data;
    var _vNode$data$attrs = _vNode$data.attrs;
    var attrs = _vNode$data$attrs === undefined ? {} : _vNode$data$attrs;
    var _vNode$data$props = _vNode$data.props;
    var props = _vNode$data$props === undefined ? {} : _vNode$data$props;

    if (attrs[attr]) {
      return attrs[attr];
    }
    if (props[attr]) {
      return props[attr];
    }
  }
};

var language = (0, _cssauron2.default)(new LanguageSpecification());

exports.default = language;