let {addIndex, chain, curry, map, range} = require("ramda")
let snabbdom = require("../../snabbdom")
let h = require("snabbdom/h")
let hh = require("hyperscript-helpers")

let {div, span, p} = hh(h)

let patch = snabbdom.init([
  require("snabbdom/modules/style"),
  require("snabbdom/modules/attributes"),
  require("snabbdom/modules/props"),
])

let mapi = addIndex(map)
let chaini = addIndex(chain)

let board1 = [
  [["A1", 0], ["B1", 0]],
  [["C1", 0], ["D1", 0]],
]

let board2 = [
  [["A2", 1], ["B2", 0]],
  [["C2", 0], ["D2", 0]],
]

// renderCell :: Cell -> String
let renderCell = curry((i, j, cell) => {
  if (cell[1] == 0) {
    return span(".cell", [ // <-------- updates when child updates WTF???
      span({attrs: {"data-state": 0}}, [cell[0]])
    ])
  } else {
    return span(".cell", [
      p({attrs: {"data-state": 1}}, [cell[0]])
    ])
  }
})

// renderBoard :: [[Cell]] -> String
let renderBoard = (board) => {
  let rowsM = board.length
  let colsN = board[0] ? board[0].length : 0
  return div(".board",
    chaini((r, i) => mapi((c, j) => renderCell(i, j, c), r), board)
  )
}

let vnode = renderBoard(board1)

let container = document.getElementById("app")

patch(container, vnode)

setTimeout(() => {
  let vnode2 = renderBoard(board2)
  console.log(vnode);
  console.log(vnode2);
  patch(vnode, vnode2)
  vnode = vnode2
}, 3000)
