import 'source-map-support/register';
declare enum DepType {
    prod = "prod",
    dev = "dev"
}
interface PkgTree {
    name: string;
    version: string;
    dependencies?: {
        [dep: string]: PkgTree;
    };
    depType?: DepType;
    hasDevDependencies?: boolean;
    cyclic?: boolean;
}
export { buildDepTree, buildDepTreeFromFiles, PkgTree, DepType, };
declare function buildDepTree(manifestFileContents: string, lockFileContents: string, includeDev?: boolean): Promise<PkgTree>;
declare function buildDepTreeFromFiles(root: string, manifestFilePath: string, lockFilePath: string, includeDev?: boolean): Promise<PkgTree>;
