"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
require("source-map-support/register");
var fs = require("fs");
var path = require("path");
var _ = require("lodash");
var DepType;
(function (DepType) {
    DepType["prod"] = "prod";
    DepType["dev"] = "dev";
})(DepType || (DepType = {}));
exports.DepType = DepType;
function buildDepTree(manifestFileContents, lockFileContents, includeDev) {
    if (includeDev === void 0) { includeDev = false; }
    return __awaiter(this, void 0, void 0, function () {
        var lockFile, manifestFile, depTree, topLevelDeps;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    lockFile = JSON.parse(lockFileContents);
                    manifestFile = JSON.parse(manifestFileContents);
                    if (!manifestFile.dependencies && !includeDev) {
                        throw new Error("No 'dependencies' property in package.json");
                    }
                    depTree = {
                        dependencies: {},
                        hasDevDependencies: !_.isEmpty(manifestFile.devDependencies),
                        name: manifestFile.name,
                        version: manifestFile.version,
                    };
                    // asked to process empty deps
                    if (_.isEmpty(manifestFile.dependencies) && !includeDev) {
                        return [2 /*return*/, depTree];
                    }
                    if (!lockFile.dependencies && !includeDev) {
                        throw new Error("No 'dependencies' property in package-lock.json");
                    }
                    topLevelDeps = getTopLevelDeps(manifestFile, includeDev);
                    return [4 /*yield*/, Promise.all(topLevelDeps.map(function (dep) { return __awaiter(_this, void 0, void 0, function () {
                            var _a, _b;
                            return __generator(this, function (_c) {
                                switch (_c.label) {
                                    case 0:
                                        _a = depTree.dependencies;
                                        _b = dep;
                                        return [4 /*yield*/, buildSubTreeRecursive(dep, ['dependencies'], lockFile, [])];
                                    case 1:
                                        _a[_b] = _c.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); }))];
                case 1:
                    _a.sent();
                    return [2 /*return*/, depTree];
            }
        });
    });
}
exports.buildDepTree = buildDepTree;
function getTopLevelDeps(targetFile, includeDev) {
    return Object.keys(__assign({}, targetFile.dependencies, (includeDev ? targetFile.devDependencies : null)));
}
function buildSubTreeRecursive(depName, lockfilePath, lockFile, depPath) {
    return __awaiter(this, void 0, void 0, function () {
        var depSubTree, deps, dep, depKey, newDeps;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    depSubTree = {
                        depType: undefined,
                        dependencies: {},
                        name: depName,
                        version: undefined,
                    };
                    deps = _.get(lockFile, lockfilePath);
                    dep = _.get(deps, depName);
                    if (!dep) return [3 /*break*/, 4];
                    // update the tree
                    depSubTree.version = dep.version;
                    depSubTree.depType = dep.dev ? DepType.dev : DepType.prod;
                    depKey = depName + "@" + dep.version;
                    if (!(depPath.indexOf(depKey) >= 0)) return [3 /*break*/, 1];
                    depSubTree.cyclic = true;
                    return [3 /*break*/, 3];
                case 1:
                    // if not, add it
                    depPath.push(depKey);
                    newDeps = dep.requires ? Object.keys(dep.requires) : [];
                    return [4 /*yield*/, Promise.all(newDeps.map(function (subDep) { return __awaiter(_this, void 0, void 0, function () {
                            var _a, _b;
                            return __generator(this, function (_c) {
                                switch (_c.label) {
                                    case 0:
                                        _a = depSubTree.dependencies;
                                        _b = subDep;
                                        return [4 /*yield*/, buildSubTreeRecursive(subDep, lockfilePath.concat([depName, 'dependencies']), lockFile, depPath.slice())];
                                    case 1:
                                        _a[_b] = _c.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); }))];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3: return [2 /*return*/, depSubTree];
                case 4:
                    // tree was walked to the root and dependency was not found
                    if (!lockfilePath.length) {
                        throw new Error("Dependency " + depName + " was not found in package-lock.json.\n        Your package.json and package-lock.json are probably out of sync.\n        Please run npm install and try to parse the log again.");
                    }
                    // dependency was not found on a current path, remove last key (move closer to the root) and try again
                    // visitedDepPaths can be passed by a reference, because traversing up doesn't update it
                    return [2 /*return*/, buildSubTreeRecursive(depName, lockfilePath.slice(0, -1), lockFile, depPath)];
            }
        });
    });
}
function buildDepTreeFromFiles(root, manifestFilePath, lockFilePath, includeDev) {
    if (includeDev === void 0) { includeDev = false; }
    return __awaiter(this, void 0, void 0, function () {
        var manifestFileFullPath, lockFileFullPath, manifestFileContents, lockFileContents;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!root || !lockFilePath || !lockFilePath) {
                        throw new Error('Missing required parameters for buildDepTreeFromFiles()');
                    }
                    manifestFileFullPath = path.resolve(root, manifestFilePath);
                    lockFileFullPath = path.resolve(root, lockFilePath);
                    if (!fs.existsSync(manifestFileFullPath)) {
                        throw new Error("Target file package.json not found at location: " + manifestFileFullPath);
                    }
                    if (!fs.existsSync(lockFileFullPath)) {
                        throw new Error("Lockfile package-lock.json not found at location: " + lockFileFullPath);
                    }
                    manifestFileContents = fs.readFileSync(manifestFileFullPath, 'utf-8');
                    lockFileContents = fs.readFileSync(lockFileFullPath, 'utf-8');
                    return [4 /*yield*/, buildDepTree(manifestFileContents, lockFileContents, includeDev)];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.buildDepTreeFromFiles = buildDepTreeFromFiles;
//# sourceMappingURL=index.js.map