#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const process_1 = require("process");
const common = require("./common");
const fs = require("fs");
const path = require("path");
const errorContextMessage = 'Runtime';
const fallbackScript = path.join(__dirname, '..', 'dist', 'cli', 'index.js');
const legacyCLIflag = '--legacy-cli';
function run(executable) {
    let cliArguments = common.getCliArguments(process_1.argv);
    if (executable.endsWith('.js')) {
        cliArguments = [executable].concat(cliArguments);
        executable = process_1.argv[0]; // node runtime
    }
    const exitCode = common.runWrapper(executable, cliArguments);
    return exitCode;
}
(async () => {
    let fallbackToLegacyCLI = process_1.argv.includes(legacyCLIflag);
    if (fallbackToLegacyCLI === false) {
        try {
            const config = common.getCurrentConfiguration();
            const executable = config.getLocalLocation();
            const { downloadUrl, backupUrl } = config.getDownloadLocations();
            if (!fs.existsSync(executable)) {
                console.error("Executable doesn't exist, trying to download.");
                const downloadError = await common.downloadWithBackup(downloadUrl, backupUrl, executable, config.getShasumFile());
                if (downloadError !== undefined) {
                    throw downloadError;
                }
            }
            // run the executable
            process.exit(run(executable));
        }
        catch (error) {
            fallbackToLegacyCLI = true;
            await common.logError(errorContextMessage, error);
        }
    }
    else {
        // if --legacy-clli is enabled create a log messaeg
        await common.logError(errorContextMessage, Error(legacyCLIflag + ' is set'), false);
    }
    if (fallbackToLegacyCLI) {
        common.formatErrorMessage('legacy-cli');
        const exitCode = run(fallbackScript);
        common.formatErrorMessage('legacy-cli');
        process.exit(exitCode);
    }
})();
//# sourceMappingURL=index.js.map