/* eslint-disable camelcase */
const { crypto_verify_32 } = require('./crypto_verify')
const Sha512 = require('sha512-universal')
const assert = require('nanoassert')

const crypto_auth_BYTES = 32
const crypto_auth_KEYBYTES = 32

function crypto_auth (out, input, k) {
  assert(out.byteLength === crypto_auth_BYTES, "out should be 'crypto_auth_BYTES' in length")
  assert(k.byteLength === crypto_auth_KEYBYTES, "key should be 'crypto_auth_KEYBYTES' in length")

  const out0 = new Uint8Array(64)
  const hmac = Sha512.HMAC(k)
  hmac.update(input)
  hmac.digest(out0)

  out.set(out0.subarray(0, 32))
}

function crypto_auth_verify (h, input, k) {
  assert(h.byteLength === crypto_auth_BYTES, "h should be 'crypto_auth_BYTES' in length")
  assert(k.byteLength === crypto_auth_KEYBYTES, "key should be 'crypto_auth_KEYBYTES' in length")

  const correct = Sha512.HMAC(k).update(input).digest()

  return crypto_verify_32(h, 0, correct, 0)
}

module.exports = {
  crypto_auth_BYTES,
  crypto_auth_KEYBYTES,
  crypto_auth,
  crypto_auth_verify
}
