{
  'variables': {
    'target_endianness%': '<!(node ../scripts/endianness.js)',
    'sodium_version%': '<!(node ../scripts/version.js)',
  },
  'targets': [{
    'target_name': 'libsodium',
    'type': 'static_library',
    'include_dirs': [
      './libsodium/src/libsodium/include/sodium',
    ],
    'defines': [
      '_GNU_SOURCE=1',
      'SODIUM_STATIC=1',
      'CONFIGURED=1',
      'DEV_MODE=1',
      'HAVE_ATOMIC_OPS=1',
      'HAVE_C11_MEMORY_FENCES=1',
      'HAVE_GCC_MEMORY_FENCES=1',
      'HAVE_INLINE_ASM=1',
      'HAVE_INTTYPES_H=1',
      'HAVE_STDINT_H=1',
    ],
    'xcode_settings': {
      'OTHER_CFLAGS': [
        '-fvisibility=hidden',
        '-fno-strict-aliasing',
        '-fwrapv',
        '-flax-vector-conversions',
        '-Wno-unused-function',
        '-Wno-unknown-pragmas',
        '-Wno-unused-but-set-variable',
      ],
    },
    'sources': [
      './libsodium/src/libsodium/crypto_aead/aes256gcm/aesni/aead_aes256gcm_aesni.c',
      './libsodium/src/libsodium/crypto_aead/chacha20poly1305/sodium/aead_chacha20poly1305.c',
      './libsodium/src/libsodium/crypto_aead/xchacha20poly1305/sodium/aead_xchacha20poly1305.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/argon2-core.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/argon2-encoding.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/argon2-fill-block-avx2.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/argon2-fill-block-avx512f.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/argon2-fill-block-ref.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/argon2-fill-block-ssse3.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/argon2.c',
      './libsodium/src/libsodium/crypto_auth/hmacsha256/auth_hmacsha256.c',
      './libsodium/src/libsodium/crypto_auth/hmacsha512/auth_hmacsha512.c',
      './libsodium/src/libsodium/crypto_auth/hmacsha512256/auth_hmacsha512256.c',
      './libsodium/src/libsodium/crypto_generichash/blake2b/ref/blake2b-compress-avx2.c',
      './libsodium/src/libsodium/crypto_generichash/blake2b/ref/blake2b-compress-ref.c',
      './libsodium/src/libsodium/crypto_generichash/blake2b/ref/blake2b-compress-sse41.c',
      './libsodium/src/libsodium/crypto_generichash/blake2b/ref/blake2b-compress-ssse3.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/blake2b-long.c',
      './libsodium/src/libsodium/crypto_generichash/blake2b/ref/blake2b-ref.c',
      './libsodium/src/libsodium/crypto_box/curve25519xchacha20poly1305/box_curve25519xchacha20poly1305.c',
      './libsodium/src/libsodium/crypto_box/curve25519xsalsa20poly1305/box_curve25519xsalsa20poly1305.c',
      './libsodium/src/libsodium/crypto_box/curve25519xchacha20poly1305/box_seal_curve25519xchacha20poly1305.c',
      './libsodium/src/libsodium/crypto_stream/chacha20/dolbeau/chacha20_dolbeau-avx2.c',
      './libsodium/src/libsodium/crypto_stream/chacha20/dolbeau/chacha20_dolbeau-ssse3.c',
      './libsodium/src/libsodium/crypto_stream/chacha20/ref/chacha20_ref.c',
      './libsodium/src/libsodium/sodium/codecs.c',
      './libsodium/src/libsodium/sodium/core.c',
      './libsodium/src/libsodium/crypto_core/ed25519/core_ed25519.c',
      './libsodium/src/libsodium/crypto_core/hchacha20/core_hchacha20.c',
      './libsodium/src/libsodium/crypto_core/hsalsa20/core_hsalsa20.c',
      './libsodium/src/libsodium/crypto_core/hsalsa20/ref2/core_hsalsa20_ref2.c',
      './libsodium/src/libsodium/crypto_core/ed25519/core_ristretto255.c',
      './libsodium/src/libsodium/crypto_core/salsa/ref/core_salsa_ref.c',
      './libsodium/src/libsodium/crypto_auth/crypto_auth.c',
      './libsodium/src/libsodium/crypto_box/crypto_box.c',
      './libsodium/src/libsodium/crypto_box/crypto_box_easy.c',
      './libsodium/src/libsodium/crypto_box/crypto_box_seal.c',
      './libsodium/src/libsodium/crypto_generichash/crypto_generichash.c',
      './libsodium/src/libsodium/crypto_hash/crypto_hash.c',
      './libsodium/src/libsodium/crypto_kdf/crypto_kdf.c',
      './libsodium/src/libsodium/crypto_kx/crypto_kx.c',
      './libsodium/src/libsodium/crypto_onetimeauth/crypto_onetimeauth.c',
      './libsodium/src/libsodium/crypto_pwhash/crypto_pwhash.c',
      './libsodium/src/libsodium/crypto_scalarmult/crypto_scalarmult.c',
      './libsodium/src/libsodium/crypto_pwhash/scryptsalsa208sha256/crypto_scrypt-common.c',
      './libsodium/src/libsodium/crypto_secretbox/crypto_secretbox.c',
      './libsodium/src/libsodium/crypto_secretbox/crypto_secretbox_easy.c',
      './libsodium/src/libsodium/crypto_shorthash/crypto_shorthash.c',
      './libsodium/src/libsodium/crypto_sign/crypto_sign.c',
      './libsodium/src/libsodium/crypto_stream/crypto_stream.c',
      './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/curve25519_sandy2x.c',
      './libsodium/src/libsodium/crypto_core/ed25519/ref10/ed25519_ref10.c',
      './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/fe51_invert.c',
      './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/fe_frombytes_sandy2x.c',
      './libsodium/src/libsodium/crypto_generichash/blake2b/generichash_blake2.c',
      './libsodium/src/libsodium/crypto_generichash/blake2b/ref/generichash_blake2b.c',
      './libsodium/src/libsodium/crypto_hash/sha256/hash_sha256.c',
      './libsodium/src/libsodium/crypto_hash/sha256/cp/hash_sha256_cp.c',
      './libsodium/src/libsodium/crypto_hash/sha512/hash_sha512.c',
      './libsodium/src/libsodium/crypto_hash/sha512/cp/hash_sha512_cp.c',
      './libsodium/src/libsodium/crypto_kdf/blake2b/kdf_blake2b.c',
      './libsodium/src/libsodium/crypto_sign/ed25519/ref10/keypair.c',
      './libsodium/src/libsodium/crypto_sign/ed25519/ref10/obsolete.c',
      './libsodium/src/libsodium/crypto_onetimeauth/poly1305/onetimeauth_poly1305.c',
      './libsodium/src/libsodium/crypto_sign/ed25519/ref10/open.c',
      './libsodium/src/libsodium/crypto_pwhash/scryptsalsa208sha256/pbkdf2-sha256.c',
      './libsodium/src/libsodium/crypto_onetimeauth/poly1305/donna/poly1305_donna.c',
      './libsodium/src/libsodium/crypto_onetimeauth/poly1305/sse2/poly1305_sse2.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/pwhash_argon2i.c',
      './libsodium/src/libsodium/crypto_pwhash/argon2/pwhash_argon2id.c',
      './libsodium/src/libsodium/crypto_pwhash/scryptsalsa208sha256/pwhash_scryptsalsa208sha256.c',
      './libsodium/src/libsodium/crypto_pwhash/scryptsalsa208sha256/nosse/pwhash_scryptsalsa208sha256_nosse.c',
      './libsodium/src/libsodium/crypto_pwhash/scryptsalsa208sha256/sse/pwhash_scryptsalsa208sha256_sse.c',
      './libsodium/src/libsodium/randombytes/randombytes.c',
      './libsodium/src/libsodium/randombytes/internal/randombytes_internal_random.c',
      './libsodium/src/libsodium/randombytes/sysrandom/randombytes_sysrandom.c',
      './libsodium/src/libsodium/sodium/runtime.c',
      './libsodium/src/libsodium/crypto_stream/salsa20/ref/salsa20_ref.c',
      './libsodium/src/libsodium/crypto_stream/salsa20/xmm6/salsa20_xmm6.c',
      './libsodium/src/libsodium/crypto_stream/salsa20/xmm6int/salsa20_xmm6int-avx2.c',
      './libsodium/src/libsodium/crypto_stream/salsa20/xmm6int/salsa20_xmm6int-sse2.c',
      './libsodium/src/libsodium/crypto_scalarmult/curve25519/scalarmult_curve25519.c',
      './libsodium/src/libsodium/crypto_scalarmult/ed25519/ref10/scalarmult_ed25519_ref10.c',
      './libsodium/src/libsodium/crypto_scalarmult/ristretto255/ref10/scalarmult_ristretto255_ref10.c',
      './libsodium/src/libsodium/crypto_pwhash/scryptsalsa208sha256/scrypt_platform.c',
      './libsodium/src/libsodium/crypto_secretbox/xchacha20poly1305/secretbox_xchacha20poly1305.c',
      './libsodium/src/libsodium/crypto_secretbox/xsalsa20poly1305/secretbox_xsalsa20poly1305.c',
      './libsodium/src/libsodium/crypto_secretstream/xchacha20poly1305/secretstream_xchacha20poly1305.c',
      './libsodium/src/libsodium/crypto_shorthash/siphash24/shorthash_siphash24.c',
      './libsodium/src/libsodium/crypto_shorthash/siphash24/ref/shorthash_siphash24_ref.c',
      './libsodium/src/libsodium/crypto_shorthash/siphash24/shorthash_siphashx24.c',
      './libsodium/src/libsodium/crypto_shorthash/siphash24/ref/shorthash_siphashx24_ref.c',
      './libsodium/src/libsodium/crypto_sign/ed25519/ref10/sign.c',
      './libsodium/src/libsodium/crypto_sign/ed25519/sign_ed25519.c',
      './libsodium/src/libsodium/crypto_stream/chacha20/stream_chacha20.c',
      './libsodium/src/libsodium/crypto_stream/salsa20/stream_salsa20.c',
      './libsodium/src/libsodium/crypto_stream/salsa208/stream_salsa208.c',
      './libsodium/src/libsodium/crypto_stream/salsa208/ref/stream_salsa208_ref.c',
      './libsodium/src/libsodium/crypto_stream/salsa2012/stream_salsa2012.c',
      './libsodium/src/libsodium/crypto_stream/salsa2012/ref/stream_salsa2012_ref.c',
      './libsodium/src/libsodium/crypto_stream/xchacha20/stream_xchacha20.c',
      './libsodium/src/libsodium/crypto_stream/xsalsa20/stream_xsalsa20.c',
      './libsodium/src/libsodium/sodium/utils.c',
      './libsodium/src/libsodium/crypto_verify/sodium/verify.c',
      './libsodium/src/libsodium/sodium/version.c',
      './libsodium/src/libsodium/crypto_scalarmult/curve25519/ref10/x25519_ref10.c',
    ],
    'configurations': {
      'Debug': {
        'defines': ['DEBUG'],
      },
      'Release': {
        'defines': ['NDEBUG'],
      },
    },
    'conditions': [
      ['OS=="mac"', {
        'defines': [
          'ASM_HIDE_SYMBOL=.private_extern',
          'TLS=_Thread_local',
          'HAVE_ARC4RANDOM=1',
          'HAVE_ARC4RANDOM_BUF=1',
          'HAVE_CATCHABLE_ABRT=1',
          'HAVE_CATCHABLE_SEGV=1',
          'HAVE_GETENTROPY=1',
          'HAVE_GETPID=1',
          'HAVE_MADVISE=1',
          'HAVE_MEMSET_S=1',
          'HAVE_MLOCK=1',
          'HAVE_MMAP=1',
          'HAVE_MPROTECT=1',
          'HAVE_NANOSLEEP=1',
          'HAVE_POSIX_MEMALIGN=1',
          'HAVE_PTHREAD=1',
          'HAVE_PTHREAD_PRIO_INHERIT=1',
          'HAVE_RAISE=1',
          'HAVE_SYSCONF=1',
          'HAVE_SYS_MMAN_H=1',
          'HAVE_SYS_PARAM_H=1',
          'HAVE_SYS_RANDOM_H=1',
          'HAVE_WEAK_SYMBOLS=1',
        ]
      }],
      ['OS=="linux"', {
        'cflags': [
          '-fno-strict-overflow',
        ],
        'defines': [
          'ASM_HIDE_SYMBOL=.hidden',
          'TLS=_Thread_local',
          'HAVE_CATCHABLE_ABRT=1',
          'HAVE_CATCHABLE_SEGV=1',
          'HAVE_GETPID=1',
          'HAVE_INLINE_ASM=1',
          'HAVE_MADVISE=1',
          'HAVE_MLOCK=1',
          'HAVE_MMAP=1',
          'HAVE_MPROTECT=1',
          'HAVE_NANOSLEEP=1',
          'HAVE_POSIX_MEMALIGN=1',
          'HAVE_PTHREAD_PRIO_INHERIT=1',
          'HAVE_PTHREAD=1',
          'HAVE_RAISE=1',
          'HAVE_SYSCONF=1',
          'HAVE_SYS_AUXV_H=1',
          'HAVE_SYS_MMAN_H=1',
          'HAVE_SYS_PARAM_H=1',
          'HAVE_SYS_RANDOM_H=1',
          'HAVE_WEAK_SYMBOLS=1',
        ],
      }],
      ['OS=="win"', {
        'defines': [
          '_CRT_SECURE_NO_WARNINGS=1',
          'HAVE_RAISE=1',
          'HAVE_SYS_PARAM_H=1',
        ],
      }, {
        'cflags': [
          '-fvisibility=hidden',
          '-fno-strict-aliasing',
          '-fwrapv',
          '-flax-vector-conversions',
          '-Wno-unused-function',
          '-Wno-unknown-pragmas',
          '-Wno-unused-but-set-variable',
        ],
      }],
      ['target_arch=="x64"', {
        'defines': [
          'HAVE_CPUID=1',
          'HAVE_MMINTRIN_H=1',
          'HAVE_EMMINTRIN_H=1',
          'HAVE_PMMINTRIN_H=1',
          'HAVE_SMMINTRIN_H=1',
          'HAVE_TMMINTRIN_H=1',
        ],
        'conditions': [
          ['OS!="win"', {
            'defines': [
              'HAVE_TI_MODE=1',
              'HAVE_AMD64_ASM=1',
              'HAVE_AVX_ASM=1',
            ],
            'sources': [
              './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/consts.S',
              './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/fe51_mul.S',
              './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/fe51_nsquare.S',
              './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/fe51_pack.S',
              './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/ladder.S',
              './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/ladder_base.S',
              './libsodium/src/libsodium/crypto_stream/salsa20/xmm6/salsa20_xmm6-asm.S',
              './libsodium/src/libsodium/crypto_scalarmult/curve25519/sandy2x/sandy2x.S',
            ],
          }],
        ],
      }],
      ['target_arch=="arm64"', {
        'conditions': [
          ['OS!="win"', {
            'defines': [
              'HAVE_TI_MODE=1',
            ],
          }],
        ]
      }],
      ['target_endianness=="le"', {
        'defines': [
          'NATIVE_LITTLE_ENDIAN=1',
        ],
      }, {
        'defines': [
          'NATIVE_BIG_ENDIAN=1',
        ],
      }]
    ],
  }],
}
