# sodium-universal

Universal wrapper for `sodium-javascript` and `sodium-native` working in Node.js and the Browser

```sh
npm install sodium-universal
```

`sodium-native` ships with prebuilds for macOS, Windows, and Linux.

Note that the module itself is generated on a prepublish hook.

## Usage

```js
var sodium = require('sodium-universal')

var rnd = Buffer.allocUnsafe(12) // Cryptographically random data
sodium.randombytes_buf(rnd)

console.log(rnd.toString('hex'))

```

Works seamlessly with Node.js:

```sh
$ node example.js
c7dbd46a6cc84ff2e0d1285c
```

And the browser:

First install the peer dep, `sodium-javascript`.

```sh
npm install --save sodium-javascript
```

And then browserify

```sh
browserify example.js > bundle.js
```

## Introduction

[`libsodium`](https://download.libsodium.org/doc/) is a collection of cryptographic primitives, providing a low-level foundation to build higher-level cryptographic applications and protocols. It is often put in contrast to RSA based cryptography and OpenSSL, even though they all share overlapping algorithms and target slightly different audiences. Sodium is a collection of modern collection of primitives, fulfilling the same cryptographic tasks, but based on simpler and more efficient algorithms.

This library provides seamless bindings to [`sodium-native`](https://github.com/sodium-friends/sodium-native), which is the original C implementation of `libsodium` exposed as a Node native module. For the browser we expose [`sodium-javascript`](https://github.com/sodium-friends/sodium-javascript), using the `package.json` [`browser`](https://github.com/defunctzombie/package-browser-field-spec) field, which is supported by most bundlers.

## API

Please refer to [`sodium-native`](https://github.com/sodium-friends/sodium-native#api) and [`sodium-javascript`](https://github.com/sodium-friends/sodium-javascript#api). Note that the two modules do not yet have feature parity, where `sodium-native` is the more featureful of the two.

## Compatibilty

<!-- Generated by build-scripts/symbols.js with
     sodium-native@3.2.0
     sodium-javascript@0.6.0 -->
|                     C Library Symbol                     |   `sodium-native`    | `sodium-javascript`  |
|:--------------------------------------------------------:|:--------------------:|:--------------------:|
| `crypto_aead_chacha20poly1305_ietf_ABYTES`               |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_chacha20poly1305_ietf_decrypt`              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_chacha20poly1305_ietf_decrypt_detached`     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_chacha20poly1305_ietf_encrypt`              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_chacha20poly1305_ietf_encrypt_detached`     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_chacha20poly1305_ietf_KEYBYTES`             |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_chacha20poly1305_ietf_keygen`               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_chacha20poly1305_ietf_MESSAGEBYTES_MAX`     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_chacha20poly1305_ietf_NPUBBYTES`            |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_chacha20poly1305_ietf_NSECBYTES`            |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_aead_xchacha20poly1305_ietf_ABYTES`              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_decrypt`             |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_decrypt_detached`    |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_encrypt`             |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_encrypt_detached`    |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_KEYBYTES`            |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_keygen`              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_MESSAGEBYTES_MAX`    |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_NPUBBYTES`           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_aead_xchacha20poly1305_ietf_NSECBYTES`           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_auth`                                            |  :white_check_mark:  | :small_red_triangle: |
| `crypto_auth_BYTES`                                      |  :white_check_mark:  | :small_red_triangle: |
| `crypto_auth_KEYBYTES`                                   |  :white_check_mark:  | :small_red_triangle: |
| `crypto_auth_verify`                                     |  :white_check_mark:  | :small_red_triangle: |
| `crypto_box_BEFORENMBYTES`                               | :small_red_triangle: |  :white_check_mark:  |
| `crypto_box_BOXZEROBYTES`                                | :small_red_triangle: |  :white_check_mark:  |
| `crypto_box_detached`                                    |  :white_check_mark:  | :small_red_triangle: |
| `crypto_box_easy`                                        |  :white_check_mark:  | :small_red_triangle: |
| `crypto_box_keypair`                                     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_MACBYTES`                                    |  :white_check_mark:  | :small_red_triangle: |
| `crypto_box_NONCEBYTES`                                  |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_open_detached`                               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_box_open_easy`                                   |  :white_check_mark:  | :small_red_triangle: |
| `crypto_box_PUBLICKEYBYTES`                              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_seal`                                        |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_seal_open`                                   |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_SEALBYTES`                                   |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_SECRETKEYBYTES`                              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_seed_keypair`                                |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_SEEDBYTES`                                   |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_box_ZEROBYTES`                                   | :small_red_triangle: |  :white_check_mark:  |
| `crypto_core_ed25519_add`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_BYTES`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_from_uniform`                       |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_is_valid_point`                     |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_NONREDUCEDSCALARBYTES`              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_scalar_add`                         |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_scalar_complement`                  |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_scalar_invert`                      |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_scalar_negate`                      |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_scalar_random`                      |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_scalar_reduce`                      |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_scalar_sub`                         |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_SCALARBYTES`                        |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_sub`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_core_ed25519_UNIFORMBYTES`                       |  :white_check_mark:  | :small_red_triangle: |
| `crypto_generichash`                                     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_generichash_BYTES`                               |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_generichash_BYTES_MAX`                           |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_generichash_BYTES_MIN`                           |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_generichash_final`                               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_generichash_init`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_generichash_KEYBYTES`                            |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_generichash_KEYBYTES_MAX`                        |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_generichash_KEYBYTES_MIN`                        |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_generichash_keygen`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_generichash_STATEBYTES`                          |  :white_check_mark:  | :small_red_triangle: |
| `crypto_generichash_update`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_hash`                                            |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_hash_BYTES`                                      |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_hash_sha256`                                     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_hash_sha256_BYTES`                               |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_hash_sha256_final`                               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_hash_sha256_init`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_hash_sha256_STATEBYTES`                          |  :white_check_mark:  | :small_red_triangle: |
| `crypto_hash_sha256_update`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_hash_sha512`                                     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_hash_sha512_BYTES`                               |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_hash_sha512_final`                               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_hash_sha512_init`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_hash_sha512_STATEBYTES`                          |  :white_check_mark:  | :small_red_triangle: |
| `crypto_hash_sha512_update`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_kdf_BYTES_MAX`                                   |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kdf_BYTES_MIN`                                   |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kdf_CONTEXTBYTES`                                |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kdf_derive_from_key`                             |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kdf_KEYBYTES`                                    |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kdf_keygen`                                      |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kx_client_session_keys`                          |  :white_check_mark:  | :small_red_triangle: |
| `crypto_kx_keypair`                                      |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kx_PUBLICKEYBYTES`                               |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kx_SECRETKEYBYTES`                               |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kx_seed_keypair`                                 |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kx_SEEDBYTES`                                    |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_kx_server_session_keys`                          |  :white_check_mark:  | :small_red_triangle: |
| `crypto_kx_SESSIONKEYBYTES`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_onetimeauth`                                     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_onetimeauth_BYTES`                               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_onetimeauth_final`                               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_onetimeauth_init`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_onetimeauth_KEYBYTES`                            |  :white_check_mark:  | :small_red_triangle: |
| `crypto_onetimeauth_STATEBYTES`                          |  :white_check_mark:  | :small_red_triangle: |
| `crypto_onetimeauth_update`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_onetimeauth_verify`                              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_pwhash`                                          |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_BYTES_MAX`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_BYTES_MIN`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_SALTBYTES`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_scryptsalsa208sha256`                     |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_scryptsalsa208sha256_BYTES_MAX`           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_scryptsalsa208sha256_BYTES_MIN`           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_scryptsalsa208sha256_SALTBYTES`           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_scryptsalsa208sha256_str`                 |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_scryptsalsa208sha256_str_needs_rehash`    |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_scryptsalsa208sha256_str_verify`          |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_scryptsalsa208sha256_STRBYTES`            |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_str`                                      |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_str_needs_rehash`                         |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_str_verify`                               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_pwhash_STRBYTES`                                 |  :white_check_mark:  | :small_red_triangle: |
| `crypto_scalarmult`                                      |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_scalarmult_base`                                 |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_scalarmult_BYTES`                                |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_scalarmult_ed25519`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_scalarmult_ed25519_base`                         |  :white_check_mark:  | :small_red_triangle: |
| `crypto_scalarmult_ed25519_base_noclamp`                 |  :white_check_mark:  | :small_red_triangle: |
| `crypto_scalarmult_ed25519_BYTES`                        |  :white_check_mark:  | :small_red_triangle: |
| `crypto_scalarmult_ed25519_noclamp`                      |  :white_check_mark:  | :small_red_triangle: |
| `crypto_scalarmult_ed25519_SCALARBYTES`                  |  :white_check_mark:  | :small_red_triangle: |
| `crypto_scalarmult_SCALARBYTES`                          |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_secretbox`                                       | :small_red_triangle: |  :white_check_mark:  |
| `crypto_secretbox_BOXZEROBYTES`                          | :small_red_triangle: |  :white_check_mark:  |
| `crypto_secretbox_detached`                              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_secretbox_easy`                                  |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_secretbox_KEYBYTES`                              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_secretbox_MACBYTES`                              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_secretbox_NONCEBYTES`                            |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_secretbox_open`                                  | :small_red_triangle: |  :white_check_mark:  |
| `crypto_secretbox_open_detached`                         |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_secretbox_open_easy`                             |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_secretbox_ZEROBYTES`                             | :small_red_triangle: |  :white_check_mark:  |
| `crypto_secretstream_xchacha20poly1305_ABYTES`           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_HEADERBYTES`      |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_init_pull`        |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_init_push`        |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_KEYBYTES`         |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_keygen`           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_MESSAGEBYTES_MAX` |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_pull`             |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_push`             |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_rekey`            |  :white_check_mark:  | :small_red_triangle: |
| `crypto_secretstream_xchacha20poly1305_STATEBYTES`       |  :white_check_mark:  | :small_red_triangle: |
| `crypto_shorthash`                                       |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_shorthash_BYTES`                                 |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_shorthash_KEYBYTES`                              |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign`                                            |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_BYTES`                                      |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_detached`                                   |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_ed25519_pk_to_curve25519`                   |  :white_check_mark:  | :small_red_triangle: |
| `crypto_sign_ed25519_sk_to_curve25519`                   |  :white_check_mark:  | :small_red_triangle: |
| `crypto_sign_ed25519_sk_to_pk`                           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_sign_keypair`                                    |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_open`                                       |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_PUBLICKEYBYTES`                             |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_SECRETKEYBYTES`                             |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_seed_keypair`                               |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_SEEDBYTES`                                  |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_sign_verify_detached`                            |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream`                                          |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20`                                 |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_ietf`                            |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_ietf_KEYBYTES`                   |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_ietf_MESSAGEBYTES_MAX`           |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_ietf_NONCEBYTES`                 |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_ietf_xor`                        |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_ietf_xor_ic`                     |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_KEYBYTES`                        |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_MESSAGEBYTES_MAX`                |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_NONCEBYTES`                      |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_xor`                             |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_chacha20_xor_ic`                          |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_KEYBYTES`                                 |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_NONCEBYTES`                               |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_stream_salsa20_KEYBYTES`                         |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_salsa20_MESSAGEBYTES_MAX`                 |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_salsa20_NONCEBYTES`                       |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_salsa20_xor`                              |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_salsa20_xor_ic`                           |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_xchacha20`                                |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_xchacha20_KEYBYTES`                       |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_xchacha20_MESSAGEBYTES_MAX`               |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_xchacha20_NONCEBYTES`                     |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_xchacha20_xor`                            |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_xchacha20_xor_ic`                         |  :white_check_mark:  | :small_red_triangle: |
| `crypto_stream_xor`                                      |  :white_check_mark:  |  :white_check_mark:  |
| `crypto_verify_16`                                       | :small_red_triangle: |  :white_check_mark:  |
| `crypto_verify_32`                                       | :small_red_triangle: |  :white_check_mark:  |
| `randombytes_buf`                                        |  :white_check_mark:  |  :white_check_mark:  |
| `randombytes_buf_deterministic`                          |  :white_check_mark:  | :small_red_triangle: |
| `randombytes_random`                                     |  :white_check_mark:  | :small_red_triangle: |
| `randombytes_SEEDBYTES`                                  |  :white_check_mark:  | :small_red_triangle: |
| `randombytes_uniform`                                    |  :white_check_mark:  | :small_red_triangle: |
| `sodium_add`                                             |  :white_check_mark:  | :small_red_triangle: |
| `sodium_compare`                                         |  :white_check_mark:  | :small_red_triangle: |
| `sodium_free`                                            |  :white_check_mark:  | :small_red_triangle: |
| `sodium_increment`                                       |  :white_check_mark:  | :small_red_triangle: |
| `sodium_is_zero`                                         |  :white_check_mark:  |  :white_check_mark:  |
| `sodium_malloc`                                          |  :white_check_mark:  |  :white_check_mark:  |
| `sodium_memcmp`                                          |  :white_check_mark:  |  :white_check_mark:  |
| `sodium_memzero`                                         |  :white_check_mark:  |  :white_check_mark:  |
| `sodium_mlock`                                           |  :white_check_mark:  | :small_red_triangle: |
| `sodium_mprotect_noaccess`                               |  :white_check_mark:  | :small_red_triangle: |
| `sodium_mprotect_readonly`                               |  :white_check_mark:  | :small_red_triangle: |
| `sodium_mprotect_readwrite`                              |  :white_check_mark:  | :small_red_triangle: |
| `sodium_munlock`                                         |  :white_check_mark:  | :small_red_triangle: |
| `sodium_pad`                                             |  :white_check_mark:  | :small_red_triangle: |
| `sodium_sub`                                             |  :white_check_mark:  | :small_red_triangle: |
| `sodium_unpad`                                           |  :white_check_mark:  | :small_red_triangle: |

### Missing altogether (Ctrl + F friendly)

`crypto_aead_aes256gcm_ABYTES`, `crypto_aead_aes256gcm_beforenm`, `crypto_aead_aes256gcm_decrypt`, `crypto_aead_aes256gcm_decrypt_afternm`, `crypto_aead_aes256gcm_decrypt_detached`, `crypto_aead_aes256gcm_decrypt_detached_afternm`, `crypto_aead_aes256gcm_encrypt`, `crypto_aead_aes256gcm_encrypt_afternm`, `crypto_aead_aes256gcm_encrypt_detached`, `crypto_aead_aes256gcm_encrypt_detached_afternm`, `crypto_aead_aes256gcm_is_available`, `crypto_aead_aes256gcm_KEYBYTES`, `crypto_aead_aes256gcm_keygen`, `crypto_aead_aes256gcm_MESSAGEBYTES_MAX`, `crypto_aead_aes256gcm_NPUBBYTES`, `crypto_aead_aes256gcm_NSECBYTES`, `crypto_aead_aes256gcm_STATEBYTES`, `crypto_aead_chacha20poly1305_ABYTES`, `crypto_aead_chacha20poly1305_decrypt`, `crypto_aead_chacha20poly1305_decrypt_detached`, `crypto_aead_chacha20poly1305_encrypt`, `crypto_aead_chacha20poly1305_encrypt_detached`, `crypto_aead_chacha20poly1305_KEYBYTES`, `crypto_aead_chacha20poly1305_keygen`, `crypto_aead_chacha20poly1305_MESSAGEBYTES_MAX`, `crypto_aead_chacha20poly1305_NPUBBYTES`, `crypto_aead_chacha20poly1305_NSECBYTES`, `crypto_auth_hmacsha256`, `crypto_auth_hmacsha256_BYTES`, `crypto_auth_hmacsha256_final`, `crypto_auth_hmacsha256_init`, `crypto_auth_hmacsha256_KEYBYTES`, `crypto_auth_hmacsha256_keygen`, `crypto_auth_hmacsha256_STATEBYTES`, `crypto_auth_hmacsha256_update`, `crypto_auth_hmacsha256_verify`, `crypto_auth_hmacsha512`, `crypto_auth_hmacsha512256`, `crypto_auth_hmacsha512256_BYTES`, `crypto_auth_hmacsha512256_final`, `crypto_auth_hmacsha512256_init`, `crypto_auth_hmacsha512256_KEYBYTES`, `crypto_auth_hmacsha512256_keygen`, `crypto_auth_hmacsha512256_STATEBYTES`, `crypto_auth_hmacsha512256_update`, `crypto_auth_hmacsha512256_verify`, `crypto_auth_hmacsha512_BYTES`, `crypto_auth_hmacsha512_final`, `crypto_auth_hmacsha512_init`, `crypto_auth_hmacsha512_KEYBYTES`, `crypto_auth_hmacsha512_keygen`, `crypto_auth_hmacsha512_STATEBYTES`, `crypto_auth_hmacsha512_update`, `crypto_auth_hmacsha512_verify`, `crypto_auth_keygen`, `crypto_auth_primitive`, `crypto_box`, `crypto_box_afternm`, `crypto_box_beforenm`, `crypto_box_curve25519xchacha20poly1305_beforenm`, `crypto_box_curve25519xchacha20poly1305_BEFORENMBYTES`, `crypto_box_curve25519xchacha20poly1305_detached`, `crypto_box_curve25519xchacha20poly1305_detached_afternm`, `crypto_box_curve25519xchacha20poly1305_easy`, `crypto_box_curve25519xchacha20poly1305_easy_afternm`, `crypto_box_curve25519xchacha20poly1305_keypair`, `crypto_box_curve25519xchacha20poly1305_MACBYTES`, `crypto_box_curve25519xchacha20poly1305_MESSAGEBYTES_MAX`, `crypto_box_curve25519xchacha20poly1305_NONCEBYTES`, `crypto_box_curve25519xchacha20poly1305_open_detached`, `crypto_box_curve25519xchacha20poly1305_open_detached_afternm`, `crypto_box_curve25519xchacha20poly1305_open_easy`, `crypto_box_curve25519xchacha20poly1305_open_easy_afternm`, `crypto_box_curve25519xchacha20poly1305_PUBLICKEYBYTES`, `crypto_box_curve25519xchacha20poly1305_seal`, `crypto_box_curve25519xchacha20poly1305_seal_open`, `crypto_box_curve25519xchacha20poly1305_SEALBYTES`, `crypto_box_curve25519xchacha20poly1305_SECRETKEYBYTES`, `crypto_box_curve25519xchacha20poly1305_seed_keypair`, `crypto_box_curve25519xchacha20poly1305_SEEDBYTES`, `crypto_box_curve25519xsalsa20poly1305`, `crypto_box_curve25519xsalsa20poly1305_afternm`, `crypto_box_curve25519xsalsa20poly1305_beforenm`, `crypto_box_curve25519xsalsa20poly1305_BEFORENMBYTES`, `crypto_box_curve25519xsalsa20poly1305_BOXZEROBYTES`, `crypto_box_curve25519xsalsa20poly1305_keypair`, `crypto_box_curve25519xsalsa20poly1305_MACBYTES`, `crypto_box_curve25519xsalsa20poly1305_MESSAGEBYTES_MAX`, `crypto_box_curve25519xsalsa20poly1305_NONCEBYTES`, `crypto_box_curve25519xsalsa20poly1305_open`, `crypto_box_curve25519xsalsa20poly1305_open_afternm`, `crypto_box_curve25519xsalsa20poly1305_PUBLICKEYBYTES`, `crypto_box_curve25519xsalsa20poly1305_SECRETKEYBYTES`, `crypto_box_curve25519xsalsa20poly1305_seed_keypair`, `crypto_box_curve25519xsalsa20poly1305_SEEDBYTES`, `crypto_box_curve25519xsalsa20poly1305_ZEROBYTES`, `crypto_box_detached_afternm`, `crypto_box_easy_afternm`, `crypto_box_MESSAGEBYTES_MAX`, `crypto_box_open`, `crypto_box_open_afternm`, `crypto_box_open_detached_afternm`, `crypto_box_open_easy_afternm`, `crypto_box_primitive`, `crypto_core_ed25519_from_hash`, `crypto_core_ed25519_HASHBYTES`, `crypto_core_ed25519_random`, `crypto_core_ed25519_scalar_mul`, `crypto_core_hchacha20`, `crypto_core_hchacha20_CONSTBYTES`, `crypto_core_hchacha20_INPUTBYTES`, `crypto_core_hchacha20_KEYBYTES`, `crypto_core_hchacha20_OUTPUTBYTES`, `crypto_core_hsalsa20`, `crypto_core_hsalsa20_CONSTBYTES`, `crypto_core_hsalsa20_INPUTBYTES`, `crypto_core_hsalsa20_KEYBYTES`, `crypto_core_hsalsa20_OUTPUTBYTES`, `crypto_core_ristretto255_add`, `crypto_core_ristretto255_BYTES`, `crypto_core_ristretto255_from_hash`, `crypto_core_ristretto255_HASHBYTES`, `crypto_core_ristretto255_is_valid_point`, `crypto_core_ristretto255_NONREDUCEDSCALARBYTES`, `crypto_core_ristretto255_random`, `crypto_core_ristretto255_scalar_add`, `crypto_core_ristretto255_scalar_complement`, `crypto_core_ristretto255_scalar_invert`, `crypto_core_ristretto255_scalar_mul`, `crypto_core_ristretto255_scalar_negate`, `crypto_core_ristretto255_scalar_random`, `crypto_core_ristretto255_scalar_reduce`, `crypto_core_ristretto255_scalar_sub`, `crypto_core_ristretto255_SCALARBYTES`, `crypto_core_ristretto255_sub`, `crypto_core_salsa20`, `crypto_core_salsa2012`, `crypto_core_salsa2012_CONSTBYTES`, `crypto_core_salsa2012_INPUTBYTES`, `crypto_core_salsa2012_KEYBYTES`, `crypto_core_salsa2012_OUTPUTBYTES`, `crypto_core_salsa208`, `crypto_core_salsa208_CONSTBYTES`, `crypto_core_salsa208_INPUTBYTES`, `crypto_core_salsa208_KEYBYTES`, `crypto_core_salsa208_OUTPUTBYTES`, `crypto_core_salsa20_CONSTBYTES`, `crypto_core_salsa20_INPUTBYTES`, `crypto_core_salsa20_KEYBYTES`, `crypto_core_salsa20_OUTPUTBYTES`, `crypto_generichash_blake2b`, `crypto_generichash_blake2b_BYTES`, `crypto_generichash_blake2b_BYTES_MAX`, `crypto_generichash_blake2b_BYTES_MIN`, `crypto_generichash_blake2b_final`, `crypto_generichash_blake2b_init`, `crypto_generichash_blake2b_init_salt_personal`, `crypto_generichash_blake2b_KEYBYTES`, `crypto_generichash_blake2b_KEYBYTES_MAX`, `crypto_generichash_blake2b_KEYBYTES_MIN`, `crypto_generichash_blake2b_keygen`, `crypto_generichash_blake2b_PERSONALBYTES`, `crypto_generichash_blake2b_salt_personal`, `crypto_generichash_blake2b_SALTBYTES`, `crypto_generichash_blake2b_STATEBYTES`, `crypto_generichash_blake2b_update`, `crypto_generichash_primitive`, `crypto_hash_primitive`, `crypto_kdf_blake2b_BYTES_MAX`, `crypto_kdf_blake2b_BYTES_MIN`, `crypto_kdf_blake2b_CONTEXTBYTES`, `crypto_kdf_blake2b_derive_from_key`, `crypto_kdf_blake2b_KEYBYTES`, `crypto_kdf_primitive`, `crypto_kx_primitive`, `crypto_onetimeauth_keygen`, `crypto_onetimeauth_poly1305`, `crypto_onetimeauth_poly1305_BYTES`, `crypto_onetimeauth_poly1305_final`, `crypto_onetimeauth_poly1305_init`, `crypto_onetimeauth_poly1305_KEYBYTES`, `crypto_onetimeauth_poly1305_keygen`, `crypto_onetimeauth_poly1305_STATEBYTES`, `crypto_onetimeauth_poly1305_update`, `crypto_onetimeauth_poly1305_verify`, `crypto_onetimeauth_primitive`, `crypto_pwhash_alg_argon2i13`, `crypto_pwhash_alg_argon2id13`, `crypto_pwhash_alg_default`, `crypto_pwhash_argon2i`, `crypto_pwhash_argon2i_alg_argon2i13`, `crypto_pwhash_argon2i_BYTES_MAX`, `crypto_pwhash_argon2i_BYTES_MIN`, `crypto_pwhash_argon2i_memlimit_interactive`, `crypto_pwhash_argon2i_memlimit_max`, `crypto_pwhash_argon2i_memlimit_min`, `crypto_pwhash_argon2i_memlimit_moderate`, `crypto_pwhash_argon2i_memlimit_sensitive`, `crypto_pwhash_argon2i_opslimit_interactive`, `crypto_pwhash_argon2i_opslimit_max`, `crypto_pwhash_argon2i_opslimit_min`, `crypto_pwhash_argon2i_opslimit_moderate`, `crypto_pwhash_argon2i_opslimit_sensitive`, `crypto_pwhash_argon2i_passwd_max`, `crypto_pwhash_argon2i_passwd_min`, `crypto_pwhash_argon2i_SALTBYTES`, `crypto_pwhash_argon2i_str`, `crypto_pwhash_argon2i_str_needs_rehash`, `crypto_pwhash_argon2i_str_verify`, `crypto_pwhash_argon2i_STRBYTES`, `crypto_pwhash_argon2i_strprefix`, `crypto_pwhash_argon2id`, `crypto_pwhash_argon2id_alg_argon2id13`, `crypto_pwhash_argon2id_BYTES_MAX`, `crypto_pwhash_argon2id_BYTES_MIN`, `crypto_pwhash_argon2id_memlimit_interactive`, `crypto_pwhash_argon2id_memlimit_max`, `crypto_pwhash_argon2id_memlimit_min`, `crypto_pwhash_argon2id_memlimit_moderate`, `crypto_pwhash_argon2id_memlimit_sensitive`, `crypto_pwhash_argon2id_opslimit_interactive`, `crypto_pwhash_argon2id_opslimit_max`, `crypto_pwhash_argon2id_opslimit_min`, `crypto_pwhash_argon2id_opslimit_moderate`, `crypto_pwhash_argon2id_opslimit_sensitive`, `crypto_pwhash_argon2id_passwd_max`, `crypto_pwhash_argon2id_passwd_min`, `crypto_pwhash_argon2id_SALTBYTES`, `crypto_pwhash_argon2id_str`, `crypto_pwhash_argon2id_str_needs_rehash`, `crypto_pwhash_argon2id_str_verify`, `crypto_pwhash_argon2id_STRBYTES`, `crypto_pwhash_argon2id_strprefix`, `crypto_pwhash_memlimit_interactive`, `crypto_pwhash_memlimit_max`, `crypto_pwhash_memlimit_min`, `crypto_pwhash_memlimit_moderate`, `crypto_pwhash_memlimit_sensitive`, `crypto_pwhash_opslimit_interactive`, `crypto_pwhash_opslimit_max`, `crypto_pwhash_opslimit_min`, `crypto_pwhash_opslimit_moderate`, `crypto_pwhash_opslimit_sensitive`, `crypto_pwhash_passwd_max`, `crypto_pwhash_passwd_min`, `crypto_pwhash_primitive`, `crypto_pwhash_scryptsalsa208sha256_ll`, `crypto_pwhash_scryptsalsa208sha256_memlimit_interactive`, `crypto_pwhash_scryptsalsa208sha256_memlimit_max`, `crypto_pwhash_scryptsalsa208sha256_memlimit_min`, `crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive`, `crypto_pwhash_scryptsalsa208sha256_opslimit_interactive`, `crypto_pwhash_scryptsalsa208sha256_opslimit_max`, `crypto_pwhash_scryptsalsa208sha256_opslimit_min`, `crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive`, `crypto_pwhash_scryptsalsa208sha256_passwd_max`, `crypto_pwhash_scryptsalsa208sha256_passwd_min`, `crypto_pwhash_scryptsalsa208sha256_strprefix`, `crypto_pwhash_str_alg`, `crypto_pwhash_strprefix`, `crypto_scalarmult_curve25519`, `crypto_scalarmult_curve25519_base`, `crypto_scalarmult_curve25519_BYTES`, `crypto_scalarmult_curve25519_SCALARBYTES`, `crypto_scalarmult_primitive`, `crypto_scalarmult_ristretto255`, `crypto_scalarmult_ristretto255_base`, `crypto_scalarmult_ristretto255_BYTES`, `crypto_scalarmult_ristretto255_SCALARBYTES`, `crypto_secretbox_keygen`, `crypto_secretbox_MESSAGEBYTES_MAX`, `crypto_secretbox_primitive`, `crypto_secretbox_xchacha20poly1305_detached`, `crypto_secretbox_xchacha20poly1305_easy`, `crypto_secretbox_xchacha20poly1305_KEYBYTES`, `crypto_secretbox_xchacha20poly1305_MACBYTES`, `crypto_secretbox_xchacha20poly1305_MESSAGEBYTES_MAX`, `crypto_secretbox_xchacha20poly1305_NONCEBYTES`, `crypto_secretbox_xchacha20poly1305_open_detached`, `crypto_secretbox_xchacha20poly1305_open_easy`, `crypto_secretbox_xsalsa20poly1305`, `crypto_secretbox_xsalsa20poly1305_BOXZEROBYTES`, `crypto_secretbox_xsalsa20poly1305_KEYBYTES`, `crypto_secretbox_xsalsa20poly1305_keygen`, `crypto_secretbox_xsalsa20poly1305_MACBYTES`, `crypto_secretbox_xsalsa20poly1305_MESSAGEBYTES_MAX`, `crypto_secretbox_xsalsa20poly1305_NONCEBYTES`, `crypto_secretbox_xsalsa20poly1305_open`, `crypto_secretbox_xsalsa20poly1305_ZEROBYTES`, `crypto_secretstream_xchacha20poly1305_tag_final`, `crypto_secretstream_xchacha20poly1305_tag_message`, `crypto_secretstream_xchacha20poly1305_tag_push`, `crypto_secretstream_xchacha20poly1305_tag_rekey`, `crypto_shorthash_keygen`, `crypto_shorthash_primitive`, `crypto_shorthash_siphash24`, `crypto_shorthash_siphash24_BYTES`, `crypto_shorthash_siphash24_KEYBYTES`, `crypto_shorthash_siphashx24`, `crypto_shorthash_siphashx24_BYTES`, `crypto_shorthash_siphashx24_KEYBYTES`, `crypto_sign_ed25519`, `crypto_sign_ed25519_BYTES`, `crypto_sign_ed25519_detached`, `crypto_sign_ed25519_keypair`, `crypto_sign_ed25519_MESSAGEBYTES_MAX`, `crypto_sign_ed25519_open`, `crypto_sign_ed25519_PUBLICKEYBYTES`, `crypto_sign_ed25519_SECRETKEYBYTES`, `crypto_sign_ed25519_seed_keypair`, `crypto_sign_ed25519_SEEDBYTES`, `crypto_sign_ed25519_sk_to_seed`, `crypto_sign_ed25519_verify_detached`, `crypto_sign_ed25519ph_final_create`, `crypto_sign_ed25519ph_final_verify`, `crypto_sign_ed25519ph_init`, `crypto_sign_ed25519ph_STATEBYTES`, `crypto_sign_ed25519ph_update`, `crypto_sign_edwards25519sha512batch`, `crypto_sign_edwards25519sha512batch_keypair`, `crypto_sign_edwards25519sha512batch_open`, `crypto_sign_final_create`, `crypto_sign_final_verify`, `crypto_sign_init`, `crypto_sign_MESSAGEBYTES_MAX`, `crypto_sign_primitive`, `crypto_sign_STATEBYTES`, `crypto_sign_update`, `crypto_stream_chacha20_ietf_keygen`, `crypto_stream_chacha20_keygen`, `crypto_stream_keygen`, `crypto_stream_MESSAGEBYTES_MAX`, `crypto_stream_primitive`, `crypto_stream_salsa20`, `crypto_stream_salsa2012`, `crypto_stream_salsa2012_KEYBYTES`, `crypto_stream_salsa2012_keygen`, `crypto_stream_salsa2012_MESSAGEBYTES_MAX`, `crypto_stream_salsa2012_NONCEBYTES`, `crypto_stream_salsa2012_xor`, `crypto_stream_salsa208`, `crypto_stream_salsa208_KEYBYTES`, `crypto_stream_salsa208_keygen`, `crypto_stream_salsa208_MESSAGEBYTES_MAX`, `crypto_stream_salsa208_NONCEBYTES`, `crypto_stream_salsa208_xor`, `crypto_stream_salsa20_keygen`, `crypto_stream_xchacha20_keygen`, `crypto_stream_xsalsa20`, `crypto_stream_xsalsa20_KEYBYTES`, `crypto_stream_xsalsa20_keygen`, `crypto_stream_xsalsa20_MESSAGEBYTES_MAX`, `crypto_stream_xsalsa20_NONCEBYTES`, `crypto_stream_xsalsa20_xor`, `crypto_stream_xsalsa20_xor_ic`, `crypto_verify_16_BYTES`, `crypto_verify_32_BYTES`, `crypto_verify_64`, `crypto_verify_64_BYTES`, `randombytes`, `randombytes_close`, `randombytes_implementation_name`, `randombytes_internal_implementation`, `randombytes_set_implementation`, `randombytes_stir`, `randombytes_sysrandom_implementation`, `sodium_allocarray`, `sodium_base642bin`, `sodium_base64_encoded_len`, `sodium_bin2base64`, `sodium_bin2hex`, `sodium_hex2bin`, `sodium_init`, `sodium_library_minimal`, `sodium_library_version_major`, `sodium_library_version_minor`, `sodium_misuse`, `sodium_runtime_has_aesni`, `sodium_runtime_has_avx`, `sodium_runtime_has_avx2`, `sodium_runtime_has_avx512f`, `sodium_runtime_has_neon`, `sodium_runtime_has_pclmul`, `sodium_runtime_has_rdrand`, `sodium_runtime_has_sse2`, `sodium_runtime_has_sse3`, `sodium_runtime_has_sse41`, `sodium_runtime_has_ssse3`, `sodium_set_misuse_handler`, `sodium_stackzero`, `sodium_version_string`

## License

[MIT](LICENSE.md)
