var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import '../icon/icon';
import { classMap } from 'lit/directives/class-map.js';
import { customElement } from '../../internal/register-custom-element';
import { getTextContent } from '../../internal/slot';
import { html } from 'lit';
import { property, query } from 'lit/decorators.js';
import { watch } from '../../internal/watch';
import SolidElement from '../../internal/solid-element';
import styles from './menu-item.styles';
let SdMenuItem = class SdMenuItem extends SolidElement {
    constructor() {
        super(...arguments);
        this.type = 'normal';
        this.checked = false;
        this.value = '';
        this.disabled = false;
    }
    static { this.styles = [...SolidElement.styles, styles]; }
    handleDefaultSlotChange() {
        const textLabel = this.getTextLabel();
        if (typeof this.cachedTextLabel === 'undefined') {
            this.cachedTextLabel = textLabel;
            return;
        }
        if (textLabel !== this.cachedTextLabel) {
            this.cachedTextLabel = textLabel;
            this.emit('slotchange', { bubbles: true, composed: false, cancelable: false });
        }
    }
    handleCheckedChange() {
        if (this.checked && this.type !== 'checkbox') {
            this.checked = false;
            console.error('The checked attribute can only be used on menu items with type="checkbox"', this);
            return;
        }
        if (this.type === 'checkbox') {
            this.setAttribute('aria-checked', this.checked ? 'true' : 'false');
        }
        else {
            this.removeAttribute('aria-checked');
        }
    }
    handleDisabledChange() {
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
    }
    handleTypeChange() {
        if (this.type === 'checkbox') {
            this.setAttribute('role', 'menuitemcheckbox');
            this.setAttribute('aria-checked', this.checked ? 'true' : 'false');
        }
        else {
            this.setAttribute('role', 'menuitem');
            this.removeAttribute('aria-checked');
        }
    }
    getTextLabel() {
        return getTextContent(this.defaultSlot);
    }
    render() {
        return html `
      <div
        part="base"
        class=${classMap({
            'menu-item': true,
            'menu-item--checked': this.checked,
            'menu-item--disabled': this.disabled,
            'menu-item--has-submenu': false
        })}
      >
        <span part="checked-icon" class="menu-item__check">
          <sd-4-0-5-icon name="check" library="system" aria-hidden="true"></sd-4-0-5-icon>
        </span>

        <slot name="prefix" part="prefix" class="menu-item__prefix"></slot>

        <slot part="label" class="menu-item__label" @slotchange=${this.handleDefaultSlotChange}></slot>

        <slot name="suffix" part="suffix" class="menu-item__suffix"></slot>

        <span class="menu-item__chevron">
          <sd-4-0-5-icon name="chevron-right" library="system" aria-hidden="true"></sd-4-0-5-icon>
        </span>
      </div>
    `;
    }
};
__decorate([
    query('slot:not([name])')
], SdMenuItem.prototype, "defaultSlot", void 0);
__decorate([
    query('.menu-item')
], SdMenuItem.prototype, "menuItem", void 0);
__decorate([
    property()
], SdMenuItem.prototype, "type", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], SdMenuItem.prototype, "checked", void 0);
__decorate([
    property()
], SdMenuItem.prototype, "value", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], SdMenuItem.prototype, "disabled", void 0);
__decorate([
    watch('checked')
], SdMenuItem.prototype, "handleCheckedChange", null);
__decorate([
    watch('disabled')
], SdMenuItem.prototype, "handleDisabledChange", null);
__decorate([
    watch('type')
], SdMenuItem.prototype, "handleTypeChange", null);
SdMenuItem = __decorate([
    customElement('sd-menu-item')
], SdMenuItem);
export default SdMenuItem;
