import '../spinner/spinner';
import SolidElement from '../../internal/solid-element';
import type { SolidFormControl } from '../../internal/solid-element';
export default class SdButton extends SolidElement implements SolidFormControl {
    private readonly formControlController;
    private readonly hasSlotController;
    button: HTMLButtonElement | HTMLLinkElement;
    _iconsInDefaultSlot: HTMLElement[];
    protected invalid: boolean;
    title: string;
    variant: 'primary' | 'secondary' | 'tertiary' | 'cta';
    inverted: boolean;
    size: 'lg' | 'md' | 'sm';
    disabled: boolean;
    loading: boolean;
    type: 'button' | 'submit' | 'reset';
    name: string;
    value: string;
    href: string;
    target: '_blank' | '_parent' | '_self' | '_top';
    download?: string;
    form: string;
    formAction: string;
    formEnctype: 'application/x-www-form-urlencoded' | 'multipart/form-data' | 'text/plain';
    formMethod: 'post' | 'get';
    formNoValidate: boolean;
    formTarget: '_self' | '_blank' | '_parent' | '_top';
    get validity(): ValidityState;
    get validationMessage(): string;
    firstUpdated(): void;
    private handleBlur;
    private handleFocus;
    private handleClick;
    private handleInvalid;
    private isButton;
    private isLink;
    handleDisabledChange(): void;
    click(): void;
    focus(options?: FocusOptions): void;
    blur(): void;
    checkValidity(): boolean;
    getForm(): HTMLFormElement | null;
    reportValidity(): boolean;
    setCustomValidity(message: string): void;
    render(): import("lit-html").TemplateResult;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-button': SdButton;
    }
}
