import { LocalizeController } from '../../utilities/localize.js';
import SolidElement from '../../internal/solid-element.js';
export default class SdNotification extends SolidElement {
    private autoHideTimeout;
    localize: LocalizeController;
    base: HTMLElement;
    variant: 'info' | 'success' | 'error' | 'warning';
    open: boolean;
    closable: boolean;
    duration: number;
    durationIndicator: boolean;
    toastStack: 'top-right' | 'bottom-center';
    private remainingDuration;
    private startTime;
    firstUpdated(): void;
    private startAutoHide;
    private onHover;
    private onHoverEnd;
    private handleCloseClick;
    handleOpenChange(): Promise<void>;
    handleDurationChange(): void;
    show(): Promise<void>;
    hide(): Promise<void>;
    toast(): Promise<void>;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-notification': SdNotification;
    }
}
