import { LocalizeController } from '../../utilities/localize';
import SolidElement from '../../internal/solid-element';
export default class SdScrollable extends SolidElement {
    localize: LocalizeController;
    orientation: 'horizontal' | 'vertical' | 'auto';
    scrollbars: boolean;
    buttons: boolean;
    shadows: boolean;
    inset: boolean;
    step: number;
    private canScroll;
    private isScrollHorizontalEnabled;
    private isScrollVerticalEnabled;
    private isKeyboardNavigation;
    private resizeObserver;
    private scrollContainer;
    connectedCallback(): void;
    disconnectedCallback(): void;
    updated(changedProperties: Map<string, unknown>): void;
    private updateScrollEnabledFlags;
    private get container();
    updateScrollIndicatorVisibility(): void;
    handleScroll(direction: 'left' | 'right' | 'up' | 'down', event?: PointerEvent): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-scrollable': SdScrollable;
    }
}
