import SolidElement from '../../internal/solid-element';
import type { SolidFormControl } from '../../internal/solid-element';
export default class SdSwitch extends SolidElement implements SolidFormControl {
    private readonly formControlController;
    input: HTMLInputElement;
    invalidMessage: HTMLDivElement;
    showInvalidStyle: boolean;
    title: string;
    name: string;
    value: string;
    disabled: boolean;
    checked: boolean;
    defaultChecked: boolean;
    form: string;
    required: boolean;
    get validity(): ValidityState;
    firstUpdated(): void;
    private handleClick;
    private handleBlur;
    private handleInput;
    private handleInvalid;
    private handleFocus;
    handleDisabledChange(): void;
    handleStateChange(): void;
    click(): void;
    focus(options?: FocusOptions): void;
    blur(): void;
    checkValidity(): boolean;
    getForm(): HTMLFormElement | null;
    reportValidity(): boolean;
    setCustomValidity(message: string): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-switch': SdSwitch;
    }
}
