import SolidElement from '../../internal/solid-element';
import type { SolidFormControl } from '../../internal/solid-element';
export default class SdTextarea extends SolidElement implements SolidFormControl {
    private readonly formControlController;
    private readonly hasSlotController;
    textarea: HTMLTextAreaElement;
    invalidMessage: HTMLDivElement;
    hasFocus: boolean;
    showValidStyle: boolean;
    showInvalidStyle: boolean;
    title: string;
    name: string;
    value: string;
    size: 'lg' | 'md' | 'sm';
    label: string;
    helpText: string;
    placeholder: string;
    rows: number;
    disabled: boolean;
    readonly: boolean;
    form: string;
    required: boolean;
    minlength: number;
    maxlength: number;
    autocapitalize: 'off' | 'none' | 'on' | 'sentences' | 'words' | 'characters';
    autocorrect: 'off' | 'on';
    autocomplete: string;
    autofocus: boolean;
    enterkeyhint: 'enter' | 'done' | 'go' | 'next' | 'previous' | 'search' | 'send';
    styleOnValid: boolean;
    spellcheck: boolean;
    inputmode: 'none' | 'text';
    defaultValue: string;
    get validity(): ValidityState;
    get validationMessage(): string;
    connectedCallback(): void;
    firstUpdated(): void;
    disconnectedCallback(): void;
    private handleBlur;
    private handleChange;
    private handleFocus;
    private handleInput;
    private handleInvalid;
    private setTextareaHeight;
    handleDisabledChange(): void;
    handleRowsChange(): void;
    handleValueChange(): Promise<void>;
    focus(options?: FocusOptions): void;
    blur(): void;
    select(): void;
    scrollPosition(position?: {
        top?: number;
        left?: number;
    }): {
        top: number;
        left: number;
    } | undefined;
    setSelectionRange(selectionStart: number, selectionEnd: number, selectionDirection?: 'forward' | 'backward' | 'none'): void;
    setRangeText(replacement: string, start?: number, end?: number, selectMode?: 'select' | 'start' | 'end' | 'preserve'): void;
    checkValidity(): boolean;
    getForm(): HTMLFormElement | null;
    reportValidity(): boolean;
    setCustomValidity(message: string): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-textarea': SdTextarea;
    }
}
