import '../popup/popup';
import { LocalizeController } from '../../utilities/localize';
import SolidElement from '../../internal/solid-element';
import type SdPopup from '../popup/popup';
export default class SdTooltip extends SolidElement {
    private hoverTimeout;
    private isFocusTriggered;
    localize: LocalizeController;
    defaultSlot: HTMLSlotElement;
    body: HTMLElement;
    popup: SdPopup;
    size: 'lg' | 'sm';
    content: string;
    placement: 'top' | 'top-start' | 'top-end' | 'bottom' | 'bottom-start' | 'bottom-end';
    disabled: boolean;
    open: boolean;
    trigger: string;
    hoist: boolean;
    connectedCallback(): void;
    firstUpdated(): void;
    disconnectedCallback(): void;
    private handleBlur;
    private handleClick;
    private handleFocus;
    private handleKeyDown;
    private handleMouseOver;
    private handleMouseOut;
    private hasTrigger;
    handleOpenChange(): Promise<void>;
    handleOptionsChange(): Promise<void>;
    handleDisabledChange(): void;
    show(): Promise<void>;
    hide(): Promise<void>;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-4-0-5-tooltip': SdTooltip;
    }
}
