import '../translations/de';
import '../translations/en';
import { LocalizeController as DefaultLocalizationController } from '@shoelace-style/localize';
import type { Translation as DefaultTranslation } from '@shoelace-style/localize';
import type { ReactiveControllerHost } from 'lit';
export declare class LocalizeController extends DefaultLocalizationController<Translation> {
    private _instanceTranslations;
    constructor(host: ReactiveControllerHost & HTMLElement);
    get instanceTranslations(): Partial<Translation> | null;
    set instanceTranslations(value: Partial<Translation> | null);
    hostConnected(): void;
    hostDisconnected(): void;
    private setCustomLocalizationFromData;
    term<K extends keyof Translation>(key: K, ...args: unknown[]): string;
    setCustomLocalization(customLocalization: Partial<Translation>): void;
}
export interface Translation extends DefaultTranslation {
    $code: string;
    $name: string;
    $dir: 'ltr' | 'rtl';
    autoplay: string;
    audioPlayer: string;
    carousel: string;
    clearEntry: string;
    close: string;
    comboboxDefaultPlaceholder: string;
    copy: string;
    currentValue: string;
    goToSlide: (slide: number, count: number) => string;
    hidePassword: string;
    loading: string;
    mute: string;
    nextSlide: string;
    noResults: string;
    numOptionsSelected: (num: number) => string;
    pauseAudio: string;
    playAudio: string;
    playbackSpeed: string;
    previousSlide: string;
    progress: string;
    remove: string;
    removed: (name: string) => string;
    resize: string;
    scrollToEnd: string;
    scrollToStart: string;
    selectAColorFromTheScreen: string;
    selectDefaultPlaceholder: string;
    showLess: string;
    showMore: string;
    showPassword: string;
    slideNum: (slide: number, count: number) => string;
    tagsSelected: string;
    toggleColorFormat: string;
    unmute: string;
}
