import SolidElement from '../../internal/solid-element';
import type SdMenuItem from '../menu-item/menu-item';
export interface MenuSelectEventDetail {
    item: SdMenuItem;
}
export default class SdMenu extends SolidElement {
    static styles: import("lit").CSSResult[];
    defaultSlot: HTMLSlotElement;
    connectedCallback(): void;
    private getAllItems;
    private handleClick;
    private handleKeyDown;
    private handleMouseDown;
    private handleSlotChange;
    private isMenuItem;
    getCurrentItem(): SdMenuItem | undefined;
    setCurrentItem(item: SdMenuItem): void;
    render(): import("lit-html").TemplateResult<1>;
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-menu': SdMenu;
    }
}
