import '../icon/icon.js';
import { LocalizeController } from '../../utilities/localize.js';
import SolidElement from '../../internal/solid-element.js';
export default class SdCarousel extends SolidElement {
    autoplayControls: HTMLElement;
    previousButton: HTMLButtonElement;
    nextButton: HTMLButtonElement;
    paginationItems: HTMLButtonElement[];
    variant: 'dot' | 'number';
    inverted: boolean;
    loop: boolean;
    autoplay: boolean;
    slidesPerPage: number;
    slidesPerMove: number;
    defaultSlot: HTMLSlotElement;
    scrollContainer: HTMLElement;
    paginationContainer: HTMLElement;
    activeSlide: number;
    currentPage: number;
    pausedAutoplay: boolean;
    private autoplayController;
    private scrollController;
    private readonly slides;
    private intersectionObserver;
    private readonly intersectionObserverEntries;
    localize: LocalizeController;
    private mutationObserver;
    private userInteracted;
    connectedCallback(): void;
    disconnectedCallback(): void;
    protected firstUpdated(): void;
    getPageCount(totalSlides: number, slidesPerPage: number, slidesPerMove: number): number;
    getCurrentPage(totalSlides: number, activeSlide: number, slidesPerPage: number, slidesPerMove: number): number;
    private handleUserInteraction;
    private getSlides;
    private handleKeyDown;
    private handleScrollEnd;
    private handleSlotChange;
    private unblockAutoplay;
    pause(): void;
    resume(): void;
    handlePausedAutoplay(): void;
    initializeSlides(): void;
    handleSlideChange(): void;
    handleSlidesPerMoveChange(): void;
    handleAutoplayChange(): void;
    previous(behavior?: ScrollBehavior): void;
    next(behavior?: ScrollBehavior): void;
    nextTillFirst(behavior?: ScrollBehavior): void;
    goToSlide(index: number, behavior?: ScrollBehavior): void;
    render(): import("lit-html").TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-carousel': SdCarousel;
    }
}
