import { type TemplateResult } from 'lit';
import { type OptionRenderer } from './option-renderer.js';
import SdIcon from '../icon/icon';
import SdPopup from '../popup/popup';
import SdTag from '../tag/tag';
import SolidElement from '../../internal/solid-element';
import type { SolidFormControl } from '../../internal/solid-element';
import type SdOptgroup from '../optgroup/optgroup.js';
import type SdOption from '../option/option';
export default class SdCombobox extends SolidElement implements SolidFormControl {
    static dependencies: {
        'sd-icon': typeof SdIcon;
        'sd-popup': typeof SdPopup;
        'sd-tag': typeof SdTag;
    };
    private readonly formControlController;
    private readonly hasSlotController;
    private readonly localize;
    popup: SdPopup;
    combobox: HTMLSlotElement;
    displayInput: HTMLInputElement;
    valueInput: HTMLInputElement;
    listbox: HTMLSlotElement;
    tagWrapper: HTMLDivElement;
    filteredWrapper: HTMLSlotElement;
    private defaultSlot;
    invalidMessage: HTMLDivElement;
    hasHover: boolean;
    private hasFocus;
    displayInputValue: string;
    selectedTextLabel: string;
    selectedOptions: (SdOption | undefined)[];
    filteredOptions: (SdOption | SdOptgroup | undefined)[];
    allOptions: (SdOption | SdOptgroup | undefined)[];
    lastOption: SdOption | undefined;
    showValidStyle: boolean;
    showInvalidStyle: boolean;
    name: string;
    value: string | string[];
    defaultValue: string;
    size: 'lg' | 'md' | 'sm';
    placeholder: string;
    maxOptionsTagLabel: string;
    disabled: boolean;
    clearable: boolean;
    open: boolean;
    hoist: boolean;
    label: string;
    placement: 'top' | 'bottom';
    helpText: string;
    form: string;
    required: boolean;
    currentPlacement: "top" | "bottom";
    getOption: OptionRenderer;
    multiple: boolean;
    useTags: boolean;
    maxOptionsVisible: number;
    styleOnValid: boolean;
    filter: (option: SdOption, queryString: string) => boolean;
    getTag: (option: SdOption, index: number) => TemplateResult | string | HTMLElement;
    connectedCallback(): void;
    firstUpdated(): void;
    get validity(): ValidityState;
    get validationMessage(): string;
    protected get options(): (SdOption | SdOptgroup | TemplateResult<1>)[];
    protected get tags(): (TemplateResult<1> | TemplateResult<1>[])[];
    private addOpenListeners;
    private removeOpenListeners;
    private handleFocus;
    private handleBlur;
    private handleDocumentFocusIn;
    private handleDocumentKeyDown;
    private handleDocumentMouseDown;
    private handleTagKeyDown;
    private handleTagMaxOptionsKeyDown;
    private handleLabelClick;
    private handleTagRemove;
    private handleComboboxMouseDown;
    private handleComboboxKeyDown;
    private handleClearClick;
    private handleNoResultsClick;
    private clearCombobox;
    private preventLoosingFocus;
    private handleOptionClick;
    private selectNextOption;
    private getAllFilteredOptions;
    private getCurrentOption;
    private setCurrentOption;
    private toggleOptionSelection;
    private findOptionByValue;
    private selectedOptionsAndValueSynced;
    private isOptionSelected;
    private syncSelectedOptionsAndValue;
    private compareOptions;
    private setSelectedOptions;
    private setOrderedSelectedOptions;
    private selectionChanged;
    private createComboboxOptionsFromQuery;
    private handleInvalid;
    private handleMouseEnter;
    private handleMouseLeave;
    private handleCurrentPlacement;
    handleFilterChange(): void;
    handleUseTagsChange(): void;
    applySizeToOptions(): void;
    handleDisabledChange(): void;
    handleValueChange(): void;
    handleDisplayInputValueChange(): void;
    handleOpenChange(): Promise<void>;
    show(): Promise<void>;
    hide(): Promise<void>;
    checkValidity(): boolean;
    getForm(): HTMLFormElement | null;
    reportValidity(): boolean;
    setCustomValidity(message: string): void;
    focus(options?: FocusOptions): void;
    blur(): void;
    private handleInput;
    private handleChange;
    private getSlottedOptions;
    private getSlottedOptGroups;
    private handleDefaultSlotChange;
    render(): TemplateResult<1>;
    static styles: import("lit").CSSResult[];
}
declare global {
    interface HTMLElementTagNameMap {
        'sd-combobox': SdCombobox;
    }
}
