import { AsyncDirective, type DirectiveParameters, type Part } from 'lit/async-directive.js';
import { type ElementPart, noChange, nothing } from 'lit';
interface Callbacks {
    start: () => void;
    end: () => void;
}
declare class LongPressDirective extends AsyncDirective {
    host: HTMLButtonElement;
    observer: MutationObserver;
    callbacks: Callbacks;
    interval: NodeJS.Timeout;
    timeout: NodeJS.Timeout;
    constructor(part: Part);
    render(_callback: Callbacks): typeof nothing;
    update(part: ElementPart, [callbacks]: DirectiveParameters<this>): typeof noChange;
    protected disconnected(): void;
    private handlePointerDown;
    private spinOnLongPressCallback;
    private handlePointerUp;
    private stopSpinningAndCleanUp;
}
export declare const longPress: (_callback: Callbacks) => import("lit-html/directive").DirectiveResult<typeof LongPressDirective>;
export type { LongPressDirective };
