// src/translations/en.ts
import { registerTranslation } from "@shoelace-style/localize";
var translation = {
  $code: "en",
  $name: "English",
  $dir: "ltr",
  autoplay: "Autoplay",
  audioPlayer: "Audio Player",
  clearEntry: "Clear entry",
  close: "Close",
  comboboxDefaultPlaceholder: "Please search and select",
  copy: "Copy",
  carousel: "Carousel",
  currentValue: "Current value",
  goToSlide: (slide, count) => `Go to slide ${slide} of ${count}`,
  hidePassword: "Hide password",
  loading: "Loading",
  mute: "Mute",
  nextSlide: "Next slide",
  noResults: "No results found",
  numOptionsSelected: (num) => {
    if (num === 0) return "";
    return `Options Selected (${num})`;
  },
  pauseAudio: "Pause Audio",
  playAudio: "Play Audio",
  playbackSpeed: "Playback Speed",
  previousSlide: "Previous slide",
  progress: "Progress",
  remove: "Remove",
  removed: (name) => `${name} removed`,
  resize: "Resize",
  scrollToEnd: "Scroll to end",
  scrollToStart: "Scroll to start",
  selectAColorFromTheScreen: "Select a color from the screen",
  selectDefaultPlaceholder: "Please select",
  showLess: "Show less",
  showMore: "Show more",
  showPassword: "Show password",
  slideNum: (num) => `Slide ${num}`,
  tagsSelected: "Options selected",
  toggleColorFormat: "Toggle color format",
  unmute: "Unmute"
};
registerTranslation(translation);
var en_default = translation;

export {
  en_default
};
