import {
  SdTag
} from "./chunk.KH4M6HPE.js";
import {
  SdPopup
} from "./chunk.VTUCPGYW.js";
import {
  defaultValue
} from "./chunk.GI7VDIWX.js";
import {
  defaultOptionRenderer
} from "./chunk.WBJBQ4QI.js";
import {
  filterOnlyOptgroups,
  getAllOptions,
  getAssignedElementsForSlot,
  normalizeString
} from "./chunk.UIQBHPD3.js";
import {
  scrollIntoView
} from "./chunk.WDWV53JP.js";
import {
  FormControlController
} from "./chunk.KVKRZJS7.js";
import {
  getAnimation,
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  SdIcon
} from "./chunk.X2PI2F35.js";
import {
  animateTo,
  stopAnimations
} from "./chunk.EY4JPJJQ.js";
import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/combobox/combobox.ts
import { css, html } from "lit";
import { property, query, state } from "lit/decorators.js";
import { unsafeHTML } from "lit-html/directives/unsafe-html.js";
import cx from "classix";
var SdCombobox = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.formControlController = new FormControlController(this, {
      assumeInteractionOn: ["sd-blur", "sd-4-0-5-input"]
    });
    this.hasSlotController = new HasSlotController(this, "help-text", "label");
    this.localize = new LocalizeController(this);
    this.hasHover = false;
    this.hasFocus = false;
    this.displayInputValue = "";
    this.selectedTextLabel = "";
    this.selectedOptions = [];
    this.filteredOptions = [];
    this.allOptions = [];
    this.showValidStyle = false;
    this.showInvalidStyle = false;
    this.name = "";
    this.value = "";
    this.defaultValue = "";
    this.size = "lg";
    this.placeholder = "";
    this.maxOptionsTagLabel = "";
    this.disabled = false;
    this.clearable = false;
    this.open = false;
    this.hoist = false;
    this.label = "";
    this.placement = "bottom";
    this.helpText = "";
    this.form = "";
    this.required = false;
    this.currentPlacement = this.placement;
    this.getOption = defaultOptionRenderer;
    this.multiple = false;
    this.useTags = true;
    this.maxOptionsVisible = 3;
    this.styleOnValid = false;
    this.filter = (option, queryString) => {
      const normalizedOption = normalizeString(option.value);
      const normalizedOptionLabel = normalizeString(option.getTextLabel());
      const normalizedQuery = normalizeString(queryString);
      return normalizedOption.includes(normalizedQuery) || normalizedOptionLabel.includes(normalizedQuery);
    };
    this.getTag = (option) => {
      return html`<sd-4-0-5-tag ?disabled="${this.disabled}" part="tag" exportparts="
              base:tag__base,
              content:tag__content,
              removable-indicator:tag__removable-indicator,
            " size="${this.size === "sm" ? "sm" : "lg"}" removable @keydown="${(event) => this.handleTagKeyDown(event, option)}" @sd-remove="${(event) => this.handleTagRemove(event, option)}">${option.getTextLabel()}</sd-4-0-5-tag>`;
    };
    this.handleDocumentFocusIn = (event) => {
      const path = event.composedPath();
      if (this && !path.includes(this)) {
        this.hide();
      }
    };
    this.handleDocumentKeyDown = (event) => {
      const target = event.target;
      const isClearButton = target.closest(".combobox__clear") !== null;
      if (isClearButton) {
        return;
      }
      if (event.key === "Escape") {
        if (this.open) {
          event.preventDefault();
          event.stopPropagation();
          this.hide();
          this.displayInput.focus({ preventScroll: true });
        } else {
          this.displayInputValue = "";
        }
      }
      if (event.key === "Backspace" && this.multiple && this.displayInput.value === "") {
        this.handleTagRemove(new CustomEvent("sd-remove"), this.selectedOptions[this.selectedOptions.length - 1]);
        this.updateComplete.then(() => this.displayInput.focus({ preventScroll: true }));
        return;
      }
      if (event.key === "Enter") {
        const currentOption = this.getCurrentOption();
        const hasModifier = event.metaKey || event.ctrlKey || event.shiftKey || event.altKey;
        if (!this.open && !hasModifier) {
          setTimeout(() => {
            if (!event.defaultPrevented) {
              this.formControlController.submit();
            }
          });
          return;
        }
        if (!this.open || (currentOption == null ? void 0 : currentOption.disabled)) {
          return;
        }
        if (currentOption && !currentOption.disabled) {
          const oldValue = this.value;
          if (this.multiple) {
            this.toggleOptionSelection(currentOption);
            this.lastOption = currentOption;
            this.setOrderedSelectedOptions(currentOption);
            this.updateComplete.then(() => {
              this.selectionChanged();
            });
          } else {
            this.setOrderedSelectedOptions(currentOption);
            this.setSelectedOptions(currentOption);
          }
          this.updateComplete.then(() => {
            this.displayInput.focus({ preventScroll: true });
            if (this.value !== oldValue) {
              this.emit("sd-input");
              this.emit("sd-change");
            }
          });
        }
        this.displayInput.focus({ preventScroll: true });
        if (!this.multiple) {
          this.hide();
          this.displayInput.focus({ preventScroll: true });
        }
        return;
      }
      if (["ArrowUp", "ArrowDown"].includes(event.key)) {
        event.preventDefault();
        event.stopPropagation();
        if (!this.open) {
          this.show();
        }
        this.selectNextOption(event.key === "ArrowDown");
      }
      if (["Home", "End"].includes(event.key)) {
        event.preventDefault();
        event.stopPropagation();
        if (event.key === "Home") {
          this.displayInput.setSelectionRange(0, 0);
        } else if (event.key === "End") {
          this.displayInput.setSelectionRange(this.displayInput.value.length, this.displayInput.value.length);
        }
      }
    };
    this.handleDocumentMouseDown = (event) => {
      const path = event.composedPath();
      if (this && !path.includes(this)) {
        this.hide();
      }
    };
  }
  connectedCallback() {
    super.connectedCallback();
    this.open = false;
  }
  firstUpdated() {
    if (!this.multiple) {
      const option = this.findOptionByValue(this.getSlottedOptions(), this.value);
      this.selectedTextLabel = (option == null ? void 0 : option.getTextLabel()) || "";
    }
    this.formControlController.updateValidity();
  }
  /** Gets the validity state object */
  get validity() {
    return this.valueInput.validity;
  }
  /** Gets the validation message */
  get validationMessage() {
    return this.valueInput.validationMessage;
  }
  get options() {
    const renderOption = (option) => {
      const queryString = this.displayInput.value;
      const optionHtml = this.getOption(option, queryString);
      return html`${typeof optionHtml === "string" ? unsafeHTML(optionHtml) : optionHtml}`;
    };
    return this.filteredOptions.map((item) => {
      if (item.tagName.toLowerCase() === "sd-4-0-5-optgroup") {
        Array.from(item.children).forEach((option) => {
          if (option.tagName.toLowerCase() === "sd-4-0-5-option") {
            renderOption(option);
          }
        });
        return item;
      }
      return renderOption(item);
    });
  }
  get tags() {
    if (this.selectedOptions.length <= this.maxOptionsVisible) {
      return this.selectedOptions.map((option, index) => {
        if (index < this.maxOptionsVisible || this.maxOptionsVisible <= 0) {
          const tag = this.getTag(option, index);
          return html`<div @sd-remove="${(e) => this.handleTagRemove(e, option)}">${typeof tag === "string" ? unsafeHTML(tag) : tag}</div>`;
        }
        return [html``];
      });
    } else {
      return [
        html`<sd-4-0-5-tag ?disabled="${this.disabled}" part="tag" exportparts="
              base:tag__base,
              content:tag__content,
              removable-indicator:tag__removable-indicator,
            " size="${this.size === "sm" ? "sm" : "lg"}" removable @keydown="${(event) => this.handleTagMaxOptionsKeyDown(event)}" @sd-remove="${(event) => this.handleTagRemove(event)}">${this.selectedOptions.length} ${this.localize.term("tagsSelected")}</sd-4-0-5-tag>`
      ];
    }
  }
  addOpenListeners() {
    document.addEventListener("focusin", this.handleDocumentFocusIn);
    document.addEventListener("mousedown", this.handleDocumentMouseDown);
    if (this.getRootNode() !== document) {
      this.getRootNode().addEventListener("focusin", this.handleDocumentFocusIn);
    }
  }
  removeOpenListeners() {
    document.removeEventListener("focusin", this.handleDocumentFocusIn);
    document.removeEventListener("mousedown", this.handleDocumentMouseDown);
    if (this.getRootNode() !== document) {
      this.getRootNode().removeEventListener("focusin", this.handleDocumentFocusIn);
    }
  }
  handleFocus() {
    this.hasFocus = true;
    this.emit("sd-focus");
  }
  handleBlur() {
    this.hasFocus = false;
    this.emit("sd-blur");
  }
  handleTagKeyDown(event, option) {
    if (event.key === "Backspace" && this.multiple) {
      event.preventDefault();
      event.stopPropagation();
      this.handleTagRemove(new CustomEvent("sd-remove"), option);
      this.updateComplete.then(() => this.displayInput.focus({ preventScroll: true }));
    }
  }
  handleTagMaxOptionsKeyDown(event) {
    if (event.key === "Backspace" && this.multiple) {
      event.preventDefault();
      event.stopPropagation();
      this.handleTagRemove(new CustomEvent("sd-remove"), this.selectedOptions[this.selectedOptions.length - 1]);
      this.updateComplete.then(() => this.displayInput.focus({ preventScroll: true }));
    }
  }
  handleLabelClick() {
    this.displayInput.focus();
  }
  handleTagRemove(event, option) {
    event.stopPropagation();
    if (!option) {
      this.clearCombobox();
    }
    if (option && !this.disabled) {
      this.toggleOptionSelection(option, false);
      this.setOrderedSelectedOptions(option);
      this.updateComplete.then(() => {
        this.selectionChanged();
        this.emit("sd-input");
        this.emit("sd-change");
      });
    }
  }
  handleComboboxMouseDown(event) {
    const path = event.composedPath();
    const isRemovableIndicator = path.some((el) => el instanceof HTMLSlotElement && el.name === "removable-indicator");
    if (this.disabled || isRemovableIndicator) {
      return;
    }
    const toggleListboxOpen = () => this.open ? this.hide() : this.show();
    toggleListboxOpen().then(() => {
      setTimeout(() => this.displayInput.focus({ preventScroll: true }));
    });
  }
  handleComboboxKeyDown(event) {
    if (event.key === "Tab") {
      return;
    }
    this.handleDocumentKeyDown(event);
  }
  handleClearClick(event) {
    event.stopPropagation();
    this.clearCombobox();
  }
  handleNoResultsClick(event) {
    event.preventDefault();
    this.hide();
  }
  clearCombobox() {
    if (this.value !== "") {
      this.value = "";
      this.displayInputValue = "";
      this.selectedTextLabel = "";
      this.lastOption = void 0;
      this.selectedOptions = [];
      this.getSlottedOptions().forEach((option) => {
        option.selected = false;
      });
      this.displayInput.focus({ preventScroll: true });
      this.updateComplete.then(() => {
        this.emit("sd-clear");
        this.emit("sd-input");
        this.emit("sd-change");
      });
    }
  }
  preventLoosingFocus(event) {
    event.stopPropagation();
    event.preventDefault();
  }
  handleOptionClick(event) {
    const target = event.target;
    const option = target.closest("sd-4-0-5-option");
    const oldValue = this.value;
    if (option && !option.disabled) {
      if (this.multiple) {
        this.toggleOptionSelection(option);
        this.lastOption = option;
        this.setOrderedSelectedOptions(option);
        this.updateComplete.then(() => {
          this.selectionChanged();
        });
      } else {
        this.setOrderedSelectedOptions(option);
        this.setSelectedOptions(option);
      }
      this.updateComplete.then(() => {
        this.displayInput.focus({ preventScroll: true });
        if (this.value !== oldValue) {
          this.emit("sd-input");
          this.emit("sd-change");
        }
      });
      if (!this.multiple) {
        this.hide();
        this.displayInput.focus({ preventScroll: true });
      }
    }
  }
  /**
   * Selects the following or previous option.
   *
   * @param isNext - A boolean indicating whether to select the following option (true)
   *                 or the previous option (false).
   */
  selectNextOption(isNext) {
    const filteredOptions = this.getAllFilteredOptions();
    if (filteredOptions.length === 0) {
      return;
    }
    const currentOption = this.getCurrentOption();
    const currentIndex = filteredOptions.indexOf(currentOption);
    let newIndex = Math.max(0, currentIndex);
    if (isNext) {
      const nextIndex = currentIndex + 1;
      newIndex = nextIndex > filteredOptions.length - 1 ? 0 : nextIndex;
    } else {
      const previousIndex = currentIndex - 1;
      newIndex = previousIndex < 0 ? filteredOptions.length - 1 : previousIndex;
    }
    this.setCurrentOption(filteredOptions[newIndex]);
    scrollIntoView(this.getCurrentOption(), this.listbox, "vertical", "auto");
  }
  getAllFilteredOptions() {
    return [...this.filteredWrapper.querySelectorAll("sd-4-0-5-option")];
  }
  getCurrentOption() {
    return this.getAllFilteredOptions().find((option) => option.current);
  }
  // Sets the current option, which is the option the user is currently interacting with
  // (e.g. via keyboard). Only one option may be "current" at a time.
  setCurrentOption(option) {
    const allFilteredOptions = this.getAllFilteredOptions();
    this.displayInput.removeAttribute("aria-activedescendant");
    allFilteredOptions.forEach((el) => {
      el.current = false;
      el.setAttribute("aria-selected", "false");
    });
    if (option) {
      option.current = true;
      option.setAttribute("aria-selected", "true");
      this.displayInput.setAttribute("aria-activedescendant", option.id);
    }
  }
  // Toggles an option's selected state
  toggleOptionSelection(option, force) {
    const allOptions = this.getSlottedOptions();
    const optionEl = allOptions.find(
      (el) => el.value && option.value ? el.value === option.value : el.getTextLabel() === option.getTextLabel()
    );
    if (optionEl) optionEl.selected = force != null ? force : !optionEl.selected;
  }
  findOptionByValue(slottedOptions, value) {
    if (!value) return void 0;
    if (Array.isArray(value)) {
      return slottedOptions.find((option) => value.includes(option.value));
    }
    return slottedOptions.find((option) => option.value === value);
  }
  selectedOptionsAndValueSynced() {
    var _a;
    if (!this.value && this.selectedOptions.length === 0) return true;
    return Array.isArray(this.value) ? this.value.length === this.selectedOptions.length : this.value === ((_a = this.selectedOptions[0]) == null ? void 0 : _a.value);
  }
  isOptionSelected(option) {
    if (option.value) {
      return this.value.includes(option.value);
    } else {
      return this.value.includes(option.getTextLabel());
    }
  }
  syncSelectedOptionsAndValue() {
    if (this.selectedOptionsAndValueSynced()) {
      return;
    }
    const allOptions = this.getSlottedOptions();
    allOptions.forEach((option) => {
      option.selected = false;
    });
    this.selectedOptions = this.getSlottedOptions().filter((option) => {
      return this.isOptionSelected(option);
    });
    this.selectedOptions.forEach((option) => {
      if (option) option.selected = true;
    });
    return Promise.resolve();
  }
  compareOptions(a, b) {
    if (a.value && b.value) {
      return a.value === b.value;
    }
    return a.getTextLabel() === b.getTextLabel();
  }
  /**
   * Updates the selected options cache, the current value, and the display value
   */
  setSelectedOptions(option) {
    const allOptions = this.getSlottedOptions();
    allOptions.forEach((el) => {
      el.selected = this.compareOptions(el, option);
    });
    this.selectionChanged();
  }
  setOrderedSelectedOptions(option) {
    const selectedSlottedOption = this.getSlottedOptions().find((el) => this.compareOptions(el, option));
    if (this.multiple) {
      if (this.selectedOptions.length > 0 && selectedSlottedOption && this.selectedOptions.find((el) => this.compareOptions(el, selectedSlottedOption))) {
        this.selectedOptions = this.selectedOptions.filter((el) => !this.compareOptions(el, selectedSlottedOption));
      } else {
        this.selectedOptions = [...this.selectedOptions, selectedSlottedOption];
      }
    } else {
      this.selectedOptions = [selectedSlottedOption];
    }
  }
  selectionChanged() {
    var _a, _b, _c;
    const hasSelectedOptions = this.selectedOptions.some((option) => {
      if (!option) return false;
      return this.isOptionSelected(option);
    });
    if (this.multiple) {
      if (!hasSelectedOptions && this.selectedOptions.length > 0) {
        this.value = [...this.value, ...this.selectedOptions.map((el) => el.value || el.getTextLabel())];
      } else {
        this.value = this.selectedOptions.map((el) => {
          return (el == null ? void 0 : el.value) || (el == null ? void 0 : el.getTextLabel()) || "";
        });
      }
      this.displayInputValue = "";
    } else {
      this.value = ((_a = this.selectedOptions[0]) == null ? void 0 : _a.value) || ((_b = this.selectedOptions[0]) == null ? void 0 : _b.getTextLabel()) || "";
      this.selectedTextLabel = ((_c = this.selectedOptions[0]) == null ? void 0 : _c.getTextLabel()) || "";
      this.displayInputValue = "";
    }
    this.updateComplete.then(() => {
      this.formControlController.updateValidity();
    });
  }
  createComboboxOptionsFromQuery(queryString) {
    const optgroups = [];
    this.filteredOptions = this.getSlottedOptions().filter((option) => {
      return this.filter(option, queryString) || queryString === "";
    }).map((option) => {
      var _a, _b, _c;
      const clonedOption = option.cloneNode(true);
      clonedOption.current = clonedOption.value === ((_a = this.lastOption) == null ? void 0 : _a.value);
      clonedOption.selected = option.selected;
      clonedOption.checkbox = option.checkbox;
      clonedOption.size = option.size;
      const hasOptgroup = ((_b = option.parentElement) == null ? void 0 : _b.tagName.toLowerCase()) === "sd-4-0-5-optgroup";
      if (!hasOptgroup) {
        return clonedOption;
      }
      const optgroup = option.parentElement;
      const optGroupLabel = (_c = optgroup.querySelector('[slot="label"]')) == null ? void 0 : _c.cloneNode(true);
      const filteredOptgroup = optgroups.find((el) => el.id === optgroup.id);
      if (filteredOptgroup) {
        filteredOptgroup == null ? void 0 : filteredOptgroup.appendChild(clonedOption);
        if (optGroupLabel) filteredOptgroup == null ? void 0 : filteredOptgroup.appendChild(optGroupLabel);
        return void 0;
      }
      const clonedOptgroup = optgroup.cloneNode();
      clonedOptgroup.appendChild(clonedOption);
      if (optGroupLabel) clonedOptgroup.appendChild(optGroupLabel);
      optgroups.push(clonedOptgroup);
      return clonedOptgroup;
    }).filter(Boolean);
  }
  handleInvalid(event) {
    this.formControlController.setValidity(false);
    this.formControlController.emitInvalidEvent(event);
    this.invalidMessage.textContent = event.target.validationMessage;
  }
  handleMouseEnter() {
    this.hasHover = true;
  }
  handleMouseLeave() {
    this.hasHover = false;
  }
  /** Receives incoming event detail from sd-4-0-5-popup and updates local state for conditional styling. */
  handleCurrentPlacement(e) {
    const incomingPlacement = e.detail;
    if (incomingPlacement) {
      this.currentPlacement = incomingPlacement;
    }
  }
  handleFilterChange() {
    this.createComboboxOptionsFromQuery(this.displayInputValue);
  }
  handleUseTagsChange() {
    const allOptions = this.getAllFilteredOptions();
    if (customElements.get("sd-4-0-5-option")) {
      allOptions.forEach((option) => {
        option.checkbox = this.multiple;
      });
    }
  }
  applySizeToOptions() {
    this.getSlottedOptions().forEach((option) => {
      option.size = this.size;
    });
  }
  handleDisabledChange() {
    this.formControlController.setValidity(this.disabled);
    if (this.disabled) {
      this.open = false;
      this.handleOpenChange();
    }
  }
  handleValueChange() {
    this.syncSelectedOptionsAndValue();
    if (this.multiple) {
      this.createComboboxOptionsFromQuery(this.displayInput.value);
    } else {
      this.createComboboxOptionsFromQuery("");
    }
  }
  handleDisplayInputValueChange() {
    this.createComboboxOptionsFromQuery(this.displayInputValue);
  }
  async handleOpenChange() {
    if (this.open && !this.disabled) {
      this.emit("sd-show");
      this.addOpenListeners();
      await stopAnimations(this);
      this.listbox.hidden = false;
      this.popup.active = true;
      const { keyframes: keyframes2, options: options2 } = getAnimation(this, "combobox.show", { dir: this.localize.dir() });
      await animateTo(this.popup.popup, keyframes2, options2);
      this.emit("sd-after-show");
      if (this.filteredOptions.length === 0) {
        this.emit("sd-error");
      }
      return;
    }
    this.setCurrentOption(null);
    this.displayInput.removeAttribute("aria-activedescendant");
    this.emit("sd-hide");
    this.removeOpenListeners();
    await stopAnimations(this);
    const { keyframes, options } = getAnimation(this, "combobox.hide", { dir: this.localize.dir() });
    await animateTo(this.popup.popup, keyframes, options);
    this.listbox.hidden = true;
    this.popup.active = false;
    this.emit("sd-after-hide");
  }
  async show() {
    if (this.open || this.disabled) {
      this.open = false;
      return void 0;
    }
    this.open = true;
    return Promise.race([waitForEvent(this, "sd-after-show"), waitForEvent(this, "sd-error")]);
  }
  /** Hides the listbox. */
  async hide() {
    if (!this.open || this.disabled) {
      this.open = false;
      return void 0;
    }
    this.displayInputValue = "";
    this.open = false;
    return waitForEvent(this, "sd-after-hide");
  }
  /**
   * Checks for validity but does not show a validation message.
   * Returns `true` when valid and `false` when invalid.
   */
  checkValidity() {
    return this.valueInput.checkValidity();
  }
  /** Gets the associated form, if one exists. */
  getForm() {
    return this.formControlController.getForm();
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  reportValidity() {
    this.formControlController.fakeUserInteraction();
    return this.valueInput.reportValidity();
  }
  /** Sets a custom validation message. Pass an empty string to restore validity. */
  setCustomValidity(message) {
    this.valueInput.setCustomValidity(message);
    this.formControlController.updateValidity();
  }
  /** Sets focus on the control. */
  focus(options) {
    this.displayInput.focus(options);
  }
  /** Removes focus from the control. */
  blur() {
    this.displayInput.blur();
  }
  async handleInput() {
    const inputValue = this.displayInput.value;
    this.displayInputValue = inputValue;
    await this.updateComplete;
    this.open = this.filteredWrapper.children.length > 0;
    this.formControlController.updateValidity();
    this.emit("sd-input");
  }
  handleChange() {
    if (!this.selectedOptions || !this.multiple) {
      this.selectedTextLabel = this.displayInput.value;
      this.updateComplete.then(() => {
        this.formControlController.updateValidity();
      });
      this.emit("sd-change");
    }
  }
  getSlottedOptions() {
    return getAllOptions(getAssignedElementsForSlot(this.defaultSlot)).flat();
  }
  getSlottedOptGroups() {
    return filterOnlyOptgroups(getAssignedElementsForSlot(this.defaultSlot));
  }
  async handleDefaultSlotChange() {
    if (!customElements.get("sd-4-0-5-option")) {
      customElements.whenDefined("sd-4-0-5-option").then(() => this.handleDefaultSlotChange());
      return;
    }
    const slottedOptions = this.getSlottedOptions();
    const slottedOptgroups = this.getSlottedOptGroups();
    this.applySizeToOptions();
    const selectedOption = this.findOptionByValue(slottedOptions, this.value);
    this.selectedTextLabel = (selectedOption == null ? void 0 : selectedOption.getTextLabel()) || "";
    slottedOptions.forEach((option, index) => {
      if (this.multiple) {
        option.checkbox = true;
      }
      option.id = option.id || `sd-4-0-5-combobox-option-${index}`;
    });
    slottedOptgroups.forEach((optgroup, index) => {
      optgroup.id = optgroup.id || `sd-4-0-5-combobox-optgroup-${index}`;
    });
    await this.syncSelectedOptionsAndValue();
    if (this.multiple) {
      this.createComboboxOptionsFromQuery(this.displayInputValue);
    } else {
      this.createComboboxOptionsFromQuery("");
    }
  }
  render() {
    const slots = {
      left: this.hasSlotController.test("left"),
      right: this.hasSlotController.test("right")
    };
    const hasLabelSlot = this.hasSlotController.test("label");
    const hasHelpTextSlot = this.hasSlotController.test("help-text");
    const hasLabel = this.label ? true : !!hasLabelSlot;
    const hasHelpText = this.helpText ? true : !!hasHelpTextSlot;
    const hasClearIcon = this.clearable && !this.disabled;
    const selectState = this.disabled ? "disabled" : this.hasFocus && this.showInvalidStyle ? "activeInvalid" : this.hasFocus && this.styleOnValid && this.showValidStyle ? "activeValid" : this.hasFocus || this.open ? "active" : this.showInvalidStyle ? "invalid" : this.styleOnValid && this.showValidStyle ? "valid" : "default";
    const cursorStyles = this.disabled ? "cursor-not-allowed" : "cursor-pointer";
    const iconColor = this.disabled ? "text-neutral-500" : "text-primary";
    const iconMarginLeft = { sm: "ml-1", md: "ml-2", lg: "ml-2" }[this.size];
    const iconMarginRight = { sm: "mr-1", md: "mr-2", lg: "mr-2" }[this.size];
    const iconSize = {
      sm: "text-base",
      md: "text-lg",
      lg: "text-xl"
    }[this.size];
    return html`<div part="form-control" class="${cx(
      "relative text-left",
      cursorStyles,
      this.size === "sm" ? "text-sm" : "text-base",
      this.open && "z-50"
    )}"><label id="label" part="form-control-label" class="${hasLabel && "inline-block mb-2"}" aria-hidden="${!hasLabel}" @click="${this.handleLabelClick}"><slot name="label">${this.label}</slot></label><div part="form-control-input" class="relative w-full bg-white text-black"><div part="border" class="${cx(
      "absolute top-0 w-full h-full pointer-events-none border rounded-default",
      this.hasHover && "bg-neutral-200",
      {
        disabled: "border-neutral-500",
        readonly: "border-neutral-800",
        activeInvalid: "border-error border-2",
        activeValid: "border-success border-2",
        active: "border-primary border-2",
        invalid: "border-error",
        valid: "border-success",
        default: "border-neutral-800"
      }[selectState],
      this.open && (this.currentPlacement === "bottom" ? "rounded-bl-none rounded-br-none" : "rounded-tl-none rounded-tr-none")
    )}"></div><sd-4-0-5-popup @sd-current-placement="${this.handleCurrentPlacement}" class="${cx(
      "inline-flex relative w-full",
      this.currentPlacement === "bottom" ? "origin-top" : "origin-bottom"
    )}" placement="${this.placement}" strategy="${this.hoist ? "fixed" : "absolute"}" flip shift sync="width" auto-size="vertical" auto-size-padding="10" exportparts="
              popup:popup__content,
            "><div part="combobox" class="${cx(
      "relative w-full px-4 flex flex-row items-center rounded-default",
      this.open && "shadow",
      {
        sm: "py-1 min-h-[32px]",
        md: "py-1 min-h-[40px]",
        lg: "py-2 min-h-[48px]"
      }[this.size]
    )}" slot="anchor" @keydown="${this.handleComboboxKeyDown}" @mousedown="${this.handleComboboxMouseDown}" @mouseenter="${this.handleMouseEnter}" @mouseleave="${this.handleMouseLeave}">${slots["left"] ? html`<slot part="left" name="left" class="${cx("inline-flex", iconMarginRight, iconColor, iconSize)}"></slot>` : ""} ${this.multiple && this.useTags && this.tags.length > 0 ? html`<div part="tags" class="${cx("flex items-center gap-1", iconMarginRight)}">${this.tags}</div>` : null} <input id="display-input" name="${this.name}" form="${this.form}" part="display-input" class="${cx(
      "appearance-none outline-none bg-transparent flex-auto min-w-0",
      cursorStyles,
      this.selectedTextLabel && !this.multiple ? "placeholder-black" : "placeholder-neutral-700"
    )}" type="text" placeholder="${this.selectedTextLabel && !this.multiple ? this.selectedTextLabel : this.placeholder || this.localize.term("comboboxDefaultPlaceholder")}" .disabled="${this.disabled}" .value="${this.displayInputValue}" autocomplete="off" spellcheck="false" autocapitalize="off" aria-controls="listbox" aria-expanded="${this.open}" aria-haspopup="listbox" aria-labelledby="label" aria-disabled="${this.disabled}" aria-describedby="help-text invalid-message" aria-invalid="${this.showInvalidStyle}" role="combobox" tabindex="0" @focus="${this.handleFocus}" @blur="${this.handleBlur}" aria-autocomplete="list" aria-owns="listbox" @input="${this.handleInput}" @change="${this.handleChange}"><div aria-live="polite" id="control-value" class="absolute top-0 left-0 opacity-0 -z-10">${this.selectedOptions.map((option) => option == null ? void 0 : option.getTextLabel()).join(", ")}</div><input class="${cx("value-input absolute top-0 left-0 w-full h-full opacity-0 -z-10", cursorStyles)}" type="text" ?disabled="${this.disabled}" ?required="${this.required}" .value="${Array.isArray(this.value) ? this.value.join(", ") : this.value}" tabindex="-1" aria-controls="control-value" aria-hidden="true" @focus="${() => this.focus()}" @invalid="${this.handleInvalid}"> ${hasClearIcon ? html`<button part="clear-button" class="${cx(
      "flex justify-center",
      iconMarginLeft,
      this.value.length > 0 ? "visible" : "invisible"
    )}" type="button" aria-label="${this.localize.term("clearEntry")}" @mousedown="${this.preventLoosingFocus}" @click="${this.handleClearClick}" tabindex="-1"><slot name="clear-icon"><sd-4-0-5-icon class="${cx("text-icon-fill-neutral-800", iconSize)}" name="closing-round" library="system"></sd-4-0-5-icon></slot></button>` : ""} ${this.showInvalidStyle ? html`<sd-4-0-5-icon part="invalid-icon" class="${cx(iconMarginLeft, iconSize, "text-error")}" library="system" name="risk"></sd-4-0-5-icon>` : ""} ${this.styleOnValid && this.showValidStyle ? html`<sd-4-0-5-icon part="valid-icon" class="${cx("flex-shrink-0 text-success", iconMarginLeft, iconSize)}" library="system" name="status-check"></sd-4-0-5-icon>` : ""}<slot name="right" part="right" class="${cx(
      "inline-flex ml-2 leading-[0]",
      this.disabled ? "text-neutral-500" : "text-primary",
      iconSize
    )}"><sd-4-0-5-icon class="${cx("transition-all", this.open ? "rotate-180" : "rotate-0")}" name="chevron-down" part="chevron" library="system" color="currentColor"></sd-4-0-5-icon></slot></div><div id="listbox" role="listbox" aria-expanded="${this.open}" aria-multiselectable="${this.multiple}" aria-labelledby="label" part="listbox" class="${cx(
      "bg-white px-2 py-3 relative border-primary overflow-y-auto",
      this.open && "shadow",
      this.currentPlacement === "bottom" ? "border-r-2 border-b-2 border-l-2 rounded-br-default rounded-bl-default" : "border-r-2 border-t-2 border-l-2 rounded-tr-default rounded-tl-default"
    )}" tabindex="-1" @mousedown="${this.preventLoosingFocus}" @mouseup="${this.handleOptionClick}"><div part="filtered-listbox" class="overflow-y-scroll">${this.filteredOptions.length === 0 ? html`<span id="noResults" class="px-4 flex items-center w-full transition-all text-left text-base relative text-black py-3" aria-hidden="true" @click="${this.handleNoResultsClick}">${this.localize.term("noResults")}</span>` : this.options}</div><slot id="defaultOptionsSlot" class="hidden" @slotchange="${this.handleDefaultSlotChange}"></slot></div></sd-4-0-5-popup></div><div part="form-control-help-text" id="help-text" class="text-sm text-neutral-700" aria-hidden="${!hasHelpText}"><slot name="help-text">${this.helpText}</slot></div></div>${this.formControlController.renderInvalidMessage()}`;
  }
};
SdCombobox.dependencies = {
  "sd-4-0-5-icon": SdIcon,
  "sd-4-0-5-popup": SdPopup,
  "sd-4-0-5-tag": SdTag
};
SdCombobox.styles = [
  ...SolidElement.styles,
  css`:host{display:block;position:relative;width:100%}:host([required]) #label:after{content:" *"}[part=listbox]{max-height:var(--auto-size-available-height,auto)}sd-4-0-5-popup::part(popup){z-index:var(--sd-z-index-dropdown,900)}sd-4-0-5-tag::part(base){border-radius:var(--sd-border-radius-default,.25rem);padding-left:var(--sd-spacing-1,.25rem);padding-right:var(--sd-spacing-1,.25rem)}sd-4-0-5-tag::part(content){display:inline-block;max-width:var(--tag-max-width,15ch);overflow:hidden;text-overflow:ellipsis;white-space:nowrap}sd-4-0-5-tag[size=lg]::part(base){padding-left:var(--sd-spacing-2,.5rem);padding-right:var(--sd-spacing-2,.5rem)}sd-4-0-5-tag[disabled=false]::part(base):hover{--tw-bg-opacity:1;background-color:rgb(var(--sd-color-primary-100,236 240 249)/var(--tw-bg-opacity,1))}[part=filtered-listbox] sd-4-0-5-optgroup:first-of-type{--display-divider:none}mark{background-color:transparent;color:inherit;font-weight:700}`
];
__decorateClass([
  query("sd-4-0-5-popup")
], SdCombobox.prototype, "popup", 2);
__decorateClass([
  query('[part="combobox"]')
], SdCombobox.prototype, "combobox", 2);
__decorateClass([
  query('[part="display-input"]')
], SdCombobox.prototype, "displayInput", 2);
__decorateClass([
  query(".value-input")
], SdCombobox.prototype, "valueInput", 2);
__decorateClass([
  query('[part="listbox"]')
], SdCombobox.prototype, "listbox", 2);
__decorateClass([
  query('[part="tags"]')
], SdCombobox.prototype, "tagWrapper", 2);
__decorateClass([
  query('[part="filtered-listbox"]')
], SdCombobox.prototype, "filteredWrapper", 2);
__decorateClass([
  query("slot:not([name])")
], SdCombobox.prototype, "defaultSlot", 2);
__decorateClass([
  query("#invalid-message")
], SdCombobox.prototype, "invalidMessage", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "hasHover", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "hasFocus", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "displayInputValue", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "selectedTextLabel", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "selectedOptions", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "filteredOptions", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "allOptions", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "lastOption", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "showValidStyle", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "showInvalidStyle", 2);
__decorateClass([
  property()
], SdCombobox.prototype, "name", 2);
__decorateClass([
  property({
    converter: {
      fromAttribute: (value) => value.split(" "),
      toAttribute: (value) => value.join(" ")
    }
  })
], SdCombobox.prototype, "value", 2);
__decorateClass([
  defaultValue()
], SdCombobox.prototype, "defaultValue", 2);
__decorateClass([
  property({ reflect: true })
], SdCombobox.prototype, "size", 2);
__decorateClass([
  property()
], SdCombobox.prototype, "placeholder", 2);
__decorateClass([
  property({ attribute: "max-options-tag-label" })
], SdCombobox.prototype, "maxOptionsTagLabel", 2);
__decorateClass([
  property({ reflect: true, type: Boolean })
], SdCombobox.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean })
], SdCombobox.prototype, "clearable", 2);
__decorateClass([
  property({ reflect: true, type: Boolean })
], SdCombobox.prototype, "open", 2);
__decorateClass([
  property({ type: Boolean })
], SdCombobox.prototype, "hoist", 2);
__decorateClass([
  property()
], SdCombobox.prototype, "label", 2);
__decorateClass([
  property({ reflect: true })
], SdCombobox.prototype, "placement", 2);
__decorateClass([
  property({ attribute: "help-text" })
], SdCombobox.prototype, "helpText", 2);
__decorateClass([
  property({ reflect: true })
], SdCombobox.prototype, "form", 2);
__decorateClass([
  property({ reflect: true, type: Boolean })
], SdCombobox.prototype, "required", 2);
__decorateClass([
  state()
], SdCombobox.prototype, "currentPlacement", 2);
__decorateClass([
  property()
], SdCombobox.prototype, "getOption", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdCombobox.prototype, "multiple", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdCombobox.prototype, "useTags", 2);
__decorateClass([
  property({ attribute: "max-options-visible", type: Number })
], SdCombobox.prototype, "maxOptionsVisible", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "style-on-valid" })
], SdCombobox.prototype, "styleOnValid", 2);
__decorateClass([
  property()
], SdCombobox.prototype, "filter", 2);
__decorateClass([
  property()
], SdCombobox.prototype, "getTag", 2);
__decorateClass([
  watch("filter", { waitUntilFirstUpdate: true })
], SdCombobox.prototype, "handleFilterChange", 1);
__decorateClass([
  watch("useTags", { waitUntilFirstUpdate: true })
], SdCombobox.prototype, "handleUseTagsChange", 1);
__decorateClass([
  watch("size", { waitUntilFirstUpdate: true })
], SdCombobox.prototype, "applySizeToOptions", 1);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdCombobox.prototype, "handleDisabledChange", 1);
__decorateClass([
  watch("value", { waitUntilFirstUpdate: true })
], SdCombobox.prototype, "handleValueChange", 1);
__decorateClass([
  watch("displayInputValue", { waitUntilFirstUpdate: true })
], SdCombobox.prototype, "handleDisplayInputValueChange", 1);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdCombobox.prototype, "handleOpenChange", 1);
SdCombobox = __decorateClass([
  customElement("sd-4-0-5-combobox")
], SdCombobox);
setDefaultAnimation("combobox.show", {
  keyframes: [
    { opacity: 0, scale: 0.9 },
    { opacity: 1, scale: 1 }
  ],
  options: { duration: 100, easing: "ease" }
});
setDefaultAnimation("combobox.hide", {
  keyframes: [
    { opacity: 1, scale: 1 },
    { opacity: 0, scale: 0.9 }
  ],
  options: { duration: 100, easing: "ease" }
});

export {
  SdCombobox
};
