// src/components/icon/library.default.ts
var defaultLibrary = {
  name: "default",
  resolver: (name) => {
    const path = name.split("/");
    if (path[0] === "content" || path[0] === "system") {
      name = "union-investment/" + name;
    }
    return `https://celum-icons.fe.union-investment.de/${name}.svg`;
  },
  mutator: (svg) => {
    const recoloredElements = {
      currentColorFills: [],
      currentColorStrokes: [],
      greenFills: [],
      greenStrokes: []
    };
    recoloredElements["currentColorFills"] = svg.querySelectorAll('[fill="#00358e" i]');
    recoloredElements["currentColorStrokes"] = svg.querySelectorAll('[stroke="#00358e" i]');
    recoloredElements["greenFills"] = svg.querySelectorAll('[fill="#2d9d00" i]');
    recoloredElements["greenStrokes"] = svg.querySelectorAll('[stroke="#2d9d00" i]');
    recoloredElements.currentColorFills.forEach((filledElement) => {
      filledElement.setAttribute("fill", "currentColor");
    });
    recoloredElements.currentColorStrokes.forEach((strokedElement) => {
      strokedElement.setAttribute("stroke", "currentColor");
    });
    recoloredElements.greenFills.forEach((filledElement) => {
      filledElement.setAttribute("fill", "rgb(var(--sd-color-accent, 45 157 0) / var(--tw-bg-opacity, 1))");
    });
    recoloredElements.greenStrokes.forEach((strokedElement) => {
      strokedElement.setAttribute("stroke", "rgb(var(--sd-color-accent, 45 157 0) / var(--tw-bg-opacity, 1))");
    });
    return svg;
  }
};
var library_default_default = defaultLibrary;

export {
  library_default_default
};
