import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/divider/divider.ts
import { css, html } from "lit";
import { property } from "lit/decorators.js";
import cx from "classix";
var SdDivider = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.orientation = "horizontal";
    this.inverted = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.setAttribute("role", "separator");
  }
  render() {
    return html`<hr part="main" aria-orientation="${this.orientation}" class="${cx(
      this.inverted ? "border-primary-400" : "border-neutral-400",
      this.orientation === "horizontal" ? "border-t w-full" : " border-l h-full"
    )}">`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdDivider.styles = [
  ...SolidElement.styles,
  css`:host{margin:var(--sd-spacing-0,0)}:host(sd-4-0-5-divider[orientation=horizontal]){display:block}:host(sd-4-0-5-divider[orientation=vertical]){display:inline-block}`
];
__decorateClass([
  property({ reflect: true })
], SdDivider.prototype, "orientation", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdDivider.prototype, "inverted", 2);
SdDivider = __decorateClass([
  customElement("sd-4-0-5-divider")
], SdDivider);

export {
  SdDivider
};
