import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/step/step.ts
import { css } from "lit";
import { html, literal } from "lit/static-html.js";
import { ifDefined } from "lit/directives/if-defined.js";
import { property } from "lit/decorators.js";
import cx from "classix";
var SdStep = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.size = "lg";
    this.orientation = "horizontal";
    this.disabled = false;
    this.current = false;
    this.noTail = false;
    this.notInteractive = false;
    this.label = "";
    this.description = "";
    this.index = 1;
    this.href = "";
  }
  connectedCallback() {
    super.connectedCallback();
  }
  isLink() {
    return this.href ? true : false;
  }
  handleBlur() {
    this.emit("sd-blur");
  }
  handleFocus() {
    this.emit("sd-focus");
  }
  handleCurrentChange() {
    if (this.current) {
      this.disabled = false;
    }
  }
  handleDisabledChange() {
    if (this.disabled) {
      this.current = false;
    }
  }
  handleInteractivityChange() {
    if (this.notInteractive) {
      this.current = false;
      this.disabled = false;
    }
  }
  render() {
    const isLink = this.isLink();
    const tag = this.notInteractive ? literal`div` : isLink ? literal`a` : literal`button`;
    return html`<div role="listitem" part="base" class="${cx(
      "flex pt-1",
      this.orientation === "horizontal" ? "flex-col w-full" : "flex-row gap-4 items-stretch h-full w-min overflow-hidden",
      !this.disabled && !this.current && !this.notInteractive && "group"
    )}" @focus="${this.handleFocus}" @blur="${this.handleBlur}"><div part="circle-and-tail-container" class="${cx(
      "flex shrink-0 gap-2",
      this.noTail && "w-max",
      this.orientation === "horizontal" ? "flex-row" : "flex-col items-stretch",
      this.orientation === "horizontal" ? this.size === "lg" ? "translateLg" : "translateSm" : this.size === "lg" ? "mt-1" : "mt-3"
    )}"><${tag} part="circle" href="${ifDefined(isLink ? this.href : void 0)}" aria-disabled="${ifDefined(this.disabled || void 0)}" aria-current="${this.current ? "step" : void 0}" aria-labelledby="${ifDefined("label")}" aria-describedby="${ifDefined("description")}" class="${cx(
      "border rounded-full aspect-square circle flex items-center justify-center shrink-0 font-bold select-none",
      this.disabled ? "focus-visible:outline-none cursor-not-allowed" : "focus-visible:focus-outline group-hover:cursor-pointer",
      this.notInteractive ? this.size === "lg" ? "w-[72px]" : "w-12" : this.size === "lg" ? "w-12" : "w-8",
      this.disabled && "border-neutral-400 text-neutral-700",
      !this.disabled && !this.current && !this.notInteractive && "border-primary group-hover:bg-primary-100 group-hover:border-primary-500",
      this.notInteractive && "border-neutral-400",
      this.current && "bg-accent border-none text-white"
    )}"><slot name="circle-content" class="${cx(
      !this.disabled && !this.current && !this.notInteractive && "text-primary group-hover:text-primary-500 group-hover:fill-primary-500",
      this.notInteractive && "text-primary",
      this.size === "lg" ? "text-lg" : "text-sm"
    )}">${!this.disabled && !this.current && !this.notInteractive ? html`<sd-4-0-5-icon name="status-check" library="system"></sd-4-0-5-icon>` : html`${this.index}`}</slot></${tag}>${this.noTail ? "" : html`<div part="tail" class="${cx(
      this.orientation === "horizontal" ? "border-t w-full my-auto mr-2" : "border-l flex-grow flex-shrink-0 basis-auto h-full w-[1px] mx-auto",
      !this.disabled && !this.current && !this.notInteractive ? " border-primary group-hover:border-primary-500" : "border-neutral-400"
    )}"></div>`}</div><div part="text-container" class="${cx("mt-4 break-words flex flex-col gap-2", this.orientation === "horizontal" ? "text-center w-40" : "w-max text-left", this.disabled && "!text-neutral-700", this.notInteractive ? "ml-3" : "mr-4")}"><div part="label" id="label" class="${cx("!font-bold sd-paragraph", this.disabled && "!text-neutral-700", !this.disabled && !this.current && !this.notInteractive ? "!text-primary group-hover:!text-primary-500 group-hover:cursor-pointer" : "text-black")}"><slot name="label">${this.label}</slot></div><div part="description" id="description" class="${cx("sd-paragraph sd-paragraph--size-sm", this.disabled && "!text-neutral-700")}">${this.description || html`<slot></slot>`}</div></div></div>`;
  }
};
SdStep.styles = [
  ...SolidElement.styles,
  css`:host{flex:1 1 0%}:host([no-tail]){flex-grow:0}.translateLg{transform:translateX(55px)}.translateSm{transform:translateX(64px)}`
];
__decorateClass([
  property({ reflect: true })
], SdStep.prototype, "size", 2);
__decorateClass([
  property({ reflect: true })
], SdStep.prototype, "orientation", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdStep.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdStep.prototype, "current", 2);
__decorateClass([
  property({ reflect: true, type: Boolean, attribute: "no-tail" })
], SdStep.prototype, "noTail", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "not-interactive" })
], SdStep.prototype, "notInteractive", 2);
__decorateClass([
  property()
], SdStep.prototype, "label", 2);
__decorateClass([
  property()
], SdStep.prototype, "description", 2);
__decorateClass([
  property({ type: Number, reflect: true, attribute: "index" })
], SdStep.prototype, "index", 2);
__decorateClass([
  property()
], SdStep.prototype, "href", 2);
__decorateClass([
  watch("current")
], SdStep.prototype, "handleCurrentChange", 1);
__decorateClass([
  watch("disabled")
], SdStep.prototype, "handleDisabledChange", 1);
__decorateClass([
  watch("notInteractive")
], SdStep.prototype, "handleInteractivityChange", 1);
SdStep = __decorateClass([
  customElement("sd-4-0-5-step")
], SdStep);

export {
  SdStep
};
