import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/option/option.ts
import { css, html } from "lit";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdOption = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.hasSlotController = new HasSlotController(this, "default", "left", "right");
    this.current = false;
    this.selected = false;
    this.hasHover = false;
    this.size = "lg";
    this.checkbox = false;
    this.disabled = false;
    this.value = "";
  }
  connectedCallback() {
    super.connectedCallback();
    this.setAttribute("role", "option");
    this.setAttribute("aria-selected", "false");
  }
  handleDefaultSlotChange() {
    const textLabel = this.getTextLabel();
    if (typeof this.cachedTextLabel === "undefined") {
      this.cachedTextLabel = textLabel;
      return;
    }
    if (textLabel !== this.cachedTextLabel) {
      this.cachedTextLabel = textLabel;
      this.emit("slotchange", { bubbles: true, composed: false, cancelable: false });
    }
  }
  handleMouseEnter() {
    this.hasHover = true;
  }
  handleMouseLeave() {
    this.hasHover = false;
  }
  handleDisabledChange() {
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
  }
  handleSelectedChange() {
    this.setAttribute("aria-selected", this.selected ? "true" : "false");
  }
  handleValueChange() {
    if (this.value.includes(" ")) {
      console.error(`Option values cannot include a space. All spaces have been replaced with underscores.`, this);
      this.value = this.value.replace(/ /g, "_");
    }
  }
  /** Returns a plain text label based on the option's content. */
  getTextLabel() {
    var _a;
    return ((_a = this.textContent) != null ? _a : "").trim();
  }
  render() {
    const slots = {
      default: this.hasSlotController.test("default"),
      left: this.hasSlotController.test("left"),
      right: this.hasSlotController.test("right")
    };
    return html`<div part="base" class="${cx(
      "px-4 flex items-center w-full transition-all text-left text-base relative text-black",
      {
        sm: "text-sm py-1",
        md: "text-base py-2",
        lg: "text-base py-3"
      }[this.size],
      this.disabled ? "text-neutral-500 cursor-not-allowed" : "cursor-pointer",
      this.hasHover && !this.disabled ? "bg-neutral-200" : "",
      this.current && "bg-neutral-200"
    )}" @mouseenter="${this.handleMouseEnter}" @mouseleave="${this.handleMouseLeave}"><span class="${cx(
      "absolute w-full left-0 top-0 pointer-events-none transition-all duration-150 border-l-4 h-[calc(100%-8px)]",
      this.selected && !this.checkbox ? "border-accent" : "border-transparent",
      this.disabled && "border-neutral-500 top-1",
      !this.disabled && this.hasHover ? "h-full top-0" : "top-1"
    )}"></span> ${this.checkbox ? html`<span id="control" part="control ${this.selected ? " control--checked" : "control--unchecked"}" class="${cx(
      "relative flex flex-shrink-0 items-center justify-center border rounded-sm h-4 w-4 mr-2",
      this.disabled ? "border-neutral-500" : this.selected ? "bg-accent border-accent" : "border-neutral-800"
    )}">${this.selected ? html`<sd-4-0-5-icon part="checked-icon" class="text-white w-3 h-3" library="system" name="status-check"></sd-4-0-5-icon>` : ""}</span>` : ""} ${slots["left"] ? html`<slot name="left" part="left" class="inline-flex mr-2"></slot>` : ""}<slot part="label" class="inline-block flex-grow" @slotchange="${this.handleDefaultSlotChange}"></slot>${slots["right"] ? html`<slot name="right" part="right" class="inline-flex ml-2"></slot>` : ""}</div>`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdOption.styles = [
  ...SolidElement.styles,
  css`:host{display:block;outline:2px solid transparent!important;outline-offset:2px!important;position:relative;width:100%}`
];
__decorateClass([
  query('[part="base"]')
], SdOption.prototype, "defaultSlot", 2);
__decorateClass([
  state()
], SdOption.prototype, "current", 2);
__decorateClass([
  state()
], SdOption.prototype, "selected", 2);
__decorateClass([
  state()
], SdOption.prototype, "hasHover", 2);
__decorateClass([
  property({ reflect: true })
], SdOption.prototype, "size", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdOption.prototype, "checkbox", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdOption.prototype, "disabled", 2);
__decorateClass([
  property({ reflect: true })
], SdOption.prototype, "value", 2);
__decorateClass([
  watch("disabled")
], SdOption.prototype, "handleDisabledChange", 1);
__decorateClass([
  watch("selected")
], SdOption.prototype, "handleSelectedChange", 1);
__decorateClass([
  watch("value")
], SdOption.prototype, "handleValueChange", 1);
SdOption = __decorateClass([
  customElement("sd-4-0-5-option")
], SdOption);

export {
  SdOption
};
