import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/button-group/button-group.ts
import { css, html } from "lit";
import { property, query, state } from "lit/decorators.js";
var SdButtonGroup = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.disableRole = false;
    this.label = "";
  }
  handleFocus(event) {
    const button = findButton(event.target);
    button == null ? void 0 : button.classList.add("sd-4-0-5-button-group__button--focus");
  }
  handleBlur(event) {
    const button = findButton(event.target);
    button == null ? void 0 : button.classList.remove("sd-4-0-5-button-group__button--focus");
  }
  handleMouseOver(event) {
    const button = findButton(event.target);
    button == null ? void 0 : button.classList.add("sd-4-0-5-button-group__button--hover");
  }
  handleMouseOut(event) {
    const button = findButton(event.target);
    button == null ? void 0 : button.classList.remove("sd-4-0-5-button-group__button--hover");
  }
  handleSlotChange() {
    const slottedElements = [...this.defaultSlot.assignedElements({ flatten: true })];
    slottedElements.forEach((el) => {
      const index = slottedElements.indexOf(el);
      const button = findButton(el);
      if (button !== null) {
        button.classList.add("sd-4-0-5-button-group__button");
        button.classList.toggle("sd-4-0-5-button-group__button--first", index === 0);
        button.classList.toggle("sd-4-0-5-button-group__button--inner", index > 0 && index < slottedElements.length - 1);
        button.classList.toggle("sd-4-0-5-button-group__button--last", index === slottedElements.length - 1);
        button.classList.toggle("sd-4-0-5-button-group__button--radio", button.tagName.toLowerCase() === "sd-4-0-5-radio-button");
      }
    });
  }
  render() {
    return html`<slot part="base" role="${this.disableRole ? "presentation" : "group"}" aria-label="${this.label}" @focusout="${this.handleBlur}" @focusin="${this.handleFocus}" @mouseover="${this.handleMouseOver}" @mouseout="${this.handleMouseOut}" @slotchange="${this.handleSlotChange}"></slot>`;
  }
};
SdButtonGroup.styles = [
  ...SolidElement.styles,
  css`:host{display:inline-block}[part=base]{display:flex;flex-wrap:nowrap}`
];
__decorateClass([
  query("slot")
], SdButtonGroup.prototype, "defaultSlot", 2);
__decorateClass([
  state()
], SdButtonGroup.prototype, "disableRole", 2);
__decorateClass([
  property()
], SdButtonGroup.prototype, "label", 2);
SdButtonGroup = __decorateClass([
  customElement("sd-4-0-5-button-group")
], SdButtonGroup);
function findButton(el) {
  var _a;
  const selector = "sd-4-0-5-button, sd-4-0-5-radio-button";
  return (_a = el.closest(selector)) != null ? _a : el.querySelector(selector);
}

export {
  SdButtonGroup
};
