import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/map-marker/map-marker.ts
import { css, svg } from "lit";
import { html, literal } from "lit/static-html.js";
import { ifDefined } from "lit/directives/if-defined.js";
import { property } from "lit/decorators.js";
import cx from "classix";
var SdMapMarker = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.variant = "main";
    this.state = "default";
    this.animated = false;
    this.notInteractive = false;
    this.href = "";
    /** @internal */
    this.marker = {
      cluster: svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 50"><circle cx="25" cy="25" opacity="1" r="20"/><circle cx="25" cy="25" opacity=".3" r="25"/></svg>`,
      main: svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 60 75"><path d="M51 49A29 29 0 0 0 30 0 29 29 0 0 0 9 49l21 22 21-22Z"/><circle cx="30" cy="28" r="10" fill="#fff"/></svg>`,
      place: svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 60 75"><path fill-rule="evenodd" d="M51 49A29 29 0 0 0 30 0 29 29 0 0 0 9 49l21 22 21-22Z" clip-rule="evenodd"/></svg>`
    };
  }
  handleBlur() {
    this.emit("sd-blur");
  }
  handleFocus() {
    this.emit("sd-focus");
  }
  isLink() {
    return this.href ? true : false;
  }
  render() {
    const isLink = this.isLink();
    const tag = this.notInteractive ? literal`div` : isLink ? literal`a` : literal`button`;
    return html`<${tag} part="base" class="${cx(
      "flex justify-center",
      !this.notInteractive && "focus:outline focus:outline-2 focus:outline-primary focus:outline-offset-2"
    )}" href="${ifDefined(isLink ? this.href : void 0)}" target="${ifDefined(isLink ? this.target : void 0)}" @blur="${this.handleBlur}" @focus="${this.handleFocus}" role="${ifDefined(this.notInteractive || isLink ? void 0 : "button")}" aria-labelledby="${ifDefined(!this.notInteractive ? "content" : void 0)}"><div part="marker" class="${cx(
      "inline-flex",
      this.animated && (this.variant === "main" || this.variant === "place") && "animate-bounce-once",
      this.variant === "cluster" && this.state === "hover" && "scale-110 fill-primary-500",
      this.variant === "cluster" && !this.notInteractive && "transition-all duration-200 ease-in-out hover:scale-110 hover:fill-primary-500",
      this.variant === "main" && this.state === "hover" && "fill-accent-550",
      this.variant === "main" && this.state === "active" && "fill-accent-700",
      this.variant === "main" && !this.notInteractive && "hover:fill-accent-550 active:fill-accent-700",
      this.variant === "place" && this.state === "default" && "fill-white",
      this.variant === "place" && this.state === "hover" && "fill-primary-100",
      this.variant === "place" && this.state === "active" && "fill-primary-200",
      this.variant === "place" && !this.notInteractive && "hover:fill-primary-100",
      {
        cluster: "fill-primary",
        main: "fill-accent *:drop-shadow-md",
        place: "*:drop-shadow-md"
      }[this.variant]
    )}">${this.marker[this.variant]}</div><div id="content" part="content" class="${cx("absolute self-center pointer-events-none", this.variant === "cluster" && "font-bold text-white")}"><slot></slot></div></${tag}>`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdMapMarker.styles = [
  ...SolidElement.styles,
  css`:host{display:block}:host([variant=cluster]) [part=base],svg{width:calc(var(--sd-spacing-12,3rem)*var(--map-marker-scaling,1))}:host([variant=cluster]) [part=base]{height:calc(var(--sd-spacing-12,3rem)*var(--map-marker-scaling,1))}:host(:not([variant=cluster])) [part=base]{height:calc(var(--sd-spacing-16,4rem)*var(--map-marker-scaling,1))}:host([variant=cluster]) [part=content]{font-size:calc(var(--sd-font-size-sm,.875rem)*var(--map-marker-scaling,1))}:host([variant=place]) [part=content]{font-size:calc(var(--sd-font-size-3xl,2rem)*var(--map-marker-scaling,1))}`
];
__decorateClass([
  property({ reflect: true })
], SdMapMarker.prototype, "variant", 2);
__decorateClass([
  property({ reflect: true })
], SdMapMarker.prototype, "state", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdMapMarker.prototype, "animated", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "not-interactive" })
], SdMapMarker.prototype, "notInteractive", 2);
__decorateClass([
  property()
], SdMapMarker.prototype, "href", 2);
__decorateClass([
  property()
], SdMapMarker.prototype, "target", 2);
SdMapMarker = __decorateClass([
  customElement("sd-4-0-5-map-marker")
], SdMapMarker);

export {
  SdMapMarker
};
