import {
  defaultValue
} from "./chunk.GI7VDIWX.js";
import {
  FormControlController
} from "./chunk.KVKRZJS7.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/switch/switch.ts
import { css, html } from "lit";
import { ifDefined } from "lit/directives/if-defined.js";
import { live } from "lit/directives/live.js";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdSwitch = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.formControlController = new FormControlController(this, {
      value: (control) => control.checked ? control.value || "on" : void 0,
      defaultValue: (control) => control.defaultChecked,
      setValue: (control, checked) => control.checked = checked
    });
    this.showInvalidStyle = false;
    this.title = "";
    this.name = "";
    this.disabled = false;
    this.checked = false;
    this.defaultChecked = false;
    this.form = "";
    this.required = false;
  }
  /** Gets the validity state object */
  get validity() {
    return this.input.validity;
  }
  firstUpdated() {
    this.formControlController.updateValidity();
  }
  handleClick() {
    this.checked = !this.checked;
    this.emit("sd-change");
  }
  handleBlur() {
    this.emit("sd-blur");
  }
  handleInput() {
    this.emit("sd-input");
  }
  handleInvalid(event) {
    this.formControlController.setValidity(false);
    this.formControlController.emitInvalidEvent(event);
    this.invalidMessage.textContent = event.target.validationMessage;
  }
  handleFocus() {
    this.emit("sd-focus");
  }
  handleDisabledChange() {
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
    this.formControlController.setValidity(this.disabled);
  }
  handleStateChange() {
    this.input.checked = this.checked;
    this.formControlController.updateValidity();
  }
  /** Simulates a click on the switch. */
  click() {
    this.input.click();
  }
  /** Sets focus on the switch. */
  focus(options) {
    this.input.focus(options);
  }
  /** Removes focus from the switch. */
  blur() {
    this.input.blur();
  }
  /** Checks for validity but does not show a validation message. Returns true when valid and false when invalid. */
  checkValidity() {
    return this.input.checkValidity();
  }
  /** Gets the associated form, if one exists. */
  getForm() {
    return this.formControlController.getForm();
  }
  /** Checks for validity and shows a validation message if the control is invalid. */
  reportValidity() {
    return this.input.reportValidity();
  }
  /**
   * Sets a custom validation message. The value provided will be shown to the user when the form is submitted. To clear
   * the custom validation message, call this method with an empty string.
   */
  setCustomValidity(message) {
    this.input.setCustomValidity(message);
    this.formControlController.updateValidity();
  }
  render() {
    return html`<label part="base" class="${cx(
      "group flex items-center text-base leading-normal text-black cursor-pointer",
      this.disabled && "hover:cursor-not-allowed"
    )}"><input id="input" class="peer absolute opacity-0 p-0 m-0 pointer-events-none" type="checkbox" role="switch" title="${this.title}" name="${this.name}" value="${ifDefined(this.value)}" .checked="${live(this.checked)}" .disabled="${this.disabled}" .required="${this.required}" aria-checked="${this.checked ? "true" : "false"}" aria-invalid="${this.showInvalidStyle}" aria-describedby="invalid-message" @click="${this.handleClick}" @input="${this.handleInput}" @invalid="${this.handleInvalid}" @blur="${this.handleBlur}" @focus="${this.handleFocus}"> <span id="control" part="control ${this.checked ? " control--checked" : "control--unchecked"}" class="${cx(
      `relative flex flex-initial items-center justify-center border rounded-full h-4 w-8 transition-colors ease duration-100
            peer-focus-visible:outline peer-focus-visible:outline-2 peer-focus-visible:outline-offset-2
            peer-focus-visible:outline-primary`,
      this.disabled && this.checked ? "border-neutral-500 bg-neutral-500" : this.disabled ? "border-neutral-500" : this.showInvalidStyle ? "border-error bg-error hover:bg-error-400" : this.checked ? "border-accent bg-accent hover:bg-accent-550 group-hover:bg-accent-550" : "border-neutral-800 bg-white hover:bg-neutral-200 group-hover:bg-neutral-200"
    )}"><span id="thumb" part="thumb" class="${cx(
      "w-2.5 h-2.5 rounded-full transition-transform ease-in-out duration-200",
      this.disabled && this.checked ? "bg-white" : this.disabled ? "-translate-x-2 bg-neutral-500" : this.showInvalidStyle ? "bg-white -translate-x-2" : this.checked ? "translate-x-2 bg-white" : "bg-neutral-800 -translate-x-2"
    )}"></span> </span><span part="label" id="label" class="${cx(
      "select-none inline-block ml-2",
      this.disabled ? "text-neutral-500" : this.showInvalidStyle ? "text-error" : "text-black"
    )}"><slot></slot></span></label> ${this.formControlController.renderInvalidMessage()}`;
  }
};
/**
 * Inherits Tailwind classes and includes additional styling.
 */
SdSwitch.styles = [
  ...SolidElement.styles,
  css`:host{display:block;width:-moz-max-content;width:max-content}:host(:focus-visible){outline:2px solid transparent;outline-offset:2px}:host([required]) #label:after{content:" *"}`
];
__decorateClass([
  query("input")
], SdSwitch.prototype, "input", 2);
__decorateClass([
  query("#invalid-message")
], SdSwitch.prototype, "invalidMessage", 2);
__decorateClass([
  state()
], SdSwitch.prototype, "showInvalidStyle", 2);
__decorateClass([
  property()
], SdSwitch.prototype, "title", 2);
__decorateClass([
  property()
], SdSwitch.prototype, "name", 2);
__decorateClass([
  property()
], SdSwitch.prototype, "value", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdSwitch.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdSwitch.prototype, "checked", 2);
__decorateClass([
  defaultValue("checked")
], SdSwitch.prototype, "defaultChecked", 2);
__decorateClass([
  property({ reflect: true })
], SdSwitch.prototype, "form", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdSwitch.prototype, "required", 2);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdSwitch.prototype, "handleDisabledChange", 1);
__decorateClass([
  watch(["checked"], { waitUntilFirstUpdate: true })
], SdSwitch.prototype, "handleStateChange", 1);
SdSwitch = __decorateClass([
  customElement("sd-4-0-5-switch")
], SdSwitch);

export {
  SdSwitch
};
