import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/flipcard/flipcard.ts
import { css, html } from "lit";
import { ifDefined } from "lit/directives/if-defined.js";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdFlipcard = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.flipDirection = "horizontal";
    this.placement = "top";
    this.frontVariant = "primary";
    this.backVariant = "primary";
    this.activeSide = "front";
  }
  connectedCallback() {
    super.connectedCallback();
  }
  flipFront() {
    this.activeSide = "back";
    this.front.classList.add("clicked--front");
    this.back.classList.add("clicked--back");
    this.emit("sd-flip-front");
    setTimeout(() => {
      this.back.focus();
    });
  }
  flipBack() {
    this.activeSide = "front";
    this.front.classList.remove("clicked--front");
    this.back.classList.remove("clicked--back");
    this.emit("sd-flip-back");
    setTimeout(() => {
      this.front.focus();
    });
  }
  handleFrontKeydown(event) {
    if (event.code === "Enter" && this.front === event.target) {
      this.flipFront();
    }
  }
  handleBackKeydown(event) {
    if (event.code === "Enter" && this.back === event.target) {
      this.flipBack();
    }
  }
  render() {
    return html`<div part="base" class="${cx("flip-card relative h-full w-full")}"><div part="front" tabindex="0" aria-hidden="${this.activeSide === "back"}" inert="${ifDefined(this.activeSide === "back" || void 0)}" class="${cx(
      "flip-card__side flip-card__side--front overflow-hidden transition-transform duration-1000 ease-in-out",
      "flex focus-visible:focus-outline",
      "absolute top-0 left-0 w-full h-full justify-end text-left",
      this.frontVariant === "primary" && "bg-primary",
      this.frontVariant === "primary-100" && "bg-primary-100",
      this.placement === "top" ? "flex-col" : "flex-col-reverse",
      this.flipDirection === "vertical" && "vertical"
    )}"><div part="media-front" class="${cx(
      "absolute h-full w-full -z-20",
      (this.frontVariant === "primary" || this.frontVariant === "primary-100") && "hidden"
    )}"><slot name="media-front"></slot></div><div part="front-slot-container" class="${cx(
      "flex",
      {
        primary: "text-white",
        "primary-100": "text-black",
        "gradient-light": "text-black",
        "gradient-dark": "text-white"
      }[this.frontVariant],
      {
        primary: "",
        "primary-100": "",
        "gradient-light": this.placement === "top" ? "bg-gradient-to-b from-white/75 to-white/60" : "bg-gradient-to-t  from-white/75 to-white/60",
        "gradient-dark": this.placement === "bottom" ? "bg-gradient-to-t from-primary-800/75 to-primary-800/60" : "bg-gradient-to-b  from-primary-800/75 to-primary-800/60"
      }[this.frontVariant]
    )}"><slot name="front"></slot></div><div part="front-secondary-gradient" class="${cx(
      "flip-card__gradient",
      {
        primary: "mb-auto",
        "primary-100": "mb-auto",
        "gradient-light": this.placement === "top" ? "bg-gradient-to-b from-white/60 to-white/0 mb-auto" : "bg-gradient-to-t from-white/60 to-white/0 mt-auto",
        "gradient-dark": this.placement === "bottom" ? "bg-gradient-to-t from-primary-800/60 to-primary-800/0 mt-auto" : "bg-gradient-to-b from-primary-800/60 to-primary-800/0 mb-auto"
      }[this.frontVariant]
    )}"></div><sd-4-0-5-button part="front-button" size="md" variant="${{
      primary: "tertiary",
      "primary-100": "tertiary",
      "gradient-light": "primary",
      "gradient-dark": "primary"
    }[this.frontVariant]}" ?inverted="${{
      primary: true,
      "primary-100": false,
      "gradient-light": true,
      "gradient-dark": true
    }[this.frontVariant]}" class="${cx("absolute right-0 p-2 flex-shrink-0", this.placement === "top" ? "bottom-0" : "top-0")}" @click="${this.flipFront}" @keydown="${this.handleFrontKeydown}"><sd-4-0-5-icon library="system" name="reload" label="Flip to Back"></sd-4-0-5-icon></sd-4-0-5-button></div><div part="back" tabindex="0" aria-hidden="${this.activeSide === "front"}" inert="${ifDefined(this.activeSide === "front" || void 0)}" class="${cx(
      "flip-card__side flip-card__side--back overflow-hidden transition-transform duration-1000 ease-in-out",
      "flex focus-visible:focus-outline",
      "absolute top-0 left-0 w-full h-full justify-end text-left",
      this.backVariant === "primary" && "bg-primary",
      this.backVariant === "primary-100" && "bg-primary-100",
      this.placement === "top" ? "flex-col" : "flex-col-reverse",
      this.flipDirection === "vertical" && "vertical"
    )}"><div part="media-back" class="${cx(
      "absolute h-full w-full -z-20",
      (this.backVariant === "primary" || this.backVariant === "primary-100") && "hidden"
    )}"><slot name="media-back"></slot></div><div part="back-slot-container" class="${cx(
      "flex",
      {
        primary: "text-white",
        "primary-100": "text-black",
        "gradient-light": "text-black",
        "gradient-dark": "text-white"
      }[this.backVariant],
      {
        primary: "",
        "primary-100": "",
        "gradient-light": this.placement === "top" ? "bg-gradient-to-b from-white/75 to-white/60" : "bg-gradient-to-t  from-white/75 to-white/60",
        "gradient-dark": this.placement === "bottom" ? "bg-gradient-to-t from-primary-800/75 to-primary-800/60" : "bg-gradient-to-b  from-primary-800/75 to-primary-800/60"
      }[this.backVariant]
    )}"><slot name="back"></slot></div><div part="back-secondary-gradient" class="${cx(
      "flip-card__gradient",
      {
        primary: "mb-auto",
        "primary-100": "mb-auto",
        "gradient-light": this.placement === "top" ? "bg-gradient-to-b from-white/60 to-white/0 mb-auto" : "bg-gradient-to-t from-white/60 to-white/0 mt-auto",
        "gradient-dark": this.placement === "bottom" ? "bg-gradient-to-t from-primary-800/60 to-primary-800/0 mt-auto" : "bg-gradient-to-b from-primary-800/60 to-primary-800/0 mb-auto"
      }[this.backVariant]
    )}"></div><sd-4-0-5-button size="md" part="back-button" variant="${{
      primary: "tertiary",
      "primary-100": "tertiary",
      "gradient-light": "primary",
      "gradient-dark": "primary"
    }[this.backVariant]}" ?inverted="${{
      primary: true,
      "primary-100": false,
      "gradient-light": true,
      "gradient-dark": true
    }[this.backVariant]}" class="${cx("absolute right-0 p-2 flex-shrink-0", this.placement === "top" ? "bottom-0" : "top-0")}" @click="${this.flipBack}" @keydown="${this.handleBackKeydown}"><sd-4-0-5-icon library="system" name="reload" label="Flip to Front"></sd-4-0-5-icon></sd-4-0-5-button></div></div>`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdFlipcard.styles = [
  ...SolidElement.styles,
  css`:host{aspect-ratio:3/4;display:block;--name:"";--height:480px;height:var(--height)}.flip-card{perspective:100rem}.flip-card__side{backface-visibility:hidden}.flip-card__side--back{transform:rotateY(180deg)}.clicked--front{transform:rotateY(-180deg)}.clicked--back{transform:rotateY(0)}.flip-card__side--back.vertical{transform:rotateX(180deg)}.clicked--front.vertical{transform:rotateX(-180deg)}.clicked--back.vertical{transform:rotateX(0)}.flip-card__gradient{flex:.4 1 0}`
];
__decorateClass([
  query('[part="front"]')
], SdFlipcard.prototype, "front", 2);
__decorateClass([
  query('[part="back"]')
], SdFlipcard.prototype, "back", 2);
__decorateClass([
  property({ reflect: true, attribute: "flip-direction" })
], SdFlipcard.prototype, "flipDirection", 2);
__decorateClass([
  property({ reflect: true })
], SdFlipcard.prototype, "placement", 2);
__decorateClass([
  property({ type: String, reflect: true, attribute: "front-variant" })
], SdFlipcard.prototype, "frontVariant", 2);
__decorateClass([
  property({ type: String, reflect: true, attribute: "back-variant" })
], SdFlipcard.prototype, "backVariant", 2);
__decorateClass([
  state()
], SdFlipcard.prototype, "activeSide", 2);
SdFlipcard = __decorateClass([
  customElement("sd-4-0-5-flipcard")
], SdFlipcard);

export {
  SdFlipcard
};
