import {
  requestInclude
} from "./chunk.RPB53XXV.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/include/include.ts
import { css, html } from "lit";
import { property } from "lit/decorators.js";
var SdInclude = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.mode = "cors";
    this.allowScripts = false;
  }
  executeScript(script) {
    const newScript = document.createElement("script");
    [...script.attributes].forEach((attr) => newScript.setAttribute(attr.name, attr.value));
    newScript.textContent = script.textContent;
    script.parentNode.replaceChild(newScript, script);
  }
  async handleSrcChange() {
    try {
      const src = this.src;
      const file = await requestInclude(src, this.mode);
      if (src !== this.src) {
        return;
      }
      if (!file.ok) {
        this.emit("sd-error", { detail: { status: file.status } });
        return;
      }
      this.innerHTML = file.html;
      if (this.allowScripts) {
        [...this.querySelectorAll("script")].forEach((script) => this.executeScript(script));
      }
      this.emit("sd-load");
    } catch (e) {
      this.emit("sd-error", { detail: { status: -1 } });
    }
  }
  render() {
    return html`<slot></slot>`;
  }
};
SdInclude.styles = [
  ...SolidElement.styles,
  css`:host{display:block}`
];
__decorateClass([
  property()
], SdInclude.prototype, "src", 2);
__decorateClass([
  property()
], SdInclude.prototype, "mode", 2);
__decorateClass([
  property({ attribute: "allow-scripts", type: Boolean })
], SdInclude.prototype, "allowScripts", 2);
__decorateClass([
  watch("src")
], SdInclude.prototype, "handleSrcChange", 1);
SdInclude = __decorateClass([
  customElement("sd-4-0-5-include")
], SdInclude);

export {
  SdInclude
};
