import {
  defaultValue
} from "./chunk.GI7VDIWX.js";
import {
  FormControlController
} from "./chunk.KVKRZJS7.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass,
  __spreadValues
} from "./chunk.S3NI7NKU.js";

// src/components/input/input.ts
import { css, html } from "lit";
import { ifDefined } from "lit/directives/if-defined.js";
import { live } from "lit/directives/live.js";

// src/internal/longpress.ts
import { AsyncDirective, directive, PartType } from "lit/async-directive.js";
import { noChange, nothing } from "lit";
var LongPressDirective = class extends AsyncDirective {
  constructor(part) {
    super(part);
    this.handlePointerDown = (event) => {
      if (event.button !== 0 || this.host.disabled) {
        return;
      }
      this.spinOnLongPressCallback(event);
    };
    this.handlePointerUp = (pointerUp) => {
      pointerUp == null ? void 0 : pointerUp.preventDefault();
      pointerUp == null ? void 0 : pointerUp.stopPropagation();
      if (this.timeout) {
        this.callbacks.start();
      }
      this.stopSpinningAndCleanUp();
      this.callbacks.end();
      document.removeEventListener("pointerup", this.handlePointerUp);
    };
    if (part.type !== PartType.ELEMENT || !(part.element instanceof HTMLButtonElement)) {
      throw new Error("The `longPress` directive must be used on an HTMLButtonElement.");
    }
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  render(_callback) {
    return nothing;
  }
  update(part, [callbacks]) {
    if (this.callbacks === void 0 && this.host === void 0) {
      this.host = part.element;
      this.callbacks = __spreadValues({}, callbacks);
      this.host.addEventListener("pointerdown", this.handlePointerDown);
    }
    return noChange;
  }
  disconnected() {
    this.stopSpinningAndCleanUp();
    this.host.removeEventListener("pointerdown", this.handlePointerDown);
    document.removeEventListener("pointerup", this.handlePointerUp);
  }
  /**
   * Start spinning on long press clicks otherwise handle as single click event
   */
  spinOnLongPressCallback(event) {
    var _a2;
    event.preventDefault();
    event.stopPropagation();
    this.timeout = setTimeout(() => {
      this.timeout = void 0;
      this.interval = setInterval(() => {
        this.callbacks.start();
      }, 50);
    }, 500);
    document.addEventListener("pointerup", this.handlePointerUp);
    (_a2 = this.observer) == null ? void 0 : _a2.disconnect();
    this.observer = new MutationObserver((mutations) => {
      mutations.forEach((mutation) => {
        if (mutation.attributeName === "disabled") {
          this.stopSpinningAndCleanUp();
        }
      });
    });
    this.observer.observe(this.host, { attributes: true });
  }
  /**
   * Stop the spinning and clean up all timer and observer
   */
  stopSpinningAndCleanUp() {
    var _a2;
    clearInterval(this.interval);
    clearTimeout(this.timeout);
    (_a2 = this.observer) == null ? void 0 : _a2.disconnect();
  }
};
var longPress = directive(LongPressDirective);

// src/components/input/input.ts
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var _a;
var isChromium = (_a = navigator.userAgentData) == null ? void 0 : _a.brands.some((b) => b.brand.includes("Chromium"));
var isFirefox = isChromium ? false : navigator.userAgent.includes("Firefox");
var SdInput = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.formControlController = new FormControlController(this);
    this.hasSlotController = new HasSlotController(
      this,
      "help-text",
      "label",
      "left",
      "right",
      "message",
      "placeholder"
    );
    this.localize = new LocalizeController(this);
    this.hasFocus = false;
    this.showValidStyle = false;
    this.showInvalidStyle = false;
    this.type = "text";
    this.size = "lg";
    this.value = "";
    this.defaultValue = "";
    this.placeholder = "";
    this.label = "";
    this.helpText = "";
    this.clearable = false;
    this.disabled = false;
    this.readonly = false;
    this.passwordToggle = false;
    this.passwordVisible = false;
    this.spinButtons = false;
    this.form = "";
    this.name = "";
    this.title = "";
    this.required = false;
    this.styleOnValid = false;
    this.spellcheck = true;
  }
  /** Gets or sets the current value as a `Date` object. Returns `null` if the value can't be converted. */
  get valueAsDate() {
    var _a2, _b;
    return (_b = (_a2 = this.input) == null ? void 0 : _a2.valueAsDate) != null ? _b : null;
  }
  set valueAsDate(newValue) {
    const input = document.createElement("input");
    input.type = "date";
    input.valueAsDate = newValue;
    this.value = input.value;
  }
  /** Gets or sets the current value as a number. Returns `NaN` if the value can't be converted. */
  get valueAsNumber() {
    var _a2, _b;
    return (_b = (_a2 = this.input) == null ? void 0 : _a2.valueAsNumber) != null ? _b : parseFloat(this.value);
  }
  set valueAsNumber(newValue) {
    const input = document.createElement("input");
    input.type = "number";
    input.valueAsNumber = newValue;
    this.value = input.value;
  }
  /** Gets the validity state object */
  get validity() {
    return this.input.validity;
  }
  firstUpdated() {
    this.formControlController.updateValidity();
  }
  handleBlur() {
    this.hasFocus = false;
    this.emit("sd-blur");
  }
  handleChange() {
    this.value = this.input.value;
    this.emit("sd-change");
  }
  handleClearClick(event) {
    this.value = "";
    this.emit("sd-clear");
    this.emit("sd-input");
    this.emit("sd-change");
    this.input.focus();
    event.stopPropagation();
  }
  handleFocus() {
    this.hasFocus = true;
    this.emit("sd-focus");
  }
  handleInput() {
    this.value = this.input.value;
    this.formControlController.updateValidity();
    this.emit("sd-input");
  }
  handleInvalid(event) {
    this.formControlController.setValidity(false);
    this.formControlController.emitInvalidEvent(event);
    this.invalidMessage.textContent = event.target.validationMessage;
  }
  handleKeyDown(event) {
    const hasModifier = event.metaKey || event.ctrlKey || event.shiftKey || event.altKey;
    if (event.key === "Enter" && !hasModifier) {
      setTimeout(() => {
        if (!event.defaultPrevented && !event.isComposing) {
          this.formControlController.submit();
        }
      });
    }
  }
  handlePasswordToggle() {
    this.passwordVisible = !this.passwordVisible;
  }
  isDecrementDisabled() {
    if (this.disabled || this.readonly) {
      return true;
    }
    if (this.min === void 0 || this.min === null) {
      return false;
    }
    const min = typeof this.min === "string" ? parseFloat(this.min) : this.min;
    return this.valueAsNumber <= min;
  }
  isIncrementDisabled() {
    if (this.disabled || this.readonly) {
      return true;
    }
    if (this.max === void 0 || this.max === null) {
      return false;
    }
    const max = typeof this.max === "string" ? parseFloat(this.max) : this.max;
    return this.valueAsNumber >= max;
  }
  handleStep() {
    this.handleInput();
    this.input.focus();
  }
  handleStepUp() {
    this.stepUp();
    this.handleStep();
  }
  handleStepDown() {
    this.stepDown();
    this.handleStep();
  }
  handleDisabledChange() {
    this.formControlController.setValidity(this.disabled);
  }
  handleStepChange() {
    this.input.step = String(this.step);
    this.formControlController.updateValidity();
  }
  async handleValueChange() {
    await this.updateComplete;
    this.formControlController.updateValidity();
  }
  /** Sets focus on the input. */
  focus(options) {
    this.input.focus(options);
  }
  /** Removes focus from the input. */
  blur() {
    this.input.blur();
  }
  /** Selects all the text in the input. */
  select() {
    this.input.select();
  }
  /** Sets the start and end positions of the text selection (0-based). */
  setSelectionRange(selectionStart, selectionEnd, selectionDirection = "none") {
    this.input.setSelectionRange(selectionStart, selectionEnd, selectionDirection);
  }
  /** Replaces a range of text with a new string. */
  setRangeText(replacement, start, end, selectMode) {
    this.input.setRangeText(replacement, start, end, selectMode);
    if (this.value !== this.input.value) {
      this.value = this.input.value;
    }
  }
  /** Displays the browser picker for an input element (only works if the browser supports it for the input type). */
  showPicker() {
    if ("showPicker" in HTMLInputElement.prototype) {
      this.input.showPicker();
    }
  }
  /** Increments the value of a numeric input type by the value of the step attribute. */
  stepUp() {
    this.input.stepUp();
    if (this.value !== this.input.value) {
      this.value = this.input.value;
    }
  }
  /** Decrements the value of a numeric input type by the value of the step attribute. */
  stepDown() {
    this.input.stepDown();
    if (this.value !== this.input.value) {
      this.value = this.input.value;
    }
  }
  /** Checks for validity but does not show the browser's validation message. */
  checkValidity() {
    var _a2;
    return (_a2 = this.input) == null ? void 0 : _a2.checkValidity();
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  reportValidity() {
    this.formControlController.fakeUserInteraction();
    return this.input.reportValidity();
  }
  /** Sets a custom validation message. Pass an empty string to restore validity. */
  setCustomValidity(message) {
    this.input.setCustomValidity(message);
    this.formControlController.updateValidity();
  }
  render() {
    const slots = {
      label: this.hasSlotController.test("label"),
      helpText: this.hasSlotController.test("help-text"),
      description: this.hasSlotController.test("description"),
      left: this.hasSlotController.test("left"),
      right: this.hasSlotController.test("right")
    };
    const hasLabel = this.label ? true : !!slots["label"];
    const hasHelpText = this.helpText ? true : !!slots["helpText"];
    const hasClearIcon = this.clearable && !this.readonly && (typeof this.value === "number" || this.value.length > 0);
    const inputState = this.disabled ? "disabled" : this.readonly ? "readonly" : this.hasFocus && this.showInvalidStyle ? "activeInvalid" : this.hasFocus && this.styleOnValid && this.showValidStyle ? "activeValid" : this.hasFocus ? "active" : this.showInvalidStyle ? "invalid" : this.styleOnValid && this.showValidStyle ? "valid" : "default";
    const textSize = this.size === "sm" ? "text-sm" : "text-base";
    const borderColor = {
      disabled: "border-neutral-500",
      readonly: "border-neutral-800",
      activeInvalid: "border-error border-2",
      activeValid: "border-success border-2",
      active: "border-primary border-2",
      invalid: "border-error",
      valid: "border-success",
      default: "border-neutral-800"
    }[inputState];
    const iconColor = this.disabled ? "text-neutral-500" : "text-primary";
    const iconMarginLeft = { sm: "ml-1", md: "ml-2", lg: "ml-2" }[this.size];
    const iconSize = {
      sm: "text-base",
      md: "text-lg",
      lg: "text-xl"
    }[this.size];
    return html`<div part="form-control" class="${cx(this.disabled && "pointer-events-none")}"><div class="flex items-center gap-1 mb-2"><label part="form-control-label" id="label" class="${cx(hasLabel ? "inline-block" : "hidden", textSize)}" for="input" aria-hidden="${hasLabel ? "false" : "true"}"><slot name="label">${this.label}</slot></label><slot name="tooltip"></slot></div><div part="form-control-input" class="relative w-full"><div part="border" class="${cx("absolute w-full h-full pointer-events-none border rounded-default", borderColor)}"></div><div part="base" class="${cx(
      "px-4 flex flex-row items-center rounded-default transition-all",
      // Vertical Padding
      this.size === "lg" ? "py-2" : "py-1",
      // States
      !this.disabled && !this.readonly ? "hover:bg-neutral-200" : "",
      this.readonly ? "bg-neutral-100" : "bg-white",
      inputState === "disabled" ? "text-neutral-500" : "text-black"
    )}">${slots["left"] ? html`<slot name="left" part="left" class="${cx("inline-flex", this.size === "sm" ? "mr-1" : "mr-2", iconColor, iconSize)}"></slot>` : ""} <input part="input" id="input" class="${cx(
      "min-w-0 flex-grow focus:outline-none bg-transparent placeholder-neutral-700",
      this.size === "sm" ? "h-6" : "h-8",
      textSize
    )}" type="${this.type === "password" && this.passwordVisible ? "text" : this.type}" title="${this.title}" name="${ifDefined(this.name)}" ?disabled="${this.disabled}" ?readonly="${this.readonly}" ?required="${this.required}" placeholder="${ifDefined(this.placeholder)}" minlength="${ifDefined(this.minlength)}" maxlength="${ifDefined(this.maxlength)}" min="${ifDefined(this.min)}" max="${ifDefined(this.max)}" step="${ifDefined(this.step)}" .value="${live(this.value)}" autocapitalize="${ifDefined(this.type === "password" ? "off" : this.autocapitalize)}" autocomplete="${ifDefined(this.type === "password" ? "off" : this.autocomplete)}" autocorrect="${ifDefined(this.type === "password" ? "off" : this.autocorrect)}" ?autofocus="${this.autofocus}" spellcheck="${this.spellcheck}" pattern="${ifDefined(this.pattern)}" enterkeyhint="${ifDefined(this.enterkeyhint)}" inputmode="${ifDefined(this.inputmode)}" aria-describedby="help-text invalid-message" @change="${this.handleChange}" @input="${this.handleInput}" @invalid="${this.handleInvalid}" @keydown="${this.handleKeyDown}" @focus="${this.handleFocus}" @blur="${this.handleBlur}"> ${hasClearIcon ? html`<button part="clear-button" class="${cx("flex justify-center ", iconMarginLeft)}" type="button" aria-label="${this.localize.term("clearEntry")}" @click="${this.handleClearClick}" tabindex="-1"><slot name="clear-icon"><sd-4-0-5-icon class="${cx("icon-fill-neutral-800", iconSize)}" library="system" name="closing-round"></sd-4-0-5-icon></slot></button>` : ""} ${this.passwordToggle && this.type === "password" ? html`<button aria-label="${this.localize.term(this.passwordVisible ? "hidePassword" : "showPassword")}" part="password-toggle-button" class="flex items-center" type="button" @click="${this.handlePasswordToggle}" tabindex="-1">${this.passwordVisible ? html`<slot name="show-password-icon"><sd-4-0-5-icon class="${cx(iconColor, iconMarginLeft, iconSize)}" library="system" name="eye"></sd-4-0-5-icon></slot>` : html`<slot name="hide-password-icon"><sd-4-0-5-icon class="${cx(iconColor, iconMarginLeft, iconSize)}" library="system" name="eye-crossed-out"></sd-4-0-5-icon></slot>`}</button>` : ""} ${(this.type === "date" || this.type === "datetime-local") && !isFirefox ? html`<sd-4-0-5-icon class="${cx(iconColor, iconMarginLeft, iconSize)}" library="system" name="calendar"></sd-4-0-5-icon>` : ""} ${this.type === "time" ? html`<sd-4-0-5-icon class="${cx(iconColor, iconMarginLeft, iconSize)}" library="system" name="clock"></sd-4-0-5-icon>` : ""} ${this.type === "search" ? html`<button class="flex items-center" type="button" tabindex="-1"><sd-4-0-5-icon class="${cx(iconColor, iconMarginLeft, iconSize)}" library="system" name="magnifying-glass"></sd-4-0-5-icon></button>` : ""} ${this.showInvalidStyle ? html`<sd-4-0-5-icon part="invalid-icon" class="${cx("text-error", iconMarginLeft, iconSize)}" library="system" name="risk"></sd-4-0-5-icon>` : ""} ${this.showValidStyle && this.styleOnValid ? html`<sd-4-0-5-icon class="${cx("text-success flex-shrink-0", iconMarginLeft, iconSize)}" library="system" name="status-check" part="valid-icon"></sd-4-0-5-icon>` : ""} ${slots["right"] ? html`<slot name="right" part="right" class="${cx("inline-flex", iconColor, iconMarginLeft, iconSize)}"></slot>` : ""} ${this.type === "number" && this.spinButtons ? html`<div part="stepper" class="flex items-center"><button part="decrement-number-stepper" class="stepper-button flex" type="button" ?disabled="${this.isDecrementDisabled()}" aria-hidden="true" ${longPress({ start: () => this.handleStepDown(), end: () => this.handleChange() })} tabindex="-1"><slot name="decrement-number-stepper"><sd-4-0-5-icon name="system/minus-circle" label="Decrease value" class="${cx(iconColor, iconMarginLeft, iconSize)}"></sd-4-0-5-icon></slot></button> <button part="increment-number-stepper" class="stepper-button flex" type="button" ?disabled="${this.isIncrementDisabled()}" aria-hidden="true" ${longPress({ start: () => this.handleStepUp(), end: () => this.handleChange() })} tabindex="-1"><slot name="increment-number-stepper"><sd-4-0-5-icon name="system/plus-circle" label="Decrease value" class="${cx(iconColor, iconMarginLeft, iconSize)}"></sd-4-0-5-icon></slot></button></div>` : ""}</div></div><slot name="help-text" part="form-control-help-text" id="help-text" class="${cx("text-sm text-neutral-700", hasHelpText ? "block" : "hidden")}" aria-hidden="${!hasHelpText}">${this.helpText}</slot></div>${this.formControlController.renderInvalidMessage()}`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdInput.styles = [
  ...SolidElement.styles,
  css`:host{box-sizing:border-box;display:inline-block;position:relative;text-align:left;width:100%}:host([vertical]){display:block}:host([required]) #label:after{content:" *"}details summary::-webkit-details-marker{display:none}input::-webkit-inner-spin-button,input::-webkit-outer-spin-button{-webkit-appearance:none;margin:0}input[type=number]{-moz-appearance:textfield}input[type=time]::-webkit-calendar-picker-indicator{background:0 0}details summary::-webkit-details-marker,input[type=date]::-webkit-calendar-picker-indicator,input[type=datetime-local]::-webkit-calendar-picker-indicator,input[type=search]::-webkit-search-cancel-button,input[type=search]::-webkit-search-decoration,input[type=search]::-webkit-search-results-button,input[type=search]::-webkit-search-results-decoration{display:none}.stepper-button[disabled] sd-4-0-5-icon{--tw-text-opacity:1;color:rgb(var(--sd-color-neutral-500,174 174 174)/var(--tw-text-opacity,1))}`
];
__decorateClass([
  query("#input")
], SdInput.prototype, "input", 2);
__decorateClass([
  query("#invalid-message")
], SdInput.prototype, "invalidMessage", 2);
__decorateClass([
  state()
], SdInput.prototype, "hasFocus", 2);
__decorateClass([
  state()
], SdInput.prototype, "showValidStyle", 2);
__decorateClass([
  state()
], SdInput.prototype, "showInvalidStyle", 2);
__decorateClass([
  property({ reflect: true })
], SdInput.prototype, "type", 2);
__decorateClass([
  property({ reflect: true })
], SdInput.prototype, "size", 2);
__decorateClass([
  property()
], SdInput.prototype, "inputmode", 2);
__decorateClass([
  property()
], SdInput.prototype, "value", 2);
__decorateClass([
  defaultValue()
], SdInput.prototype, "defaultValue", 2);
__decorateClass([
  property()
], SdInput.prototype, "placeholder", 2);
__decorateClass([
  property()
], SdInput.prototype, "label", 2);
__decorateClass([
  property({ attribute: "help-text" })
], SdInput.prototype, "helpText", 2);
__decorateClass([
  property({ type: Boolean })
], SdInput.prototype, "clearable", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdInput.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdInput.prototype, "readonly", 2);
__decorateClass([
  property({ attribute: "password-toggle", type: Boolean })
], SdInput.prototype, "passwordToggle", 2);
__decorateClass([
  property({ attribute: "password-visible", type: Boolean })
], SdInput.prototype, "passwordVisible", 2);
__decorateClass([
  property({ attribute: "spin-buttons", type: Boolean })
], SdInput.prototype, "spinButtons", 2);
__decorateClass([
  property({ type: Number })
], SdInput.prototype, "minlength", 2);
__decorateClass([
  property({ type: Number })
], SdInput.prototype, "maxlength", 2);
__decorateClass([
  property()
], SdInput.prototype, "min", 2);
__decorateClass([
  property()
], SdInput.prototype, "max", 2);
__decorateClass([
  property({ reflect: true })
], SdInput.prototype, "form", 2);
__decorateClass([
  property()
], SdInput.prototype, "name", 2);
__decorateClass([
  property()
], SdInput.prototype, "title", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdInput.prototype, "required", 2);
__decorateClass([
  property()
], SdInput.prototype, "pattern", 2);
__decorateClass([
  property()
], SdInput.prototype, "step", 2);
__decorateClass([
  property()
], SdInput.prototype, "autocapitalize", 2);
__decorateClass([
  property()
], SdInput.prototype, "autocorrect", 2);
__decorateClass([
  property()
], SdInput.prototype, "autocomplete", 2);
__decorateClass([
  property({ type: Boolean })
], SdInput.prototype, "autofocus", 2);
__decorateClass([
  property()
], SdInput.prototype, "enterkeyhint", 2);
__decorateClass([
  property({ type: Boolean, reflect: true, attribute: "style-on-valid" })
], SdInput.prototype, "styleOnValid", 2);
__decorateClass([
  property({
    type: Boolean,
    converter: {
      // Allow "true|false" attribute values but keep the property boolean
      fromAttribute: (value) => !value || value === "false" ? false : true,
      toAttribute: (value) => value ? "true" : "false"
    }
  })
], SdInput.prototype, "spellcheck", 2);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdInput.prototype, "handleDisabledChange", 1);
__decorateClass([
  watch("step", { waitUntilFirstUpdate: true })
], SdInput.prototype, "handleStepChange", 1);
__decorateClass([
  watch("value", { waitUntilFirstUpdate: true })
], SdInput.prototype, "handleValueChange", 1);
SdInput = __decorateClass([
  customElement("sd-4-0-5-input")
], SdInput);

export {
  SdInput
};
