import {
  Modal
} from "./chunk.VBQLCQSN.js";
import {
  lockBodyScrolling,
  unlockBodyScrolling
} from "./chunk.WDWV53JP.js";
import {
  getAnimation,
  setDefaultAnimation
} from "./chunk.N4LHE3QK.js";
import {
  animateTo,
  stopAnimations
} from "./chunk.EY4JPJJQ.js";
import {
  waitForEvent
} from "./chunk.B4BZKR24.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  LocalizeController
} from "./chunk.YKM42GKF.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/drawer/drawer.ts
import { css, html } from "lit";
import { ifDefined } from "lit/directives/if-defined.js";
import { property, query } from "lit/decorators.js";

// src/internal/string.ts
function uppercaseFirstLetter(string) {
  return string.charAt(0).toUpperCase() + string.slice(1);
}

// src/components/drawer/drawer.ts
import cx from "classix";
var SdDrawer = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.hasSlotController = new HasSlotController(this, "footer");
    this.localize = new LocalizeController(this);
    this.modal = new Modal(this);
    this.open = false;
    this.label = "";
    this.placement = "end";
    this.contained = false;
    this.noHeader = false;
    this.handleDocumentKeyDown = (event) => {
      if (this.open && event.key === "Escape") {
        event.stopPropagation();
        this.requestClose("keyboard");
      }
    };
  }
  firstUpdated() {
    this.drawer.hidden = !this.open;
    if (this.open) {
      this.addOpenListeners();
      if (!this.contained) {
        this.modal.activate();
        lockBodyScrolling(this);
      }
    }
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    unlockBodyScrolling(this);
  }
  requestClose(source) {
    const slRequestClose = this.emit("sd-request-close", {
      cancelable: true,
      detail: { source }
    });
    if (slRequestClose.defaultPrevented) {
      const animation = getAnimation(this, "drawer.denyClose", { dir: this.localize.dir() });
      animateTo(this.panel, animation.keyframes, animation.options);
      return;
    }
    this.hide();
  }
  addOpenListeners() {
    document.addEventListener("keydown", this.handleDocumentKeyDown);
  }
  removeOpenListeners() {
    document.removeEventListener("keydown", this.handleDocumentKeyDown);
  }
  async handleOpenChange() {
    var _a;
    const closeButtonBase = (_a = this.closeButton.shadowRoot) == null ? void 0 : _a.querySelector('[part="base"]');
    if (this.open) {
      this.emit("sd-show");
      this.addOpenListeners();
      this.originalTrigger = document.activeElement;
      if (!this.contained) {
        this.modal.activate();
        lockBodyScrolling(this);
      }
      const autoFocusTarget = this.querySelector("[autofocus]");
      if (autoFocusTarget) {
        autoFocusTarget.removeAttribute("autofocus");
      }
      await Promise.all([stopAnimations(this.drawer), stopAnimations(this.overlay)]);
      this.drawer.hidden = false;
      requestAnimationFrame(() => {
        const sdInitialFocus = this.emit("sd-initial-focus", { cancelable: true });
        if (!sdInitialFocus.defaultPrevented) {
          if (autoFocusTarget) {
            autoFocusTarget.focus({ preventScroll: true });
          } else {
            this.panel.focus({ preventScroll: true });
          }
        }
        if (autoFocusTarget) {
          autoFocusTarget.setAttribute("autofocus", "");
        }
      });
      const panelAnimation = getAnimation(this, `drawer.show${uppercaseFirstLetter(this.placement)}`, {
        dir: this.localize.dir()
      });
      const overlayAnimation = getAnimation(this, "drawer.overlay.show", { dir: this.localize.dir() });
      await Promise.all([
        animateTo(this.panel, panelAnimation.keyframes, panelAnimation.options),
        animateTo(this.overlay, overlayAnimation.keyframes, overlayAnimation.options)
      ]);
      closeButtonBase == null ? void 0 : closeButtonBase.setAttribute("aria-controls", "drawer");
      closeButtonBase == null ? void 0 : closeButtonBase.setAttribute("aria-expanded", "true");
      this.emit("sd-after-show");
    } else {
      this.emit("sd-hide");
      this.removeOpenListeners();
      if (!this.contained) {
        this.modal.deactivate();
        unlockBodyScrolling(this);
      }
      await Promise.all([stopAnimations(this.drawer), stopAnimations(this.overlay)]);
      const panelAnimation = getAnimation(this, `drawer.hide${uppercaseFirstLetter(this.placement)}`, {
        dir: this.localize.dir()
      });
      const overlayAnimation = getAnimation(this, "drawer.overlay.hide", { dir: this.localize.dir() });
      await Promise.all([
        animateTo(this.overlay, overlayAnimation.keyframes, overlayAnimation.options).then(() => {
          this.overlay.hidden = true;
        }),
        animateTo(this.panel, panelAnimation.keyframes, panelAnimation.options).then(() => {
          this.panel.hidden = true;
        })
      ]);
      this.drawer.hidden = true;
      this.overlay.hidden = false;
      this.panel.hidden = false;
      const trigger = this.originalTrigger;
      if (typeof (trigger == null ? void 0 : trigger.focus) === "function") {
        setTimeout(() => trigger.focus());
      }
      closeButtonBase == null ? void 0 : closeButtonBase.setAttribute("aria-expanded", "false");
      this.emit("sd-after-hide");
    }
  }
  handleNoModalChange() {
    if (this.open && !this.contained) {
      this.modal.activate();
      lockBodyScrolling(this);
    }
    if (this.open && this.contained) {
      this.modal.deactivate();
      unlockBodyScrolling(this);
    }
  }
  /** Shows the drawer. */
  async show() {
    if (this.open) {
      return void 0;
    }
    this.open = true;
    return waitForEvent(this, "sd-after-show");
  }
  /** Hides the drawer */
  async hide() {
    if (!this.open) {
      return void 0;
    }
    this.open = false;
    return waitForEvent(this, "sd-after-hide");
  }
  render() {
    return html`<div id="drawer" part="base" class="${cx(
      "top-0 start-0 w-full h-full pointer-events-none overflow-hidden",
      this.contained ? "absolute" : "fixed"
    )}"><div part="overlay" class="${cx(
      "block top-0 left-0 right-0 bottom-0 bg-neutral-800/75 pointer-events-auto",
      this.contained ? "absolute" : "fixed"
    )}" @click="${() => this.requestClose("overlay")}" tabindex="-1"></div><div part="panel" class="${cx(
      "absolute flex flex-col z-10 max-w-full max-h-full bg-white shadow-lg overflow-auto pointer-events-auto focus:outline-none",
      {
        end: "top-0 end-0 bottom-auto start-auto w-[--width] h-full",
        start: "top-0 end-auto bottom-auto start-0 w-[--width] h-full"
      }[this.placement]
    )}" role="dialog" aria-modal="true" aria-hidden="${this.open ? "false" : "true"}" aria-label="${this.label}" aria-labelledby="${ifDefined(!this.noHeader ? "title" : void 0)}" tabindex="0">${!this.noHeader ? html`<header part="header" class="flex justify-between py-2 px-4 items-center flex-shrink-0" style="min-height:56px"><div part="title"><slot name="header" part="title" class="flex-auto text-xl m-0" id="title"></slot></div><div class="shrink-0 flex flex-wrap justify-end gap-1 ml-4 absolute top-2 right-2"><sd-4-0-5-button variant="tertiary" size="lg" part="close-button" @click="${() => this.requestClose("close-button")}"><sd-4-0-5-icon label="${this.localize.term("close")}" name="close" library="system"></sd-4-0-5-icon></sd-4-0-5-button></div></header>` : ""}<div part="body" class="flex-auto block px-4"><slot></slot></div><footer part="footer" class="${cx(this.hasSlotController.test("footer") ? "text-left p-4" : "hidden")}"><slot name="footer"></slot></footer></div></div>`;
  }
};
SdDrawer.styles = [
  ...SolidElement.styles,
  css`:host{--width:25rem;display:contents}:host([contained]){z-index:auto}:host(:not([contained])){z-index:var(--sd-z-index-drawer,700)}[part=body]{-webkit-overflow-scrolling:touch;overflow-y:scroll;scrollbar-width:none}[part=body]::-webkit-scrollbar{height:var(--sd-spacing-0,0);width:var(--sd-spacing-0,0)}`
];
__decorateClass([
  query("[part=base]")
], SdDrawer.prototype, "drawer", 2);
__decorateClass([
  query("[part=panel]")
], SdDrawer.prototype, "panel", 2);
__decorateClass([
  query("[part=overlay]")
], SdDrawer.prototype, "overlay", 2);
__decorateClass([
  query("[part=close-button]")
], SdDrawer.prototype, "closeButton", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdDrawer.prototype, "open", 2);
__decorateClass([
  property({ attribute: "label", reflect: true })
], SdDrawer.prototype, "label", 2);
__decorateClass([
  property({ reflect: true })
], SdDrawer.prototype, "placement", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdDrawer.prototype, "contained", 2);
__decorateClass([
  property({ attribute: "no-header", type: Boolean })
], SdDrawer.prototype, "noHeader", 2);
__decorateClass([
  watch("open", { waitUntilFirstUpdate: true })
], SdDrawer.prototype, "handleOpenChange", 1);
__decorateClass([
  watch("contained", { waitUntilFirstUpdate: true })
], SdDrawer.prototype, "handleNoModalChange", 1);
SdDrawer = __decorateClass([
  customElement("sd-4-0-5-drawer")
], SdDrawer);
setDefaultAnimation("drawer.showStart", {
  keyframes: [
    { opacity: 0, translate: "-100%" },
    { opacity: 1, translate: "0" }
  ],
  rtlKeyframes: [
    { opacity: 0, translate: "100%" },
    { opacity: 1, translate: "0" }
  ],
  options: { duration: 250, easing: "ease" }
});
setDefaultAnimation("drawer.hideStart", {
  keyframes: [
    { opacity: 1, translate: "0" },
    { opacity: 0, translate: "-100%" }
  ],
  rtlKeyframes: [
    { opacity: 1, translate: "0" },
    { opacity: 0, translate: "100%" }
  ],
  options: { duration: 250, easing: "ease" }
});
setDefaultAnimation("drawer.showEnd", {
  keyframes: [
    { opacity: 0, translate: "100%" },
    { opacity: 1, translate: "0" }
  ],
  rtlKeyframes: [
    { opacity: 0, translate: "-100%" },
    { opacity: 1, translate: "0" }
  ],
  options: { duration: 250, easing: "ease" }
});
setDefaultAnimation("drawer.hideEnd", {
  keyframes: [
    { opacity: 1, translate: "0" },
    { opacity: 0, translate: "100%" }
  ],
  rtlKeyframes: [
    { opacity: 1, translate: "0" },
    { opacity: 0, translate: "-100%" }
  ],
  options: { duration: 250, easing: "ease" }
});
setDefaultAnimation("drawer.denyClose", {
  keyframes: [{ scale: 1 }, { scale: 1.01 }, { scale: 1 }],
  options: { duration: 250 }
});
setDefaultAnimation("drawer.overlay.show", {
  keyframes: [{ opacity: 0 }, { opacity: 1 }],
  options: { duration: 250 }
});
setDefaultAnimation("drawer.overlay.hide", {
  keyframes: [{ opacity: 1 }, { opacity: 0 }],
  options: { duration: 250 }
});

export {
  SdDrawer
};
