import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/carousel-item/carousel-item.ts
import { css, html } from "lit";
var SdCarouselItem = class extends SolidElement {
  static isCarouselItem(node) {
    return node instanceof Element && node.getAttribute("aria-roledescription") === "slide";
  }
  connectedCallback() {
    super.connectedCallback();
    this.setAttribute("role", "group");
  }
  render() {
    return html`<slot></slot>`;
  }
};
SdCarouselItem.styles = [
  ...SolidElement.styles,
  css`:host{align-items:center;aspect-ratio:var(--aspect-ratio);display:flex;flex-direction:column;height:100%;justify-content:center;scroll-snap-align:start;scroll-snap-stop:always;width:100%}::slotted(img){height:100%;-o-object-fit:cover;object-fit:cover;width:100%}`
];
SdCarouselItem = __decorateClass([
  customElement("sd-4-0-5-carousel-item")
], SdCarouselItem);

export {
  SdCarouselItem
};
