import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/link/link.ts
import { css, html } from "lit";
import { ifDefined } from "lit/directives/if-defined.js";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdLink = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.hasSlotController = new HasSlotController(this, "[default]", "icon-left", "icon-right");
    this.standalone = false;
    this.size = "inherit";
    this.inverted = false;
    this.href = "";
  }
  handleBlur() {
    this.emit("sd-blur");
  }
  handleFocus() {
    this.emit("sd-focus");
  }
  /** Sets focus on the button. */
  focus(options) {
    this.button.focus(options);
  }
  /** Removes focus from the button. */
  blur() {
    this.button.blur();
  }
  render() {
    const slots = {
      label: this.hasSlotController.test("[default]"),
      "icon-left": this.hasSlotController.test("icon-left"),
      "icon-right": this.hasSlotController.test("icon-right")
    };
    return html`<a part="base" class="${cx(
      "inline",
      this.href ? "cursor-pointer" : "",
      {
        sm: "text-sm",
        lg: "text-base",
        inherit: ""
      }[this.size],
      {
        disabled: !this.inverted ? "text-neutral-500" : "text-neutral-600",
        enabled: !this.inverted ? ` text-primary hover:text-primary-500 active:text-primary-800 focus-visible:focus-outline` : `text-white hover:text-primary-200 active:text-primary-400 focus-visible:focus-outline-inverted`
      }[this.href ? "enabled" : "disabled"],
      this.standalone && "flex items-start"
    )}" href="${ifDefined(this.href || void 0)}" target="${ifDefined(this.target || void 0)}" download="${ifDefined(this.download)}" rel="${ifDefined(this.target ? "noreferrer noopener" : void 0)}" aria-disabled="${!this.href ? "true" : "false"}" tabindex="${!this.href ? "-1" : "0"}" @blur="${this.handleBlur}" @focus="${this.handleFocus}"><slot name="icon-left" part="icon-left" class="${cx(
      "inline",
      slots["icon-left"] && (!this.standalone ? "mr-[0.25em]" : {
        sm: "mr-1",
        lg: "mr-2",
        inherit: "mr-[0.5em]"
      }[this.size])
    )}"></slot><span part="label" class="inline underline underline-offset-2"><slot></slot></span><slot name="icon-right" part="icon-right" class="${cx(
      "inline",
      slots["icon-right"] && (!this.standalone ? "ml-[0.25em]" : {
        sm: "ml-1",
        lg: "ml-2",
        inherit: "ml-[0.5em]"
      }[this.size])
    )}"></slot></a>`;
  }
};
SdLink.styles = [
  ...SolidElement.styles,
  css`::slotted(sd-4-0-5-icon){font-size:1.25em;margin-bottom:-.25em}:host([size=sm][standalone]) ::slotted(sd-4-0-5-icon){font-size:var(--sd-font-size-base,1rem)}:host([size=lg][standalone]) ::slotted(sd-4-0-5-icon){font-size:var(--sd-font-size-xl,1.5rem)}`
];
__decorateClass([
  query("a")
], SdLink.prototype, "button", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdLink.prototype, "standalone", 2);
__decorateClass([
  property({ reflect: true })
], SdLink.prototype, "size", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdLink.prototype, "inverted", 2);
__decorateClass([
  property()
], SdLink.prototype, "href", 2);
__decorateClass([
  property()
], SdLink.prototype, "target", 2);
__decorateClass([
  property()
], SdLink.prototype, "download", 2);
SdLink = __decorateClass([
  customElement("sd-4-0-5-link")
], SdLink);

export {
  SdLink
};
