import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/radio-button/radio-button.ts
import { css, html } from "lit";
import { ifDefined } from "lit/directives/if-defined.js";
import { property, query, state } from "lit/decorators.js";
import cx from "classix";
var SdRadioButton = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.hasSlotController = new HasSlotController(this, "[default]", "icon");
    this.hasFocus = false;
    this.size = "lg";
    this.disabled = false;
    this.checked = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.setAttribute("role", "presentation");
  }
  handleBlur() {
    this.hasFocus = false;
    this.emit("sd-blur");
  }
  handleClick(e) {
    if (this.disabled) {
      e.preventDefault();
      e.stopPropagation();
      return;
    }
    this.checked = true;
  }
  handleFocus() {
    this.hasFocus = true;
    this.emit("sd-focus");
  }
  handleDisabledChange() {
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
  }
  /** Sets focus on the radio button. */
  focus(options) {
    this.input.focus(options);
  }
  /** Removes focus from the radio button. */
  blur() {
    this.input.blur();
  }
  render() {
    const hasDefaultSlot = this.hasSlotController.test("[default]");
    const hasIconSlot = this.hasSlotController.test("icon");
    const buttonSizeClass = `${this.size}-${hasDefaultSlot ? "label" : "no-label"}`;
    return html`<div part="base" role="presentation" class="relative"><button part="${`button${this.checked ? " button--checked" : ""}`}" role="radio" aria-checked="${this.checked}" class="${cx(
      "relative text-center border rounded-default transition-all ease-in-out duration-100 items-center justify-center focus-visible:focus-outline",
      this.size === "sm" ? "text-sm" : "text-base",
      this.checked && !this.disabled ? "bg-primary border-primary text-white hover:bg-primary-500 hover:border-primary-500" : this.disabled && !this.checked ? "border-neutral-500 text-neutral-500 hover:cursor-not-allowed" : this.disabled && this.checked ? "bg-neutral-500 border-neutral-500 text-white hover:cursor-not-allowed" : "bg-transparent text-primary border-primary hover:bg-primary-100 hover:border-primary-500 hover:text-primary-500 cursor-pointer",
      hasDefaultSlot && "px-4",
      this.hasFocus && "focused-class",
      hasDefaultSlot && "button--has-label",
      hasIconSlot && "button--has-icon flex gap-2",
      buttonSizeClass
    )}" aria-disabled="${this.disabled}" type="button" value="${ifDefined(this.value)}" tabindex="${this.checked ? "0" : "-1"}" @blur="${this.handleBlur}" @focus="${this.handleFocus}" @click="${this.handleClick}"><slot name="icon" part="icon" class="${cx(
      hasIconSlot && "inline-flex relative items-center",
      {
        sm: "text-base",
        md: "text-lg",
        lg: "text-xl"
      }[this.size]
    )}" ?hidden="${!hasIconSlot}"></slot>${hasDefaultSlot ? html`<slot part="label" class="button__label inline-flex relative items-center whitespace-nowrap"></slot>` : null}</button></div>`;
  }
};
SdRadioButton.styles = [
  ...SolidElement.styles,
  css`:host{display:block;width:-moz-min-content;width:min-content}.hidden-input{all:unset;inset:var(--sd-spacing-0,0);opacity:var(--sd-opacity-0,0);outline-color:rgb(var(--sd-color-error,204 25 55)/1);outline-style:dotted;outline-width:1px;position:absolute;z-index:-10}.lg-label,.lg-no-label{height:var(--sd-spacing-12,3rem)}.lg-no-label{width:var(--sd-spacing-12,3rem)}.md-label,.md-no-label{height:var(--sd-spacing-10,2.5rem)}.md-no-label{width:var(--sd-spacing-10,2.5rem)}.sm-label,.sm-no-label{height:var(--sd-spacing-8,2rem)}.sm-no-label{width:var(--sd-spacing-8,2rem)}:host(.sd-4-0-5-button-group__button--first:not(.sd-4-0-5-button-group__button--last)) button{border-bottom-right-radius:var(--sd-border-radius-none,0);border-top-right-radius:var(--sd-border-radius-none,0)}:host(.sd-4-0-5-button-group__button--inner) button{border-radius:var(--sd-border-radius-none,0)}:host(.sd-4-0-5-button-group__button--last:not(.sd-4-0-5-button-group__button--first)) button{border-bottom-left-radius:var(--sd-border-radius-none,0);border-top-left-radius:var(--sd-border-radius-none,0)}:host(.sd-4-0-5-button-group__button:not(.sd-4-0-5-button-group__button--first)){margin-inline-start:-1px}:host(.sd-4-0-5-button-group__button--hover){z-index:10}:host(.sd-4-0-5-button-group__button--focus),:host(.sd-4-0-5-button-group__button[checked]){z-index:20}`
];
__decorateClass([
  query(".button")
], SdRadioButton.prototype, "input", 2);
__decorateClass([
  query(".hidden-input")
], SdRadioButton.prototype, "hiddenInput", 2);
__decorateClass([
  state()
], SdRadioButton.prototype, "hasFocus", 2);
__decorateClass([
  property({ reflect: true })
], SdRadioButton.prototype, "size", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdRadioButton.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdRadioButton.prototype, "checked", 2);
__decorateClass([
  property()
], SdRadioButton.prototype, "value", 2);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdRadioButton.prototype, "handleDisabledChange", 1);
SdRadioButton = __decorateClass([
  customElement("sd-4-0-5-radio-button")
], SdRadioButton);

export {
  SdRadioButton
};
