import {
  SdDivider
} from "./chunk.AKF4KQEW.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/optgroup/optgroup.ts
import { css } from "lit";
import { html } from "lit/static-html.js";
import { property, query } from "lit/decorators.js";
import cx from "classix";
var SdOptgroup = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.disabled = false;
    this.label = "";
  }
  /**
   * Syncs the disabled prop for all slotted sd-4-0-5-options when it is triggered
   */
  handleDisableOptions() {
    const { disabled } = this;
    this.defaultSlot.assignedElements().filter((opt) => opt.tagName.toLowerCase() === "sd-4-0-5-option").forEach((opt) => {
      opt.disabled = disabled;
    });
  }
  handleDisabledChange() {
    this.handleDisableOptions();
  }
  render() {
    const { disabled } = this;
    return html`<div role="${disabled ? "presentation" : "group"}" class="${cx(this.disabled ? "text-neutral-500" : "")}" part="base" aria-labelledby="group-label"><sd-4-0-5-divider id="divider" class="pt-2 pb-4" part="divider"></sd-4-0-5-divider><div part="label-container" class="${cx(this.disabled ? "text-neutral-500" : "text-black")} px-4 font-bold text-left" role="presentation" id="group-label"><slot name="label"><span>${this.label}</span></slot></div><div role="group" part="options"><slot @slotchange="${this.handleDisableOptions}"></slot></div></div>`;
  }
};
SdOptgroup.dependencies = {
  "sd-4-0-5-divider": SdDivider
};
SdOptgroup.styles = [
  ...SolidElement.styles,
  css`:host{--display-divider:block}#divider{display:var(--display-divider)}`
];
__decorateClass([
  query("slot:not([name])")
], SdOptgroup.prototype, "defaultSlot", 2);
__decorateClass([
  property({ reflect: true, type: Boolean })
], SdOptgroup.prototype, "disabled", 2);
__decorateClass([
  property()
], SdOptgroup.prototype, "label", 2);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdOptgroup.prototype, "handleDisabledChange", 1);
SdOptgroup = __decorateClass([
  customElement("sd-4-0-5-optgroup")
], SdOptgroup);

export {
  SdOptgroup
};
