import {
  FormControlController,
  validValidityState
} from "./chunk.KVKRZJS7.js";
import {
  watch
} from "./chunk.X2OQMWGY.js";
import {
  HasSlotController
} from "./chunk.YEZS5ZR2.js";
import {
  SolidElement,
  customElement
} from "./chunk.HFHUY7YD.js";
import {
  __decorateClass
} from "./chunk.S3NI7NKU.js";

// src/components/button/button.ts
import { css } from "lit";
import { html, literal } from "lit/static-html.js";
import { ifDefined } from "lit/directives/if-defined.js";
import { property, query, queryAssignedElements, state } from "lit/decorators.js";
import cx from "classix";
var SdButton = class extends SolidElement {
  constructor() {
    super(...arguments);
    this.formControlController = new FormControlController(this, {
      form: (input) => {
        if (input.hasAttribute("form")) {
          const doc = input.getRootNode();
          const formId = input.getAttribute("form");
          return doc.getElementById(formId);
        }
        return input.closest("form");
      }
    });
    this.hasSlotController = new HasSlotController(this, "[default]", "icon-left", "icon-right");
    this.invalid = false;
    this.title = "";
    this.variant = "primary";
    this.inverted = false;
    this.size = "lg";
    this.disabled = false;
    this.loading = false;
    this.type = "button";
    this.name = "";
    this.value = "";
    this.href = "";
  }
  /** Gets the validity state object */
  get validity() {
    if (this.isButton()) {
      return this.button.validity;
    }
    return validValidityState;
  }
  /** Gets the validation message */
  get validationMessage() {
    if (this.isButton()) {
      return this.button.validationMessage;
    }
    return "";
  }
  firstUpdated() {
    if (this.isButton()) {
      this.formControlController.updateValidity();
    }
  }
  handleBlur() {
    this.emit("sd-blur");
  }
  handleFocus() {
    this.emit("sd-focus");
  }
  handleClick(event) {
    if (this.disabled || this.loading) {
      event.preventDefault();
      event.stopPropagation();
      return;
    }
    if (this.type === "submit") {
      this.formControlController.submit(this);
    }
    if (this.type === "reset") {
      this.formControlController.reset(this);
    }
  }
  handleInvalid(event) {
    this.formControlController.setValidity(false);
    this.formControlController.emitInvalidEvent(event);
  }
  isButton() {
    return this.href ? false : true;
  }
  isLink() {
    return this.href ? true : false;
  }
  handleDisabledChange() {
    if (this.isButton()) {
      this.formControlController.setValidity(this.disabled);
    }
  }
  /** Simulates a click on the button. */
  click() {
    this.button.click();
  }
  /** Sets focus on the button. */
  focus(options) {
    this.button.focus(options);
  }
  /** Removes focus from the button. */
  blur() {
    this.button.blur();
  }
  /** Checks for validity but does not show the browser's validation message. Returns `true` when valid and `false` when invalid. */
  checkValidity() {
    if (this.isButton()) {
      return this.button.checkValidity();
    }
    return true;
  }
  /** Gets the associated form, if one exists. */
  getForm() {
    return this.formControlController.getForm();
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  reportValidity() {
    if (this.isButton()) {
      return this.button.reportValidity();
    }
    return true;
  }
  /** Sets a custom validation message. Pass an empty string to restore validity. */
  setCustomValidity(message) {
    if (this.isButton()) {
      this.button.setCustomValidity(message);
      this.formControlController.updateValidity();
    }
  }
  render() {
    const isLink = this.isLink();
    const tag = isLink ? literal`a` : literal`button`;
    const slots = {
      label: this.hasSlotController.test("[default]"),
      "icon-left": this.hasSlotController.test("icon-left"),
      "icon-right": this.hasSlotController.test("icon-right"),
      "icon-only": this._iconsInDefaultSlot.length > 0
    };
    return html`<${tag} part="base" class="${cx(
      `font-md leading-[calc(var(--tw-varspacing)-2px)] no-underline
        w-full h-varspacing whitespace-nowrap align-middle inline-flex items-stretch justify-center
        border transition-colors duration-200 ease-in-out rounded-default
        select-none cursor-[inherit]`,
      !this.inverted ? "focus-visible:focus-outline" : "focus-visible:focus-outline-inverted",
      this.loading && "relative cursor-wait",
      this.disabled && "cursor-not-allowed",
      slots["icon-only"] && "px-0 w-varspacing",
      /**
       * Anatomy
       * */
      {
        /* sizes, fonts */
        sm: "text-sm varspacing-8 px-4",
        md: "text-base varspacing-10 px-4",
        lg: "text-base varspacing-12 px-4"
      }[this.size],
      {
        /* variants */
        primary: !this.inverted ? `text-white bg-primary border-transparent
          hover:text-primary-100 hover:bg-primary-500
          active:text-primary-200 active:bg-primary-800
          disabled:bg-neutral-500` : `text-primary bg-white border-transparent
          hover:text-primary-500 hover:bg-primary-100
          active:text-primary-800 active:bg-primary-200
          disabled:bg-neutral-600 disabled:text-white`,
        secondary: !this.inverted ? `text-primary border-primary
          hover:text-primary-500 hover:border-primary-500 hover:bg-primary-100
          active:text-primary-800 active:border-primary-800 active:bg-primary-200
          disabled:text-neutral-500 disabled:border-neutral-500` : `text-white border-white
          hover:text-primary-100 hover:bg-primary-500 hover:border-primary-100
          active:text-primary-200 active:bg-primary-800 active:border-primary-200
          disabled:text-neutral-600 disabled:border-neutral-600`,
        tertiary: !this.inverted ? `text-primary border-transparent
          hover:text-primary-500 hover:bg-primary-100
          active:text-primary-800 active:bg-primary-200
          disabled:text-neutral-500` : `text-white border-transparent
          hover:text-primary-100 hover:bg-primary-500
          active:text-primary-200 active:bg-primary-800
          disabled:text-neutral-600`,
        cta: `text-white bg-accent-500 border-transparent
          hover:bg-accent-550
          active:bg-accent-700
          ${!this.inverted ? "disabled:bg-neutral-500" : "disabled:bg-neutral-600"} disabled:text-white`
      }[this.variant]
    )}" ?disabled="${ifDefined(isLink ? void 0 : this.disabled)}" type="${ifDefined(isLink ? void 0 : this.type)}" title="${this.title}" name="${ifDefined(isLink ? void 0 : this.name)}" value="${ifDefined(isLink ? void 0 : this.value)}" href="${ifDefined(isLink ? this.href : void 0)}" target="${ifDefined(isLink ? this.target : void 0)}" download="${ifDefined(isLink ? this.download : void 0)}" rel="${ifDefined(isLink && this.target ? "noreferrer noopener" : void 0)}" role="${ifDefined(isLink ? void 0 : "button")}" aria-disabled="${this.disabled ? "true" : "false"}" aria-labelledby="content" tabindex="${this.disabled ? "-1" : "0"}" @blur="${this.handleBlur}" @focus="${this.handleFocus}" @invalid="${this.isButton() ? this.handleInvalid : null}" @click="${this.handleClick}"><slot name="icon-left" part="icon-left" class="${cx(
      "flex flex-auto items-center pointer-events-none",
      slots["icon-only"] && "hidden",
      this.loading && "invisible",
      slots["icon-left"] && {
        sm: "mr-1",
        md: "mr-2",
        lg: "mr-2"
      }[this.size]
    )}"></slot><slot part="label" id="content" class="${cx(
      slots["icon-only"] ? "flex flex-auto items-center pointer-events-none" : "inline-block",
      this.loading && "invisible"
    )}"></slot><slot name="icon-right" part="icon-right" class="${cx(
      "flex flex-auto items-center pointer-events-none",
      this.loading && "invisible",
      slots["icon-only"] && "hidden",
      slots["icon-right"] && {
        sm: "ml-1",
        md: "ml-2",
        lg: "ml-2"
      }[this.size]
    )}"></slot>${this.loading ? html`<sd-4-0-5-spinner class="${cx("absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2")}"></sd-4-0-5-spinner>` : ""}</${tag}>`;
  }
};
/**
 * Inherits global stylesheet including TailwindCSS
 */
SdButton.styles = [
  ...SolidElement.styles,
  css`:host{cursor:pointer;display:inline-block;position:relative;width:var(--sd-spacing-auto,auto)}sd-4-0-5-spinner{--indicator-color:currentColor;--track-color:var(--tw-varcolor-200)}::slotted(sd-4-0-5-badge){pointer-events:none;position:absolute;right:var(--sd-spacing-0,0);top:var(--sd-spacing-0,0);--tw-translate-x:50%!important;--tw-translate-y:-50%!important;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))!important}::slotted(sd-4-0-5-icon),sd-4-0-5-spinner{font-size:calc(var(--tw-varspacing)/2)}`
];
__decorateClass([
  query("a, button")
], SdButton.prototype, "button", 2);
__decorateClass([
  queryAssignedElements({ selector: "sd-4-0-5-icon" })
], SdButton.prototype, "_iconsInDefaultSlot", 2);
__decorateClass([
  state()
], SdButton.prototype, "invalid", 2);
__decorateClass([
  property()
], SdButton.prototype, "title", 2);
__decorateClass([
  property({ reflect: true })
], SdButton.prototype, "variant", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdButton.prototype, "inverted", 2);
__decorateClass([
  property({ reflect: true })
], SdButton.prototype, "size", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdButton.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean, reflect: true })
], SdButton.prototype, "loading", 2);
__decorateClass([
  property()
], SdButton.prototype, "type", 2);
__decorateClass([
  property()
], SdButton.prototype, "name", 2);
__decorateClass([
  property()
], SdButton.prototype, "value", 2);
__decorateClass([
  property()
], SdButton.prototype, "href", 2);
__decorateClass([
  property()
], SdButton.prototype, "target", 2);
__decorateClass([
  property()
], SdButton.prototype, "download", 2);
__decorateClass([
  property()
], SdButton.prototype, "form", 2);
__decorateClass([
  property({ attribute: "formaction" })
], SdButton.prototype, "formAction", 2);
__decorateClass([
  property({ attribute: "formenctype" })
], SdButton.prototype, "formEnctype", 2);
__decorateClass([
  property({ attribute: "formmethod" })
], SdButton.prototype, "formMethod", 2);
__decorateClass([
  property({ attribute: "formnovalidate", type: Boolean })
], SdButton.prototype, "formNoValidate", 2);
__decorateClass([
  property({ attribute: "formtarget" })
], SdButton.prototype, "formTarget", 2);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], SdButton.prototype, "handleDisabledChange", 1);
SdButton = __decorateClass([
  customElement("sd-4-0-5-button")
], SdButton);

export {
  SdButton
};
